/*
 * Decompiled with CFR 0.152.
 */
package de.captaingoldfish.scim.sdk.client.http;

import de.captaingoldfish.scim.sdk.client.exceptions.SslContextCreationFailedException;
import de.captaingoldfish.scim.sdk.client.keys.KeyStoreWrapper;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.util.Optional;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;

public final class SSLContextHelper {
    public static SSLContext getSslContext(KeyStoreWrapper mutualClientAuthenticationKeystoreList, KeyStoreWrapper truststore, String tlsVersion) {
        SSLContext sslContext;
        if (!(mutualClientAuthenticationKeystoreList != null && mutualClientAuthenticationKeystoreList.getKeyStore() != null || truststore != null && truststore.getKeyStore() != null)) {
            try {
                return SSLContext.getDefault();
            }
            catch (NoSuchAlgorithmException e) {
                throw new IllegalStateException("problem with default SSLContext. Has probably been tampered with.", e);
            }
        }
        try {
            sslContext = SSLContext.getInstance(Optional.ofNullable(tlsVersion).map(StringUtils::stripToNull).orElse("TLSv1.2"));
        }
        catch (NoSuchAlgorithmException e) {
            throw new SslContextCreationFailedException(e);
        }
        try {
            sslContext.init(SSLContextHelper.getKeyManagers(mutualClientAuthenticationKeystoreList), SSLContextHelper.getTrustmanager(truststore), null);
        }
        catch (KeyManagementException e) {
            throw new SslContextCreationFailedException(e);
        }
        return sslContext;
    }

    private static TrustManager[] getTrustmanager(KeyStoreWrapper truststore) {
        TrustManagerFactory trustManagerFactory;
        if (truststore == null || truststore.getKeyStore() == null) {
            return null;
        }
        try {
            trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            trustManagerFactory.init(truststore.getKeyStore());
        }
        catch (KeyStoreException | NoSuchAlgorithmException e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
        return trustManagerFactory.getTrustManagers();
    }

    private static KeyManager[] getKeyManagers(KeyStoreWrapper keyStoreAccessor) {
        KeyManagerFactory keyManagerFactory;
        KeyStoreWrapper mutualClientAuthKeystore = keyStoreAccessor;
        if (mutualClientAuthKeystore == null || mutualClientAuthKeystore.getKeyStore() == null) {
            return null;
        }
        try {
            keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        }
        catch (NoSuchAlgorithmException e) {
            throw new SslContextCreationFailedException(e);
        }
        try {
            keyManagerFactory.init(mutualClientAuthKeystore.getKeyStore(), mutualClientAuthKeystore.getKeystorePassword().toCharArray());
        }
        catch (KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException e) {
            throw new SslContextCreationFailedException("keystore could not be accessed", e);
        }
        return keyManagerFactory.getKeyManagers();
    }

    @Generated
    private SSLContextHelper() {
    }
}

