/*
 * Decompiled with CFR 0.152.
 */
package de.captaingoldfish.scim.sdk.client.builder.config;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import lombok.Generated;

public class MetaConfigRequestDetails {
    public static final List<String> DEFAULT_META_SCHEMA_URIS = Arrays.asList("urn:ietf:params:scim:schemas:core:2.0:Meta", "urn:ietf:params:scim:schemas:core:2.0:ServiceProviderConfig", "urn:ietf:params:scim:schemas:core:2.0:ResourceType", "urn:gold:params:scim:schemas:extension:url:2.0:ResourceTypeFeatures", "urn:ietf:params:scim:schemas:core:2.0:Schema");
    public static final List<String> DEFAULT_META_RESOURCE_TYPES_NAMES = Arrays.asList("ServiceProviderConfig", "ResourceType", "Schema");
    private final String serviceProviderEndpoint;
    private final String resourceTypeEndpoint;
    private final String schemasEndpoint;
    private final boolean excludeMetaSchemas;
    private final boolean excludeMetaResourceTypes;
    private final List<String> metaResourceTypeNames;
    private final List<String> metaSchemaUris;

    public MetaConfigRequestDetails() {
        this.serviceProviderEndpoint = "/ServiceProviderConfig";
        this.resourceTypeEndpoint = "/ResourceTypes";
        this.schemasEndpoint = "/Schemas";
        this.excludeMetaSchemas = false;
        this.excludeMetaResourceTypes = false;
        this.metaResourceTypeNames = DEFAULT_META_RESOURCE_TYPES_NAMES;
        this.metaSchemaUris = DEFAULT_META_SCHEMA_URIS;
    }

    public MetaConfigRequestDetails(String serviceProviderEndpoint, String resourceTypeEndpoint, String schemasEndpoint, boolean excludeMetaSchemas, boolean excludeMetaResourceTypes, List<String> metaSchemaUris, List<String> metaResourceTypeNames) {
        this.serviceProviderEndpoint = Optional.ofNullable(serviceProviderEndpoint).orElse("/ServiceProviderConfig");
        this.resourceTypeEndpoint = Optional.ofNullable(resourceTypeEndpoint).orElse("/ResourceTypes");
        this.schemasEndpoint = Optional.ofNullable(schemasEndpoint).orElse("/Schemas");
        this.excludeMetaSchemas = excludeMetaSchemas;
        this.excludeMetaResourceTypes = excludeMetaResourceTypes;
        this.metaSchemaUris = Optional.ofNullable(metaSchemaUris).orElse(DEFAULT_META_SCHEMA_URIS);
        this.metaResourceTypeNames = Optional.ofNullable(metaResourceTypeNames).orElse(DEFAULT_META_RESOURCE_TYPES_NAMES);
    }

    @Generated
    public static MetaConfigRequestDetailsBuilder builder() {
        return new MetaConfigRequestDetailsBuilder();
    }

    @Generated
    public String getServiceProviderEndpoint() {
        return this.serviceProviderEndpoint;
    }

    @Generated
    public String getResourceTypeEndpoint() {
        return this.resourceTypeEndpoint;
    }

    @Generated
    public String getSchemasEndpoint() {
        return this.schemasEndpoint;
    }

    @Generated
    public boolean isExcludeMetaSchemas() {
        return this.excludeMetaSchemas;
    }

    @Generated
    public boolean isExcludeMetaResourceTypes() {
        return this.excludeMetaResourceTypes;
    }

    @Generated
    public List<String> getMetaResourceTypeNames() {
        return this.metaResourceTypeNames;
    }

    @Generated
    public List<String> getMetaSchemaUris() {
        return this.metaSchemaUris;
    }

    @Generated
    public static class MetaConfigRequestDetailsBuilder {
        @Generated
        private String serviceProviderEndpoint;
        @Generated
        private String resourceTypeEndpoint;
        @Generated
        private String schemasEndpoint;
        @Generated
        private boolean excludeMetaSchemas;
        @Generated
        private boolean excludeMetaResourceTypes;
        @Generated
        private List<String> metaSchemaUris;
        @Generated
        private List<String> metaResourceTypeNames;

        @Generated
        MetaConfigRequestDetailsBuilder() {
        }

        @Generated
        public MetaConfigRequestDetailsBuilder serviceProviderEndpoint(String serviceProviderEndpoint) {
            this.serviceProviderEndpoint = serviceProviderEndpoint;
            return this;
        }

        @Generated
        public MetaConfigRequestDetailsBuilder resourceTypeEndpoint(String resourceTypeEndpoint) {
            this.resourceTypeEndpoint = resourceTypeEndpoint;
            return this;
        }

        @Generated
        public MetaConfigRequestDetailsBuilder schemasEndpoint(String schemasEndpoint) {
            this.schemasEndpoint = schemasEndpoint;
            return this;
        }

        @Generated
        public MetaConfigRequestDetailsBuilder excludeMetaSchemas(boolean excludeMetaSchemas) {
            this.excludeMetaSchemas = excludeMetaSchemas;
            return this;
        }

        @Generated
        public MetaConfigRequestDetailsBuilder excludeMetaResourceTypes(boolean excludeMetaResourceTypes) {
            this.excludeMetaResourceTypes = excludeMetaResourceTypes;
            return this;
        }

        @Generated
        public MetaConfigRequestDetailsBuilder metaSchemaUris(List<String> metaSchemaUris) {
            this.metaSchemaUris = metaSchemaUris;
            return this;
        }

        @Generated
        public MetaConfigRequestDetailsBuilder metaResourceTypeNames(List<String> metaResourceTypeNames) {
            this.metaResourceTypeNames = metaResourceTypeNames;
            return this;
        }

        @Generated
        public MetaConfigRequestDetails build() {
            return new MetaConfigRequestDetails(this.serviceProviderEndpoint, this.resourceTypeEndpoint, this.schemasEndpoint, this.excludeMetaSchemas, this.excludeMetaResourceTypes, this.metaSchemaUris, this.metaResourceTypeNames);
        }

        @Generated
        public String toString() {
            return "MetaConfigRequestDetails.MetaConfigRequestDetailsBuilder(serviceProviderEndpoint=" + this.serviceProviderEndpoint + ", resourceTypeEndpoint=" + this.resourceTypeEndpoint + ", schemasEndpoint=" + this.schemasEndpoint + ", excludeMetaSchemas=" + this.excludeMetaSchemas + ", excludeMetaResourceTypes=" + this.excludeMetaResourceTypes + ", metaSchemaUris=" + this.metaSchemaUris + ", metaResourceTypeNames=" + this.metaResourceTypeNames + ")";
        }
    }
}

