/*
 * Decompiled with CFR 0.152.
 */
package de.captaingoldfish.scim.sdk.client.builder;

import com.fasterxml.jackson.databind.JsonNode;
import de.captaingoldfish.scim.sdk.client.http.HttpResponse;
import de.captaingoldfish.scim.sdk.client.http.ScimHttpClient;
import de.captaingoldfish.scim.sdk.client.response.ServerResponse;
import de.captaingoldfish.scim.sdk.common.resources.base.ScimObjectNode;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import lombok.Generated;
import org.apache.http.client.methods.HttpUriRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RequestBuilder<T extends ScimObjectNode> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RequestBuilder.class);
    private final String baseUrl;
    private String endpoint;
    private String resource;
    private Class<T> responseEntityType;
    private ScimHttpClient scimHttpClient;
    private Map<String, String> requiredHttpHeaders;

    public RequestBuilder(String baseUrl, String endpoint, Class<T> responseEntityType, ScimHttpClient scimHttpClient) {
        this.baseUrl = baseUrl;
        this.endpoint = endpoint;
        this.responseEntityType = responseEntityType;
        this.scimHttpClient = scimHttpClient;
    }

    protected RequestBuilder<T> setResource(String resource) {
        this.resource = resource;
        return this;
    }

    protected RequestBuilder<T> setResource(JsonNode resource) {
        this.resource = resource.toString();
        return this;
    }

    protected abstract boolean isExpectedResponseCode(int var1);

    protected Function<HttpResponse, Boolean> isResponseParseable() {
        return httpResponse -> false;
    }

    public ServerResponse<T> sendRequest() {
        return this.sendRequestWithMultiHeaders(Collections.emptyMap());
    }

    public ServerResponse<T> sendRequestWithMultiHeaders(Map<String, String[]> httpHeaders) {
        HttpUriRequest request = this.getHttpUriRequest();
        request.setHeader("Content-Type", "application/scim+json");
        this.addHeaderToRequest(this.scimHttpClient.getScimClientConfig().getHttpHeaders(), httpHeaders, request);
        if (this.scimHttpClient.getScimClientConfig().getBasicAuth() != null) {
            request.setHeader("Authorization", this.scimHttpClient.getScimClientConfig().getBasicAuth().getAuthorizationHeaderValue());
        }
        HttpResponse response = this.scimHttpClient.sendRequest(request);
        return this.toResponse(response);
    }

    protected void addHeaderToRequest(Map<String, String[]> defaultHeaders, Map<String, String[]> preferredHeaders, HttpUriRequest request) {
        Consumer<Map> addHeaders = headerMap -> {
            if (headerMap == null) {
                return;
            }
            headerMap.forEach((key, values) -> {
                request.removeHeaders(key);
                for (String value : values) {
                    request.addHeader(key, value);
                }
            });
        };
        addHeaders.accept(defaultHeaders);
        addHeaders.accept(preferredHeaders);
    }

    public ServerResponse<T> sendRequest(Map<String, String> headers) {
        HashMap<String, String[]> multiHeader = new HashMap<String, String[]>();
        headers.forEach((key, value) -> multiHeader.put((String)key, new String[]{value}));
        return this.sendRequestWithMultiHeaders(multiHeader);
    }

    protected ServerResponse<T> toResponse(HttpResponse response) {
        return new ServerResponse<T>(response, this.isExpectedResponseCode(response.getHttpStatusCode()), this.responseEntityType, this.isResponseParseable(), this.getRequiredResponseHeaders());
    }

    protected Map<String, String> getRequiredResponseHeaders() {
        if (this.requiredHttpHeaders != null) {
            return this.requiredHttpHeaders;
        }
        if (this.scimHttpClient.getScimClientConfig().getExpectedHttpResponseHeaders() != null) {
            return this.scimHttpClient.getScimClientConfig().getExpectedHttpResponseHeaders();
        }
        HashMap<String, String> requiredHttpHeaders = new HashMap<String, String>();
        requiredHttpHeaders.put("Content-Type", "application/scim+json");
        return requiredHttpHeaders;
    }

    protected RequestBuilder<T> setExpectedResponseHeaders(Map<String, String> requiredResponseHeaders) {
        this.requiredHttpHeaders = requiredResponseHeaders;
        return this;
    }

    protected abstract HttpUriRequest getHttpUriRequest();

    @Generated
    protected String getBaseUrl() {
        return this.baseUrl;
    }

    @Generated
    protected String getEndpoint() {
        return this.endpoint;
    }

    @Generated
    public String getResource() {
        return this.resource;
    }

    @Generated
    protected Class<T> getResponseEntityType() {
        return this.responseEntityType;
    }

    @Generated
    protected ScimHttpClient getScimHttpClient() {
        return this.scimHttpClient;
    }

    @Generated
    public Map<String, String> getRequiredHttpHeaders() {
        return this.requiredHttpHeaders;
    }
}

