/*
 * Decompiled with CFR 0.152.
 */
package de.captaingoldfish.scim.sdk.client.builder;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import de.captaingoldfish.scim.sdk.client.ScimClientConfig;
import de.captaingoldfish.scim.sdk.client.builder.RequestBuilder;
import de.captaingoldfish.scim.sdk.client.http.HttpResponse;
import de.captaingoldfish.scim.sdk.client.http.ScimHttpClient;
import de.captaingoldfish.scim.sdk.client.response.ServerResponse;
import de.captaingoldfish.scim.sdk.common.constants.enums.Comparator;
import de.captaingoldfish.scim.sdk.common.constants.enums.SortOrder;
import de.captaingoldfish.scim.sdk.common.request.SearchRequest;
import de.captaingoldfish.scim.sdk.common.resources.ResourceNode;
import de.captaingoldfish.scim.sdk.common.resources.base.ScimObjectNode;
import de.captaingoldfish.scim.sdk.common.response.ListResponse;
import de.captaingoldfish.scim.sdk.common.utils.EncodingUtils;
import de.captaingoldfish.scim.sdk.common.utils.JsonHelper;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ListBuilder<T extends ResourceNode> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ListBuilder.class);
    private final String baseUrl;
    private final String endpoint;
    private final Class<T> responseEntityType;
    private final Map<String, String> requestParameters = new HashMap<String, String>();
    private final ScimHttpClient scimHttpClient;
    private final String fullUrl;

    public ListBuilder(String fullUrl, Class<T> responseEntityType, ScimHttpClient scimHttpClient) {
        this.baseUrl = null;
        this.endpoint = null;
        this.responseEntityType = responseEntityType;
        this.scimHttpClient = scimHttpClient;
        this.fullUrl = fullUrl;
    }

    public ListBuilder(String baseUrl, String endpoint, Class<T> responseEntityType, ScimHttpClient scimHttpClient) {
        this.baseUrl = baseUrl;
        this.endpoint = endpoint;
        this.responseEntityType = responseEntityType;
        this.scimHttpClient = scimHttpClient;
        this.fullUrl = null;
    }

    public ListBuilder<T> count(int count) {
        this.requestParameters.put("count", String.valueOf(count));
        return this;
    }

    public ListBuilder<T> startIndex(long startIndex) {
        this.requestParameters.put("startIndex", String.valueOf(startIndex));
        return this;
    }

    public ListBuilder<T> sortBy(String sortBy) {
        this.requestParameters.put("sortBy", sortBy);
        return this;
    }

    public ListBuilder<T> sortOrder(SortOrder sortOrder) {
        this.requestParameters.put("sortOrder", sortOrder.name().toLowerCase());
        return this;
    }

    public ListBuilder<T> attributes(String ... attributeNames) {
        if (attributeNames != null) {
            this.requestParameters.put("attributes", String.join((CharSequence)",", attributeNames));
        }
        return this;
    }

    public ListBuilder<T> excludedAttributes(String ... attributeNames) {
        if (attributeNames != null) {
            this.requestParameters.put("excludedAttributes", String.join((CharSequence)",", attributeNames));
        }
        return this;
    }

    public FilterBuilder<T> filter() {
        return new FilterBuilder(this);
    }

    public FilterBuilder<T> filter(String attributeName, Comparator comparator, String value) {
        return this.filter(false, attributeName, comparator, value);
    }

    public FilterBuilder<T> filter(boolean openParanthesis, String attributeName, Comparator comparator, String value) {
        return new FilterBuilder(this, attributeName, comparator, value, openParanthesis);
    }

    public ListBuilder<T> filter(String filter) {
        this.requestParameters.put("filter", filter);
        return this;
    }

    public ListBuilder<T> custom(String attributeName, String attribute) {
        this.requestParameters.put(attributeName, attribute);
        return this;
    }

    public GetRequestBuilder<T> get() {
        return new GetRequestBuilder(this);
    }

    public PostRequestBuilder<T> post() {
        return new PostRequestBuilder(this);
    }

    @Generated
    protected Map<String, String> getRequestParameters() {
        return this.requestParameters;
    }

    public class FilterBuilder<T extends ResourceNode> {
        private final ListBuilder<T> listBuilder;
        private final StringBuilder filterString = new StringBuilder();
        private int openedParenthesis = 0;
        private int closedParenthesis = 0;

        public FilterBuilder(ListBuilder<T> listBuilder) {
            this.listBuilder = listBuilder;
        }

        public FilterBuilder(ListBuilder<T> listBuilder, String attributeName, Comparator comparator, String value, boolean openParenthesis) {
            this.listBuilder = listBuilder;
            this.openParenthesis(openParenthesis);
            this.setExpression(attributeName, comparator, value);
        }

        private FilterBuilder<T> openParenthesis(boolean openParenthesis) {
            if (openParenthesis) {
                ++this.openedParenthesis;
                this.filterString.append("(");
            }
            return this;
        }

        public FilterBuilder<T> closeParenthesis() {
            ++this.closedParenthesis;
            this.filterString.append(")");
            return this;
        }

        private FilterBuilder<T> closeParenthesis(boolean closeParenthesis) {
            if (closeParenthesis) {
                return this.closeParenthesis();
            }
            return this;
        }

        public FilterBuilder<T> and(String attributeName, Comparator comparator, String value) {
            return this.and(false, attributeName, comparator, value);
        }

        public FilterBuilder<T> or(String attributeName, Comparator comparator, String value) {
            return this.or(false, attributeName, comparator, value);
        }

        public FilterBuilder<T> and(String attributeName, Comparator comparator, Boolean value) {
            return this.and(false, attributeName, comparator, value);
        }

        public FilterBuilder<T> or(String attributeName, Comparator comparator, Boolean value) {
            return this.or(false, attributeName, comparator, value);
        }

        public FilterBuilder<T> and(String attributeName, Comparator comparator, Integer value) {
            return this.and(false, attributeName, comparator, value);
        }

        public FilterBuilder<T> or(String attributeName, Comparator comparator, Integer value) {
            return this.or(false, attributeName, comparator, value);
        }

        public FilterBuilder<T> and(String attributeName, Comparator comparator, Long value) {
            return this.and(false, attributeName, comparator, value);
        }

        public FilterBuilder<T> or(String attributeName, Comparator comparator, Long value) {
            return this.or(false, attributeName, comparator, value);
        }

        public FilterBuilder<T> and(String attributeName, Comparator comparator, Double value) {
            return this.and(false, attributeName, comparator, value);
        }

        public FilterBuilder<T> or(String attributeName, Comparator comparator, Double value) {
            return this.or(false, attributeName, comparator, value);
        }

        public FilterBuilder<T> and(String attributeName, Comparator comparator, Instant value) {
            return this.and(false, attributeName, comparator, value);
        }

        public FilterBuilder<T> or(String attributeName, Comparator comparator, Instant value) {
            return this.or(false, attributeName, comparator, value);
        }

        public FilterBuilder<T> and(boolean openParenthesis, String attributeName, Comparator comparator, String value) {
            return this.and(openParenthesis, attributeName, comparator, value, false);
        }

        public FilterBuilder<T> or(boolean openParenthesis, String attributeName, Comparator comparator, String value) {
            return this.or(openParenthesis, attributeName, comparator, value, false);
        }

        public FilterBuilder<T> and(boolean openParenthesis, String attributeName, Comparator comparator, Boolean value) {
            return this.and(openParenthesis, attributeName, comparator, value, false);
        }

        public FilterBuilder<T> or(boolean openParenthesis, String attributeName, Comparator comparator, Boolean value) {
            return this.or(openParenthesis, attributeName, comparator, value, false);
        }

        public FilterBuilder<T> and(boolean openParenthesis, String attributeName, Comparator comparator, Integer value) {
            return this.and(openParenthesis, attributeName, comparator, value, false);
        }

        public FilterBuilder<T> or(boolean openParenthesis, String attributeName, Comparator comparator, Integer value) {
            return this.or(openParenthesis, attributeName, comparator, value, false);
        }

        public FilterBuilder<T> and(boolean openParenthesis, String attributeName, Comparator comparator, Long value) {
            return this.and(openParenthesis, attributeName, comparator, value, false);
        }

        public FilterBuilder<T> or(boolean openParenthesis, String attributeName, Comparator comparator, Long value) {
            return this.or(openParenthesis, attributeName, comparator, value, false);
        }

        public FilterBuilder<T> and(boolean openParenthesis, String attributeName, Comparator comparator, Double value) {
            return this.and(openParenthesis, attributeName, comparator, value, false);
        }

        public FilterBuilder<T> or(boolean openParenthesis, String attributeName, Comparator comparator, Double value) {
            return this.or(openParenthesis, attributeName, comparator, value, false);
        }

        public FilterBuilder<T> and(boolean openParenthesis, String attributeName, Comparator comparator, Instant value) {
            return this.and(openParenthesis, attributeName, comparator, value, false);
        }

        public FilterBuilder<T> or(boolean openParenthesis, String attributeName, Comparator comparator, Instant value) {
            return this.or(openParenthesis, attributeName, comparator, value, false);
        }

        public FilterBuilder<T> and(String attributeName, Comparator comparator, String value, boolean closeParenthesis) {
            return this.and(false, attributeName, comparator, value, closeParenthesis);
        }

        public FilterBuilder<T> or(String attributeName, Comparator comparator, String value, boolean closeParenthesis) {
            return this.or(false, attributeName, comparator, value, closeParenthesis);
        }

        public FilterBuilder<T> and(String attributeName, Comparator comparator, Boolean value, boolean closeParenthesis) {
            return this.and(false, attributeName, comparator, value, closeParenthesis);
        }

        public FilterBuilder<T> or(String attributeName, Comparator comparator, Boolean value, boolean closeParenthesis) {
            return this.or(false, attributeName, comparator, value, closeParenthesis);
        }

        public FilterBuilder<T> and(String attributeName, Comparator comparator, Integer value, boolean closeParenthesis) {
            return this.and(false, attributeName, comparator, value, closeParenthesis);
        }

        public FilterBuilder<T> or(String attributeName, Comparator comparator, Integer value, boolean closeParenthesis) {
            return this.or(false, attributeName, comparator, value, closeParenthesis);
        }

        public FilterBuilder<T> and(String attributeName, Comparator comparator, Long value, boolean closeParenthesis) {
            return this.and(false, attributeName, comparator, value, closeParenthesis);
        }

        public FilterBuilder<T> or(String attributeName, Comparator comparator, Long value, boolean closeParenthesis) {
            return this.or(false, attributeName, comparator, value, closeParenthesis);
        }

        public FilterBuilder<T> and(String attributeName, Comparator comparator, Double value, boolean closeParenthesis) {
            return this.and(false, attributeName, comparator, value, closeParenthesis);
        }

        public FilterBuilder<T> or(String attributeName, Comparator comparator, Double value, boolean closeParenthesis) {
            return this.or(false, attributeName, comparator, value, closeParenthesis);
        }

        public FilterBuilder<T> and(String attributeName, Comparator comparator, Instant value, boolean closeParenthesis) {
            return this.and(false, attributeName, comparator, value, closeParenthesis);
        }

        public FilterBuilder<T> or(String attributeName, Comparator comparator, Instant value, boolean closeParenthesis) {
            return this.or(false, attributeName, comparator, value, closeParenthesis);
        }

        public FilterBuilder<T> and(boolean openParenthesis, String attributeName, Comparator comparator, String value, boolean closeParenthesis) {
            if (this.filterString.length() != 0) {
                this.filterString.append(" and ");
            }
            this.openParenthesis(openParenthesis);
            this.setExpression(attributeName, comparator, value);
            this.closeParenthesis(closeParenthesis);
            return this;
        }

        public FilterBuilder<T> or(boolean openParenthesis, String attributeName, Comparator comparator, String value, boolean closeParenthesis) {
            if (this.filterString.length() != 0) {
                this.filterString.append(" or ");
            }
            this.openParenthesis(openParenthesis);
            this.setExpression(attributeName, comparator, value);
            this.closeParenthesis(closeParenthesis);
            return this;
        }

        public FilterBuilder<T> and(boolean openParenthesis, String attributeName, Comparator comparator, Boolean value, boolean closeParenthesis) {
            if (this.filterString.length() != 0) {
                this.filterString.append(" and ");
            }
            this.openParenthesis(openParenthesis);
            this.setExpression(attributeName, comparator, value);
            this.closeParenthesis(closeParenthesis);
            return this;
        }

        public FilterBuilder<T> or(boolean openParenthesis, String attributeName, Comparator comparator, Boolean value, boolean closeParenthesis) {
            if (this.filterString.length() != 0) {
                this.filterString.append(" or ");
            }
            this.openParenthesis(openParenthesis);
            this.setExpression(attributeName, comparator, value);
            this.closeParenthesis(closeParenthesis);
            return this;
        }

        public FilterBuilder<T> and(boolean openParenthesis, String attributeName, Comparator comparator, Integer value, boolean closeParenthesis) {
            if (this.filterString.length() != 0) {
                this.filterString.append(" and ");
            }
            this.openParenthesis(openParenthesis);
            this.setExpression(attributeName, comparator, value);
            this.closeParenthesis(closeParenthesis);
            return this;
        }

        public FilterBuilder<T> or(boolean openParenthesis, String attributeName, Comparator comparator, Integer value, boolean closeParenthesis) {
            if (this.filterString.length() != 0) {
                this.filterString.append(" or ");
            }
            this.openParenthesis(openParenthesis);
            this.setExpression(attributeName, comparator, value);
            this.closeParenthesis(closeParenthesis);
            return this;
        }

        public FilterBuilder<T> and(boolean openParenthesis, String attributeName, Comparator comparator, Long value, boolean closeParenthesis) {
            if (this.filterString.length() != 0) {
                this.filterString.append(" and ");
            }
            this.openParenthesis(openParenthesis);
            this.setExpression(attributeName, comparator, value);
            this.closeParenthesis(closeParenthesis);
            return this;
        }

        public FilterBuilder<T> or(boolean openParenthesis, String attributeName, Comparator comparator, Long value, boolean closeParenthesis) {
            if (this.filterString.length() != 0) {
                this.filterString.append(" or ");
            }
            this.openParenthesis(openParenthesis);
            this.setExpression(attributeName, comparator, value);
            this.closeParenthesis(closeParenthesis);
            return this;
        }

        public FilterBuilder<T> and(boolean openParenthesis, String attributeName, Comparator comparator, Double value, boolean closeParenthesis) {
            if (this.filterString.length() != 0) {
                this.filterString.append(" and ");
            }
            this.openParenthesis(openParenthesis);
            this.setExpression(attributeName, comparator, value);
            this.closeParenthesis(closeParenthesis);
            return this;
        }

        public FilterBuilder<T> or(boolean openParenthesis, String attributeName, Comparator comparator, Double value, boolean closeParenthesis) {
            if (this.filterString.length() != 0) {
                this.filterString.append(" or ");
            }
            this.openParenthesis(openParenthesis);
            this.setExpression(attributeName, comparator, value);
            this.closeParenthesis(closeParenthesis);
            return this;
        }

        public FilterBuilder<T> and(boolean openParenthesis, String attributeName, Comparator comparator, Instant value, boolean closeParenthesis) {
            if (this.filterString.length() != 0) {
                this.filterString.append(" and ");
            }
            this.openParenthesis(openParenthesis);
            this.setExpression(attributeName, comparator, value.toString());
            this.closeParenthesis(closeParenthesis);
            return this;
        }

        public FilterBuilder<T> or(boolean openParenthesis, String attributeName, Comparator comparator, Instant value, boolean closeParenthesis) {
            if (this.filterString.length() != 0) {
                this.filterString.append(" or ");
            }
            this.openParenthesis(openParenthesis);
            this.setExpression(attributeName, comparator, value.toString());
            this.closeParenthesis(closeParenthesis);
            return this;
        }

        private void setExpression(String attributeName, Comparator comparator, Object value) {
            ScimClientConfig scimClientConfig = ListBuilder.this.scimHttpClient.getScimClientConfig();
            String comparatorString = scimClientConfig.isUseLowerCaseInFilterComparators() ? comparator.name().toLowerCase() : comparator.name();
            this.filterString.append(attributeName).append(" ").append(comparatorString);
            if (value instanceof String) {
                this.filterString.append(value == null ? "" : " ").append("\"").append(value == null ? "" : value).append("\"");
            } else {
                this.filterString.append(value == null ? "" : " " + value);
            }
        }

        public ListBuilder<T> build() {
            if (this.openedParenthesis != this.closedParenthesis) {
                throw new IllegalStateException("error within filter expression\n\topened parentheses: " + this.openedParenthesis + "\n\tclosed parentheses: " + this.closedParenthesis + "\n\tfilter: " + this.filterString);
            }
            ((ListBuilder)this.listBuilder).requestParameters.put("filter", this.filterString.toString());
            return this.listBuilder;
        }
    }

    public static class GetRequestBuilder<T extends ResourceNode>
    extends TypedRequestBuilder<T> {
        public GetRequestBuilder(ListBuilder<T> listBuilder) {
            super(listBuilder);
        }

        @Override
        public GetRequestBuilder<T> setExpectedResponseHeaders(Map<String, String> requiredResponseHeaders) {
            return (GetRequestBuilder)super.setExpectedResponseHeaders(requiredResponseHeaders);
        }

        @Override
        protected boolean isExpectedResponseCode(int httpStatus) {
            return 200 == httpStatus;
        }

        @Override
        protected HttpUriRequest getHttpUriRequest() {
            StringBuilder queryBuilder = new StringBuilder();
            if (!this.listBuilder.requestParameters.isEmpty()) {
                if (StringUtils.contains((CharSequence)this.listBuilder.fullUrl, (CharSequence)"?")) {
                    queryBuilder.append("&");
                } else {
                    queryBuilder.append("?");
                }
                ArrayList pairs = new ArrayList();
                this.listBuilder.requestParameters.forEach((key, value) -> pairs.add(key + "=" + EncodingUtils.urlEncode((String)value)));
                queryBuilder.append(String.join((CharSequence)"&", pairs));
            }
            HttpGet httpGet = StringUtils.isBlank((CharSequence)this.listBuilder.fullUrl) ? new HttpGet(this.getBaseUrl() + this.getEndpoint() + queryBuilder) : new HttpGet(this.listBuilder.fullUrl + queryBuilder);
            return httpGet;
        }

        @Override
        protected Function<HttpResponse, Boolean> isResponseParseable() {
            return httpResponse -> {
                String responseBody = httpResponse.getResponseBody();
                if (StringUtils.isNotBlank((CharSequence)responseBody) && responseBody.contains("urn:ietf:params:scim:api:messages:2.0:ListResponse")) {
                    return true;
                }
                return false;
            };
        }

        @Override
        protected ServerResponse<ListResponse<T>> toResponse(HttpResponse response) {
            return new ListServerResponse(response, this.isExpectedResponseCode(response.getHttpStatusCode()), this.getResponseEntityType(), this.listBuilder.responseEntityType, this.isResponseParseable(), this.getRequiredResponseHeaders());
        }
    }

    public static class PostRequestBuilder<T extends ResourceNode>
    extends TypedRequestBuilder<T> {
        public PostRequestBuilder(ListBuilder<T> listBuilder) {
            super(listBuilder);
        }

        @Override
        public PostRequestBuilder<T> setExpectedResponseHeaders(Map<String, String> requiredResponseHeaders) {
            return (PostRequestBuilder)super.setExpectedResponseHeaders(requiredResponseHeaders);
        }

        @Override
        protected boolean isExpectedResponseCode(int httpStatus) {
            return 200 == httpStatus;
        }

        @Override
        protected HttpUriRequest getHttpUriRequest() {
            String url;
            HttpPost httpPost = StringUtils.isBlank((CharSequence)this.listBuilder.fullUrl) ? new HttpPost(this.getBaseUrl() + this.getEndpoint() + "/.search") : ((url = this.listBuilder.fullUrl).endsWith("/.search") ? new HttpPost(this.listBuilder.fullUrl) : new HttpPost(this.listBuilder.fullUrl + "/.search"));
            if (!this.listBuilder.requestParameters.isEmpty()) {
                SearchRequest searchRequest = SearchRequest.builder().build();
                this.listBuilder.requestParameters.forEach((arg_0, arg_1) -> ((SearchRequest)searchRequest).put(arg_0, arg_1));
                super.setResource((JsonNode)searchRequest);
                StringEntity stringEntity = new StringEntity(this.getResource(), StandardCharsets.UTF_8);
                httpPost.setEntity((HttpEntity)stringEntity);
            }
            return httpPost;
        }

        @Override
        protected Function<HttpResponse, Boolean> isResponseParseable() {
            return httpResponse -> {
                String responseBody = httpResponse.getResponseBody();
                if (StringUtils.isNotBlank((CharSequence)responseBody) && responseBody.contains("urn:ietf:params:scim:api:messages:2.0:ListResponse")) {
                    return true;
                }
                return false;
            };
        }

        @Override
        protected ServerResponse<ListResponse<T>> toResponse(HttpResponse response) {
            return new ListServerResponse(response, this.isExpectedResponseCode(response.getHttpStatusCode()), this.getResponseEntityType(), this.listBuilder.responseEntityType, this.isResponseParseable(), this.getRequiredResponseHeaders());
        }
    }

    public static class ListServerResponse<T extends ResourceNode>
    extends ServerResponse<ListResponse<T>> {
        private Class<T> responseEntityType;

        public ListServerResponse(HttpResponse httpResponse, boolean expectedResponseCode, Class<ListResponse<T>> type, Class<T> responseEntityType, Function<HttpResponse, Boolean> isResponseParseable, Map<String, String> requiredResponseHeaders) {
            super(httpResponse, expectedResponseCode, type, isResponseParseable, requiredResponseHeaders);
            this.responseEntityType = responseEntityType;
        }

        @Override
        public <R extends ScimObjectNode> R getResource(Class<R> responseType) {
            ListResponse listResponse = (ListResponse)JsonHelper.readJsonDocument((String)this.getResponseBody(), ListResponse.class);
            List typedResources = listResponse.getListedResources().parallelStream().map(scimObjectNode -> (ResourceNode)JsonHelper.readJsonDocument((String)scimObjectNode.toString(), this.responseEntityType)).collect(Collectors.toList());
            ListResponse typedListResponse = new ListResponse(this.responseEntityType);
            typedListResponse.setItemsPerPage(Integer.valueOf(listResponse.getItemsPerPage()));
            typedListResponse.setStartIndex(Long.valueOf(listResponse.getStartIndex()));
            typedListResponse.setTotalResults(Long.valueOf(listResponse.getTotalResults()));
            typedListResponse.setListedResources(typedResources);
            return (R)typedListResponse;
        }
    }

    private static abstract class TypedRequestBuilder<T extends ResourceNode>
    extends RequestBuilder<ListResponse<T>> {
        protected ListBuilder<T> listBuilder;

        protected TypedRequestBuilder(ListBuilder<T> listBuilder) {
            super(((ListBuilder)listBuilder).baseUrl, ((ListBuilder)listBuilder).endpoint, new ListResponse().getClass(), ((ListBuilder)listBuilder).scimHttpClient);
            this.listBuilder = listBuilder;
        }

        public ServerResponse<ListResponse<T>> getAll() {
            long totalResults;
            ArrayList<ServerResponse<ListResponse<T>>> responseList = new ArrayList<ServerResponse<ListResponse<T>>>();
            boolean needsAdditionalRequest = false;
            long originalStartIndex = Optional.ofNullable(this.listBuilder.getRequestParameters().get("startIndex")).map(Long::parseLong).filter(index -> index > 0L).orElse(1L);
            Integer originalCount = Optional.ofNullable(this.listBuilder.getRequestParameters().get("count")).map(Integer::parseInt).orElse(null);
            int iterations = 0;
            int currentlyRetrievedResources = 0;
            ArrayNode resources = new ArrayNode(JsonNodeFactory.instance);
            do {
                ServerResponse<ListResponse<T>> response;
                log.trace("Loading resources in iteration: {}", (Object)iterations++);
                if (originalCount != null && originalCount - currentlyRetrievedResources < originalCount) {
                    this.listBuilder.count(originalCount - currentlyRetrievedResources);
                }
                if (!(response = this.sendRequest()).isSuccess()) {
                    log.warn("Failed to load next-resources in iteration. Ignoring previous responses: {}", (Object)iterations);
                    return response;
                }
                responseList.add(response);
                ArrayNode nextResources = (ArrayNode)((ListResponse)response.getResource()).get("Resources");
                if (nextResources != null) {
                    resources.addAll(nextResources);
                }
                ListResponse<T> listResponse = response.getResource();
                totalResults = listResponse.getTotalResults();
                int itemsPerPage = listResponse.getItemsPerPage() == 0 ? listResponse.getListedResources().size() : listResponse.getItemsPerPage();
                long usedStartIndex = listResponse.getStartIndex() <= 1L ? originalStartIndex + (long)currentlyRetrievedResources : listResponse.getStartIndex();
                boolean hasReachedEndOfRemoteResources = usedStartIndex - 1L + (long)itemsPerPage >= totalResults;
                boolean hasReachedWantedResourceCount = originalCount != null && (currentlyRetrievedResources += itemsPerPage) >= originalCount;
                boolean bl = needsAdditionalRequest = !hasReachedEndOfRemoteResources && !hasReachedWantedResourceCount;
                if (!needsAdditionalRequest) continue;
                this.listBuilder.startIndex(usedStartIndex + (long)itemsPerPage);
            } while (needsAdditionalRequest);
            ListResponse rebuildListResponse = new ListResponse();
            rebuildListResponse.setTotalResults(Long.valueOf(totalResults));
            rebuildListResponse.setItemsPerPage(Integer.valueOf(currentlyRetrievedResources));
            rebuildListResponse.setStartIndex(Long.valueOf(originalStartIndex));
            rebuildListResponse.set("Resources", (JsonNode)resources);
            HttpResponse httpResponse = HttpResponse.builder().httpStatusCode(200).build();
            return new ServerResponse<ListResponse<T>>(httpResponse, true, rebuildListResponse);
        }
    }
}

