/*
 * Decompiled with CFR 0.152.
 */
package de.captaingoldfish.scim.sdk.client.builder;

import com.fasterxml.jackson.databind.JsonNode;
import de.captaingoldfish.scim.sdk.client.ScimClientConfig;
import de.captaingoldfish.scim.sdk.client.builder.RequestBuilder;
import de.captaingoldfish.scim.sdk.client.http.HttpResponse;
import de.captaingoldfish.scim.sdk.client.http.ScimHttpClient;
import de.captaingoldfish.scim.sdk.client.response.ServerResponse;
import de.captaingoldfish.scim.sdk.common.constants.enums.HttpMethod;
import de.captaingoldfish.scim.sdk.common.etag.ETag;
import de.captaingoldfish.scim.sdk.common.request.BulkRequest;
import de.captaingoldfish.scim.sdk.common.request.BulkRequestOperation;
import de.captaingoldfish.scim.sdk.common.resources.ServiceProvider;
import de.captaingoldfish.scim.sdk.common.resources.base.ScimObjectNode;
import de.captaingoldfish.scim.sdk.common.resources.complex.BulkConfig;
import de.captaingoldfish.scim.sdk.common.response.BulkResponse;
import de.captaingoldfish.scim.sdk.common.response.BulkResponseOperation;
import de.captaingoldfish.scim.sdk.common.response.ErrorResponse;
import de.captaingoldfish.scim.sdk.common.tree.GenericTree;
import de.captaingoldfish.scim.sdk.common.tree.TreeNode;
import de.captaingoldfish.scim.sdk.common.utils.JsonHelper;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ForkJoinTask;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BulkBuilder
extends RequestBuilder<BulkResponse> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BulkBuilder.class);
    private final BulkRequest.BulkRequestBuilder builder = BulkRequest.builder();
    private final List<BulkRequestOperation> bulkRequestOperationList = Collections.synchronizedList(new ArrayList());
    private final Map<String, BulkRequestOperation> bulkRequestOperationMap = new ConcurrentHashMap<String, BulkRequestOperation>();
    private final String fullUrl;
    private Supplier<ServiceProvider> serviceProviderSupplier;

    public BulkBuilder(String baseUrl, ScimHttpClient scimHttpClient, boolean isFullUrl, Supplier<ServiceProvider> serviceProviderSupplier) {
        super(isFullUrl ? null : baseUrl, "/Bulk", BulkResponse.class, scimHttpClient);
        this.builder.bulkRequestOperation(this.bulkRequestOperationList);
        this.fullUrl = isFullUrl ? baseUrl : null;
        this.serviceProviderSupplier = Optional.ofNullable(serviceProviderSupplier).orElse(() -> null);
    }

    public BulkBuilder setExpectedResponseHeaders(Map<String, String> requiredResponseHeaders) {
        return (BulkBuilder)super.setExpectedResponseHeaders(requiredResponseHeaders);
    }

    public BulkRequestOperation getOperationByBulkId(String bulkId) {
        return this.bulkRequestOperationMap.get(bulkId);
    }

    @Override
    protected boolean isExpectedResponseCode(int httpStatus) {
        return 200 == httpStatus;
    }

    @Override
    protected HttpUriRequest getHttpUriRequest() {
        HttpPost httpPost = StringUtils.isBlank((CharSequence)this.fullUrl) ? new HttpPost(this.getBaseUrl() + this.getEndpoint()) : new HttpPost(this.fullUrl);
        StringEntity stringEntity = new StringEntity(this.getResource(), StandardCharsets.UTF_8);
        httpPost.setEntity((HttpEntity)stringEntity);
        return httpPost;
    }

    @Override
    public String getResource() {
        return this.builder.build().toString();
    }

    @Override
    protected Function<HttpResponse, Boolean> isResponseParseable() {
        return httpResponse -> {
            String responseBody = httpResponse.getResponseBody();
            if (StringUtils.isNotBlank((CharSequence)responseBody) && responseBody.contains("urn:ietf:params:scim:api:messages:2.0:BulkResponse")) {
                return true;
            }
            return false;
        };
    }

    public BulkBuilder failOnErrors(Integer failOnErrors) {
        this.builder.failOnErrors(failOnErrors);
        return this;
    }

    public BulkRequestOperationCreator bulkRequestOperation(String path) {
        return this.bulkRequestOperation(path, null);
    }

    public BulkRequestOperationCreator bulkRequestOperation(String path, String id) {
        String idPath = StringUtils.isBlank((CharSequence)id) ? "" : "/" + id;
        return new BulkRequestOperationCreator(this, path + idPath);
    }

    public BulkBuilder addOperations(List<BulkRequestOperation> requestOperations) {
        for (BulkRequestOperation requestOperation : requestOperations) {
            if (!requestOperation.getBulkId().isPresent()) {
                requestOperation.setBulkId(UUID.randomUUID().toString());
            }
            this.bulkRequestOperationMap.put((String)requestOperation.getBulkId().get(), requestOperation);
        }
        this.bulkRequestOperationList.addAll(requestOperations);
        return this;
    }

    public ServerResponse<BulkResponse> sendRequest(boolean runSplittedRequestsParallel) {
        return this.sendRequestWithMultiHeaders(Collections.emptyMap(), null, runSplittedRequestsParallel);
    }

    public ServerResponse<BulkResponse> sendRequest(Consumer<ServerResponse<BulkResponse>> responseHandler) {
        return this.sendRequestWithMultiHeaders(Collections.emptyMap(), responseHandler, false);
    }

    public ServerResponse<BulkResponse> sendRequest(Consumer<ServerResponse<BulkResponse>> responseHandler, boolean runSplittedRequestsParallel) {
        return this.sendRequestWithMultiHeaders(Collections.emptyMap(), responseHandler, runSplittedRequestsParallel);
    }

    public ServerResponse<BulkResponse> sendRequest(Map<String, String> headers, Consumer<ServerResponse<BulkResponse>> responseHandler) {
        return this.sendRequest(headers, responseHandler, false);
    }

    public ServerResponse<BulkResponse> sendRequest(Map<String, String> headers, Consumer<ServerResponse<BulkResponse>> responseHandler, boolean runSplittedRequestsParallel) {
        HashMap<String, String[]> multiHeader = new HashMap<String, String[]>();
        headers.forEach((key, value) -> multiHeader.put((String)key, new String[]{value}));
        return this.sendRequestWithMultiHeaders(multiHeader, responseHandler, runSplittedRequestsParallel);
    }

    @Override
    public ServerResponse<BulkResponse> sendRequestWithMultiHeaders(Map<String, String[]> httpHeaders) {
        return this.sendRequestWithMultiHeaders(httpHeaders, null, false);
    }

    public ServerResponse<BulkResponse> sendRequestWithMultiHeaders(Map<String, String[]> httpHeaders, boolean runSplittedRequestsParallel) {
        return this.sendRequestWithMultiHeaders(httpHeaders, null, runSplittedRequestsParallel);
    }

    public ServerResponse<BulkResponse> sendRequestWithMultiHeaders(Map<String, String[]> httpHeaders, Consumer<ServerResponse<BulkResponse>> responseHandler) {
        return this.sendRequestWithMultiHeaders(httpHeaders, responseHandler, false);
    }

    public ServerResponse<BulkResponse> sendRequestWithMultiHeaders(Map<String, String[]> httpHeaders, Consumer<ServerResponse<BulkResponse>> responseHandler, boolean runSplittedRequestsParallel) {
        boolean fitsIntoASingleRequest;
        if (this.bulkRequestOperationList.isEmpty()) {
            throw new IllegalStateException("Cannot send bulk-request without any operations");
        }
        int maxNumberOfOperationns = this.getMaxNumberOfOperations();
        boolean isSplittingFeatureDisabled = !this.getScimHttpClient().getScimClientConfig().isEnableAutomaticBulkRequestSplitting();
        boolean bl = fitsIntoASingleRequest = this.bulkRequestOperationList.size() <= maxNumberOfOperationns;
        if (isSplittingFeatureDisabled || fitsIntoASingleRequest) {
            return super.sendRequestWithMultiHeaders(httpHeaders);
        }
        return this.sendMultipleBulkRequests(httpHeaders, responseHandler, runSplittedRequestsParallel);
    }

    private int getMaxNumberOfOperations() {
        int maxNumberOfOperations = Optional.ofNullable(this.serviceProviderSupplier.get()).map(ServiceProvider::getBulkConfig).map(BulkConfig::getMaxOperations).orElse(Integer.MAX_VALUE);
        if (maxNumberOfOperations <= 0) {
            throw new IllegalStateException("Maximum number of operations must not be 0 or smaller.");
        }
        return maxNumberOfOperations;
    }

    private ServerResponse<BulkResponse> sendMultipleBulkRequests(Map<String, String[]> httpHeaders, Consumer<ServerResponse<BulkResponse>> responseHandler, boolean runSplittedRequestsParallel) {
        BulkRequestIdResolverWrapper bulkRequestIdResolverWrapper;
        boolean containsBulkIdReferences = this.getResource().contains(String.format("\"%s:", "bulkId"));
        if (containsBulkIdReferences) {
            bulkRequestIdResolverWrapper = this.splitRequestsWithRelationOrderPreserved();
        } else {
            List<List<BulkRequestOperation>> bulkRequestOperationRequestList = this.splitRequestsSimple(this.bulkRequestOperationList);
            bulkRequestIdResolverWrapper = new BulkRequestIdResolverWrapper(bulkRequestOperationRequestList, new HashMap<String, List<BulkRequestOperation>>());
        }
        List synchronizedResponseOperations = Collections.synchronizedList(new ArrayList());
        List<List<BulkRequestOperation>> bulkRequestOperationsList = bulkRequestIdResolverWrapper.getRequestsList();
        ArrayBlockingQueue serverResponseList = new ArrayBlockingQueue(bulkRequestOperationsList.size());
        ServiceProvider serviceProvider = this.serviceProviderSupplier.get();
        ScimClientConfig scimClientConfig = this.getScimHttpClient().getScimClientConfig();
        IntStream bulkOperationIndexStream = IntStream.range(0, bulkRequestOperationsList.size());
        Function<Runnable, ForkJoinTask> runInPool = runnable -> {
            serviceProvider.getThreadPool().awaitQuiescence(scimClientConfig.getSocketTimeout(), TimeUnit.SECONDS);
            return serviceProvider.getThreadPool().submit((Runnable)runnable);
        };
        Runnable runnable2 = () -> {
            IntStream indexStream = runSplittedRequestsParallel ? bulkOperationIndexStream.parallel() : bulkOperationIndexStream;
            indexStream.forEach(index -> {
                List bulkRequestOperations = (List)bulkRequestOperationsList.get(index);
                if (log.isDebugEnabled()) {
                    log.debug("Handling bulk request '{}' of '{}' with '{}' operations.", new Object[]{index + 1, bulkRequestIdResolverWrapper.getRequestsList().size(), bulkRequestOperations.size()});
                }
                boolean isFullUrl = this.getBaseUrl() == null;
                this.replaceBulkRequestOperations(bulkRequestOperations, bulkRequestIdResolverWrapper);
                BulkBuilder splitBulkBuilder = new BulkBuilder(this.getBaseUrl(), this.getScimHttpClient(), isFullUrl, this.serviceProviderSupplier);
                Integer failOnErrors = this.builder.getFailOnErrors();
                splitBulkBuilder.failOnErrors(failOnErrors).addOperations(bulkRequestOperations);
                ServerResponse<BulkResponse> response = splitBulkBuilder.sendRequestWithMultiHeaders(httpHeaders);
                if (log.isDebugEnabled()) {
                    log.debug("Received response for bulk request '{}' of '{}'.", (Object)(index + 1), (Object)bulkRequestIdResolverWrapper.getRequestsList().size());
                }
                this.validateResponseAndResolveResults(bulkRequestOperations, bulkRequestIdResolverWrapper, response, synchronizedResponseOperations);
                Optional.ofNullable(responseHandler).ifPresent(handler -> handler.accept(response));
                serverResponseList.add(response);
            });
        };
        runInPool.apply(runnable2).get();
        log.debug("Finished handling all bulk requests. The requests will be merged and returned in a single response-object");
        BulkResponse compositeBulkResponse = new BulkResponse();
        compositeBulkResponse.setBulkResponseOperations(synchronizedResponseOperations);
        HttpResponse httpResponse = HttpResponse.builder().httpStatusCode(200).responseBody(compositeBulkResponse.toString()).responseHeaders(Optional.ofNullable((ServerResponse)serverResponseList.peek()).map(ServerResponse::getHttpHeaders).orElse(Collections.emptyMap())).build();
        return new ServerResponse<BulkResponse>(httpResponse, true, BulkResponse.class, this.isResponseParseable(), this.getRequiredResponseHeaders());
    }

    private void replaceBulkRequestOperations(List<BulkRequestOperation> bulkRequestOperations, BulkRequestIdResolverWrapper bulkRequestIdResolverWrapper) {
        for (int i = 0; i < bulkRequestOperations.size(); ++i) {
            BulkRequestOperation bulkRequestOperation = bulkRequestOperations.get(i);
            String operationString = bulkRequestOperation.toString();
            String bulkId = bulkRequestOperation.getBulkId().orElse(null);
            if (bulkId == null) {
                throw new IllegalStateException("Cannot use auto-splitting feature for bulk requests if the bulkId elements are missing. Please assign a bulkId to each single operation!");
            }
            List<BulkRequestOperation> childOperationList = bulkRequestIdResolverWrapper.getParentChildRelationMap().get(bulkId);
            if (childOperationList == null) break;
            for (BulkRequestOperation childOperation : childOperationList) {
                String childBulkId = (String)childOperation.getBulkId().get();
                String childResourceId = bulkRequestIdResolverWrapper.getResolvedBulkIds().get(childBulkId);
                String oldReference = String.format("\"%s:%s\"", "bulkId", childBulkId);
                String newReference = String.format("\"%s\"", childResourceId);
                operationString = operationString.replaceAll(oldReference, newReference);
            }
            bulkRequestOperations.remove(i);
            BulkRequestOperation newOperation = (BulkRequestOperation)JsonHelper.readJsonDocument((String)operationString, BulkRequestOperation.class);
            bulkRequestOperations.add(i, newOperation);
        }
    }

    private void validateResponseAndResolveResults(List<BulkRequestOperation> bulkRequestOperations, BulkRequestIdResolverWrapper bulkRequestIdResolverWrapper, ServerResponse<BulkResponse> response, List<BulkResponseOperation> responseOperations) {
        if (!response.isSuccess()) {
            log.error("Bulk error on automatically splitted requests. Please note that this might cause unwanted results on the server that need to be fixed manually. The following log messages shall help identifying the problem:");
            log.error("The following request operations were not successful: \n{}", (Object)bulkRequestOperations.stream().map(ScimObjectNode::toPrettyString).collect(Collectors.joining("\n")));
            log.error("Response from the server: {}", (Object)Optional.ofNullable(response.getErrorResponse()).map(ErrorResponse::toPrettyString).orElseGet(response::getResponseBody));
            int indexOfFailedRequest = bulkRequestIdResolverWrapper.getRequestsList().indexOf(bulkRequestOperations);
            if (indexOfFailedRequest > 0) {
                String successOperations = bulkRequestIdResolverWrapper.getRequestsList().subList(0, indexOfFailedRequest).stream().flatMap(Collection::stream).map(ScimObjectNode::toPrettyString).collect(Collectors.joining("\n"));
                log.error("The following operations were executed successfully on the server and were persisted: \n{}", (Object)successOperations);
            }
            throw new IllegalStateException(String.format("The bulk request failed with status: %s and message: %s", response.getHttpStatus(), response.getResponseBody()));
        }
        BulkResponse bulkResponse = response.getResource();
        for (BulkResponseOperation bulkResponseOperation : bulkResponse.getBulkResponseOperations()) {
            String bulkId = (String)bulkResponseOperation.getBulkId().orElseThrow(() -> new IllegalStateException("Missing bulkId in response cannot resolve relations of split operations."));
            String resourceId = bulkResponseOperation.getResourceId().orElseGet(() -> this.getIdFromLocationAttribute(bulkResponseOperation));
            if (resourceId != null) {
                bulkRequestIdResolverWrapper.getResolvedBulkIds().put(bulkId, resourceId);
            }
            responseOperations.add(bulkResponseOperation);
        }
    }

    protected String getIdFromLocationAttribute(BulkResponseOperation bulkResponseOperation) {
        String[] locationParts = bulkResponseOperation.getLocation().map(s -> s.split("/")).orElse(null);
        if (locationParts == null) {
            return null;
        }
        return locationParts[locationParts.length - 1];
    }

    private BulkRequestIdResolverWrapper splitRequestsWithRelationOrderPreserved() {
        int maxNumberOfOperationns = this.getMaxNumberOfOperations();
        GenericTree<BulkRequestOperation> childParentRelationsTree = this.getParentChildRelationsOfRequest();
        List<BulkRequestOperation> unparentedOperations = this.extractUnparentedOperationsFromTree(childParentRelationsTree);
        ArrayList<List<BulkRequestOperation>> requestLists = new ArrayList<List<BulkRequestOperation>>();
        HashMap<String, List<BulkRequestOperation>> parentChildRelationMap = new HashMap<String, List<BulkRequestOperation>>();
        for (TreeNode treeNode : childParentRelationsTree.getAllNodes()) {
            if (treeNode.isLeaf()) continue;
            parentChildRelationMap.put((String)((BulkRequestOperation)treeNode.getValue()).getBulkId().get(), treeNode.getChildren().stream().map(TreeNode::getValue).collect(Collectors.toList()));
        }
        block1: while (childParentRelationsTree.hasNodes()) {
            ArrayList<BulkRequestOperation> operationList = new ArrayList<BulkRequestOperation>();
            while (operationList.size() != maxNumberOfOperationns && childParentRelationsTree.hasNodes()) {
                boolean areMoreOperationsAvailable;
                for (TreeNode leaf : childParentRelationsTree.getLeafs()) {
                    childParentRelationsTree.removeNodeFromTree(leaf);
                    operationList.add((BulkRequestOperation)leaf.getValue());
                    if (operationList.size() != maxNumberOfOperationns) continue;
                    break;
                }
                if (!childParentRelationsTree.hasNodes()) {
                    requestLists.add(operationList);
                    continue block1;
                }
                boolean bl = areMoreOperationsAvailable = operationList.size() < maxNumberOfOperationns;
                if (areMoreOperationsAvailable) continue;
                requestLists.add(operationList);
            }
        }
        List lastParentedList = (List)requestLists.get(requestLists.size() - 1);
        if (lastParentedList.size() < maxNumberOfOperationns) {
            while (!unparentedOperations.isEmpty() && lastParentedList.size() < maxNumberOfOperationns) {
                BulkRequestOperation bulkRequestOperation = unparentedOperations.get(0);
                unparentedOperations.remove(0);
                lastParentedList.add(bulkRequestOperation);
            }
        }
        if (!unparentedOperations.isEmpty()) {
            List<List<BulkRequestOperation>> splittedLists = this.splitRequestsSimple(unparentedOperations);
            requestLists.addAll(splittedLists);
        }
        return new BulkRequestIdResolverWrapper(requestLists, parentChildRelationMap);
    }

    private List<BulkRequestOperation> extractUnparentedOperationsFromTree(GenericTree<BulkRequestOperation> childParentRelationsTree) {
        ArrayList<BulkRequestOperation> unparentedOperations = new ArrayList<BulkRequestOperation>();
        for (TreeNode leaf : childParentRelationsTree.getLeafs()) {
            boolean isNodeWithoutRelationsships = leaf.isLeaf() && leaf.isRoot();
            if (!isNodeWithoutRelationsships) continue;
            unparentedOperations.add((BulkRequestOperation)leaf.getValue());
            childParentRelationsTree.removeNodeFromTree(leaf);
        }
        return unparentedOperations;
    }

    private GenericTree<BulkRequestOperation> getParentChildRelationsOfRequest() {
        String regex = String.format("\"%s:(.*?)\"", "bulkId");
        Pattern bulkIdPattern = Pattern.compile(regex);
        GenericTree childParentRelations = new GenericTree();
        for (BulkRequestOperation bulkRequestOperation : this.getBulkRequestOperationList()) {
            String currentResource = bulkRequestOperation.toString();
            Matcher bulkIdMatcher = bulkIdPattern.matcher(currentResource);
            TreeNode parentNode = childParentRelations.addDistinctNode((Object)bulkRequestOperation);
            while (bulkIdMatcher.find()) {
                String bulkId = bulkIdMatcher.group(1);
                BulkRequestOperation operation = this.bulkRequestOperationList.stream().filter(op -> bulkId.equals(op.getBulkId().orElse(null))).findAny().orElseThrow(() -> {
                    String error = "found illegal bulkId in request '" + bulkId + "':  has no parent.";
                    return new IllegalStateException(error);
                });
                TreeNode childNode = childParentRelations.addDistinctNode((Object)operation);
                parentNode.addChild(childNode);
            }
        }
        return childParentRelations;
    }

    private List<List<BulkRequestOperation>> splitRequestsSimple(List<BulkRequestOperation> operationsToSplit) {
        List<BulkRequestOperation> subList;
        int maxNumberOfOperationns = Math.max(1, this.getMaxNumberOfOperations());
        ArrayList<List<BulkRequestOperation>> splittedListParts = new ArrayList<List<BulkRequestOperation>>();
        if (operationsToSplit.size() <= maxNumberOfOperationns) {
            splittedListParts.add(operationsToSplit);
            return splittedListParts;
        }
        for (int currentIndex = 0; currentIndex < operationsToSplit.size(); currentIndex += subList.size()) {
            int nextIndex = currentIndex + maxNumberOfOperationns;
            int effectiveListIndex = Math.min(nextIndex, operationsToSplit.size());
            subList = operationsToSplit.subList(currentIndex, effectiveListIndex);
            splittedListParts.add(new ArrayList<BulkRequestOperation>(subList));
        }
        log.debug("Splitted bulk operations into '{}' individual bulk-requests", (Object)splittedListParts.size());
        return splittedListParts;
    }

    @Generated
    public List<BulkRequestOperation> getBulkRequestOperationList() {
        return this.bulkRequestOperationList;
    }

    @Generated
    public void setServiceProviderSupplier(Supplier<ServiceProvider> serviceProviderSupplier) {
        this.serviceProviderSupplier = serviceProviderSupplier;
    }

    public static class BulkRequestOperationCreator {
        private final BulkBuilder bulkBuilder;
        private final BulkRequestOperation.BulkRequestOperationBuilder builder = BulkRequestOperation.builder();

        public BulkRequestOperationCreator(BulkBuilder bulkBuilder, String path) {
            this.bulkBuilder = bulkBuilder;
            this.builder.path(path);
        }

        public BulkRequestOperationCreator method(HttpMethod method) {
            this.builder.method(method);
            return this;
        }

        public BulkRequestOperationCreator bulkId(String bulkId) {
            this.builder.bulkId(bulkId);
            return this;
        }

        public BulkRequestOperationCreator data(String data) {
            this.builder.data(data);
            return this;
        }

        public BulkRequestOperationCreator data(JsonNode data) {
            this.builder.data(data.toString());
            return this;
        }

        public BulkRequestOperationCreator version(ETag version) {
            this.builder.version(version);
            return this;
        }

        public BulkRequestOperationCreator returnResource(boolean returnResource) {
            this.builder.returnResource(Boolean.valueOf(returnResource));
            return this;
        }

        public BulkRequestOperationCreator maxResourceLevel(int maxResourceLevel) {
            this.builder.maxResourceLevel(Integer.valueOf(maxResourceLevel));
            return this;
        }

        public BulkBuilder next() {
            BulkRequestOperation operation = this.builder.build();
            this.bulkBuilder.getBulkRequestOperationList().add(operation);
            if (!operation.getBulkId().isPresent()) {
                operation.setBulkId(UUID.randomUUID().toString());
            }
            this.bulkBuilder.bulkRequestOperationMap.put((String)operation.getBulkId().get(), operation);
            return this.bulkBuilder;
        }

        public ServerResponse<BulkResponse> sendRequest() {
            return this.sendRequest(Collections.emptyMap());
        }

        public ServerResponse<BulkResponse> sendRequest(Consumer<ServerResponse<BulkResponse>> responseHandler) {
            return this.sendRequest(Collections.emptyMap(), responseHandler);
        }

        public ServerResponse<BulkResponse> sendRequest(Map<String, String> httpHeaders) {
            return this.next().sendRequest(httpHeaders);
        }

        public ServerResponse<BulkResponse> sendRequest(Map<String, String> httpHeaders, Consumer<ServerResponse<BulkResponse>> responseHandler) {
            return this.next().sendRequest(httpHeaders, responseHandler);
        }

        public ServerResponse<BulkResponse> sendRequestWithMultiHeaders(Map<String, String[]> httpHeaders) {
            return this.next().sendRequestWithMultiHeaders(httpHeaders);
        }

        public ServerResponse<BulkResponse> sendRequestWithMultiHeaders(Map<String, String[]> httpHeaders, Consumer<ServerResponse<BulkResponse>> responseHandler) {
            return this.next().sendRequestWithMultiHeaders(httpHeaders, responseHandler);
        }
    }

    private static class BulkRequestIdResolverWrapper {
        private final List<List<BulkRequestOperation>> requestsList;
        private final Map<String, List<BulkRequestOperation>> parentChildRelationMap;
        private final Map<String, String> resolvedBulkIds;

        public BulkRequestIdResolverWrapper(List<List<BulkRequestOperation>> requestsList, Map<String, List<BulkRequestOperation>> parentChildRelationMap) {
            this.requestsList = Objects.requireNonNull(requestsList);
            this.parentChildRelationMap = Objects.requireNonNull(parentChildRelationMap);
            this.resolvedBulkIds = new HashMap<String, String>();
        }

        @Generated
        public List<List<BulkRequestOperation>> getRequestsList() {
            return this.requestsList;
        }

        @Generated
        public Map<String, List<BulkRequestOperation>> getParentChildRelationMap() {
            return this.parentChildRelationMap;
        }

        @Generated
        public Map<String, String> getResolvedBulkIds() {
            return this.resolvedBulkIds;
        }
    }
}

