/*
 * Decompiled with CFR 0.152.
 */
package de.captaingoldfish.scim.sdk.client;

import de.captaingoldfish.scim.sdk.client.http.BasicAuth;
import de.captaingoldfish.scim.sdk.client.http.ConfigManipulator;
import de.captaingoldfish.scim.sdk.client.http.ProxyHelper;
import de.captaingoldfish.scim.sdk.client.keys.KeyStoreWrapper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.net.ssl.HostnameVerifier;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.impl.client.HttpClientBuilder;

public class ScimClientConfig {
    public static final int DEFAULT_TIMEOUT = 10;
    private int requestTimeout;
    private int socketTimeout;
    private int connectTimeout;
    private boolean enableCookieManagement;
    private boolean enableAutomaticBulkRequestSplitting;
    private HostnameVerifier hostnameVerifier;
    private ProxyHelper proxy;
    private KeyStoreWrapper clientAuth;
    private KeyStoreWrapper truststore;
    private Map<String, String[]> httpHeaders;
    private Map<String, String> expectedHttpResponseHeaders;
    private BasicAuth basicAuth;
    private ConfigManipulator configManipulator;
    private boolean useLowerCaseInFilterComparators;
    private String tlsVersion;
    private HttpClientBuilder httpClientBuilder;
    private int maxPatchOperationsPerRequest;

    public ScimClientConfig(Integer requestTimeout, Integer socketTimeout, Integer connectTimeout, boolean enableCookieManagement, boolean enableAutomaticBulkRequestSplitting, HostnameVerifier hostnameVerifier, ProxyHelper proxy, KeyStoreWrapper clientAuth, KeyStoreWrapper truststore, Map<String, String> httpHeaders, Map<String, String[]> httpMultiHeaders, BasicAuth basicAuth, ConfigManipulator configManipulator, boolean useLowerCaseInFilterComparators, Map<String, String> expectedHttpResponseHeaders, String tlsVersion, HttpClientBuilder httpClientBuilder, int maxPatchOperationsPerRequest) {
        this.requestTimeout = requestTimeout == null ? 10 : requestTimeout;
        this.socketTimeout = socketTimeout == null ? 10 : socketTimeout;
        this.connectTimeout = connectTimeout == null ? 10 : connectTimeout;
        this.enableCookieManagement = enableCookieManagement;
        this.enableAutomaticBulkRequestSplitting = enableAutomaticBulkRequestSplitting;
        this.hostnameVerifier = hostnameVerifier;
        this.proxy = proxy;
        this.clientAuth = clientAuth;
        this.truststore = truststore;
        this.setHeaders(httpHeaders, httpMultiHeaders);
        this.basicAuth = basicAuth;
        this.configManipulator = configManipulator;
        this.useLowerCaseInFilterComparators = useLowerCaseInFilterComparators;
        this.expectedHttpResponseHeaders = expectedHttpResponseHeaders;
        this.tlsVersion = Optional.ofNullable(tlsVersion).map(StringUtils::stripToNull).orElse("TLSv1.2");
        this.httpClientBuilder = httpClientBuilder;
        this.maxPatchOperationsPerRequest = maxPatchOperationsPerRequest;
    }

    private void setHeaders(Map<String, String> httpSingleHeaders, Map<String, String[]> httpMultiHeaders) {
        this.httpHeaders = new HashMap<String, String[]>();
        if (httpSingleHeaders != null) {
            httpSingleHeaders.forEach((key, value) -> this.httpHeaders.put((String)key, new String[]{value}));
        }
        if (httpMultiHeaders != null) {
            httpMultiHeaders.forEach((key, valueArray) -> {
                String[] multiValues = this.httpHeaders.get(key);
                if (multiValues == null) {
                    this.httpHeaders.put((String)key, (String[])valueArray);
                } else {
                    ArrayList<String> headerList = new ArrayList<String>(Arrays.asList(multiValues));
                    headerList.addAll(Arrays.asList(valueArray));
                    this.httpHeaders.put((String)key, headerList.toArray(new String[0]));
                }
            });
        }
    }

    public HttpClientBuilder getHttpClientBuilder() {
        return this.httpClientBuilder == null ? HttpClientBuilder.create() : this.httpClientBuilder;
    }

    @Generated
    public static ScimClientConfigBuilder builder() {
        return new ScimClientConfigBuilder();
    }

    @Generated
    public int getRequestTimeout() {
        return this.requestTimeout;
    }

    @Generated
    public int getSocketTimeout() {
        return this.socketTimeout;
    }

    @Generated
    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    @Generated
    public boolean isEnableCookieManagement() {
        return this.enableCookieManagement;
    }

    @Generated
    public boolean isEnableAutomaticBulkRequestSplitting() {
        return this.enableAutomaticBulkRequestSplitting;
    }

    @Generated
    public HostnameVerifier getHostnameVerifier() {
        return this.hostnameVerifier;
    }

    @Generated
    public ProxyHelper getProxy() {
        return this.proxy;
    }

    @Generated
    public KeyStoreWrapper getClientAuth() {
        return this.clientAuth;
    }

    @Generated
    public KeyStoreWrapper getTruststore() {
        return this.truststore;
    }

    @Generated
    public Map<String, String[]> getHttpHeaders() {
        return this.httpHeaders;
    }

    @Generated
    public Map<String, String> getExpectedHttpResponseHeaders() {
        return this.expectedHttpResponseHeaders;
    }

    @Generated
    public BasicAuth getBasicAuth() {
        return this.basicAuth;
    }

    @Generated
    public ConfigManipulator getConfigManipulator() {
        return this.configManipulator;
    }

    @Generated
    public boolean isUseLowerCaseInFilterComparators() {
        return this.useLowerCaseInFilterComparators;
    }

    @Generated
    public String getTlsVersion() {
        return this.tlsVersion;
    }

    @Generated
    public int getMaxPatchOperationsPerRequest() {
        return this.maxPatchOperationsPerRequest;
    }

    @Generated
    public void setRequestTimeout(int requestTimeout) {
        this.requestTimeout = requestTimeout;
    }

    @Generated
    public void setSocketTimeout(int socketTimeout) {
        this.socketTimeout = socketTimeout;
    }

    @Generated
    public void setConnectTimeout(int connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    @Generated
    public void setEnableCookieManagement(boolean enableCookieManagement) {
        this.enableCookieManagement = enableCookieManagement;
    }

    @Generated
    public void setEnableAutomaticBulkRequestSplitting(boolean enableAutomaticBulkRequestSplitting) {
        this.enableAutomaticBulkRequestSplitting = enableAutomaticBulkRequestSplitting;
    }

    @Generated
    public void setHostnameVerifier(HostnameVerifier hostnameVerifier) {
        this.hostnameVerifier = hostnameVerifier;
    }

    @Generated
    public void setProxy(ProxyHelper proxy) {
        this.proxy = proxy;
    }

    @Generated
    public void setClientAuth(KeyStoreWrapper clientAuth) {
        this.clientAuth = clientAuth;
    }

    @Generated
    public void setTruststore(KeyStoreWrapper truststore) {
        this.truststore = truststore;
    }

    @Generated
    public void setHttpHeaders(Map<String, String[]> httpHeaders) {
        this.httpHeaders = httpHeaders;
    }

    @Generated
    public void setExpectedHttpResponseHeaders(Map<String, String> expectedHttpResponseHeaders) {
        this.expectedHttpResponseHeaders = expectedHttpResponseHeaders;
    }

    @Generated
    public void setBasicAuth(BasicAuth basicAuth) {
        this.basicAuth = basicAuth;
    }

    @Generated
    public void setConfigManipulator(ConfigManipulator configManipulator) {
        this.configManipulator = configManipulator;
    }

    @Generated
    public void setUseLowerCaseInFilterComparators(boolean useLowerCaseInFilterComparators) {
        this.useLowerCaseInFilterComparators = useLowerCaseInFilterComparators;
    }

    @Generated
    public void setTlsVersion(String tlsVersion) {
        this.tlsVersion = tlsVersion;
    }

    @Generated
    public void setHttpClientBuilder(HttpClientBuilder httpClientBuilder) {
        this.httpClientBuilder = httpClientBuilder;
    }

    @Generated
    public void setMaxPatchOperationsPerRequest(int maxPatchOperationsPerRequest) {
        this.maxPatchOperationsPerRequest = maxPatchOperationsPerRequest;
    }

    @Generated
    public ScimClientConfig() {
    }

    public static class ScimClientConfigBuilder {
        @Generated
        private Integer requestTimeout;
        @Generated
        private Integer socketTimeout;
        @Generated
        private Integer connectTimeout;
        @Generated
        private boolean enableCookieManagement;
        @Generated
        private boolean enableAutomaticBulkRequestSplitting;
        @Generated
        private HostnameVerifier hostnameVerifier;
        @Generated
        private ProxyHelper proxy;
        @Generated
        private KeyStoreWrapper clientAuth;
        @Generated
        private KeyStoreWrapper truststore;
        @Generated
        private Map<String, String> httpHeaders;
        @Generated
        private Map<String, String[]> httpMultiHeaders;
        @Generated
        private BasicAuth basicAuth;
        @Generated
        private ConfigManipulator configManipulator;
        @Generated
        private boolean useLowerCaseInFilterComparators;
        @Generated
        private Map<String, String> expectedHttpResponseHeaders;
        @Generated
        private String tlsVersion;
        @Generated
        private HttpClientBuilder httpClientBuilder;
        @Generated
        private int maxPatchOperationsPerRequest;

        public ScimClientConfigBuilder basic(String username, String password) {
            this.basicAuth = BasicAuth.builder().username(username).password(password).build();
            return this;
        }

        @Generated
        ScimClientConfigBuilder() {
        }

        @Generated
        public ScimClientConfigBuilder requestTimeout(Integer requestTimeout) {
            this.requestTimeout = requestTimeout;
            return this;
        }

        @Generated
        public ScimClientConfigBuilder socketTimeout(Integer socketTimeout) {
            this.socketTimeout = socketTimeout;
            return this;
        }

        @Generated
        public ScimClientConfigBuilder connectTimeout(Integer connectTimeout) {
            this.connectTimeout = connectTimeout;
            return this;
        }

        @Generated
        public ScimClientConfigBuilder enableCookieManagement(boolean enableCookieManagement) {
            this.enableCookieManagement = enableCookieManagement;
            return this;
        }

        @Generated
        public ScimClientConfigBuilder enableAutomaticBulkRequestSplitting(boolean enableAutomaticBulkRequestSplitting) {
            this.enableAutomaticBulkRequestSplitting = enableAutomaticBulkRequestSplitting;
            return this;
        }

        @Generated
        public ScimClientConfigBuilder hostnameVerifier(HostnameVerifier hostnameVerifier) {
            this.hostnameVerifier = hostnameVerifier;
            return this;
        }

        @Generated
        public ScimClientConfigBuilder proxy(ProxyHelper proxy) {
            this.proxy = proxy;
            return this;
        }

        @Generated
        public ScimClientConfigBuilder clientAuth(KeyStoreWrapper clientAuth) {
            this.clientAuth = clientAuth;
            return this;
        }

        @Generated
        public ScimClientConfigBuilder truststore(KeyStoreWrapper truststore) {
            this.truststore = truststore;
            return this;
        }

        @Generated
        public ScimClientConfigBuilder httpHeaders(Map<String, String> httpHeaders) {
            this.httpHeaders = httpHeaders;
            return this;
        }

        @Generated
        public ScimClientConfigBuilder httpMultiHeaders(Map<String, String[]> httpMultiHeaders) {
            this.httpMultiHeaders = httpMultiHeaders;
            return this;
        }

        @Generated
        public ScimClientConfigBuilder basicAuth(BasicAuth basicAuth) {
            this.basicAuth = basicAuth;
            return this;
        }

        @Generated
        public ScimClientConfigBuilder configManipulator(ConfigManipulator configManipulator) {
            this.configManipulator = configManipulator;
            return this;
        }

        @Generated
        public ScimClientConfigBuilder useLowerCaseInFilterComparators(boolean useLowerCaseInFilterComparators) {
            this.useLowerCaseInFilterComparators = useLowerCaseInFilterComparators;
            return this;
        }

        @Generated
        public ScimClientConfigBuilder expectedHttpResponseHeaders(Map<String, String> expectedHttpResponseHeaders) {
            this.expectedHttpResponseHeaders = expectedHttpResponseHeaders;
            return this;
        }

        @Generated
        public ScimClientConfigBuilder tlsVersion(String tlsVersion) {
            this.tlsVersion = tlsVersion;
            return this;
        }

        @Generated
        public ScimClientConfigBuilder httpClientBuilder(HttpClientBuilder httpClientBuilder) {
            this.httpClientBuilder = httpClientBuilder;
            return this;
        }

        @Generated
        public ScimClientConfigBuilder maxPatchOperationsPerRequest(int maxPatchOperationsPerRequest) {
            this.maxPatchOperationsPerRequest = maxPatchOperationsPerRequest;
            return this;
        }

        @Generated
        public ScimClientConfig build() {
            return new ScimClientConfig(this.requestTimeout, this.socketTimeout, this.connectTimeout, this.enableCookieManagement, this.enableAutomaticBulkRequestSplitting, this.hostnameVerifier, this.proxy, this.clientAuth, this.truststore, this.httpHeaders, this.httpMultiHeaders, this.basicAuth, this.configManipulator, this.useLowerCaseInFilterComparators, this.expectedHttpResponseHeaders, this.tlsVersion, this.httpClientBuilder, this.maxPatchOperationsPerRequest);
        }

        @Generated
        public String toString() {
            return "ScimClientConfig.ScimClientConfigBuilder(requestTimeout=" + this.requestTimeout + ", socketTimeout=" + this.socketTimeout + ", connectTimeout=" + this.connectTimeout + ", enableCookieManagement=" + this.enableCookieManagement + ", enableAutomaticBulkRequestSplitting=" + this.enableAutomaticBulkRequestSplitting + ", hostnameVerifier=" + this.hostnameVerifier + ", proxy=" + this.proxy + ", clientAuth=" + this.clientAuth + ", truststore=" + this.truststore + ", httpHeaders=" + this.httpHeaders + ", httpMultiHeaders=" + this.httpMultiHeaders + ", basicAuth=" + this.basicAuth + ", configManipulator=" + this.configManipulator + ", useLowerCaseInFilterComparators=" + this.useLowerCaseInFilterComparators + ", expectedHttpResponseHeaders=" + this.expectedHttpResponseHeaders + ", tlsVersion=" + this.tlsVersion + ", httpClientBuilder=" + this.httpClientBuilder + ", maxPatchOperationsPerRequest=" + this.maxPatchOperationsPerRequest + ")";
        }
    }
}

