// Generated by delombok at Sun Jan 12 14:49:30 CET 2025
package de.captaingoldfish.scim.sdk.client;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.net.ssl.HostnameVerifier;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.impl.client.HttpClientBuilder;
import de.captaingoldfish.scim.sdk.client.http.BasicAuth;
import de.captaingoldfish.scim.sdk.client.http.ConfigManipulator;
import de.captaingoldfish.scim.sdk.client.http.ProxyHelper;
import de.captaingoldfish.scim.sdk.client.keys.KeyStoreWrapper;


/**
 * author Pascal Knueppel <br>
 * created at: 10.12.2019 - 13:39 <br>
 * <br>
 */
public class ScimClientConfig
{

  /**
   * the default timeout value to use in seconds
   */
  public static final int DEFAULT_TIMEOUT = 10;

  /**
   * request timeout in seconds
   */
  private int requestTimeout;

  /**
   * socket timeout in seconds
   */
  private int socketTimeout;

  /**
   * connect timeout in seconds
   */
  private int connectTimeout;

  /**
   * if cookie management should be enabled or not. Default is false.
   */
  private boolean enableCookieManagement;

  /**
   * if large request operation lists should automatically be split into several requests based on the
   * maxOperations value from the service provider. Please note that a failed request in the middle of the
   * process might cause unwanted results on the server that need to be resolved manually.
   */
  private boolean enableAutomaticBulkRequestSplitting;

  /**
   * the hostname verifier that should be used in the requests
   */
  private HostnameVerifier hostnameVerifier;

  /**
   * proxy if the request must be sent through a proxy
   */
  private ProxyHelper proxy;

  /**
   * the keystore that should be used for client authentication
   */
  private KeyStoreWrapper clientAuth;

  /**
   * the truststore to trust the server
   */
  private KeyStoreWrapper truststore;

  /**
   * additional http headers that may be used to authorize at the scim server
   */
  private Map<String, String[]> httpHeaders;

  /**
   * normally SCIM responses must have set the http-header "application/scim+json". But some providers are not
   * providing these headers. If so, set this map in order to modify the check of the response headers from the
   * server. <br>
   * <ul>
   * <li>null: The headers are checked as normally for the content-type "application/scim+json"</li>
   * <li>empty map: The check of response headers is disabled</li>
   * <li>filled map: The check of the response headers will be done with the entries of this map</li>
   * </ul>
   */
  private Map<String, String> expectedHttpResponseHeaders;

  /**
   * an optional basic authentication object
   */
  private BasicAuth basicAuth;

  /**
   * may be used to manipulate the apache configuration before the http client is created
   */
  private ConfigManipulator configManipulator;

  /**
   * if the filter-expression-comparators should be sent in lowercase instead of uppercase e.g.: eq instead of
   * EQ.
   */
  private boolean useLowerCaseInFilterComparators;

  /**
   * a string value describing the TLS version that is used for SSLContexts
   */
  private String tlsVersion;

  /**
   * a {@link HttpClientBuilder} instance for custom HTTP clients
   */
  private HttpClientBuilder httpClientBuilder;

  /**
   * the maximum number of operations in a single patch requests. This can be useful if a provider is not
   * capable of handling large number of operations in a single request. Value "0" or lower indicates that there
   * is no restriction and that all operations are sent in a single request.
   */
  private int maxPatchOperationsPerRequest;

  public ScimClientConfig(Integer requestTimeout,
                          Integer socketTimeout,
                          Integer connectTimeout,
                          boolean enableCookieManagement,
                          boolean enableAutomaticBulkRequestSplitting,
                          HostnameVerifier hostnameVerifier,
                          ProxyHelper proxy,
                          KeyStoreWrapper clientAuth,
                          KeyStoreWrapper truststore,
                          Map<String, String> httpHeaders,
                          Map<String, String[]> httpMultiHeaders,
                          BasicAuth basicAuth,
                          ConfigManipulator configManipulator,
                          boolean useLowerCaseInFilterComparators,
                          Map<String, String> expectedHttpResponseHeaders,
                          String tlsVersion,
                          HttpClientBuilder httpClientBuilder,
                          int maxPatchOperationsPerRequest)
  {
    this.requestTimeout = requestTimeout == null ? DEFAULT_TIMEOUT : requestTimeout;
    this.socketTimeout = socketTimeout == null ? DEFAULT_TIMEOUT : socketTimeout;
    this.connectTimeout = connectTimeout == null ? DEFAULT_TIMEOUT : connectTimeout;
    this.enableCookieManagement = enableCookieManagement;
    this.enableAutomaticBulkRequestSplitting = enableAutomaticBulkRequestSplitting;
    this.hostnameVerifier = hostnameVerifier;
    this.proxy = proxy;
    this.clientAuth = clientAuth;
    this.truststore = truststore;
    setHeaders(httpHeaders, httpMultiHeaders);
    this.basicAuth = basicAuth;
    this.configManipulator = configManipulator;
    this.useLowerCaseInFilterComparators = useLowerCaseInFilterComparators;
    this.expectedHttpResponseHeaders = expectedHttpResponseHeaders;
    this.tlsVersion = Optional.ofNullable(tlsVersion).map(StringUtils::stripToNull).orElse("TLSv1.2");
    this.httpClientBuilder = httpClientBuilder;
    this.maxPatchOperationsPerRequest = maxPatchOperationsPerRequest;
  }

  /**
   * merges the values of the single headers map and the multi-headers map into a single map
   */
  private void setHeaders(Map<String, String> httpSingleHeaders, Map<String, String[]> httpMultiHeaders)
  {
    this.httpHeaders = new HashMap<>();
    if (httpSingleHeaders != null)
    {
      httpSingleHeaders.forEach((key, value) -> this.httpHeaders.put(key, new String[]{value}));
    }
    if (httpMultiHeaders != null)
    {
      httpMultiHeaders.forEach((key, valueArray) -> {
        String[] multiValues = this.httpHeaders.get(key);
        if (multiValues == null)
        {
          this.httpHeaders.put(key, valueArray);
        }
        else
        {
          List<String> headerList = new ArrayList<>(Arrays.asList(multiValues));
          headerList.addAll(Arrays.asList(valueArray));
          this.httpHeaders.put(key, headerList.toArray(new String[0]));
        }
      });
    }
  }

  /**
   * Get the custom HttpClientBuilder if set, get a default HttpClientBuilder otherwise.
   */
  public HttpClientBuilder getHttpClientBuilder()
  {
    return this.httpClientBuilder == null ? HttpClientBuilder.create() : this.httpClientBuilder;
  }


  /**
   * override lombok builder
   */
  public static class ScimClientConfigBuilder
  {

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private Integer requestTimeout;

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private Integer socketTimeout;

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private Integer connectTimeout;

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private boolean enableCookieManagement;

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private boolean enableAutomaticBulkRequestSplitting;

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private HostnameVerifier hostnameVerifier;

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private ProxyHelper proxy;

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private KeyStoreWrapper clientAuth;

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private KeyStoreWrapper truststore;

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private Map<String, String> httpHeaders;

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private Map<String, String[]> httpMultiHeaders;

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private BasicAuth basicAuth;

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private ConfigManipulator configManipulator;

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private boolean useLowerCaseInFilterComparators;

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private Map<String, String> expectedHttpResponseHeaders;

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private String tlsVersion;

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private HttpClientBuilder httpClientBuilder;

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private int maxPatchOperationsPerRequest;

    public ScimClientConfigBuilder basic(String username, String password)
    {
      basicAuth = BasicAuth.builder().username(username).password(password).build();
      return this;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    ScimClientConfigBuilder()
    {}

    /**
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public ScimClientConfig.ScimClientConfigBuilder requestTimeout(final Integer requestTimeout)
    {
      this.requestTimeout = requestTimeout;
      return this;
    }

    /**
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public ScimClientConfig.ScimClientConfigBuilder socketTimeout(final Integer socketTimeout)
    {
      this.socketTimeout = socketTimeout;
      return this;
    }

    /**
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public ScimClientConfig.ScimClientConfigBuilder connectTimeout(final Integer connectTimeout)
    {
      this.connectTimeout = connectTimeout;
      return this;
    }

    /**
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public ScimClientConfig.ScimClientConfigBuilder enableCookieManagement(final boolean enableCookieManagement)
    {
      this.enableCookieManagement = enableCookieManagement;
      return this;
    }

    /**
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public ScimClientConfig.ScimClientConfigBuilder enableAutomaticBulkRequestSplitting(final boolean enableAutomaticBulkRequestSplitting)
    {
      this.enableAutomaticBulkRequestSplitting = enableAutomaticBulkRequestSplitting;
      return this;
    }

    /**
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public ScimClientConfig.ScimClientConfigBuilder hostnameVerifier(final HostnameVerifier hostnameVerifier)
    {
      this.hostnameVerifier = hostnameVerifier;
      return this;
    }

    /**
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public ScimClientConfig.ScimClientConfigBuilder proxy(final ProxyHelper proxy)
    {
      this.proxy = proxy;
      return this;
    }

    /**
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public ScimClientConfig.ScimClientConfigBuilder clientAuth(final KeyStoreWrapper clientAuth)
    {
      this.clientAuth = clientAuth;
      return this;
    }

    /**
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public ScimClientConfig.ScimClientConfigBuilder truststore(final KeyStoreWrapper truststore)
    {
      this.truststore = truststore;
      return this;
    }

    /**
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public ScimClientConfig.ScimClientConfigBuilder httpHeaders(final Map<String, String> httpHeaders)
    {
      this.httpHeaders = httpHeaders;
      return this;
    }

    /**
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public ScimClientConfig.ScimClientConfigBuilder httpMultiHeaders(final Map<String, String[]> httpMultiHeaders)
    {
      this.httpMultiHeaders = httpMultiHeaders;
      return this;
    }

    /**
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public ScimClientConfig.ScimClientConfigBuilder basicAuth(final BasicAuth basicAuth)
    {
      this.basicAuth = basicAuth;
      return this;
    }

    /**
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public ScimClientConfig.ScimClientConfigBuilder configManipulator(final ConfigManipulator configManipulator)
    {
      this.configManipulator = configManipulator;
      return this;
    }

    /**
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public ScimClientConfig.ScimClientConfigBuilder useLowerCaseInFilterComparators(final boolean useLowerCaseInFilterComparators)
    {
      this.useLowerCaseInFilterComparators = useLowerCaseInFilterComparators;
      return this;
    }

    /**
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public ScimClientConfig.ScimClientConfigBuilder expectedHttpResponseHeaders(final Map<String, String> expectedHttpResponseHeaders)
    {
      this.expectedHttpResponseHeaders = expectedHttpResponseHeaders;
      return this;
    }

    /**
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public ScimClientConfig.ScimClientConfigBuilder tlsVersion(final String tlsVersion)
    {
      this.tlsVersion = tlsVersion;
      return this;
    }

    /**
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public ScimClientConfig.ScimClientConfigBuilder httpClientBuilder(final HttpClientBuilder httpClientBuilder)
    {
      this.httpClientBuilder = httpClientBuilder;
      return this;
    }

    /**
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public ScimClientConfig.ScimClientConfigBuilder maxPatchOperationsPerRequest(final int maxPatchOperationsPerRequest)
    {
      this.maxPatchOperationsPerRequest = maxPatchOperationsPerRequest;
      return this;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public ScimClientConfig build()
    {
      return new ScimClientConfig(this.requestTimeout, this.socketTimeout, this.connectTimeout,
                                  this.enableCookieManagement, this.enableAutomaticBulkRequestSplitting,
                                  this.hostnameVerifier, this.proxy, this.clientAuth, this.truststore, this.httpHeaders,
                                  this.httpMultiHeaders, this.basicAuth, this.configManipulator,
                                  this.useLowerCaseInFilterComparators, this.expectedHttpResponseHeaders,
                                  this.tlsVersion, this.httpClientBuilder, this.maxPatchOperationsPerRequest);
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public java.lang.String toString()
    {
      return "ScimClientConfig.ScimClientConfigBuilder(requestTimeout=" + this.requestTimeout + ", socketTimeout="
             + this.socketTimeout + ", connectTimeout=" + this.connectTimeout + ", enableCookieManagement="
             + this.enableCookieManagement + ", enableAutomaticBulkRequestSplitting="
             + this.enableAutomaticBulkRequestSplitting + ", hostnameVerifier=" + this.hostnameVerifier + ", proxy="
             + this.proxy + ", clientAuth=" + this.clientAuth + ", truststore=" + this.truststore + ", httpHeaders="
             + this.httpHeaders + ", httpMultiHeaders=" + this.httpMultiHeaders + ", basicAuth=" + this.basicAuth
             + ", configManipulator=" + this.configManipulator + ", useLowerCaseInFilterComparators="
             + this.useLowerCaseInFilterComparators + ", expectedHttpResponseHeaders="
             + this.expectedHttpResponseHeaders + ", tlsVersion=" + this.tlsVersion + ", httpClientBuilder="
             + this.httpClientBuilder + ", maxPatchOperationsPerRequest=" + this.maxPatchOperationsPerRequest + ")";
    }
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public static ScimClientConfig.ScimClientConfigBuilder builder()
  {
    return new ScimClientConfig.ScimClientConfigBuilder();
  }

  /**
   * request timeout in seconds
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public int getRequestTimeout()
  {
    return this.requestTimeout;
  }

  /**
   * socket timeout in seconds
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public int getSocketTimeout()
  {
    return this.socketTimeout;
  }

  /**
   * connect timeout in seconds
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public int getConnectTimeout()
  {
    return this.connectTimeout;
  }

  /**
   * if cookie management should be enabled or not. Default is false.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public boolean isEnableCookieManagement()
  {
    return this.enableCookieManagement;
  }

  /**
   * if large request operation lists should automatically be split into several requests based on the
   * maxOperations value from the service provider. Please note that a failed request in the middle of the
   * process might cause unwanted results on the server that need to be resolved manually.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public boolean isEnableAutomaticBulkRequestSplitting()
  {
    return this.enableAutomaticBulkRequestSplitting;
  }

  /**
   * the hostname verifier that should be used in the requests
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public HostnameVerifier getHostnameVerifier()
  {
    return this.hostnameVerifier;
  }

  /**
   * proxy if the request must be sent through a proxy
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public ProxyHelper getProxy()
  {
    return this.proxy;
  }

  /**
   * the keystore that should be used for client authentication
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public KeyStoreWrapper getClientAuth()
  {
    return this.clientAuth;
  }

  /**
   * the truststore to trust the server
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public KeyStoreWrapper getTruststore()
  {
    return this.truststore;
  }

  /**
   * additional http headers that may be used to authorize at the scim server
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Map<String, String[]> getHttpHeaders()
  {
    return this.httpHeaders;
  }

  /**
   * normally SCIM responses must have set the http-header "application/scim+json". But some providers are not
   * providing these headers. If so, set this map in order to modify the check of the response headers from the
   * server. <br>
   * <ul>
   * <li>null: The headers are checked as normally for the content-type "application/scim+json"</li>
   * <li>empty map: The check of response headers is disabled</li>
   * <li>filled map: The check of the response headers will be done with the entries of this map</li>
   * </ul>
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Map<String, String> getExpectedHttpResponseHeaders()
  {
    return this.expectedHttpResponseHeaders;
  }

  /**
   * an optional basic authentication object
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BasicAuth getBasicAuth()
  {
    return this.basicAuth;
  }

  /**
   * may be used to manipulate the apache configuration before the http client is created
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public ConfigManipulator getConfigManipulator()
  {
    return this.configManipulator;
  }

  /**
   * if the filter-expression-comparators should be sent in lowercase instead of uppercase e.g.: eq instead of
   * EQ.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public boolean isUseLowerCaseInFilterComparators()
  {
    return this.useLowerCaseInFilterComparators;
  }

  /**
   * a string value describing the TLS version that is used for SSLContexts
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getTlsVersion()
  {
    return this.tlsVersion;
  }

  /**
   * the maximum number of operations in a single patch requests. This can be useful if a provider is not
   * capable of handling large number of operations in a single request. Value "0" or lower indicates that there
   * is no restriction and that all operations are sent in a single request.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public int getMaxPatchOperationsPerRequest()
  {
    return this.maxPatchOperationsPerRequest;
  }

  /**
   * request timeout in seconds
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setRequestTimeout(final int requestTimeout)
  {
    this.requestTimeout = requestTimeout;
  }

  /**
   * socket timeout in seconds
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setSocketTimeout(final int socketTimeout)
  {
    this.socketTimeout = socketTimeout;
  }

  /**
   * connect timeout in seconds
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setConnectTimeout(final int connectTimeout)
  {
    this.connectTimeout = connectTimeout;
  }

  /**
   * if cookie management should be enabled or not. Default is false.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setEnableCookieManagement(final boolean enableCookieManagement)
  {
    this.enableCookieManagement = enableCookieManagement;
  }

  /**
   * if large request operation lists should automatically be split into several requests based on the
   * maxOperations value from the service provider. Please note that a failed request in the middle of the
   * process might cause unwanted results on the server that need to be resolved manually.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setEnableAutomaticBulkRequestSplitting(final boolean enableAutomaticBulkRequestSplitting)
  {
    this.enableAutomaticBulkRequestSplitting = enableAutomaticBulkRequestSplitting;
  }

  /**
   * the hostname verifier that should be used in the requests
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setHostnameVerifier(final HostnameVerifier hostnameVerifier)
  {
    this.hostnameVerifier = hostnameVerifier;
  }

  /**
   * proxy if the request must be sent through a proxy
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setProxy(final ProxyHelper proxy)
  {
    this.proxy = proxy;
  }

  /**
   * the keystore that should be used for client authentication
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setClientAuth(final KeyStoreWrapper clientAuth)
  {
    this.clientAuth = clientAuth;
  }

  /**
   * the truststore to trust the server
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setTruststore(final KeyStoreWrapper truststore)
  {
    this.truststore = truststore;
  }

  /**
   * additional http headers that may be used to authorize at the scim server
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setHttpHeaders(final Map<String, String[]> httpHeaders)
  {
    this.httpHeaders = httpHeaders;
  }

  /**
   * normally SCIM responses must have set the http-header "application/scim+json". But some providers are not
   * providing these headers. If so, set this map in order to modify the check of the response headers from the
   * server. <br>
   * <ul>
   * <li>null: The headers are checked as normally for the content-type "application/scim+json"</li>
   * <li>empty map: The check of response headers is disabled</li>
   * <li>filled map: The check of the response headers will be done with the entries of this map</li>
   * </ul>
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setExpectedHttpResponseHeaders(final Map<String, String> expectedHttpResponseHeaders)
  {
    this.expectedHttpResponseHeaders = expectedHttpResponseHeaders;
  }

  /**
   * an optional basic authentication object
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setBasicAuth(final BasicAuth basicAuth)
  {
    this.basicAuth = basicAuth;
  }

  /**
   * may be used to manipulate the apache configuration before the http client is created
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setConfigManipulator(final ConfigManipulator configManipulator)
  {
    this.configManipulator = configManipulator;
  }

  /**
   * if the filter-expression-comparators should be sent in lowercase instead of uppercase e.g.: eq instead of
   * EQ.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setUseLowerCaseInFilterComparators(final boolean useLowerCaseInFilterComparators)
  {
    this.useLowerCaseInFilterComparators = useLowerCaseInFilterComparators;
  }

  /**
   * a string value describing the TLS version that is used for SSLContexts
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setTlsVersion(final String tlsVersion)
  {
    this.tlsVersion = tlsVersion;
  }

  /**
   * a {@link HttpClientBuilder} instance for custom HTTP clients
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setHttpClientBuilder(final HttpClientBuilder httpClientBuilder)
  {
    this.httpClientBuilder = httpClientBuilder;
  }

  /**
   * the maximum number of operations in a single patch requests. This can be useful if a provider is not
   * capable of handling large number of operations in a single request. Value "0" or lower indicates that there
   * is no restriction and that all operations are sent in a single request.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setMaxPatchOperationsPerRequest(final int maxPatchOperationsPerRequest)
  {
    this.maxPatchOperationsPerRequest = maxPatchOperationsPerRequest;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public ScimClientConfig()
  {}
}
