// Generated by delombok at Tue Oct 15 15:19:09 CEST 2024
package de.captaingoldfish.scim.sdk.client.http;

import java.util.Map;


/**
 * author Pascal Knueppel <br>
 * created at: 09.12.2019 - 20:39 <br>
 * <br>
 * represents a response object that will be returned by the {@link ScimHttpClient} if a response from a
 * server was received
 */
public class HttpResponse
{

  /**
   * the status code of the response
   */
  private int httpStatusCode;

  /**
   * the body of the response
   */
  private String responseBody;

  /**
   * the headers of the response
   */
  private Map<String, String> responseHeaders;

  /**
   * Creates a new {@code HttpResponse} instance.
   *
   * @param httpStatusCode the status code of the response
   * @param responseBody the body of the response
   * @param responseHeaders the headers of the response
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  HttpResponse(final int httpStatusCode, final String responseBody, final Map<String, String> responseHeaders)
  {
    this.httpStatusCode = httpStatusCode;
    this.responseBody = responseBody;
    this.responseHeaders = responseHeaders;
  }


  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public static class HttpResponseBuilder
  {

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private int httpStatusCode;

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private String responseBody;

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private Map<String, String> responseHeaders;

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    HttpResponseBuilder()
    {}

    /**
     * the status code of the response
     * 
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public HttpResponse.HttpResponseBuilder httpStatusCode(final int httpStatusCode)
    {
      this.httpStatusCode = httpStatusCode;
      return this;
    }

    /**
     * the body of the response
     * 
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public HttpResponse.HttpResponseBuilder responseBody(final String responseBody)
    {
      this.responseBody = responseBody;
      return this;
    }

    /**
     * the headers of the response
     * 
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public HttpResponse.HttpResponseBuilder responseHeaders(final Map<String, String> responseHeaders)
    {
      this.responseHeaders = responseHeaders;
      return this;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public HttpResponse build()
    {
      return new HttpResponse(this.httpStatusCode, this.responseBody, this.responseHeaders);
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public java.lang.String toString()
    {
      return "HttpResponse.HttpResponseBuilder(httpStatusCode=" + this.httpStatusCode + ", responseBody="
             + this.responseBody + ", responseHeaders=" + this.responseHeaders + ")";
    }
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public static HttpResponse.HttpResponseBuilder builder()
  {
    return new HttpResponse.HttpResponseBuilder();
  }

  /**
   * the status code of the response
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public int getHttpStatusCode()
  {
    return this.httpStatusCode;
  }

  /**
   * the body of the response
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getResponseBody()
  {
    return this.responseBody;
  }

  /**
   * the headers of the response
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Map<String, String> getResponseHeaders()
  {
    return this.responseHeaders;
  }
}
