/*
 * Decompiled with CFR 0.152.
 */
package de.captaingoldfish.scim.sdk.client.http;

import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProxyHelper {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ProxyHelper.class);
    private String systemProxyHost;
    private int systemProxyPort;
    private String systemProxyUsername;
    private String systemProxyPassword;

    public boolean isProxySet() {
        return StringUtils.isNotBlank((CharSequence)this.systemProxyHost) && this.systemProxyPort != 0;
    }

    public CredentialsProvider getProxyCredentials() {
        if (StringUtils.isBlank((CharSequence)this.getSystemProxyUsername())) {
            log.trace("Proxy username is empty cannot create client credentials");
            return null;
        }
        if (this.getSystemProxyPassword() == null) {
            log.debug("Proxy password is null cannot create client credentials");
            return null;
        }
        BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
        credentialsProvider.setCredentials(new AuthScope(this.getSystemProxyHost(), this.systemProxyPort), (Credentials)new UsernamePasswordCredentials(this.getSystemProxyUsername(), this.getSystemProxyPassword()));
        return credentialsProvider;
    }

    public RequestConfig getProxyConfig() {
        if (StringUtils.isNotBlank((CharSequence)this.systemProxyHost)) {
            HttpHost systemProxy = new HttpHost(this.systemProxyHost, this.systemProxyPort);
            log.debug("Using proxy configuration: {}", (Object)systemProxy);
            return RequestConfig.custom().setProxy(systemProxy).build();
        }
        return RequestConfig.DEFAULT;
    }

    public String getProxyAddress() {
        return this.getSystemProxyHost() + ":" + this.getSystemProxyPort();
    }

    @Generated
    public static ProxyHelperBuilder builder() {
        return new ProxyHelperBuilder();
    }

    @Generated
    public String getSystemProxyHost() {
        return this.systemProxyHost;
    }

    @Generated
    public int getSystemProxyPort() {
        return this.systemProxyPort;
    }

    @Generated
    public String getSystemProxyUsername() {
        return this.systemProxyUsername;
    }

    @Generated
    public String getSystemProxyPassword() {
        return this.systemProxyPassword;
    }

    @Generated
    public void setSystemProxyHost(String systemProxyHost) {
        this.systemProxyHost = systemProxyHost;
    }

    @Generated
    public void setSystemProxyPort(int systemProxyPort) {
        this.systemProxyPort = systemProxyPort;
    }

    @Generated
    public void setSystemProxyUsername(String systemProxyUsername) {
        this.systemProxyUsername = systemProxyUsername;
    }

    @Generated
    public void setSystemProxyPassword(String systemProxyPassword) {
        this.systemProxyPassword = systemProxyPassword;
    }

    @Generated
    public ProxyHelper(String systemProxyHost, int systemProxyPort, String systemProxyUsername, String systemProxyPassword) {
        this.systemProxyHost = systemProxyHost;
        this.systemProxyPort = systemProxyPort;
        this.systemProxyUsername = systemProxyUsername;
        this.systemProxyPassword = systemProxyPassword;
    }

    public static class ProxyHelperBuilder {
        @Generated
        private String systemProxyHost;
        @Generated
        private int systemProxyPort;
        @Generated
        private String systemProxyUsername;
        @Generated
        private String systemProxyPassword;

        public ProxyHelperBuilder systemProxyPort(int systemProxyPort) {
            this.systemProxyPort = systemProxyPort;
            return this;
        }

        public ProxyHelperBuilder systemProxyPort(String systemProxyPort) {
            if (StringUtils.isBlank((CharSequence)systemProxyPort) || !systemProxyPort.matches("\\d+")) {
                throw new IllegalArgumentException("Port must not be empty and must contain only numbers but is: " + systemProxyPort + "\n Set Port to '0' if proxy is not required.");
            }
            this.systemProxyPort = Integer.parseInt(systemProxyPort);
            return this;
        }

        @Generated
        public ProxyHelperBuilder systemProxyHost(String systemProxyHost) {
            this.systemProxyHost = systemProxyHost;
            return this;
        }

        @Generated
        public ProxyHelperBuilder systemProxyUsername(String systemProxyUsername) {
            this.systemProxyUsername = systemProxyUsername;
            return this;
        }

        @Generated
        public ProxyHelperBuilder systemProxyPassword(String systemProxyPassword) {
            this.systemProxyPassword = systemProxyPassword;
            return this;
        }

        @Generated
        public ProxyHelper build() {
            return new ProxyHelper(this.systemProxyHost, this.systemProxyPort, this.systemProxyUsername, this.systemProxyPassword);
        }

        @Generated
        public String toString() {
            return "ProxyHelper.ProxyHelperBuilder(systemProxyHost=" + this.systemProxyHost + ", systemProxyPort=" + this.systemProxyPort + ", systemProxyUsername=" + this.systemProxyUsername + ", systemProxyPassword=" + this.systemProxyPassword + ")";
        }
    }
}

