/*
 * Decompiled with CFR 0.152.
 */
package de.captaingoldfish.scim.sdk.client.builder;

import com.fasterxml.jackson.databind.JsonNode;
import de.captaingoldfish.scim.sdk.client.builder.ETagRequestBuilder;
import de.captaingoldfish.scim.sdk.client.http.ScimHttpClient;
import de.captaingoldfish.scim.sdk.common.etag.ETag;
import de.captaingoldfish.scim.sdk.common.resources.ResourceNode;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;

public class UpdateBuilder<T extends ResourceNode>
extends ETagRequestBuilder<T> {
    private final String fullUrl;

    public UpdateBuilder(String fullUrl, Class<T> responseEntityType, ScimHttpClient scimHttpClient) {
        super(responseEntityType, scimHttpClient);
        this.fullUrl = fullUrl;
    }

    public UpdateBuilder(String baseUrl, String endpoint, String resourceId, Class<T> responseEntityType, ScimHttpClient scimHttpClient) {
        super(baseUrl, endpoint + (StringUtils.isBlank((CharSequence)resourceId) ? "" : "/" + resourceId), responseEntityType, scimHttpClient);
        this.fullUrl = null;
    }

    @Override
    public UpdateBuilder<T> setExpectedResponseHeaders(Map<String, String> requiredResponseHeaders) {
        return (UpdateBuilder)super.setExpectedResponseHeaders(requiredResponseHeaders);
    }

    @Override
    public UpdateBuilder<T> setResource(String resource) {
        return (UpdateBuilder)super.setResource(resource);
    }

    @Override
    public UpdateBuilder<T> setResource(JsonNode resource) {
        return (UpdateBuilder)super.setResource(resource);
    }

    @Override
    public UpdateBuilder<T> setETagForIfMatch(String version) {
        return (UpdateBuilder)super.setETagForIfMatch(version);
    }

    @Override
    public UpdateBuilder<T> setETagForIfNoneMatch(String version) {
        return (UpdateBuilder)super.setETagForIfNoneMatch(version);
    }

    @Override
    public UpdateBuilder<T> setETagForIfMatch(ETag version) {
        return (UpdateBuilder)super.setETagForIfMatch(version);
    }

    @Override
    public UpdateBuilder<T> setETagForIfNoneMatch(ETag version) {
        return (UpdateBuilder)super.setETagForIfNoneMatch(version);
    }

    @Override
    protected boolean isExpectedResponseCode(int httpStatus) {
        return 200 == httpStatus;
    }

    @Override
    protected HttpUriRequest getHttpUriRequest() {
        HttpPut httpPut = StringUtils.isBlank((CharSequence)this.fullUrl) ? new HttpPut(this.getBaseUrl() + this.getEndpoint()) : new HttpPut(this.fullUrl);
        if (StringUtils.isBlank((CharSequence)this.getResource())) {
            throw new IllegalArgumentException("resource for update request must not be empty");
        }
        StringEntity stringEntity = new StringEntity(this.getResource(), StandardCharsets.UTF_8);
        httpPut.setEntity((HttpEntity)stringEntity);
        if (this.isUseIfMatch()) {
            httpPut.setHeader("If-Match", this.getVersion().toString());
        }
        if (this.isUseIfNoneMatch()) {
            httpPut.setHeader("If-None-Match", this.getVersion().toString());
        }
        return httpPut;
    }
}

