/*
 * Decompiled with CFR 0.152.
 */
package de.captaingoldfish.scim.sdk.client.builder;

import de.captaingoldfish.scim.sdk.client.builder.GetBuilder;
import de.captaingoldfish.scim.sdk.client.builder.ListBuilder;
import de.captaingoldfish.scim.sdk.client.builder.RequestBuilder;
import de.captaingoldfish.scim.sdk.client.builder.config.MetaConfigRequestDetails;
import de.captaingoldfish.scim.sdk.client.http.HttpResponse;
import de.captaingoldfish.scim.sdk.client.http.ScimHttpClient;
import de.captaingoldfish.scim.sdk.client.resources.MetaConfiguration;
import de.captaingoldfish.scim.sdk.client.resources.ResourceType;
import de.captaingoldfish.scim.sdk.client.response.ServerResponse;
import de.captaingoldfish.scim.sdk.common.constants.enums.Comparator;
import de.captaingoldfish.scim.sdk.common.resources.ServiceProvider;
import de.captaingoldfish.scim.sdk.common.response.ListResponse;
import de.captaingoldfish.scim.sdk.common.schemas.Schema;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.apache.http.client.methods.HttpUriRequest;

public class MetaConfigLoaderBuilder
extends RequestBuilder<MetaConfiguration> {
    private final MetaConfigRequestDetails metaConfigLoaderDetails;
    private GetBuilder<ServiceProvider> serviceProviderLoaderBuilder;
    private ListBuilder<ResourceType> resourceTypeLoaderBuilder;
    private ListBuilder<Schema> schemaLoaderBuilder;

    public MetaConfigLoaderBuilder(String baseUrl, ScimHttpClient scimHttpClient, MetaConfigRequestDetails metaConfigLoaderDetails) {
        super(null, null, null, null);
        this.serviceProviderLoaderBuilder = new GetBuilder<ServiceProvider>(baseUrl, metaConfigLoaderDetails.getServiceProviderEndpoint(), null, ServiceProvider.class, scimHttpClient);
        this.resourceTypeLoaderBuilder = new ListBuilder<ResourceType>(baseUrl, metaConfigLoaderDetails.getResourceTypeEndpoint(), ResourceType.class, scimHttpClient);
        this.schemaLoaderBuilder = new ListBuilder<Schema>(baseUrl, metaConfigLoaderDetails.getSchemasEndpoint(), Schema.class, scimHttpClient);
        this.metaConfigLoaderDetails = metaConfigLoaderDetails;
    }

    @Override
    protected boolean isExpectedResponseCode(int httpStatus) {
        return 200 == httpStatus;
    }

    @Override
    protected HttpUriRequest getHttpUriRequest() {
        return null;
    }

    @Override
    public ServerResponse<MetaConfiguration> sendRequest() {
        List resourceTypeList;
        List schemaList;
        int statusCode;
        ServerResponse<ServiceProvider> serviceProviderResponse = this.serviceProviderLoaderBuilder.sendRequest();
        ServerResponse<ListResponse<ResourceType>> resourceTypeResponse = this.loadResourceTypes(serviceProviderResponse);
        ServerResponse<ListResponse<Schema>> schemasResponse = this.loadSchemas(serviceProviderResponse);
        HttpResponse.HttpResponseBuilder httpResponseBuilder = HttpResponse.builder();
        if (!serviceProviderResponse.isSuccess()) {
            statusCode = serviceProviderResponse.getHttpStatus();
            httpResponseBuilder.responseBody(serviceProviderResponse.getResponseBody());
        } else if (!resourceTypeResponse.isSuccess()) {
            statusCode = resourceTypeResponse.getHttpStatus();
            httpResponseBuilder.responseBody(resourceTypeResponse.getResponseBody());
        } else if (!schemasResponse.isSuccess()) {
            statusCode = schemasResponse.getHttpStatus();
            httpResponseBuilder.responseBody(schemasResponse.getResponseBody());
        } else {
            statusCode = 200;
        }
        httpResponseBuilder.httpStatusCode(statusCode);
        boolean isExpectedResponseCode = this.isExpectedResponseCode(statusCode);
        if (this.metaConfigLoaderDetails.isExcludeMetaSchemas() && schemasResponse.isSuccess()) {
            ListResponse<Schema> schemaListResponse = schemasResponse.getResource();
            schemaList = schemaListResponse.getListedResources();
            schemaList.removeIf(schema -> this.metaConfigLoaderDetails.getMetaSchemaUris().contains(schema.getNonNullId()));
        } else {
            List list = schemaList = schemasResponse.isSuccess() ? schemasResponse.getResource().getListedResources() : null;
        }
        if (this.metaConfigLoaderDetails.isExcludeMetaResourceTypes() && resourceTypeResponse.isSuccess()) {
            ListResponse<ResourceType> resourceTypeListResponse = resourceTypeResponse.getResource();
            resourceTypeList = resourceTypeListResponse.getListedResources();
            resourceTypeList.removeIf(resourceType -> this.metaConfigLoaderDetails.getMetaResourceTypeNames().contains(resourceType.getName()));
        } else {
            resourceTypeList = resourceTypeResponse.isSuccess() ? resourceTypeResponse.getResource().getListedResources() : null;
        }
        MetaConfiguration metaConfiguration = MetaConfiguration.builder().serviceProvider(serviceProviderResponse.getResource()).resourceTypes(resourceTypeList).schemas(schemaList).build();
        return new ServerResponse<MetaConfiguration>(httpResponseBuilder.build(), isExpectedResponseCode, metaConfiguration);
    }

    private ServerResponse<ListResponse<ResourceType>> loadResourceTypes(ServerResponse<ServiceProvider> serviceProviderResponse) {
        ServiceProvider serviceProvider = serviceProviderResponse.getResource();
        if (this.metaConfigLoaderDetails.isExcludeMetaResourceTypes() && serviceProviderResponse.isSuccess() && serviceProvider.getFilterConfig().isSupported()) {
            ListBuilder.FilterBuilder<ResourceType> filterBuilder = null;
            for (String metaResourceTypeEndpoint : this.metaConfigLoaderDetails.getMetaResourceTypeNames()) {
                if (filterBuilder == null) {
                    filterBuilder = this.resourceTypeLoaderBuilder.filter(true, "name", Comparator.NE, metaResourceTypeEndpoint).or("id", Comparator.NE, metaResourceTypeEndpoint, true);
                    continue;
                }
                filterBuilder.and(true, "name", Comparator.NE, metaResourceTypeEndpoint).or("id", Comparator.NE, metaResourceTypeEndpoint, true);
            }
            return Optional.ofNullable(filterBuilder).map(ListBuilder.FilterBuilder::build).orElse(this.resourceTypeLoaderBuilder).get().getAll();
        }
        return this.resourceTypeLoaderBuilder.get().getAll();
    }

    private ServerResponse<ListResponse<Schema>> loadSchemas(ServerResponse<ServiceProvider> serviceProviderResponse) {
        ServiceProvider serviceProvider = serviceProviderResponse.getResource();
        if (this.metaConfigLoaderDetails.isExcludeMetaSchemas() && serviceProviderResponse.isSuccess() && serviceProvider.getFilterConfig().isSupported()) {
            ListBuilder.FilterBuilder<Schema> filterBuilder = null;
            for (String metaSchemaUri : this.metaConfigLoaderDetails.getMetaSchemaUris()) {
                if (filterBuilder == null) {
                    filterBuilder = this.schemaLoaderBuilder.filter("id", Comparator.NE, metaSchemaUri);
                    continue;
                }
                filterBuilder.and("id", Comparator.NE, metaSchemaUri);
            }
            return Optional.ofNullable(filterBuilder).map(ListBuilder.FilterBuilder::build).orElse(this.schemaLoaderBuilder).get().getAll();
        }
        return this.schemaLoaderBuilder.get().getAll();
    }

    @Generated
    GetBuilder<ServiceProvider> getServiceProviderLoaderBuilder() {
        return this.serviceProviderLoaderBuilder;
    }

    @Generated
    void setServiceProviderLoaderBuilder(GetBuilder<ServiceProvider> serviceProviderLoaderBuilder) {
        this.serviceProviderLoaderBuilder = serviceProviderLoaderBuilder;
    }

    @Generated
    ListBuilder<ResourceType> getResourceTypeLoaderBuilder() {
        return this.resourceTypeLoaderBuilder;
    }

    @Generated
    void setResourceTypeLoaderBuilder(ListBuilder<ResourceType> resourceTypeLoaderBuilder) {
        this.resourceTypeLoaderBuilder = resourceTypeLoaderBuilder;
    }

    @Generated
    ListBuilder<Schema> getSchemaLoaderBuilder() {
        return this.schemaLoaderBuilder;
    }

    @Generated
    void setSchemaLoaderBuilder(ListBuilder<Schema> schemaLoaderBuilder) {
        this.schemaLoaderBuilder = schemaLoaderBuilder;
    }
}

