/*
 * Decompiled with CFR 0.152.
 */
package de.captaingoldfish.scim.sdk.client.builder;

import de.captaingoldfish.scim.sdk.client.builder.ETagRequestBuilder;
import de.captaingoldfish.scim.sdk.client.http.ScimHttpClient;
import de.captaingoldfish.scim.sdk.common.etag.ETag;
import de.captaingoldfish.scim.sdk.common.resources.ResourceNode;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;

public class GetBuilder<T extends ResourceNode>
extends ETagRequestBuilder<T> {
    private final String fullUrl;

    public GetBuilder(String fullUrl, Class<T> responseEntityType, ScimHttpClient scimHttpClient) {
        super(responseEntityType, scimHttpClient);
        this.fullUrl = fullUrl;
    }

    public GetBuilder(String baseUrl, String endpoint, String resourceId, Class<T> responseEntityType, ScimHttpClient scimHttpClient) {
        super(baseUrl, endpoint + (StringUtils.isBlank((CharSequence)resourceId) ? "" : "/" + resourceId), responseEntityType, scimHttpClient);
        this.fullUrl = null;
    }

    @Override
    public GetBuilder<T> setExpectedResponseHeaders(Map<String, String> requiredResponseHeaders) {
        return (GetBuilder)super.setExpectedResponseHeaders(requiredResponseHeaders);
    }

    @Override
    public GetBuilder<T> setETagForIfMatch(String version) {
        return (GetBuilder)super.setETagForIfMatch(version);
    }

    @Override
    public GetBuilder<T> setETagForIfNoneMatch(String version) {
        return (GetBuilder)super.setETagForIfNoneMatch(version);
    }

    @Override
    public GetBuilder<T> setETagForIfMatch(ETag version) {
        return (GetBuilder)super.setETagForIfMatch(version);
    }

    @Override
    public GetBuilder<T> setETagForIfNoneMatch(ETag version) {
        return (GetBuilder)super.setETagForIfNoneMatch(version);
    }

    @Override
    protected boolean isExpectedResponseCode(int httpStatus) {
        return 200 == httpStatus;
    }

    @Override
    protected HttpUriRequest getHttpUriRequest() {
        HttpGet httpGet = StringUtils.isBlank((CharSequence)this.fullUrl) ? new HttpGet(this.getBaseUrl() + this.getEndpoint()) : new HttpGet(this.fullUrl);
        if (this.isUseIfMatch()) {
            httpGet.setHeader("If-Match", this.getVersion().toString());
        }
        if (this.isUseIfNoneMatch()) {
            httpGet.setHeader("If-None-Match", this.getVersion().toString());
        }
        return httpGet;
    }
}

