/*
 * Decompiled with CFR 0.152.
 */
package de.captaingoldfish.scim.sdk.client.http;

import java.util.Map;

public class HttpResponse {
    private int httpStatusCode;
    private String responseBody;
    private Map<String, String> responseHeaders;

    HttpResponse(int httpStatusCode, String responseBody, Map<String, String> responseHeaders) {
        this.httpStatusCode = httpStatusCode;
        this.responseBody = responseBody;
        this.responseHeaders = responseHeaders;
    }

    public static HttpResponseBuilder builder() {
        return new HttpResponseBuilder();
    }

    public int getHttpStatusCode() {
        return this.httpStatusCode;
    }

    public String getResponseBody() {
        return this.responseBody;
    }

    public Map<String, String> getResponseHeaders() {
        return this.responseHeaders;
    }

    public static class HttpResponseBuilder {
        private int httpStatusCode;
        private String responseBody;
        private Map<String, String> responseHeaders;

        HttpResponseBuilder() {
        }

        public HttpResponseBuilder httpStatusCode(int httpStatusCode) {
            this.httpStatusCode = httpStatusCode;
            return this;
        }

        public HttpResponseBuilder responseBody(String responseBody) {
            this.responseBody = responseBody;
            return this;
        }

        public HttpResponseBuilder responseHeaders(Map<String, String> responseHeaders) {
            this.responseHeaders = responseHeaders;
            return this;
        }

        public HttpResponse build() {
            return new HttpResponse(this.httpStatusCode, this.responseBody, this.responseHeaders);
        }

        public String toString() {
            return "HttpResponse.HttpResponseBuilder(httpStatusCode=" + this.httpStatusCode + ", responseBody=" + this.responseBody + ", responseHeaders=" + this.responseHeaders + ")";
        }
    }
}

