/*
 * Decompiled with CFR 0.152.
 */
package de.captaingoldfish.scim.sdk.client;

import de.captaingoldfish.scim.sdk.client.http.BasicAuth;
import de.captaingoldfish.scim.sdk.client.http.ConfigManipulator;
import de.captaingoldfish.scim.sdk.client.http.ProxyHelper;
import de.captaingoldfish.scim.sdk.client.keys.KeyStoreWrapper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.net.ssl.HostnameVerifier;
import org.apache.commons.lang3.StringUtils;

public class ScimClientConfig {
    public static final int DEFAULT_TIMEOUT = 10;
    private int requestTimeout;
    private int socketTimeout;
    private int connectTimeout;
    private boolean enableCookieManagement;
    private boolean enableAutomaticBulkRequestSplitting;
    private HostnameVerifier hostnameVerifier;
    private ProxyHelper proxy;
    private KeyStoreWrapper clientAuth;
    private KeyStoreWrapper truststore;
    private Map<String, String[]> httpHeaders;
    private Map<String, String> expectedHttpResponseHeaders;
    private BasicAuth basicAuth;
    private ConfigManipulator configManipulator;
    private boolean useLowerCaseInFilterComparators;
    private String tlsVersion;

    public ScimClientConfig(Integer requestTimeout, Integer socketTimeout, Integer connectTimeout, boolean enableCookieManagement, boolean enableAutomaticBulkRequestSplitting, HostnameVerifier hostnameVerifier, ProxyHelper proxy, KeyStoreWrapper clientAuth, KeyStoreWrapper truststore, Map<String, String> httpHeaders, Map<String, String[]> httpMultiHeaders, BasicAuth basicAuth, ConfigManipulator configManipulator, boolean useLowerCaseInFilterComparators, Map<String, String> expectedHttpResponseHeaders, String tlsVersion) {
        this.requestTimeout = requestTimeout == null ? 10 : requestTimeout;
        this.socketTimeout = socketTimeout == null ? 10 : socketTimeout;
        this.connectTimeout = connectTimeout == null ? 10 : connectTimeout;
        this.enableCookieManagement = enableCookieManagement;
        this.enableAutomaticBulkRequestSplitting = enableAutomaticBulkRequestSplitting;
        this.hostnameVerifier = hostnameVerifier;
        this.proxy = proxy;
        this.clientAuth = clientAuth;
        this.truststore = truststore;
        this.setHeaders(httpHeaders, httpMultiHeaders);
        this.basicAuth = basicAuth;
        this.configManipulator = configManipulator;
        this.useLowerCaseInFilterComparators = useLowerCaseInFilterComparators;
        this.expectedHttpResponseHeaders = expectedHttpResponseHeaders;
        this.tlsVersion = Optional.ofNullable(tlsVersion).map(StringUtils::stripToNull).orElse("TLSv1.2");
    }

    private void setHeaders(Map<String, String> httpSingleHeaders, Map<String, String[]> httpMultiHeaders) {
        this.httpHeaders = new HashMap<String, String[]>();
        if (httpSingleHeaders != null) {
            httpSingleHeaders.forEach((key, value) -> this.httpHeaders.put((String)key, new String[]{value}));
        }
        if (httpMultiHeaders != null) {
            httpMultiHeaders.forEach((key, valueArray) -> {
                String[] multiValues = this.httpHeaders.get(key);
                if (multiValues == null) {
                    this.httpHeaders.put((String)key, (String[])valueArray);
                } else {
                    ArrayList<String> headerList = new ArrayList<String>(Arrays.asList(multiValues));
                    headerList.addAll(Arrays.asList(valueArray));
                    this.httpHeaders.put((String)key, headerList.toArray(new String[0]));
                }
            });
        }
    }

    public static ScimClientConfigBuilder builder() {
        return new ScimClientConfigBuilder();
    }

    public int getRequestTimeout() {
        return this.requestTimeout;
    }

    public int getSocketTimeout() {
        return this.socketTimeout;
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    public boolean isEnableCookieManagement() {
        return this.enableCookieManagement;
    }

    public boolean isEnableAutomaticBulkRequestSplitting() {
        return this.enableAutomaticBulkRequestSplitting;
    }

    public HostnameVerifier getHostnameVerifier() {
        return this.hostnameVerifier;
    }

    public ProxyHelper getProxy() {
        return this.proxy;
    }

    public KeyStoreWrapper getClientAuth() {
        return this.clientAuth;
    }

    public KeyStoreWrapper getTruststore() {
        return this.truststore;
    }

    public Map<String, String[]> getHttpHeaders() {
        return this.httpHeaders;
    }

    public Map<String, String> getExpectedHttpResponseHeaders() {
        return this.expectedHttpResponseHeaders;
    }

    public BasicAuth getBasicAuth() {
        return this.basicAuth;
    }

    public ConfigManipulator getConfigManipulator() {
        return this.configManipulator;
    }

    public boolean isUseLowerCaseInFilterComparators() {
        return this.useLowerCaseInFilterComparators;
    }

    public String getTlsVersion() {
        return this.tlsVersion;
    }

    public void setRequestTimeout(int requestTimeout) {
        this.requestTimeout = requestTimeout;
    }

    public void setSocketTimeout(int socketTimeout) {
        this.socketTimeout = socketTimeout;
    }

    public void setConnectTimeout(int connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    public void setEnableCookieManagement(boolean enableCookieManagement) {
        this.enableCookieManagement = enableCookieManagement;
    }

    public void setEnableAutomaticBulkRequestSplitting(boolean enableAutomaticBulkRequestSplitting) {
        this.enableAutomaticBulkRequestSplitting = enableAutomaticBulkRequestSplitting;
    }

    public void setHostnameVerifier(HostnameVerifier hostnameVerifier) {
        this.hostnameVerifier = hostnameVerifier;
    }

    public void setProxy(ProxyHelper proxy) {
        this.proxy = proxy;
    }

    public void setClientAuth(KeyStoreWrapper clientAuth) {
        this.clientAuth = clientAuth;
    }

    public void setTruststore(KeyStoreWrapper truststore) {
        this.truststore = truststore;
    }

    public void setHttpHeaders(Map<String, String[]> httpHeaders) {
        this.httpHeaders = httpHeaders;
    }

    public void setExpectedHttpResponseHeaders(Map<String, String> expectedHttpResponseHeaders) {
        this.expectedHttpResponseHeaders = expectedHttpResponseHeaders;
    }

    public void setBasicAuth(BasicAuth basicAuth) {
        this.basicAuth = basicAuth;
    }

    public void setConfigManipulator(ConfigManipulator configManipulator) {
        this.configManipulator = configManipulator;
    }

    public void setUseLowerCaseInFilterComparators(boolean useLowerCaseInFilterComparators) {
        this.useLowerCaseInFilterComparators = useLowerCaseInFilterComparators;
    }

    public void setTlsVersion(String tlsVersion) {
        this.tlsVersion = tlsVersion;
    }

    public ScimClientConfig() {
    }

    public static class ScimClientConfigBuilder {
        private Integer requestTimeout;
        private Integer socketTimeout;
        private Integer connectTimeout;
        private boolean enableCookieManagement;
        private boolean enableAutomaticBulkRequestSplitting;
        private HostnameVerifier hostnameVerifier;
        private ProxyHelper proxy;
        private KeyStoreWrapper clientAuth;
        private KeyStoreWrapper truststore;
        private Map<String, String> httpHeaders;
        private Map<String, String[]> httpMultiHeaders;
        private BasicAuth basicAuth;
        private ConfigManipulator configManipulator;
        private boolean useLowerCaseInFilterComparators;
        private Map<String, String> expectedHttpResponseHeaders;
        private String tlsVersion;

        public ScimClientConfigBuilder basic(String username, String password) {
            this.basicAuth = BasicAuth.builder().username(username).password(password).build();
            return this;
        }

        ScimClientConfigBuilder() {
        }

        public ScimClientConfigBuilder requestTimeout(Integer requestTimeout) {
            this.requestTimeout = requestTimeout;
            return this;
        }

        public ScimClientConfigBuilder socketTimeout(Integer socketTimeout) {
            this.socketTimeout = socketTimeout;
            return this;
        }

        public ScimClientConfigBuilder connectTimeout(Integer connectTimeout) {
            this.connectTimeout = connectTimeout;
            return this;
        }

        public ScimClientConfigBuilder enableCookieManagement(boolean enableCookieManagement) {
            this.enableCookieManagement = enableCookieManagement;
            return this;
        }

        public ScimClientConfigBuilder enableAutomaticBulkRequestSplitting(boolean enableAutomaticBulkRequestSplitting) {
            this.enableAutomaticBulkRequestSplitting = enableAutomaticBulkRequestSplitting;
            return this;
        }

        public ScimClientConfigBuilder hostnameVerifier(HostnameVerifier hostnameVerifier) {
            this.hostnameVerifier = hostnameVerifier;
            return this;
        }

        public ScimClientConfigBuilder proxy(ProxyHelper proxy) {
            this.proxy = proxy;
            return this;
        }

        public ScimClientConfigBuilder clientAuth(KeyStoreWrapper clientAuth) {
            this.clientAuth = clientAuth;
            return this;
        }

        public ScimClientConfigBuilder truststore(KeyStoreWrapper truststore) {
            this.truststore = truststore;
            return this;
        }

        public ScimClientConfigBuilder httpHeaders(Map<String, String> httpHeaders) {
            this.httpHeaders = httpHeaders;
            return this;
        }

        public ScimClientConfigBuilder httpMultiHeaders(Map<String, String[]> httpMultiHeaders) {
            this.httpMultiHeaders = httpMultiHeaders;
            return this;
        }

        public ScimClientConfigBuilder basicAuth(BasicAuth basicAuth) {
            this.basicAuth = basicAuth;
            return this;
        }

        public ScimClientConfigBuilder configManipulator(ConfigManipulator configManipulator) {
            this.configManipulator = configManipulator;
            return this;
        }

        public ScimClientConfigBuilder useLowerCaseInFilterComparators(boolean useLowerCaseInFilterComparators) {
            this.useLowerCaseInFilterComparators = useLowerCaseInFilterComparators;
            return this;
        }

        public ScimClientConfigBuilder expectedHttpResponseHeaders(Map<String, String> expectedHttpResponseHeaders) {
            this.expectedHttpResponseHeaders = expectedHttpResponseHeaders;
            return this;
        }

        public ScimClientConfigBuilder tlsVersion(String tlsVersion) {
            this.tlsVersion = tlsVersion;
            return this;
        }

        public ScimClientConfig build() {
            return new ScimClientConfig(this.requestTimeout, this.socketTimeout, this.connectTimeout, this.enableCookieManagement, this.enableAutomaticBulkRequestSplitting, this.hostnameVerifier, this.proxy, this.clientAuth, this.truststore, this.httpHeaders, this.httpMultiHeaders, this.basicAuth, this.configManipulator, this.useLowerCaseInFilterComparators, this.expectedHttpResponseHeaders, this.tlsVersion);
        }

        public String toString() {
            return "ScimClientConfig.ScimClientConfigBuilder(requestTimeout=" + this.requestTimeout + ", socketTimeout=" + this.socketTimeout + ", connectTimeout=" + this.connectTimeout + ", enableCookieManagement=" + this.enableCookieManagement + ", enableAutomaticBulkRequestSplitting=" + this.enableAutomaticBulkRequestSplitting + ", hostnameVerifier=" + this.hostnameVerifier + ", proxy=" + this.proxy + ", clientAuth=" + this.clientAuth + ", truststore=" + this.truststore + ", httpHeaders=" + this.httpHeaders + ", httpMultiHeaders=" + this.httpMultiHeaders + ", basicAuth=" + this.basicAuth + ", configManipulator=" + this.configManipulator + ", useLowerCaseInFilterComparators=" + this.useLowerCaseInFilterComparators + ", expectedHttpResponseHeaders=" + this.expectedHttpResponseHeaders + ", tlsVersion=" + this.tlsVersion + ")";
        }
    }
}

