/*
 * Decompiled with CFR 0.152.
 */
package de.captaingoldfish.scim.sdk.client.builder.config;

import de.captaingoldfish.scim.sdk.common.resources.ServiceProvider;
import de.captaingoldfish.scim.sdk.common.resources.complex.FilterConfig;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;

public class MetaConfigRequestDetails {
    public static final List<String> DEFAULT_META_SCHEMA_URIS = Arrays.asList("urn:ietf:params:scim:schemas:core:2.0:Meta", "urn:ietf:params:scim:schemas:core:2.0:ServiceProviderConfig", "urn:ietf:params:scim:schemas:core:2.0:ResourceType", "urn:gold:params:scim:schemas:extension:url:2.0:ResourceTypeFeatures", "urn:ietf:params:scim:schemas:core:2.0:Schema");
    public static final List<String> DEFAULT_META_RESOURCE_TYPES_NAMES = Arrays.asList("ServiceProviderConfig", "ResourceType", "Schema");
    private final String serviceProviderEndpoint;
    private final String resourceTypeEndpoint;
    private final String schemasEndpoint;
    private final boolean excludeMetaSchemas;
    private final boolean excludeMetaResourceTypes;
    private final List<String> metaResourceTypeNames;
    private final List<String> metaSchemaUris;
    private final Function<ServiceProvider, Integer> maxCountPerRequest;

    public MetaConfigRequestDetails() {
        this.serviceProviderEndpoint = "/ServiceProviderConfig";
        this.resourceTypeEndpoint = "/ResourceTypes";
        this.schemasEndpoint = "/Schemas";
        this.excludeMetaSchemas = false;
        this.excludeMetaResourceTypes = false;
        this.metaResourceTypeNames = DEFAULT_META_RESOURCE_TYPES_NAMES;
        this.metaSchemaUris = DEFAULT_META_SCHEMA_URIS;
        this.maxCountPerRequest = serviceProvider -> Optional.ofNullable(serviceProvider).map(ServiceProvider::getFilterConfig).map(FilterConfig::getMaxResults).orElse(50);
    }

    public MetaConfigRequestDetails(String serviceProviderEndpoint, String resourceTypeEndpoint, String schemasEndpoint, boolean excludeMetaSchemas, boolean excludeMetaResourceTypes, List<String> metaSchemaUris, List<String> metaResourceTypeNames, Function<ServiceProvider, Integer> maxCountPerRequest) {
        this.serviceProviderEndpoint = Optional.ofNullable(serviceProviderEndpoint).orElse("/ServiceProviderConfig");
        this.resourceTypeEndpoint = Optional.ofNullable(resourceTypeEndpoint).orElse("/ResourceTypes");
        this.schemasEndpoint = Optional.ofNullable(schemasEndpoint).orElse("/Schemas");
        this.excludeMetaSchemas = excludeMetaSchemas;
        this.excludeMetaResourceTypes = excludeMetaResourceTypes;
        this.metaSchemaUris = Optional.ofNullable(metaSchemaUris).orElse(DEFAULT_META_SCHEMA_URIS);
        this.metaResourceTypeNames = Optional.ofNullable(metaResourceTypeNames).orElse(DEFAULT_META_RESOURCE_TYPES_NAMES);
        this.maxCountPerRequest = Optional.ofNullable(maxCountPerRequest).orElseGet(() -> serviceProvider -> Optional.ofNullable(serviceProvider).map(ServiceProvider::getFilterConfig).map(FilterConfig::getMaxResults).orElse(50));
    }

    public static MetaConfigRequestDetailsBuilder builder() {
        return new MetaConfigRequestDetailsBuilder();
    }

    public String getServiceProviderEndpoint() {
        return this.serviceProviderEndpoint;
    }

    public String getResourceTypeEndpoint() {
        return this.resourceTypeEndpoint;
    }

    public String getSchemasEndpoint() {
        return this.schemasEndpoint;
    }

    public boolean isExcludeMetaSchemas() {
        return this.excludeMetaSchemas;
    }

    public boolean isExcludeMetaResourceTypes() {
        return this.excludeMetaResourceTypes;
    }

    public List<String> getMetaResourceTypeNames() {
        return this.metaResourceTypeNames;
    }

    public List<String> getMetaSchemaUris() {
        return this.metaSchemaUris;
    }

    public Function<ServiceProvider, Integer> getMaxCountPerRequest() {
        return this.maxCountPerRequest;
    }

    public static class MetaConfigRequestDetailsBuilder {
        private String serviceProviderEndpoint;
        private String resourceTypeEndpoint;
        private String schemasEndpoint;
        private boolean excludeMetaSchemas;
        private boolean excludeMetaResourceTypes;
        private List<String> metaSchemaUris;
        private List<String> metaResourceTypeNames;
        private Function<ServiceProvider, Integer> maxCountPerRequest;

        MetaConfigRequestDetailsBuilder() {
        }

        public MetaConfigRequestDetailsBuilder serviceProviderEndpoint(String serviceProviderEndpoint) {
            this.serviceProviderEndpoint = serviceProviderEndpoint;
            return this;
        }

        public MetaConfigRequestDetailsBuilder resourceTypeEndpoint(String resourceTypeEndpoint) {
            this.resourceTypeEndpoint = resourceTypeEndpoint;
            return this;
        }

        public MetaConfigRequestDetailsBuilder schemasEndpoint(String schemasEndpoint) {
            this.schemasEndpoint = schemasEndpoint;
            return this;
        }

        public MetaConfigRequestDetailsBuilder excludeMetaSchemas(boolean excludeMetaSchemas) {
            this.excludeMetaSchemas = excludeMetaSchemas;
            return this;
        }

        public MetaConfigRequestDetailsBuilder excludeMetaResourceTypes(boolean excludeMetaResourceTypes) {
            this.excludeMetaResourceTypes = excludeMetaResourceTypes;
            return this;
        }

        public MetaConfigRequestDetailsBuilder metaSchemaUris(List<String> metaSchemaUris) {
            this.metaSchemaUris = metaSchemaUris;
            return this;
        }

        public MetaConfigRequestDetailsBuilder metaResourceTypeNames(List<String> metaResourceTypeNames) {
            this.metaResourceTypeNames = metaResourceTypeNames;
            return this;
        }

        public MetaConfigRequestDetailsBuilder maxCountPerRequest(Function<ServiceProvider, Integer> maxCountPerRequest) {
            this.maxCountPerRequest = maxCountPerRequest;
            return this;
        }

        public MetaConfigRequestDetails build() {
            return new MetaConfigRequestDetails(this.serviceProviderEndpoint, this.resourceTypeEndpoint, this.schemasEndpoint, this.excludeMetaSchemas, this.excludeMetaResourceTypes, this.metaSchemaUris, this.metaResourceTypeNames, this.maxCountPerRequest);
        }

        public String toString() {
            return "MetaConfigRequestDetails.MetaConfigRequestDetailsBuilder(serviceProviderEndpoint=" + this.serviceProviderEndpoint + ", resourceTypeEndpoint=" + this.resourceTypeEndpoint + ", schemasEndpoint=" + this.schemasEndpoint + ", excludeMetaSchemas=" + this.excludeMetaSchemas + ", excludeMetaResourceTypes=" + this.excludeMetaResourceTypes + ", metaSchemaUris=" + this.metaSchemaUris + ", metaResourceTypeNames=" + this.metaResourceTypeNames + ", maxCountPerRequest=" + this.maxCountPerRequest + ")";
        }
    }
}

