/*
 * Decompiled with CFR 0.152.
 */
package de.captaingoldfish.scim.sdk.client.builder;

import com.fasterxml.jackson.databind.JsonNode;
import de.captaingoldfish.scim.sdk.client.builder.ETagRequestBuilder;
import de.captaingoldfish.scim.sdk.client.builder.RequestBuilder;
import de.captaingoldfish.scim.sdk.client.http.HttpDelete;
import de.captaingoldfish.scim.sdk.client.http.ScimHttpClient;
import de.captaingoldfish.scim.sdk.common.etag.ETag;
import de.captaingoldfish.scim.sdk.common.resources.ResourceNode;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;

public class DeleteBuilder<T extends ResourceNode>
extends ETagRequestBuilder<T> {
    private final String fullUrl;

    public DeleteBuilder(String fullUrl, Class<T> responseEntityType, ScimHttpClient scimHttpClient) {
        super(responseEntityType, scimHttpClient);
        this.fullUrl = fullUrl;
    }

    public DeleteBuilder(String baseUrl, String endpoint, String resourceId, Class<T> responseEntityType, ScimHttpClient scimHttpClient) {
        super(baseUrl, endpoint + (StringUtils.isBlank((CharSequence)resourceId) ? "" : "/" + resourceId), responseEntityType, scimHttpClient);
        this.fullUrl = null;
    }

    @Override
    public RequestBuilder<T> setResource(String resource) {
        return super.setResource(resource);
    }

    @Override
    public RequestBuilder<T> setResource(JsonNode resource) {
        return super.setResource(resource);
    }

    @Override
    protected DeleteBuilder<T> setExpectedResponseHeaders(Map<String, String> requiredResponseHeaders) {
        return (DeleteBuilder)super.setExpectedResponseHeaders(requiredResponseHeaders);
    }

    @Override
    protected boolean isExpectedResponseCode(int httpStatus) {
        return 204 == httpStatus;
    }

    @Override
    public DeleteBuilder<T> setETagForIfMatch(String version) {
        return (DeleteBuilder)super.setETagForIfMatch(version);
    }

    @Override
    public DeleteBuilder<T> setETagForIfNoneMatch(String version) {
        return (DeleteBuilder)super.setETagForIfNoneMatch(version);
    }

    @Override
    public DeleteBuilder<T> setETagForIfMatch(ETag version) {
        return (DeleteBuilder)super.setETagForIfMatch(version);
    }

    @Override
    public DeleteBuilder<T> setETagForIfNoneMatch(ETag version) {
        return (DeleteBuilder)super.setETagForIfNoneMatch(version);
    }

    @Override
    protected HttpUriRequest getHttpUriRequest() {
        HttpDelete httpDelete = StringUtils.isBlank((CharSequence)this.fullUrl) ? new HttpDelete(this.getBaseUrl() + this.getEndpoint()) : new HttpDelete(this.fullUrl);
        if (StringUtils.isNotBlank((CharSequence)this.getResource())) {
            httpDelete.setEntity((HttpEntity)new StringEntity(this.getResource()));
        }
        if (this.isUseIfMatch()) {
            httpDelete.setHeader("If-Match", this.getVersion().toString());
        }
        if (this.isUseIfNoneMatch()) {
            httpDelete.setHeader("If-None-Match", this.getVersion().toString());
        }
        return httpDelete;
    }

    @Override
    protected Map<String, String> getRequiredResponseHeaders() {
        return new HashMap<String, String>();
    }
}

