/*
 * Decompiled with CFR 0.152.
 */
package de.captaingoldfish.scim.sdk.client.builder;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import de.captaingoldfish.scim.sdk.client.builder.ETagRequestBuilder;
import de.captaingoldfish.scim.sdk.client.http.ScimHttpClient;
import de.captaingoldfish.scim.sdk.common.constants.enums.PatchOp;
import de.captaingoldfish.scim.sdk.common.request.PatchOpRequest;
import de.captaingoldfish.scim.sdk.common.request.PatchRequestOperation;
import de.captaingoldfish.scim.sdk.common.resources.ResourceNode;
import de.captaingoldfish.scim.sdk.common.utils.JsonHelper;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpPatch;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;

public class PatchBuilder<T extends ResourceNode>
extends ETagRequestBuilder<T> {
    private final String fullUrl;
    private List<PatchRequestOperation> operations = new ArrayList<PatchRequestOperation>();

    public PatchBuilder(String fullUrl, Class<T> responseEntityType, ScimHttpClient scimHttpClient) {
        super(responseEntityType, scimHttpClient);
        this.fullUrl = fullUrl;
    }

    public PatchBuilder(String baseUrl, String endpoint, String resourceId, Class<T> responseEntityType, ScimHttpClient scimHttpClient) {
        super(baseUrl, endpoint + (StringUtils.isBlank((CharSequence)resourceId) ? "" : "/" + resourceId), responseEntityType, scimHttpClient);
        this.fullUrl = null;
    }

    @Override
    public PatchBuilder<T> setExpectedResponseHeaders(Map<String, String> requiredResponseHeaders) {
        return (PatchBuilder)super.setExpectedResponseHeaders(requiredResponseHeaders);
    }

    @Override
    protected boolean isExpectedResponseCode(int httpStatus) {
        return 200 == httpStatus;
    }

    public PatchBuilder<T> setPatchResource(PatchOpRequest resource) {
        PatchBuilder patchBuilder = (PatchBuilder)super.setResource((JsonNode)resource);
        this.operations = resource.getOperations();
        return patchBuilder;
    }

    public PatchBuilder<T> setPatchResource(String resource) {
        PatchBuilder patchBuilder = (PatchBuilder)super.setResource(resource);
        PatchOpRequest patchOpRequest = (PatchOpRequest)JsonHelper.readJsonDocument((String)resource, PatchOpRequest.class);
        this.operations = patchOpRequest.getOperations();
        return patchBuilder;
    }

    public PatchOperationBuilder<T> addOperation() {
        return new PatchOperationBuilder(this);
    }

    @Override
    protected HttpUriRequest getHttpUriRequest() {
        HttpPatch httpPatch = StringUtils.isBlank((CharSequence)this.fullUrl) ? new HttpPatch(this.getBaseUrl() + this.getEndpoint()) : new HttpPatch(this.fullUrl);
        StringEntity stringEntity = new StringEntity(this.getResource(), StandardCharsets.UTF_8);
        httpPatch.setEntity((HttpEntity)stringEntity);
        return httpPatch;
    }

    @Override
    public final String getResource() {
        return new PatchOpRequest(this.operations).toString();
    }

    public static class PatchOperationBuilder<T extends ResourceNode> {
        private PatchBuilder<T> patchBuilder;
        private PatchRequestOperation.PatchRequestOperationBuilder builder;

        public PatchOperationBuilder(PatchBuilder<T> patchBuilder) {
            this.patchBuilder = patchBuilder;
            this.builder = PatchRequestOperation.builder();
        }

        public PatchOperationBuilder<T> path(String path) {
            this.builder.path(path);
            return this;
        }

        public PatchOperationBuilder<T> op(PatchOp op) {
            this.builder.op(op);
            return this;
        }

        public PatchOperationBuilder<T> value(String values) {
            this.builder.values(Collections.singletonList(values));
            return this;
        }

        public PatchOperationBuilder<T> values(List<String> values) {
            this.builder.values(values);
            return this;
        }

        public PatchOperationBuilder<T> valueNode(JsonNode valueNode) {
            this.builder.valueNode(valueNode);
            return this;
        }

        public PatchOperationBuilder<T> valueNodes(List<? extends JsonNode> valueNodes) {
            ArrayNode arrayNode = new ArrayNode(JsonNodeFactory.instance);
            valueNodes.forEach(arg_0 -> ((ArrayNode)arrayNode).add(arg_0));
            this.builder.valueNode((JsonNode)arrayNode);
            return this;
        }

        public PatchBuilder<T> build() {
            ((PatchBuilder)this.patchBuilder).operations.add(this.builder.build());
            return this.patchBuilder;
        }

        public PatchOperationBuilder<T> next() {
            this.build();
            return new PatchOperationBuilder<T>(this.patchBuilder);
        }
    }
}

