/*
 * Decompiled with CFR 0.152.
 */
package de.captaingoldfish.scim.sdk.client.builder;

import com.fasterxml.jackson.databind.JsonNode;
import de.captaingoldfish.scim.sdk.client.builder.RequestBuilder;
import de.captaingoldfish.scim.sdk.client.exceptions.InvalidRequestException;
import de.captaingoldfish.scim.sdk.client.http.ScimHttpClient;
import de.captaingoldfish.scim.sdk.client.response.ServerResponse;
import de.captaingoldfish.scim.sdk.common.resources.ResourceNode;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;

public class CreateBuilder<T extends ResourceNode>
extends RequestBuilder<T> {
    private final String fullUrl;

    public CreateBuilder(String fullUrl, Class<T> responseEntityType, ScimHttpClient scimHttpClient) {
        super(null, null, responseEntityType, scimHttpClient);
        this.fullUrl = fullUrl;
    }

    public CreateBuilder(String baseUrl, String endpoint, Class<T> responseEntityType, ScimHttpClient scimHttpClient) {
        super(baseUrl, endpoint, responseEntityType, scimHttpClient);
        this.fullUrl = null;
    }

    @Override
    public CreateBuilder<T> setExpectedResponseHeaders(Map<String, String> requiredResponseHeaders) {
        return (CreateBuilder)super.setExpectedResponseHeaders(requiredResponseHeaders);
    }

    @Override
    public CreateBuilder<T> setResource(String resource) {
        return (CreateBuilder)super.setResource(resource);
    }

    @Override
    public CreateBuilder<T> setResource(JsonNode resource) {
        return (CreateBuilder)super.setResource(resource);
    }

    @Override
    public ServerResponse<T> sendRequest() {
        if (StringUtils.isBlank((CharSequence)this.getResource())) {
            throw new InvalidRequestException("no resource set");
        }
        return super.sendRequest();
    }

    @Override
    protected boolean isExpectedResponseCode(int httpStatus) {
        return 201 == httpStatus;
    }

    @Override
    protected HttpUriRequest getHttpUriRequest() {
        HttpPost httpPost = StringUtils.isBlank((CharSequence)this.fullUrl) ? new HttpPost(this.getBaseUrl() + this.getEndpoint()) : new HttpPost(this.fullUrl);
        StringEntity stringEntity = new StringEntity(this.getResource(), StandardCharsets.UTF_8);
        httpPost.setEntity((HttpEntity)stringEntity);
        return httpPost;
    }
}

