/*
 * Decompiled with CFR 0.152.
 */
package de.captaingoldfish.scim.sdk.client.http;

import de.captaingoldfish.scim.sdk.client.ScimClientConfig;
import de.captaingoldfish.scim.sdk.client.exceptions.ConnectTimeoutRuntimeException;
import de.captaingoldfish.scim.sdk.client.exceptions.IORuntimeException;
import de.captaingoldfish.scim.sdk.client.exceptions.SSLHandshakeRuntimeException;
import de.captaingoldfish.scim.sdk.client.exceptions.SocketTimeoutRuntimeException;
import de.captaingoldfish.scim.sdk.client.exceptions.UnknownHostRuntimeException;
import de.captaingoldfish.scim.sdk.client.http.HttpResponse;
import de.captaingoldfish.scim.sdk.client.http.SSLContextHelper;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Optional;
import javax.net.ssl.SSLHandshakeException;
import org.apache.commons.io.IOUtils;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ConnectTimeoutException;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScimHttpClient
implements Closeable {
    private static final Logger log = LoggerFactory.getLogger(ScimHttpClient.class);
    private static final int TIMEOUT_MILLIS = 1000;
    private ScimClientConfig scimClientConfig;
    private CloseableHttpClient httpClient;

    public ScimHttpClient(ScimClientConfig scimClientConfig) {
        this.scimClientConfig = scimClientConfig;
    }

    private static HttpResponse toResponse(CloseableHttpResponse response) throws IOException {
        HashMap<String, String> headers = new HashMap<String, String>();
        Arrays.stream(response.getAllHeaders()).forEach(header -> headers.put(header.getName(), header.getValue()));
        return HttpResponse.builder().httpStatusCode(response.getStatusLine().getStatusCode()).responseBody(response.getEntity() == null ? null : IOUtils.toString((InputStream)response.getEntity().getContent(), (Charset)StandardCharsets.UTF_8)).responseHeaders(headers).build();
    }

    public CloseableHttpClient getHttpClient() {
        if (this.httpClient != null) {
            return this.httpClient;
        }
        HttpClientBuilder clientBuilder = HttpClientBuilder.create();
        CredentialsProvider credentialsProvider = null;
        if (this.scimClientConfig.getProxy() != null && this.scimClientConfig.getProxy().isProxySet()) {
            credentialsProvider = this.scimClientConfig.getProxy().getProxyCredentials();
        }
        clientBuilder.setDefaultCredentialsProvider(credentialsProvider);
        if (this.scimClientConfig.getClientAuth() != null || this.scimClientConfig.getTruststore() != null) {
            clientBuilder.setSSLContext(SSLContextHelper.getSslContext(this.scimClientConfig.getClientAuth(), this.scimClientConfig.getTruststore()));
        }
        clientBuilder.setConnectionReuseStrategy((response, context) -> false);
        if (this.scimClientConfig.getHostnameVerifier() != null) {
            clientBuilder.setSSLHostnameVerifier(this.scimClientConfig.getHostnameVerifier());
        }
        clientBuilder.setDefaultRequestConfig(this.getRequestConfig());
        if (this.scimClientConfig.getConfigManipulator() != null) {
            this.scimClientConfig.getConfigManipulator().modifyHttpClientConfig(clientBuilder);
        }
        this.httpClient = clientBuilder.build();
        return this.httpClient;
    }

    public RequestConfig getRequestConfig() {
        RequestConfig.Builder configBuilder;
        if (this.scimClientConfig.getProxy() == null) {
            configBuilder = RequestConfig.copy((RequestConfig)RequestConfig.DEFAULT);
        } else {
            RequestConfig proxyConfig = this.scimClientConfig.getProxy().getProxyConfig();
            configBuilder = RequestConfig.copy((RequestConfig)proxyConfig);
        }
        if (this.scimClientConfig.getConnectTimeout() > 0) {
            configBuilder.setConnectTimeout(this.scimClientConfig.getConnectTimeout() * 1000);
            log.debug("Connection timeout '{}' seconds", (Object)this.scimClientConfig.getConnectTimeout());
        }
        if (this.scimClientConfig.getSocketTimeout() > 0) {
            configBuilder.setSocketTimeout(this.scimClientConfig.getSocketTimeout() * 1000);
            log.debug("Socket timeout '{}' seconds", (Object)this.scimClientConfig.getSocketTimeout());
        }
        if (this.scimClientConfig.getRequestTimeout() > 0) {
            configBuilder.setConnectionRequestTimeout(this.scimClientConfig.getRequestTimeout() * 1000);
            log.debug("Request timeout '{}' seconds", (Object)this.scimClientConfig.getRequestTimeout());
        }
        if (this.scimClientConfig.getConfigManipulator() != null) {
            this.scimClientConfig.getConfigManipulator().modifyRequestConfig(configBuilder);
        }
        return configBuilder.build();
    }

    public HttpResponse sendRequest(HttpUriRequest uriRequest) {
        HttpResponse httpResponse;
        block14: {
            if (this.httpClient == null) {
                this.httpClient = this.getHttpClient();
            }
            this.setAuthenticationIfMissing(uriRequest);
            if (log.isTraceEnabled()) {
                log.trace("Sending http request: \n\tmethod: {}\n\turi: {}", (Object)uriRequest.getMethod(), (Object)uriRequest.getURI().toString());
            }
            CloseableHttpResponse response = this.httpClient.execute(uriRequest);
            try {
                httpResponse = ScimHttpClient.toResponse(response);
                if (response == null) break block14;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SSLHandshakeException ex) {
                    throw new SSLHandshakeRuntimeException("handshake error during connection setup", ex);
                }
                catch (ConnectTimeoutException ex) {
                    throw new ConnectTimeoutRuntimeException("connection timeout after '" + this.scimClientConfig.getConnectTimeout() + "' seconds", ex);
                }
                catch (SocketTimeoutException ex) {
                    throw new SocketTimeoutRuntimeException("socket timeout after '" + this.scimClientConfig.getSocketTimeout() + "' seconds", ex);
                }
                catch (UnknownHostException ex) {
                    throw new UnknownHostRuntimeException("could not find host '" + uriRequest.getURI().getHost() + "'", ex);
                }
                catch (IOException ex) {
                    throw new IORuntimeException("communication with server failed", ex);
                }
            }
            response.close();
        }
        return httpResponse;
    }

    private void setAuthenticationIfMissing(HttpUriRequest uriRequest) {
        Optional.ofNullable(this.scimClientConfig.getBasicAuth()).ifPresent(basicAuth -> {
            if (null == uriRequest.getFirstHeader("Authorization")) {
                uriRequest.addHeader("Authorization", this.scimClientConfig.getBasicAuth().getAuthorizationHeaderValue());
            }
        });
    }

    @Override
    public void close() {
        if (this.httpClient == null) {
            return;
        }
        try {
            this.httpClient.close();
        }
        catch (IOException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        this.httpClient = null;
    }

    public static int getTIMEOUT_MILLIS() {
        return 1000;
    }

    public ScimClientConfig getScimClientConfig() {
        return this.scimClientConfig;
    }
}

