/*
 * Decompiled with CFR 0.152.
 */
package de.captaingoldfish.scim.sdk.client.http;

import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Optional;

public class BasicAuth {
    private String username;
    private String password;

    public String getAuthorizationHeaderValue() {
        byte[] encoded = (Optional.ofNullable(this.username).orElse("") + ":" + Optional.ofNullable(this.password).orElse("")).getBytes(StandardCharsets.UTF_8);
        return "Basic " + Base64.getEncoder().encodeToString(encoded);
    }

    BasicAuth(String username, String password) {
        this.username = username;
        this.password = password;
    }

    public static BasicAuthBuilder builder() {
        return new BasicAuthBuilder();
    }

    public static class BasicAuthBuilder {
        private String username;
        private String password;

        BasicAuthBuilder() {
        }

        public BasicAuthBuilder username(String username) {
            this.username = username;
            return this;
        }

        public BasicAuthBuilder password(String password) {
            this.password = password;
            return this;
        }

        public BasicAuth build() {
            return new BasicAuth(this.username, this.password);
        }

        public String toString() {
            return "BasicAuth.BasicAuthBuilder(username=" + this.username + ", password=" + this.password + ")";
        }
    }
}

