// Generated by delombok at Mon May 31 21:29:47 CEST 2021
package de.captaingoldfish.scim.sdk.client;

import de.captaingoldfish.scim.sdk.client.builder.BulkBuilder;
import de.captaingoldfish.scim.sdk.client.builder.CreateBuilder;
import de.captaingoldfish.scim.sdk.client.builder.DeleteBuilder;
import de.captaingoldfish.scim.sdk.client.builder.GetBuilder;
import de.captaingoldfish.scim.sdk.client.builder.ListBuilder;
import de.captaingoldfish.scim.sdk.client.builder.PatchBuilder;
import de.captaingoldfish.scim.sdk.client.builder.UpdateBuilder;
import de.captaingoldfish.scim.sdk.client.http.ScimHttpClient;
import de.captaingoldfish.scim.sdk.common.resources.ResourceNode;


/**
 * author Pascal Knueppel <br>
 * created at: 07.12.2019 - 23:08 <br>
 * <br>
 * this class can be used to build any type of request for SCIM
 */
public class ScimRequestBuilder implements AutoCloseable
{

  /**
   * must contain the baseUrl to the scim service
   */
  private final String baseUrl;

  /**
   * the configuration for the client that should be used
   */
  private final ScimClientConfig scimClientConfig;

  // for unit tests
  /**
   * a convenience implementation that wraps the apache http client
   */
  private ScimHttpClient scimHttpClient;

  public ScimRequestBuilder(String baseUrl, ScimClientConfig scimClientConfig)
  {
    this.baseUrl = baseUrl.replaceFirst("/$", "");
    this.scimClientConfig = scimClientConfig;
    this.scimHttpClient = new ScimHttpClient(scimClientConfig);
  }

  /**
   * builds a create builder class based on the given type
   *
   * @param type the type that should be created
   * @param endpoint the endpoint path to the resource e.g. "/Users" or "/Groups"
   * @return a create-request builder for the given resource type
   */
  public <T extends ResourceNode> CreateBuilder<T> create(Class<T> type, String endpoint)
  {
    return new CreateBuilder<>(baseUrl, endpoint, type, scimHttpClient);
  }

  /**
   * builds a create builder class based on the given type
   *
   * @param fullyQualifiedUrl if the builder should not build the url on the baseUrl but use another fully
   *          qualified url
   * @param type the type that should be created
   * @return a create-request builder for the given resource type
   */
  public <T extends ResourceNode> CreateBuilder<T> create(String fullyQualifiedUrl, Class<T> type)
  {
    return new CreateBuilder<>(fullyQualifiedUrl, type, scimHttpClient);
  }

  /**
   * builds a get builder class based on the given type
   *
   * @param type the type that should be created
   * @param endpoint the endpoint path to the resource e.g. "/Users" or "/Groups"
   * @param resourceId the id of the resource that should be returned (may be null if the endpoint path already
   *          contains the id)
   * @return a get-request builder for the given resource type
   */
  public <T extends ResourceNode> GetBuilder<T> get(Class<T> type, String endpoint, String resourceId)
  {
    return new GetBuilder<>(baseUrl, endpoint, resourceId, type, scimHttpClient);
  }

  /**
   * builds a get builder that is used to access a singleton resource from the provider
   *
   * @param type the type that should be created
   * @param endpoint the endpoint path to the resource e.g. "/Users" or "/Groups"
   * @return a get-request builder for the given resource type
   */
  public <T extends ResourceNode> GetBuilder<T> get(Class<T> type, String endpoint)
  {
    return new GetBuilder<>(baseUrl, endpoint, null, type, scimHttpClient);
  }

  /**
   * builds a get builder class based on the given type
   *
   * @param fullyQualifiedUrl if the builder should not build the url on the baseUrl but use another fully
   *          qualified url
   * @param type the type that should be created
   * @return a get-request builder for the given resource type
   */
  public <T extends ResourceNode> GetBuilder<T> get(String fullyQualifiedUrl, Class<T> type)
  {
    return new GetBuilder<>(fullyQualifiedUrl, type, scimHttpClient);
  }

  /**
   * builds a delete builder class based on the given type
   *
   * @param type the type that should be created
   * @param endpoint the endpoint path to the resource e.g. "/Users" or "/Groups"
   * @param resourceId the id of the resource that should be returned (may be null if the endpoint path already
   *          contains the id)
   * @return a delete-request builder for the given resource type
   */
  public <T extends ResourceNode> DeleteBuilder<T> delete(Class<T> type, String endpoint, String resourceId)
  {
    return new DeleteBuilder<>(baseUrl, endpoint, resourceId, type, scimHttpClient);
  }

  /**
   * builds a delete builder class based on the given type
   *
   * @param fullyQualifiedUrl if the builder should not build the url on the baseUrl but use another fully
   *          qualified url
   * @param type the type that should be created
   * @return a delete-request builder for the given resource type
   */
  public <T extends ResourceNode> DeleteBuilder<T> delete(String fullyQualifiedUrl, Class<T> type)
  {
    return new DeleteBuilder<>(fullyQualifiedUrl, type, scimHttpClient);
  }

  /**
   * builds an update builder class based on the given type
   *
   * @param type the type that should be created
   * @param endpoint the endpoint path to the resource e.g. "/Users" or "/Groups"
   * @param resourceId the id of the resource that should be returned (may be null if the endpoint path already
   *          contains the id)
   * @return a update-request builder for the given resource type
   */
  public <T extends ResourceNode> UpdateBuilder<T> update(Class<T> type, String endpoint, String resourceId)
  {
    return new UpdateBuilder<>(baseUrl, endpoint, resourceId, type, scimHttpClient);
  }

  /**
   * builds an update builder class based on the given type
   *
   * @param fullyQualifiedUrl if the builder should not build the url on the baseUrl but use another fully
   *          qualified url
   * @param type the type that should be created
   * @return a update-request builder for the given resource type
   */
  public <T extends ResourceNode> UpdateBuilder<T> update(String fullyQualifiedUrl, Class<T> type)
  {
    return new UpdateBuilder<>(fullyQualifiedUrl, type, scimHttpClient);
  }

  /**
   * builds an update builder class based on the given type
   *
   * @param type the type that should be created
   * @param endpoint the endpoint path to the resource e.g. "/Users" or "/Groups"
   * @return a update-request builder for the given resource type
   */
  public <T extends ResourceNode> ListBuilder<T> list(Class<T> type, String endpoint)
  {
    return new ListBuilder<>(baseUrl, endpoint, type, scimHttpClient);
  }

  /**
   * builds an update builder class based on the given type
   *
   * @param fullyQualifiedUrl if the builder should not build the url on the baseUrl but use another fully
   *          qualified url
   * @param type the type that should be created
   * @return a update-request builder for the given resource type
   */
  public <T extends ResourceNode> ListBuilder<T> list(String fullyQualifiedUrl, Class<T> type)
  {
    return new ListBuilder<>(fullyQualifiedUrl, type, scimHttpClient);
  }

  /**
   * builds an bulk request builder
   *
   * @return a bulk-request builder
   */
  public BulkBuilder bulk()
  {
    return new BulkBuilder(baseUrl, scimHttpClient, false);
  }

  /**
   * builds an bulk request builder
   *
   * @param fullyQualifiedUrl if the builder should not build the url on the baseUrl but use another fully
   *          qualified url
   * @return a bulk-request builder
   */
  public BulkBuilder bulk(String fullyQualifiedUrl)
  {
    return new BulkBuilder(fullyQualifiedUrl, scimHttpClient, true);
  }

  /**
   * builds a patch request builder
   *
   * @param type the type that should be created
   * @param endpoint the endpoint path to the resource e.g. "/Users" or "/Groups"
   * @param resourceId the id of the resource that should be returned (may be null if the endpoint path already
   *          contains the id)
   * @return a patch-request builder
   */
  public <T extends ResourceNode> PatchBuilder<T> patch(Class<T> type, String endpoint, String resourceId)
  {
    return new PatchBuilder<>(baseUrl, endpoint, resourceId, type, scimHttpClient);
  }

  /**
   * builds a patch request builder
   *
   * @param fullyQualifiedUrl if the builder should not build the url on the baseUrl but use another fully
   *          qualified url
   * @param type the type that should be created
   * @return a patch-request builder
   */
  public <T extends ResourceNode> PatchBuilder<T> patch(String fullyQualifiedUrl, Class<T> type)
  {
    return new PatchBuilder<>(fullyQualifiedUrl, type, scimHttpClient);
  }

  /**
   * closes the underlying apache http client. If the http client is closed this request builder is still
   * usable. The next request will simply be executed with a new http client instance
   */
  @Override
  public void close()
  {
    scimHttpClient.close();
  }

  /**
   * the configuration for the client that should be used
   */
  @java.lang.SuppressWarnings("all")
  public ScimClientConfig getScimClientConfig()
  {
    return this.scimClientConfig;
  }

  /**
   * a convenience implementation that wraps the apache http client
   */
  @java.lang.SuppressWarnings("all")
  protected ScimHttpClient getScimHttpClient()
  {
    return this.scimHttpClient;
  }
}
