/*
 * Decompiled with CFR 0.152.
 */
package de.caluga.morphium.query;

import de.caluga.morphium.annotations.lifecycle.Lifecycle;
import de.caluga.morphium.annotations.lifecycle.PostLoad;
import de.caluga.morphium.driver.MorphiumCursor;
import de.caluga.morphium.driver.MorphiumDriverException;
import de.caluga.morphium.driver.commands.FindCommand;
import de.caluga.morphium.query.MorphiumIterator;
import de.caluga.morphium.query.Query;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryIterator<T>
implements MorphiumIterator<T>,
Iterator<T> {
    private final Logger log = LoggerFactory.getLogger(QueryIterator.class);
    private Query<T> query;
    private MorphiumCursor cursor = null;
    private int windowSize = 0;

    public int getWindowSize() {
        return this.windowSize;
    }

    public QueryIterator<T> setWindowSize(int windowSize) {
        this.windowSize = windowSize;
        return this;
    }

    public Query<T> getQuery() {
        return this.query;
    }

    public void setQuery(Query<T> q) {
        this.query = q.clone();
    }

    public long getCount() {
        return this.query.countAll();
    }

    @Override
    public void ahead(int jump) {
        try {
            this.getMongoCursor().ahead(jump);
        }
        catch (MorphiumDriverException e) {
            if (this.getMongoCursor() != null && this.getMongoCursor().getConnection() != null) {
                this.getMongoCursor().getConnection().close();
            }
            throw new RuntimeException(e);
        }
    }

    @Override
    public void back(int jump) {
        try {
            this.getMongoCursor().back(jump);
        }
        catch (MorphiumDriverException e) {
            if (this.getMongoCursor() != null && this.getMongoCursor().getConnection() != null) {
                this.getMongoCursor().getConnection().close();
            }
            throw new RuntimeException(e);
        }
    }

    @Override
    public int available() {
        try {
            return this.getMongoCursor().available();
        }
        catch (Exception e) {
            if (this.getMongoCursor() != null && this.getMongoCursor().getConnection() != null) {
                this.getMongoCursor().getConnection().close();
            }
            throw new RuntimeException(e);
        }
    }

    @Override
    public Iterator<T> iterator() {
        return this;
    }

    @Override
    public boolean hasNext() {
        try {
            boolean ret = this.getMongoCursor().hasNext();
            if (!ret && this.getMongoCursor() != null && this.getMongoCursor().getConnection() != null) {
                this.getMongoCursor().getConnection().close();
            }
            return ret;
        }
        catch (Exception e) {
            if (this.getMongoCursor() != null && this.getMongoCursor().getConnection() != null) {
                this.getMongoCursor().getConnection().close();
            }
            throw new RuntimeException(e);
        }
    }

    @Override
    public Map<String, Object> nextMap() {
        try {
            return this.getMongoCursor().next();
        }
        catch (Exception e) {
            if (this.getMongoCursor() != null && this.getMongoCursor().getConnection() != null) {
                this.getMongoCursor().getConnection().close();
            }
            throw new RuntimeException(e);
        }
    }

    @Override
    public T next() {
        try {
            if (this.query.getType() == null) {
                return (T)this.getMongoCursor().next();
            }
            T ret = this.query.getMorphium().getMapper().deserialize(this.query.getType(), (Map<String, Object>)this.getMongoCursor().next());
            if (this.query.getMorphium().getARHelper().isAnnotationPresentInHierarchy(this.query.getType(), Lifecycle.class)) {
                this.query.getMorphium().getARHelper().callLifecycleMethod(PostLoad.class, ret);
            }
            return ret;
        }
        catch (Exception e) {
            if (this.getMongoCursor() != null && this.getMongoCursor().getConnection() != null) {
                this.getMongoCursor().getConnection().close();
            }
            throw new RuntimeException(e);
        }
    }

    @Override
    public List<T> getCurrentBuffer() {
        ArrayList<T> ret = new ArrayList<T>();
        for (Map<String, Object> o : this.getMongoCursor().getBatch()) {
            ret.add(this.query.getMorphium().getMapper().deserialize(this.query.getType(), o));
        }
        return ret;
    }

    @Override
    public void close() {
        this.getMongoCursor().close();
    }

    @Override
    public int getCursor() {
        return this.getMongoCursor().getCursor();
    }

    public MorphiumCursor getMongoCursor() {
        if (this.cursor == null) {
            FindCommand cmd = this.query.getFindCmd();
            try {
                if (this.windowSize != 0) {
                    cmd.setBatchSize(this.windowSize);
                }
                this.cursor = cmd.executeIterable(this.windowSize);
            }
            catch (MorphiumDriverException e) {
                cmd.releaseConnection();
                throw new RuntimeException(e);
            }
        }
        return this.cursor;
    }
}

