/*
 * Decompiled with CFR 0.152.
 */
package de.caluga.morphium.messaging.jms;

import de.caluga.morphium.annotations.Entity;
import de.caluga.morphium.driver.MorphiumId;
import de.caluga.morphium.messaging.Msg;
import java.util.Collections;
import java.util.Enumeration;
import java.util.concurrent.ConcurrentHashMap;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;

@Entity(typeId="jmsmessage", polymorph=true)
public class JMSMessage
extends Msg
implements Message {
    private boolean redelivered = false;
    private Object body;
    private Destination replyTo;
    private Destination destination;

    public JMSMessage() {
        this.setMapValue(new ConcurrentHashMap<String, Object>());
    }

    public String getJMSMessageID() throws JMSException {
        return this.getMsgId().toString();
    }

    public void setJMSMessageID(String id) throws JMSException {
        this.setMsgId(new MorphiumId(id));
    }

    public long getJMSTimestamp() throws JMSException {
        return this.getTimestamp();
    }

    public void setJMSTimestamp(long timestamp) throws JMSException {
        this.setTimestamp(timestamp);
    }

    public byte[] getJMSCorrelationIDAsBytes() throws JMSException {
        return this.getMsgId().getBytes();
    }

    public void setJMSCorrelationIDAsBytes(byte[] correlationID) throws JMSException {
        this.setMsgId(new MorphiumId(correlationID));
    }

    public String getJMSCorrelationID() throws JMSException {
        return this.getMsgId().toString();
    }

    public void setJMSCorrelationID(String correlationID) throws JMSException {
        this.setMsgId(new MorphiumId(correlationID));
    }

    public Destination getJMSReplyTo() throws JMSException {
        return this.replyTo;
    }

    public void setJMSReplyTo(Destination replyTo) throws JMSException {
        this.replyTo = replyTo;
    }

    public Destination getJMSDestination() throws JMSException {
        return this.destination;
    }

    public void setJMSDestination(Destination destination) throws JMSException {
        this.destination = destination;
    }

    public int getJMSDeliveryMode() throws JMSException {
        return 2;
    }

    public void setJMSDeliveryMode(int deliveryMode) throws JMSException {
    }

    public boolean getJMSRedelivered() throws JMSException {
        return this.redelivered;
    }

    public void setJMSRedelivered(boolean redelivered) throws JMSException {
        this.redelivered = redelivered;
    }

    public String getJMSType() throws JMSException {
        return this.getTopic();
    }

    public void setJMSType(String type) throws JMSException {
        this.setTopic(type);
    }

    public long getJMSExpiration() throws JMSException {
        return System.currentTimeMillis() + this.getTtl();
    }

    public void setJMSExpiration(long expiration) throws JMSException {
        this.setTtl(System.currentTimeMillis() - expiration);
    }

    public long getJMSDeliveryTime() throws JMSException {
        return this.getTimestamp();
    }

    public void setJMSDeliveryTime(long deliveryTime) throws JMSException {
        this.setTimestamp(deliveryTime);
    }

    public int getJMSPriority() throws JMSException {
        return this.getPriority();
    }

    public void setJMSPriority(int priority) throws JMSException {
        this.setPriority(priority);
    }

    public void clearProperties() throws JMSException {
        this.getMapValue().clear();
    }

    public boolean propertyExists(String name) throws JMSException {
        return this.getMapValue().containsKey(name);
    }

    public boolean getBooleanProperty(String name) throws JMSException {
        return this.getMapValue().get(name).equals("true");
    }

    public byte getByteProperty(String name) throws JMSException {
        return (Byte)this.getMapValue().get(name);
    }

    public short getShortProperty(String name) throws JMSException {
        return (Short)this.getMapValue().get(name);
    }

    public int getIntProperty(String name) throws JMSException {
        return (Integer)this.getMapValue().get(name);
    }

    public long getLongProperty(String name) throws JMSException {
        return (Long)this.getMapValue().get(name);
    }

    public float getFloatProperty(String name) throws JMSException {
        return ((Float)this.getMapValue().get(name)).floatValue();
    }

    public double getDoubleProperty(String name) throws JMSException {
        return (Double)this.getMapValue().get(name);
    }

    public String getStringProperty(String name) throws JMSException {
        return (String)this.getMapValue().get(name);
    }

    public Object getObjectProperty(String name) throws JMSException {
        return null;
    }

    public Enumeration getPropertyNames() throws JMSException {
        return Collections.enumeration(this.getMapValue().keySet());
    }

    public void setBooleanProperty(String name, boolean value) throws JMSException {
        this.getMapValue().put(name, "" + value);
    }

    public void setByteProperty(String name, byte value) throws JMSException {
        this.getMapValue().put(name, value);
    }

    public void setShortProperty(String name, short value) throws JMSException {
        this.getMapValue().put(name, value);
    }

    public void setIntProperty(String name, int value) throws JMSException {
        this.getMapValue().put(name, value);
    }

    public void setLongProperty(String name, long value) throws JMSException {
        this.getMapValue().put(name, value);
    }

    public void setFloatProperty(String name, float value) throws JMSException {
        this.getMapValue().put(name, Float.valueOf(value));
    }

    public void setDoubleProperty(String name, double value) throws JMSException {
        this.getMapValue().put(name, value);
    }

    public void setStringProperty(String name, String value) throws JMSException {
        this.getMapValue().put(name, value);
    }

    public void setObjectProperty(String name, Object value) throws JMSException {
        this.getMapValue().put(name, value);
    }

    public void acknowledge() throws JMSException {
    }

    public void clearBody() throws JMSException {
        this.body = null;
    }

    public <T> T getBody(Class<T> c) throws JMSException {
        return (T)this.body;
    }

    public boolean isBodyAssignableTo(Class c) throws JMSException {
        if (this.body == null) {
            return false;
        }
        return c.isAssignableFrom(this.body.getClass());
    }
}

