/*
 * Decompiled with CFR 0.152.
 */
package de.caluga.morphium.messaging.jms;

import de.caluga.morphium.Morphium;
import de.caluga.morphium.MorphiumConfig;
import de.caluga.morphium.messaging.jms.Context;
import de.caluga.morphium.messaging.jms.JMSConnection;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.JMSContext;
import javax.jms.JMSException;

public class JMSConnectionFactory
implements ConnectionFactory {
    private Morphium morphium;

    public JMSConnectionFactory(Morphium morphium) {
        this.morphium = morphium;
    }

    public Connection createConnection() throws JMSException {
        return new JMSConnection(this.morphium);
    }

    public Connection createConnection(String userName, String password) throws JMSException {
        MorphiumConfig cfg = MorphiumConfig.fromProperties(this.morphium.getConfig().asProperties());
        cfg.encryptionSettings().setCredentialsEncryptionKey(this.morphium.getConfig().encryptionSettings().getCredentialsEncryptionKey());
        cfg.encryptionSettings().setCredentialsDecryptionKey(this.morphium.getConfig().encryptionSettings().getCredentialsDecryptionKey());
        cfg.authSettings().setMongoLogin(userName);
        cfg.authSettings().setMongoPassword(password);
        return new JMSConnection(new Morphium(cfg));
    }

    public JMSContext createContext() {
        return new Context(this.morphium);
    }

    public JMSContext createContext(String userName, String password) {
        MorphiumConfig cfg = MorphiumConfig.fromProperties(this.morphium.getConfig().asProperties());
        cfg.encryptionSettings().setCredentialsEncryptionKey(this.morphium.getConfig().encryptionSettings().getCredentialsEncryptionKey());
        cfg.encryptionSettings().setCredentialsDecryptionKey(this.morphium.getConfig().encryptionSettings().getCredentialsDecryptionKey());
        cfg.authSettings().setMongoLogin(userName);
        cfg.authSettings().setMongoPassword(password);
        return new Context(new Morphium(cfg));
    }

    public JMSContext createContext(String userName, String password, int sessionMode) {
        MorphiumConfig cfg = MorphiumConfig.fromProperties(this.morphium.getConfig().asProperties());
        cfg.encryptionSettings().setCredentialsEncryptionKey(this.morphium.getConfig().encryptionSettings().getCredentialsEncryptionKey());
        cfg.encryptionSettings().setCredentialsDecryptionKey(this.morphium.getConfig().encryptionSettings().getCredentialsDecryptionKey());
        cfg.authSettings().setMongoLogin(userName);
        cfg.authSettings().setMongoPassword(password);
        return new Context(new Morphium(cfg), "", sessionMode);
    }

    public JMSContext createContext(int sessionMode) {
        return new Context(this.morphium, "", sessionMode);
    }
}

