/*
 * Decompiled with CFR 0.152.
 */
package de.caluga.morphium.messaging;

import de.caluga.morphium.Morphium;
import de.caluga.morphium.driver.MorphiumDriverException;
import de.caluga.morphium.messaging.MessageListener;
import de.caluga.morphium.messaging.MorphiumMessaging;
import de.caluga.morphium.messaging.Msg;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryUsage;
import java.lang.management.ThreadMXBean;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StatusInfoListener
implements MessageListener<Msg> {
    private Logger log = LoggerFactory.getLogger(StatusInfoListener.class);
    public static final String messagingThreadpoolstatsKey = "messaging_threadpoolstats";
    public static final String messageListenersbyNameKey = "message_listeners_by_name";
    public static final String morphiumCachestatsKey = "morphium.cachestats";
    public static final String morphiumConfigKey = "morphium.config";
    public static final String morphiumDriverStatsKey = "morphium.driver.stats";
    public static final String morphiumDriverConnections = "morphium.driver.connections";
    public static final String morphiumDriverReplstatKey = "morphium.driver.replicaset_status";

    @Override
    public Msg onMessage(MorphiumMessaging msg, Msg m) {
        if (m.isAnswer()) {
            return null;
        }
        this.log.debug("Preparing status info... " + String.valueOf(m.getMsgId()));
        long tripDur = System.currentTimeMillis() - m.getTimestamp();
        Msg answer = m.createAnswerMsg();
        answer.setMapValue(new HashMap<String, Object>());
        StatusInfoLevel level = StatusInfoLevel.MESSAGING_ONLY;
        if (m.getValue() != null) {
            for (StatusInfoLevel l : StatusInfoLevel.values()) {
                if (!l.name().equals(m.getValue())) continue;
                level = StatusInfoLevel.valueOf(m.getValue());
                break;
            }
        }
        if (!level.equals((Object)StatusInfoLevel.PING)) {
            Map<String, Object> map = answer.getMapValue();
            Runtime.getRuntime();
            map.put("jvm.version", Runtime.version().toString());
            answer.getMapValue().put("jvm.free_mem", Runtime.getRuntime().freeMemory());
            answer.getMapValue().put("jvm.total_mem", Runtime.getRuntime().totalMemory());
            answer.getMapValue().put("jvm.max_mem", Runtime.getRuntime().maxMemory());
            MemoryMXBean memMxBean = ManagementFactory.getMemoryMXBean();
            MemoryUsage heap = memMxBean.getHeapMemoryUsage();
            answer.getMapValue().put("jvm.heap.init", heap.getInit());
            answer.getMapValue().put("jvm.heap.used", heap.getUsed());
            answer.getMapValue().put("jvm.heap.committed", heap.getCommitted());
            answer.getMapValue().put("jvm.heap.max", heap.getMax());
            MemoryUsage nonheap = memMxBean.getNonHeapMemoryUsage();
            answer.getMapValue().put("jvm.nonheap.init", nonheap.getInit());
            answer.getMapValue().put("jvm.nonheap.used", nonheap.getUsed());
            answer.getMapValue().put("jvm.nonheap.committed", nonheap.getCommitted());
            answer.getMapValue().put("jvm.nonheap.max", nonheap.getMax());
            ThreadMXBean tc = ManagementFactory.getThreadMXBean();
            answer.getMapValue().put("jvm.threads.active", tc.getThreadCount());
            answer.getMapValue().put("jvm.threads.deamons", tc.getDaemonThreadCount());
            answer.getMapValue().put("jvm.threads.peak", tc.getPeakThreadCount());
            answer.getMapValue().put("jvm.threads.total_started", tc.getTotalStartedThreadCount());
            if (level.equals((Object)StatusInfoLevel.ALL) || level.equals((Object)StatusInfoLevel.MESSAGING_ONLY)) {
                try {
                    if (msg.isMultithreadded()) {
                        answer.getMapValue().put(messagingThreadpoolstatsKey, msg.getThreadPoolStats());
                    }
                    answer.getMapValue().put(messageListenersbyNameKey, msg.getListenerNames());
                    answer.getMapValue().put("messaging.changestream", msg.isUseChangeStream());
                    answer.getMapValue().put("messaging.multithreadded", msg.isMultithreadded());
                    answer.getMapValue().put("messaging.window_size", msg.getWindowSize());
                    answer.getMapValue().put("messaging.pause", msg.getPause());
                    answer.getMapValue().put("messaging.time_till_recieved", tripDur);
                    answer.getMapValue().put("messaging.waiting_for_answers", msg.waitingForAnswersCount());
                    answer.getMapValue().put("messaging.waiting_for_answers_total", msg.waitingForAnswersTotalCount());
                    answer.getMapValue().put("messaging.in_progress", msg.getInProgressCount());
                    answer.getMapValue().put("messaging.processing", msg.getProcessingCount());
                }
                catch (Exception e) {
                    answer.getMapValue().put("messaging.stats.error", e.getMessage());
                }
            }
            if (level.equals((Object)StatusInfoLevel.ALL) || level.equals((Object)StatusInfoLevel.MORPHIUM_ONLY)) {
                try {
                    answer.getMapValue().put(morphiumCachestatsKey, msg.getMorphium().getStatistics());
                    if (msg.getMorphium().getConfig() == null) {
                        answer.getMapValue().put(morphiumConfigKey, "NULL!");
                    } else {
                        answer.getMapValue().put(morphiumConfigKey, msg.getMorphium().getConfig().asProperties());
                    }
                    answer.getMapValue().put(morphiumDriverStatsKey, msg.getMorphium().getDriver().getDriverStats());
                    answer.getMapValue().put(morphiumDriverConnections, msg.getMorphium().getDriver().getNumConnectionsByHost());
                    try {
                        answer.getMapValue().put(morphiumDriverReplstatKey, msg.getMorphium().getDriver().getReplsetStatus());
                    }
                    catch (MorphiumDriverException e) {
                        answer.getMapValue().put(morphiumDriverReplstatKey, "could not get replicaset status: " + e.getMessage());
                    }
                }
                catch (Exception e) {
                    answer.getMapValue().put("morphium.driver.stats.stats.error", e.getMessage());
                }
            }
            if (level.equals((Object)StatusInfoLevel.ALL)) {
                int i = 0;
                for (Morphium alternativeMorphium : msg.getMorphium().getAlternativeMorphiums()) {
                    ++i;
                    try {
                        HashMap<String, Object> stats = new HashMap<String, Object>();
                        stats.put(morphiumCachestatsKey, alternativeMorphium.getStatistics());
                        if (alternativeMorphium.getConfig() == null) {
                            stats.put(morphiumConfigKey, "NULL!");
                        } else {
                            stats.put(morphiumConfigKey, alternativeMorphium.getConfig().asProperties());
                        }
                        stats.put(morphiumDriverStatsKey, alternativeMorphium.getDriver().getDriverStats());
                        stats.put(morphiumDriverConnections, alternativeMorphium.getDriver().getNumConnectionsByHost());
                        try {
                            stats.put(morphiumDriverReplstatKey, alternativeMorphium.getDriver().getReplsetStatus());
                        }
                        catch (MorphiumDriverException e) {
                            stats.put(morphiumDriverReplstatKey, "could not get replicaset status: " + e.getMessage());
                        }
                        answer.getMapValue().put("alternativeMorphium" + i, stats);
                    }
                    catch (Exception e) {
                        answer.getMapValue().put("alternativeMorphium" + i + ".stats.error", e.getMessage());
                    }
                }
            }
        }
        this.log.info(" status info done... " + String.valueOf(m.getMsgId()));
        return answer;
    }

    @Override
    public boolean markAsProcessedBeforeExec() {
        return true;
    }

    public static enum StatusInfoLevel {
        ALL,
        MESSAGING_ONLY,
        MORPHIUM_ONLY,
        PING;

    }

    public static abstract class InternalCommand {
        private String name;

        public InternalCommand(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public abstract void exec(MorphiumMessaging var1, Msg var2, Object var3);
    }
}

