/*
 * Decompiled with CFR 0.152.
 */
package de.caluga.morphium.driver.wireprotocol;

import de.caluga.morphium.driver.Doc;
import de.caluga.morphium.driver.bson.BsonDecoder;
import de.caluga.morphium.driver.bson.BsonEncoder;
import de.caluga.morphium.driver.wireprotocol.WireProtocolMessage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class OpReply
extends WireProtocolMessage {
    public static final int CURSOR_NOT_FOUND_FLAG = 1;
    public static final int QUERY_FAILURE_FLAG = 2;
    public static final int SHARD_CONFIG_STATE_FLAG = 4;
    public static final int AWAIT_CAPABLE_FLAG = 8;
    public final long timestamp = System.currentTimeMillis();
    private int size = 0;
    private int opcode = 1;
    private int flags;
    private long cursorId;
    private int startFrom;
    private int numReturned;
    private List<Map<String, Object>> documents;

    @Override
    public byte[] getPayload() throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        this.writeInt(this.flags, out);
        OpReply.writeLong(this.cursorId, out);
        this.writeInt(this.startFrom, out);
        this.writeInt(this.numReturned, out);
        for (Map<String, Object> doc : this.documents) {
            out.write(BsonEncoder.encodeDocument(doc));
        }
        return out.toByteArray();
    }

    @Override
    public int getSize() {
        return this.size;
    }

    @Override
    public void setSize(int size) {
        this.size = size;
    }

    public int getOpcode() {
        return this.opcode;
    }

    public void setOpcode(int opcode) {
        this.opcode = opcode;
    }

    public int getFlags() {
        return this.flags;
    }

    public void setFlags(int flags) {
        this.flags = flags;
    }

    public long getCursorId() {
        return this.cursorId;
    }

    public void setCursorId(long cursorId) {
        this.cursorId = cursorId;
    }

    public int getStartFrom() {
        return this.startFrom;
    }

    public void setStartFrom(int startFrom) {
        this.startFrom = startFrom;
    }

    public int getNumReturned() {
        return this.numReturned;
    }

    public void setNumReturned(int numReturned) {
        this.numReturned = numReturned;
    }

    public List<Map<String, Object>> getDocuments() {
        return this.documents;
    }

    public void setDocuments(List<Map<String, Object>> documents) {
        this.documents = documents;
    }

    public void addDocument(Map<String, Object> doc) {
        if (this.documents == null) {
            this.documents = new ArrayList<Map<String, Object>>();
        }
        this.documents.add(doc);
    }

    @Override
    public void parsePayload(byte[] bytes, int offset) throws IOException {
        this.flags = OpReply.readInt(bytes, offset);
        this.cursorId = OpReply.readLong(bytes, offset += 4);
        this.startFrom = OpReply.readInt(bytes, offset += 8);
        this.numReturned = OpReply.readInt(bytes, offset += 4);
        offset += 4;
        this.documents = new ArrayList<Map<String, Object>>();
        for (int i = 0; i < this.numReturned; ++i) {
            Doc m = new Doc();
            int l = BsonDecoder.decodeDocumentIn(m, bytes, offset);
            offset += l;
            this.documents.add(m);
        }
    }

    @Override
    public int getOpCode() {
        return this.opcode;
    }
}

