/*
 * Decompiled with CFR 0.152.
 */
package de.caluga.morphium.driver.wireprotocol;

import de.caluga.morphium.driver.Doc;
import de.caluga.morphium.driver.bson.BsonDecoder;
import de.caluga.morphium.driver.bson.BsonEncoder;
import de.caluga.morphium.driver.wireprotocol.WireProtocolMessage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class OpInsert
extends WireProtocolMessage {
    public static final int CONTINUE_ON_ERROR_FLAG = 1;
    private int flags;
    private String fullConnectionName;
    private List<Doc> documents;

    public void addDocument(Doc doc) {
        if (this.documents == null) {
            this.documents = new ArrayList<Doc>();
        }
        this.documents.add(doc);
    }

    public int getFlags() {
        return this.flags;
    }

    public void setFlags(int flags) {
        this.flags = flags;
    }

    public String getFullConnectionName() {
        return this.fullConnectionName;
    }

    public void setFullConnectionName(String fullConnectionName) {
        this.fullConnectionName = fullConnectionName;
    }

    public List<Doc> getDocuments() {
        return this.documents;
    }

    public void setDocuments(List<Doc> documents) {
        this.documents = documents;
    }

    @Override
    public void parsePayload(byte[] bytes, int offset) throws IOException {
        int len;
        this.flags = OpInsert.readInt(bytes, offset);
        this.fullConnectionName = OpInsert.readString(bytes, offset + 4);
        int strLen = OpInsert.strLen(bytes, offset + 4);
        this.documents = new ArrayList<Doc>();
        for (int idx = offset + 4 + strLen; idx < bytes.length; idx += len) {
            Doc doc = new Doc();
            len = BsonDecoder.decodeDocumentIn(doc, bytes, idx);
            this.documents.add(doc);
        }
    }

    @Override
    public byte[] getPayload() throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        this.writeInt(this.flags, out);
        this.writeString(this.fullConnectionName, out);
        for (Map map : this.documents) {
            out.write(BsonEncoder.encodeDocument(map));
        }
        return out.toByteArray();
    }

    @Override
    public int getOpCode() {
        return WireProtocolMessage.OpCode.OP_INSERT.opCode;
    }
}

