/*
 * Decompiled with CFR 0.152.
 */
package de.caluga.morphium.driver.wire;

import de.caluga.morphium.Morphium;
import de.caluga.morphium.Utils;
import de.caluga.morphium.UtilsMap;
import de.caluga.morphium.aggregation.Aggregator;
import de.caluga.morphium.aggregation.AggregatorImpl;
import de.caluga.morphium.annotations.Driver;
import de.caluga.morphium.driver.Doc;
import de.caluga.morphium.driver.MorphiumCursor;
import de.caluga.morphium.driver.MorphiumDriver;
import de.caluga.morphium.driver.MorphiumDriverException;
import de.caluga.morphium.driver.MorphiumDriverNetworkException;
import de.caluga.morphium.driver.MorphiumTransactionContext;
import de.caluga.morphium.driver.ReadPreference;
import de.caluga.morphium.driver.WriteConcern;
import de.caluga.morphium.driver.bulk.BulkRequest;
import de.caluga.morphium.driver.bulk.BulkRequestContext;
import de.caluga.morphium.driver.bulk.DeleteBulkRequest;
import de.caluga.morphium.driver.bulk.InsertBulkRequest;
import de.caluga.morphium.driver.bulk.UpdateBulkRequest;
import de.caluga.morphium.driver.commands.AbortTransactionCommand;
import de.caluga.morphium.driver.commands.CollStatsCommand;
import de.caluga.morphium.driver.commands.CommitTransactionCommand;
import de.caluga.morphium.driver.commands.CurrentOpCommand;
import de.caluga.morphium.driver.commands.DbStatsCommand;
import de.caluga.morphium.driver.commands.DeleteMongoCommand;
import de.caluga.morphium.driver.commands.HelloCommand;
import de.caluga.morphium.driver.commands.InsertMongoCommand;
import de.caluga.morphium.driver.commands.KillCursorsCommand;
import de.caluga.morphium.driver.commands.MongoCommand;
import de.caluga.morphium.driver.commands.ReplicastStatusCommand;
import de.caluga.morphium.driver.commands.UpdateMongoCommand;
import de.caluga.morphium.driver.commands.WatchCommand;
import de.caluga.morphium.driver.wire.AtomicDecimal;
import de.caluga.morphium.driver.wire.ConnectionType;
import de.caluga.morphium.driver.wire.DriverBase;
import de.caluga.morphium.driver.wire.HelloResult;
import de.caluga.morphium.driver.wire.MongoConnection;
import de.caluga.morphium.driver.wire.NetworkCallHelper;
import de.caluga.morphium.driver.wire.SingleMongoConnection;
import de.caluga.morphium.driver.wireprotocol.OpMsg;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Driver(name="SingleMongoConnectDriver", description="simple driver only handling one connection")
public class SingleMongoConnectDriver
extends DriverBase {
    private ScheduledFuture<?> heartbeat;
    public static final String driverName = "SingleMongoConnectDriver";
    private final Logger log = LoggerFactory.getLogger(SingleMongoConnectDriver.class);
    private SingleMongoConnection connection;
    private ConnectionType connectionType = ConnectionType.PRIMARY;
    private int idleSleepTime = 20;
    private boolean connectionInUse = false;
    private AtomicInteger waitingForHeartbeatCounter = new AtomicInteger(0);
    private Map<MorphiumDriver.DriverStatsKey, AtomicDecimal> stats = new HashMap<MorphiumDriver.DriverStatsKey, AtomicDecimal>();
    private ScheduledThreadPoolExecutor executor = new ScheduledThreadPoolExecutor(5, r -> {
        Thread ret = new Thread(r);
        ret.setName("SCCon_" + this.stats.get((Object)MorphiumDriver.DriverStatsKey.THREADS_CREATED).incrementAndGet());
        ret.setDaemon(true);
        return ret;
    });

    @Override
    public int getServerSelectionTimeout() {
        return 0;
    }

    @Override
    public void setServerSelectionTimeout(int timeoutInMS) {
    }

    public SingleMongoConnectDriver() {
        for (MorphiumDriver.DriverStatsKey e : MorphiumDriver.DriverStatsKey.values()) {
            this.stats.put(e, new AtomicDecimal(0));
        }
    }

    @Override
    public <T, R> Aggregator<T, R> createAggregator(Morphium morphium, Class<? extends T> type, Class<? extends R> resultType) {
        return new AggregatorImpl<T, R>(morphium, type, resultType);
    }

    @Override
    public Map<MorphiumDriver.DriverStatsKey, Double> getDriverStats() {
        HashMap<MorphiumDriver.DriverStatsKey, Double> ret = new HashMap<MorphiumDriver.DriverStatsKey, Double>();
        HashMap<MorphiumDriver.DriverStatsKey, AtomicDecimal> hashMap = new HashMap<MorphiumDriver.DriverStatsKey, AtomicDecimal>(this.stats);
        for (Map.Entry entry : hashMap.entrySet()) {
            ret.put((MorphiumDriver.DriverStatsKey)((Object)entry.getKey()), ((AtomicDecimal)entry.getValue()).get());
        }
        if (this.connection != null) {
            for (Map.Entry<Object, Object> entry : this.connection.getStats().entrySet()) {
                ret.putIfAbsent((MorphiumDriver.DriverStatsKey)((Object)entry.getKey()), 0.0);
                ret.put((MorphiumDriver.DriverStatsKey)((Object)entry.getKey()), (Double)ret.get(entry.getKey()) + (Double)entry.getValue());
            }
        }
        return ret;
    }

    public MongoConnection getConnection() throws MorphiumDriverException {
        long waitUntil = System.currentTimeMillis() + (long)(this.getMaxWaitTime() * 5);
        while (this.connectionInUse) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (System.currentTimeMillis() <= waitUntil) continue;
            throw new MorphiumDriverException("could not get connection - still in use after " + this.getMaxWaitTime());
        }
        while (this.connection != null && !this.connection.isConnected()) {
            try {
                this.log.info("Waiting for heartbeat to fix connection...");
                int waitingCount = this.waitingForHeartbeatCounter.incrementAndGet();
                if (waitingCount > 20) {
                    if (this.heartbeat != null) {
                        this.heartbeat.cancel(true);
                    }
                    this.heartbeat = null;
                    this.waitingForHeartbeatCounter.set(0);
                    this.startHeartbeat();
                }
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (System.currentTimeMillis() <= waitUntil) continue;
            throw new MorphiumDriverException("could not get connection - not connected after " + this.getMaxWaitTime());
        }
        this.incStat(MorphiumDriver.DriverStatsKey.CONNECTIONS_BORROWED);
        this.connectionInUse = true;
        return new ConnectionWrapper(this.connection);
    }

    public ConnectionType getConnectionType() {
        return this.connectionType;
    }

    public SingleMongoConnectDriver setConnectionType(ConnectionType connectionType) {
        this.connectionType = connectionType;
        return this;
    }

    private String getHost(int hostSeedIndex) {
        return this.getHost(this.getHostSeed().get(hostSeedIndex));
    }

    private String getHost(String hostPort) {
        String[] h = hostPort.split(":");
        return h[0];
    }

    private int getPortFromHost(int hostSeedIdx) {
        return this.getPortFromHost(this.getHostSeed().get(hostSeedIdx));
    }

    private int getPortFromHost(String host) {
        String[] h = host.split(":");
        if (h.length == 1) {
            return 27017;
        }
        return Integer.parseInt(h[1]);
    }

    @Override
    public void connect() throws MorphiumDriverException {
        this.connect(null);
    }

    private double decStat(MorphiumDriver.DriverStatsKey k) {
        return this.stats.get((Object)k).decrementAndGet();
    }

    private double incStat(MorphiumDriver.DriverStatsKey k) {
        return this.stats.get((Object)k).incrementAndGet();
    }

    @Override
    public void connect(String replSet) throws MorphiumDriverException {
        int connectToIdx = 0;
        int retries = 0;
        while (true) {
            try {
                HelloResult hello;
                while (true) {
                    this.incStat(MorphiumDriver.DriverStatsKey.CONNECTIONS_OPENED);
                    if (connectToIdx >= this.getHostSeed().size()) {
                        connectToIdx = 0;
                    }
                    if (this.getHostSeed().isEmpty()) {
                        this.log.error("All hosts unavailable...");
                        throw new MorphiumDriverException("Could not connect!");
                    }
                    String host = this.getHostSeed().get(connectToIdx);
                    String[] h = host.split(":");
                    int port = 27017;
                    if (h.length > 1) {
                        port = Integer.parseInt(h[1]);
                    }
                    this.log.debug("Connecting to {}:{}", (Object)h[0], (Object)port);
                    this.connection = new SingleMongoConnection();
                    if (this.getAuthDb() != null) {
                        this.connection.setCredentials(this.getAuthDb(), this.getUser(), this.getPassword());
                    }
                    if ((hello = this.connection.connect(this, h[0], port)) == null) {
                        this.log.error("did not get hello back...");
                        if (++retries > this.getRetriesOnNetworkError()) {
                            this.log.error("Max retries reached - aborting");
                            throw new MorphiumDriverNetworkException("Could not connect to " + h[0] + ":" + port);
                        }
                        Thread.sleep(this.getSleepBetweenErrorRetries() * 10000);
                        continue;
                    }
                    if (hello.getHosts() != null) {
                        for (String s : hello.getHosts()) {
                            if (this.getHostSeed().contains(s)) continue;
                            this.addToHostSeed(s);
                            this.log.info("Adding {}", (Object)s);
                        }
                    }
                    for (String hst : new ArrayList<String>(this.getHostSeed())) {
                        if (hst.equals(hello.getPrimary()) || hello.getHosts().contains(hst)) continue;
                        this.log.debug("Host {} from hostseed is not part of replicaset anymore", (Object)hst);
                        this.removeFromHostSeed(hst);
                    }
                    if (hello.getPrimary() != null && !this.getHostSeed().contains(hello.getPrimary())) {
                        this.addToHostSeed(hello.getPrimary());
                    }
                    if (!this.getHostSeed().contains(this.connection.getConnectedTo())) {
                        this.log.debug("Hostname changed?!?!?");
                        this.close();
                        continue;
                    }
                    if (this.connectionType.equals((Object)ConnectionType.PRIMARY) && !Boolean.TRUE.equals(hello.getWritablePrimary())) {
                        this.log.debug("connecting-> want primary connection, got secondary, retrying");
                        this.connection.close();
                        this.incStat(MorphiumDriver.DriverStatsKey.CONNECTIONS_CLOSED);
                        this.connection = null;
                        Thread.sleep(1000L);
                        if (hello.getPrimary() != null) {
                            connectToIdx = this.getHostSeed().indexOf(hello.getPrimary());
                            continue;
                        }
                        if (++connectToIdx < this.getHostSeed().size()) continue;
                        this.log.debug("End of hostseed, starting over");
                        connectToIdx = 0;
                        continue;
                    }
                    if (!this.connectionType.equals((Object)ConnectionType.SECONDARY) || Boolean.TRUE.equals(hello.getSecondary())) break;
                    this.log.debug("want secondary connection, got other - retrying");
                    this.connection.close();
                    this.incStat(MorphiumDriver.DriverStatsKey.CONNECTIONS_CLOSED);
                    this.connection = null;
                    Thread.sleep(1000L);
                    if (++connectToIdx < this.getHostSeed().size()) continue;
                    this.log.debug("End of hostseed, starting over");
                    connectToIdx = 0;
                }
                this.setMaxBsonObjectSize(hello.getMaxBsonObjectSize());
                this.setMaxMessageSize(hello.getMaxMessageSizeBytes());
                this.setMaxWriteBatchSize(hello.getMaxWriteBatchSize());
            }
            catch (Exception e) {
                this.incStat(MorphiumDriver.DriverStatsKey.ERRORS);
                this.log.error("connection failed", (Throwable)e);
                if (++connectToIdx > this.getHostSeed().size()) {
                    connectToIdx = 0;
                }
                if (++retries > this.getRetriesOnNetworkError()) {
                    throw new MorphiumDriverException("max retries exceeded", e);
                }
                try {
                    Thread.sleep(this.getSleepBetweenErrorRetries());
                }
                catch (InterruptedException interruptedException) {}
                continue;
            }
            break;
        }
        this.startHeartbeat();
        this.incStat(MorphiumDriver.DriverStatsKey.CONNECTIONS_IN_POOL);
    }

    protected void startHeartbeat() {
        if (this.heartbeat == null) {
            this.heartbeat = this.executor.scheduleWithFixedDelay(() -> {
                try {
                    if (this.connectionInUse) {
                        return;
                    }
                    if (this.connection == null) {
                        return;
                    }
                    this.connectionInUse = true;
                    try {
                        HelloCommand cmd = new HelloCommand(this.connection).setHelloOk(true).setIncludeClient(false);
                        HelloResult hello = cmd.execute();
                        if (hello == null) {
                            this.log.warn("Could not run heartbeat!");
                            return;
                        }
                        if (this.connectionType.equals((Object)ConnectionType.PRIMARY) && !Boolean.TRUE.equals(hello.getWritablePrimary()) || this.connectionType.equals((Object)ConnectionType.SECONDARY) && !Boolean.TRUE.equals(hello.getSecondary())) {
                            this.log.warn("state change -> wanted {}, but changed, retrying", (Object)this.connectionType.name());
                            this.connection.close();
                            this.connection = null;
                            this.incStat(MorphiumDriver.DriverStatsKey.FAILOVERS);
                            this.decStat(MorphiumDriver.DriverStatsKey.CONNECTIONS_IN_POOL);
                            this.incStat(MorphiumDriver.DriverStatsKey.CONNECTIONS_CLOSED);
                            Thread.sleep(1000L);
                            this.connect(this.getReplicaSetName());
                        }
                    }
                    catch (MorphiumDriverException e) {
                        this.incStat(MorphiumDriver.DriverStatsKey.ERRORS);
                        this.log.error("Connection error", (Throwable)e);
                        this.log.warn("Trying reconnect");
                        try {
                            this.close();
                        }
                        catch (Exception hello) {
                            // empty catch block
                        }
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (InterruptedException hello) {
                            // empty catch block
                        }
                        try {
                            this.connect();
                        }
                        catch (MorphiumDriverException ex) {
                            this.log.error("Could not reconnect", (Throwable)ex);
                        }
                    }
                    catch (InterruptedException e) {
                    }
                    catch (Exception e) {
                        this.incStat(MorphiumDriver.DriverStatsKey.ERRORS);
                        this.log.error("Error during heartbeat", (Throwable)e);
                    }
                    finally {
                        this.connectionInUse = false;
                    }
                }
                catch (Throwable e) {
                    this.log.error("Heartbeat caught error", e);
                }
            }, 10L, this.getHeartbeatFrequency(), TimeUnit.MILLISECONDS);
        } else {
            this.log.debug("Heartbeat already scheduled...");
        }
    }

    @Override
    public void watch(WatchCommand settings) throws MorphiumDriverException {
        this.connection.watch(settings);
    }

    @Override
    public void releaseConnection(MongoConnection con) {
        this.incStat(MorphiumDriver.DriverStatsKey.CONNECTIONS_RELEASED);
        this.connectionInUse = false;
        if (con instanceof ConnectionWrapper) {
            ((ConnectionWrapper)con).setDelegate(null);
        }
    }

    @Override
    public void closeConnection(MongoConnection con) {
        this.releaseConnection(con);
    }

    @Override
    public MongoConnection getReadConnection(ReadPreference rp) {
        try {
            return this.getConnection();
        }
        catch (MorphiumDriverException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public MongoConnection getPrimaryConnection(WriteConcern wc) {
        try {
            return this.getConnection();
        }
        catch (MorphiumDriverException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void close() {
        this.incStat(MorphiumDriver.DriverStatsKey.CONNECTIONS_CLOSED);
        this.decStat(MorphiumDriver.DriverStatsKey.CONNECTIONS_IN_POOL);
        try {
            if (this.connection != null) {
                this.connection.close();
                this.connection = null;
            }
        }
        catch (Exception e) {
            this.log.warn("Problem when closing connection", (Throwable)e);
        }
        if (this.heartbeat != null) {
            this.heartbeat.cancel(true);
        }
        this.heartbeat = null;
        this.connectionInUse = false;
    }

    @Override
    public String getName() {
        return driverName;
    }

    @Override
    public void setConnectionUrl(String connectionUrl) {
    }

    @Override
    public boolean isConnected() {
        return this.connection != null && this.connection.isConnected();
    }

    @Override
    public void commitTransaction() throws MorphiumDriverException {
        if (this.getTransactionContext() == null) {
            throw new IllegalArgumentException("No transaction in progress, cannot commit");
        }
        MorphiumTransactionContext ctx = this.getTransactionContext();
        CommitTransactionCommand cmd = new CommitTransactionCommand(this.connection).setTxnNumber(ctx.getTxnNumber()).setAutocommit(false).setLsid(ctx.getLsid());
        cmd.execute();
        this.clearTransactionContext();
    }

    @Override
    public void abortTransaction() throws MorphiumDriverException {
        if (this.getTransactionContext() == null) {
            throw new IllegalArgumentException("No transaction in progress, cannot abort");
        }
        MorphiumTransactionContext ctx = this.getTransactionContext();
        AbortTransactionCommand cmd = new AbortTransactionCommand(this.connection).setTxnNumber(ctx.getTxnNumber()).setAutocommit(false).setLsid(ctx.getLsid());
        cmd.execute();
        this.clearTransactionContext();
    }

    @Override
    public Map<String, Object> getCollStats(String db, String coll) throws MorphiumDriverException {
        CollStatsCommand cmd = new CollStatsCommand(this.connection);
        return cmd.execute();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, Object> getReplsetStatus() throws MorphiumDriverException {
        MongoCommand cmd = null;
        try {
            cmd = new ReplicastStatusCommand(this.getPrimaryConnection(null));
            Map<String, Object> result = ((ReplicastStatusCommand)cmd).execute();
            List mem = (List)result.get("members");
            if (mem == null) {
                Map<String, Object> map = null;
                return map;
            }
            mem.stream().filter(d -> d.get("optime") instanceof Map).forEach(d -> d.put("optime", ((Map)d.get("optime")).get("ts")));
            Map<String, Object> map = result;
            return map;
        }
        finally {
            if (cmd != null && cmd.getConnection() != null) {
                cmd.releaseConnection();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, Object> getDBStats(String db) throws MorphiumDriverException {
        MongoCommand cmd = null;
        try {
            cmd = (DbStatsCommand)new DbStatsCommand(this.getPrimaryConnection(null)).setDb(db);
            Map<String, Object> map = ((DbStatsCommand)cmd).execute();
            return map;
        }
        finally {
            if (cmd != null) {
                cmd.releaseConnection();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Map<String, Object>> currentOp(int threshold) throws MorphiumDriverException {
        MongoCommand cmd = null;
        try {
            cmd = ((CurrentOpCommand)new CurrentOpCommand(this.connection).setColl("admin")).setSecsRunning(threshold);
            List<Map<String, Object>> list = ((CurrentOpCommand)cmd).execute();
            return list;
        }
        finally {
            if (cmd != null) {
                cmd.releaseConnection();
            }
        }
    }

    @Override
    public BulkRequestContext createBulkContext(Morphium m, final String db, final String collection, boolean ordered, final WriteConcern wc) {
        return new BulkRequestContext(this, m){
            private final List<BulkRequest> requests;
            final /* synthetic */ SingleMongoConnectDriver this$0;
            {
                this.this$0 = this$0;
                super(m);
                this.requests = new ArrayList<BulkRequest>();
            }

            public Doc execute() {
                int delCount = 0;
                int matchedCount = 0;
                int insertCount = 0;
                int modifiedCount = 0;
                ArrayList upsertedIds = new ArrayList();
                try {
                    for (BulkRequest r : this.requests) {
                        Map<String, Object> result;
                        MongoConnection c;
                        if (r instanceof InsertBulkRequest) {
                            MongoConnection c2 = this.this$0.getPrimaryConnection(wc);
                            InsertMongoCommand settings = new InsertMongoCommand(c2);
                            ((InsertMongoCommand)((InsertMongoCommand)settings.setDb(db)).setColl(collection)).setComment("Bulk insert").setDocuments(((InsertBulkRequest)r).getToInsert());
                            Map<String, Object> result2 = settings.execute();
                            settings.releaseConnection();
                            insertCount += ((InsertBulkRequest)r).getToInsert().size();
                            continue;
                        }
                        if (r instanceof UpdateBulkRequest) {
                            UpdateBulkRequest up = (UpdateBulkRequest)r;
                            c = this.this$0.getPrimaryConnection(wc);
                            UpdateMongoCommand upCmd = new UpdateMongoCommand(c);
                            ((UpdateMongoCommand)((UpdateMongoCommand)upCmd.setColl(collection)).setDb(db)).setUpdates(Arrays.asList(Doc.of("q", up.getQuery(), "u", up.getCmd(), "upsert", (Object)up.isUpsert(), "multi", (Object)up.isMultiple())));
                            result = upCmd.execute();
                            upCmd.releaseConnection();
                            if (result.containsKey("n")) {
                                matchedCount += ((Number)result.get("n")).intValue();
                            }
                            if (result.containsKey("nModified")) {
                                modifiedCount += ((Number)result.get("nModified")).intValue();
                            }
                            if (!result.containsKey("upserted")) continue;
                            List upserted = (List)result.get("upserted");
                            for (Map u : upserted) {
                                upsertedIds.add(u.get("_id"));
                            }
                            continue;
                        }
                        if (r instanceof DeleteBulkRequest) {
                            DeleteBulkRequest dbr = (DeleteBulkRequest)r;
                            c = this.this$0.getPrimaryConnection(wc);
                            DeleteMongoCommand del = new DeleteMongoCommand(c);
                            ((DeleteMongoCommand)((DeleteMongoCommand)del.setColl(collection)).setDb(db)).setDeletes(Arrays.asList(Doc.of("q", dbr.getQuery(), "limit", (Object)(dbr.isMultiple() ? 0 : 1))));
                            result = del.execute();
                            del.releaseConnection();
                            if (!result.containsKey("n")) continue;
                            delCount += ((Number)result.get("n")).intValue();
                            continue;
                        }
                        throw new RuntimeException("Unknown operation " + r.getClass().getName());
                    }
                }
                catch (MorphiumDriverException e) {
                    this.this$0.log.error("Got exception: ", (Throwable)e);
                }
                Doc res = Doc.of("num_deleted", (Object)delCount, "num_matched", (Object)matchedCount, "num_inserted", (Object)insertCount, "num_modified", (Object)modifiedCount, "num_upserts", (Object)upsertedIds.size());
                if (!upsertedIds.isEmpty()) {
                    res.put("upsertedIds", upsertedIds);
                }
                return res;
            }

            @Override
            public UpdateBulkRequest addUpdateBulkRequest() {
                UpdateBulkRequest up = new UpdateBulkRequest();
                this.requests.add(up);
                return up;
            }

            @Override
            public InsertBulkRequest addInsertBulkRequest(List<Map<String, Object>> toInsert) {
                InsertBulkRequest in = new InsertBulkRequest(toInsert);
                this.requests.add(in);
                return in;
            }

            @Override
            public DeleteBulkRequest addDeleteBulkRequest() {
                DeleteBulkRequest del = new DeleteBulkRequest();
                this.requests.add(del);
                return del;
            }
        };
    }

    public void closeIteration(MorphiumCursor crs) throws MorphiumDriverException {
        if (crs == null) {
            return;
        }
        this.killCursors(crs.getDb(), crs.getCollection(), crs.getCursorId());
    }

    protected void killCursors(String db, String coll, long ... ids) throws MorphiumDriverException {
        ArrayList<Long> cursorIds = new ArrayList<Long>();
        for (long l : ids) {
            if (l == 0L) continue;
            cursorIds.add(l);
        }
        if (cursorIds.isEmpty()) {
            return;
        }
        KillCursorsCommand k = (KillCursorsCommand)((KillCursorsCommand)new KillCursorsCommand(this.connection).setCursors(cursorIds).setDb(db)).setColl(coll);
        Map<String, Object> ret = k.execute();
        this.log.debug("killed cursor");
    }

    private List<Map<String, Object>> readBatches(int waitingfor, int batchSize) throws MorphiumDriverException {
        ArrayList<Map<String, Object>> ret = new ArrayList<Map<String, Object>>();
        String db = null;
        String coll = null;
        while (true) {
            OpMsg reply;
            if ((reply = this.connection.readNextMessage(this.getMaxWaitTime())).getResponseTo() != waitingfor) {
                this.log.error("Wrong answer - waiting for {} but got {}", (Object)waitingfor, (Object)reply.getResponseTo());
                this.log.error("Document: {}", (Object)Utils.toJsonString(reply.getFirstDoc()));
                continue;
            }
            Map cursor = (Map)reply.getFirstDoc().get("cursor");
            if (cursor == null) {
                if (reply.getFirstDoc().get("result") != null) {
                    return (List)reply.getFirstDoc().get("result");
                }
                if (reply.getFirstDoc().containsKey("results")) {
                    return (List)reply.getFirstDoc().get("results");
                }
                throw new MorphiumDriverException("Mongo Error: " + String.valueOf(reply.getFirstDoc().get("codeName")) + " - " + String.valueOf(reply.getFirstDoc().get("errmsg")));
            }
            if (db == null) {
                String[] namespace = cursor.get("ns").toString().split("\\.");
                db = namespace[0];
                if (namespace.length > 1) {
                    coll = namespace[1];
                }
            }
            if (cursor.get("firstBatch") != null) {
                ret.addAll((List)cursor.get("firstBatch"));
            } else if (cursor.get("nextBatch") != null) {
                ret.addAll((List)cursor.get("nextBatch"));
            }
            if ((Long)cursor.get("id") == 0L) break;
            OpMsg q = new OpMsg();
            q.setFirstDoc(Doc.of("getMore", cursor.get("id")).add("$db", db).add("batchSize", batchSize));
            if (coll != null) {
                q.getFirstDoc().put("collection", coll);
            }
            q.setMessageId(this.getNextId());
            waitingfor = q.getMessageId();
            this.connection.sendQuery(q);
        }
        return ret;
    }

    @Override
    public boolean exists(String db) throws MorphiumDriverException {
        List<String> databases = this.listDatabases();
        return databases != null && databases.contains(db);
    }

    public Map<String, Object> getDbStats(String db) throws MorphiumDriverException {
        return this.getDbStats(db, false);
    }

    public Map<String, Object> getDbStats(String db, boolean withStorage) throws MorphiumDriverException {
        return (Map)new NetworkCallHelper().doCall(() -> {
            OpMsg msg = new OpMsg();
            msg.setMessageId(this.getNextId());
            Doc v = Doc.of("dbStats", (Object)1, "scale", (Object)1024);
            v.put("$db", db);
            if (withStorage) {
                v.put("freeStorage", 1);
            }
            msg.setFirstDoc(v);
            this.connection.sendQuery(msg);
            OpMsg reply = this.connection.readNextMessage(this.getMaxWaitTime());
            return reply.getFirstDoc();
        }, this.getRetriesOnNetworkError(), this.getSleepBetweenErrorRetries(), t -> {
            this.close();
            this.connect();
        });
    }

    private List<Map<String, Object>> getCollectionInfo(String db, String collection) throws MorphiumDriverException {
        return (List)new NetworkCallHelper().doCall(() -> {
            Doc cmd = new Doc();
            cmd.put("listCollections", 1);
            OpMsg q = new OpMsg();
            q.setMessageId(this.getNextId());
            if (collection != null) {
                cmd.put("filter", Doc.of("name", collection));
            }
            cmd.put("$db", db);
            q.setFirstDoc(cmd);
            q.setFlags(0);
            q.setResponseTo(0);
            this.connection.sendQuery(q);
            List<Map<String, Object>> ret = this.readBatches(q.getMessageId(), this.getMaxWriteBatchSize());
            return ret;
        }, this.getRetriesOnNetworkError(), this.getSleepBetweenErrorRetries(), t -> {
            this.close();
            this.connect();
        });
    }

    @Override
    public boolean isCapped(String db, String coll) throws MorphiumDriverException {
        List<Map<String, Object>> lst = this.getCollectionInfo(db, coll);
        try {
            if (!lst.isEmpty() && lst.get(0).get("name").equals(coll)) {
                Object capped = ((Map)lst.get(0).get("options")).get("capped");
                return capped != null && capped.equals(true);
            }
        }
        catch (Exception e) {
            this.log.error("Error", (Throwable)e);
        }
        return false;
    }

    @Override
    public Map<String, Integer> getNumConnectionsByHost() {
        return UtilsMap.of(this.connection.getConnectedTo(), 1);
    }

    @Override
    public void setIdleSleepTime(int sl) {
        this.idleSleepTime = sl;
    }

    @Override
    public int getIdleSleepTime() {
        return this.idleSleepTime;
    }

    private class ConnectionWrapper
    implements MongoConnection {
        private MongoConnection delegate;

        public MongoConnection getDelegate() {
            if (this.delegate == null) {
                throw new RuntimeException("Cannot get delegate - Connection released!");
            }
            return this.delegate;
        }

        public ConnectionWrapper(MongoConnection con) {
            this.delegate = con;
        }

        public void setDelegate(MongoConnection con) {
            this.delegate = con;
        }

        @Override
        public MorphiumDriver getDriver() {
            return SingleMongoConnectDriver.this;
        }

        @Override
        public int getSourcePort() {
            return 0;
        }

        @Override
        public void setCredentials(String authDb, String userName, String password) {
            this.delegate.setCredentials(authDb, userName, password);
        }

        @Override
        public HelloResult connect(MorphiumDriver drv, String host, int port) throws IOException, MorphiumDriverException {
            return this.getDelegate().connect(drv, host, port);
        }

        @Override
        public void close() {
            SingleMongoConnectDriver.this.releaseConnection(this.getDelegate());
            this.getDelegate().close();
        }

        @Override
        public boolean isConnected() {
            return this.getDelegate().isConnected();
        }

        @Override
        public String getConnectedTo() {
            return this.getDelegate().getConnectedTo();
        }

        @Override
        public String getConnectedToHost() {
            return this.getDelegate().getConnectedToHost();
        }

        @Override
        public int getConnectedToPort() {
            return this.getDelegate().getConnectedToPort();
        }

        @Override
        public void closeIteration(MorphiumCursor crs) throws MorphiumDriverException {
            this.getDelegate().closeIteration(crs);
        }

        @Override
        public Map<String, Object> killCursors(String db, String coll, long ... ids) throws MorphiumDriverException {
            return (Map)new NetworkCallHelper().doCall(() -> this.getDelegate().killCursors(db, coll, ids), SingleMongoConnectDriver.this.getRetriesOnNetworkError(), SingleMongoConnectDriver.this.getSleepBetweenErrorRetries(), t -> {
                this.close();
                SingleMongoConnectDriver.this.connect();
            });
        }

        @Override
        public OpMsg readNextMessage(int timeout) throws MorphiumDriverException {
            return (OpMsg)new NetworkCallHelper().doCall(() -> this.getDelegate().readNextMessage(timeout), SingleMongoConnectDriver.this.getRetriesOnNetworkError(), SingleMongoConnectDriver.this.getSleepBetweenErrorRetries(), t -> {
                this.close();
                SingleMongoConnectDriver.this.connect();
            });
        }

        @Override
        public Map<String, Object> readSingleAnswer(int id) throws MorphiumDriverException {
            return (Map)new NetworkCallHelper().doCall(() -> this.getDelegate().readSingleAnswer(id), SingleMongoConnectDriver.this.getRetriesOnNetworkError(), SingleMongoConnectDriver.this.getSleepBetweenErrorRetries(), t -> {
                this.close();
                SingleMongoConnectDriver.this.connect();
            });
        }

        @Override
        public void watch(WatchCommand settings) throws MorphiumDriverException {
            new NetworkCallHelper().doCall(() -> {
                this.getDelegate().watch(settings);
                return null;
            }, SingleMongoConnectDriver.this.getRetriesOnNetworkError(), SingleMongoConnectDriver.this.getSleepBetweenErrorRetries(), t -> {
                if (t.getMessage().contains("Socket closed")) {
                    SingleMongoConnectDriver.this.log.info("Socket closed");
                    this.close();
                }
                this.close();
                SingleMongoConnectDriver.this.connect();
            });
        }

        @Override
        public List<Map<String, Object>> readAnswerFor(int queryId) throws MorphiumDriverException {
            return (List)new NetworkCallHelper().doCall(() -> this.getDelegate().readAnswerFor(queryId), SingleMongoConnectDriver.this.getRetriesOnNetworkError(), SingleMongoConnectDriver.this.getSleepBetweenErrorRetries(), t -> {
                this.close();
                SingleMongoConnectDriver.this.connect();
            });
        }

        @Override
        public MorphiumCursor getAnswerFor(int queryId, int batchsize) throws MorphiumDriverException {
            return (MorphiumCursor)new NetworkCallHelper().doCall(() -> this.getDelegate().getAnswerFor(queryId, batchsize), SingleMongoConnectDriver.this.getRetriesOnNetworkError(), SingleMongoConnectDriver.this.getSleepBetweenErrorRetries(), t -> {
                this.close();
                SingleMongoConnectDriver.this.connect();
            });
        }

        @Override
        public List<Map<String, Object>> readAnswerFor(MorphiumCursor crs) throws MorphiumDriverException {
            return (List)new NetworkCallHelper().doCall(() -> this.getDelegate().readAnswerFor(crs), SingleMongoConnectDriver.this.getRetriesOnNetworkError(), SingleMongoConnectDriver.this.getSleepBetweenErrorRetries(), t -> {
                this.close();
                SingleMongoConnectDriver.this.connect();
            });
        }

        @Override
        public int sendCommand(MongoCommand cmd) throws MorphiumDriverException {
            return (Integer)new NetworkCallHelper().doCall(() -> this.getDelegate().sendCommand(cmd), SingleMongoConnectDriver.this.getRetriesOnNetworkError(), SingleMongoConnectDriver.this.getSleepBetweenErrorRetries(), t -> {
                this.close();
                SingleMongoConnectDriver.this.connect();
            });
        }
    }
}

