/*
 * Decompiled with CFR 0.152.
 */
package de.caluga.morphium.driver.wire;

import de.caluga.morphium.Morphium;
import de.caluga.morphium.aggregation.Aggregator;
import de.caluga.morphium.aggregation.AggregatorImpl;
import de.caluga.morphium.annotations.Driver;
import de.caluga.morphium.driver.Doc;
import de.caluga.morphium.driver.MorphiumCursor;
import de.caluga.morphium.driver.MorphiumDriver;
import de.caluga.morphium.driver.MorphiumDriverException;
import de.caluga.morphium.driver.MorphiumTransactionContext;
import de.caluga.morphium.driver.ReadPreference;
import de.caluga.morphium.driver.ReadPreferenceType;
import de.caluga.morphium.driver.WriteConcern;
import de.caluga.morphium.driver.bulk.BulkRequest;
import de.caluga.morphium.driver.bulk.BulkRequestContext;
import de.caluga.morphium.driver.bulk.DeleteBulkRequest;
import de.caluga.morphium.driver.bulk.InsertBulkRequest;
import de.caluga.morphium.driver.bulk.UpdateBulkRequest;
import de.caluga.morphium.driver.commands.AbortTransactionCommand;
import de.caluga.morphium.driver.commands.CollStatsCommand;
import de.caluga.morphium.driver.commands.CommitTransactionCommand;
import de.caluga.morphium.driver.commands.CurrentOpCommand;
import de.caluga.morphium.driver.commands.DbStatsCommand;
import de.caluga.morphium.driver.commands.DeleteMongoCommand;
import de.caluga.morphium.driver.commands.InsertMongoCommand;
import de.caluga.morphium.driver.commands.KillCursorsCommand;
import de.caluga.morphium.driver.commands.ListCollectionsCommand;
import de.caluga.morphium.driver.commands.MongoCommand;
import de.caluga.morphium.driver.commands.ReplicastStatusCommand;
import de.caluga.morphium.driver.commands.UpdateMongoCommand;
import de.caluga.morphium.driver.commands.WatchCommand;
import de.caluga.morphium.driver.wire.AtomicDecimal;
import de.caluga.morphium.driver.wire.DriverBase;
import de.caluga.morphium.driver.wire.HelloResult;
import de.caluga.morphium.driver.wire.MongoConnection;
import de.caluga.morphium.driver.wire.NetworkCallHelper;
import de.caluga.morphium.driver.wire.SingleMongoConnection;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Driver(name="PooledDriver", description="Driver with connection pool")
public class PooledDriver
extends DriverBase {
    public static final String driverName = "PooledDriver";
    private final Map<String, BlockingQueue<ConnectionContainer>> connectionPool;
    private final Map<Integer, ConnectionContainer> borrowedConnections;
    private final Map<MorphiumDriver.DriverStatsKey, AtomicDecimal> stats;
    private volatile long fastestTime = 10000L;
    private int idleSleepTime = 5;
    private volatile String fastestHost = null;
    private Map<String, Long> pingTimesPerHost = new ConcurrentHashMap<String, Long>();
    private final Map<String, PingStats> pingStatsPerHost = new ConcurrentHashMap<String, PingStats>();
    private final Logger log = LoggerFactory.getLogger(PooledDriver.class);
    private volatile String primaryNode;
    private final ScheduledThreadPoolExecutor executor = new ScheduledThreadPoolExecutor(5, Thread.ofVirtual().name("MCon-", 0L).factory());
    private final AtomicInteger lastSecondaryNode = new AtomicInteger(0);
    private final Map<String, Thread> hostThreads = new ConcurrentHashMap<String, Thread>();
    private int serverSelectionTimeout = 2000;
    private volatile StatsSnapshot cachedStats = null;
    private volatile long lastStatsUpdate = 0L;
    private static final long STATS_CACHE_TTL = 1000L;
    private volatile ScheduledFuture<?> heartbeat;
    private final Object waitCounterSignal = new Object();
    private final Map<String, AtomicInteger> waitCounter = new ConcurrentHashMap<String, AtomicInteger>();
    private List<String> lastHostsFromHello = null;

    public PooledDriver() {
        this.connectionPool = new HashMap<String, BlockingQueue<ConnectionContainer>>();
        this.borrowedConnections = Collections.synchronizedMap(new HashMap());
        this.stats = new ConcurrentHashMap<MorphiumDriver.DriverStatsKey, AtomicDecimal>();
        for (MorphiumDriver.DriverStatsKey e : MorphiumDriver.DriverStatsKey.values()) {
            this.stats.put(e, new AtomicDecimal(0));
        }
    }

    @Override
    public int getServerSelectionTimeout() {
        return this.serverSelectionTimeout;
    }

    @Override
    public void setServerSelectionTimeout(int timeoutInMS) {
        this.serverSelectionTimeout = timeoutInMS;
    }

    @Override
    public void connect(String replSet) throws MorphiumDriverException {
        for (String host : this.getHostSeed()) {
            this.connectionPool.put(host, new LinkedBlockingQueue());
        }
        this.setReplicaSet(this.getHostSeed().size() > 1);
        this.startHeartbeat();
    }

    @Override
    public ReadPreference getDefaultReadPreference() {
        return ReadPreference.nearest();
    }

    @Override
    public synchronized void removeFromHostSeed(String host) {
        super.removeFromHostSeed(host);
        this.pingTimesPerHost.remove(host);
        this.pingStatsPerHost.remove(host);
        if (this.getNumHostsInSeed() == 0) {
            if (this.lastHostsFromHello == null) {
                this.log.warn("Wanted to remove last host in hostseed, but last hosts is null");
                this.addToHostSeed(host);
            } else {
                this.setHostSeed(this.lastHostsFromHello);
            }
        }
    }

    private String getHost(String hostPort) {
        if (hostPort == null) {
            return "";
        }
        String[] h = hostPort.split(":");
        return h[0];
    }

    private int getPortFromHost(String host) {
        String[] h = host.split(":");
        if (h.length == 1) {
            return 27017;
        }
        return Integer.parseInt(h[1]);
    }

    @Override
    public void connect() throws MorphiumDriverException {
        this.connect(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleHelloResult(HelloResult hello, String hostConnected) {
        if (hello == null) {
            return;
        }
        if (hello.getWritablePrimary() != null && hello.getWritablePrimary().booleanValue() && hello.getMe() == null) {
            if (hello.getWritablePrimary().booleanValue() && this.primaryNode == null) {
                this.primaryNode = hostConnected;
            } else if (!hostConnected.equals(this.primaryNode)) {
                this.log.warn("Primary failover? {} -> {}", (Object)this.primaryNode, (Object)hello.getMe());
                this.stats.get((Object)MorphiumDriver.DriverStatsKey.FAILOVERS).incrementAndGet();
                this.primaryNode = hostConnected;
            } else if (!hello.getWritablePrimary().booleanValue() && hostConnected.equals(this.primaryNode)) {
                this.log.error("Primary node is not me {}", (Object)hello.getMe());
                this.primaryNode = null;
            }
        } else if (hello.getWritablePrimary() != null && hello.getMe() != null) {
            if (this.primaryNode == null && hello.getPrimary() != null) {
                this.primaryNode = hello.getPrimary();
            } else if (hello.getWritablePrimary().booleanValue() && !hello.getMe().equals(this.primaryNode)) {
                this.log.warn("Primary failover? {} -> {}", (Object)this.primaryNode, (Object)hello.getMe());
                this.stats.get((Object)MorphiumDriver.DriverStatsKey.FAILOVERS).incrementAndGet();
                this.primaryNode = hello.getMe();
            } else if (!hello.getWritablePrimary().booleanValue() && hello.getMe().equals(this.primaryNode)) {
                this.log.error("Primary node is not me {}", (Object)hello.getMe());
                this.primaryNode = null;
            }
        }
        if (hello.getHosts() != null && !hello.getHosts().isEmpty()) {
            Iterator iterator;
            this.lastHostsFromHello = hello.getHosts();
            for (String hst : hello.getHosts()) {
                iterator = this.connectionPool;
                synchronized (iterator) {
                    if (!this.connectionPool.containsKey(hst)) {
                        this.connectionPool.put(hst, new LinkedBlockingQueue());
                    }
                }
                this.addToHostSeed(hst);
            }
            for (String hst : this.getHostSeed()) {
                if (hello.getHosts().contains(hst)) continue;
                this.removeFromHostSeed(hst);
                iterator = this.waitCounter;
                synchronized (iterator) {
                    this.waitCounter.remove(hst);
                }
            }
            ArrayList<ConnectionContainer> toClose = new ArrayList<ConnectionContainer>();
            Map<String, BlockingQueue<ConnectionContainer>> map = this.connectionPool;
            synchronized (map) {
                for (String host : new ArrayList<String>(this.connectionPool.keySet())) {
                    if (hello.getHosts().contains(host)) continue;
                    this.log.warn("Host {} is not part of the replicaset anymore!", (Object)host);
                    this.removeFromHostSeed(host);
                    Map<String, AtomicInteger> map2 = this.waitCounter;
                    synchronized (map2) {
                        this.waitCounter.remove(host);
                    }
                    BlockingQueue<ConnectionContainer> lst = this.connectionPool.remove(host);
                    ArrayList<Integer> toDelete = new ArrayList<Integer>();
                    for (Map.Entry<Integer, ConnectionContainer> e : new ArrayList<Map.Entry<Integer, ConnectionContainer>>(this.borrowedConnections.entrySet())) {
                        if (!e.getValue().getCon().getConnectedToHost().equals(host)) continue;
                        toDelete.add(e.getKey());
                    }
                    for (Integer i : toDelete) {
                        this.borrowedConnections.remove(i);
                    }
                    if (this.fastestHost != null && this.fastestHost.equals(host)) {
                        this.fastestHost = null;
                        this.fastestTime = 10000L;
                    }
                    toClose.addAll(lst);
                }
                for (ConnectionContainer con : toClose) {
                    try {
                        con.getCon().close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    this.stats.get((Object)MorphiumDriver.DriverStatsKey.CONNECTIONS_CLOSED).incrementAndGet();
                }
            }
        }
    }

    protected synchronized void startHeartbeat() {
        if (this.heartbeat == null) {
            this.heartbeat = this.executor.scheduleWithFixedDelay(() -> {
                for (String hst : this.getHostSeed()) {
                    BlockingQueue<ConnectionContainer> connectionPoolForHost = null;
                    Map<String, BlockingQueue<ConnectionContainer>> map = this.connectionPool;
                    synchronized (map) {
                        connectionPoolForHost = this.connectionPool.get(hst);
                    }
                    if (connectionPoolForHost != null) {
                        try {
                            ConnectionContainer connection;
                            int len = connectionPoolForHost.size();
                            for (int i = 0; i < len && (connection = connectionPoolForHost.poll(1L, TimeUnit.MILLISECONDS)) != null; ++i) {
                                long now = System.currentTimeMillis();
                                if (connection.getLastUsed() < now - (long)this.getMaxConnectionIdleTime() || connection.getCreated() < now - (long)this.getMaxConnectionLifetime()) {
                                    this.log.debug("connection to host:{} too long idle {}ms or just too old {}ms -> remove", new Object[]{connection.getCon().getConnectedToHost(), this.getMaxConnectionIdleTime(), this.getMaxConnectionLifetime()});
                                    try {
                                        connection.getCon().close();
                                    }
                                    catch (Exception exception) {
                                        // empty catch block
                                    }
                                    this.stats.get((Object)MorphiumDriver.DriverStatsKey.CONNECTIONS_CLOSED).incrementAndGet();
                                    continue;
                                }
                                connectionPoolForHost.add(connection);
                            }
                        }
                        catch (Throwable len) {
                            // empty catch block
                        }
                    }
                    if (this.hostThreads.containsKey(hst)) continue;
                    Thread t = Thread.ofVirtual().name("HeartbeatCheck-" + hst).start(() -> {
                        try {
                            this.waitCounter.putIfAbsent(hst, new AtomicInteger());
                            ConnectionContainer container = null;
                            Map<String, BlockingQueue<ConnectionContainer>> map = this.connectionPool;
                            synchronized (map) {
                                if (this.connectionPool.get(hst) == null) {
                                    this.log.warn("No connectionPool for host {} creating new ConnectionContainer", (Object)hst);
                                    container = new ConnectionContainer(this, new SingleMongoConnection());
                                } else {
                                    container = this.connectionPool.get(hst).poll(1L, TimeUnit.MILLISECONDS);
                                }
                            }
                            if (container != null) {
                                long start = System.currentTimeMillis();
                                HelloResult result = container.getCon().isConnected() ? container.getCon().getHelloResult(false) : container.getCon().connect(this, this.getHost(hst), this.getPortFromHost(hst));
                                long dur = System.currentTimeMillis() - start;
                                this.pingTimesPerHost.put(hst, dur);
                                PingStats newStats = this.pingStatsPerHost.compute(hst, (host, oldStats) -> oldStats == null ? new PingStats(dur, dur, dur, dur, 1, System.currentTimeMillis()) : oldStats.updateWith(dur));
                                this.updateFastestHost(hst, newStats);
                                this.handleHelloResult(result, String.format("%s:%d", this.getHost(hst), this.getPortFromHost(hst)));
                                Map<String, BlockingQueue<ConnectionContainer>> map2 = this.connectionPool;
                                synchronized (map2) {
                                    if (this.connectionPool.containsKey(hst) && this.getTotalConnectionsToHost(hst) < this.getMaxConnectionsPerHost()) {
                                        this.connectionPool.get(hst).add(container);
                                    } else {
                                        container.getCon().close();
                                        this.stats.get((Object)MorphiumDriver.DriverStatsKey.CONNECTIONS_CLOSED).incrementAndGet();
                                    }
                                }
                            }
                            BlockingQueue<ConnectionContainer> queue = null;
                            Map<String, BlockingQueue<ConnectionContainer>> map3 = this.connectionPool;
                            synchronized (map3) {
                                queue = this.connectionPool.get(hst);
                            }
                            int wait = this.getWaitCounterForHost(hst);
                            for (int loopCounter = 0; this.getHostSeed().contains(hst) && queue != null && loopCounter < this.getMaxConnectionsPerHost() && (queue.size() < wait && this.getTotalConnectionsToHost(hst) < this.getMaxConnectionsPerHost() || this.getTotalConnectionsToHost(hst) < this.getMinConnectionsPerHost()); ++loopCounter) {
                                this.createNewConnection(hst);
                            }
                        }
                        catch (Throwable e) {
                            this.log.error("Could not create connection to host {}", (Object)hst, (Object)e);
                            this.onConnectionError(hst);
                        }
                        finally {
                            this.hostThreads.remove(hst);
                        }
                    });
                    this.hostThreads.put(hst, t);
                }
            }, 0L, this.getHeartbeatFrequency(), TimeUnit.MILLISECONDS);
            Thread.ofVirtual().name("ConnectionWaiter").start(() -> {
                while (this.heartbeat != null) {
                    try {
                        Object object = this.waitCounterSignal;
                        synchronized (object) {
                            this.waitCounterSignal.wait();
                        }
                        for (String hst : this.getHostSeed()) {
                            try {
                                BlockingQueue<ConnectionContainer> queue = null;
                                Map<String, BlockingQueue<ConnectionContainer>> map = this.connectionPool;
                                synchronized (map) {
                                    queue = this.connectionPool.get(hst);
                                }
                                for (int loopCounter = 0; this.getHostSeed().contains(hst) && queue != null && loopCounter < this.getMaxConnectionsPerHost() && queue.size() < this.getWaitCounterForHost(hst) && this.getTotalConnectionsToHost(hst) < this.getMaxConnectionsPerHost(); ++loopCounter) {
                                    this.createNewConnection(hst);
                                }
                            }
                            catch (Exception e) {
                                this.log.error("Could not create connection to {}", (Object)hst, (Object)e);
                                this.onConnectionError(hst);
                            }
                        }
                    }
                    catch (Throwable e) {
                        this.log.error("error", e);
                        this.stats.get((Object)MorphiumDriver.DriverStatsKey.ERRORS).incrementAndGet();
                    }
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getWaitCounterForHost(String hst) {
        Map<String, AtomicInteger> map = this.waitCounter;
        synchronized (map) {
            this.waitCounter.putIfAbsent(hst, new AtomicInteger());
            return this.waitCounter.get(hst).get();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void updateFastestHost(String host, PingStats stats) {
        PingStats pingStats = stats;
        Objects.requireNonNull(pingStats);
        PingStats pingStats2 = pingStats;
        int n = 0;
        while (true) {
            long l;
            long avg;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{PingStats.class}, (Object)pingStats2, n)) {
                case 0: {
                    PingStats pingStats3 = pingStats2;
                    try {
                        int n2;
                        long l2;
                        long l3 = l2 = pingStats3.lastPing();
                        long last = l2;
                        l3 = l2 = pingStats3.averagePing();
                        avg = l2;
                        l3 = l2 = pingStats3.minPing();
                        long min = l2;
                        l3 = l2 = pingStats3.maxPing();
                        long max = l2;
                        int n3 = n2 = pingStats3.sampleCount();
                        int count = n2;
                        l3 = l = pingStats3.lastUpdated();
                        break;
                    }
                    catch (Throwable throwable) {
                        throw new MatchException(throwable.toString(), throwable);
                    }
                }
                default: {
                    return;
                }
            }
            long updated = l;
            if (avg < this.fastestTime) {
                this.fastestTime = avg;
                this.fastestHost = host;
                return;
            }
            n = 1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onConnectionError(String host) {
        BlockingQueue<ConnectionContainer> connectionsList;
        this.stats.get((Object)MorphiumDriver.DriverStatsKey.ERRORS).incrementAndGet();
        Object object = this.connectionPool;
        synchronized (object) {
            connectionsList = this.connectionPool.remove(host);
        }
        object = this.waitCounter;
        synchronized (object) {
            this.waitCounter.remove(host);
        }
        if (this.lastHostsFromHello != null && !this.lastHostsFromHello.contains(host)) {
            this.log.info("Removing unreachable seed host '{}' not present in replicaset members {}", (Object)host, this.lastHostsFromHello);
            this.removeFromHostSeed(host);
            this.pingTimesPerHost.remove(host);
            this.pingStatsPerHost.remove(host);
        }
        if (host.equals(this.primaryNode)) {
            this.primaryNode = null;
        }
        if (host.equals(this.fastestHost)) {
            this.fastestHost = null;
            this.fastestTime = 10000L;
        }
        if (connectionsList != null) {
            for (ConnectionContainer c : connectionsList) {
                try {
                    c.getCon().close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.stats.get((Object)MorphiumDriver.DriverStatsKey.CONNECTIONS_CLOSED).incrementAndGet();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createNewConnection(String hst) throws Exception {
        Map<String, BlockingQueue<ConnectionContainer>> map = this.connectionPool;
        synchronized (map) {
            if (!this.connectionPool.containsKey(hst)) {
                return;
            }
        }
        SingleMongoConnection con = new SingleMongoConnection();
        if (this.getAuthDb() != null) {
            con.setCredentials(this.getAuthDb(), this.getUser(), this.getPassword());
        }
        long start = System.currentTimeMillis();
        HelloResult result = con.connect(this, this.getHost(hst), this.getPortFromHost(hst));
        this.stats.get((Object)MorphiumDriver.DriverStatsKey.CONNECTIONS_OPENED).incrementAndGet();
        Map<String, BlockingQueue<ConnectionContainer>> map2 = this.connectionPool;
        synchronized (map2) {
            if (this.connectionPool.containsKey(hst) && (this.connectionPool.get(hst).size() < this.getWaitCounterForHost(hst) && this.getTotalConnectionsToHost(hst) < this.getMaxConnectionsPerHost() || this.getTotalConnectionsToHost(hst) < this.getMinConnectionsPerHost())) {
                ConnectionContainer cont = new ConnectionContainer(this, con);
                this.connectionPool.get(hst).add(cont);
            } else {
                this.stats.get((Object)MorphiumDriver.DriverStatsKey.CONNECTIONS_CLOSED).incrementAndGet();
                con.close();
            }
        }
        long dur = System.currentTimeMillis() - start;
        PingStats newStats = this.pingStatsPerHost.compute(hst, (host, oldStats) -> oldStats == null ? new PingStats(dur, dur, dur, dur, 1, System.currentTimeMillis()) : oldStats.updateWith(dur));
        this.updateFastestHost(hst, newStats);
        this.handleHelloResult(result, String.format("%s:%d", this.getHost(hst), this.getPortFromHost(hst)));
    }

    @Override
    public void watch(WatchCommand settings) throws MorphiumDriverException {
        MongoConnection con = null;
        try {
            con = this.getPrimaryConnection(null);
            con.watch(settings);
        }
        finally {
            if (con != null) {
                this.releaseConnection(con);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getTotalConnectionsToHost(String h) {
        int borrowed;
        try {
            borrowed = (int)this.borrowedConnections.values().stream().filter(c -> c.getCon().getConnectedTo().equals(h)).count();
        }
        catch (Exception e) {
            Map<Integer, ConnectionContainer> map = this.borrowedConnections;
            synchronized (map) {
                borrowed = (int)this.borrowedConnections.values().stream().filter(c -> c.getCon().getConnectedTo().equals(h)).count();
            }
        }
        Map<String, BlockingQueue<ConnectionContainer>> map = this.connectionPool;
        synchronized (map) {
            BlockingQueue<ConnectionContainer> pool = this.connectionPool.get(h);
            return borrowed + (pool != null ? pool.size() : 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MongoConnection borrowConnection(String host) throws MorphiumDriverException {
        if (host == null) {
            throw new MorphiumDriverException("Cannot connect to host null!");
        }
        boolean needToDecrement = false;
        try {
            ConnectionContainer bc = null;
            BlockingQueue<ConnectionContainer> queue = null;
            Object object = this.connectionPool;
            synchronized (object) {
                if (!this.connectionPool.containsKey(host)) {
                    this.log.error("No connectionpool for host {}", (Object)host);
                    throw new MorphiumDriverException(String.format("No connectionpool for %s available", host));
                }
                queue = this.connectionPool.get(host);
                if (queue.isEmpty()) {
                    Map<String, AtomicInteger> map = this.waitCounter;
                    synchronized (map) {
                        this.waitCounter.putIfAbsent(host, new AtomicInteger());
                        if (this.getWaitCounterForHost(host) < this.getMaxConnectionsPerHost()) {
                            this.waitCounter.get(host).incrementAndGet();
                            needToDecrement = true;
                        }
                        Object object2 = this.waitCounterSignal;
                        synchronized (object2) {
                            this.waitCounterSignal.notifyAll();
                        }
                    }
                }
            }
            do {
                if ((bc = this.getServerSelectionTimeout() <= 0 ? queue.poll(Integer.MAX_VALUE, TimeUnit.SECONDS) : queue.poll(this.getServerSelectionTimeout(), TimeUnit.MILLISECONDS)) == null) {
                    this.log.error("Connection timeout");
                    this.log.error("Connections to {}: {}", (Object)host, (Object)this.getTotalConnectionsToHost(host));
                    this.log.error("WaitingThreads for {}: {}", (Object)host, (Object)this.getWaitCounterForHost(host));
                    throw new MorphiumDriverException(String.format("Could not get connection to %s in time %dms", host, this.getMaxWaitTime()));
                }
                if (bc.getCon().getSourcePort() != 0) continue;
                this.stats.get((Object)MorphiumDriver.DriverStatsKey.ERRORS).incrementAndGet();
            } while (bc.getCon().getSourcePort() == 0);
            bc.touch();
            this.borrowedConnections.put(bc.getCon().getSourcePort(), bc);
            this.stats.get((Object)MorphiumDriver.DriverStatsKey.CONNECTIONS_BORROWED).incrementAndGet();
            object = bc.getCon();
            return object;
        }
        catch (InterruptedException iex) {
            throw new MorphiumDriverException("Waiting for connection was aborted");
        }
        finally {
            AtomicInteger atomicInteger;
            if (needToDecrement && this.getWaitCounterForHost(host) > 0 && (atomicInteger = this.waitCounter.get(host)) != null) {
                atomicInteger.decrementAndGet();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public MongoConnection getReadConnection(ReadPreference rp) {
        try {
            if (this.getHostSeed().size() == 1 || !this.isReplicaSet()) {
                if (this.primaryNode != null) return this.borrowConnection(this.primaryNode);
                return this.borrowConnection(this.getHostSeed().get(0));
            }
            if (rp == null) {
                rp = this.getDefaultReadPreference();
            }
            type = rp.getType();
            if (this.isTransactionInProgress()) {
                type = ReadPreferenceType.PRIMARY;
            }
            switch (2.$SwitchMap$de$caluga$morphium$driver$ReadPreferenceType[type.ordinal()]) {
                case 1: {
                    start = System.currentTimeMillis();
                    timeout = this.getServerSelectionTimeout();
                    if (timeout <= 0L) {
                        timeout = 1000L;
                    }
                    while (this.primaryNode == null) {
                        if (System.currentTimeMillis() - start > timeout) {
                            throw new MorphiumDriverException("No primary node defined - not connected yet?");
                        }
                        try {
                            Thread.sleep(100L);
                        }
                        catch (InterruptedException e) {
                            Thread.currentThread().interrupt();
                            return null;
                        }
                    }
                    return this.borrowConnection(this.primaryNode);
                }
                case 2: {
                    if (this.fastestHost != null) {
                        try {
                            return this.borrowConnection(this.fastestHost);
                        }
                        catch (MorphiumDriverException e) {
                            this.stats.get((Object)MorphiumDriver.DriverStatsKey.ERRORS).incrementAndGet();
                            this.log.warn("Could not get connection to fastest host, trying primary", (Throwable)e);
                        }
                    }
                }
                case 3: {
                    e = this.connectionPool;
                    synchronized (e) {
                        if (null != this.connectionPool.get(this.primaryNode) && !this.connectionPool.get(this.primaryNode).isEmpty()) {
                            try {
                                return this.borrowConnection(this.primaryNode);
                            }
                            catch (MorphiumDriverException e) {
                                this.stats.get((Object)MorphiumDriver.DriverStatsKey.ERRORS).incrementAndGet();
                                this.log.warn("Could not get connection to {} trying secondary", (Object)this.primaryNode);
                            }
                        }
                    }
                }
                case 4: 
                case 5: {
                    retry = 0;
lbl46:
                    // 2 sources

                    block29: while (true) {
                        host = null;
                        var9_13 = this.lastSecondaryNode;
                        synchronized (var9_13) {
                            this.lastSecondaryNode.incrementAndGet();
                            hostSeed = this.getHostSeed();
                            if (this.lastSecondaryNode.get() >= hostSeed.size()) {
                                this.lastSecondaryNode.set(0);
                                ++retry;
                            }
                            if (hostSeed.get(this.lastSecondaryNode.get()).equals(this.primaryNode)) {
                                this.lastSecondaryNode.incrementAndGet();
                                if (this.lastSecondaryNode.get() >= hostSeed.size()) {
                                    this.lastSecondaryNode.set(0);
                                    ++retry;
                                }
                            }
                            if (this.getLocalThreshold() <= 0) ** GOTO lbl90
                            var12_18 = stats = this.pingStatsPerHost.get(host);
                            var13_19 = 0;
lbl65:
                            // 2 sources

                            block30: while (true) {
                                switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{PingStats.class}, (Object)var12_18, var13_19)) {
                                    case -1: {
                                        host = hostSeed.get(this.lastSecondaryNode.get());
                                        break block30;
                                    }
                                    case 0: {
                                        var14_20 = var12_18;
                                        var28_31 = var26_27 = var14_20.lastPing();
                                        lastPing = var26_27;
                                        var28_31 = var26_27 = var14_20.averagePing();
                                        avgPing = var26_27;
                                        var28_31 = var26_27 = var14_20.minPing();
                                        minPing = var26_27;
                                        var28_31 = var26_27 = var14_20.maxPing();
                                        maxPing = var26_27;
                                        var27_30 = var26_28 = var14_20.sampleCount();
                                        count = var26_28;
                                        var28_31 = var26_29 = var14_20.lastUpdated();
                                    }
lbl90:
                                    // 1 sources

                                    host = hostSeed.get(this.lastSecondaryNode.get());
                                }
                                break;
                            }
lbl91:
                            // 3 sources

                            while (true) {
                                // MONITOREXIT @DISABLED, blocks:[0, 10, 11, 29, 15, 31] lbl94 : MonitorExitStatement: MONITOREXIT : var9_13
                                try {
                                    return this.borrowConnection(host);
                                }
                                catch (MorphiumDriverException e) {
                                    if (retry > this.getRetriesOnNetworkError()) {
                                        this.log.error("Could not get Connection - abort");
                                        this.stats.get((Object)MorphiumDriver.DriverStatsKey.ERRORS).incrementAndGet();
                                        throw e;
                                    }
                                    this.log.warn("could not get connection to secondary node '{}'- trying other replicaset node", (Object)host, (Object)e);
                                    this.onConnectionError(host);
                                    try {
                                        Thread.sleep(this.getSleepBetweenErrorRetries());
                                        continue block29;
                                    }
                                    catch (InterruptedException e1) {
                                        Thread.currentThread().interrupt();
                                        throw new IllegalArgumentException("Unhandeled Readpreferencetype " + String.valueOf((Object)rp.getType()));
                                    }
                                }
                                break;
                            }
                        }
                        break;
                    }
                }
                default: {
                    throw new IllegalArgumentException("Unhandeled Readpreferencetype " + String.valueOf((Object)rp.getType()));
                }
            }
            {
                catch (Throwable type) {
                    throw new MatchException(type.toString(), type);
                }
                updated = var26_29;
                if (avgPing > this.fastestTime + (long)this.getLocalThreshold()) {
                    var13_19 = 1;
                    ** continue;
                }
                host = hostSeed.get(this.lastSecondaryNode.get());
                ** continue;
                ** break;
            }
lbl120:
            // 1 sources

            ** continue;
        }
        catch (MorphiumDriverException e) {
            this.log.error("Error getting connection", (Throwable)e);
            this.stats.get((Object)MorphiumDriver.DriverStatsKey.ERRORS).incrementAndGet();
            throw new RuntimeException(e);
        }
    }

    @Override
    public MongoConnection getPrimaryConnection(WriteConcern wc) throws MorphiumDriverException {
        if (this.primaryNode == null) {
            throw new MorphiumDriverException("No primary node found - connection not established yet?");
        }
        return this.borrowConnection(this.primaryNode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void closeConnection(MongoConnection con) {
        this.releaseConnection(con);
        Map<String, BlockingQueue<ConnectionContainer>> map = this.connectionPool;
        synchronized (map) {
            for (String k : this.connectionPool.keySet()) {
                for (ConnectionContainer c : new ArrayList(this.connectionPool.get(k))) {
                    if (c.getCon() != con) continue;
                    this.connectionPool.get(k).remove(c);
                    return;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<Integer, ConnectionContainer> getBorrowedConnections() {
        Map<String, BlockingQueue<ConnectionContainer>> map = this.connectionPool;
        synchronized (map) {
            return new HashMap<Integer, ConnectionContainer>(this.borrowedConnections);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void releaseConnection(MongoConnection con) {
        this.stats.get((Object)MorphiumDriver.DriverStatsKey.CONNECTIONS_RELEASED).incrementAndGet();
        if (con == null) {
            return;
        }
        if (this.heartbeat == null) {
            return;
        }
        if (!(con instanceof SingleMongoConnection)) {
            throw new IllegalArgumentException("Got connection of wrong type back!");
        }
        if (con.getSourcePort() != 0) {
            ConnectionContainer c = this.borrowedConnections.remove(con.getSourcePort());
            if (c == null) {
                if (con.isConnected()) {
                    this.stats.get((Object)MorphiumDriver.DriverStatsKey.CONNECTIONS_CLOSED).incrementAndGet();
                    con.close();
                }
                return;
            }
            if (con.getConnectedTo() != null) {
                Map<String, BlockingQueue<ConnectionContainer>> map = this.connectionPool;
                synchronized (map) {
                    BlockingQueue<ConnectionContainer> connectionContainer = this.connectionPool.get(con.getConnectedTo());
                    if (null != connectionContainer) {
                        connectionContainer.add(c);
                    }
                }
            }
        } else {
            ArrayList<Integer> sourcePortsToDelete = new ArrayList<Integer>();
            for (int port : new ArrayList<Integer>(this.borrowedConnections.keySet())) {
                ConnectionContainer connectionContainer = this.borrowedConnections.get(port);
                if (connectionContainer != null && connectionContainer.getCon() != null && connectionContainer.getCon().getSourcePort() != 0) continue;
                sourcePortsToDelete.add(port);
            }
            for (int port : sourcePortsToDelete) {
                this.borrowedConnections.remove(port);
            }
            this.stats.get((Object)MorphiumDriver.DriverStatsKey.CONNECTIONS_RELEASED).incrementAndGet();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isConnected() {
        Map<String, BlockingQueue<ConnectionContainer>> map = this.connectionPool;
        synchronized (map) {
            for (String c : this.connectionPool.keySet()) {
                if (this.getTotalConnectionsToHost(c) == 0) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public int getIdleSleepTime() {
        return this.idleSleepTime;
    }

    @Override
    public void setIdleSleepTime(int sl) {
        this.idleSleepTime = sl;
    }

    @Override
    public <T, R> Aggregator<T, R> createAggregator(Morphium morphium, Class<? extends T> type, Class<? extends R> resultType) {
        return new AggregatorImpl<T, R>(morphium, type, resultType);
    }

    @Override
    public String getName() {
        return driverName;
    }

    @Override
    public void setConnectionUrl(String connectionUrl) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        if (this.heartbeat != null) {
            this.heartbeat.cancel(true);
        }
        this.heartbeat = null;
        if (this.executor != null) {
            this.executor.shutdownNow();
        }
        Map<String, BlockingQueue<ConnectionContainer>> map = this.connectionPool;
        synchronized (map) {
            for (Map.Entry<String, BlockingQueue<ConnectionContainer>> e : new ArrayList<Map.Entry<String, BlockingQueue<ConnectionContainer>>>(this.connectionPool.entrySet())) {
                for (ConnectionContainer c : new ArrayList(e.getValue())) {
                    try {
                        c.getCon().close();
                    }
                    catch (Exception exception) {}
                }
                this.connectionPool.get(e.getKey()).clear();
                this.stats.get((Object)MorphiumDriver.DriverStatsKey.CONNECTIONS_CLOSED).incrementAndGet();
            }
        }
    }

    protected void killCursors(String db, String coll, long ... ids) throws MorphiumDriverException {
        ArrayList<Long> cursorIds = new ArrayList<Long>();
        for (long l : ids) {
            if (l == 0L) continue;
            cursorIds.add(l);
        }
        if (cursorIds.isEmpty()) {
            return;
        }
        KillCursorsCommand k = (KillCursorsCommand)((KillCursorsCommand)new KillCursorsCommand(null).setCursors(cursorIds).setDb(db)).setColl(coll);
        Map<String, Object> ret = k.execute();
    }

    @Override
    public void commitTransaction() throws MorphiumDriverException {
        if (this.getTransactionContext() == null) {
            throw new IllegalArgumentException("No transaction in progress, cannot commit");
        }
        MorphiumTransactionContext ctx = this.getTransactionContext();
        MongoConnection con = this.getPrimaryConnection(null);
        CommitTransactionCommand cmd = new CommitTransactionCommand(con).setTxnNumber(ctx.getTxnNumber()).setAutocommit(false).setLsid(ctx.getLsid());
        cmd.execute();
        this.clearTransactionContext();
        this.releaseConnection(con);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void abortTransaction() throws MorphiumDriverException {
        if (this.getTransactionContext() == null) {
            throw new IllegalArgumentException("No transaction in progress, cannot abort");
        }
        MongoConnection con = this.getPrimaryConnection(null);
        try {
            MorphiumTransactionContext ctx = this.getTransactionContext();
            AbortTransactionCommand cmd = new AbortTransactionCommand(con).setTxnNumber(ctx.getTxnNumber()).setAutocommit(false).setLsid(ctx.getLsid());
            cmd.execute();
        }
        finally {
            this.releaseConnection(con);
            this.clearTransactionContext();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, Object> getReplsetStatus() throws MorphiumDriverException {
        MongoConnection con = null;
        try {
            con = this.getPrimaryConnection(null);
            ReplicastStatusCommand cmd = new ReplicastStatusCommand(con);
            Map<String, Object> result = cmd.execute();
            List mem = (List)result.get("members");
            if (mem == null) {
                Map<String, Object> map = null;
                return map;
            }
            mem.stream().filter(d -> d.get("optime") instanceof Map).forEach(d -> d.put("optime", ((Map)d.get("optime")).get("ts")));
            Map<String, Object> map = result;
            return map;
        }
        finally {
            this.releaseConnection(con);
        }
    }

    @Override
    public Map<String, Object> getDBStats(String db) throws MorphiumDriverException {
        return this.getDBStats(db, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Object> getDBStats(String db, boolean withStorage) throws MorphiumDriverException {
        MongoConnection con = null;
        try {
            con = this.getPrimaryConnection(null);
            Map<String, Object> map = ((DbStatsCommand)new DbStatsCommand(con).setDb(db)).setWithStorage(withStorage).execute();
            return map;
        }
        finally {
            this.releaseConnection(con);
        }
    }

    @Override
    public Map<String, Object> getCollStats(String db, String coll) throws MorphiumDriverException {
        CollStatsCommand cmd = (CollStatsCommand)((CollStatsCommand)new CollStatsCommand(this.getPrimaryConnection(null)).setColl(coll)).setDb(db);
        return cmd.execute();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Map<String, Object>> currentOp(int threshold) throws MorphiumDriverException {
        MongoCommand cmd = null;
        try {
            cmd = ((CurrentOpCommand)new CurrentOpCommand(this.getPrimaryConnection(null)).setColl("admin")).setSecsRunning(threshold);
            List<Map<String, Object>> list = ((CurrentOpCommand)cmd).execute();
            return list;
        }
        finally {
            if (cmd != null) {
                cmd.releaseConnection();
            }
        }
    }

    public void closeIteration(MorphiumCursor crs) throws MorphiumDriverException {
        if (crs == null) {
            return;
        }
        this.killCursors(crs.getDb(), crs.getCollection(), crs.getCursorId());
    }

    @Override
    public boolean exists(String db) throws MorphiumDriverException {
        List<String> databases = this.listDatabases();
        return databases != null && databases.contains(db);
    }

    private List<Map<String, Object>> getCollectionInfo(String db, String collection) throws MorphiumDriverException {
        return (List)new NetworkCallHelper().doCall(() -> {
            MongoConnection con = this.getReadConnection(ReadPreference.primary());
            ListCollectionsCommand cmd = new ListCollectionsCommand(con);
            cmd.setDb(db);
            cmd.setFilter(Doc.of("name", collection));
            return cmd.execute();
        }, this.getRetriesOnNetworkError(), this.getSleepBetweenErrorRetries());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, Integer> getNumConnectionsByHost() {
        HashMap<String, Integer> ret = new HashMap<String, Integer>();
        Map<String, BlockingQueue<ConnectionContainer>> map = this.connectionPool;
        synchronized (map) {
            for (Map.Entry<String, BlockingQueue<ConnectionContainer>> entry : this.connectionPool.entrySet()) {
                ret.put(entry.getKey(), entry.getValue().size());
            }
            for (ConnectionContainer connectionContainer : this.borrowedConnections.values()) {
                ret.put(connectionContainer.getCon().getConnectedTo(), (Integer)ret.get(connectionContainer.getCon().getConnectedTo()) + 1);
            }
        }
        return ret;
    }

    @Override
    public boolean isCapped(String db, String coll) throws MorphiumDriverException {
        List<Map<String, Object>> lst = this.getCollectionInfo(db, coll);
        try {
            if (!lst.isEmpty() && lst.get(0).get("name") != null && lst.get(0).get("name").equals(coll)) {
                Object capped = ((Map)lst.get(0).get("options")).get("capped");
                return capped != null && capped.equals(true);
            }
        }
        catch (Exception e) {
            this.log.error("Error", (Throwable)e);
            this.stats.get((Object)MorphiumDriver.DriverStatsKey.ERRORS).incrementAndGet();
        }
        return false;
    }

    @Override
    public BulkRequestContext createBulkContext(Morphium m, final String db, final String collection, boolean ordered, WriteConcern wc) {
        return new BulkRequestContext(this, m){
            private final List<BulkRequest> requests;
            final /* synthetic */ PooledDriver this$0;
            {
                this.this$0 = this$0;
                super(m);
                this.requests = new ArrayList<BulkRequest>();
            }

            public Doc execute() {
                int delCount = 0;
                int matchedCount = 0;
                int insertCount = 0;
                int modifiedCount = 0;
                ArrayList upsertedIds = new ArrayList();
                try {
                    block7: for (BulkRequest r : this.requests) {
                        BulkRequest bulkRequest;
                        Objects.requireNonNull(r);
                        int n = 0;
                        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{InsertBulkRequest.class, UpdateBulkRequest.class, DeleteBulkRequest.class}, (Object)bulkRequest, n)) {
                            case 0: {
                                InsertBulkRequest insert = (InsertBulkRequest)bulkRequest;
                                InsertMongoCommand settings = new InsertMongoCommand(this.this$0.getPrimaryConnection(null));
                                ((InsertMongoCommand)((InsertMongoCommand)settings.setDb(db)).setColl(collection)).setComment("Bulk insert").setDocuments(insert.getToInsert());
                                Map<String, Object> result = settings.execute();
                                settings.releaseConnection();
                                insertCount += insert.getToInsert().size();
                                break;
                            }
                            case 1: {
                                UpdateBulkRequest update = (UpdateBulkRequest)bulkRequest;
                                UpdateMongoCommand upCmd = new UpdateMongoCommand(this.this$0.getPrimaryConnection(null));
                                ((UpdateMongoCommand)((UpdateMongoCommand)upCmd.setColl(collection)).setDb(db)).setUpdates(Arrays.asList(Doc.of("q", update.getQuery(), "u", update.getCmd(), "upsert", (Object)update.isUpsert(), "multi", (Object)update.isMultiple())));
                                Map<String, Object> result = upCmd.execute();
                                upCmd.releaseConnection();
                                if (result.containsKey("n")) {
                                    matchedCount += ((Number)result.get("n")).intValue();
                                }
                                if (result.containsKey("nModified")) {
                                    modifiedCount += ((Number)result.get("nModified")).intValue();
                                }
                                if (!result.containsKey("upserted")) continue block7;
                                List upserted = (List)result.get("upserted");
                                for (Map u : upserted) {
                                    upsertedIds.add(u.get("_id"));
                                }
                                continue block7;
                            }
                            case 2: {
                                DeleteBulkRequest delete = (DeleteBulkRequest)bulkRequest;
                                DeleteMongoCommand del = new DeleteMongoCommand(this.this$0.getPrimaryConnection(null));
                                ((DeleteMongoCommand)((DeleteMongoCommand)del.setColl(collection)).setDb(db)).setDeletes(Arrays.asList(Doc.of("q", delete.getQuery(), "limit", (Object)(delete.isMultiple() ? 0 : 1))));
                                Map<String, Object> result = del.execute();
                                del.releaseConnection();
                                if (!result.containsKey("n")) continue block7;
                                delCount += ((Number)result.get("n")).intValue();
                                break;
                            }
                            default: {
                                throw new RuntimeException("Unknown operation " + r.getClass().getName());
                            }
                        }
                    }
                }
                catch (MorphiumDriverException e) {
                    this.this$0.log.error("Got exception: ", (Throwable)e);
                    this.this$0.stats.get((Object)MorphiumDriver.DriverStatsKey.ERRORS).incrementAndGet();
                }
                Doc res = Doc.of("num_deleted", (Object)delCount, "num_matched", (Object)matchedCount, "num_inserted", (Object)insertCount, "num_modified", (Object)modifiedCount, "num_upserts", (Object)upsertedIds.size());
                if (!upsertedIds.isEmpty()) {
                    res.put("upsertedIds", upsertedIds);
                }
                return res;
            }

            @Override
            public UpdateBulkRequest addUpdateBulkRequest() {
                UpdateBulkRequest up = new UpdateBulkRequest();
                this.requests.add(up);
                return up;
            }

            @Override
            public InsertBulkRequest addInsertBulkRequest(List<Map<String, Object>> toInsert) {
                InsertBulkRequest in = new InsertBulkRequest(toInsert);
                this.requests.add(in);
                return in;
            }

            @Override
            public DeleteBulkRequest addDeleteBulkRequest() {
                DeleteBulkRequest del = new DeleteBulkRequest();
                this.requests.add(del);
                return del;
            }
        };
    }

    @Override
    public Map<MorphiumDriver.DriverStatsKey, Double> getDriverStats() {
        StatsSnapshot snapshot;
        long now = System.currentTimeMillis();
        if (this.cachedStats != null && now - this.lastStatsUpdate < 1000L) {
            return this.cachedStats.toMap();
        }
        this.cachedStats = snapshot = this.collectStatsSnapshot();
        this.lastStatsUpdate = now;
        return snapshot.toMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private StatsSnapshot collectStatsSnapshot() {
        HashMap<MorphiumDriver.DriverStatsKey, Double> driverStats = new HashMap<MorphiumDriver.DriverStatsKey, Double>();
        for (Map.Entry<MorphiumDriver.DriverStatsKey, AtomicDecimal> e : this.stats.entrySet()) {
            driverStats.put(e.getKey(), e.getValue().get());
        }
        int totalPooled = 0;
        HashMap<MorphiumDriver.DriverStatsKey, Double> connStats = new HashMap<MorphiumDriver.DriverStatsKey, Double>();
        Map<String, BlockingQueue<ConnectionContainer>> map = this.connectionPool;
        synchronized (map) {
            for (BlockingQueue<ConnectionContainer> blockingQueue : this.connectionPool.values()) {
                totalPooled += blockingQueue.size();
                for (ConnectionContainer con : blockingQueue) {
                    for (Map.Entry<MorphiumDriver.DriverStatsKey, Double> entry : con.getCon().getStats().entrySet()) {
                        connStats.merge(entry.getKey(), entry.getValue(), Double::sum);
                    }
                }
            }
        }
        int totalBorrowed = this.borrowedConnections.size();
        int waiting = 0;
        try {
            for (String hst : this.waitCounter.keySet()) {
                waiting += this.getWaitCounterForHost(hst);
            }
        }
        catch (Exception exception) {
            Map<String, AtomicInteger> map2 = this.waitCounter;
            synchronized (map2) {
                for (String hst : this.waitCounter.keySet()) {
                    waiting += this.getWaitCounterForHost(hst);
                }
            }
        }
        return new StatsSnapshot(driverStats, totalPooled, totalBorrowed, waiting, connStats);
    }

    private record StatsSnapshot(Map<MorphiumDriver.DriverStatsKey, Double> driverStats, int totalPooledConnections, int totalBorrowedConnections, int totalWaitingThreads, Map<MorphiumDriver.DriverStatsKey, Double> aggregatedConnectionStats) {
        Map<MorphiumDriver.DriverStatsKey, Double> toMap() {
            HashMap<MorphiumDriver.DriverStatsKey, Double> result = new HashMap<MorphiumDriver.DriverStatsKey, Double>(this.driverStats);
            result.put(MorphiumDriver.DriverStatsKey.CONNECTIONS_IN_POOL, Double.valueOf(this.totalPooledConnections));
            result.put(MorphiumDriver.DriverStatsKey.CONNECTIONS_IN_USE, Double.valueOf(this.totalBorrowedConnections));
            result.put(MorphiumDriver.DriverStatsKey.THREADS_WAITING_FOR_CONNECTION, Double.valueOf(this.totalWaitingThreads));
            result.putAll(this.aggregatedConnectionStats);
            return result;
        }
    }

    private class ConnectionContainer {
        private SingleMongoConnection con;
        private long created;
        private long lastUsed;

        public ConnectionContainer(PooledDriver pooledDriver, SingleMongoConnection con) {
            this.con = con;
            this.created = System.currentTimeMillis();
            this.lastUsed = System.currentTimeMillis();
        }

        public void touch() {
            this.lastUsed = System.currentTimeMillis();
        }

        public SingleMongoConnection getCon() {
            return this.con;
        }

        public ConnectionContainer setCon(SingleMongoConnection con) {
            this.con = con;
            return this;
        }

        public long getCreated() {
            return this.created;
        }

        public ConnectionContainer setCreated(long created) {
            this.created = created;
            return this;
        }

        public long getLastUsed() {
            return this.lastUsed;
        }

        public ConnectionContainer setLastUsed(long lastUsed) {
            this.lastUsed = lastUsed;
            return this;
        }
    }

    public record PingStats(long lastPing, long averagePing, long minPing, long maxPing, int sampleCount, long lastUpdated) {
        public PingStats updateWith(long newPing) {
            if (this.sampleCount == 0) {
                return new PingStats(newPing, newPing, newPing, newPing, 1, System.currentTimeMillis());
            }
            long newAvg = (this.averagePing * (long)this.sampleCount + newPing) / (long)(this.sampleCount + 1);
            return new PingStats(newPing, newAvg, Math.min(this.minPing, newPing), Math.max(this.maxPing, newPing), Math.min(this.sampleCount + 1, 100), System.currentTimeMillis());
        }
    }
}

