/*
 * Decompiled with CFR 0.152.
 */
package de.caluga.morphium.driver.wire;

import de.caluga.morphium.driver.Doc;
import de.caluga.morphium.driver.MorphiumDriver;
import de.caluga.morphium.driver.MorphiumDriverException;
import de.caluga.morphium.driver.MorphiumTransactionContext;
import de.caluga.morphium.driver.ReadPreference;
import de.caluga.morphium.driver.bson.UUIDRepresentation;
import de.caluga.morphium.driver.commands.ListCollectionsCommand;
import de.caluga.morphium.driver.commands.ListDatabasesCommand;
import de.caluga.morphium.driver.commands.WatchCommand;
import de.caluga.morphium.driver.mongodb.Maximums;
import de.caluga.morphium.driver.wire.MongoConnection;
import de.caluga.morphium.driver.wire.MorphiumTransactionContextImpl;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.SequencedSet;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DriverBase
implements MorphiumDriver {
    private final Logger log = LoggerFactory.getLogger(DriverBase.class);
    private volatile AtomicInteger rqid = new AtomicInteger(Math.abs((int)(System.currentTimeMillis() % 100000L)));
    private int maxWait = 1000;
    private int maxBsonObjectSize = 0xC03000;
    private int maxMessageSize = 0x1000000;
    private int maxWriteBatchSize = 1000;
    private ReadPreference defaultRP = ReadPreference.primary();
    private boolean replicaSet = false;
    private String replicaSetName = null;
    private int retriesOnNetworkError = 5;
    private int sleepBetweenRetries = 100;
    private boolean defaultJ = false;
    private Set<String> hostSeed;
    private int heartbeatFrequency = 2000;
    private boolean useSSL = false;
    private int defaultW = 1;
    private int connectionTimeout = 1000;
    private int maxConnectionIdleTime = 100000;
    private int maxConnectionLifetime = 600000;
    private int minConnectionsPerHost = 1;
    private int maxConnectionsPerHost = 100;
    private int defaultWriteTimeout = 10000;
    private int batchSize = 100;
    private boolean retryReads = false;
    private boolean retryWrites = true;
    private int readTimeout = 30000;
    private int compressionType = 0;
    private int localThreshold = -1;
    private ThreadLocal<MorphiumTransactionContext> transactionContext = new ThreadLocal();
    private String authDb = null;
    private String user;
    private String password;

    @Override
    public void setConnectionUrl(String connectionUrl) throws MalformedURLException {
        URL u = new URL(connectionUrl);
        if (!u.getProtocol().equals("mongodb")) {
            throw new MalformedURLException("unsupported protocol: " + u.getProtocol());
        }
    }

    @Override
    public int getCompression() {
        return this.compressionType;
    }

    @Override
    public MorphiumDriver setCompression(int type) {
        this.log.debug("Setting compression to {}", (Object)type);
        this.compressionType = type;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> listCollections(String db, String regex) throws MorphiumDriverException {
        MongoConnection primaryConnection = this.getPrimaryConnection(null);
        ListCollectionsCommand cmd = null;
        try {
            cmd = new ListCollectionsCommand(primaryConnection);
            ((ListCollectionsCommand)cmd.setDb(db)).setNameOnly(true);
            if (regex != null) {
                cmd.setFilter(Doc.of("name", Pattern.compile(regex)));
            }
            List<Map<String, Object>> lst = cmd.execute();
            if (cmd.getConnection() != null) {
                cmd.releaseConnection();
                this.log.warn("connection not released!?!?");
            }
            ArrayList<String> colNames = new ArrayList<String>();
            for (Map<String, Object> doc : lst) {
                if (!doc.containsKey("name")) continue;
                String name = doc.get("name").toString();
                colNames.add(name);
            }
            ArrayList<String> arrayList = colNames;
            return arrayList;
        }
        finally {
            if (cmd != null) {
                cmd.releaseConnection();
            }
        }
    }

    public int getNumHostsInSeed() {
        return this.hostSeed.size();
    }

    public void removeFromHostSeed(String host) {
        this.hostSeed.remove(host);
    }

    public void addToHostSeed(String host) {
        this.hostSeed.add(host);
    }

    @Override
    public void setHostSeed(String ... hosts) {
        this.hostSeed = Collections.synchronizedSet(new LinkedHashSet());
        for (String h : hosts) {
            this.hostSeed.add(h);
        }
    }

    @Override
    public int getRetriesOnNetworkError() {
        return this.retriesOnNetworkError;
    }

    @Override
    public MorphiumDriver setRetriesOnNetworkError(int r) {
        this.retriesOnNetworkError = r;
        return this;
    }

    @Override
    public int getSleepBetweenErrorRetries() {
        return this.sleepBetweenRetries;
    }

    @Override
    public MorphiumDriver setSleepBetweenErrorRetries(int s) {
        this.sleepBetweenRetries = s;
        return this;
    }

    @Override
    public void setCredentials(String db, String login, String pwd) {
        this.authDb = db;
        this.user = login;
        this.password = pwd;
    }

    @Override
    public int getMaxConnections() {
        return this.maxConnectionsPerHost;
    }

    public String getAuthDb() {
        return this.authDb;
    }

    public DriverBase setAuthDb(String authDb) {
        this.authDb = authDb;
        return this;
    }

    public String getUser() {
        return this.user;
    }

    public DriverBase setUser(String user) {
        this.user = user;
        return this;
    }

    public String getPassword() {
        return this.password;
    }

    public DriverBase setPassword(String password) {
        this.password = password;
        return this;
    }

    @Override
    public MorphiumDriver setMaxConnections(int maxConnections) {
        this.maxConnectionsPerHost = maxConnections;
        return this;
    }

    @Override
    public int getMinConnections() {
        return this.getMinConnectionsPerHost();
    }

    @Override
    public MorphiumDriver setMinConnections(int minConnections) {
        this.minConnectionsPerHost = minConnections;
        return this;
    }

    @Override
    public boolean isRetryReads() {
        return this.retryReads;
    }

    @Override
    public MorphiumDriver setRetryReads(boolean retryReads) {
        this.retryReads = retryReads;
        return this;
    }

    @Override
    public boolean isRetryWrites() {
        return this.retryWrites;
    }

    @Override
    public MorphiumDriver setRetryWrites(boolean retryWrites) {
        this.retryWrites = retryWrites;
        return this;
    }

    public String getUuidRepresentation() {
        return UUIDRepresentation.STANDARD.name();
    }

    public void setUuidRepresentation(String uuidRepresentation) {
    }

    @Override
    public int getReadTimeout() {
        return this.readTimeout;
    }

    @Override
    public void setReadTimeout(int readTimeout) {
        this.readTimeout = readTimeout;
    }

    @Override
    public int getMinConnectionsPerHost() {
        return this.minConnectionsPerHost;
    }

    @Override
    public void setMinConnectionsPerHost(int minConnectionsPerHost) {
        this.minConnectionsPerHost = minConnectionsPerHost;
    }

    @Override
    public int getMaxConnectionsPerHost() {
        return this.maxConnectionsPerHost;
    }

    @Override
    public void setMaxConnectionsPerHost(int maxConnectionsPerHost) {
        this.maxConnectionsPerHost = maxConnectionsPerHost;
    }

    @Override
    public boolean isReplicaset() {
        return this.replicaSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> listDatabases() throws MorphiumDriverException {
        if (!this.isConnected()) {
            return null;
        }
        MongoConnection primaryConnection = this.getPrimaryConnection(null);
        ListDatabasesCommand cmd = null;
        try {
            cmd = new ListDatabasesCommand(primaryConnection);
            int msg = primaryConnection.sendCommand(cmd);
            Map<String, Object> res = primaryConnection.readSingleAnswer(msg);
            ArrayList<String> ret = new ArrayList<String>();
            if (res.get("databases") != null) {
                List lst = (List)res.get("databases");
                for (Map db : lst) {
                    if (db.get("name") != null) {
                        ret.add(db.get("name").toString());
                        continue;
                    }
                    this.log.error("No DB Name for this entry...");
                }
            }
            ArrayList<String> arrayList = ret;
            return arrayList;
        }
        finally {
            if (cmd != null) {
                cmd.releaseConnection();
            }
        }
    }

    @Override
    public boolean exists(String db, String collection) throws MorphiumDriverException {
        List<String> ret = this.listCollections(db, null);
        for (String c : ret) {
            if (!c.equals(collection)) continue;
            return true;
        }
        return false;
    }

    @Override
    public List<String> getHostSeed() {
        if (this.hostSeed == null) {
            return null;
        }
        return Collections.unmodifiableList(new ArrayList<String>(this.hostSeed));
    }

    @Override
    public String getReplicaSetName() {
        return this.replicaSetName;
    }

    @Override
    public void setReplicaSetName(String replicaSetName) {
        this.replicaSetName = replicaSetName;
    }

    @Override
    public int getMaxBsonObjectSize() {
        return this.maxBsonObjectSize;
    }

    @Override
    public void setMaxBsonObjectSize(int maxBsonObjectSize) {
        this.maxBsonObjectSize = maxBsonObjectSize;
    }

    @Override
    public int getMaxMessageSize() {
        return this.maxMessageSize;
    }

    @Override
    public void setMaxMessageSize(int maxMessageSize) {
        this.maxMessageSize = maxMessageSize;
    }

    @Override
    public int getMaxWriteBatchSize() {
        return this.maxWriteBatchSize;
    }

    @Override
    public void setMaxWriteBatchSize(int maxWriteBatchSize) {
        this.maxWriteBatchSize = maxWriteBatchSize;
    }

    @Override
    public boolean isReplicaSet() {
        return this.replicaSet;
    }

    @Override
    public void setReplicaSet(boolean replicaSet) {
        this.replicaSet = replicaSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNextId() {
        Class<DriverBase> clazz = DriverBase.class;
        synchronized (DriverBase.class) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.rqid.incrementAndGet();
        }
    }

    @Override
    public boolean getDefaultJ() {
        return this.defaultJ;
    }

    @Override
    public int getDefaultWriteTimeout() {
        return this.defaultWriteTimeout;
    }

    @Override
    public void setDefaultWriteTimeout(int wt) {
        this.defaultWriteTimeout = wt;
    }

    @Override
    public int getMaxWaitTime() {
        return this.maxWait;
    }

    @Override
    public void setMaxWaitTime(int maxWaitTime) {
        this.maxWait = maxWaitTime;
    }

    @Override
    public String[] getCredentials(String db) {
        return new String[0];
    }

    @Override
    public void setHostSeed(List<String> hosts) {
        this.hostSeed = Collections.synchronizedSet(new LinkedHashSet());
        this.hostSeed.addAll(hosts);
    }

    @Override
    public int getMaxConnectionLifetime() {
        return this.maxConnectionLifetime;
    }

    @Override
    public void setMaxConnectionLifetime(int timeout) {
        this.maxConnectionLifetime = timeout;
    }

    @Override
    public int getMaxConnectionIdleTime() {
        return this.maxConnectionIdleTime;
    }

    @Override
    public void setMaxConnectionIdleTime(int time) {
        this.maxConnectionIdleTime = time;
    }

    @Override
    public int getConnectionTimeout() {
        return this.connectionTimeout;
    }

    @Override
    public void setConnectionTimeout(int timeout) {
        this.connectionTimeout = timeout;
    }

    @Override
    public int getDefaultW() {
        return this.defaultW;
    }

    @Override
    public void setDefaultW(int w) {
        this.defaultW = w;
    }

    @Override
    public int getHeartbeatFrequency() {
        return this.heartbeatFrequency;
    }

    @Override
    public void setHeartbeatFrequency(int heartbeatFrequency) {
        this.heartbeatFrequency = heartbeatFrequency;
    }

    public Maximums getMaximums() {
        Maximums max = new Maximums();
        max.setMaxBsonSize(this.maxBsonObjectSize);
        max.setMaxMessageSize(this.maxMessageSize);
        max.setMaxWriteBatchSize(this.maxWriteBatchSize);
        return max;
    }

    @Override
    public ReadPreference getDefaultReadPreference() {
        return this.defaultRP;
    }

    @Override
    public void setDefaultReadPreference(ReadPreference rp) {
        this.defaultRP = rp;
    }

    @Override
    public int getDefaultBatchSize() {
        return this.batchSize;
    }

    @Override
    public void setDefaultBatchSize(int defaultBatchSize) {
        this.batchSize = defaultBatchSize;
    }

    @Override
    public boolean isUseSSL() {
        return this.useSSL;
    }

    @Override
    public void setUseSSL(boolean useSSL) {
        this.useSSL = useSSL;
    }

    @Override
    public boolean isDefaultJ() {
        return this.defaultJ;
    }

    @Override
    public void setDefaultJ(boolean j) {
        this.defaultJ = j;
    }

    public void heartBeatFrequency(int t) {
        this.heartbeatFrequency = t;
    }

    public void useSsl(boolean ssl) {
        this.useSSL = ssl;
    }

    @Override
    public MorphiumTransactionContext startTransaction(boolean autoCommit) {
        if (this.transactionContext.get() != null) {
            throw new IllegalArgumentException("Transaction in progress");
        }
        MorphiumTransactionContextImpl ctx = new MorphiumTransactionContextImpl();
        ctx.setLsid(UUID.randomUUID());
        ctx.setTxnNumber(Long.valueOf(this.getNextId()));
        this.transactionContext.set(ctx);
        return ctx;
    }

    @Override
    public MorphiumTransactionContext getTransactionContext() {
        return this.transactionContext.get();
    }

    @Override
    public void setTransactionContext(MorphiumTransactionContext ctx) {
        if (this.transactionContext.get() != null) {
            throw new IllegalArgumentException("Transaction already in progress!");
        }
        if (!(ctx instanceof MorphiumTransactionContextImpl)) {
            throw new IllegalArgumentException("Transaction context of wrong type!");
        }
        this.transactionContext.set((MorphiumTransactionContextImpl)ctx);
    }

    @Override
    public boolean isTransactionInProgress() {
        return this.transactionContext.get() != null;
    }

    protected void clearTransactionContext() {
        this.transactionContext.remove();
    }

    @Override
    public abstract void watch(WatchCommand var1) throws MorphiumDriverException;

    @Override
    public abstract boolean isCapped(String var1, String var2) throws MorphiumDriverException;

    public Logger getLog() {
        return this.log;
    }

    public AtomicInteger getRqid() {
        return this.rqid;
    }

    public void setRqid(AtomicInteger rqid) {
        this.rqid = rqid;
    }

    public int getMaxWait() {
        return this.maxWait;
    }

    public void setMaxWait(int maxWait) {
        this.maxWait = maxWait;
    }

    public ReadPreference getDefaultRP() {
        return this.defaultRP;
    }

    public void setDefaultRP(ReadPreference defaultRP) {
        this.defaultRP = defaultRP;
    }

    public int getSleepBetweenRetries() {
        return this.sleepBetweenRetries;
    }

    public void setSleepBetweenRetries(int sleepBetweenRetries) {
        this.sleepBetweenRetries = sleepBetweenRetries;
    }

    public void setHostSeed(Set<String> hostSeed) {
        this.hostSeed = hostSeed instanceof SequencedSet ? (SequencedSet)hostSeed : Collections.synchronizedSet(new LinkedHashSet<String>(hostSeed));
    }

    public String getFirstHost() {
        return this.hostSeed != null && !this.hostSeed.isEmpty() ? this.hostSeed.iterator().next() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getLastHost() {
        if (this.hostSeed != null && !this.hostSeed.isEmpty()) {
            Set<String> set = this.hostSeed;
            synchronized (set) {
                return this.hostSeed.stream().reduce((first, second) -> second).orElse(null);
            }
        }
        return null;
    }

    public void addHostFirst(String host) {
        if (this.hostSeed != null) {
            Set<String> newHostSeed = Collections.synchronizedSet(new LinkedHashSet());
            newHostSeed.add(host);
            newHostSeed.addAll(this.hostSeed);
            this.hostSeed = newHostSeed;
        }
    }

    public void addHostLast(String host) {
        if (this.hostSeed != null) {
            this.hostSeed.add(host);
        }
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    public void setBatchSize(int batchSize) {
        this.batchSize = batchSize;
    }

    public int getCompressionType() {
        return this.compressionType;
    }

    public void setCompressionType(int compressionType) {
        this.compressionType = compressionType;
    }

    @Override
    public int getLocalThreshold() {
        return this.localThreshold;
    }

    @Override
    public void setLocalThreshold(int localThreshold) {
        this.localThreshold = localThreshold;
    }

    public void setTransactionContext(ThreadLocal<MorphiumTransactionContext> transactionContext) {
        this.transactionContext = transactionContext;
    }
}

