/*
 * Decompiled with CFR 0.152.
 */
package de.caluga.morphium.driver.inmem;

import de.caluga.morphium.Collation;
import de.caluga.morphium.MongoType;
import de.caluga.morphium.aggregation.Expr;
import de.caluga.morphium.driver.Doc;
import de.caluga.morphium.driver.MorphiumId;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.Collator;
import java.text.ParseException;
import java.text.RuleBasedCollator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import org.bson.types.ObjectId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryHelper {
    private static final Logger log = LoggerFactory.getLogger(QueryHelper.class);

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean matchesQuery(Map<String, Object> query, Map<String, Object> toCheck, Map<String, Object> collation) {
        Collator c;
        Object commandKey;
        List lst;
        String keyQuery;
        block236: {
            if (query.isEmpty()) {
                return true;
            }
            for (String key : query.keySet()) {
                boolean allMatched;
                if (!(query.get(key) instanceof Map)) continue;
                Map queryMap = (Map)query.get(key);
                if (toCheck.get(key) instanceof Map) {
                    Map checkMap = (Map)toCheck.get(key);
                    allMatched = true;
                    for (Object mapKey : queryMap.keySet()) {
                        if (checkMap.containsKey(mapKey) && QueryHelper.compareValues(checkMap.get(mapKey), queryMap.get(mapKey), null)) continue;
                        allMatched = false;
                        break;
                    }
                    if (!allMatched) continue;
                    return true;
                }
                if (!(toCheck.get(key) instanceof List)) continue;
                List checkList = (List)toCheck.get(key);
                allMatched = true;
                for (Object mapKey : queryMap.keySet()) {
                    try {
                        int idx = Integer.parseInt((String)mapKey);
                        Object indexQuery = queryMap.get(mapKey);
                        if (idx < 0 || idx >= checkList.size()) {
                            if (indexQuery instanceof Map && ((Map)indexQuery).containsKey("$exists")) {
                                Object v = ((Map)indexQuery).get("$exists");
                                if (!Boolean.TRUE.equals(v) && !"true".equals(v) && !Integer.valueOf(1).equals(v)) continue;
                                allMatched = false;
                                break;
                            }
                            allMatched = false;
                            break;
                        }
                        if (indexQuery instanceof Map && ((Map)indexQuery).containsKey("$exists")) {
                            Object v = ((Map)indexQuery).get("$exists");
                            if (Boolean.TRUE.equals(v) || "true".equals(v) || Integer.valueOf(1).equals(v)) continue;
                            allMatched = false;
                            break;
                        }
                        Object e = checkList.get(idx);
                        if (e instanceof Map) {
                            if (QueryHelper.matchesQuery((Map)indexQuery, (Map)e, collation)) continue;
                            allMatched = false;
                            break;
                        }
                        Map<String, Object> syntheticDoc = Map.of("value", e);
                        Map<String, Object> elementQuery = Map.of("value", indexQuery);
                        if (QueryHelper.matchesQuery(elementQuery, syntheticDoc, collation)) continue;
                        allMatched = false;
                    }
                    catch (NumberFormatException e) {
                        allMatched = false;
                    }
                    break;
                }
                if (!allMatched) continue;
                return true;
            }
            boolean ret = false;
            Iterator<String> iterator = query.keySet().iterator();
            block85: while (iterator.hasNext()) {
                Object lst2;
                Object pth;
                Object mapKey;
                switch (keyQuery = iterator.next()) {
                    case "$and": {
                        Map q;
                        lst = (List)query.get(keyQuery);
                        mapKey = lst.iterator();
                        do {
                            if (!mapKey.hasNext()) return true;
                        } while (QueryHelper.matchesQuery(q = (Map)mapKey.next(), toCheck, collation));
                        return false;
                    }
                    case "$or": {
                        Map q;
                        lst = (List)query.get(keyQuery);
                        mapKey = lst.iterator();
                        do {
                            if (!mapKey.hasNext()) return false;
                        } while (!QueryHelper.matchesQuery(q = (Map)mapKey.next(), toCheck, collation));
                        return true;
                    }
                    case "$not": {
                        if (QueryHelper.matchesQuery((Map)query.get(keyQuery), toCheck, collation)) return false;
                        return true;
                    }
                    case "$nor": {
                        Map q;
                        lst = (List)query.get(keyQuery);
                        mapKey = lst.iterator();
                        do {
                            if (!mapKey.hasNext()) return true;
                        } while (!QueryHelper.matchesQuery(q = (Map)mapKey.next(), toCheck, collation));
                        return false;
                    }
                    case "$expr": {
                        Expr expr = Expr.parse(query.get(keyQuery));
                        Object result = expr.evaluate(toCheck);
                        if (!(result instanceof Expr)) return Boolean.TRUE.equals(result);
                        result = ((Expr)result).evaluate(toCheck);
                        return Boolean.TRUE.equals(result);
                    }
                    case "$jsonSchema": {
                        Object schema = query.get(keyQuery);
                        if (!(schema instanceof Map)) {
                            return false;
                        }
                        if (!QueryHelper.matchesJsonSchema((Map)schema, toCheck)) {
                            return false;
                        }
                        ret = true;
                        continue block85;
                    }
                    case "$where": {
                        ret = QueryHelper.runWhere(query, toCheck);
                        continue block85;
                    }
                }
                if (!(query.get(keyQuery) instanceof Map)) break block236;
                Map commandMap = (Map)query.get(keyQuery);
                ArrayList<String> operators = new ArrayList<String>();
                for (String opKey : commandMap.keySet()) {
                    if ("$options".equals(opKey)) continue;
                    operators.add(opKey);
                }
                if (operators.size() > 1) {
                    for (String opKey : operators) {
                        LinkedHashMap linkedHashMap = new LinkedHashMap();
                        linkedHashMap.put(opKey, commandMap.get(opKey));
                        if (commandMap.containsKey("$options")) {
                            linkedHashMap.put("$options", commandMap.get("$options"));
                        }
                        LinkedHashMap<String, Object> singleQuery = new LinkedHashMap<String, Object>();
                        singleQuery.put(keyQuery, linkedHashMap);
                        if (QueryHelper.matchesQuery(singleQuery, toCheck, collation)) continue;
                        return false;
                    }
                    ret = true;
                    continue;
                }
                Iterator it = commandMap.keySet().iterator();
                commandKey = (String)it.next();
                while (((String)commandKey).equals("$options") && it.hasNext()) {
                    commandKey = (String)it.next();
                }
                if (keyQuery.equals("$expr")) {
                    Expr expr = Expr.parse(commandMap);
                    return Boolean.TRUE.equals(expr.evaluate(toCheck));
                }
                Object var12_27 = null;
                if (collation != null && !collation.isEmpty()) {
                    Collator collator = QueryHelper.getCollator(collation);
                }
                Object checkValue = toCheck;
                if (keyQuery.contains(".")) {
                    String[] parts = keyQuery.split("\\.", 2);
                    if (parts.length == 2 && toCheck.get(parts[0]) instanceof Map) {
                        Map mapField = (Map)toCheck.get(parts[0]);
                        if (mapField.containsKey(parts[1])) {
                            checkValue = mapField.get(parts[1]);
                        } else {
                            pth = keyQuery.split("\\.");
                            checkValue = toCheck;
                            Object object = pth;
                            int n = ((Object)object).length;
                            for (int i = 0; i < n; ++i) {
                                Object p = object[i];
                                if (checkValue != null) {
                                    if (checkValue instanceof Map) {
                                        checkValue = ((Map)checkValue).get(p);
                                        continue;
                                    }
                                    if (!(checkValue instanceof List)) continue;
                                    try {
                                        int idx = Integer.valueOf((String)p);
                                        checkValue = ((List)checkValue).get(Integer.valueOf((String)p));
                                    }
                                    catch (Exception e) {
                                        lst2 = new ArrayList();
                                        for (Object o : (List)checkValue) {
                                            if (!(o instanceof Map)) continue;
                                            ((ArrayList)lst2).add(((Map)o).get(p));
                                        }
                                        checkValue = lst2;
                                    }
                                    continue;
                                }
                                break;
                            }
                        }
                    } else {
                        String[] pth2 = keyQuery.split("\\.");
                        checkValue = toCheck;
                        for (String p : pth2) {
                            if (checkValue != null) {
                                if (checkValue instanceof Map) {
                                    checkValue = checkValue.get(p);
                                    continue;
                                }
                                if (!(checkValue instanceof List)) continue;
                                try {
                                    int idx = Integer.valueOf(p);
                                    checkValue = ((List)checkValue).get(Integer.valueOf(p));
                                }
                                catch (Exception e) {
                                    ArrayList lst3 = new ArrayList();
                                    for (Object o : (List)checkValue) {
                                        if (!(o instanceof Map)) continue;
                                        lst3.add(((Map)o).get(p));
                                    }
                                    checkValue = lst3;
                                }
                                continue;
                            }
                            break;
                        }
                    }
                } else {
                    checkValue = toCheck.get(keyQuery);
                }
                switch (commandKey) {
                    case "$where": {
                        return QueryHelper.runWhere(query, toCheck);
                    }
                    case "$eq": {
                        Object value;
                        void var12_29;
                        if (checkValue == null && commandMap.get(commandKey) == null) {
                            return true;
                        }
                        if (checkValue == null) return false;
                        if (commandMap.get(commandKey) == null) {
                            return false;
                        }
                        if (!(checkValue instanceof List)) return QueryHelper.compareValues(checkValue, commandMap.get(commandKey), (Collator)var12_29);
                        pth = ((List)checkValue).iterator();
                        do {
                            if (!pth.hasNext()) return false;
                        } while (!QueryHelper.compareValues(value = pth.next(), commandMap.get(commandKey), (Collator)var12_29));
                        return true;
                    }
                    case "$lte": 
                    case "$lt": {
                        Map cv;
                        void var12_29;
                        List<Map> lst4 = null;
                        int offset = 0;
                        if (((String)commandKey).equals("$lt")) {
                            offset = -1;
                        }
                        if (checkValue instanceof List) {
                            lst4 = (List<Map>)checkValue;
                        } else if (checkValue != null) {
                            lst4 = List.of(checkValue);
                        }
                        if (lst4 == null) {
                            return false;
                        }
                        Iterator<Map> iterator2 = lst4.iterator();
                        do {
                            if (!iterator2.hasNext()) return false;
                        } while ((cv = iterator2.next()) == null || !QueryHelper.compareLessThan(cv, commandMap.get(commandKey), offset, (Collator)var12_29));
                        return true;
                    }
                    case "$gte": 
                    case "$gt": {
                        Map cv;
                        void var12_29;
                        List<Map> lst4 = null;
                        int offset = 0;
                        if (((String)commandKey).equals("$gt")) {
                            offset = 1;
                        }
                        if (checkValue instanceof List) {
                            lst4 = (List)checkValue;
                        } else if (checkValue != null) {
                            lst4 = List.of(checkValue);
                        }
                        if (lst4 == null) {
                            return false;
                        }
                        Iterator<Map> iterator3 = lst4.iterator();
                        do {
                            if (!iterator3.hasNext()) return false;
                        } while ((cv = iterator3.next()) == null || !QueryHelper.compareGreaterThan(cv, commandMap.get(commandKey), offset, (Collator)var12_29));
                        return true;
                    }
                    case "$mod": {
                        Number n = (Number)checkValue;
                        List arr = (List)commandMap.get(commandKey);
                        int div = (Integer)arr.get(0);
                        int rem = (Integer)arr.get(1);
                        if (n.intValue() % div != rem) return false;
                        return true;
                    }
                    case "$ne": {
                        void var12_29;
                        if (checkValue instanceof List) {
                            Object element;
                            lst2 = ((List)checkValue).iterator();
                            do {
                                if (!lst2.hasNext()) return true;
                            } while (!QueryHelper.compareValues(element = lst2.next(), commandMap.get(commandKey), (Collator)var12_29));
                            return false;
                        }
                        if (checkValue == null && commandMap.get(commandKey) == null) {
                            return false;
                        }
                        if (QueryHelper.compareValues(checkValue, commandMap.get(commandKey), (Collator)var12_29)) return false;
                        return true;
                    }
                    case "$exists": {
                        boolean expectExists;
                        boolean exists;
                        if (keyQuery.contains(".")) {
                            LookupResult lookup = QueryHelper.resolveValuesForPath(toCheck, keyQuery.split("\\."), 0);
                            exists = lookup.pathExists;
                        } else {
                            exists = QueryHelper.fieldExists(toCheck, keyQuery);
                            if (!exists && keyQuery.contains("_")) {
                                String camelCaseField = QueryHelper.convertSnakeToCamelCase(keyQuery);
                                exists = QueryHelper.fieldExists(toCheck, camelCaseField);
                            }
                            if (!exists && !keyQuery.contains("_")) {
                                String snakeCaseField = QueryHelper.convertCamelToSnakeCase(keyQuery);
                                exists = QueryHelper.fieldExists(toCheck, snakeCaseField);
                            }
                        }
                        Object existsOperand = commandMap.get(commandKey);
                        boolean bl = expectExists = Boolean.TRUE.equals(existsOperand) || "true".equals(existsOperand) || Integer.valueOf(1).equals(existsOperand);
                        if (!expectExists) {
                            if (exists) return false;
                            return true;
                        }
                        boolean bl2 = exists;
                        return bl2;
                    }
                    case "$nin": {
                        void var12_29;
                        boolean found = false;
                        for (Object v : (List)commandMap.get(commandKey)) {
                            Object normalized = QueryHelper.normalizeId(v);
                            if (checkValue instanceof List) {
                                for (Object element : (List)checkValue) {
                                    if (!QueryHelper.compareValues(element, normalized, (Collator)var12_29)) continue;
                                    return false;
                                }
                            } else if (QueryHelper.compareValues(checkValue, normalized, (Collator)var12_29)) {
                                return false;
                            }
                            if (!found) continue;
                            break;
                        }
                        if (found) return false;
                        return true;
                    }
                    case "$in": {
                        void var12_29;
                        Iterator iterator4 = ((List)commandMap.get(commandKey)).iterator();
                        block102: while (iterator4.hasNext()) {
                            Object v = iterator4.next();
                            Object normalized = QueryHelper.normalizeId(v);
                            if (checkValue instanceof List) {
                                Object element;
                                Iterator iterator5 = ((List)checkValue).iterator();
                                do {
                                    if (!iterator5.hasNext()) continue block102;
                                } while (!QueryHelper.compareValues(element = iterator5.next(), normalized, (Collator)var12_29));
                                return true;
                            }
                            if (QueryHelper.compareValues(checkValue, normalized, (Collator)var12_29)) return true;
                        }
                        return false;
                    }
                    case "$comment": {
                        continue block85;
                    }
                    case "$expr": {
                        Expr e = (Expr)commandMap.get(commandKey);
                        Object ev = e.evaluate(toCheck);
                        if (ev == null) return false;
                        if (ev.equals(Boolean.TRUE)) return true;
                        if (ev.equals(1)) return true;
                        if (!ev.equals("true")) return false;
                        return true;
                    }
                    case "$not": {
                        if (QueryHelper.matchesQuery((Map)commandMap.get(commandKey), toCheck, collation)) return false;
                        return true;
                    }
                    case "$regex": 
                    case "$regularExpression": 
                    case "$text": {
                        Object e;
                        Map valtoCheck = null;
                        if (keyQuery.contains(".")) {
                            String[] b = keyQuery.split("\\.");
                            Map val = toCheck;
                            for (int i = 0; i < b.length; ++i) {
                                String string = b[i];
                                Object candidate = val.get(string);
                                if (candidate == null) {
                                    return false;
                                }
                                if (!(candidate instanceof Map) && i < b.length - 1) {
                                    return false;
                                }
                                if (i < b.length - 1) {
                                    val = (Map)candidate;
                                }
                                if (i != b.length - 1) continue;
                                valtoCheck = candidate;
                            }
                        } else {
                            valtoCheck = checkValue;
                        }
                        int opts = 0;
                        if (commandMap.containsKey("$options")) {
                            String opt = commandMap.get("$options").toString().toLowerCase();
                            if (opt.contains("i")) {
                                opts |= 2;
                            }
                            if (opt.contains("m")) {
                                opts |= 8;
                            }
                            if (opt.contains("s")) {
                                opts |= 0x20;
                            }
                            if (opt.contains("x")) {
                                opts |= 4;
                            }
                        }
                        if (valtoCheck == null) {
                            return false;
                        }
                        if (((String)commandKey).equals("$text")) {
                            String srch = commandMap.get("$text").toString().toLowerCase();
                            ArrayList<String> tokens = new ArrayList<String>();
                            Pattern pattern = Pattern.compile("\"([^\"]+)\"");
                            Matcher matcher = pattern.matcher(srch);
                            while (matcher.find()) {
                                tokens.add(matcher.group(1));
                            }
                            srch = matcher.replaceAll(" ");
                            srch = srch.replaceAll("[^a-z0-9 ]", " ");
                            tokens.addAll(Arrays.asList(srch.trim().split(" +")));
                            String valueText = valtoCheck.toString().toLowerCase();
                            for (String token : tokens) {
                                if (token == null || token.isBlank() || valueText.contains(token)) continue;
                                return false;
                            }
                            if (tokens.isEmpty()) return false;
                            return true;
                        }
                        Pattern regexPattern = QueryHelper.buildRegexPattern(commandMap, opts);
                        if (regexPattern == null) {
                            return false;
                        }
                        if (!(valtoCheck instanceof List)) return regexPattern.matcher(valtoCheck.toString()).find();
                        Iterator tokens = ((List)((Object)valtoCheck)).iterator();
                        do {
                            if (!tokens.hasNext()) return false;
                        } while ((e = tokens.next()) == null || !regexPattern.matcher(e.toString()).find());
                        return true;
                    }
                    case "$type": {
                        Object o;
                        MongoType type = null;
                        if (commandMap.get(commandKey) instanceof Integer) {
                            type = MongoType.findByValue((Integer)commandMap.get(commandKey));
                        } else if (commandMap.get(commandKey) instanceof String) {
                            type = MongoType.findByTxt((String)commandMap.get(commandKey));
                        } else {
                            log.error("Type specification needs to be either int or string - not " + commandMap.get(commandKey).getClass().getName());
                            return false;
                        }
                        List elements = new ArrayList();
                        if (checkValue instanceof List) {
                            elements = (List)checkValue;
                        } else {
                            elements.add(checkValue);
                        }
                        Iterator iterator6 = elements.iterator();
                        do {
                            if (!iterator6.hasNext()) return false;
                        } while (!QueryHelper.matchesType(o = iterator6.next(), type));
                        return true;
                    }
                    case "$jsonSchema": {
                        break;
                    }
                    case "$geoIntersects": {
                        if (!QueryHelper.geoIntersects(checkValue, commandMap.get(commandKey))) {
                            return false;
                        }
                        ret = true;
                        continue block85;
                    }
                    case "$nearSphere": 
                    case "$near": {
                        if (!(checkValue instanceof List)) {
                            log.warn("No proper coordinates found");
                            return false;
                        }
                        if (commandMap.get(commandKey) instanceof Map) {
                            Map map = (Map)commandMap.get(commandKey);
                            Map geo = (Map)map.get("$geometry");
                            if (!geo.containsKey("type")) return false;
                            if (!geo.get("type").equals("Point")) {
                                log.warn("$near needs a point as parameter");
                                return false;
                            }
                            List coord = (List)geo.get("coordinates");
                            if (coord == null || coord.size() != 2) {
                                log.warn("Coordinates for point wrong!");
                                return false;
                            }
                            double lat1 = (Double)coord.get(1);
                            double lon1 = (Double)coord.get(0);
                            double d = (Double)((List)checkValue).get(1);
                            double lon2 = (Double)((List)checkValue).get(0);
                            lon1 = Math.toRadians(lon1);
                            lon2 = Math.toRadians(lon2);
                            lat1 = Math.toRadians(lat1);
                            d = Math.toRadians(d);
                            double dlon = lon2 - lon1;
                            double dlat = d - lat1;
                            double a = Math.pow(Math.sin(dlat / 2.0), 2.0) + Math.cos(lat1) * Math.cos(d) * Math.pow(Math.sin(dlon / 2.0), 2.0);
                            double c2 = 2.0 * Math.asin(Math.sqrt(a));
                            double r = 6371.0;
                            double distance = c2 * r;
                            if (map.containsKey("$minDistance") && distance < (Double)map.get("$minDistance")) {
                                return false;
                            }
                            if (map.containsKey("$maxDistance") && distance > (Double)map.get("$maxDistance")) {
                                return false;
                            }
                            if (map.containsKey("$maxDistance")) return true;
                            if (map.containsKey("$minDistance")) return true;
                            log.warn("No distance given?");
                            return true;
                        }
                        log.error("Could not parse near query");
                        return false;
                    }
                    case "$geoWithin": {
                        if (!(checkValue instanceof List)) {
                            log.warn("No proper coordinates found");
                            return false;
                        }
                        if (!(commandMap.get(commandKey) instanceof Map)) {
                            log.warn("No proper geoWithin query for " + keyQuery);
                            return false;
                        }
                        Map map = (Map)commandMap.get(commandKey);
                        List coordToCheckWithin = (List)checkValue;
                        if (!map.containsKey("$box")) continue block85;
                        List coords = (List)map.get("$box");
                        if (coords.size() > 2) {
                            log.error("Box coordinates should be 2 Points!");
                        } else if (coords.size() < 2) {
                            log.error("No proper box coordinates");
                            return false;
                        }
                        Double upperLeftX = (Double)((List)coords.get(0)).get(0);
                        Double upperLeftY = (Double)((List)coords.get(0)).get(1);
                        Double lowerRightX = (Double)((List)coords.get(1)).get(0);
                        Double lowerRightY = (Double)((List)coords.get(1)).get(1);
                        if (lowerRightX < upperLeftX) {
                            Double d = upperLeftX;
                            upperLeftX = lowerRightX;
                            lowerRightX = d;
                        }
                        if (lowerRightY < upperLeftY) {
                            Double d = upperLeftY;
                            upperLeftY = lowerRightY;
                            lowerRightY = d;
                        }
                        if (coordToCheckWithin.size() == 2 && coordToCheckWithin.get(0) instanceof Double) {
                            Double d = (Double)coordToCheckWithin.get(0);
                            Double y = (Double)coordToCheckWithin.get(1);
                            if (d > lowerRightX) return false;
                            if (d < upperLeftX) {
                                return false;
                            }
                            if (y > lowerRightY) return false;
                            if (!(y < upperLeftY)) return true;
                            return false;
                        }
                        Iterator iterator7 = coordToCheckWithin.iterator();
                        block109: while (true) {
                            Double y;
                            if (!iterator7.hasNext()) return true;
                            Object o = iterator7.next();
                            Iterator lon2 = ((List)o).iterator();
                            do {
                                if (!lon2.hasNext()) continue block109;
                                List coord = (List)lon2.next();
                                Double x = (Double)coord.get(0);
                                y = (Double)coord.get(1);
                                if (x > lowerRightX) return false;
                                if (x < upperLeftX) {
                                    return false;
                                }
                                if (y > lowerRightY) return false;
                            } while (!(y < upperLeftY));
                            break;
                        }
                        return false;
                    }
                    case "$all": {
                        Object o;
                        if (checkValue == null) {
                            return false;
                        }
                        if (!(checkValue instanceof List)) {
                            log.warn("Trying $all on non-list value");
                            return false;
                        }
                        if (!(commandMap.get(commandKey) instanceof List)) {
                            log.warn("Syntax: $all: [ v1,v2,v3... ]");
                            return false;
                        }
                        List toCheckValList = (List)checkValue;
                        List queryValues = (List)commandMap.get(commandKey);
                        Iterator upperLeftY = queryValues.iterator();
                        do {
                            if (!upperLeftY.hasNext()) return true;
                        } while (toCheckValList.contains(o = upperLeftY.next()));
                        return false;
                    }
                    case "$size": {
                        if (checkValue == null) {
                            return commandMap.get(commandKey).equals(0);
                        }
                        if (checkValue instanceof List) return commandMap.get(commandKey).equals(((List)checkValue).size());
                        log.warn("Trying $size on non-list value");
                        return false;
                    }
                    case "$elemMatch": {
                        void var39_119;
                        if (checkValue == null) {
                            return false;
                        }
                        if (!(checkValue instanceof List)) {
                            log.warn("Trying $elemMatch on non-list value");
                            return false;
                        }
                        if (!(commandMap.get(commandKey) instanceof Map)) {
                            log.warn("Syntax: $elemMatch { field: QUERYMAP}");
                            return false;
                        }
                        List valList = (List)checkValue;
                        Map queryMap = (Map)commandMap.get(commandKey);
                        Iterator lowerRightY = valList.iterator();
                        do {
                            if (!lowerRightY.hasNext()) return false;
                            Object e = lowerRightY.next();
                            if (!(e instanceof Map)) {
                                Doc doc = Doc.of("value", e);
                            }
                            if (QueryHelper.matchesQuery(queryMap, (Map)var39_119, null)) return true;
                        } while (!QueryHelper.matchesQuery(Doc.of("value", queryMap), (Map)var39_119, null));
                        return true;
                    }
                    case "$bitsAnySet": 
                    case "$bitsAllClear": 
                    case "$bitsAllSet": 
                    case "$bitsAnyClear": {
                        if (checkValue == null) {
                            return false;
                        }
                        long value = 0L;
                        if (commandMap.get(commandKey) instanceof Integer) {
                            value = ((Integer)commandMap.get(commandKey)).longValue();
                        } else if (commandMap.get(commandKey) instanceof Long) {
                            value = (Long)commandMap.get(commandKey);
                        } else if (commandMap.get(commandKey) instanceof List) {
                            for (Object o : (List)commandMap.get(commandKey)) {
                                if (!(o instanceof Integer)) continue;
                                value |= 1L << (Integer)o;
                            }
                        } else if (commandMap.get(commandKey) instanceof byte[]) {
                            byte[] b = (byte[])commandMap.get(commandKey);
                            int bits = 0;
                            for (int idx = b.length - 1; idx > 0; ++idx) {
                                value |= (long)(b[idx] << bits);
                                bits += 8;
                            }
                        }
                        long chkVal = 0L;
                        if (checkValue instanceof Integer) {
                            chkVal = ((Integer)checkValue).longValue();
                        } else if (checkValue instanceof Long) {
                            chkVal = (Long)checkValue;
                        } else if (checkValue instanceof Byte) {
                            chkVal = ((Byte)checkValue).byteValue();
                        }
                        if (((String)commandKey).equals("$bitsAnySet")) {
                            if ((value & chkVal) == 0L) return false;
                            return true;
                        }
                        if (((String)commandKey).equals("$bitsAllSet")) {
                            if ((value & chkVal) != value) return false;
                            return true;
                        }
                        if (((String)commandKey).equals("$bitsAnyClear")) {
                            if ((value & chkVal) >= value) return false;
                            return true;
                        }
                        if ((value & chkVal) != 0L) return false;
                        return true;
                    }
                    case "$options": {
                        break;
                    }
                    default: {
                        if (toCheck.containsKey(commandKey)) {
                            return toCheck.get(commandKey).equals(commandMap.get(commandKey));
                        }
                        if (!keyQuery.equals("value")) return commandMap.equals(toCheck);
                        return false;
                    }
                }
            }
            return ret;
        }
        if (keyQuery.contains(".")) {
            String[] path = keyQuery.split("\\.");
            LookupResult lookup = QueryHelper.resolveValuesForPath(toCheck, path, 0);
            Object expected = query.get(keyQuery);
            if (!lookup.pathExists) {
                if (expected != null) return false;
                return true;
            }
            if (expected == null) {
                Object e;
                if (lookup.values.isEmpty()) {
                    return true;
                }
                commandKey = lookup.values.iterator();
                do {
                    if (!commandKey.hasNext()) return false;
                } while ((e = commandKey.next()) != null);
                return true;
            }
            Collator coll = null;
            if (collation != null && !collation.isEmpty()) {
                coll = QueryHelper.getCollator(collation);
            }
            Iterator<Object> iterator = lookup.values.iterator();
            block116: while (iterator.hasNext()) {
                Object candidate = iterator.next();
                if (candidate instanceof List) {
                    Object element;
                    Object object = ((List)candidate).iterator();
                    do {
                        if (!object.hasNext()) continue block116;
                    } while (!QueryHelper.compareValues(element = object.next(), expected, coll));
                    return true;
                }
                if (QueryHelper.compareValues(candidate, expected, coll)) return true;
            }
            return false;
        }
        if (toCheck.get(keyQuery) == null && query.get(keyQuery) == null) {
            return true;
        }
        if (toCheck.get(keyQuery) == null && query.get(keyQuery) != null) {
            return false;
        }
        if (toCheck.get(keyQuery) instanceof MorphiumId) return toCheck.get(keyQuery).toString().equals(query.get(keyQuery).toString());
        if (toCheck.get(keyQuery) instanceof ObjectId) {
            return toCheck.get(keyQuery).toString().equals(query.get(keyQuery).toString());
        }
        if (toCheck.get(keyQuery) instanceof List) {
            Object e;
            lst = (List)toCheck.get(keyQuery);
            Object qv = query.get(keyQuery);
            if (collation == null) return lst.contains(qv);
            if (!(qv instanceof String)) return lst.contains(qv);
            Collator c3 = QueryHelper.getCollator(collation);
            if (c3 == null) return lst.contains(qv);
            Iterator iterator = lst.iterator();
            do {
                if (!iterator.hasNext()) return false;
            } while (!((e = iterator.next()) instanceof String) || !c3.equals((String)e, (String)qv));
            return true;
        }
        if (collation != null && toCheck.get(keyQuery) instanceof String && query.get(keyQuery) instanceof String && (c = QueryHelper.getCollator(collation)) != null) {
            return c.equals((String)toCheck.get(keyQuery), (String)query.get(keyQuery));
        }
        if (toCheck.get(keyQuery) == null) return false;
        if (!toCheck.get(keyQuery).equals(query.get(keyQuery))) return false;
        return true;
    }

    private static boolean matchesJsonSchema(Map<String, Object> schema, Map<String, Object> document) {
        if (schema == null) {
            return true;
        }
        try {
            return QueryHelper.validateJsonSchema(schema, document);
        }
        catch (ClassCastException e) {
            log.debug("$jsonSchema evaluation failed because of incompatible schema definition: {}", (Object)e.getMessage());
            return false;
        }
    }

    private static Geometry toGeometry(String type, List<?> coordinates) {
        if (type == null || coordinates == null) {
            return null;
        }
        switch (type = type.toLowerCase(Locale.ROOT)) {
            case "point": {
                return new PointGeometry(coordinates);
            }
            case "linestring": {
                return new LineStringGeometry(coordinates);
            }
            case "polygon": {
                return new PolygonGeometry(coordinates);
            }
            case "multipoint": {
                return new MultiGeometry(coordinates, "point");
            }
            case "multilinestring": {
                return new MultiGeometry(coordinates, "linestring");
            }
            case "multipolygon": {
                return new MultiGeometry(coordinates, "polygon");
            }
        }
        log.warn("Unsupported geo type '{}'", (Object)type);
        return null;
    }

    private static double toDouble(List<?> point, int index) {
        if (point == null || point.size() <= index) {
            return Double.NaN;
        }
        Object value = point.get(index);
        if (value instanceof Number) {
            return ((Number)value).doubleValue();
        }
        if (value instanceof String) {
            try {
                return Double.parseDouble((String)value);
            }
            catch (NumberFormatException ignored) {
                return Double.NaN;
            }
        }
        return Double.NaN;
    }

    private static boolean pointOnSegment(double px, double py, double x1, double y1, double x2, double y2) {
        double cross = (px - x1) * (y2 - y1) - (py - y1) * (x2 - x1);
        if (Math.abs(cross) > 1.0E-9) {
            return false;
        }
        double dot = (px - x1) * (px - x2) + (py - y1) * (py - y2);
        return dot <= 0.0;
    }

    private static boolean segmentsIntersect(double x1, double y1, double x2, double y2, double x3, double y3, double x4, double y4) {
        double d1 = QueryHelper.direction(x3, y3, x4, y4, x1, y1);
        double d2 = QueryHelper.direction(x3, y3, x4, y4, x2, y2);
        double d3 = QueryHelper.direction(x1, y1, x2, y2, x3, y3);
        double d4 = QueryHelper.direction(x1, y1, x2, y2, x4, y4);
        if ((d1 > 0.0 && d2 < 0.0 || d1 < 0.0 && d2 > 0.0) && (d3 > 0.0 && d4 < 0.0 || d3 < 0.0 && d4 > 0.0)) {
            return true;
        }
        if (Math.abs(d1) < 1.0E-9 && QueryHelper.pointOnSegment(x1, y1, x3, y3, x4, y4)) {
            return true;
        }
        if (Math.abs(d2) < 1.0E-9 && QueryHelper.pointOnSegment(x2, y2, x3, y3, x4, y4)) {
            return true;
        }
        if (Math.abs(d3) < 1.0E-9 && QueryHelper.pointOnSegment(x3, y3, x1, y1, x2, y2)) {
            return true;
        }
        return Math.abs(d4) < 1.0E-9 && QueryHelper.pointOnSegment(x4, y4, x1, y1, x2, y2);
    }

    private static double direction(double xi, double yi, double xj, double yj, double xk, double yk) {
        return (xk - xi) * (yj - yi) - (xj - xi) * (yk - yi);
    }

    private static boolean pointInPolygon(double px, double py, LineStringGeometry ring) {
        int intersections = 0;
        for (int i = 0; i < ring.xs.length - 1; ++i) {
            boolean intersect;
            double x1 = ring.xs[i];
            double y1 = ring.ys[i];
            double x2 = ring.xs[i + 1];
            double y2 = ring.ys[i + 1];
            if (QueryHelper.pointOnSegment(px, py, x1, y1, x2, y2)) {
                return true;
            }
            boolean bl = intersect = y1 > py != y2 > py && px < (x2 - x1) * (py - y1) / (y2 - y1 + 1.0E-12) + x1;
            if (!intersect) continue;
            ++intersections;
        }
        return intersections % 2 == 1;
    }

    private static Map<String, Object> asGeometry(Object value) {
        if (!(value instanceof Map)) {
            return null;
        }
        Map map = (Map)value;
        if (!map.containsKey("type") || !map.containsKey("coordinates")) {
            return null;
        }
        return map;
    }

    private static boolean geoIntersects(Object documentGeometry, Object queryGeometry) {
        Map<String, Object> docGeo = QueryHelper.asGeometry(documentGeometry);
        Map<String, Object> queryGeo = QueryHelper.asGeometry(queryGeometry instanceof Map && ((Map)queryGeometry).containsKey("$geometry") ? ((Map)queryGeometry).get("$geometry") : queryGeometry);
        if (docGeo == null || queryGeo == null) {
            return false;
        }
        String docType = (String)docGeo.get("type");
        String queryType = (String)queryGeo.get("type");
        if (docType == null || queryType == null) {
            return false;
        }
        List<?> docCoords = QueryHelper.toListView(docGeo.get("coordinates"));
        List<?> queryCoords = QueryHelper.toListView(queryGeo.get("coordinates"));
        if (docCoords == null || queryCoords == null) {
            return false;
        }
        Geometry docGeometryObj = QueryHelper.toGeometry(docType, docCoords);
        Geometry queryGeometryObj = QueryHelper.toGeometry(queryType, queryCoords);
        if (docGeometryObj == null || queryGeometryObj == null) {
            return false;
        }
        return docGeometryObj.intersects(queryGeometryObj);
    }

    /*
     * WARNING - void declaration
     */
    private static boolean validateJsonSchema(Map<String, Object> schema, Object value) {
        block68: {
            Object object;
            HashSet hashSet;
            Map mapValue;
            block69: {
                Map patternProperties;
                Number number;
                Number number2;
                List<?> list;
                List<Object> allowedValues;
                Object object2;
                Object object3;
                boolean condition;
                if (schema == null) {
                    return true;
                }
                if (schema.containsKey("allOf")) {
                    for (Object object4 : QueryHelper.asList(schema.get("allOf"))) {
                        if (!(object4 instanceof Map) || QueryHelper.validateJsonSchema((Map)object4, value)) continue;
                        return false;
                    }
                }
                if (schema.containsKey("anyOf")) {
                    boolean matched = false;
                    for (Object entry : QueryHelper.asList(schema.get("anyOf"))) {
                        if (!(entry instanceof Map) || !QueryHelper.validateJsonSchema((Map)entry, value)) continue;
                        matched = true;
                        break;
                    }
                    if (!matched) {
                        return false;
                    }
                }
                if (schema.containsKey("oneOf")) {
                    int matches = 0;
                    for (Object entry : QueryHelper.asList(schema.get("oneOf"))) {
                        if (!(entry instanceof Map) || !QueryHelper.validateJsonSchema((Map)entry, value)) continue;
                        ++matches;
                    }
                    if (matches != 1) {
                        return false;
                    }
                }
                if (schema.containsKey("not") && schema.get("not") instanceof Map && QueryHelper.validateJsonSchema((Map)schema.get("not"), value)) {
                    return false;
                }
                if (schema.containsKey("if") && schema.get("if") instanceof Map && ((condition = QueryHelper.validateJsonSchema((Map)schema.get("if"), value)) ? (object3 = schema.get("then")) instanceof Map && !QueryHelper.validateJsonSchema((Map)object3, value) : (object2 = schema.get("else")) instanceof Map && !QueryHelper.validateJsonSchema((Map)object2, value))) {
                    return false;
                }
                if (schema.containsKey("enum") && !(allowedValues = QueryHelper.asList(schema.get("enum"))).isEmpty()) {
                    boolean bl;
                    boolean bl2 = false;
                    for (Object object5 : allowedValues) {
                        if (!QueryHelper.compareValues(value, object5, null)) continue;
                        bl = true;
                        break;
                    }
                    if (!bl) {
                        return false;
                    }
                }
                if (schema.containsKey("const") && !QueryHelper.compareValues(value, schema.get("const"), null)) {
                    return false;
                }
                if (schema.containsKey("bsonType") || schema.containsKey("type")) {
                    Object typeSpec = schema.containsKey("bsonType") ? schema.get("bsonType") : schema.get("type");
                    List<Object> list2 = QueryHelper.asList(typeSpec);
                    boolean typeMatch = false;
                    for (Object object6 : list2) {
                        if (!QueryHelper.matchesTypeSpecification(value, object6)) continue;
                        typeMatch = true;
                        break;
                    }
                    if (!typeMatch) {
                        return false;
                    }
                }
                if (value == null) {
                    return true;
                }
                BigDecimal numeric = QueryHelper.toBigDecimal(value);
                if (numeric != null) {
                    BigDecimal remainder;
                    BigDecimal bigDecimal;
                    BigDecimal maximum;
                    Object object7;
                    BigDecimal minimum;
                    Object object8;
                    BigDecimal bigDecimal2;
                    BigDecimal bigDecimal3;
                    if (schema.containsKey("minimum") && (bigDecimal3 = QueryHelper.toBigDecimal(schema.get("minimum"))) != null && numeric.compareTo(bigDecimal3) < 0) {
                        return false;
                    }
                    if (schema.containsKey("maximum") && (bigDecimal2 = QueryHelper.toBigDecimal(schema.get("maximum"))) != null && numeric.compareTo(bigDecimal2) > 0) {
                        return false;
                    }
                    if (schema.containsKey("exclusiveMinimum") && ((object8 = schema.get("exclusiveMinimum")) instanceof Boolean ? (Boolean)object8 != false && schema.containsKey("minimum") && (minimum = QueryHelper.toBigDecimal(schema.get("minimum"))) != null && numeric.compareTo(minimum) <= 0 : (minimum = QueryHelper.toBigDecimal(object8)) != null && numeric.compareTo(minimum) <= 0)) {
                        return false;
                    }
                    if (schema.containsKey("exclusiveMaximum") && ((object7 = schema.get("exclusiveMaximum")) instanceof Boolean ? (Boolean)object7 != false && schema.containsKey("maximum") && (maximum = QueryHelper.toBigDecimal(schema.get("maximum"))) != null && numeric.compareTo(maximum) >= 0 : (maximum = QueryHelper.toBigDecimal(object7)) != null && numeric.compareTo(maximum) >= 0)) {
                        return false;
                    }
                    if (schema.containsKey("multipleOf") && (bigDecimal = QueryHelper.toBigDecimal(schema.get("multipleOf"))) != null && bigDecimal.compareTo(BigDecimal.ZERO) != 0 && ((remainder = numeric.remainder(bigDecimal)) == null || remainder.compareTo(BigDecimal.ZERO) != 0)) {
                        return false;
                    }
                }
                if (value instanceof String) {
                    Object object9;
                    Number maxLength;
                    Number minLength;
                    String string = (String)value;
                    if (schema.containsKey("minLength") && (minLength = QueryHelper.asNumber(schema.get("minLength"))) != null && string.codePointCount(0, string.length()) < minLength.intValue()) {
                        return false;
                    }
                    if (schema.containsKey("maxLength") && (maxLength = QueryHelper.asNumber(schema.get("maxLength"))) != null && string.codePointCount(0, string.length()) > maxLength.intValue()) {
                        return false;
                    }
                    if (schema.containsKey("pattern") && (object9 = schema.get("pattern")) instanceof String) {
                        String patternText = (String)object9;
                        try {
                            Pattern pattern = Pattern.compile(patternText);
                            if (!pattern.matcher(string).find()) {
                                return false;
                            }
                        }
                        catch (PatternSyntaxException patternSyntaxException) {
                            log.warn("Invalid regex in $jsonSchema pattern '{}': {}", (Object)patternText, (Object)patternSyntaxException.getMessage());
                            return false;
                        }
                    }
                }
                if ((list = QueryHelper.toListView(value)) != null) {
                    Number maxItems;
                    Number minItems;
                    if (schema.containsKey("minItems") && (minItems = QueryHelper.asNumber(schema.get("minItems"))) != null && list.size() < minItems.intValue()) {
                        return false;
                    }
                    if (schema.containsKey("maxItems") && (maxItems = QueryHelper.asNumber(schema.get("maxItems"))) != null && list.size() > maxItems.intValue()) {
                        return false;
                    }
                    if (Boolean.TRUE.equals(schema.get("uniqueItems"))) {
                        HashSet<Object> seen = new HashSet<Object>();
                        for (Object obj : list) {
                            Object normalized = QueryHelper.normalizeId(obj);
                            if (normalized instanceof byte[]) {
                                normalized = Arrays.hashCode((byte[])normalized);
                            }
                            if (seen.add(normalized)) continue;
                            return false;
                        }
                    }
                    if (schema.containsKey("items")) {
                        Object items = schema.get("items");
                        if (items instanceof Map) {
                            for (Object obj : list) {
                                if (QueryHelper.validateJsonSchema((Map)items, obj)) continue;
                                return false;
                            }
                        } else if (items instanceof List) {
                            void var6_67;
                            List list3 = (List)items;
                            boolean bl = false;
                            while (var6_67 < list3.size() && var6_67 < list.size()) {
                                Object tupleSchema = list3.get((int)var6_67);
                                if (tupleSchema instanceof Map && !QueryHelper.validateJsonSchema((Map)tupleSchema, list.get((int)var6_67))) {
                                    return false;
                                }
                                ++var6_67;
                            }
                            if (list.size() > list3.size()) {
                                Object additionalItems = schema.get("additionalItems");
                                if (additionalItems instanceof Boolean) {
                                    if (!((Boolean)additionalItems).booleanValue()) {
                                        return false;
                                    }
                                } else if (additionalItems instanceof Map) {
                                    void var8_75;
                                    int n = list3.size();
                                    while (var8_75 < list.size()) {
                                        if (!QueryHelper.validateJsonSchema((Map)additionalItems, list.get((int)var8_75))) {
                                            return false;
                                        }
                                        ++var8_75;
                                    }
                                }
                            }
                        }
                    }
                    if (schema.containsKey("contains") && schema.get("contains") instanceof Map) {
                        boolean containsMatch = false;
                        for (Object obj : list) {
                            if (!QueryHelper.validateJsonSchema((Map)schema.get("contains"), obj)) continue;
                            containsMatch = true;
                            break;
                        }
                        if (!containsMatch) {
                            return false;
                        }
                    }
                }
                if (!(value instanceof Map)) break block68;
                mapValue = (Map)value;
                if (schema.containsKey("minProperties") && (number2 = QueryHelper.asNumber(schema.get("minProperties"))) != null && mapValue.size() < number2.intValue()) {
                    return false;
                }
                if (schema.containsKey("maxProperties") && (number = QueryHelper.asNumber(schema.get("maxProperties"))) != null && mapValue.size() > number.intValue()) {
                    return false;
                }
                if (schema.containsKey("required")) {
                    for (Object object10 : QueryHelper.asList(schema.get("required"))) {
                        Object fieldName;
                        if (!(object10 instanceof String) || mapValue.containsKey(fieldName = (String)object10)) continue;
                        return false;
                    }
                }
                Map map = schema.get("properties") instanceof Map ? (Map)schema.get("properties") : Collections.emptyMap();
                hashSet = new HashSet(map.keySet());
                hashSet.add("_id");
                for (Map.Entry entry : map.entrySet()) {
                    if (!(entry.getValue() instanceof Map) || !mapValue.containsKey(entry.getKey()) || QueryHelper.validateJsonSchema((Map)entry.getValue(), mapValue.get(entry.getKey()))) continue;
                    return false;
                }
                Map map2 = patternProperties = schema.get("patternProperties") instanceof Map ? (Map)schema.get("patternProperties") : Collections.emptyMap();
                if (!patternProperties.isEmpty()) {
                    for (Map.Entry patternEntry : patternProperties.entrySet()) {
                        try {
                            Pattern compiled = Pattern.compile((String)patternEntry.getKey());
                            for (Map.Entry docEntry : mapValue.entrySet()) {
                                if (!compiled.matcher((CharSequence)docEntry.getKey()).find()) continue;
                                hashSet.add((String)docEntry.getKey());
                                if (!(patternEntry.getValue() instanceof Map) || QueryHelper.validateJsonSchema((Map)patternEntry.getValue(), docEntry.getValue())) continue;
                                return false;
                            }
                        }
                        catch (PatternSyntaxException pse) {
                            log.warn("Invalid regex in patternProperties '{}': {}", patternEntry.getKey(), (Object)pse.getMessage());
                            return false;
                        }
                    }
                }
                if (!schema.containsKey("additionalProperties")) break block68;
                object = schema.get("additionalProperties");
                if (!(object instanceof Boolean)) break block69;
                if (((Boolean)object).booleanValue()) break block68;
                for (String key : mapValue.keySet()) {
                    if (hashSet.contains(key)) continue;
                    return false;
                }
                break block68;
            }
            if (object instanceof Map) {
                for (Map.Entry entry : mapValue.entrySet()) {
                    if (hashSet.contains(entry.getKey()) || QueryHelper.validateJsonSchema((Map)object, entry.getValue())) continue;
                    return false;
                }
            }
        }
        return true;
    }

    private static boolean matchesTypeSpecification(Object value, Object specification) {
        if (specification == null) {
            return true;
        }
        if (specification instanceof Map) {
            return QueryHelper.validateJsonSchema((Map)specification, value);
        }
        if (specification instanceof Number) {
            MongoType mongoType = MongoType.findByValue(((Number)specification).intValue());
            return mongoType != null && QueryHelper.matchesType(value, mongoType);
        }
        if (specification instanceof String) {
            String typeName = (String)specification;
            String normalized = typeName.toLowerCase(Locale.ROOT);
            MongoType mongoType = MongoType.findByTxt(normalized);
            if (mongoType != null) {
                return QueryHelper.matchesType(value, mongoType);
            }
            switch (normalized) {
                case "number": {
                    return value instanceof Number || value instanceof BigDecimal;
                }
                case "integer": {
                    return QueryHelper.isIntegralNumber(value);
                }
                case "object": {
                    return value instanceof Map;
                }
                case "array": {
                    return value instanceof List || value != null && value.getClass().isArray();
                }
                case "boolean": {
                    return value instanceof Boolean;
                }
                case "string": {
                    return value instanceof String;
                }
                case "null": {
                    return value == null;
                }
                case "date": {
                    return value instanceof Date;
                }
                case "timestamp": {
                    return value instanceof Date || QueryHelper.matchesType(value, MongoType.TIMESTAMP);
                }
                case "decimal128": 
                case "decimal": {
                    return QueryHelper.matchesType(value, MongoType.DECIMAL);
                }
                case "objectid": {
                    return value instanceof MorphiumId || value instanceof ObjectId;
                }
            }
            return false;
        }
        return false;
    }

    private static List<Object> asList(Object value) {
        if (value == null) {
            return Collections.emptyList();
        }
        if (value instanceof List) {
            return (List)value;
        }
        if (value.getClass().isArray()) {
            int length = Array.getLength(value);
            ArrayList<Object> result = new ArrayList<Object>(length);
            for (int i = 0; i < length; ++i) {
                result.add(Array.get(value, i));
            }
            return result;
        }
        return Collections.singletonList(value);
    }

    private static List<?> toListView(Object value) {
        if (value instanceof List) {
            return (List)value;
        }
        if (value != null && value.getClass().isArray()) {
            int length = Array.getLength(value);
            ArrayList<Object> result = new ArrayList<Object>(length);
            for (int i = 0; i < length; ++i) {
                result.add(Array.get(value, i));
            }
            return result;
        }
        return null;
    }

    private static Number asNumber(Object value) {
        if (value instanceof Number) {
            return (Number)value;
        }
        if (value instanceof String) {
            try {
                return new BigDecimal((String)value);
            }
            catch (NumberFormatException ignored) {
                return null;
            }
        }
        return null;
    }

    private static BigDecimal toBigDecimal(Object value) {
        if (value instanceof BigDecimal) {
            return (BigDecimal)value;
        }
        if (value instanceof BigInteger) {
            return new BigDecimal((BigInteger)value);
        }
        if (value instanceof Number) {
            if (value instanceof Double || value instanceof Float) {
                return BigDecimal.valueOf(((Number)value).doubleValue());
            }
            return BigDecimal.valueOf(((Number)value).longValue());
        }
        if (value instanceof String) {
            try {
                return new BigDecimal((String)value);
            }
            catch (NumberFormatException ignored) {
                return null;
            }
        }
        return null;
    }

    private static boolean isIntegralNumber(Object value) {
        if (value instanceof Byte || value instanceof Short || value instanceof Integer || value instanceof Long || value instanceof BigInteger) {
            return true;
        }
        if (value instanceof BigDecimal) {
            BigDecimal bd = ((BigDecimal)value).stripTrailingZeros();
            return bd.scale() <= 0;
        }
        if (value instanceof Float || value instanceof Double) {
            double dbl = ((Number)value).doubleValue();
            return Math.rint(dbl) == dbl;
        }
        return false;
    }

    private static LookupResult resolveValuesForPath(Object current, String[] path, int position) {
        LookupResult result = new LookupResult();
        if (position >= path.length) {
            result.pathExists = true;
            if (current instanceof List) {
                for (Object element : (List)current) {
                    result.values.add(element);
                }
                return result;
            }
            result.values.add(current);
            return result;
        }
        if (current instanceof Map) {
            Map map = (Map)current;
            String key = path[position];
            if (!map.containsKey(key)) {
                return result;
            }
            Object next = map.get(key);
            if (next == null) {
                if (position == path.length - 1) {
                    result.pathExists = true;
                    result.values.add(null);
                }
                return result;
            }
            LookupResult sub = QueryHelper.resolveValuesForPath(next, path, position + 1);
            result.pathExists = sub.pathExists;
            result.values.addAll(sub.values);
            return result;
        }
        if (current instanceof List) {
            List list = (List)current;
            String key = path[position];
            if (QueryHelper.isInteger(key)) {
                int index = Integer.parseInt(key);
                if (index < 0 || index >= list.size()) {
                    return result;
                }
                LookupResult sub = QueryHelper.resolveValuesForPath(list.get(index), path, position + 1);
                result.pathExists = sub.pathExists;
                result.values.addAll(sub.values);
                return result;
            }
            boolean anyExists = false;
            for (Object element : list) {
                LookupResult sub = QueryHelper.resolveValuesForPath(element, path, position);
                if (sub.pathExists) {
                    anyExists = true;
                }
                result.values.addAll(sub.values);
            }
            result.pathExists = anyExists;
            return result;
        }
        return result;
    }

    private static boolean isInteger(String value) {
        if (value == null || value.isEmpty()) {
            return false;
        }
        for (int i = 0; i < value.length(); ++i) {
            char ch = value.charAt(i);
            if (!(i == 0 && ch == '-' ? value.length() == 1 : !Character.isDigit(ch))) continue;
            return false;
        }
        return true;
    }

    private static boolean compareValues(Object left, Object right, Collator coll) {
        Object normalizedLeft = QueryHelper.normalizeId(left);
        Object normalizedRight = QueryHelper.normalizeId(right);
        if (normalizedLeft == null || normalizedRight == null) {
            return normalizedLeft == null && normalizedRight == null;
        }
        if (normalizedLeft instanceof String && normalizedRight instanceof String && coll != null) {
            return coll.compare((String)normalizedLeft, (String)normalizedRight) == 0;
        }
        if (normalizedLeft instanceof Number && normalizedRight instanceof Number) {
            return Double.compare(((Number)normalizedLeft).doubleValue(), ((Number)normalizedRight).doubleValue()) == 0;
        }
        return normalizedLeft.equals(normalizedRight);
    }

    private static Object normalizeId(Object value) {
        if (value instanceof MorphiumId || value instanceof ObjectId) {
            return value == null ? null : value.toString();
        }
        return value;
    }

    private static boolean compareLessThan(Object left, Object right, int offset, Collator coll) {
        if (left == null || right == null) {
            return false;
        }
        if (left instanceof String && right instanceof String && coll != null) {
            return coll.compare((String)left, (String)right) <= offset;
        }
        if (left instanceof Number && right instanceof Number) {
            return Double.compare(((Number)left).doubleValue(), ((Number)right).doubleValue()) <= offset;
        }
        if (left instanceof Comparable && right instanceof Comparable) {
            try {
                return ((Comparable)left).compareTo(right) <= offset;
            }
            catch (ClassCastException ignored) {
                return false;
            }
        }
        return false;
    }

    private static boolean compareGreaterThan(Object left, Object right, int offset, Collator coll) {
        if (left == null || right == null) {
            return false;
        }
        if (left instanceof String && right instanceof String && coll != null) {
            return coll.compare((String)left, (String)right) >= offset;
        }
        if (left instanceof Number && right instanceof Number) {
            return Double.compare(((Number)left).doubleValue(), ((Number)right).doubleValue()) >= offset;
        }
        if (left instanceof Comparable && right instanceof Comparable) {
            try {
                return ((Comparable)left).compareTo(right) >= offset;
            }
            catch (ClassCastException ignored) {
                return false;
            }
        }
        return false;
    }

    private static Pattern buildRegexPattern(Map<String, Object> commandMap, int baseFlags) {
        Object regularExpression;
        int flags = baseFlags;
        Object regexObject = commandMap.get("$regex");
        if (regexObject instanceof Pattern) {
            return (Pattern)regexObject;
        }
        String pattern = null;
        if (regexObject instanceof String) {
            pattern = (String)regexObject;
        }
        if ((regularExpression = commandMap.get("$regularExpression")) instanceof Map) {
            Object opt;
            Map regexMap = (Map)regularExpression;
            if (regexMap.get("pattern") instanceof String) {
                pattern = (String)regexMap.get("pattern");
            }
            if ((opt = regexMap.get("options")) instanceof String) {
                flags = QueryHelper.applyRegexOptions((String)opt, flags);
            }
        }
        if (pattern == null) {
            return null;
        }
        return Pattern.compile(pattern, flags);
    }

    private static int applyRegexOptions(String options, int flags) {
        String opt = options.toLowerCase(Locale.ROOT);
        if (opt.contains("i")) {
            flags |= 2;
        }
        if (opt.contains("m")) {
            flags |= 8;
        }
        if (opt.contains("s")) {
            flags |= 0x20;
        }
        if (opt.contains("x")) {
            flags |= 4;
        }
        return flags;
    }

    private static boolean matchesType(Object value, MongoType type) {
        if (value == null) {
            return type.equals((Object)MongoType.NULL);
        }
        if (value instanceof byte[]) {
            return type.equals((Object)MongoType.BINARY_DATA);
        }
        if (value instanceof List || value.getClass().isArray()) {
            return type.equals((Object)MongoType.ARRAY);
        }
        if (value instanceof Pattern) {
            return type.equals((Object)MongoType.REGEX);
        }
        if (value instanceof Map) {
            return type.equals((Object)MongoType.OBJECT);
        }
        if (value instanceof Double || value instanceof Float) {
            return type.equals((Object)MongoType.DOUBLE);
        }
        if (value instanceof Date) {
            return type.equals((Object)MongoType.DATE);
        }
        if (value instanceof MorphiumId || value instanceof ObjectId) {
            return type.equals((Object)MongoType.OBJECT_ID);
        }
        if (value instanceof BigDecimal) {
            return type.equals((Object)MongoType.DECIMAL);
        }
        if (value instanceof String) {
            return type.equals((Object)MongoType.STRING);
        }
        if (value instanceof Boolean) {
            return type.equals((Object)MongoType.BOOLEAN);
        }
        if (value instanceof Long) {
            return type.equals((Object)MongoType.LONG);
        }
        if (value instanceof Integer || value instanceof Short || value instanceof Byte) {
            return type.equals((Object)MongoType.INTEGER);
        }
        return false;
    }

    private static boolean fieldExists(Map<String, Object> document, String fieldPath) {
        if (document == null || fieldPath == null) {
            return false;
        }
        if (!fieldPath.contains(".")) {
            return document.containsKey(fieldPath);
        }
        String[] parts = fieldPath.split("\\.");
        return QueryHelper.fieldExists(document, parts, 0);
    }

    private static boolean fieldExists(Object current, String[] parts, int idx) {
        if (current == null) {
            return false;
        }
        if (idx >= parts.length) {
            return true;
        }
        String part = parts[idx];
        if (current instanceof Map) {
            Map map = (Map)current;
            if (!map.containsKey(part)) {
                return false;
            }
            if (idx + 1 >= parts.length) {
                return true;
            }
            return QueryHelper.fieldExists(map.get(part), parts, idx + 1);
        }
        if (current instanceof List) {
            List list = (List)current;
            if (part.matches("\\d+")) {
                int pos = Integer.parseInt(part);
                if (pos < 0 || pos >= list.size()) {
                    return false;
                }
                if (idx + 1 >= parts.length) {
                    return true;
                }
                return QueryHelper.fieldExists(list.get(pos), parts, idx + 1);
            }
            for (Object entry : list) {
                if (!QueryHelper.fieldExists(entry, parts, idx)) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    private static String convertSnakeToCamelCase(String fieldPath) {
        if (!fieldPath.contains("_")) {
            return fieldPath;
        }
        String[] parts = fieldPath.split("\\.");
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < parts.length; ++i) {
            String part;
            if (i > 0) {
                result.append(".");
            }
            if ((part = parts[i]).matches("\\d+")) {
                result.append(part);
                continue;
            }
            String[] words = part.split("_");
            result.append(words[0]);
            for (int j = 1; j < words.length; ++j) {
                if (words[j].length() <= 0) continue;
                result.append(Character.toUpperCase(words[j].charAt(0)));
                if (words[j].length() <= 1) continue;
                result.append(words[j].substring(1));
            }
        }
        return result.toString();
    }

    private static String convertCamelToSnakeCase(String fieldPath) {
        String[] parts = fieldPath.split("\\.");
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < parts.length; ++i) {
            String part;
            if (i > 0) {
                result.append(".");
            }
            if ((part = parts[i]).matches("\\d+")) {
                result.append(part);
                continue;
            }
            StringBuilder converted = new StringBuilder();
            for (int j = 0; j < part.length(); ++j) {
                char c = part.charAt(j);
                if (Character.isUpperCase(c)) {
                    if (j > 0) {
                        converted.append("_");
                    }
                    converted.append(Character.toLowerCase(c));
                    continue;
                }
                converted.append(c);
            }
            result.append(converted.toString());
        }
        return result.toString();
    }

    private static boolean runWhere(Map<String, Object> query, Map<String, Object> toCheck) {
        System.setProperty("polyglot.engine.WarnInterpreterOnly", "false");
        ScriptEngineManager mgr = new ScriptEngineManager();
        ScriptEngine engine = mgr.getEngineByExtension("js");
        if (engine != null) {
            engine.getContext().setAttribute("obj", toCheck, 100);
            for (String k : toCheck.keySet()) {
                engine.getContext().setAttribute(k, toCheck.get(k), 100);
            }
            try {
                Object result = engine.eval((String)query.get("$where"));
                return result.equals(Boolean.TRUE);
            }
            catch (ScriptException e) {
                throw new RuntimeException("Scripting error", e);
            }
        }
        log.error("Could not create javscript engine!");
        return false;
    }

    public static Collator getCollator(Map<String, Object> collation) {
        Locale locale = Locale.ROOT;
        if (collation == null) {
            return null;
        }
        if (collation.containsKey("locale") && !"simple".equals(collation.get("locale"))) {
            locale = Locale.forLanguageTag((String)collation.get("locale"));
        }
        Collator coll = Collator.getInstance(locale);
        if (collation.containsKey("caseFirst") && Collation.CaseFirst.UPPER.getMongoText().equals(collation.get("caseFirst"))) {
            try {
                coll = new RuleBasedCollator(((RuleBasedCollator)coll).getRules() + ",A<a,B<b,C<c,D<d,E<e,F<f,G<g,H<h,I<i,J<j,K<k,L<l,M<m,N<n,O<o,P<p,Q<q,R<r,S<s,T<t,U<u,V<v,W<w,X<x,Y<y,Z<z,\u00d6<\u00f6,\u00dc<\u00fc,\u00c4<\u00e4");
            }
            catch (ParseException e) {
                throw new RuntimeException(e);
            }
        }
        if (collation.containsKey("strength")) {
            coll.setStrength((Integer)collation.get("strength"));
        }
        return coll;
    }

    private static final class LookupResult {
        boolean pathExists;
        final List<Object> values = new ArrayList<Object>();

        private LookupResult() {
        }
    }

    private static final class PointGeometry
    implements Geometry {
        private final double x;
        private final double y;

        PointGeometry(List<?> coordinates) {
            this.x = QueryHelper.toDouble(coordinates, 0);
            this.y = QueryHelper.toDouble(coordinates, 1);
        }

        @Override
        public boolean intersects(Geometry other) {
            if (other instanceof PointGeometry) {
                PointGeometry p = (PointGeometry)other;
                return Double.compare(this.x, p.x) == 0 && Double.compare(this.y, p.y) == 0;
            }
            if (other instanceof LineStringGeometry) {
                return ((LineStringGeometry)other).contains(this.x, this.y);
            }
            if (other instanceof PolygonGeometry) {
                return ((PolygonGeometry)other).contains(this.x, this.y);
            }
            if (other instanceof MultiGeometry) {
                return ((MultiGeometry)other).intersects(this);
            }
            return false;
        }
    }

    private static final class LineStringGeometry
    implements Geometry {
        private final double[] xs;
        private final double[] ys;

        LineStringGeometry(List<?> coordinates) {
            int len = coordinates.size();
            this.xs = new double[len];
            this.ys = new double[len];
            for (int i = 0; i < len; ++i) {
                List<?> point = QueryHelper.toListView(coordinates.get(i));
                this.xs[i] = QueryHelper.toDouble(point, 0);
                this.ys[i] = QueryHelper.toDouble(point, 1);
            }
        }

        boolean contains(double px, double py) {
            for (int i = 0; i < this.xs.length - 1; ++i) {
                double x1 = this.xs[i];
                double y1 = this.ys[i];
                double x2 = this.xs[i + 1];
                double y2 = this.ys[i + 1];
                if (!QueryHelper.pointOnSegment(px, py, x1, y1, x2, y2)) continue;
                return true;
            }
            return false;
        }

        boolean intersectsLine(LineStringGeometry other) {
            for (int i = 0; i < this.xs.length - 1; ++i) {
                double x1 = this.xs[i];
                double y1 = this.ys[i];
                double x2 = this.xs[i + 1];
                double y2 = this.ys[i + 1];
                for (int j = 0; j < other.xs.length - 1; ++j) {
                    double x3 = other.xs[j];
                    double y3 = other.ys[j];
                    double x4 = other.xs[j + 1];
                    double y4 = other.ys[j + 1];
                    if (!QueryHelper.segmentsIntersect(x1, y1, x2, y2, x3, y3, x4, y4)) continue;
                    return true;
                }
            }
            return false;
        }

        @Override
        public boolean intersects(Geometry other) {
            if (other instanceof PointGeometry) {
                PointGeometry p = (PointGeometry)other;
                return this.contains(p.x, p.y);
            }
            if (other instanceof LineStringGeometry) {
                LineStringGeometry line = (LineStringGeometry)other;
                return this.intersectsLine(line) || line.intersectsLine(this);
            }
            if (other instanceof PolygonGeometry) {
                PolygonGeometry polygon = (PolygonGeometry)other;
                if (polygon.contains(this.xs[0], this.ys[0])) {
                    return true;
                }
                return polygon.intersectsLine(this);
            }
            if (other instanceof MultiGeometry) {
                return other.intersects(this);
            }
            return false;
        }
    }

    private static final class PolygonGeometry
    implements Geometry {
        private final List<LineStringGeometry> rings = new ArrayList<LineStringGeometry>();

        PolygonGeometry(List<?> coordinates) {
            for (Object ringObj : coordinates) {
                List<?> ring = QueryHelper.toListView(ringObj);
                if (ring == null || ring.size() < 4) continue;
                this.rings.add(new LineStringGeometry(ring));
            }
        }

        boolean contains(double px, double py) {
            if (this.rings.isEmpty()) {
                return false;
            }
            if (!QueryHelper.pointInPolygon(px, py, this.rings.get(0))) {
                return false;
            }
            for (int i = 1; i < this.rings.size(); ++i) {
                if (!QueryHelper.pointInPolygon(px, py, this.rings.get(i))) continue;
                return false;
            }
            return true;
        }

        boolean intersectsLine(LineStringGeometry line) {
            if (this.contains(line.xs[0], line.ys[0])) {
                return true;
            }
            for (LineStringGeometry ring : this.rings) {
                if (!ring.intersectsLine(line)) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean intersects(Geometry other) {
            if (other instanceof PointGeometry) {
                PointGeometry point = (PointGeometry)other;
                return this.contains(point.x, point.y);
            }
            if (other instanceof LineStringGeometry) {
                return this.intersectsLine((LineStringGeometry)other);
            }
            if (other instanceof PolygonGeometry) {
                PolygonGeometry polygon = (PolygonGeometry)other;
                if (this.contains(polygon.rings.get((int)0).xs[0], polygon.rings.get((int)0).ys[0]) || polygon.contains(this.rings.get((int)0).xs[0], this.rings.get((int)0).ys[0])) {
                    return true;
                }
                for (LineStringGeometry ring : this.rings) {
                    if (!polygon.intersectsLine(ring)) continue;
                    return true;
                }
                for (LineStringGeometry otherRing : polygon.rings) {
                    if (!this.intersectsLine(otherRing)) continue;
                    return true;
                }
                return false;
            }
            if (other instanceof MultiGeometry) {
                return other.intersects(this);
            }
            return false;
        }
    }

    private static final class MultiGeometry
    implements Geometry {
        private final List<Geometry> components = new ArrayList<Geometry>();

        MultiGeometry(List<?> coordinates, String componentType) {
            for (Object component : coordinates) {
                Geometry geometry = QueryHelper.toGeometry(componentType, QueryHelper.toListView(component));
                if (geometry == null) continue;
                this.components.add(geometry);
            }
        }

        @Override
        public boolean intersects(Geometry other) {
            for (Geometry component : this.components) {
                if (!component.intersects(other)) continue;
                return true;
            }
            return false;
        }
    }

    private static interface Geometry {
        public boolean intersects(Geometry var1);
    }
}

