/*
 * Decompiled with CFR 0.152.
 */
package de.caluga.morphium.driver.inmem;

import de.caluga.morphium.Collation;
import de.caluga.morphium.IndexDescription;
import de.caluga.morphium.Morphium;
import de.caluga.morphium.ObjectMapperImpl;
import de.caluga.morphium.Utils;
import de.caluga.morphium.UtilsMap;
import de.caluga.morphium.aggregation.Aggregator;
import de.caluga.morphium.aggregation.Expr;
import de.caluga.morphium.annotations.Driver;
import de.caluga.morphium.driver.Doc;
import de.caluga.morphium.driver.DriverTailableIterationCallback;
import de.caluga.morphium.driver.FunctionNotSupportedException;
import de.caluga.morphium.driver.MorphiumCursor;
import de.caluga.morphium.driver.MorphiumDriver;
import de.caluga.morphium.driver.MorphiumDriverException;
import de.caluga.morphium.driver.MorphiumId;
import de.caluga.morphium.driver.MorphiumTransactionContext;
import de.caluga.morphium.driver.ReadPreference;
import de.caluga.morphium.driver.SingleBatchCursor;
import de.caluga.morphium.driver.WriteConcern;
import de.caluga.morphium.driver.bulk.BulkRequest;
import de.caluga.morphium.driver.bulk.BulkRequestContext;
import de.caluga.morphium.driver.bulk.DeleteBulkRequest;
import de.caluga.morphium.driver.bulk.InsertBulkRequest;
import de.caluga.morphium.driver.bulk.UpdateBulkRequest;
import de.caluga.morphium.driver.commands.AbortTransactionCommand;
import de.caluga.morphium.driver.commands.AggregateMongoCommand;
import de.caluga.morphium.driver.commands.ClearCollectionCommand;
import de.caluga.morphium.driver.commands.CollStatsCommand;
import de.caluga.morphium.driver.commands.CommitTransactionCommand;
import de.caluga.morphium.driver.commands.CountMongoCommand;
import de.caluga.morphium.driver.commands.CreateCommand;
import de.caluga.morphium.driver.commands.CreateIndexesCommand;
import de.caluga.morphium.driver.commands.CurrentOpCommand;
import de.caluga.morphium.driver.commands.DbStatsCommand;
import de.caluga.morphium.driver.commands.DeleteMongoCommand;
import de.caluga.morphium.driver.commands.DistinctMongoCommand;
import de.caluga.morphium.driver.commands.DropDatabaseMongoCommand;
import de.caluga.morphium.driver.commands.DropMongoCommand;
import de.caluga.morphium.driver.commands.ExplainCommand;
import de.caluga.morphium.driver.commands.FindAndModifyMongoCommand;
import de.caluga.morphium.driver.commands.FindCommand;
import de.caluga.morphium.driver.commands.GenericCommand;
import de.caluga.morphium.driver.commands.GetMoreMongoCommand;
import de.caluga.morphium.driver.commands.HelloCommand;
import de.caluga.morphium.driver.commands.InsertMongoCommand;
import de.caluga.morphium.driver.commands.KillCursorsCommand;
import de.caluga.morphium.driver.commands.ListCollectionsCommand;
import de.caluga.morphium.driver.commands.ListDatabasesCommand;
import de.caluga.morphium.driver.commands.ListIndexesCommand;
import de.caluga.morphium.driver.commands.MapReduceCommand;
import de.caluga.morphium.driver.commands.MongoCommand;
import de.caluga.morphium.driver.commands.RenameCollectionCommand;
import de.caluga.morphium.driver.commands.ReplicastStatusCommand;
import de.caluga.morphium.driver.commands.ShutdownCommand;
import de.caluga.morphium.driver.commands.StepDownCommand;
import de.caluga.morphium.driver.commands.StoreMongoCommand;
import de.caluga.morphium.driver.commands.UpdateMongoCommand;
import de.caluga.morphium.driver.commands.WatchCommand;
import de.caluga.morphium.driver.commands.auth.CreateRoleAdminCommand;
import de.caluga.morphium.driver.commands.auth.CreateUserAdminCommand;
import de.caluga.morphium.driver.commands.auth.SaslAuthCommand;
import de.caluga.morphium.driver.inmem.InMemAggregator;
import de.caluga.morphium.driver.inmem.InMemDumpContainer;
import de.caluga.morphium.driver.inmem.InMemTransactionContext;
import de.caluga.morphium.driver.inmem.QueryHelper;
import de.caluga.morphium.driver.wire.AtomicDecimal;
import de.caluga.morphium.driver.wire.HelloResult;
import de.caluga.morphium.driver.wire.MongoConnection;
import de.caluga.morphium.driver.wireprotocol.OpMsg;
import de.caluga.morphium.objectmapping.MorphiumObjectMapper;
import de.caluga.morphium.objectmapping.MorphiumTypeMapper;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.lang.invoke.LambdaMetafactory;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.Collator;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.Date;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.Vector;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Predicate;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.net.ssl.SSLContext;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import org.bson.types.ObjectId;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;
import org.openjdk.jol.vm.VM;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Driver(name="InMemDriver", description="in memory driver for simple test")
public class InMemoryDriver
implements MorphiumDriver,
MongoConnection {
    private final Logger log = LoggerFactory.getLogger(InMemoryDriver.class);
    public static final String driverName = "InMemDriver";
    private final Map<String, Map<String, List<Map<String, Object>>>> database = new ConcurrentHashMap<String, Map<String, List<Map<String, Object>>>>();
    private final Map<String, ReadWriteLock> collectionLocks = new ConcurrentHashMap<String, ReadWriteLock>();
    private int idleSleepTime = 20;
    private final Map<String, Map<String, List<Map<String, Object>>>> indicesByDbCollection = new ConcurrentHashMap<String, Map<String, List<Map<String, Object>>>>();
    private final Map<String, Map<String, Map<String, Map<Integer, List<Map<String, Object>>>>>> indexDataByDBCollection = new ConcurrentHashMap<String, Map<String, Map<String, Map<Integer, List<Map<String, Object>>>>>>();
    private final ThreadLocal<InMemTransactionContext> currentTransaction = new ThreadLocal();
    private final AtomicLong txn = new AtomicLong();
    private final AtomicLong changeStreamSequence = new AtomicLong();
    private final Map<String, CopyOnWriteArrayList<ChangeStreamSubscription>> changeStreamSubscribers = new ConcurrentHashMap<String, CopyOnWriteArrayList<ChangeStreamSubscription>>();
    private final ConcurrentLinkedDeque<ChangeStreamEventInfo> changeStreamHistory = new ConcurrentLinkedDeque();
    private final int CHANGE_STREAM_HISTORY_LIMIT = 1024;
    private final Map<String, Map<String, Map<String, Integer>>> cappedCollections = new ConcurrentHashMap<String, Map<String, Map<String, Integer>>>();
    private final List<Object> monitors = new CopyOnWriteArrayList<Object>();
    private final BlockingQueue<Runnable> eventQueue = new LinkedBlockingDeque<Runnable>();
    private final List<Map<String, Object>> commandResults = new Vector<Map<String, Object>>();
    private final Map<String, Class<? extends MongoCommand>> commandsCache = new HashMap<String, Class<? extends MongoCommand>>();
    private final AtomicInteger commandNumber = new AtomicInteger(0);
    private final AtomicInteger connectionId = new AtomicInteger(0);
    private final Map<MorphiumDriver.DriverStatsKey, AtomicDecimal> stats = new ConcurrentHashMap<MorphiumDriver.DriverStatsKey, AtomicDecimal>();
    private final Map<Long, FindCommand> cursors = new ConcurrentHashMap<Long, FindCommand>();
    private final Map<Long, InMemoryCursor> iterationCursors = new ConcurrentHashMap<Long, InMemoryCursor>();
    private final Map<Long, CursorResultBuffer> activeQueryCursors = new ConcurrentHashMap<Long, CursorResultBuffer>();
    private final AtomicLong cursorIdSequence = new AtomicLong(1L);
    private ScheduledThreadPoolExecutor exec = new ScheduledThreadPoolExecutor(10);
    private final ExecutorService eventDispatcher = Executors.newCachedThreadPool(Thread.ofVirtual().name("event-dispatcher-", 0L).factory());
    private boolean running = true;
    private int expireCheck = 10000;
    private ScheduledFuture<?> expire;
    private String replicaSetName;
    private final AtomicInteger activeConnections = new AtomicInteger(0);

    @Override
    public int getLocalThreshold() {
        return 0;
    }

    @Override
    public void setLocalThreshold(int threshold) {
    }

    public Map<String, List<Map<String, Object>>> getDatabase(String dbn) {
        return this.database.get(dbn);
    }

    @Override
    public <T, R> Aggregator<T, R> createAggregator(Morphium morphium, Class<? extends T> type, Class<? extends R> resultType) {
        return new InMemAggregator<T, R>(morphium, type, resultType);
    }

    public void setDatabase(String dbn, Map<String, List<Map<String, Object>>> db) {
        if (db != null) {
            this.database.put(dbn, db);
        }
    }

    public void restore(InputStream in) throws IOException, ParseException {
        GZIPInputStream gzin = new GZIPInputStream(in);
        BufferedInputStream bin = new BufferedInputStream(gzin);
        BufferedReader br = new BufferedReader(new InputStreamReader(bin));
        String l = null;
        StringBuilder b = new StringBuilder();
        while ((l = br.readLine()) != null) {
            b.append(l);
        }
        br.close();
        ObjectMapperImpl mapper = new ObjectMapperImpl();
        MorphiumTypeMapper<ObjectId> typeMapper = this.getObjectIdTypeMapper();
        mapper.registerCustomMapperFor(ObjectId.class, typeMapper);
        this.log.info("Read in json: " + String.valueOf(b));
        InMemDumpContainer cnt = mapper.deserialize(InMemDumpContainer.class, b.toString());
        this.log.info("Restoring DB " + cnt.getDb() + " dump from " + String.valueOf(new Date(cnt.getCreated())));
        this.setDatabase(cnt.getDb(), cnt.getData());
    }

    public void restoreFromFile(File f) throws IOException, ParseException {
        this.restore(new FileInputStream(f));
    }

    public void dumpToFile(Morphium m, String db, File f) throws IOException {
        this.dump(m, db, new FileOutputStream(f));
    }

    public void dump(Morphium m, String db, OutputStream out) throws IOException {
        MorphiumObjectMapper mapper = m.getMapper();
        MorphiumTypeMapper<ObjectId> typeMapper = this.getObjectIdTypeMapper();
        mapper.registerCustomMapperFor(ObjectId.class, typeMapper);
        GZIPOutputStream gzip = new GZIPOutputStream(out);
        InMemDumpContainer d = new InMemDumpContainer();
        d.setCreated(System.currentTimeMillis());
        d.setData(this.getDatabase(db));
        d.setDb(db);
        Map<String, Object> ser = mapper.serialize(d);
        OutputStreamWriter wr = new OutputStreamWriter(gzip);
        Utils.writeJson(ser, wr);
        wr.flush();
        gzip.finish();
        gzip.flush();
        out.flush();
        gzip.close();
    }

    private MorphiumTypeMapper<ObjectId> getObjectIdTypeMapper() {
        return new MorphiumTypeMapper<ObjectId>(this){

            @Override
            public Object marshall(ObjectId o) {
                ConcurrentHashMap<String, String> m = new ConcurrentHashMap<String, String>();
                m.put("value", o.toHexString());
                m.put("class_name", o.getClass().getName());
                return m;
            }

            @Override
            public ObjectId unmarshall(Object d) {
                return new ObjectId(((Map)d).get("value").toString());
            }
        };
    }

    @Override
    public List<String> listDatabases() {
        return new ArrayList<String>(this.database.keySet());
    }

    @Override
    public List<String> listCollections(String db, String pattern) {
        HashSet<String> collections = new HashSet<String>();
        if (db.equals("1")) {
            for (String k : this.database.keySet()) {
                collections.addAll(this.database.get(k).keySet());
            }
        } else if (this.database.containsKey(db)) {
            collections.addAll(this.database.get(db).keySet());
        } else {
            return new ArrayList<String>();
        }
        ArrayList<String> ret = new ArrayList<String>();
        if (pattern == null) {
            ret.addAll(collections);
        } else {
            for (String col : collections) {
                if (!col.matches(pattern)) continue;
                ret.add(col);
            }
        }
        return ret;
    }

    @Override
    public String getReplicaSetName() {
        return this.replicaSetName;
    }

    @Override
    public void setReplicaSetName(String replicaSetName) {
        this.replicaSetName = replicaSetName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetData() {
        this.log.info("resetData() called - clearing all data. Database had {} databases", (Object)this.database.size());
        this.database.clear();
        this.indexDataByDBCollection.clear();
        this.indicesByDbCollection.clear();
        this.cappedCollections.clear();
        Iterator<Object> iterator = this.monitors.iterator();
        while (iterator.hasNext()) {
            Object o;
            Object object = o = iterator.next();
            synchronized (object) {
                o.notifyAll();
            }
        }
        this.monitors.clear();
        this.changeStreamSubscribers.clear();
        this.changeStreamHistory.clear();
        this.changeStreamSequence.set(0L);
        this.eventQueue.clear();
        this.cursors.clear();
        this.commandResults.clear();
        this.currentTransaction.remove();
        this.log.info("resetData() completed");
    }

    public void setCredentials(String db, String login, char[] pwd) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void watch(WatchCommand settings) throws MorphiumDriverException {
        if (settings == null || settings.getCb() == null) {
            return;
        }
        String db = settings.getDb();
        if (db == null || db.isBlank()) {
            db = "admin";
        }
        String collection = settings.getColl();
        Object monitor = new Object();
        this.monitors.add(monitor);
        ChangeStreamSubscription subscription = new ChangeStreamSubscription(db, collection, settings.getCb(), settings.getPipeline(), settings.getFullDocument() == null ? WatchCommand.FullDocumentEnum.defaultValue : settings.getFullDocument(), settings.getFullDocumentBeforeChange() == null ? WatchCommand.FullDocumentBeforeChangeEnum.off : settings.getFullDocumentBeforeChange(), Boolean.TRUE.equals(settings.getShowExpandedEvents()), monitor);
        this.registerSubscription(subscription);
        try {
            Long startingToken;
            Long resumeAfterToken = InMemoryDriver.extractResumeToken(settings.getResumeAfter());
            Long startAfterToken = resumeAfterToken == null ? InMemoryDriver.extractResumeToken(settings.getStartAfter()) : null;
            Long l = startingToken = resumeAfterToken != null ? resumeAfterToken : startAfterToken;
            if (startingToken != null) {
                this.replayHistory(subscription, startingToken);
            }
            if (!subscription.isActive()) {
                return;
            }
            Object object = monitor;
            synchronized (object) {
                while (subscription.isActive()) {
                    Integer maxTime = settings.getMaxTimeMS();
                    if (maxTime != null && maxTime > 0) {
                        monitor.wait(maxTime.intValue());
                        continue;
                    }
                    monitor.wait();
                }
            }
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
        }
        finally {
            this.unregisterSubscription(subscription);
            this.monitors.remove(monitor);
        }
    }

    @Override
    public List<Map<String, Object>> readAnswerFor(int queryId) throws MorphiumDriverException {
        this.stats.get((Object)MorphiumDriver.DriverStatsKey.REPLY_PROCESSED).incrementAndGet();
        Map<String, Object> data = this.commandResults.remove(0);
        if (data.containsKey("results")) {
            return (List)data.get("results");
        }
        if (data.containsKey("cursor")) {
            Map cursor = (Map)data.get("cursor");
            if (cursor.containsKey("firstBatch")) {
                return (List)cursor.get("firstBatch");
            }
            if (cursor.containsKey("nextBatch")) {
                return (List)cursor.get("nextBatch");
            }
        }
        return null;
    }

    @Override
    public MorphiumCursor getAnswerFor(int queryId, int batchsize) throws MorphiumDriverException {
        this.stats.get((Object)MorphiumDriver.DriverStatsKey.REPLY_PROCESSED).incrementAndGet();
        Map<String, Object> data = this.commandResults.remove(0);
        if (data.containsKey("cursor")) {
            Map cursorDoc = (Map)data.get("cursor");
            if (cursorDoc.containsKey("firstBatch")) {
                int effectiveBatchSize;
                ArrayList<Map<String, Object>> firstBatch = cursorDoc.get("firstBatch") != null ? new ArrayList<Map<String, Object>>((List)cursorDoc.get("firstBatch")) : new ArrayList();
                long cursorId = cursorDoc.get("id") instanceof Number ? ((Number)cursorDoc.get("id")).longValue() : 0L;
                String namespace = cursorDoc.get("ns") instanceof String ? (String)cursorDoc.get("ns") : "";
                int n = effectiveBatchSize = batchsize > 0 ? batchsize : firstBatch.size();
                if (cursorId != 0L) {
                    CursorResultBuffer buffer = this.activeQueryCursors.get(cursorId);
                    if (effectiveBatchSize <= 0 && buffer != null && buffer.defaultBatchSize > 0) {
                        effectiveBatchSize = buffer.defaultBatchSize;
                    }
                }
                if (effectiveBatchSize <= 0) {
                    effectiveBatchSize = firstBatch.size() > 0 ? firstBatch.size() : 101;
                }
                return new InMemoryFindCursor(cursorId, namespace, firstBatch, effectiveBatchSize);
            }
            if (cursorDoc.containsKey("nextBatch")) {
                List nextBatch = cursorDoc.get("nextBatch") != null ? (List)cursorDoc.get("nextBatch") : List.of();
                return new SingleBatchCursor(nextBatch);
            }
        }
        List<Map<String, Object>> batch = new ArrayList<Map<String, Object>>();
        if (data.containsKey("results")) {
            batch = (List)data.get("results");
        }
        return new SingleBatchCursor(batch);
    }

    @Override
    public List<Map<String, Object>> readAnswerFor(MorphiumCursor crs) throws MorphiumDriverException {
        return crs.getBatch();
    }

    @Override
    public int sendCommand(MongoCommand cmd) throws MorphiumDriverException {
        this.stats.get((Object)MorphiumDriver.DriverStatsKey.MSG_SENT).incrementAndGet();
        if (cmd.asMap().get("$db") == null) {
            throw new IllegalArgumentException("DB cannot be null");
        }
        try {
            Method method = this.getClass().getDeclaredMethod("runCommand", cmd.getClass());
            Object o = method.invoke((Object)this, cmd);
            this.stats.get((Object)MorphiumDriver.DriverStatsKey.REPLY_RECEIVED);
            if (o instanceof Integer) {
                return (Integer)o;
            }
        }
        catch (NoSuchMethodException nsmex) {
            throw new RuntimeException(nsmex);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
        return 0;
    }

    public int runCommand(CreateUserAdminCommand cmd) {
        return 0;
    }

    public int runCommand(CreateRoleAdminCommand cmd) {
        return 0;
    }

    public int runCommand(SaslAuthCommand cmd) {
        return 0;
    }

    public int runCommand(ExplainCommand cmd) {
        int ret = this.commandNumber.incrementAndGet();
        Doc winningPlan = Doc.of("stage", "COLLSCAN", "direction", "forward");
        HashMap<String, Object> queryPlanner = new HashMap<String, Object>();
        queryPlanner.put("namespace", cmd.getDb() + "." + cmd.getColl());
        queryPlanner.put("indexFilterSet", false);
        Doc parsedQuery = Doc.of();
        try {
            Object filter;
            Object findCommand = cmd.getCommand().get("find");
            if (findCommand instanceof Map && (filter = ((Map)findCommand).get("filter")) != null) {
                parsedQuery = filter;
            }
        }
        catch (Exception e) {
            parsedQuery = Doc.of();
        }
        queryPlanner.put("parsedQuery", parsedQuery);
        queryPlanner.put("queryHash", "InMemoryDriver");
        queryPlanner.put("planCacheKey", "InMemoryDriver");
        queryPlanner.put("maxIndexedOrSolutionsReached", false);
        queryPlanner.put("maxIndexedAndSolutionsReached", false);
        queryPlanner.put("maxScansToExplodeReached", false);
        queryPlanner.put("winningPlan", winningPlan);
        queryPlanner.put("rejectedPlans", new ArrayList());
        Doc explainResult = Doc.of("explainVersion", "1", "queryPlanner", queryPlanner, "ok", (Object)1.0);
        this.commandResults.add(this.prepareResult(explainResult));
        return ret;
    }

    public int runCommand(GenericCommand cmd) {
        Map<String, Object> cmdMap = cmd.asMap();
        String commandName = (String)cmdMap.keySet().stream().findFirst().get();
        Class<? extends MongoCommand> commandClass = this.commandsCache.get(commandName);
        if (commandName.equals("aggreagate") && cmdMap.containsKey("pipeline") && ((Map)((List)cmdMap.get("pipeline")).get(0)).containsKey("$changeStream")) {
            commandClass = WatchCommand.class;
        } else if (commandName.equals("aggregate")) {
            commandClass = AggregateMongoCommand.class;
        }
        if (commandClass == null) {
            throw new IllegalArgumentException("Unknown command " + commandName);
        }
        try {
            Constructor<? extends MongoCommand> declaredConstructor = commandClass.getDeclaredConstructor(MongoConnection.class);
            declaredConstructor.setAccessible(true);
            MongoCommand mongoCommand = declaredConstructor.newInstance(this);
            mongoCommand.fromMap(cmdMap);
            try {
                Method method = this.getClass().getDeclaredMethod("runCommand", commandClass);
                Object o = method.invoke((Object)this, mongoCommand);
                if (o instanceof Integer) {
                    return (Integer)o;
                }
                this.log.error("THIS CANNOT HAPPEN!");
                return 0;
            }
            catch (NoSuchMethodException ex) {
                this.log.error("No method for command " + commandClass.getSimpleName() + " - " + mongoCommand.getCommandName());
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        int ret = this.commandNumber.incrementAndGet();
        this.commandResults.add(this.prepareResult(Doc.of("ok", (Object)0, "errmsg", "could not execute command inMemory")));
        return ret;
    }

    private int runCommand(StepDownCommand cmd) {
        int ret = this.commandNumber.incrementAndGet();
        this.commandResults.add(this.prepareResult(Doc.of("ok", (Object)0, "errmsg", "no replicaset - in Memory!")));
        return ret;
    }

    private int runCommand(AbortTransactionCommand cmd) {
        this.abortTransaction();
        int ret = this.commandNumber.incrementAndGet();
        this.commandResults.add(this.prepareResult(Doc.of("ok", (Object)1.0, "msg", "aborted")));
        return ret;
    }

    private int runCommand(CommitTransactionCommand cmd) {
        this.commitTransaction();
        int ret = this.commandNumber.incrementAndGet();
        this.commandResults.add(this.prepareResult(Doc.of("ok", (Object)1.0, "msg", "committed")));
        return ret;
    }

    private int runCommand(UpdateMongoCommand cmd) throws MorphiumDriverException {
        int ret = this.commandNumber.incrementAndGet();
        HashMap<String, Object> stats = new HashMap<String, Object>();
        int totalMatched = 0;
        int totalModified = 0;
        int updateIndex = 0;
        ArrayList<Doc> upserted = new ArrayList<Doc>();
        for (Map<String, Object> update : cmd.getUpdates()) {
            Object nm;
            Map<String, Object> res;
            Object m;
            boolean multi = false;
            if (update.containsKey("multi")) {
                multi = Boolean.TRUE.equals(update.get("multi"));
            }
            boolean upsert = false;
            if (update.containsKey("upsert")) {
                upsert = Boolean.TRUE.equals(update.get("upsert"));
            }
            Map collation = null;
            if (update.containsKey("collation") && update.get("collation") instanceof Map) {
                collation = (Map)update.get("collation");
            }
            if ((m = (res = this.update(cmd.getDb(), cmd.getColl(), (Map)update.get("q"), null, (Map)update.get("u"), multi, upsert, collation, cmd.getWriteConcern())).get("matched")) instanceof Number) {
                totalMatched += ((Number)m).intValue();
            }
            if ((nm = res.get("nModified")) instanceof Number) {
                totalModified += ((Number)nm).intValue();
            }
            if (res.containsKey("upsertedIds") && res.get("upsertedIds") instanceof List) {
                List ids = (List)res.get("upsertedIds");
                for (Object id : ids) {
                    upserted.add(Doc.of("index", (Object)updateIndex, "_id", id));
                }
            }
            ++updateIndex;
        }
        int n = totalMatched;
        if (!upserted.isEmpty()) {
            n += upserted.size();
        }
        stats.put("n", n);
        stats.put("nModified", totalModified);
        if (!upserted.isEmpty()) {
            stats.put("upserted", upserted);
        }
        Map<String, Object> preparedResult = this.prepareResult(stats);
        this.commandResults.add(preparedResult);
        return ret;
    }

    public int runCommand(WatchCommand cmd) throws MorphiumDriverException {
        int ret = this.commandNumber.incrementAndGet();
        this.watch(cmd);
        return ret;
    }

    public int runCommand(StoreMongoCommand cmd) throws MorphiumDriverException {
        int ret = this.commandNumber.incrementAndGet();
        Map<String, Integer> stats = this.store(cmd.getDb(), cmd.getColl(), cmd.getDocs(), null);
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("ok", 1.0);
        result.putAll(stats);
        if (!result.containsKey("n") && (result.containsKey("matched") || result.containsKey("inserted"))) {
            int matched = result.containsKey("matched") ? (Integer)result.get("matched") : 0;
            int inserted = result.containsKey("inserted") ? (Integer)result.get("inserted") : 0;
            result.put("n", matched + inserted);
        }
        Map<String, Object> preparedResult = this.prepareResult(result);
        this.commandResults.add(preparedResult);
        return ret;
    }

    public int runCommand(ShutdownCommand cmd) {
        int ret = this.commandNumber.incrementAndGet();
        this.commandResults.add(this.prepareResult(Doc.of("ok", (Object)0.0, "errmsg", "shutdown in memory not supported")));
        return ret;
    }

    public int runCommand(ReplicastStatusCommand cmd) {
        int ret = this.commandNumber.incrementAndGet();
        this.commandResults.add(this.prepareResult(Doc.of("ok", (Object)0.0, "errmsg", "no replicaset")));
        return ret;
    }

    public int runCommand(RenameCollectionCommand cmd) {
        String target = cmd.getTo();
        String origin = cmd.getColl();
        List<Map<String, Object>> col = this.database.get(cmd.getDb()).remove(origin);
        this.database.get(cmd.getDb()).put(target, col);
        int ret = this.commandNumber.incrementAndGet();
        this.commandResults.add(this.prepareResult(Doc.of("ok", (Object)1.0, "msg", "renamed " + origin + " to " + target)));
        return ret;
    }

    public int runCommand(MapReduceCommand cmd) {
        this.log.info("MapReduce command received: db={}, collection={}, map={}, reduce={}", new Object[]{cmd.getDb(), cmd.getColl(), cmd.getMap(), cmd.getReduce()});
        int ret = this.commandNumber.incrementAndGet();
        try {
            List<Map<String, Object>> results = this.mapReduceInternal(cmd.getDb(), cmd.getColl(), cmd.getMap(), cmd.getReduce(), cmd.getQuery(), cmd.getSort(), null, cmd.getFinalize());
            this.log.info("MapReduce completed with {} results", (Object)results.size());
            HashMap<String, Object> response = new HashMap<String, Object>();
            response.put("results", results);
            response.put("timeMillis", 0);
            response.put("counts", Map.of("input", results.size(), "emit", results.size(), "reduce", 0, "output", results.size()));
            response.put("ok", 1.0);
            this.commandResults.add(this.prepareResult(response));
        }
        catch (Exception e) {
            this.log.error("MapReduce error: " + e.getMessage(), (Throwable)e);
            this.commandResults.add(this.prepareResult(Doc.of("ok", (Object)0.0, "errmsg", "MapReduce error: " + e.getMessage())));
        }
        return ret;
    }

    public int runCommand(ListIndexesCommand cmd) {
        int ret = this.commandNumber.incrementAndGet();
        Map<String, List<Map<String, Object>>> indexesForDB = this.indicesByDbCollection.get(cmd.getDb());
        if (indexesForDB == null) {
            this.commandResults.add(this.prepareResult(Doc.of("cursor", Doc.of("firstBatch", List.of(), "id", (Object)0L, "ns", cmd.getDb() + "." + cmd.getColl()), "ok", (Object)1.0, "ns", cmd.getDb() + "." + cmd.getColl(), "id", (Object)0)));
            return ret;
        }
        List<Map<String, Object>> idx = indexesForDB.get(cmd.getColl());
        ArrayList indices = new ArrayList();
        if (idx != null) {
            for (Map<String, Object> i : idx) {
                HashMap<String, Object> index = new HashMap<String, Object>();
                index.put("v", 2.0);
                for (Map.Entry<String, Object> e : i.entrySet()) {
                    if (e.getKey().startsWith("$")) continue;
                    index.putIfAbsent("key", Doc.of());
                    ((Doc)index.get("key")).add(e.getKey(), e.getValue());
                }
                Map opt = (Map)i.get("$options");
                if (opt != null && opt.get("name") != null) {
                    index.put("name", opt.get("name"));
                } else {
                    index.put("name", "unknown");
                }
                if (opt != null && opt.get("unique") != null) {
                    index.put("unique", opt.get("unique"));
                }
                if (opt != null && opt.get("sparse") != null) {
                    index.put("sparse", opt.get("sparse"));
                }
                if (opt != null && opt.get("expireAfterSeconds") != null) {
                    index.put("expireAfterSeconds", opt.get("expireAfterSeconds"));
                }
                if (opt != null && opt.get("bachground") != null) {
                    index.put("background", opt.get("background"));
                }
                if (opt != null && opt.get("background") != null) {
                    index.put("background", opt.get("background"));
                }
                if (opt != null && opt.get("hidden") != null) {
                    index.put("hidden", opt.get("hidden"));
                }
                indices.add(index);
            }
        }
        this.commandResults.add(this.prepareResult(Doc.of("cursor", Doc.of("firstBatch", indices, "id", (Object)0L, "ns", cmd.getDb() + "." + cmd.getColl()), "ok", (Object)1.0, "ns", cmd.getDb() + "." + cmd.getColl(), "id", (Object)1)));
        return ret;
    }

    public int runCommand(ListDatabasesCommand cmd) {
        int ret = this.commandNumber.incrementAndGet();
        HashMap<String, Object> data = new HashMap<String, Object>();
        ArrayList<Doc> dbList = new ArrayList<Doc>();
        data.put("databases", dbList);
        int sum = 0;
        for (String k : this.database.keySet()) {
            sum += this.database.get(k).size();
            Doc db = Doc.of("name", k, "sizeOnDisk", (Object)0, "entries", (Object)this.database.get(k).size(), "empty", (Object)this.database.get(k).isEmpty());
            dbList.add(db);
        }
        data.put("ok", 1.0);
        data.put("totalSize", 0);
        data.put("totalSizeMb", 0);
        data.put("totalEntries", sum);
        this.log.info("Storing listDb Result for id: " + ret);
        this.commandResults.add(this.prepareResult(data));
        return ret;
    }

    public int runCommand(ListCollectionsCommand cmd) {
        int ret = this.commandNumber.incrementAndGet();
        Map<String, Object> m = this.prepareResult();
        ArrayList<Map<String, Object>> cursorData = new ArrayList<Map<String, Object>>();
        if (!this.database.containsKey(cmd.getDb())) {
            this.database.putIfAbsent(cmd.getDb(), new HashMap());
        }
        for (String coll : this.database.get(cmd.getDb()).keySet()) {
            cursorData.add(Doc.of("name", coll, "type", "collection", "options", new Doc(), "info", Doc.of("readonly", (Object)false, "UUID", UUID.randomUUID())).add("idIndex", Doc.of("v", (Object)2.0, "key", Doc.of("_id", (Object)1), "name", "_id_1", "ns", cmd.getDb() + "." + coll)));
        }
        this.addCursor(cmd.getDb(), "$cmd.listCollections", m, cursorData);
        this.commandResults.add(m);
        return ret;
    }

    public int runCommand(KillCursorsCommand cmd) {
        this.log.info("Killing cursors");
        int ret = this.commandNumber.incrementAndGet();
        for (Long id : cmd.getCursors()) {
            this.cursors.remove(id);
        }
        this.commandResults.add(this.prepareResult());
        return ret;
    }

    public int runCommand(InsertMongoCommand cmd) throws MorphiumDriverException {
        int ret = this.commandNumber.incrementAndGet();
        List<Map<String, Object>> writeErrors = this.insert(cmd.getDb(), cmd.getColl(), cmd.getDocuments(), cmd.getWriteConcern());
        Map<String, Object> m = this.prepareResult();
        m.put("n", cmd.getDocuments().size() - writeErrors.size());
        if (writeErrors.size() != 0) {
            m.put("writeErrors", writeErrors);
        }
        this.commandResults.add(m);
        return ret;
    }

    public int runCommand(FindCommand cmd) throws MorphiumDriverException {
        int requestedBatchSize;
        int ret = this.commandNumber.incrementAndGet();
        List<Map<String, Object>> result = this.runFind(cmd);
        if (result == null) {
            result = new ArrayList<Map<String, Object>>();
        }
        if (cmd.isTailable() != null && cmd.isTailable().booleanValue()) {
            long cursorId = ret;
            this.cursors.put(cursorId, cmd);
            final List<Map<String, Object>> tailableResult = result;
            if (result.isEmpty()) {
                WatchCommand watchCmd = ((WatchCommand)((WatchCommand)new WatchCommand(this).setDb(cmd.getDb())).setColl(cmd.getColl())).setMaxTimeMS(cmd.getMaxTimeMS()).setFullDocument(WatchCommand.FullDocumentEnum.updateLookup).setPipeline(Arrays.asList(Doc.of("$match", cmd.getFilter()))).setCb(new DriverTailableIterationCallback(){

                    @Override
                    public void incomingData(Map<String, Object> data, long dur) {
                        tailableResult.add(data);
                    }

                    @Override
                    public boolean isContinued() {
                        return false;
                    }
                });
                this.watch(watchCmd);
                watchCmd.releaseConnection();
            }
            Map<String, Object> response = this.prepareResult();
            this.addCursor(cmd.getDb(), cmd.getColl(), response, result);
            ((Map)response.get("cursor")).put("id", cursorId);
            this.commandResults.add(response);
            return ret;
        }
        int n = requestedBatchSize = cmd.getBatchSize() != null ? cmd.getBatchSize() : 0;
        if (requestedBatchSize <= 0) {
            int n2 = requestedBatchSize = this.getDefaultBatchSize() > 0 ? this.getDefaultBatchSize() : Math.min(result.size(), 101);
        }
        if (cmd.isSingleBatch() != null && cmd.isSingleBatch().booleanValue()) {
            requestedBatchSize = result.size();
        }
        ArrayList<Map<String, Object>> firstBatch = new ArrayList<Map<String, Object>>();
        if (!result.isEmpty()) {
            int end = Math.min(requestedBatchSize, result.size());
            firstBatch.addAll(result.subList(0, end));
        }
        String namespace = cmd.getDb() + "." + cmd.getColl();
        long cursorId = this.registerCursorBuffer(namespace, result, requestedBatchSize);
        HashMap<String, Object> cursorDoc = new HashMap<String, Object>();
        cursorDoc.put("firstBatch", firstBatch);
        cursorDoc.put("ns", namespace);
        cursorDoc.put("id", cursorId);
        Map<String, Object> response = this.prepareResult();
        response.put("cursor", cursorDoc);
        this.commandResults.add(response);
        return ret;
    }

    private List<Map<String, Object>> runFind(FindCommand cmd) throws MorphiumDriverException {
        Doc filter;
        int limit = 0;
        if (cmd.getLimit() != null) {
            limit = cmd.getLimit();
        }
        int skip = 0;
        if (cmd.getSkip() != null) {
            skip = cmd.getSkip();
        }
        if ((filter = cmd.getFilter()) == null) {
            filter = Doc.of();
        }
        List<Map<String, Object>> result = this.find(cmd.getDb(), cmd.getColl(), filter, cmd.getSort(), cmd.getProjection(), cmd.getCollation(), skip, limit, false);
        return result;
    }

    private int runCommand(GetMoreMongoCommand cmd) throws MorphiumDriverException {
        int ret = this.commandNumber.incrementAndGet();
        if (this.cursors.containsKey(cmd.getCursorId())) {
            ArrayList result;
            FindCommand fnd = this.cursors.get(cmd.getCursorId());
            final ArrayList tailableResult = result = new ArrayList();
            if (result.isEmpty()) {
                WatchCommand watchCmd = ((WatchCommand)((WatchCommand)new WatchCommand(this).setDb(fnd.getDb())).setColl(fnd.getColl())).setMaxTimeMS(fnd.getMaxTimeMS()).setFullDocument(WatchCommand.FullDocumentEnum.updateLookup).setPipeline(Arrays.asList(Doc.of("$match", fnd.getFilter()))).setCb(new DriverTailableIterationCallback(){

                    @Override
                    public void incomingData(Map<String, Object> data, long dur) {
                        tailableResult.add((Map)data.get("fullDocument"));
                    }

                    @Override
                    public boolean isContinued() {
                        return false;
                    }
                });
                this.watch(watchCmd);
                watchCmd.releaseConnection();
            }
            Map<String, Object> response = this.prepareResult();
            response.put("cursor", Doc.of("nextBatch", result, "ns", cmd.getDb() + "." + cmd.getColl(), "id", (Object)cmd.getCursorId()));
            this.commandResults.add(response);
            return ret;
        }
        long cursorId = cmd.getCursorId();
        int requestedBatchSize = cmd.getBatchSize() != null ? cmd.getBatchSize() : 0;
        List<Map<String, Object>> nextBatch = this.drainNextBatch(cursorId, requestedBatchSize);
        Object namespace = this.namespaceForCursor(cursorId);
        if (namespace == null) {
            namespace = cmd.getDb() + "." + cmd.getColl();
        }
        long nextId = this.activeQueryCursors.containsKey(cursorId) ? cursorId : 0L;
        HashMap<String, Object> cursorDoc = new HashMap<String, Object>();
        cursorDoc.put("nextBatch", nextBatch);
        cursorDoc.put("ns", namespace);
        cursorDoc.put("id", nextId);
        Map<String, Object> response = this.prepareResult();
        response.put("cursor", cursorDoc);
        this.commandResults.add(response);
        return ret;
    }

    private int runCommand(FindAndModifyMongoCommand cmd) throws MorphiumDriverException {
        int ret = this.commandNumber.incrementAndGet();
        if (cmd.isRemove()) {
            List<Map<String, Object>> list = this.find(cmd.getDb(), cmd.getColl(), cmd.getQuery(), cmd.getSort(), null, 0, 1);
            Map<String, Object> res = this.delete(cmd.getDb(), cmd.getColl(), Doc.of("_id", list.get(0).get("_id")), null, false, null, null);
            this.commandResults.add(this.prepareResult(Doc.of("value", list.get(0))));
        } else {
            Map<String, Object> res = this.findAndOneAndUpdate(cmd.getDb(), cmd.getColl(), cmd.getQuery(), cmd.getUpdate(), cmd.getSort(), cmd.getCollation());
            this.commandResults.add(this.prepareResult(Doc.of("value", res)));
        }
        return ret;
    }

    private int runCommand(DropMongoCommand cmd) {
        int ret = this.commandNumber.incrementAndGet();
        this.drop(cmd.getDb(), cmd.getColl(), null);
        this.commandResults.add(this.prepareResult(Doc.of("ok", (Object)1.0, "msg", "dropped collection " + cmd.getColl())));
        try {
            Thread.sleep(200L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return ret;
    }

    private int runCommand(DropDatabaseMongoCommand cmd) {
        int ret = this.commandNumber.incrementAndGet();
        this.drop(cmd.getDb(), null);
        this.commandResults.add(this.prepareResult(Doc.of("ok", (Object)1.0, "msg", "dropped database " + cmd.getDb())));
        return ret;
    }

    private int runCommand(DistinctMongoCommand cmd) throws MorphiumDriverException {
        int ret = this.commandNumber.incrementAndGet();
        List<Object> distinctResult = this.distinct(cmd.getDb(), cmd.getColl(), cmd.getKey(), cmd.getQuery(), cmd.getCollation());
        Map<String, Object> m = this.prepareResult();
        m.put("values", distinctResult);
        this.commandResults.add(m);
        return ret;
    }

    private int runCommand(DeleteMongoCommand cmd) throws MorphiumDriverException {
        int ret = this.commandNumber.incrementAndGet();
        int totalDeleted = 0;
        for (Doc del : cmd.getDeletes()) {
            Map<String, Object> deleteStats;
            Object object;
            boolean multi = true;
            if (del.get("limit") != null) {
                multi = (Integer)del.get("limit") == 0;
            }
            Map collation = null;
            if (del.get("collation") instanceof Map) {
                collation = (Map)del.get("collation");
            }
            if (!((object = (deleteStats = this.delete(cmd.getDb(), cmd.getColl(), (Map)del.get("q"), null, multi, collation, null)).get("n")) instanceof Number)) continue;
            Number n = (Number)object;
            totalDeleted += n.intValue();
        }
        Map<String, Object> result = this.prepareResult();
        result.put("ok", 1.0);
        result.put("n", totalDeleted);
        this.commandResults.add(result);
        return ret;
    }

    private int runCommand(DbStatsCommand cmd) {
        int ret = this.commandNumber.incrementAndGet();
        Map<String, Object> m = this.prepareResult();
        m.put("databases", this.database.size());
        this.commandResults.add(m);
        return ret;
    }

    private int runCommand(CurrentOpCommand cmd) {
        int ret = this.commandNumber.incrementAndGet();
        Map<String, Object> m = this.prepareResult();
        m.put("ok", 0.0);
        m.put("errmsg", "no running ops in memory");
        this.commandResults.add(m);
        return ret;
    }

    private int runCommand(CreateIndexesCommand cmd) throws MorphiumDriverException {
        int ret = this.commandNumber.incrementAndGet();
        for (Map<String, Object> idx : cmd.getIndexes()) {
            IndexDescription descr = IndexDescription.fromMap(idx);
            this.createIndex(cmd.getDb(), cmd.getColl(), (Map)idx.get("key"), idx);
        }
        this.commandResults.add(this.prepareResult());
        return ret;
    }

    private int runCommand(CreateCommand cmd) {
        int ret = this.commandNumber.incrementAndGet();
        if (cmd.getCapped() != null && cmd.getCapped().booleanValue()) {
            this.cappedCollections.putIfAbsent(cmd.getDb(), new HashMap());
            this.cappedCollections.get(cmd.getDb()).putIfAbsent(cmd.getColl(), new HashMap());
            this.cappedCollections.get(cmd.getDb()).get(cmd.getColl()).put("size", cmd.getSize());
            this.cappedCollections.get(cmd.getDb()).get(cmd.getColl()).put("max", cmd.getMax());
        }
        if (cmd.getTimeseries() != null) {
            this.log.warn("Timeseries collections not supported in memory");
        }
        if (cmd.getPipeline() != null) {
            this.log.warn("pipeline not supported in memory");
        }
        this.database.putIfAbsent(cmd.getDb(), new HashMap());
        if (this.database.get(cmd.getDb()).containsKey(cmd.getColl())) {
            this.log.warn("Collection already exists...");
        } else {
            this.database.get(cmd.getDb()).put(cmd.getColl(), new ArrayList());
        }
        Map<String, Object> m = this.prepareResult();
        this.addCursor(cmd.getDb(), cmd.getColl(), m, Arrays.asList(Doc.of()));
        this.commandResults.add(m);
        return ret;
    }

    private int runCommand(CountMongoCommand cmd) throws MorphiumDriverException {
        int ret = this.commandNumber.incrementAndGet();
        Map<String, Object> m = this.prepareResult();
        int cnt = this.find(cmd.getDb(), cmd.getColl(), cmd.getQuery(), null, null, cmd.getCollation(), 0, 0, false).size();
        m.put("n", cnt);
        m.put("count", cnt);
        this.commandResults.add(m);
        return ret;
    }

    private int runCommand(CollStatsCommand cmd) {
        int ret = this.commandNumber.incrementAndGet();
        Map<String, Object> m = this.prepareResult();
        m.put("ns", cmd.getDb() + "." + cmd.getColl());
        long size = VM.current().sizeOf(this.database.get(cmd.getDb()).get(cmd.getColl()));
        m.put("size", size);
        m.put("storageSize", 0);
        List<Map<String, Object>> indexes = this.getIndexes(cmd.getDb(), cmd.getColl());
        m.put("nindexes", indexes.size());
        Doc indexDetails = Doc.of();
        Doc indexSizes = Doc.of();
        long totalSize = size;
        for (Map<String, Object> idx : indexes) {
            String idxName = (String)((Map)idx.get("$options")).get("name");
            indexDetails.put(idxName, idx);
            long sz = VM.current().sizeOf(this.indexDataByDBCollection.get(cmd.getDb()).get(cmd.getColl())) + VM.current().sizeOf(idx);
            indexSizes.put(idxName, sz);
            totalSize += sz;
        }
        m.put("totalSize", totalSize);
        m.put("indexDetails", indexDetails);
        m.put("indexSizes", indexSizes);
        this.commandResults.add(m);
        return ret;
    }

    private int runCommand(ClearCollectionCommand cmd) {
        this.database.get(cmd.getDb()).get(cmd.getColl()).clear();
        int ret = this.commandNumber.incrementAndGet();
        this.commandResults.add(this.prepareResult(Doc.of("ok", (Object)1.0)));
        return ret;
    }

    private int runCommand(AggregateMongoCommand cmd) {
        if (cmd.getDb().equals("admin") && cmd.getColl().equals("atlascli")) {
            int ret = this.commandNumber.incrementAndGet();
            this.commandResults.add(this.prepareResult(Doc.of("ok", (Object)0.0, "msg", "not found")));
            return ret;
        }
        throw new IllegalArgumentException("please use morphium for aggregation in Memory!");
    }

    private int runCommand(MongoCommand cmd) {
        throw new IllegalArgumentException("Unhandled command " + cmd.getCommandName() + " class: " + cmd.getClass().getSimpleName());
    }

    private int runCommand(HelloCommand cmd) {
        this.log.info("Hello Command incoming");
        int ret = this.commandNumber.incrementAndGet();
        HashMap<String, Object> helloResponse = new HashMap<String, Object>();
        helloResponse.put("helloOk", true);
        helloResponse.put("isWritablePrimary", true);
        helloResponse.put("ismaster", true);
        helloResponse.put("secondary", false);
        helloResponse.put("maxBsonObjectSize", 0x8000000);
        helloResponse.put("maxWriteBatchSize", 100000);
        helloResponse.put("maxWireVersion", 21);
        helloResponse.put("minWireVersion", 0);
        helloResponse.put("localTime", new Date());
        helloResponse.put("connectionId", this.connectionId.incrementAndGet());
        helloResponse.put("msg", "InMemDriver - ok");
        Map<String, Object> m = this.addCursor(cmd.getDb(), cmd.getColl(), this.prepareResult(), Arrays.asList(helloResponse));
        this.commandResults.add(m);
        return ret;
    }

    private Map<String, Object> addCursor(String db, String coll, Map<String, Object> result, List<Map<String, Object>> data) {
        result.put("cursor", Doc.of("firstBatch", data, "ns", db + "." + coll, "id", (Object)0L));
        return result;
    }

    private long registerCursorBuffer(String namespace, List<Map<String, Object>> allResults, int batchSize) {
        if (allResults == null || allResults.isEmpty()) {
            return 0L;
        }
        if (batchSize <= 0) {
            batchSize = Math.min(allResults.size(), 101);
        }
        if (allResults.size() <= batchSize) {
            return 0L;
        }
        ArrayDeque<Map<String, Object>> remaining = new ArrayDeque<Map<String, Object>>(allResults.subList(batchSize, allResults.size()));
        long cursorId = this.cursorIdSequence.getAndIncrement();
        this.activeQueryCursors.put(cursorId, new CursorResultBuffer(remaining, namespace, batchSize));
        return cursorId;
    }

    private List<Map<String, Object>> drainNextBatch(long cursorId, int requestedBatchSize) {
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        this.activeQueryCursors.computeIfPresent(cursorId, (id, buffer) -> {
            CursorResultBuffer cursorResultBuffer = buffer;
            synchronized (cursorResultBuffer) {
                int size;
                int n = size = requestedBatchSize > 0 ? requestedBatchSize : buffer.defaultBatchSize;
                if (size <= 0) {
                    size = buffer.defaultBatchSize > 0 ? buffer.defaultBatchSize : 101;
                }
                for (int i = 0; i < size && !buffer.remaining.isEmpty(); ++i) {
                    result.add(buffer.remaining.pollFirst());
                }
                return buffer.remaining.isEmpty() ? null : buffer;
            }
        });
        return result;
    }

    private String namespaceForCursor(long cursorId) {
        CursorResultBuffer buffer = this.activeQueryCursors.get(cursorId);
        return buffer == null ? null : buffer.namespace;
    }

    private void closeCursor(long cursorId) {
        this.activeQueryCursors.remove(cursorId);
    }

    private Map<String, Object> prepareResult() {
        return this.prepareResult(Doc.of());
    }

    private Map<String, Object> prepareResult(Map<String, Object> result) {
        if (!result.containsKey("ok")) {
            result.put("ok", 1.0);
        }
        result.put("$clusterTime", Doc.of("clusterTime", (Object)System.currentTimeMillis(), "signature", Doc.of("hash", new byte[20], "keyId", (Object)0)));
        result.put("operationTime", System.currentTimeMillis());
        return result;
    }

    @Override
    public MongoConnection getReadConnection(ReadPreference rp) {
        this.activeConnections.incrementAndGet();
        this.stats.get((Object)MorphiumDriver.DriverStatsKey.CONNECTIONS_BORROWED).incrementAndGet();
        return new InMemConnectionWrapper(this);
    }

    @Override
    public MongoConnection getPrimaryConnection(WriteConcern wc) {
        this.activeConnections.incrementAndGet();
        this.stats.get((Object)MorphiumDriver.DriverStatsKey.CONNECTIONS_BORROWED).incrementAndGet();
        return new InMemConnectionWrapper(this);
    }

    @Override
    public void releaseConnection(MongoConnection con) {
        this.activeConnections.decrementAndGet();
    }

    @Override
    public void closeConnection(MongoConnection con) {
        this.activeConnections.decrementAndGet();
    }

    @Override
    public String getName() {
        return driverName;
    }

    @Override
    public int getMaxBsonObjectSize() {
        return Integer.MAX_VALUE;
    }

    @Override
    public void setMaxBsonObjectSize(int maxBsonObjectSize) {
    }

    @Override
    public int getMaxMessageSize() {
        return Integer.MAX_VALUE;
    }

    @Override
    public void setMaxMessageSize(int maxMessageSize) {
    }

    @Override
    public int getMaxWriteBatchSize() {
        return Integer.MAX_VALUE;
    }

    @Override
    public void setMaxWriteBatchSize(int maxWriteBatchSize) {
    }

    @Override
    public boolean isReplicaSet() {
        return false;
    }

    @Override
    public void setReplicaSet(boolean replicaSet) {
    }

    @Override
    public boolean getDefaultJ() {
        return false;
    }

    @Override
    public int getDefaultWriteTimeout() {
        return 0;
    }

    @Override
    public void setDefaultWriteTimeout(int wt) {
    }

    @Override
    public void setHostSeed(String ... host) {
    }

    @Override
    public void setConnectionUrl(String connectionUrl) {
    }

    /*
     * Exception decompiling
     */
    @Override
    public void connect() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void scheduleExpire() {
        this.expire = this.exec.scheduleWithFixedDelay(() -> {
            try {
                for (String db : this.database.keySet()) {
                    for (String coll : this.database.get(db).keySet()) {
                        if (this.getCollection(db, coll).isEmpty()) continue;
                        List<Map<String, Object>> idx = this.getIndexes(db, coll);
                        for (Map<String, Object> i : idx) {
                            Map options = (Map)i.get("$options");
                            if (options == null || !options.containsKey("expireAfterSeconds")) continue;
                            HashMap<String, Object> k = new HashMap<String, Object>(i);
                            k.remove("$options");
                            String[] keys = k.keySet().toArray(new String[0]);
                            if (keys.length > 1) {
                                this.log.error("Too many keys for expire-index!!!");
                                continue;
                            }
                            try {
                                Date threshold = new Date(System.currentTimeMillis() - (long)((Integer)options.get("expireAfterSeconds") * 1000));
                                ArrayList<Map<String, Object>> snapshot = new ArrayList<Map<String, Object>>(this.getCollection(db, coll));
                                ArrayList<Map> toRemove = new ArrayList<Map>();
                                for (Map map : snapshot) {
                                    boolean expired;
                                    Object val = map.get(keys[0]);
                                    if (val == null) continue;
                                    if (val instanceof Date) {
                                        expired = !((Date)val).after(threshold);
                                    } else if (val instanceof Number) {
                                        expired = ((Number)val).longValue() <= threshold.getTime();
                                    } else {
                                        this.log.warn("expireAfterSeconds value is not Number or date: {} of type {}", val, (Object)val.getClass().getName());
                                        expired = QueryHelper.matchesQuery(Doc.of(keys[0], Doc.of("$lte", threshold)), map, null);
                                    }
                                    if (!expired) continue;
                                    toRemove.add(map);
                                }
                                if (toRemove.isEmpty()) continue;
                                for (Map map : toRemove) {
                                    this.getCollection(db, coll).remove(map);
                                }
                                this.updateIndexData(db, coll, null);
                            }
                            catch (Exception e) {
                                this.log.error("Error", (Throwable)e);
                            }
                        }
                    }
                }
            }
            catch (Exception e) {
                this.log.error("Error", (Throwable)e);
            }
        }, 100L, this.expireCheck, TimeUnit.MILLISECONDS);
    }

    public int getExpireCheck() {
        return this.expireCheck;
    }

    public InMemoryDriver setExpireCheck(int expireCheck) {
        this.expireCheck = expireCheck;
        if (this.expire != null) {
            this.expire.cancel(true);
        }
        this.scheduleExpire();
        return this;
    }

    @Override
    public void connect(String replicasetName) {
        this.connect();
    }

    @Override
    public boolean isConnected() {
        return true;
    }

    @Override
    public String getConnectedTo() {
        return "inMem:0000";
    }

    @Override
    public String getConnectedToHost() {
        return "inMem";
    }

    @Override
    public int getConnectedToPort() {
        return 6666;
    }

    @Override
    public int getRetriesOnNetworkError() {
        return 1;
    }

    @Override
    public MorphiumDriver setRetriesOnNetworkError(int r) {
        return this;
    }

    @Override
    public int getSleepBetweenErrorRetries() {
        return 100;
    }

    @Override
    public MorphiumDriver setSleepBetweenErrorRetries(int s) {
        return this;
    }

    @Override
    public int getMaxConnections() {
        return 1;
    }

    @Override
    public MorphiumDriver setMaxConnections(int maxConnections) {
        return this;
    }

    @Override
    public int getMinConnections() {
        return 1;
    }

    @Override
    public MorphiumDriver setMinConnections(int minConnections) {
        return this;
    }

    @Override
    public boolean isRetryReads() {
        return false;
    }

    @Override
    public MorphiumDriver setRetryReads(boolean retryReads) {
        return this;
    }

    @Override
    public boolean isRetryWrites() {
        return false;
    }

    @Override
    public MorphiumDriver setRetryWrites(boolean retryWrites) {
        return this;
    }

    @Override
    public int getReadTimeout() {
        return 0;
    }

    @Override
    public void setReadTimeout(int readTimeout) {
    }

    @Override
    public int getMinConnectionsPerHost() {
        return 0;
    }

    @Override
    public void setMinConnectionsPerHost(int minConnectionsPerHost) {
    }

    @Override
    public int getMaxConnectionsPerHost() {
        return 0;
    }

    @Override
    public void setMaxConnectionsPerHost(int maxConnectionsPerHost) {
    }

    @Override
    public void setCredentials(String db, String login, String pwd) {
    }

    private <T> T deepClone(T object) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            oos.writeObject(object);
            ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
            ObjectInputStream ois = new ObjectInputStream(bais);
            return (T)ois.readObject();
        }
        catch (Exception e) {
            this.log.error("Error", (Throwable)e);
            return null;
        }
    }

    @Override
    public MorphiumTransactionContext startTransaction(boolean autoCommit) {
        if (this.currentTransaction.get() != null) {
            throw new IllegalArgumentException("transaction in progress");
        }
        InMemTransactionContext ctx = new InMemTransactionContext();
        ctx.setDatabase(this.deepClone(this.database));
        this.currentTransaction.set(ctx);
        return this.currentTransaction.get();
    }

    @Override
    public boolean isTransactionInProgress() {
        return this.currentTransaction.get() != null;
    }

    @Override
    public MorphiumTransactionContext getTransactionContext() {
        return this.currentTransaction.get();
    }

    @Override
    public HelloResult connect(MorphiumDriver drv, String host, int port) throws IOException, MorphiumDriverException {
        return new HelloResult().setHosts(Arrays.asList("inMem")).setHelloOk(true).setLocalTime(new Date()).setMaxBsonObjectSize(Integer.MAX_VALUE).setMe("inMem").setWritablePrimary(true);
    }

    @Override
    public MorphiumDriver getDriver() {
        return this;
    }

    @Override
    public int getSourcePort() {
        return 0;
    }

    @Override
    public void close() {
        this.log.info("InMemoryDriver.close() called - instance {}", (Object)System.identityHashCode(this));
        this.shutdown(true);
        this.log.info("InMemoryDriver.close() completed - instance {}", (Object)System.identityHashCode(this));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown(boolean clearData) {
        this.log.info("Shutting down InMemoryDriver (clearData={})", (Object)clearData);
        if (this.exec != null && !this.exec.isShutdown()) {
            this.exec.shutdownNow();
            try {
                if (!this.exec.awaitTermination(5L, TimeUnit.SECONDS)) {
                    this.log.warn("InMemoryDriver executor did not terminate in time");
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                this.log.warn("Interrupted while waiting for executor termination");
            }
        }
        if (this.eventDispatcher != null && !this.eventDispatcher.isShutdown()) {
            this.eventDispatcher.shutdownNow();
            try {
                if (!this.eventDispatcher.awaitTermination(5L, TimeUnit.SECONDS)) {
                    this.log.warn("InMemoryDriver eventDispatcher did not terminate in time");
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                this.log.warn("Interrupted while waiting for eventDispatcher termination");
            }
        }
        Iterator<Object> iterator = this.monitors.iterator();
        while (iterator.hasNext()) {
            Object m;
            Object object = m = iterator.next();
            synchronized (object) {
                m.notifyAll();
            }
        }
        if (clearData) {
            this.resetData();
        }
        this.activeConnections.set(0);
    }

    @Override
    public boolean isReplicaset() {
        return false;
    }

    @Override
    public Map<String, Object> getReplsetStatus() {
        return this.prepareResult(Doc.of("ok", (Object)0.0, "errmsg", "no replicaset"));
    }

    @Override
    public Map<String, Object> getDBStats(String db) {
        ConcurrentHashMap<String, Object> ret = new ConcurrentHashMap<String, Object>();
        ret.put("collections", this.getDB(db).size());
        return ret;
    }

    @Override
    public Map<String, Object> getCollStats(String db, String coll) throws MorphiumDriverException {
        ConcurrentHashMap<String, Object> ret = new ConcurrentHashMap<String, Object>();
        ret.put("entries", this.getDB(db).get(coll).size());
        return ret;
    }

    public MorphiumCursor initIteration(String db, String collection, Map<String, Object> query, Map<String, Object> sort, Map<String, Object> projection, int skip, int limit, int batchSize, ReadPreference readPreference, Collation coll, Map<String, Object> findMetaData) throws MorphiumDriverException {
        InMemoryCursor inCrs = new InMemoryCursor();
        inCrs.skip = Math.max(0, skip);
        inCrs.limit = Math.max(0, limit);
        inCrs.batchSize = batchSize == 0 ? 1000 : batchSize;
        inCrs.setCollection(collection);
        inCrs.setDb(db);
        inCrs.setProjection(projection);
        inCrs.setQuery(query == null ? Doc.of() : query);
        inCrs.setFindMetaData(findMetaData);
        inCrs.setReadPreference(readPreference);
        inCrs.setSort(sort);
        inCrs.setCollation(coll);
        int l = inCrs.batchSize;
        if (inCrs.limit != 0) {
            l = Math.min(l, inCrs.limit);
        }
        List<Map<String, Object>> res = this.find(db, collection, inCrs.getQuery(), sort, projection, coll == null ? null : coll.toQueryObject(), inCrs.skip, l, false);
        inCrs.dataRead = res.size();
        final CopyOnWriteArrayList<Map<String, Object>> batch = new CopyOnWriteArrayList<Map<String, Object>>(res);
        long cursorId = System.currentTimeMillis();
        this.iterationCursors.put(cursorId, inCrs);
        MorphiumCursor crs = new MorphiumCursor(this){
            private int idx = 0;
            final /* synthetic */ InMemoryDriver this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public Iterator<Map<String, Object>> iterator() {
                return this;
            }

            @Override
            public boolean hasNext() {
                return this.idx < batch.size();
            }

            @Override
            public Map<String, Object> next() {
                return (Map)batch.get(this.idx++);
            }

            @Override
            public void close() {
                this.this$0.iterationCursors.remove(this.getCursorId());
            }

            @Override
            public int available() {
                return Math.max(0, batch.size() - this.idx);
            }

            @Override
            public List<Map<String, Object>> getAll() {
                return new ArrayList<Map<String, Object>>(batch.subList(this.idx, batch.size()));
            }

            @Override
            public void ahead(int skip) {
                this.idx = Math.min(batch.size(), Math.max(0, this.idx + skip));
            }

            @Override
            public void back(int jump) {
                this.idx = Math.max(0, this.idx - Math.max(0, jump));
            }

            @Override
            public int getCursor() {
                return this.idx;
            }

            @Override
            public MongoConnection getConnection() {
                return this.this$0.new InMemConnectionWrapper(this.this$0);
            }
        };
        crs.setBatchSize(inCrs.batchSize);
        crs.setCursorId(cursorId);
        crs.setDb(db);
        crs.setCollection(collection);
        crs.setBatch(batch);
        return crs;
    }

    public MorphiumCursor nextIteration(MorphiumCursor crs) throws MorphiumDriverException {
        int remainingLimit;
        InMemoryCursor st = this.iterationCursors.get(crs.getCursorId());
        if (st == null) {
            return null;
        }
        int n = remainingLimit = st.limit == 0 ? Integer.MAX_VALUE : st.limit - st.dataRead;
        if (remainingLimit <= 0) {
            this.iterationCursors.remove(crs.getCursorId());
            return null;
        }
        int l = Math.min(st.batchSize, remainingLimit);
        int nextSkip = st.skip + st.dataRead;
        List<Map<String, Object>> res = this.find(st.getDb(), st.getCollection(), st.getQuery(), st.getSort(), st.getProjection(), st.getCollation() == null ? null : st.getCollation().toQueryObject(), nextSkip, l, false);
        if (res == null || res.isEmpty()) {
            this.iterationCursors.remove(crs.getCursorId());
            return null;
        }
        st.dataRead += res.size();
        final CopyOnWriteArrayList<Map<String, Object>> batch = new CopyOnWriteArrayList<Map<String, Object>>(res);
        MorphiumCursor next = new MorphiumCursor(this){
            private int idx = 0;
            final /* synthetic */ InMemoryDriver this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public Iterator<Map<String, Object>> iterator() {
                return this;
            }

            @Override
            public boolean hasNext() {
                return this.idx < batch.size();
            }

            @Override
            public Map<String, Object> next() {
                return (Map)batch.get(this.idx++);
            }

            @Override
            public void close() {
                this.this$0.iterationCursors.remove(this.getCursorId());
            }

            @Override
            public int available() {
                return Math.max(0, batch.size() - this.idx);
            }

            @Override
            public List<Map<String, Object>> getAll() {
                return new ArrayList<Map<String, Object>>(batch.subList(this.idx, batch.size()));
            }

            @Override
            public void ahead(int skip) {
                this.idx = Math.min(batch.size(), Math.max(0, this.idx + skip));
            }

            @Override
            public void back(int jump) {
                this.idx = Math.max(0, this.idx - Math.max(0, jump));
            }

            @Override
            public int getCursor() {
                return this.idx;
            }

            @Override
            public MongoConnection getConnection() {
                return this.this$0.new InMemConnectionWrapper(this.this$0);
            }
        };
        next.setCursorId(crs.getCursorId());
        next.setBatchSize(st.batchSize);
        next.setDb(st.getDb());
        next.setCollection(st.getCollection());
        next.setBatch(batch);
        return next;
    }

    public List<Map<String, Object>> find(String db, String collection, Map<String, Object> query, Map<String, Object> sort, Map<String, Object> projection, int skip, int limit) throws MorphiumDriverException {
        return this.find(db, collection, query, sort, projection, null, skip, limit, false);
    }

    private ReadWriteLock getCollectionLock(String db, String collection) {
        String key = db + "." + collection;
        return this.collectionLocks.computeIfAbsent(key, k -> new ReentrantReadWriteLock());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Map<String, Object>> find(String db, String collection, Map<String, Object> query, Map<String, Object> sort, Map<String, Object> projection, Map<String, Object> collation, int skip, int limit, boolean internal) throws MorphiumDriverException {
        ReadWriteLock lock;
        ReadWriteLock readWriteLock = lock = internal ? null : this.getCollectionLock(db, collection);
        if (lock != null) {
            lock.readLock().lock();
        }
        try {
            List<Object> partialHitData = new ArrayList();
            if (query == null) {
                query = Doc.of();
            }
            LinkedHashMap<String, Object> renamedQuery = new LinkedHashMap<String, Object>(query);
            for (Object key : new ArrayList(query.keySet())) {
                String translatedField;
                String newKey;
                String[] parts;
                if (((String)key).startsWith("$") || !((String)key).contains(".") || (parts = ((String)key).split("\\.", 2)).length != 2 || (newKey = (translatedField = InMemoryDriver.camelToSnakeCase(parts[0])) + "." + parts[1]).equals(key)) continue;
                Object value = renamedQuery.remove(key);
                renamedQuery.put(newKey, value);
            }
            query = renamedQuery;
            if (query.containsKey("$and")) {
                m = (List)query.get("$and");
                if (m != null && !m.isEmpty()) {
                    for (Map subquery : m) {
                        dataFromIndex = this.getDataFromIndex(db, collection, subquery);
                        if (dataFromIndex == null) continue;
                        partialHitData = dataFromIndex;
                        break;
                    }
                }
            } else if (query.containsKey("$or")) {
                m = (List)query.get("$or");
                if (m != null) {
                    for (Map subquery : m) {
                        dataFromIndex = this.getDataFromIndex(db, collection, subquery);
                        if (dataFromIndex == null) continue;
                        partialHitData.addAll(dataFromIndex);
                    }
                }
            } else {
                partialHitData = this.getDataFromIndex(db, collection, query);
            }
            List<Object> data = partialHitData == null || partialHitData.isEmpty() ? new ArrayList<Map<String, Object>>(this.getCollection(db, collection)) : partialHitData;
            ArrayList<Map<String, Object>> ret = new ArrayList<Map<String, Object>>();
            int count = 0;
            if (sort != null) {
                Collator coll = QueryHelper.getCollator(collation);
                data.sort((o1, o2) -> {
                    for (String f : sort.keySet()) {
                        int r;
                        if (o1.get(f) == null && o2.get(f) == null) continue;
                        if (o1.get(f) == null && o2.get(f) != null) {
                            return -1;
                        }
                        if (o1.get(f) != null && o2.get(f) == null) {
                            return 1;
                        }
                        if (sort.get(f) instanceof Integer) {
                            if (coll != null) {
                                r = coll.compare(o1.get(f).toString(), o2.get(f).toString()) * (Integer)sort.get(f);
                                if (r == 0) continue;
                                return r;
                            }
                            r = ((Comparable)o1.get(f)).compareTo(o2.get(f)) * (Integer)sort.get(f);
                            if (r == 0) continue;
                            return r;
                        }
                        r = coll.compare(o1.toString(), o2.toString());
                        if (r == 0) continue;
                        return r;
                    }
                    return 0;
                });
            }
            for (int i = 0; i < data.size(); ++i) {
                Map<String, Object> o = (Map<String, Object>)data.get(i);
                if (++count < skip) continue;
                if (!internal) {
                    while (true) {
                        try {
                            o = InMemoryDriver.deepCopyDoc(o);
                            if (!(o.get("_id") instanceof ObjectId)) break;
                            o.put("_id", new MorphiumId((ObjectId)o.get("_id")));
                        }
                        catch (ConcurrentModificationException value) {
                            continue;
                        }
                        break;
                    }
                }
                if (QueryHelper.matchesQuery(query, o, collation)) {
                    if (o == null) {
                        o = new HashMap<String, Object>();
                    }
                    if (projection != null && !projection.isEmpty()) {
                        HashMap<String, Object> projected = new HashMap<String, Object>();
                        boolean hasInclude = projection.values().stream().anyMatch(v -> {
                            if (v instanceof Number) {
                                return ((Number)v).intValue() == 1;
                            }
                            if (v instanceof Boolean) {
                                return (Boolean)v;
                            }
                            return v instanceof Map && (((Map)v).containsKey("$slice") || ((Map)v).containsKey("$elemMatch") || ((Map)v).containsKey("$meta"));
                        });
                        boolean hasExclude = projection.values().stream().anyMatch(v -> {
                            if (v instanceof Number) {
                                return ((Number)v).intValue() == 0;
                            }
                            if (v instanceof Boolean) {
                                return (Boolean)v == false;
                            }
                            return false;
                        });
                        if (hasInclude && !hasExclude) {
                            for (Map.Entry<String, Object> e : projection.entrySet()) {
                                Object arr;
                                String k = e.getKey();
                                Object v2 = e.getValue();
                                boolean include = v2 instanceof Number && ((Number)v2).intValue() == 1 || v2 instanceof Boolean && (Boolean)v2 != false || v2 instanceof Map;
                                if (!include) continue;
                                if (v2 instanceof Map && ((Map)v2).containsKey("$slice")) {
                                    arr = InMemoryDriver.getByPath(o, k);
                                    Object sliced = InMemoryDriver.applySlice(arr, ((Map)v2).get("$slice"));
                                    if (sliced == null) continue;
                                    InMemoryDriver.setByPath(projected, k, sliced);
                                    continue;
                                }
                                if (v2 instanceof Map && ((Map)v2).containsKey("$elemMatch")) {
                                    arr = InMemoryDriver.getByPath(o, k);
                                    Object em = InMemoryDriver.applyElemMatchProjection(k, arr, (Map)((Map)v2).get("$elemMatch"));
                                    if (em == null) continue;
                                    InMemoryDriver.setByPath(projected, k, em);
                                    continue;
                                }
                                Object val = InMemoryDriver.getByPath(o, k);
                                boolean fieldExists = InMemoryDriver.containsByPath(o, k);
                                if (!fieldExists) continue;
                                InMemoryDriver.setByPath(projected, k, val);
                            }
                            if ((!projection.containsKey("_id") || InMemoryDriver.truthy(projection.get("_id"))) && o.containsKey("_id")) {
                                projected.put("_id", o.get("_id"));
                            }
                            o = projected;
                        } else {
                            Map<String, Object> copy = InMemoryDriver.deepCopyDoc(o);
                            for (Map.Entry<String, Object> e : projection.entrySet()) {
                                String k = e.getKey();
                                Object v3 = e.getValue();
                                boolean exclude = v3 instanceof Number && ((Number)v3).intValue() == 0 || v3 instanceof Boolean && (Boolean)v3 == false;
                                if (!exclude) continue;
                                InMemoryDriver.removeByPath(copy, k);
                            }
                            o = copy;
                        }
                    }
                    ret.add(o);
                }
                if (limit > 0 && ret.size() >= limit) break;
            }
            ArrayList<Map<String, Object>> arrayList = new ArrayList<Map<String, Object>>(ret);
            return arrayList;
        }
        finally {
            if (lock != null) {
                lock.readLock().unlock();
            }
        }
    }

    private static Object getByPath(Map<String, Object> doc, String path) {
        if (doc == null || path == null) {
            return null;
        }
        String[] parts = path.split("\\.");
        Object cur = doc;
        for (String p : parts) {
            if (!(cur instanceof Map)) {
                return null;
            }
            if ((cur = cur.get(p)) != null) continue;
            return null;
        }
        return cur;
    }

    private static boolean containsByPath(Map<String, Object> doc, String path) {
        if (doc == null || path == null) {
            return false;
        }
        String[] parts = path.split("\\.");
        Map cur = doc;
        for (int i = 0; i < parts.length - 1; ++i) {
            String p = parts[i];
            if (!cur.containsKey(p) || !(cur.get(p) instanceof Map)) {
                return false;
            }
            cur = (Map)cur.get(p);
        }
        return cur.containsKey(parts[parts.length - 1]);
    }

    private static void setByPath(Map<String, Object> target, String path, Object value) {
        String[] parts = path.split("\\.");
        Map cur = target;
        for (int i = 0; i < parts.length - 1; ++i) {
            HashMap n = cur.get(parts[i]);
            if (!(n instanceof Map)) {
                n = new HashMap();
                cur.put(parts[i], n);
            }
            cur = n;
        }
        cur.put((String)parts[parts.length - 1], (Object)value);
    }

    private static void removeByPath(Map<String, Object> target, String path) {
        String[] parts = path.split("\\.");
        Map cur = target;
        for (int i = 0; i < parts.length - 1; ++i) {
            Object n = cur.get(parts[i]);
            if (!(n instanceof Map)) {
                return;
            }
            cur = (Map)n;
        }
        cur.remove(parts[parts.length - 1]);
    }

    private static Map<String, Object> deepCopyDoc(Map<String, Object> src) {
        HashMap<String, Object> out = new HashMap<String, Object>();
        for (Map.Entry<String, Object> e : src.entrySet()) {
            Map<String, Object> v = e.getValue();
            if (v instanceof Map) {
                v = InMemoryDriver.deepCopyDoc(v);
            } else if (v instanceof List) {
                v = InMemoryDriver.deepCopyList((List)((Object)v));
            }
            out.put(e.getKey(), v);
        }
        return out;
    }

    private static List deepCopyList(List src) {
        ArrayList<Object> out = new ArrayList<Object>();
        for (Object item : src) {
            if (item instanceof Map) {
                out.add(InMemoryDriver.deepCopyDoc((Map)item));
                continue;
            }
            if (item instanceof List) {
                out.add(InMemoryDriver.deepCopyList((List)item));
                continue;
            }
            out.add(item);
        }
        return out;
    }

    private static Object applySlice(Object arrayVal, Object sliceSpec) {
        if (!(arrayVal instanceof List)) {
            return null;
        }
        List lst = (List)arrayVal;
        if (sliceSpec instanceof Number) {
            int n = ((Number)sliceSpec).intValue();
            if (n >= 0) {
                return new ArrayList(lst.subList(0, Math.min(n, lst.size())));
            }
            int from = Math.max(0, lst.size() + n);
            return new ArrayList(lst.subList(from, lst.size()));
        }
        if (sliceSpec instanceof List && ((List)sliceSpec).size() == 2) {
            Object s0 = ((List)sliceSpec).get(0);
            Object s1 = ((List)sliceSpec).get(1);
            if (s0 instanceof Number && s1 instanceof Number) {
                int skip = ((Number)s0).intValue();
                int lim = ((Number)s1).intValue();
                int from = Math.max(0, Math.min(skip, lst.size()));
                int to = Math.max(from, Math.min(from + lim, lst.size()));
                return new ArrayList(lst.subList(from, to));
            }
        }
        return null;
    }

    private static Object applyElemMatchProjection(String field, Object arrayVal, Map<String, Object> cond) {
        if (!(arrayVal instanceof List)) {
            return null;
        }
        List lst = (List)arrayVal;
        for (Object el : lst) {
            boolean matches;
            if (el instanceof Map) {
                matches = QueryHelper.matchesQuery(cond, (Map)el, null);
            } else {
                Doc wrapper = Doc.of("value", el);
                matches = QueryHelper.matchesQuery(Doc.of("value", cond), wrapper, null);
            }
            if (!matches) continue;
            return new ArrayList(List.of(el));
        }
        return new ArrayList();
    }

    private List<Map<String, Object>> getDataFromIndex(String db, String collection, Map<String, Object> query) {
        List<Map<String, Object>> ret = null;
        int bucketId = 0;
        StringBuilder fieldList = new StringBuilder();
        for (Map<String, Object> idx : this.getIndexes(db, collection)) {
            if (idx.size() > query.size()) continue;
            boolean found = true;
            bucketId = 0;
            fieldList.setLength(0);
            for (String k : query.keySet()) {
                if (!idx.containsKey(k)) {
                    found = false;
                    break;
                }
                Object value = query.get(k);
                bucketId = this.iterateBucketId(bucketId, value);
                fieldList.append(k);
            }
            if (!found) continue;
            String fields = fieldList.toString();
            Map<Integer, List<Map<String, Object>>> indexDataForCollection = this.getIndexDataForCollection(db, collection, fields);
            ret = indexDataForCollection.get(bucketId);
            if (ret != null && ret.size() != 0) break;
            ret = new ArrayList<Map<String, Object>>();
            for (Map.Entry<Integer, List<Map<String, Object>>> k : indexDataForCollection.entrySet()) {
                for (Map<String, Object> o : k.getValue()) {
                    if (!QueryHelper.matchesQuery(query, o, null)) continue;
                    ret.add(o);
                }
            }
            if (ret.size() != 0) break;
            ret = null;
            break;
        }
        return ret;
    }

    public long count(String db, String collection, Map<String, Object> query, Collation collation, ReadPreference rp) throws MorphiumDriverException {
        List<Map<String, Object>> d = this.getCollection(db, collection);
        CopyOnWriteArrayList<Map<String, Object>> data = new CopyOnWriteArrayList<Map<String, Object>>(d);
        if (query.isEmpty()) {
            return data.size();
        }
        long cnt = 0L;
        for (Map map : data) {
            if (!QueryHelper.matchesQuery(query, map, collation == null ? null : collation.toQueryObject())) continue;
            ++cnt;
        }
        return cnt;
    }

    public long estimatedDocumentCount(String db, String collection, ReadPreference rp) throws MorphiumDriverException {
        return this.getCollection(db, collection).size();
    }

    public List<Map<String, Object>> findByFieldValue(String db, String coll, String field, Object value) throws MorphiumDriverException {
        ArrayList<Map<String, Object>> ret = new ArrayList<Map<String, Object>>();
        CopyOnWriteArrayList<Map<String, Object>> data = new CopyOnWriteArrayList<Map<String, Object>>(this.getCollection(db, coll));
        for (Map map : data) {
            HashMap<String, MorphiumId> add;
            if (value == null) {
                if (!map.containsKey(field) || map.get(field) != null) continue;
                add = new HashMap<String, MorphiumId>(map);
                if (add.get("_id") instanceof ObjectId) {
                    add.put("_id", new MorphiumId((ObjectId)add.get("_id")));
                }
                ret.add(add);
                continue;
            }
            if (!map.containsKey(field) || !Objects.equals(map.get(field), value)) continue;
            add = new HashMap(map);
            if (add.get("_id") instanceof ObjectId) {
                add.put("_id", new MorphiumId((ObjectId)add.get("_id")));
            }
            ret.add(add);
        }
        return ret;
    }

    public Map<Integer, List<Map<String, Object>>> getIndexDataForCollection(String db, String collection, String fields) {
        this.indexDataByDBCollection.putIfAbsent(db, new ConcurrentHashMap());
        this.indexDataByDBCollection.get(db).putIfAbsent(collection, new ConcurrentHashMap());
        this.indexDataByDBCollection.get(db).get(collection).putIfAbsent(fields, new HashMap());
        return this.indexDataByDBCollection.get(db).get(collection).get(fields);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Map<String, Object>> insert(String db, String collection, List<Map<String, Object>> objs, Map<String, Object> wc) throws MorphiumDriverException {
        ArrayList<Map<String, Object>> writeErrors;
        this.log.debug("insert() called: db={}, coll={}, thread={}", new Object[]{db, collection, Thread.currentThread().getName()});
        ReadWriteLock lock = this.getCollectionLock(db, collection);
        lock.writeLock().lock();
        ArrayList<Map<String, Object>> docSnapshots = new ArrayList<Map<String, Object>>();
        try {
            int errors = 0;
            objs = new ArrayList<Map<String, Object>>(objs);
            writeErrors = new ArrayList<Map<String, Object>>();
            List<Map<String, Object>> list = this.getIndexes(db, collection);
            if (list != null && !list.isEmpty()) {
                for (Map<String, Object> idx : list) {
                    Object options;
                    if (!idx.containsKey("$options") || !(options = (Map)idx.get("$options")).containsKey("unique") || !options.get("unique").equals("true") && !options.get("unique").equals(true)) continue;
                    HashMap<String, Object> indexKey = new HashMap<String, Object>(idx);
                    for (Map<String, Object> o : objs) {
                        Doc q = Doc.of();
                        for (Object k : indexKey.keySet()) {
                            if (((String)k).startsWith("$")) continue;
                            q.put(k, o.get(k));
                        }
                        if (q.size() != 1) {
                            Object k;
                            ArrayList<Doc> and = new ArrayList<Doc>();
                            k = q.entrySet().iterator();
                            while (k.hasNext()) {
                                Map.Entry e = (Map.Entry)k.next();
                                and.add(Doc.of((String)e.getKey(), e.getValue()));
                            }
                            q = Doc.of("$and", and);
                        }
                        if (this.find(db, collection, q, null, null, 0, 0).size() <= 0) continue;
                        this.log.error("Cannot store - unique index!");
                        writeErrors.add(o);
                    }
                    errors += writeErrors.size();
                    objs.removeAll(writeErrors);
                }
            }
            List<Map<String, Object>> collectionData = this.getCollection(db, collection);
            HashSet<Object> existingIds = new HashSet<Object>();
            for (Map<String, Object> existing : collectionData) {
                Object id = existing.get("_id");
                if (id == null) continue;
                existingIds.add(id);
            }
            for (Map<String, Object> o : objs) {
                if (o.get("_id") != null && existingIds.contains(o.get("_id"))) {
                    throw new MorphiumDriverException("Duplicate _id! " + String.valueOf(o.get("_id")), null);
                }
                o.putIfAbsent("_id", new ObjectId());
            }
            if (this.cappedCollections.containsKey(db) && this.cappedCollections.get(db).containsKey(collection)) {
                while (!collectionData.isEmpty() && this.cappedCollections.get(db).get(collection).containsKey("max") && this.cappedCollections.get(db).get(collection).get("max") < collectionData.size() + objs.size()) {
                    collectionData.remove(0);
                }
                while (collectionData.size() > 0 && (long)this.cappedCollections.get(db).get(collection).get("size").intValue() < VM.current().sizeOf(collectionData) + VM.current().sizeOf(objs)) {
                    collectionData.remove(0);
                }
                while (objs.size() > 0 && this.cappedCollections.get(db).get(collection).containsKey("max") && collectionData.size() + objs.size() > this.cappedCollections.get(db).get(collection).get("max")) {
                    objs.remove(0);
                }
                while (objs.size() > 0 && this.cappedCollections.get(db).get(collection).containsKey("size") && VM.current().sizeOf(collectionData) + VM.current().sizeOf((Object)objs.size()) > (long)this.cappedCollections.get(db).get(collection).get("size").intValue()) {
                    objs.remove(0);
                }
            }
            collectionData.addAll(objs);
            for (int i = 0; i < objs.size(); ++i) {
                Map<String, Object> o;
                o = objs.get(i);
                List<Map<String, Object>> idx = list;
                this.indexDataByDBCollection.putIfAbsent(db, new ConcurrentHashMap());
                this.indexDataByDBCollection.get(db).putIfAbsent(collection, new ConcurrentHashMap());
                Map<String, Map<Integer, List<Map<String, Object>>>> indexData = this.indexDataByDBCollection.get(db).get(collection);
                for (Map<String, Object> ix : idx) {
                    int bucketId = 0;
                    StringBuilder fieldNames = new StringBuilder();
                    for (String k : ix.keySet()) {
                        bucketId = this.iterateBucketId(bucketId, o.get(k));
                        fieldNames.append(k);
                    }
                    String fn = fieldNames.toString();
                    indexData.putIfAbsent(fn, new HashMap());
                    indexData.get(fn).putIfAbsent(bucketId, new ArrayList());
                    indexData.get(fn).get(bucketId).add(o);
                }
                int buckedId = this.iterateBucketId(0, o.get("_id"));
                indexData.putIfAbsent("_id", new HashMap());
                indexData.get("_id").putIfAbsent(buckedId, new ArrayList());
                indexData.get("_id").get(buckedId).add(o);
            }
            for (Map<String, Object> o : objs) {
                docSnapshots.add(InMemoryDriver.deepCopyDoc(o));
            }
        }
        finally {
            lock.writeLock().unlock();
        }
        for (Map map : docSnapshots) {
            this.notifyWatchers(db, collection, "insert", map);
        }
        return writeErrors;
    }

    private Integer iterateBucketId(int bucketId, Object o) {
        if (o == null) {
            return bucketId + 1;
        }
        return bucketId + o.hashCode();
    }

    private static boolean truthy(Object v) {
        if (v == null) {
            return true;
        }
        if (v instanceof Number) {
            return ((Number)v).intValue() != 0;
        }
        if (v instanceof Boolean) {
            return (Boolean)v;
        }
        return true;
    }

    private static String camelToSnakeCase(String camelCase) {
        if (camelCase == null) {
            return null;
        }
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < camelCase.length(); ++i) {
            char c = camelCase.charAt(i);
            if (Character.isUpperCase(c)) {
                result.append('_').append(Character.toLowerCase(c));
                continue;
            }
            result.append(c);
        }
        return result.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Integer> store(String db, String collection, List<Map<String, Object>> objs, Map<String, Object> wc) throws MorphiumDriverException {
        Map<String, Integer> result;
        ReadWriteLock lock = this.getCollectionLock(db, collection);
        lock.writeLock().lock();
        ArrayList<PendingNotification> pendingNotifications = new ArrayList<PendingNotification>();
        try {
            result = this.storeInternal(db, collection, objs, wc, pendingNotifications);
        }
        finally {
            lock.writeLock().unlock();
        }
        for (PendingNotification notification : pendingNotifications) {
            this.notifyWatchers(notification.db, notification.collection, notification.op, notification.doc, notification.updatedFields, notification.removedFields, notification.beforeDocument);
        }
        return result;
    }

    private Map<String, Integer> storeInternal(String db, String collection, List<Map<String, Object>> objs, Map<String, Object> wc, List<PendingNotification> pendingNotifications) throws MorphiumDriverException {
        HashMap<String, Integer> ret = new HashMap<String, Integer>();
        int upd = 0;
        int inserted = 0;
        int total = objs.size();
        for (Map<String, Object> o : objs) {
            if (o.get("_id") == null) {
                o.put("_id", new MorphiumId());
                this.enforceUniqueOrThrow(db, collection, o);
                this.getCollection(db, collection).add(o);
                pendingNotifications.add(new PendingNotification(db, collection, "insert", o));
                ++inserted;
                continue;
            }
            List<Map<String, Object>> srch = this.findByFieldValue(db, collection, "_id", o.get("_id"));
            if (!srch.isEmpty()) {
                Map<String, Object> previous = InMemoryDriver.deepCopyDoc(srch.get(0));
                this.getCollection(db, collection).remove(srch.get(0));
                this.enforceUniqueOrThrow(db, collection, o);
                ++upd;
                pendingNotifications.add(new PendingNotification(db, collection, "replace", o, null, null, previous));
            } else {
                this.enforceUniqueOrThrow(db, collection, o);
                pendingNotifications.add(new PendingNotification(db, collection, "insert", o));
                ++inserted;
            }
            this.getCollection(db, collection).add(o);
            List<Map<String, Object>> idx = this.getIndexes(db, collection);
            int bucketId = 0;
            StringBuilder fields = new StringBuilder();
            for (Map<String, Object> i : idx) {
                for (String k : i.keySet()) {
                    bucketId = this.iterateBucketId(bucketId, o.get(k));
                    fields.append(k);
                }
                this.indexDataByDBCollection.putIfAbsent(db, new ConcurrentHashMap());
                this.indexDataByDBCollection.get(db).putIfAbsent(collection, new ConcurrentHashMap());
                this.indexDataByDBCollection.get(db).get(collection).putIfAbsent(fields.toString(), new HashMap());
                this.indexDataByDBCollection.get(db).get(collection).get(fields.toString()).putIfAbsent(bucketId, new ArrayList());
                this.indexDataByDBCollection.get(db).get(collection).get(fields.toString()).get(bucketId).add(o);
            }
        }
        ret.put("matched", upd);
        ret.put("updated", upd);
        ret.put("inserted", inserted);
        ret.put("n", upd + inserted);
        return ret;
    }

    private Map<String, List<Map<String, Object>>> getDB(String db) {
        if (this.currentTransaction.get() == null) {
            this.database.putIfAbsent(db, new ConcurrentHashMap());
            return this.database.get(db);
        }
        this.currentTransaction.get().getDatabase().putIfAbsent(db, new ConcurrentHashMap());
        return (Map)this.currentTransaction.get().getDatabase().get(db);
    }

    @Override
    public void closeIteration(MorphiumCursor crs) {
    }

    @Override
    public Map<String, Object> killCursors(String db, String coll, long ... ids) throws MorphiumDriverException {
        for (long i : ids) {
            this.cursors.remove(i);
        }
        return this.prepareResult();
    }

    @Override
    public OpMsg readNextMessage(int timeout) throws MorphiumDriverException {
        OpMsg msg = new OpMsg();
        msg.setMessageId(0);
        HashMap<String, Object> o = new HashMap<String, Object>(this.commandResults.remove(0));
        msg.setFirstDoc(o);
        return msg;
    }

    @Override
    public Map<String, Object> readSingleAnswer(int id) throws MorphiumDriverException {
        if (this.commandResults.isEmpty()) {
            return null;
        }
        return this.commandResults.remove(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Object> update(String db, String collection, Map<String, Object> query, Map<String, Object> sort, Map<String, Object> op, boolean multiple, boolean upsert, Map<String, Object> collation, Map<String, Object> wc) throws MorphiumDriverException {
        Map<String, Object> result;
        ReadWriteLock lock = this.getCollectionLock(db, collection);
        lock.writeLock().lock();
        ArrayList<PendingNotification> pendingNotifications = new ArrayList<PendingNotification>();
        try {
            result = this.updateInternal(db, collection, query, sort, op, multiple, upsert, collation, wc, pendingNotifications);
        }
        finally {
            lock.writeLock().unlock();
        }
        for (PendingNotification notification : pendingNotifications) {
            this.notifyWatchers(notification.db, notification.collection, notification.op, notification.doc, notification.updatedFields, notification.removedFields, notification.beforeDocument);
        }
        return result;
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    private Map<String, Object> updateInternal(String db, String collection, Map<String, Object> query, Map<String, Object> sort, Map<String, Object> op, boolean multiple, boolean upsert, Map<String, Object> collation, Map<String, Object> wc, List<PendingNotification> pendingNotifications) throws MorphiumDriverException {
        lst = this.find(db, collection, query, sort, null, collation, 0, multiple != false ? 0 : 1, true);
        matchedCount = lst == null ? 0 : lst.size();
        insert = false;
        count = false;
        if (lst == null) {
            lst = new ArrayList<Map<String, Object>>();
        }
        if (upsert && lst.isEmpty()) {
            lst.add(new HashMap<K, V>());
            for (String k : query.keySet()) {
                if (k.startsWith("$")) continue;
                if (query.get(k) != null) {
                    lst.get(0).put(k, query.get(k));
                    continue;
                }
                lst.get(0).remove(k);
            }
            insert = true;
        }
        modified = new HashSet<Object>();
        upsertedIds = new ArrayList<Object>();
        modifiedCount = 0;
        for (Map obj : lst) {
            original = this.deepClone(obj);
            if (original == null) {
                original = new HashMap<String, Object>(obj);
            }
            block38: for (String operand : op.keySet()) {
                cmd = (Map)op.get(operand);
                var24_27 = operand;
                var25_28 = -1;
                switch (var24_27.hashCode()) {
                    case 1186238: {
                        if (!var24_27.equals("$set")) break;
                        var25_28 = 0;
                        break;
                    }
                    case 1142092165: {
                        if (!var24_27.equals("$unset")) break;
                        var25_28 = 1;
                        break;
                    }
                    case 1176890: {
                        if (!var24_27.equals("$inc")) break;
                        var25_28 = 2;
                        break;
                    }
                    case 952761891: {
                        if (!var24_27.equals("$currentDate")) break;
                        var25_28 = 3;
                        break;
                    }
                    case 1180960: {
                        if (!var24_27.equals("$mul")) break;
                        var25_28 = 4;
                        break;
                    }
                    case 950766690: {
                        if (!var24_27.equals("$rename")) break;
                        var25_28 = 5;
                        break;
                    }
                    case 1180590: {
                        if (!var24_27.equals("$min")) break;
                        var25_28 = 6;
                        break;
                    }
                    case 1180352: {
                        if (!var24_27.equals("$max")) break;
                        var25_28 = 7;
                        break;
                    }
                    case 36699241: {
                        if (!var24_27.equals("$pull")) break;
                        var25_28 = 8;
                        break;
                    }
                    case -1909505928: {
                        if (!var24_27.equals("$pullAll")) break;
                        var25_28 = 9;
                        break;
                    }
                    case 1183661: {
                        if (!var24_27.equals("$pop")) break;
                        var25_28 = 10;
                        break;
                    }
                    case -1890005014: {
                        if (!var24_27.equals("$addToSet")) break;
                        var25_28 = 11;
                        break;
                    }
                    case 36699454: {
                        if (!var24_27.equals("$push")) break;
                        var25_28 = 12;
                        break;
                    }
                    case -1903160445: {
                        if (!var24_27.equals("$pushAll")) break;
                        var25_28 = 13;
                    }
                }
                switch (var25_28) {
                    case 0: {
                        for (Map.Entry<K, V> entry : cmd.entrySet()) {
                            v /* !! */  = entry.getValue();
                            if (v /* !! */  instanceof Map) {
                                try {
                                    v /* !! */  = Expr.parse(v /* !! */ ).evaluate(obj);
                                }
                                catch (Exception var29_33) {
                                    // empty catch block
                                }
                            }
                            if (!((String)entry.getKey()).contains(".")) ** GOTO lbl117
                            path = ((String)entry.getKey()).split("\\.");
                            current = obj;
                            lastEl = null;
                            for (String p : path) {
                                if (current.get(p) == null) ** GOTO lbl109
                                if (current.get(p) instanceof Map) {
                                    ((Map)current.get(p)).put(p, Doc.of());
                                } else {
                                    this.log.error("could not set value! " + p);
                                    break;
lbl109:
                                    // 1 sources

                                    current.put((String)p, (Object)Doc.of());
                                }
                                lastEl = current;
                                current = (Map)current.get(p);
                            }
                            lastEl.put(path[path.length - 1], v /* !! */ );
                            continue;
lbl117:
                            // 1 sources

                            obj.put((String)((String)entry.getKey()), v /* !! */ );
                        }
                        continue block38;
                    }
                    case 1: {
                        for (Map.Entry<K, V> entry : cmd.entrySet()) {
                            obj.remove(entry.getKey());
                        }
                        continue block38;
                    }
                    case 2: {
                        for (Map.Entry<K, V> entry : cmd.entrySet()) {
                            value = obj.get(entry.getKey());
                            if (value == null) {
                                value = 0;
                            }
                            if (value instanceof Integer) {
                                if (entry.getValue() instanceof Integer) {
                                    value = (Integer)value + (Integer)entry.getValue();
                                } else if (entry.getValue() instanceof Float) {
                                    value = Float.valueOf((float)((Integer)value).intValue() + ((Float)entry.getValue()).floatValue());
                                } else if (entry.getValue() instanceof Double) {
                                    value = (double)((Integer)value).intValue() + (Double)entry.getValue();
                                } else if (entry.getValue() instanceof Long) {
                                    value = (long)((Integer)value).intValue() + (Long)entry.getValue();
                                }
                            } else if (value instanceof Double) {
                                if (entry.getValue() instanceof Integer) {
                                    value = (Double)value + (double)((Integer)entry.getValue()).intValue();
                                } else if (entry.getValue() instanceof Float) {
                                    value = (Double)value + (double)((Float)entry.getValue()).floatValue();
                                } else if (entry.getValue() instanceof Double) {
                                    value = (Double)value + (Double)entry.getValue();
                                } else if (entry.getValue() instanceof Long) {
                                    value = (Double)value + (double)((Long)entry.getValue()).longValue();
                                }
                            } else if (value instanceof Float) {
                                if (entry.getValue() instanceof Integer) {
                                    value = Float.valueOf(((Float)value).floatValue() + (float)((Integer)entry.getValue()).intValue());
                                } else if (entry.getValue() instanceof Float) {
                                    value = Float.valueOf(((Float)value).floatValue() + ((Float)entry.getValue()).floatValue());
                                } else if (entry.getValue() instanceof Double) {
                                    value = (double)((Float)value).floatValue() + (Double)entry.getValue();
                                } else if (entry.getValue() instanceof Long) {
                                    value = Float.valueOf(((Float)value).floatValue() + (float)((Long)entry.getValue()).longValue());
                                }
                            } else if (value instanceof Long) {
                                if (entry.getValue() instanceof Integer) {
                                    value = (Long)value + (long)((Integer)entry.getValue()).intValue();
                                } else if (entry.getValue() instanceof Float) {
                                    value = Float.valueOf((float)((Long)value).longValue() + ((Float)entry.getValue()).floatValue());
                                } else if (entry.getValue() instanceof Double) {
                                    value = (double)((Long)value).longValue() + (Double)entry.getValue();
                                } else if (entry.getValue() instanceof Long) {
                                    value = (Long)value + (Long)entry.getValue();
                                }
                            }
                            currentValue = obj.get(entry.getKey());
                            if (!Objects.equals(currentValue, value)) {
                                modified.add(obj.get("_id"));
                            }
                            if (value != null) {
                                obj.put((String)((String)entry.getKey()), (Object)value);
                                continue;
                            }
                            obj.remove(entry.getKey());
                        }
                        continue block38;
                    }
                    case 3: {
                        obj.put((String)((String)cmd.keySet().toArray()[0]), (Object)new Date());
                        break;
                    }
                    case 4: {
                        for (Map.Entry<K, V> entry : cmd.entrySet()) {
                            value = obj.get(entry.getKey());
                            if (value instanceof Integer) {
                                value = (Integer)value * (Integer)entry.getValue();
                            } else if (value instanceof Double) {
                                value = (Double)value * (Double)entry.getValue();
                            } else if (value instanceof Float) {
                                value = Float.valueOf(((Float)value).floatValue() * ((Float)entry.getValue()).floatValue());
                            } else if (value instanceof Long) {
                                value = (Long)value * (Long)entry.getValue();
                            }
                            currentValue = obj.get(entry.getKey());
                            if (!Objects.equals(currentValue, value)) {
                                modified.add(obj.get("_id"));
                            }
                            if (value != null) {
                                obj.put((String)((String)entry.getKey()), (Object)value);
                                continue;
                            }
                            obj.remove(entry.getKey());
                        }
                        continue block38;
                    }
                    case 5: {
                        for (Map.Entry<K, V> entry : cmd.entrySet()) {
                            if (obj.get(entry.getKey()) != null) {
                                obj.put((String)((String)entry.getValue()), (Object)obj.get(entry.getKey()));
                            } else {
                                obj.remove(entry.getValue());
                            }
                            obj.remove(entry.getKey());
                            modified.add(obj.get("_id"));
                        }
                        continue block38;
                    }
                    case 6: {
                        for (Map.Entry<K, V> entry : cmd.entrySet()) {
                            value = (Comparable)obj.get(entry.getKey());
                            if (value.compareTo(entry.getValue()) <= 0 || entry.getValue() == null) continue;
                            modified.add(obj.get("_id"));
                            obj.put((String)((String)entry.getKey()), entry.getValue());
                        }
                        continue block38;
                    }
                    case 7: {
                        for (Map.Entry<K, V> entry : cmd.entrySet()) {
                            value = (Comparable)obj.get(entry.getKey());
                            if (value.compareTo(entry.getValue()) >= 0 || entry.getValue() == null) continue;
                            obj.put((String)((String)entry.getKey()), entry.getValue());
                            modified.add(obj.get("_id"));
                        }
                        continue block38;
                    }
                    case 8: {
                        for (Map.Entry<K, V> entry : cmd.entrySet()) {
                            values = new ArrayList<E>((List)obj.get(entry.getKey()));
                            subquery = Doc.of((String)entry.getKey(), entry.getValue());
                            filteredValues = new ArrayList<E>();
                            for (E value : values) {
                                if (QueryHelper.matchesQuery(subquery, Doc.of((String)entry.getKey(), value), null)) continue;
                                filteredValues.add(value);
                            }
                            v0 = valueIsChanged = filteredValues.containsAll(values) == false || values.containsAll(filteredValues) == false;
                            if (valueIsChanged) {
                                modified.add(obj.get("_id"));
                            }
                            obj.put((String)((String)entry.getKey()), filteredValues);
                        }
                        continue block38;
                    }
                    case 9: {
                        for (Map.Entry<K, V> entry : cmd.entrySet()) {
                            v /* !! */  = new ArrayList<E>((List)obj.get(entry.getKey()));
                            objectsToBeDeleted = (List)entry.getValue();
                            valueIsChanged = objectsToBeDeleted.stream().anyMatch((Predicate<Object>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$updateInternal$0(java.util.List java.lang.Object ), (Ljava/lang/Object;)Z)(v /* !! */ ));
                            if (valueIsChanged) {
                                modified.add(obj.get("_id"));
                            }
                            v /* !! */ .removeAll(objectsToBeDeleted);
                            obj.put((String)((String)entry.getKey()), v /* !! */ );
                        }
                        continue block38;
                    }
                    case 10: {
                        for (Map.Entry<K, V> entry : cmd.entrySet()) {
                            field = (String)entry.getKey();
                            existing = field.contains(".") != false ? InMemoryDriver.getByPath(obj, field) : obj.get(field);
                            if (existing instanceof List) {
                                originalList = (List)existing;
                                if (originalList.isEmpty()) continue;
                                v = new ArrayList<E>(originalList);
                                position = ((Number)entry.getValue()).intValue();
                                if (position < 0) {
                                    v.remove(0);
                                } else {
                                    v.remove(v.size() - 1);
                                }
                                if (field.contains(".")) {
                                    InMemoryDriver.setByPath(obj, field, v);
                                } else {
                                    obj.put((String)field, v);
                                }
                                modified.add(obj.get("_id"));
                                continue;
                            }
                            if (existing == null) continue;
                            throw new MorphiumDriverException("Cannot apply $pop to non-array field '" + field + "'");
                        }
                        continue block38;
                    }
                    case 11: 
                    case 12: 
                    case 13: {
                        for (Map.Entry<K, V> entry : cmd.entrySet()) {
                            field = (String)entry.getKey();
                            created = false;
                            if (!field.contains(".")) ** GOTO lbl332
                            existing = InMemoryDriver.getByPath(obj, field);
                            if (existing == null) {
                                v = new ArrayList<E>();
                                InMemoryDriver.setByPath(obj, field, v);
                                created = true;
                            } else if (existing instanceof List) {
                                v = (List)existing;
                            } else {
                                throw new MorphiumDriverException("Cannot apply " + operand + " to non-array field '" + field + "'");
lbl332:
                                // 1 sources

                                existing = obj.get(field);
                                if (existing == null) {
                                    v = new ArrayList<E>();
                                    obj.put((String)field, v);
                                    created = true;
                                } else if (existing instanceof List) {
                                    v = (List)existing;
                                } else {
                                    throw new MorphiumDriverException("Cannot apply " + operand + " to non-array field '" + field + "'");
                                }
                            }
                            changed = created;
                            rawValue = entry.getValue();
                            valuesToAdd = new ArrayList<V>();
                            position = null;
                            slice = null;
                            if (rawValue instanceof Map && (valueMap = (Map)rawValue).containsKey("$each")) {
                                eachVal = valueMap.get("$each");
                                if (!(eachVal instanceof List)) {
                                    throw new MorphiumDriverException("$each requires an array value");
                                }
                                valuesToAdd.addAll((List)eachVal);
                                if (valueMap.containsKey("$position") && valueMap.get("$position") instanceof Number) {
                                    position = ((Number)valueMap.get("$position")).intValue();
                                }
                                if (valueMap.containsKey("$slice") && valueMap.get("$slice") instanceof Number) {
                                    slice = ((Number)valueMap.get("$slice")).intValue();
                                }
                            } else if (operand.equals("$pushAll") && rawValue instanceof List) {
                                valuesToAdd.addAll((List)rawValue);
                            } else {
                                valuesToAdd.add(rawValue);
                            }
                            if (operand.equals("$addToSet")) {
                                valueMap = valuesToAdd.iterator();
                                while (valueMap.hasNext()) {
                                    elem = valueMap.next();
                                    if (v.contains(elem)) continue;
                                    v.add(elem);
                                    changed = true;
                                }
                            } else {
                                if (position != null) {
                                    insertAt = Math.min(Math.max(position, 0), v.size());
                                    for (E elem : valuesToAdd) {
                                        v.add(insertAt++, elem);
                                    }
                                } else {
                                    v.addAll(valuesToAdd);
                                }
                                if (!valuesToAdd.isEmpty()) {
                                    changed = true;
                                }
                                if (slice != null) {
                                    if (slice >= 0) {
                                        while (v.size() > slice) {
                                            v.remove(v.size() - 1);
                                        }
                                    } else {
                                        while (v.size() > Math.abs(slice)) {
                                            v.remove(0);
                                        }
                                    }
                                }
                            }
                            if (!changed) continue;
                            modified.add(obj.get("_id"));
                        }
                        continue block38;
                    }
                    default: {
                        throw new RuntimeException("unknown operand " + operand);
                    }
                }
            }
            try {
                objChanged = Objects.equals(original, obj) == false || modified.contains(obj.get("_id")) != false;
            }
            catch (Exception ignored) {
                v1 = objChanged = modified.isEmpty() == false;
            }
            if (!insert && objChanged) {
                ++modifiedCount;
            }
            if (insert) continue;
            try {
                this.enforceUniqueOrThrow(db, collection, obj);
            }
            catch (MorphiumDriverException ex) {
                obj.clear();
                obj.putAll(original);
                throw ex;
            }
            beforeImage = InMemoryDriver.deepCopyDoc(original);
            updatedMap = this.computeUpdatedFields(original, obj);
            removedList = this.computeRemovedFields(original, obj);
            pendingNotifications.add(new PendingNotification(db, collection, "update", obj, updatedMap, removedList, beforeImage));
        }
        if (insert) {
            this.storeInternal(db, collection, lst, wc, pendingNotifications);
            for (Map<String, Object> d : lst) {
                if (d.get("_id") == null) continue;
                upsertedIds.add(d.get("_id"));
            }
        }
        this.indexDataByDBCollection.get(db).remove(collection);
        this.updateIndexData(db, collection, null);
        res = Doc.of("matched", (Object)matchedCount, "nModified", (Object)modifiedCount, "modified", (Object)modifiedCount);
        if (!upsertedIds.isEmpty()) {
            res.put("upsertedIds", upsertedIds);
        }
        return res;
    }

    private void notifyWatchers(String db, String collection, String op, Map doc) {
        this.notifyWatchers(db, collection, op, doc, null, null, null);
    }

    private void notifyWatchers(String db, String collection, String op, Map doc, Map<String, Object> updatedFields, List<String> removedFields) {
        this.notifyWatchers(db, collection, op, doc, updatedFields, removedFields, null);
    }

    private void notifyWatchers(String db, String collection, String op, Map doc, Map<String, Object> updatedFields, List<String> removedFields, Map<String, Object> beforeDocument) {
        this.log.debug("notifyWatchers called: db={}, coll={}, op={}, driver instance={}", new Object[]{db, collection, op, System.identityHashCode(this)});
        ChangeStreamEventInfo eventInfo = this.buildChangeStreamEvent(db, collection, op, doc, updatedFields, removedFields, beforeDocument);
        if (eventInfo == null) {
            this.log.debug("buildChangeStreamEvent returned null, skipping");
            return;
        }
        this.changeStreamHistory.addLast(eventInfo);
        while (this.changeStreamHistory.size() > 1024) {
            this.changeStreamHistory.pollFirst();
        }
        this.log.debug("Dispatching event for {}.{}", (Object)db, (Object)collection);
        this.dispatchEvent(eventInfo);
    }

    private ChangeStreamEventInfo buildChangeStreamEvent(String db, String collection, String op, Map doc, Map<String, Object> updatedFields, List<String> removedFields, Map<String, Object> beforeDocument) {
        Object documentKey;
        Map<String, Object> newDocument = this.cloneAndNormalizeDocument(doc);
        Map<String, Object> previousDocument = this.cloneAndNormalizeDocument(beforeDocument);
        LinkedHashMap<String, Object> event = new LinkedHashMap<String, Object>();
        long token = this.changeStreamSequence.incrementAndGet();
        event.put("_id", InMemoryDriver.createResumeToken(token));
        event.put("operationType", op);
        HashMap<String, String> ns = new HashMap<String, String>();
        ns.put("db", db);
        if (collection != null) {
            ns.put("coll", collection);
        }
        event.put("ns", ns);
        long clusterTime = System.currentTimeMillis();
        event.put("clusterTime", clusterTime);
        event.put("txnNumber", this.txn.incrementAndGet());
        if (newDocument != null) {
            event.put("fullDocument", newDocument);
        }
        if (previousDocument != null) {
            event.put("fullDocumentBeforeChange", previousDocument);
        }
        if ((documentKey = this.extractDocumentKey(newDocument, previousDocument)) != null) {
            event.put("documentKey", Doc.of("_id", documentKey));
        }
        if ("update".equals(op)) {
            Map<String, Object> updated = updatedFields != null ? updatedFields : this.computeUpdatedFields(previousDocument, newDocument);
            List<String> removed = removedFields != null ? removedFields : this.computeRemovedFields(previousDocument, newDocument);
            LinkedHashMap<String, Object> description = new LinkedHashMap<String, Object>();
            description.put("updatedFields", updated == null ? Map.of() : updated);
            description.put("removedFields", removed == null ? List.of() : removed);
            event.put("updateDescription", description);
        }
        return new ChangeStreamEventInfo(token, db, collection, Collections.unmodifiableMap(event), clusterTime);
    }

    private void dispatchEvent(ChangeStreamEventInfo eventInfo) {
        this.log.debug("dispatchEvent: db={}, coll={}, subscribers for db: {}, subscribers for {}.{}: {}", new Object[]{eventInfo.db, eventInfo.collection, this.changeStreamSubscribers.get(eventInfo.db) != null ? this.changeStreamSubscribers.get(eventInfo.db).size() : 0, eventInfo.db, eventInfo.collection, this.changeStreamSubscribers.get(eventInfo.db + "." + eventInfo.collection) != null ? this.changeStreamSubscribers.get(eventInfo.db + "." + eventInfo.collection).size() : 0});
        if (this.eventDispatcher.isShutdown()) {
            this.log.debug("InMemoryDriver is shut down, skipping change stream event dispatch");
            return;
        }
        try {
            this.eventDispatcher.execute(() -> {
                this.deliverToSubscribers((List<ChangeStreamSubscription>)this.changeStreamSubscribers.get(eventInfo.db), eventInfo);
                if (eventInfo.collection != null) {
                    this.deliverToSubscribers((List<ChangeStreamSubscription>)this.changeStreamSubscribers.get(eventInfo.db + "." + eventInfo.collection), eventInfo);
                }
            });
        }
        catch (RejectedExecutionException e) {
            this.log.debug("InMemoryDriver executor rejected task (likely shutting down), skipping event dispatch");
        }
    }

    private void deliverToSubscribers(List<ChangeStreamSubscription> subscriptions, ChangeStreamEventInfo eventInfo) {
        if (subscriptions == null || subscriptions.isEmpty()) {
            return;
        }
        for (ChangeStreamSubscription subscription : subscriptions) {
            if (!subscription.isActive() || !subscription.matches(eventInfo)) continue;
            subscription.deliver(eventInfo);
            if (subscription.isActive()) continue;
            this.unregisterSubscription(subscription);
        }
    }

    private void registerSubscription(ChangeStreamSubscription subscription) {
        String namespaceKey;
        subscription.namespaceKey = namespaceKey = subscription.collection == null ? subscription.db : subscription.db + "." + subscription.collection;
        this.log.debug("registerSubscription: namespaceKey={}, driver instance={}", (Object)namespaceKey, (Object)System.identityHashCode(this));
        this.changeStreamSubscribers.computeIfAbsent(namespaceKey, k -> new CopyOnWriteArrayList()).add(subscription);
        this.log.debug("After registration, subscribers for {}: {}", (Object)namespaceKey, (Object)this.changeStreamSubscribers.get(namespaceKey).size());
    }

    private void unregisterSubscription(ChangeStreamSubscription subscription) {
        if (subscription.namespaceKey == null) {
            return;
        }
        List subs = this.changeStreamSubscribers.get(subscription.namespaceKey);
        if (subs != null) {
            subs.remove(subscription);
            if (subs.isEmpty()) {
                this.changeStreamSubscribers.remove(subscription.namespaceKey);
            }
        }
        subscription.deactivate();
    }

    private void replayHistory(ChangeStreamSubscription subscription, long startingToken) {
        for (ChangeStreamEventInfo info : this.changeStreamHistory) {
            if (info.token <= startingToken || !subscription.matches(info)) continue;
            subscription.deliver(info);
            if (subscription.isActive()) continue;
            break;
        }
    }

    private static Long extractResumeToken(Map<String, Object> tokenDocument) {
        if (tokenDocument == null) {
            return null;
        }
        Object data = tokenDocument.get("_data");
        if (data instanceof String) {
            String str = (String)data;
            try {
                return Long.parseUnsignedLong(str, 16);
            }
            catch (NumberFormatException ignored) {
                return null;
            }
        }
        if (data instanceof Number) {
            Number num = (Number)data;
            return num.longValue();
        }
        return null;
    }

    private static Map<String, Object> createResumeToken(long token) {
        return Doc.of("_data", String.format(Locale.ROOT, "%016x", token));
    }

    private Map<String, Object> cloneAndNormalizeDocument(Map<String, Object> source) {
        if (source == null) {
            return null;
        }
        Map<String, Object> copy = InMemoryDriver.deepCopyDoc(source);
        if (copy.containsKey("_id")) {
            copy.put("_id", this.normalizeId(copy.get("_id")));
        }
        return copy;
    }

    private Object extractDocumentKey(Map<String, Object> newDocument, Map<String, Object> previousDocument) {
        Object id;
        Object object = id = newDocument != null ? newDocument.get("_id") : null;
        if (id == null && previousDocument != null) {
            id = previousDocument.get("_id");
        }
        return this.normalizeId(id);
    }

    private Object normalizeId(Object value) {
        if (value instanceof MorphiumId || value == null) {
            return value;
        }
        if (value instanceof ObjectId) {
            ObjectId objectId = (ObjectId)value;
            return new MorphiumId(objectId);
        }
        return value;
    }

    private Map<String, Object> computeUpdatedFields(Map<String, Object> previousDocument, Map<String, Object> newDocument) {
        if (newDocument == null) {
            return Map.of();
        }
        Map<String, Object> beforeFlat = this.flattenDocument(previousDocument);
        Map<String, Object> afterFlat = this.flattenDocument(newDocument);
        LinkedHashMap<String, Object> updated = new LinkedHashMap<String, Object>();
        for (Map.Entry<String, Object> entry : afterFlat.entrySet()) {
            Object previous;
            if ("_id".equals(entry.getKey()) || Objects.equals(previous = beforeFlat.get(entry.getKey()), entry.getValue())) continue;
            updated.put(entry.getKey(), entry.getValue());
        }
        return updated;
    }

    private List<String> computeRemovedFields(Map<String, Object> previousDocument, Map<String, Object> newDocument) {
        if (previousDocument == null) {
            return List.of();
        }
        Map<String, Object> beforeFlat = this.flattenDocument(previousDocument);
        Map<String, Object> afterFlat = this.flattenDocument(newDocument);
        ArrayList<String> removed = new ArrayList<String>();
        for (String key : beforeFlat.keySet()) {
            if ("_id".equals(key) || afterFlat.containsKey(key)) continue;
            removed.add(key);
        }
        return removed;
    }

    private Map<String, Object> flattenDocument(Map<String, Object> document) {
        LinkedHashMap<String, Object> flattened = new LinkedHashMap<String, Object>();
        if (document == null) {
            return flattened;
        }
        for (Map.Entry<String, Object> entry : document.entrySet()) {
            this.flattenValue(flattened, entry.getKey(), entry.getValue());
        }
        return flattened;
    }

    private void flattenValue(Map<String, Object> target, String prefix, Object value) {
        if (value instanceof Map) {
            Map map = (Map)value;
            if (map.isEmpty()) {
                target.put(prefix, Map.of());
            }
            for (Map.Entry entry : map.entrySet()) {
                if (entry.getKey() == null) continue;
                String newPrefix = prefix == null || prefix.isEmpty() ? entry.getKey().toString() : prefix + "." + String.valueOf(entry.getKey());
                this.flattenValue(target, newPrefix, entry.getValue());
            }
            return;
        }
        if (value instanceof List) {
            List list = (List)value;
            if (list.isEmpty()) {
                target.put(prefix, List.of());
                return;
            }
            for (int i = 0; i < list.size(); ++i) {
                String newPrefix = prefix + "." + i;
                this.flattenValue(target, newPrefix, list.get(i));
            }
            return;
        }
        target.put(prefix, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Object> delete(String db, String collection, Map<String, Object> query, Map<String, Object> sort, boolean multiple, Map<String, Object> collation, WriteConcern wc) throws MorphiumDriverException {
        ReadWriteLock lock = this.getCollectionLock(db, collection);
        lock.writeLock().lock();
        try {
            ArrayList<Map<String, Object>> toDel = new ArrayList<Map<String, Object>>(this.find(db, collection, query, null, UtilsMap.of("_id", 1), collation, 0, multiple ? 0 : 1, true));
            int deleted = 0;
            for (Map map : toDel) {
                for (Map<String, Object> dat : new ArrayList<Map<String, Object>>(this.getCollection(db, collection))) {
                    ArrayList lst;
                    Map<Integer, List<Map<String, Object>>> id;
                    if (dat.get("_id") instanceof ObjectId || dat.get("_id") instanceof MorphiumId) {
                        if (!dat.get("_id").toString().equals(map.get("_id").toString())) continue;
                        this.getCollection(db, collection).remove(dat);
                        ++deleted;
                        for (String keys : this.indexDataByDBCollection.get(db).get(collection).keySet()) {
                            id = this.getIndexDataForCollection(db, collection, keys);
                            for (int bucketId : id.keySet()) {
                                lst = new ArrayList(id.get(bucketId));
                                for (Map objectMap : lst) {
                                    if (!objectMap.get("_id").toString().equals(map.get("_id").toString())) continue;
                                    id.get(bucketId).remove(objectMap);
                                }
                            }
                        }
                        continue;
                    }
                    if (!dat.get("_id").equals(map.get("_id"))) continue;
                    this.getCollection(db, collection).remove(dat);
                    ++deleted;
                    for (String keys : this.indexDataByDBCollection.get(db).get(collection).keySet()) {
                        id = this.getIndexDataForCollection(db, collection, keys);
                        for (int bucketId : id.keySet()) {
                            lst = new ArrayList(id.get(bucketId));
                            for (Map objectMap : lst) {
                                if (!objectMap.get("_id").equals(map.get("_id"))) continue;
                                id.get(bucketId).remove(objectMap);
                            }
                        }
                    }
                }
                this.notifyWatchers(db, collection, "delete", map, null, null, map);
            }
            Doc doc = Doc.of("n", (Object)deleted, "ok", (Object)1.0);
            return doc;
        }
        finally {
            lock.writeLock().unlock();
        }
    }

    private List<Map<String, Object>> getCollection(String db, String collection) throws MorphiumDriverException {
        Map<String, List<Map<String, Object>>> dbMap = this.getDB(db);
        if (!dbMap.containsKey(collection)) {
            dbMap.put(collection, new CopyOnWriteArrayList());
            try {
                this.createIndex(db, collection, Doc.of("_id", (Object)1), Doc.of("name", "_id_1"));
            }
            catch (MorphiumDriverException morphiumDriverException) {
                // empty catch block
            }
        }
        return dbMap.get(collection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drop(String db, String collection, WriteConcern wc) {
        ReadWriteLock lock = this.getCollectionLock(db, collection);
        lock.writeLock().lock();
        try {
            this.getDB(db).remove(collection);
            if (this.indexDataByDBCollection.containsKey(db)) {
                this.indexDataByDBCollection.get(db).remove(collection);
            }
            if (this.indicesByDbCollection.containsKey(db)) {
                this.indicesByDbCollection.get(db).remove(collection);
            }
            this.notifyWatchers(db, collection, "drop", null);
        }
        finally {
            lock.writeLock().unlock();
        }
    }

    public synchronized void drop(String db, WriteConcern wc) {
        this.database.remove(db);
        if (this.indexDataByDBCollection.containsKey(db)) {
            this.indexDataByDBCollection.remove(db);
        }
        if (this.indicesByDbCollection.containsKey(db)) {
            this.indicesByDbCollection.remove(db);
        }
        this.notifyWatchers(db, null, "drop", null);
    }

    @Override
    public boolean exists(String db) {
        return this.database.containsKey(db);
    }

    @Override
    public int getMaxConnectionLifetime() {
        return 0;
    }

    @Override
    public void setMaxConnectionLifetime(int timeout) {
    }

    @Override
    public int getMaxConnectionIdleTime() {
        return 0;
    }

    @Override
    public void setMaxConnectionIdleTime(int time) {
    }

    @Override
    public int getConnectionTimeout() {
        return 0;
    }

    @Override
    public void setConnectionTimeout(int timeout) {
    }

    @Override
    public int getDefaultW() {
        return 0;
    }

    @Override
    public void setDefaultW(int w) {
    }

    @Override
    public int getHeartbeatFrequency() {
        return 0;
    }

    @Override
    public void setHeartbeatFrequency(int heartbeatFrequency) {
    }

    @Override
    public ReadPreference getDefaultReadPreference() {
        return null;
    }

    @Override
    public void setDefaultReadPreference(ReadPreference rp) {
    }

    @Override
    public int getDefaultBatchSize() {
        return 0;
    }

    @Override
    public void setDefaultBatchSize(int defaultBatchSize) {
    }

    @Override
    public boolean isUseSSL() {
        return false;
    }

    @Override
    public void setUseSSL(boolean useSSL) {
    }

    @Override
    public boolean isDefaultJ() {
        return false;
    }

    @Override
    public void setDefaultJ(boolean j) {
    }

    public List<Object> distinct(String db, String collection, String field, Map<String, Object> filter, Map<String, Object> collation) throws MorphiumDriverException {
        List<Map<String, Object>> list = this.find(db, collection, filter, null, null, 0, 0);
        HashSet<Object> distinctValues = new HashSet<Object>();
        if (list != null && !list.isEmpty()) {
            for (Map<String, Object> doc : list) {
                if (doc == null || doc.isEmpty() || doc.get(field) == null) continue;
                distinctValues.add(doc.get(field));
            }
        }
        return Collections.synchronizedList(new ArrayList(distinctValues));
    }

    @Override
    public boolean exists(String db, String collection) {
        return this.getDB(db) != null && this.getDB(db).containsKey(collection);
    }

    private Map<String, List<Map<String, Object>>> getIndexesForDB(String db) {
        this.indicesByDbCollection.putIfAbsent(db, new ConcurrentHashMap());
        return this.indicesByDbCollection.get(db);
    }

    public List<Map<String, Object>> getIndexes(String db, String collection) {
        if (!this.getIndexesForDB(db).containsKey(collection)) {
            CopyOnWriteArrayList<Doc> value = new CopyOnWriteArrayList<Doc>();
            this.getIndexesForDB(db).put(collection, value);
            value.add(Doc.of("_id", (Object)1, "$options", Doc.of("name", "_id_1")));
        }
        return this.getIndexesForDB(db).get(collection);
    }

    private void enforceUniqueOrThrow(String db, String collection, Map<String, Object> doc) throws MorphiumDriverException {
        List<Map<String, Object>> indexes = this.getIndexes(db, collection);
        if (indexes == null) {
            return;
        }
        for (Map<String, Object> idx : indexes) {
            Map options;
            Object opt = idx.get("$options");
            if (!(opt instanceof Map) || !Boolean.TRUE.equals((options = (Map)opt).get("unique")) && (!(options.get("unique") instanceof String) || !"true".equalsIgnoreCase((String)options.get("unique")))) continue;
            Doc q = new Doc();
            boolean hasAll = true;
            for (Map.Entry<String, Object> e : idx.entrySet()) {
                if (e.getKey().startsWith("$")) continue;
                Object v = doc.get(e.getKey());
                if (v == null) {
                    hasAll = false;
                    break;
                }
                q.put(e.getKey(), v);
            }
            if (!hasAll || q.isEmpty()) continue;
            List<Map<String, Object>> matches = this.find(db, collection, q, null, null, 0, 0);
            for (Map<String, Object> m : matches) {
                Object mid = m.get("_id");
                Object did = doc.get("_id");
                if (did != null && mid != null && mid.toString().equals(did.toString())) continue;
                throw new MorphiumDriverException("Duplicate key for unique index: " + String.valueOf(options.get("name")), null);
            }
        }
    }

    public List<String> getCollectionNames(String db) {
        try {
            return new ArrayList<String>(this.getDB(db).keySet());
        }
        catch (Exception e) {
            return new ArrayList<String>();
        }
    }

    public Map<String, Object> findAndOneAndDelete(String db, String col, Map<String, Object> query, Map<String, Object> sort, Map<String, Object> collation) throws MorphiumDriverException {
        List<Map<String, Object>> r = this.find(db, col, query, sort, null, 0, 1);
        if (r.size() == 0) {
            return null;
        }
        this.delete(db, col, Doc.of("_id", r.get(0).get("_id")), null, false, collation, null);
        return r.get(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Object> findAndOneAndUpdate(String db, String col, Map<String, Object> query, Map<String, Object> update, Map<String, Object> sort, Map<String, Object> collation) throws MorphiumDriverException {
        Map<String, Object> result;
        ReadWriteLock lock = this.getCollectionLock(db, col);
        lock.writeLock().lock();
        ArrayList<PendingNotification> pendingNotifications = new ArrayList<PendingNotification>();
        try {
            List<Map<String, Object>> ret = this.find(db, col, query, sort, null, collation, 0, 1, true);
            if (ret.isEmpty()) {
                Map<String, Object> map = null;
                return map;
            }
            this.updateInternal(db, col, query, null, update, false, false, collation, null, pendingNotifications);
            result = ret.get(0);
        }
        finally {
            lock.writeLock().unlock();
        }
        for (PendingNotification notification : pendingNotifications) {
            this.notifyWatchers(notification.db, notification.collection, notification.op, notification.doc, notification.updatedFields, notification.removedFields, notification.beforeDocument);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Object> findAndOneAndReplace(String db, String col, Map<String, Object> query, Map<String, Object> replacement, Map<String, Object> sort, Map<String, Object> collation) throws MorphiumDriverException {
        Map<String, Object> result;
        ReadWriteLock lock = this.getCollectionLock(db, col);
        lock.writeLock().lock();
        ArrayList<PendingNotification> pendingNotifications = new ArrayList<PendingNotification>();
        try {
            List<Map<String, Object>> ret = this.find(db, col, query, sort, null, collation, 0, 1, true);
            if (ret.isEmpty()) {
                Map<String, Object> map = null;
                return map;
            }
            if (ret.get(0).get("_id") != null) {
                replacement.put("_id", ret.get(0).get("_id"));
            } else {
                replacement.remove("_id");
            }
            this.storeInternal(db, col, Collections.singletonList(replacement), null, pendingNotifications);
            result = replacement;
        }
        finally {
            lock.writeLock().unlock();
        }
        for (PendingNotification notification : pendingNotifications) {
            this.notifyWatchers(notification.db, notification.collection, notification.op, notification.doc, notification.updatedFields, notification.removedFields, notification.beforeDocument);
        }
        return result;
    }

    public void tailableIteration(String db, String collection, Map<String, Object> query, Map<String, Object> sort, Map<String, Object> projection, int skip, int limit, int batchSize, ReadPreference readPreference, int timeout, DriverTailableIterationCallback cb) throws MorphiumDriverException {
        throw new FunctionNotSupportedException("not possible in Mem yet");
    }

    @Override
    public int getMaxWaitTime() {
        return 0;
    }

    @Override
    public void setMaxWaitTime(int maxWaitTime) {
    }

    @Override
    public String[] getCredentials(String db) {
        return new String[0];
    }

    @Override
    public List<String> getHostSeed() {
        return new ArrayList<String>();
    }

    @Override
    public void setHostSeed(List<String> hosts) {
    }

    @Override
    public int getServerSelectionTimeout() {
        return 0;
    }

    @Override
    public void setServerSelectionTimeout(int serverSelectionTimeout) {
    }

    @Override
    public boolean isCapped(String db, String coll) {
        return this.cappedCollections.containsKey(db) && this.cappedCollections.get(db).containsKey(coll);
    }

    @Override
    public Map<String, Integer> getNumConnectionsByHost() {
        return Map.of("inMem", 1);
    }

    @Override
    public BulkRequestContext createBulkContext(Morphium m, final String db, final String collection, boolean ordered, WriteConcern wc) {
        return new BulkRequestContext(this, m){
            private final List<BulkRequest> requests;
            final /* synthetic */ InMemoryDriver this$0;
            {
                this.this$0 = this$0;
                super(m);
                this.requests = new ArrayList<BulkRequest>();
            }

            @Override
            public Map<String, Object> execute() {
                int delCount = 0;
                int matchedCount = 0;
                int insertCount = 0;
                int modifiedCount = 0;
                ArrayList upsertedIds = new ArrayList();
                try {
                    for (BulkRequest r : this.requests) {
                        if (r instanceof InsertBulkRequest) {
                            InsertBulkRequest ibr = (InsertBulkRequest)r;
                            this.this$0.insert(db, collection, ibr.getToInsert(), null);
                            insertCount += ibr.getToInsert().size();
                            continue;
                        }
                        if (r instanceof UpdateBulkRequest) {
                            Object modified;
                            UpdateBulkRequest up = (UpdateBulkRequest)r;
                            Map<String, Object> updateResult = this.this$0.update(db, collection, up.getQuery(), null, up.getCmd(), up.isMultiple(), up.isUpsert(), null, null);
                            if (updateResult.containsKey("matched")) {
                                matchedCount += ((Number)updateResult.get("matched")).intValue();
                            }
                            if ((updateResult.containsKey("modified") || updateResult.containsKey("nModified")) && (modified = updateResult.getOrDefault("modified", updateResult.get("nModified"))) != null) {
                                modifiedCount += ((Number)modified).intValue();
                            }
                            if (!updateResult.containsKey("upsertedIds")) continue;
                            List ids = (List)updateResult.get("upsertedIds");
                            upsertedIds.addAll(ids);
                            continue;
                        }
                        if (r instanceof DeleteBulkRequest) {
                            Map<String, Object> delResult = this.this$0.delete(db, collection, ((DeleteBulkRequest)r).getQuery(), null, ((DeleteBulkRequest)r).isMultiple(), null, null);
                            if (!delResult.containsKey("n")) continue;
                            delCount += ((Number)delResult.get("n")).intValue();
                            continue;
                        }
                        throw new RuntimeException("Unknown operation " + r.getClass().getName());
                    }
                }
                catch (MorphiumDriverException e) {
                    this.this$0.log.error("Got exception: ", (Throwable)e);
                }
                Doc res = Doc.of("num_deleted", (Object)delCount, "num_matched", (Object)matchedCount, "num_inserted", (Object)insertCount, "num_modified", (Object)modifiedCount, "num_upserts", (Object)upsertedIds.size());
                if (!upsertedIds.isEmpty()) {
                    res.put("upsertedIds", upsertedIds);
                }
                return res;
            }

            @Override
            public UpdateBulkRequest addUpdateBulkRequest() {
                UpdateBulkRequest up = new UpdateBulkRequest();
                this.requests.add(up);
                return up;
            }

            @Override
            public InsertBulkRequest addInsertBulkRequest(List<Map<String, Object>> toInsert) {
                InsertBulkRequest in = new InsertBulkRequest(toInsert);
                this.requests.add(in);
                return in;
            }

            @Override
            public DeleteBulkRequest addDeleteBulkRequest() {
                DeleteBulkRequest del = new DeleteBulkRequest();
                this.requests.add(del);
                return del;
            }
        };
    }

    @Override
    public Map<MorphiumDriver.DriverStatsKey, Double> getDriverStats() {
        HashMap<MorphiumDriver.DriverStatsKey, Double> ret = new HashMap<MorphiumDriver.DriverStatsKey, Double>();
        for (Map.Entry<MorphiumDriver.DriverStatsKey, AtomicDecimal> e : this.stats.entrySet()) {
            ret.put(e.getKey(), e.getValue().doubleValue());
        }
        ret.put(MorphiumDriver.DriverStatsKey.REPLY_IN_MEM, Double.valueOf(this.commandResults.size()));
        return ret;
    }

    public void createIndex(String db, String collection, Map<String, Object> indexDef, Map<String, Object> options) throws MorphiumDriverException {
        HashMap<String, Object> index = new HashMap<String, Object>(indexDef);
        index.put("$options", options);
        if (!options.containsKey("name")) {
            StringBuilder name = new StringBuilder();
            for (String k : index.keySet()) {
                if (k.startsWith("$")) continue;
                name.append(k + "_" + index.get(k).toString());
                name.append("_");
            }
            name.setLength(name.length() - 1);
            ((Map)index.get("$options")).put("name", name.toString());
        }
        List<Map<String, Object>> indexes = this.getIndexes(db, collection);
        boolean found = true;
        for (Map<String, Object> i : indexes) {
            found = true;
            if (i.size() - 1 != indexDef.size()) {
                found = false;
                continue;
            }
            for (Map.Entry<String, Object> e : indexDef.entrySet()) {
                if (e.getKey().startsWith("$") || i.containsKey(e.getKey()) && i.get(e.getKey()).equals(e.getValue())) continue;
                found = false;
                break;
            }
            if (!found) continue;
            break;
        }
        if (!found) {
            indexes.add(index);
        } else if (index.size() != 2 || !index.containsKey("_id") || index.containsKey("$options")) {
            // empty if block
        }
        this.updateIndexData(db, collection, options);
    }

    private void updateIndexData(String db, String collection, Map<String, Object> options) throws MorphiumDriverException {
        StringBuilder b = new StringBuilder();
        this.indexDataByDBCollection.putIfAbsent(db, new ConcurrentHashMap());
        this.indexDataByDBCollection.get(db).putIfAbsent(collection, new ConcurrentHashMap());
        ConcurrentHashMap newIndexData = new ConcurrentHashMap();
        for (Map<String, Object> doc : this.getCollection(db, collection)) {
            for (Map<String, Object> idx : this.getIndexes(db, collection)) {
                b.setLength(0);
                int bucketId = 0;
                for (String k : idx.keySet()) {
                    if (k.equals("$options")) continue;
                    bucketId = this.iterateBucketId(bucketId, doc.get(k));
                    b.append(k);
                }
                String fieldKey = b.toString();
                newIndexData.putIfAbsent(fieldKey, new ConcurrentHashMap());
                Map index = (Map)newIndexData.get(fieldKey);
                index.putIfAbsent(bucketId, new CopyOnWriteArrayList());
                ((List)index.get(bucketId)).add(doc);
            }
        }
        this.indexDataByDBCollection.get(db).put(collection, newIndexData);
    }

    public List<Map<String, Object>> mapReduce(String db, String collection, String mapping, String reducing) throws MorphiumDriverException {
        return this.mapReduceInternal(db, collection, mapping, reducing, null, null, null, null);
    }

    public List<Map<String, Object>> mapReduce(String db, String collection, String mapping, String reducing, Map<String, Object> query) throws MorphiumDriverException {
        return this.mapReduceInternal(db, collection, mapping, reducing, query, null, null, null);
    }

    public List<Map<String, Object>> mapReduce(String db, String collection, String mapping, String reducing, Map<String, Object> query, Map<String, Object> sorting, Collation collation) throws MorphiumDriverException {
        return this.mapReduceInternal(db, collection, mapping, reducing, query, sorting, collation, null);
    }

    private List<Map<String, Object>> mapReduceInternal(String db, String collection, String mapFunction, String reduceFunction, Object query, Object sort, Collation collation, String finalizeFunction) throws MorphiumDriverException {
        Map queryMap = query instanceof Map ? (Map)query : null;
        Map sortMap = sort instanceof Map ? (Map)sort : null;
        List<Map<String, Object>> documents = this.find(db, collection, queryMap, sortMap, null, collation == null ? null : collation.toQueryObject(), 0, 0, false);
        this.log.info("MapReduce internal: found {} documents to process", (Object)documents.size());
        System.setProperty("polyglot.engine.WarnInterpreterOnly", "false");
        ScriptEngineManager mgr = new ScriptEngineManager();
        ScriptEngine engine = mgr.getEngineByExtension("js");
        if (engine == null) {
            engine = mgr.getEngineByName("js");
        }
        if (engine == null) {
            engine = mgr.getEngineByName("JavaScript");
        }
        if (engine == null) {
            throw new MorphiumDriverException("JavaScript engine not available for MapReduce");
        }
        this.log.info("JavaScript engine found: {}", (Object)engine.getClass().getName());
        try {
            ArrayList<Map<String, Object>> mapResults = new ArrayList<Map<String, Object>>();
            final MapReduceEmitter emitter = new MapReduceEmitter(mapResults);
            ArrayList emitResults = new ArrayList();
            engine.put("emitResults", emitResults);
            Object basicTest = engine.eval("1 + 1");
            this.log.info("Basic JS test (1+1): {}", basicTest);
            this.log.debug("Setting up emit function with emitter: {}", (Object)emitter);
            engine.put("emit", new Object(this){
                final /* synthetic */ InMemoryDriver this$0;
                {
                    this.this$0 = this$0;
                }

                public void emit(Object key, Object value) {
                    this.this$0.log.info("Java emit function called with key={}, value={}", key, value);
                    emitter.emit(key, value);
                }
            });
            engine.eval("var jsEmitResults = [];");
            engine.eval("function emit(key, value) {   var result = { _id: key, value: value };   jsEmitResults.push(result); }");
            engine.eval("function ObjectId() {   var hex = '0123456789abcdef';  var id = '';  for (var i = 0; i < 24; i++) {    id += hex.charAt(Math.floor(Math.random() * 16));  }  return id;}");
            engine.eval("var mapFunc = " + mapFunction + ";");
            this.log.info("Starting map phase with {} documents", (Object)documents.size());
            for (Map<String, Object> doc : documents) {
                this.log.debug("Processing document: {}", doc);
                try {
                    String jsonDoc = Utils.toJsonString(doc);
                    String escapedJson = jsonDoc.replace("\\", "\\\\").replace("'", "\\'");
                    String executable = "var __mapDoc = JSON.parse('" + escapedJson + "'); mapFunc.call(__mapDoc);";
                    this.log.debug("Executing map function for document");
                    engine.eval(executable);
                }
                catch (Exception e) {
                    this.log.error("JavaScript execution error: {}", (Object)e.getMessage(), (Object)e);
                }
                Object jsArraySize = engine.eval("jsEmitResults.length");
                this.log.debug("Map results so far: {}", jsArraySize);
            }
            Object finalJsArraySize = engine.eval("jsEmitResults.length");
            this.log.info("Map phase completed with {} emissions", finalJsArraySize);
            JSONParser jsonParser = new JSONParser();
            Object jsArrayLength = engine.eval("jsEmitResults.length");
            if (jsArrayLength instanceof Number) {
                int arrayLength = ((Number)jsArrayLength).intValue();
                this.log.info("Converting {} JavaScript results to Java", (Object)arrayLength);
                for (int i = 0; i < arrayLength; ++i) {
                    Object object = engine.eval("jsEmitResults[" + i + "]._id");
                    String valueJson = (String)engine.eval("JSON.stringify(jsEmitResults[" + i + "].value)");
                    HashMap<String, Object> javaResult = new HashMap<String, Object>();
                    javaResult.put("_id", object);
                    javaResult.put("valueJson", valueJson);
                    mapResults.add(javaResult);
                    this.log.debug("Converted result {}: key={}, valueJson={}", new Object[]{i, object, valueJson});
                }
            }
            HashMap<Object, List> groupedResults = new HashMap<Object, List>();
            for (Map map : mapResults) {
                Object key = map.get("_id");
                String valueJson = (String)map.get("valueJson");
                groupedResults.computeIfAbsent(key, k -> new ArrayList()).add(valueJson);
            }
            if (reduceFunction != null && !reduceFunction.trim().isEmpty()) {
                engine.eval("var reduceFunc = " + reduceFunction + ";");
            }
            if (finalizeFunction != null && !finalizeFunction.trim().isEmpty()) {
                engine.eval("var finalizeFunc = " + finalizeFunction + ";");
            }
            ArrayList<Map<String, Object>> finalResults = new ArrayList<Map<String, Object>>();
            for (Map.Entry entry : groupedResults.entrySet()) {
                Object reducedValue;
                Object key = entry.getKey();
                List values = (List)entry.getValue();
                if (reduceFunction == null || reduceFunction.trim().isEmpty()) {
                    reducedValue = values.size() == 1 ? values.get(0) : new ArrayList(values);
                } else {
                    engine.put("__javaKey__", key);
                    StringBuilder valuesArrayJson = new StringBuilder("[");
                    for (int i = 0; i < values.size(); ++i) {
                        if (i > 0) {
                            valuesArrayJson.append(',');
                        }
                        valuesArrayJson.append((String)values.get(i));
                    }
                    valuesArrayJson.append(']');
                    engine.put("__valuesJson__", valuesArrayJson.toString());
                    reducedValue = engine.eval("reduceFunc(__javaKey__, JSON.parse(__valuesJson__))");
                }
                if (finalizeFunction != null && !finalizeFunction.trim().isEmpty()) {
                    engine.put("__javaKey__", key);
                    engine.put("__reducedValue__", reducedValue);
                    reducedValue = engine.eval("finalizeFunc(__javaKey__, __reducedValue__)");
                }
                HashMap<String, Object> result = new HashMap<String, Object>();
                result.put("_id", key);
                if (reducedValue instanceof Map) {
                    result.put("value", reducedValue);
                } else {
                    try {
                        engine.put("__reducedJson__", reducedValue);
                        String reducedJson = (String)engine.eval("JSON.stringify(__reducedJson__)");
                        Object parsed = jsonParser.parse(reducedJson);
                        result.put("value", parsed);
                    }
                    catch (ParseException pe) {
                        throw new MorphiumDriverException("Failed to parse reduce result", pe);
                    }
                }
                finalResults.add(result);
            }
            return finalResults;
        }
        catch (ScriptException e) {
            throw new MorphiumDriverException("JavaScript error in MapReduce: " + e.getMessage(), e);
        }
    }

    @Override
    public void commitTransaction() {
        if (this.currentTransaction.get() == null) {
            throw new IllegalArgumentException("No transaction in progress");
        }
        InMemTransactionContext ctx = this.currentTransaction.get();
        this.database.clear();
        this.database.putAll(ctx.getDatabase());
        this.indexDataByDBCollection.clear();
        for (String dbName : this.database.keySet()) {
            for (String collName : this.database.get(dbName).keySet()) {
                try {
                    this.updateIndexData(dbName, collName, null);
                }
                catch (Exception exception) {}
            }
        }
        this.currentTransaction.set(null);
    }

    @Override
    public void abortTransaction() {
        this.currentTransaction.set(null);
    }

    @Override
    public void setTransactionContext(MorphiumTransactionContext ctx) {
        this.currentTransaction.set((InMemTransactionContext)ctx);
    }

    public void writeDump(File f) {
    }

    public SSLContext getSslContext() {
        return null;
    }

    public void setSslContext(SSLContext sslContext) {
    }

    public boolean isSslInvalidHostNameAllowed() {
        return false;
    }

    public void setSslInvalidHostNameAllowed(boolean sslInvalidHostNameAllowed) {
    }

    @Override
    public int getIdleSleepTime() {
        return 0;
    }

    @Override
    public void setIdleSleepTime(int sl) {
    }

    @Override
    public int getCompression() {
        return 0;
    }

    @Override
    public MorphiumDriver setCompression(int type) {
        this.log.warn("Cannot set compression on inMemDriver");
        return this;
    }

    private static /* synthetic */ boolean lambda$updateInternal$0(List v, Object object) {
        return v.contains(object);
    }

    private /* synthetic */ void lambda$connect$0() {
        block4: while (true) {
            try {
                Runnable r1;
                while ((r1 = (Runnable)this.eventQueue.poll()) != null) {
                    try {
                        r1.run();
                        continue block4;
                    }
                    catch (Exception exception) {
                    }
                }
                break;
            }
            catch (Throwable e) {
                this.log.error("Error", e);
                break;
            }
        }
    }

    private class ChangeStreamSubscription {
        private final String db;
        private final String collection;
        private final DriverTailableIterationCallback callback;
        private final List<Map<String, Object>> pipeline;
        private final WatchCommand.FullDocumentEnum fullDocumentMode;
        private final WatchCommand.FullDocumentBeforeChangeEnum beforeChangeMode;
        private final boolean showExpandedEvents;
        private final Object monitor;
        private volatile boolean active = true;
        private String namespaceKey;
        private final ExecutorService subscriptionExecutor = Executors.newSingleThreadExecutor(Thread.ofVirtual().name("changestream-watch-", 0L).factory());

        private ChangeStreamSubscription(String db, String collection, DriverTailableIterationCallback callback, List<Map<String, Object>> pipeline, WatchCommand.FullDocumentEnum fullDocumentMode, WatchCommand.FullDocumentBeforeChangeEnum beforeChangeMode, boolean showExpandedEvents, Object monitor) {
            this.db = db;
            this.collection = collection;
            this.callback = callback;
            this.pipeline = pipeline;
            this.fullDocumentMode = fullDocumentMode;
            this.beforeChangeMode = beforeChangeMode;
            this.showExpandedEvents = showExpandedEvents;
            this.monitor = monitor;
        }

        private boolean matches(ChangeStreamEventInfo info) {
            if (!Objects.equals(this.db, info.db)) {
                return false;
            }
            if (this.collection == null) {
                return true;
            }
            return Objects.equals(this.collection, info.collection);
        }

        private boolean isActive() {
            return this.active;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void deactivate() {
            if (!this.active) {
                return;
            }
            this.active = false;
            if (this.subscriptionExecutor != null && !this.subscriptionExecutor.isShutdown()) {
                this.subscriptionExecutor.shutdown();
            }
            Object object = this.monitor;
            synchronized (object) {
                this.monitor.notifyAll();
            }
        }

        private void deliver(ChangeStreamEventInfo info) {
            if (!this.active) {
                InMemoryDriver.this.log.debug("Subscription inactive, skipping delivery for {}.{}", (Object)info.db, (Object)info.collection);
                return;
            }
            InMemoryDriver.this.log.debug("Delivering change stream event for {}.{}, op={}", new Object[]{info.db, info.collection, info.event.get("operationType")});
            Map<String, Object> working = InMemoryDriver.deepCopyDoc(info.event);
            this.adjustFullDocument(working);
            if (!this.applyFullDocumentBeforeChange(working)) {
                InMemoryDriver.this.log.debug("Filtered out by fullDocumentBeforeChange requirement");
                return;
            }
            Map<String, Object> processed = this.applyPipeline(working);
            if (processed == null) {
                InMemoryDriver.this.log.debug("Filtered out by pipeline");
                return;
            }
            if (this.subscriptionExecutor.isShutdown()) {
                InMemoryDriver.this.log.debug("Subscription executor is shut down, skipping callback");
                return;
            }
            try {
                this.subscriptionExecutor.execute(() -> {
                    try {
                        InMemoryDriver.this.log.debug("Calling callback.incomingData() for {}.{}, thread={}", new Object[]{info.db, info.collection, Thread.currentThread().getName()});
                        this.callback.incomingData(processed, System.currentTimeMillis() - info.createdAt);
                        InMemoryDriver.this.log.debug("Callback completed successfully, thread={}", (Object)Thread.currentThread().getName());
                    }
                    catch (Exception e) {
                        InMemoryDriver.this.log.error("Error calling change-stream callback, thread={}", (Object)Thread.currentThread().getName(), (Object)e);
                    }
                    if (!this.callback.isContinued()) {
                        InMemoryDriver.this.log.debug("Callback indicated not to continue, deactivating subscription");
                        this.deactivate();
                    }
                });
            }
            catch (RejectedExecutionException e) {
                InMemoryDriver.this.log.debug("Subscription executor rejected task (likely shutting down), skipping callback");
            }
        }

        private void adjustFullDocument(Map<String, Object> working) {
            if (this.fullDocumentMode != WatchCommand.FullDocumentEnum.updateLookup && "update".equals(working.get("operationType"))) {
                working.remove("fullDocument");
            }
        }

        private boolean applyFullDocumentBeforeChange(Map<String, Object> working) {
            Map before = (Map)working.get("fullDocumentBeforeChange");
            switch (this.beforeChangeMode) {
                case off: {
                    working.remove("fullDocumentBeforeChange");
                    return true;
                }
                case whenAvailable: {
                    if (before == null) {
                        working.remove("fullDocumentBeforeChange");
                    }
                    return true;
                }
                case required: {
                    return before != null;
                }
            }
            return true;
        }

        private Map<String, Object> applyPipeline(Map<String, Object> working) {
            if (this.pipeline == null || this.pipeline.isEmpty()) {
                return working;
            }
            InMemAggregator<Map, Map> agg = new InMemAggregator<Map, Map>(null, Map.class, Map.class);
            List<Map<String, Object>> current = new ArrayList<Map<String, Object>>();
            current.add(working);
            for (Map<String, Object> stage : this.pipeline) {
                current = agg.execStep(stage, current);
                if (current != null && !current.isEmpty()) continue;
                return null;
            }
            Map result = (Map)current.get(0);
            if (result == working) {
                return working;
            }
            return InMemoryDriver.deepCopyDoc(result);
        }
    }

    private static class CursorResultBuffer {
        private final Deque<Map<String, Object>> remaining;
        private final String namespace;
        private final int defaultBatchSize;

        CursorResultBuffer(Deque<Map<String, Object>> remaining, String namespace, int defaultBatchSize) {
            this.remaining = remaining;
            this.namespace = namespace;
            this.defaultBatchSize = defaultBatchSize;
        }
    }

    private class InMemoryFindCursor
    extends MorphiumCursor {
        private int internalIndex = 0;
        private int index = 0;

        InMemoryFindCursor(long cursorId, String namespace, List<Map<String, Object>> firstBatch, int batchSize) {
            this.setCursorId(cursorId);
            this.setBatchSize(batchSize > 0 ? batchSize : (firstBatch.size() > 0 ? firstBatch.size() : 101));
            this.setBatch(firstBatch != null ? new ArrayList<Map<String, Object>>(firstBatch) : new ArrayList());
            this.applyNamespace(namespace);
        }

        private void applyNamespace(String namespace) {
            if (namespace == null || namespace.isEmpty()) {
                this.setDb("");
                this.setCollection("");
                return;
            }
            int dotIdx = namespace.indexOf(46);
            if (dotIdx < 0) {
                this.setDb(namespace);
                this.setCollection("$cmd");
            } else {
                this.setDb(namespace.substring(0, dotIdx));
                this.setCollection(namespace.substring(dotIdx + 1));
            }
        }

        @Override
        public synchronized boolean hasNext() {
            if (this.getBatch() != null && this.internalIndex < this.getBatch().size()) {
                return true;
            }
            if (this.getCursorId() == 0L) {
                return false;
            }
            this.loadNextBatch();
            return this.getBatch() != null && this.internalIndex < this.getBatch().size();
        }

        @Override
        public synchronized Map<String, Object> next() {
            if (!this.hasNext()) {
                return null;
            }
            Map<String, Object> doc = this.getBatch().get(this.internalIndex++);
            ++this.index;
            return doc;
        }

        @Override
        public synchronized void close() {
            if (this.getCursorId() != 0L) {
                InMemoryDriver.this.closeCursor(this.getCursorId());
                this.setCursorId(0L);
            }
            this.setBatch(Collections.emptyList());
            this.internalIndex = 0;
        }

        @Override
        public synchronized int available() {
            if (this.getBatch() == null) {
                return 0;
            }
            return Math.max(0, this.getBatch().size() - this.internalIndex);
        }

        @Override
        public synchronized List<Map<String, Object>> getAll() throws MorphiumDriverException {
            ArrayList<Map<String, Object>> res = new ArrayList<Map<String, Object>>();
            while (this.hasNext()) {
                res.add((Map<String, Object>)this.next());
            }
            return res;
        }

        @Override
        public synchronized void ahead(int jump) throws MorphiumDriverException {
            if (jump < 0) {
                throw new IllegalArgumentException("jump must be >= 0");
            }
            this.internalIndex += jump;
            this.index += jump;
            while (this.getBatch() != null && this.internalIndex >= this.getBatch().size()) {
                int diff = this.internalIndex - this.getBatch().size();
                if (this.getCursorId() == 0L) {
                    this.internalIndex = this.getBatch() != null ? this.getBatch().size() : 0;
                    break;
                }
                this.loadNextBatch();
                if (this.getBatch() == null || this.getBatch().isEmpty()) {
                    this.internalIndex = 0;
                    break;
                }
                this.internalIndex = diff;
            }
        }

        @Override
        public synchronized void back(int jump) throws MorphiumDriverException {
            if (jump < 0) {
                throw new IllegalArgumentException("jump must be >= 0");
            }
            this.internalIndex -= jump;
            this.index -= jump;
            if (this.internalIndex < 0) {
                throw new IllegalArgumentException("cannot jump back over batch boundaries!");
            }
        }

        @Override
        public int getCursor() {
            return this.index;
        }

        @Override
        public MongoConnection getConnection() {
            return new InMemConnectionWrapper(InMemoryDriver.this);
        }

        @Override
        public Iterator<Map<String, Object>> iterator() {
            return this;
        }

        private void loadNextBatch() {
            if (this.getCursorId() == 0L) {
                this.setBatch(Collections.emptyList());
                this.internalIndex = 0;
                return;
            }
            List<Map<String, Object>> next = InMemoryDriver.this.drainNextBatch(this.getCursorId(), this.getBatchSize());
            if (next.isEmpty()) {
                this.setCursorId(0L);
                this.setBatch(Collections.emptyList());
            } else {
                this.setBatch(new ArrayList<Map<String, Object>>(next));
            }
            this.internalIndex = 0;
        }
    }

    private class InMemConnectionWrapper
    implements MongoConnection {
        private final InMemoryDriver driver;
        private boolean closed = false;

        InMemConnectionWrapper(InMemoryDriver driver) {
            this.driver = driver;
        }

        @Override
        public void close() {
            if (this.closed) {
                return;
            }
            this.closed = true;
            int remaining = this.driver.activeConnections.decrementAndGet();
            InMemoryDriver.this.log.debug("Connection closed, remaining connections: {}", (Object)remaining);
        }

        @Override
        public int sendCommand(MongoCommand cmd) throws MorphiumDriverException {
            if (this.closed) {
                throw new IllegalStateException("Connection closed");
            }
            return this.driver.sendCommand(cmd);
        }

        @Override
        public int getSourcePort() {
            return this.driver.getSourcePort();
        }

        public void setTransactionContext(MorphiumTransactionContext ctx) {
            this.driver.setTransactionContext(ctx);
        }

        public MorphiumTransactionContext getTransactionContext() {
            return this.driver.getTransactionContext();
        }

        @Override
        public void setCredentials(String authDb, String userName, String password) {
            this.driver.setCredentials(authDb, userName, password);
        }

        @Override
        public HelloResult connect(MorphiumDriver drv, String host, int port) throws IOException, MorphiumDriverException {
            return this.driver.connect(drv, host, port);
        }

        @Override
        public MorphiumDriver getDriver() {
            return this.driver.getDriver();
        }

        @Override
        public boolean isConnected() {
            return this.driver.isConnected();
        }

        @Override
        public String getConnectedTo() {
            return this.driver.getConnectedTo();
        }

        @Override
        public String getConnectedToHost() {
            return this.driver.getConnectedToHost();
        }

        @Override
        public int getConnectedToPort() {
            return this.driver.getConnectedToPort();
        }

        @Override
        public void closeIteration(MorphiumCursor crs) throws MorphiumDriverException {
            this.driver.closeIteration(crs);
        }

        @Override
        public Map<String, Object> killCursors(String db, String coll, long ... ids) throws MorphiumDriverException {
            return this.driver.killCursors(db, coll, ids);
        }

        @Override
        public OpMsg readNextMessage(int timeout) throws MorphiumDriverException {
            return this.driver.readNextMessage(timeout);
        }

        @Override
        public Map<String, Object> readSingleAnswer(int id) throws MorphiumDriverException {
            return this.driver.readSingleAnswer(id);
        }

        @Override
        public void watch(WatchCommand settings) throws MorphiumDriverException {
            this.driver.watch(settings);
        }

        @Override
        public List<Map<String, Object>> readAnswerFor(int queryId) throws MorphiumDriverException {
            return this.driver.readAnswerFor(queryId);
        }

        @Override
        public MorphiumCursor getAnswerFor(int queryId, int batchsize) throws MorphiumDriverException {
            return this.driver.getAnswerFor(queryId, batchsize);
        }

        @Override
        public List<Map<String, Object>> readAnswerFor(MorphiumCursor crs) throws MorphiumDriverException {
            return this.driver.readAnswerFor(crs);
        }
    }

    private static class InMemoryCursor {
        private int skip;
        private int limit;
        private int batchSize;
        private int dataRead = 0;
        private String db;
        private String collection;
        private Map<String, Object> query;
        private Map<String, Object> sort;
        private Map<String, Object> projection;
        private ReadPreference readPreference;
        private Map<String, Object> findMetaData;
        private Collation collation;

        private InMemoryCursor() {
        }

        public String getDb() {
            return this.db;
        }

        public void setDb(String db) {
            this.db = db;
        }

        public String getCollection() {
            return this.collection;
        }

        public void setCollection(String collection) {
            this.collection = collection;
        }

        public Map<String, Object> getQuery() {
            return this.query;
        }

        public void setQuery(Map<String, Object> query) {
            this.query = query;
        }

        public Map<String, Object> getSort() {
            return this.sort;
        }

        public void setSort(Map<String, Object> sort) {
            this.sort = sort;
        }

        public Map<String, Object> getProjection() {
            return this.projection;
        }

        public void setProjection(Map<String, Object> projection) {
            this.projection = projection;
        }

        public ReadPreference getReadPreference() {
            return this.readPreference;
        }

        public void setReadPreference(ReadPreference readPreference) {
            this.readPreference = readPreference;
        }

        public Map<String, Object> getFindMetaData() {
            return this.findMetaData;
        }

        public void setFindMetaData(Map<String, Object> findMetaData) {
            this.findMetaData = findMetaData;
        }

        public int getDataRead() {
            return this.dataRead;
        }

        public void setDataRead(int dataRead) {
            this.dataRead = dataRead;
        }

        public int getBatchSize() {
            return this.batchSize;
        }

        public void setBatchSize(int batchSize) {
            this.batchSize = batchSize;
        }

        public int getSkip() {
            return this.skip;
        }

        public void setSkip(int skip) {
            this.skip = skip;
        }

        public int getLimit() {
            return this.limit;
        }

        public void setLimit(int limit) {
            this.limit = limit;
        }

        public Collation getCollation() {
            return this.collation;
        }

        public void setCollation(Collation collation) {
            this.collation = collation;
        }
    }

    private static class PendingNotification {
        final String db;
        final String collection;
        final String op;
        final Map<String, Object> doc;
        final Map<String, Object> updatedFields;
        final List<String> removedFields;
        final Map<String, Object> beforeDocument;

        PendingNotification(String db, String collection, String op, Map<String, Object> doc) {
            this(db, collection, op, doc, null, null, null);
        }

        PendingNotification(String db, String collection, String op, Map<String, Object> doc, Map<String, Object> updatedFields, List<String> removedFields, Map<String, Object> beforeDocument) {
            this.db = db;
            this.collection = collection;
            this.op = op;
            this.doc = doc;
            this.updatedFields = updatedFields;
            this.removedFields = removedFields;
            this.beforeDocument = beforeDocument;
        }
    }

    private static final class ChangeStreamEventInfo {
        private final long token;
        private final String db;
        private final String collection;
        private final Map<String, Object> event;
        private final long createdAt;

        private ChangeStreamEventInfo(long token, String db, String collection, Map<String, Object> event, long createdAt) {
            this.token = token;
            this.db = db;
            this.collection = collection;
            this.event = event;
            this.createdAt = createdAt;
        }
    }

    public static class MapReduceEmitter {
        private final List<Map<String, Object>> results;

        public MapReduceEmitter(List<Map<String, Object>> results) {
            this.results = results;
        }

        public void emit(Object key, Object value) {
            HashMap<String, Object> result = new HashMap<String, Object>();
            result.put("_id", key);
            result.put("value", value);
            this.results.add(result);
        }
    }
}

