/*
 * Decompiled with CFR 0.152.
 */
package de.caluga.morphium.driver.inmem;

import de.caluga.morphium.AnnotationAndReflectionHelper;
import de.caluga.morphium.Collation;
import de.caluga.morphium.Morphium;
import de.caluga.morphium.ObjectMapperImpl;
import de.caluga.morphium.Utils;
import de.caluga.morphium.UtilsMap;
import de.caluga.morphium.aggregation.AggregationIterator;
import de.caluga.morphium.aggregation.Aggregator;
import de.caluga.morphium.aggregation.Expr;
import de.caluga.morphium.aggregation.Group;
import de.caluga.morphium.aggregation.MorphiumAggregationIterator;
import de.caluga.morphium.async.AsyncOperationCallback;
import de.caluga.morphium.async.AsyncOperationType;
import de.caluga.morphium.driver.Doc;
import de.caluga.morphium.driver.MorphiumCursor;
import de.caluga.morphium.driver.MorphiumDriverException;
import de.caluga.morphium.driver.SingleBatchCursor;
import de.caluga.morphium.driver.commands.AggregateMongoCommand;
import de.caluga.morphium.driver.commands.ExplainCommand;
import de.caluga.morphium.driver.inmem.InMemoryDriver;
import de.caluga.morphium.driver.inmem.QueryHelper;
import de.caluga.morphium.query.Query;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InMemAggregator<T, R>
implements Aggregator<T, R> {
    private final Logger log = LoggerFactory.getLogger(InMemAggregator.class);
    private final List<Map<String, Object>> params = new ArrayList<Map<String, Object>>();
    private final List<Group<T, R>> groups = new ArrayList<Group<T, R>>();
    private Class<? extends T> type;
    private Morphium morphium;
    private Class<? extends R> rType;
    private String collectionName;
    private boolean useDisk = false;
    private boolean explain = false;
    private Collation collation;

    public InMemAggregator(Morphium morphium, Class<? extends T> type, Class<? extends R> resultType) {
        this.morphium = morphium;
        this.setSearchType(type);
        this.setResultType(resultType);
    }

    @Override
    public Collation getCollation() {
        return this.collation;
    }

    @Override
    public boolean isUseDisk() {
        return this.useDisk;
    }

    @Override
    public void setUseDisk(boolean useDisk) {
        this.useDisk = useDisk;
    }

    @Override
    public AggregateMongoCommand getAggregateCmd() {
        return new AggregateMongoCommand(null){

            @Override
            public List<Map<String, Object>> execute() throws MorphiumDriverException {
                return InMemAggregator.this.aggregateMap();
            }

            @Override
            public MorphiumCursor executeIterable(int batchsize) throws MorphiumDriverException {
                return new SingleBatchCursor(InMemAggregator.this.aggregateMap());
            }
        };
    }

    @Override
    public boolean isExplain() {
        return this.explain;
    }

    @Override
    public void setExplain(boolean explain) {
        this.explain = explain;
    }

    @Override
    public Morphium getMorphium() {
        return this.morphium;
    }

    @Override
    public void setMorphium(Morphium m) {
        this.morphium = m;
    }

    @Override
    public Class<? extends T> getSearchType() {
        return this.type;
    }

    @Override
    public void setSearchType(Class<? extends T> type) {
        this.type = type;
    }

    @Override
    public Class<? extends R> getResultType() {
        return this.rType;
    }

    @Override
    public void setResultType(Class<? extends R> type) {
        this.rType = type;
    }

    @Override
    public Aggregator<T, R> project(Map<String, Object> m) {
        LinkedHashMap<String, Object> p = new LinkedHashMap<String, Object>();
        for (Map.Entry<String, Object> e : m.entrySet()) {
            p.put(e.getKey(), e.getValue());
        }
        UtilsMap map = UtilsMap.of("$project", p);
        this.params.add(map);
        return this;
    }

    @Override
    public Aggregator<T, R> project(String fld, Expr e) {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put(fld, e);
        return this.project(map);
    }

    @Override
    public Aggregator<T, R> project(String ... m) {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        for (String sm : m) {
            map.put(sm, 1);
        }
        return this.project(map);
    }

    @Override
    public Aggregator<T, R> addFields(Map<String, Object> m) {
        LinkedHashMap<String, Object> ret = new LinkedHashMap<String, Object>();
        for (Map.Entry<String, Object> e : m.entrySet()) {
            Object value = e.getValue();
            if (!(value instanceof Expr)) {
                value = Expr.parse(value);
            }
            ret.put(e.getKey(), value);
        }
        UtilsMap o = UtilsMap.of("$addFields", ret);
        this.params.add(o);
        return this;
    }

    @Override
    public Aggregator<T, R> match(Query<T> q) {
        UtilsMap<String, Map<String, Object>> o = UtilsMap.of("$match", q.toQueryObject());
        if (this.collectionName == null) {
            this.collectionName = q.getCollectionName();
        }
        this.params.add(o);
        return this;
    }

    @Override
    public Aggregator<T, R> matchSubQuery(Query<?> q) {
        UtilsMap<String, Map<String, Object>> o = UtilsMap.of("$match", q.toQueryObject());
        this.params.add(o);
        return this;
    }

    @Override
    public Aggregator<T, R> match(Expr q) {
        this.params.add(UtilsMap.of("$match", UtilsMap.of("$expr", q)));
        return this;
    }

    @Override
    public Aggregator<T, R> limit(int num) {
        UtilsMap<String, Integer> o = UtilsMap.of("$limit", num);
        this.params.add(o);
        return this;
    }

    @Override
    public Aggregator<T, R> skip(int num) {
        UtilsMap<String, Integer> o = UtilsMap.of("$skip", num);
        this.params.add(o);
        return this;
    }

    @Override
    public Aggregator<T, R> unwind(String listField) {
        UtilsMap<String, String> o = UtilsMap.of("$unwind", listField);
        this.params.add(o);
        return this;
    }

    @Override
    public Aggregator<T, R> unwind(Expr field) {
        UtilsMap<String, Expr> o = UtilsMap.of("$unwind", field);
        this.params.add(o);
        return this;
    }

    @Override
    public Aggregator<T, R> sort(String ... prefixed) {
        LinkedHashMap<String, Integer> m = new LinkedHashMap<String, Integer>();
        String[] stringArray = prefixed;
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            String i2;
            String fld = i2 = stringArray[i];
            int val = 1;
            if (i2.startsWith("-")) {
                fld = i2.substring(1);
                val = -1;
            } else if (i2.startsWith("+")) {
                fld = i2.substring(1);
                val = 1;
            }
            if (i2.startsWith("$") && !(fld = fld.substring(1)).contains(".")) {
                fld = this.morphium.getARHelper().getMongoFieldName(this.type, fld);
            }
            m.put(fld, val);
        }
        this.sort(m);
        return this;
    }

    @Override
    public Aggregator<T, R> sort(Map<String, Integer> sort) {
        UtilsMap<String, Map<String, Integer>> o = UtilsMap.of("$sort", sort);
        this.params.add(o);
        return this;
    }

    @Override
    public String getCollectionName() {
        if (this.collectionName == null) {
            this.collectionName = this.morphium.getMapper().getCollectionName(this.type);
        }
        return this.collectionName;
    }

    @Override
    public Aggregator<T, R> setCollectionName(String cn) {
        this.collectionName = cn;
        return this;
    }

    @Override
    public Group<T, R> group(Map<String, Object> id) {
        return new Group(this, id);
    }

    @Override
    public Group<T, R> group(Expr id) {
        return new Group(this, id);
    }

    @Override
    public Group<T, R> group(String id) {
        Group gr = new Group(this, id);
        this.groups.add(gr);
        return gr;
    }

    @Override
    public void addOperator(Map<String, Object> o) {
        this.params.add(o);
    }

    @Override
    public List<R> aggregate() {
        try {
            return this.deserializeList();
        }
        catch (MorphiumDriverException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public long getCount() {
        ArrayList<Map<String, Object>> originalPipeline = new ArrayList<Map<String, Object>>(this.getPipeline());
        this.addOperator(UtilsMap.of("$count", "num"));
        List<Map<String, Object>> res = this.doAggregation();
        if (res.get(0).get("num") instanceof Integer) {
            this.params.clear();
            this.params.addAll(originalPipeline);
            return ((Integer)res.get(0).get("num")).longValue();
        }
        this.params.clear();
        this.params.addAll(originalPipeline);
        return (Long)res.get(0).get("num");
    }

    @Override
    public MorphiumAggregationIterator<T, R> aggregateIterable() {
        AggregationIterator agg = new AggregationIterator();
        agg.setAggregator(this);
        return agg;
    }

    @Override
    public void aggregate(AsyncOperationCallback<R> callback) {
        if (callback == null) {
            new Thread(this::doAggregation);
        } else {
            this.morphium.queueTask(() -> {
                try {
                    long start = System.currentTimeMillis();
                    List<R> result = this.deserializeList();
                    callback.onOperationSucceeded(AsyncOperationType.READ, null, System.currentTimeMillis() - start, result, null, this);
                }
                catch (MorphiumDriverException e) {
                    e.printStackTrace();
                }
            });
        }
    }

    private List<R> deserializeList() throws MorphiumDriverException {
        List<Map<String, Object>> r = this.doAggregation();
        List<Object> result = new ArrayList();
        if (this.getResultType().equals(Map.class)) {
            result = r;
        } else {
            for (Map<String, Object> dbObj : r) {
                result.add(this.morphium.getMapper().deserialize(this.getResultType(), dbObj));
            }
        }
        return result;
    }

    @Override
    public void aggregateMap(AsyncOperationCallback<Map<String, Object>> callback) {
    }

    @Override
    public List<Map<String, Object>> getPipeline() {
        for (Group<T, R> g : this.groups) {
            g.end();
        }
        this.groups.clear();
        return this.params;
    }

    @Override
    public Aggregator<T, R> count(String fld) {
        this.params.add(UtilsMap.of("$count", fld));
        return this;
    }

    @Override
    public Aggregator<T, R> count(Enum fld) {
        return this.count(fld.name());
    }

    @Override
    public Aggregator<T, R> bucket(Expr groupBy, List<Expr> boundaries, Expr preset, Map<String, Expr> output) {
        LinkedHashMap<String, Expr> out = new LinkedHashMap<String, Expr>();
        for (Map.Entry<String, Expr> e : output.entrySet()) {
            out.put(e.getKey(), e.getValue());
        }
        ArrayList<Expr> bn = new ArrayList<Expr>(boundaries);
        UtilsMap<String, UtilsMap<String, Map<String, Object>>> m = UtilsMap.of("$bucket", UtilsMap.of("groupBy", groupBy, "boundaries", bn, "default", preset, "output", Utils.getQueryObjectMap(output)));
        this.params.add(m);
        return this;
    }

    @Override
    public Aggregator<T, R> bucketAuto(Expr groupBy, int numBuckets, Map<String, Expr> output, Aggregator.BucketGranularity granularity) {
        LinkedHashMap<String, Expr> out = null;
        if (output != null) {
            out = new LinkedHashMap<String, Expr>();
            for (Map.Entry<String, Expr> e : output.entrySet()) {
                out.put(e.getKey(), e.getValue());
            }
        }
        UtilsMap<String, Expr> bucketAuto = UtilsMap.of("groupBy", groupBy);
        bucketAuto.put("buckets", (Expr)((Object)Integer.valueOf(numBuckets)));
        UtilsMap<String, UtilsMap<String, Expr>> map = UtilsMap.of("$bucketAuto", bucketAuto);
        if (out != null) {
            bucketAuto.put("output", (Expr)((Object)out));
        }
        if (granularity != null) {
            bucketAuto.put("granularity", (Expr)((Object)granularity.getValue()));
        }
        this.params.add(map);
        return this;
    }

    @Override
    public Aggregator<T, R> collStats(Boolean latencyHistograms, Double scale, boolean count, boolean queryExecStats) {
        LinkedHashMap m = new LinkedHashMap();
        if (latencyHistograms != null) {
            m.put("latencyStats", UtilsMap.of("histograms", latencyHistograms));
        }
        if (scale != null) {
            m.put("storageStats", UtilsMap.of("scale", scale));
        }
        if (count) {
            m.put("count", new HashMap());
        }
        if (queryExecStats) {
            m.put("queryExecStats", new HashMap());
        }
        this.params.add(UtilsMap.of("$collStats", m));
        return this;
    }

    @Override
    public Aggregator<T, R> currentOp(boolean allUsers, boolean idleConnections, boolean idleCursors, boolean idleSessions, boolean localOps) {
        this.params.add(UtilsMap.of("$currentOp", UtilsMap.of("allUsers", allUsers, "idleConnections", idleConnections, "idleCursors", idleCursors, "idleSessions", idleSessions, "localOps", localOps)));
        return this;
    }

    @Override
    public Aggregator<T, R> facetExpr(Map<String, Expr> facets) {
        Map<String, Object> map = Utils.getQueryObjectMap(facets);
        this.params.add(UtilsMap.of("$facet", map));
        return this;
    }

    @Override
    public Aggregator<T, R> facet(Map<String, Aggregator> facets) {
        HashMap<String, List<Map<String, Object>>> map = new HashMap<String, List<Map<String, Object>>>();
        for (Map.Entry<String, Aggregator> e : facets.entrySet()) {
            map.put(e.getKey(), e.getValue().getPipeline());
        }
        this.params.add(UtilsMap.of("$facet", map));
        return this;
    }

    @Override
    public Aggregator<T, R> geoNear(Map<Aggregator.GeoNearFields, Object> param) {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        for (Map.Entry<Aggregator.GeoNearFields, Object> e : param.entrySet()) {
            map.put(e.getKey().name(), ((ObjectMapperImpl)this.morphium.getMapper()).marshallIfNecessary(e.getValue()));
        }
        this.params.add(UtilsMap.of("$geoNear", map));
        return this;
    }

    @Override
    public Aggregator<T, R> graphLookup(Class<?> type, Expr startWith, Enum connectFromField, Enum connectToField, String as, Integer maxDepth, String depthField, Query restrictSearchWithMatch) {
        return this.graphLookup(this.morphium.getMapper().getCollectionName(type), startWith, connectFromField.name(), connectToField.name(), as, maxDepth, depthField, restrictSearchWithMatch);
    }

    @Override
    public Aggregator<T, R> graphLookup(Class<?> type, Expr startWith, String connectFromField, String connectToField, String as, Integer maxDepth, String depthField, Query restrictSearchWithMatch) {
        return this.graphLookup(this.morphium.getMapper().getCollectionName(type), startWith, connectFromField, connectToField, as, maxDepth, depthField, restrictSearchWithMatch);
    }

    @Override
    public Aggregator<T, R> graphLookup(String fromCollection, Expr startWith, String connectFromField, String connectToField, String as, Integer maxDepth, String depthField, Query restrictSearchWithMatch) {
        UtilsMap<String, String> add = UtilsMap.of("from", fromCollection, "startWith", startWith, "connectFromField", connectFromField, "connectToField", connectToField, "as", as);
        this.params.add(UtilsMap.of("$graphLookup", add));
        if (maxDepth != null) {
            add.put("maxDepth", (String)((Object)maxDepth));
        }
        if (depthField != null) {
            add.put("depthField", depthField);
        }
        if (restrictSearchWithMatch != null) {
            add.put("restrictSearchWithMatch", (String)((Object)restrictSearchWithMatch));
        }
        return this;
    }

    @Override
    public Aggregator<T, R> indexStats() {
        this.params.add(UtilsMap.of("$indexStats", new HashMap()));
        return this;
    }

    @Override
    public Aggregator<T, R> listLocalSessionsAllUsers() {
        this.params.add(UtilsMap.of("$listLocalSessions", UtilsMap.of("allUsers", true)));
        return this;
    }

    @Override
    public Aggregator<T, R> listLocalSessions() {
        this.params.add(UtilsMap.of("$listLocalSessions", new HashMap()));
        return this;
    }

    @Override
    public Aggregator<T, R> listLocalSessions(List<String> users, List<String> dbs) {
        ArrayList<UtilsMap<String, String>> usersList = new ArrayList<UtilsMap<String, String>>();
        for (int i = 0; i < users.size(); ++i) {
            int j = i;
            if (j > dbs.size()) {
                j = dbs.size() - 1;
            }
            usersList.add(UtilsMap.of(users.get(i), dbs.get(j)));
        }
        this.params.add(UtilsMap.of("$listLocalSessions", UtilsMap.of("users", usersList)));
        return this;
    }

    @Override
    public Aggregator<T, R> listSessionsAllUsers() {
        this.params.add(UtilsMap.of("$listSessions", UtilsMap.of("allUsers", true)));
        return this;
    }

    @Override
    public Aggregator<T, R> listSessions() {
        this.params.add(UtilsMap.of("$listSessions", new HashMap()));
        return this;
    }

    @Override
    public Aggregator<T, R> listSessions(List<String> users, List<String> dbs) {
        ArrayList<UtilsMap<String, String>> usersList = new ArrayList<UtilsMap<String, String>>();
        for (int i = 0; i < users.size(); ++i) {
            int j = i;
            if (j > dbs.size()) {
                j = dbs.size() - 1;
            }
            usersList.add(UtilsMap.of(users.get(i), dbs.get(j)));
        }
        this.params.add(UtilsMap.of("$listSessions", UtilsMap.of("users", usersList)));
        return this;
    }

    @Override
    public Aggregator<T, R> lookup(Class fromType, Enum localField, Enum foreignField, String outputArray, List<Expr> pipeline, Map<String, Expr> let) {
        return this.lookup(this.getMorphium().getMapper().getCollectionName(fromType), this.getMorphium().getARHelper().getMongoFieldName(this.getSearchType(), localField.name()), this.getMorphium().getARHelper().getMongoFieldName(fromType, foreignField.name()), outputArray, pipeline, let);
    }

    @Override
    public Aggregator<T, R> lookup(String fromCollection, String localField, String foreignField, String outputArray, List<Expr> pipeline, Map<String, Expr> let) {
        HashMap<String, String> m = new HashMap<String, String>(UtilsMap.of("from", fromCollection));
        if (localField != null) {
            m.put("localField", localField);
        }
        if (foreignField != null) {
            m.put("foreignField", foreignField);
        }
        if (outputArray != null) {
            m.put("as", outputArray);
        }
        if (pipeline != null && pipeline.size() > 0) {
            ArrayList<Expr> lst = new ArrayList<Expr>(pipeline);
            m.put("pipeline", (String)((Object)lst));
        }
        if (let != null) {
            HashMap<String, Expr> map = new HashMap<String, Expr>();
            for (Map.Entry<String, Expr> e : let.entrySet()) {
                map.put(e.getKey(), e.getValue());
            }
            m.put("let", (String)((Object)map));
        }
        this.params.add(UtilsMap.of("$lookup", m));
        return this;
    }

    @Override
    public Aggregator<T, R> merge(String intoDb, String intoCollection, Aggregator.MergeActionWhenMatched matchAction, Aggregator.MergeActionWhenNotMatched notMatchedAction, String ... onFields) {
        return this.merge(intoDb, intoCollection, null, null, matchAction, notMatchedAction, onFields);
    }

    @Override
    public Aggregator<T, R> merge(String intoCollection, Map<String, Expr> let, List<Map<String, Expr>> machedPipeline, Aggregator.MergeActionWhenNotMatched notMatchedAction, String ... onFields) {
        return this.merge(this.morphium.getConfig().getDatabase(), intoCollection, let, machedPipeline, Aggregator.MergeActionWhenMatched.merge, notMatchedAction, onFields);
    }

    @Override
    public Aggregator<T, R> merge(Class<?> intoCollection, Map<String, Expr> let, List<Map<String, Expr>> machedPipeline, Aggregator.MergeActionWhenMatched matchAction, Aggregator.MergeActionWhenNotMatched notMatchedAction, String ... onFields) {
        return this.merge(this.morphium.getConfig().getDatabase(), this.morphium.getMapper().getCollectionName(intoCollection), let, machedPipeline, Aggregator.MergeActionWhenMatched.merge, notMatchedAction, onFields);
    }

    @Override
    public Aggregator<T, R> merge(String intoDb, String intoCollection) {
        return this.merge(intoDb, intoCollection, null, null, Aggregator.MergeActionWhenMatched.merge, Aggregator.MergeActionWhenNotMatched.insert, new String[0]);
    }

    @Override
    public Aggregator<T, R> merge(Class<?> intoCollection) {
        return this.merge(this.morphium.getConfig().getDatabase(), this.morphium.getMapper().getCollectionName(intoCollection), null, null, Aggregator.MergeActionWhenMatched.merge, Aggregator.MergeActionWhenNotMatched.insert, new String[0]);
    }

    @Override
    public Aggregator<T, R> merge(String intoCollection) {
        return this.merge(this.morphium.getConfig().getDatabase(), intoCollection, null, null, Aggregator.MergeActionWhenMatched.merge, Aggregator.MergeActionWhenNotMatched.insert, new String[0]);
    }

    @Override
    public Aggregator<T, R> merge(String intoCollection, Aggregator.MergeActionWhenMatched matchAction, Aggregator.MergeActionWhenNotMatched notMatchedAction, String ... onFields) {
        return this.merge(this.morphium.getConfig().getDatabase(), intoCollection, null, null, matchAction, notMatchedAction, onFields);
    }

    private Aggregator<T, R> merge(String intoDb, String intoCollection, Map<String, Expr> let, List<Map<String, Expr>> pipeline, Aggregator.MergeActionWhenMatched matchAction, Aggregator.MergeActionWhenNotMatched notMatchedAction, String ... onFields) {
        Class<?> entity = this.morphium.getMapper().getClassForCollectionName(intoCollection);
        ArrayList<String> flds = new ArrayList<String>();
        if (entity != null) {
            for (String f : onFields) {
                flds.add(this.morphium.getARHelper().getMongoFieldName(entity, f));
            }
        } else {
            this.log.warn("no entity know for collection " + intoCollection);
            this.log.warn("cannot check field names / properties");
            flds.addAll(Arrays.asList(onFields));
        }
        HashMap<String, UtilsMap<String, String>> doc = new HashMap<String, UtilsMap<String, String>>(UtilsMap.of("into", UtilsMap.of("db", intoDb, "coll", intoCollection)));
        if (let != null) {
            doc.put("let", (UtilsMap<String, String>)Utils.getNoExprMap(let));
        }
        if (matchAction != null) {
            doc.put("whenMatched", (UtilsMap<String, String>)((Object)matchAction.name()));
        }
        if (notMatchedAction != null) {
            doc.put("whenNotMatched", (UtilsMap<String, String>)((Object)notMatchedAction.name()));
        }
        if (onFields != null && onFields.length != 0) {
            doc.put("on", (UtilsMap<String, String>)((Object)flds));
        }
        if (pipeline != null) {
            doc.put("whenMatched", (UtilsMap<String, String>)((Object)pipeline));
        }
        this.params.add(UtilsMap.of("$merge", doc));
        return this;
    }

    @Override
    public Aggregator<T, R> out(String collectionName) {
        this.params.add(UtilsMap.of("$out", UtilsMap.of("coll", collectionName)));
        return this;
    }

    @Override
    public Aggregator<T, R> out(Class<?> type) {
        return this.out(this.morphium.getMapper().getCollectionName(type));
    }

    @Override
    public Aggregator<T, R> out(String db, String collectionName) {
        this.params.add(UtilsMap.of("$out", UtilsMap.of("coll", collectionName, "db", db)));
        return this;
    }

    @Override
    public Aggregator<T, R> planCacheStats(Map<String, Object> param) {
        this.params.add(UtilsMap.of("$planCacheStats", new HashMap()));
        return this;
    }

    @Override
    public Aggregator<T, R> redact(Expr redact) {
        this.params.add(UtilsMap.of("$redact", redact));
        return this;
    }

    @Override
    public Aggregator<T, R> replaceRoot(Expr newRoot) {
        this.params.add(UtilsMap.of("$replaceRoot", UtilsMap.of("newRoot", newRoot)));
        return this;
    }

    @Override
    public Aggregator<T, R> replaceWith(Expr newDoc) {
        this.params.add(UtilsMap.of("$replaceWith", newDoc));
        return this;
    }

    @Override
    public Aggregator<T, R> sample(int sampleSize) {
        this.params.add(UtilsMap.of("$sample", UtilsMap.of("size", sampleSize)));
        return this;
    }

    @Override
    public Aggregator<T, R> set(Map<String, Expr> param) {
        UtilsMap<String, Map<String, Object>> o = UtilsMap.of("$set", Utils.getQueryObjectMap(param));
        this.params.add(o);
        return this;
    }

    @Override
    public Aggregator<T, R> sortByCount(Expr sortby) {
        this.params.add(UtilsMap.of("$sortByCount", sortby));
        return this;
    }

    @Override
    public Aggregator<T, R> unionWith(String collection) {
        this.params.add(UtilsMap.of("$unionWith", collection));
        return this;
    }

    @Override
    public Aggregator<T, R> unionWith(Aggregator agg) {
        this.params.add(UtilsMap.of("$unionWith", UtilsMap.of("coll", this.collectionName, "pipeline", agg.getPipeline())));
        return this;
    }

    @Override
    public Aggregator<T, R> unset(List<String> field) {
        this.params.add(UtilsMap.of("$unset", field));
        return this;
    }

    @Override
    public Aggregator<T, R> unset(String ... param) {
        this.params.add(UtilsMap.of("$unset", Arrays.asList(param)));
        return this;
    }

    @Override
    public Aggregator<T, R> unset(Enum ... field) {
        List lst = Arrays.stream(field).map(Enum::name).collect(Collectors.toList());
        this.params.add(UtilsMap.of("$unset", lst));
        return this;
    }

    @Override
    public Aggregator<T, R> genericStage(String stageName, Object param) {
        if (!(param instanceof Expr)) {
            throw new IllegalArgumentException("inMemAggregation only works with Expr");
        }
        if (!((String)stageName).startsWith("$")) {
            stageName = "$" + (String)stageName;
        }
        this.params.add(UtilsMap.of(stageName, param));
        return this;
    }

    @Override
    public Aggregator<T, R> collation(Collation collation) {
        this.collation = collation;
        return this;
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    public List<Map<String, Object>> execStep(Map<String, Object> step, List<Map<String, Object>> data) {
        if (step.keySet().size() != 1) {
            throw new IllegalArgumentException("Pipeline start wrong");
        }
        stage = (String)step.keySet().stream().findFirst().get();
        ret = new ArrayList<Map<String, Object>>();
        var5_5 = stage;
        var6_6 = -1;
        switch (var5_5.hashCode()) {
            case 1142092165: {
                if (!var5_5.equals("$unset")) break;
                var6_6 = 0;
                break;
            }
            case -1992648075: {
                if (!var5_5.equals("$project")) break;
                var6_6 = 1;
                break;
            }
            case 1186238: {
                if (!var5_5.equals("$set")) break;
                var6_6 = 2;
                break;
            }
            case 1133580054: {
                if (!var5_5.equals("$addFields")) break;
                var6_6 = 3;
                break;
            }
            case 1125500779: {
                if (!var5_5.equals("$count")) break;
                var6_6 = 4;
                break;
            }
            case 1129278683: {
                if (!var5_5.equals("$group")) break;
                var6_6 = 5;
                break;
            }
            case 36778915: {
                if (!var5_5.equals("$skip")) break;
                var6_6 = 6;
                break;
            }
            case 1133625879: {
                if (!var5_5.equals("$limit")) break;
                var6_6 = 7;
                break;
            }
            case 1134317601: {
                if (!var5_5.equals("$match")) break;
                var6_6 = 8;
                break;
            }
            case 1045241669: {
                if (!var5_5.equals("$unwind")) break;
                var6_6 = 9;
                break;
            }
            case 979024588: {
                if (!var5_5.equals("$search")) break;
                var6_6 = 10;
                break;
            }
            case 36783042: {
                if (!var5_5.equals("$sort")) break;
                var6_6 = 11;
                break;
            }
            case 788266654: {
                if (!var5_5.equals("$lookup")) break;
                var6_6 = 12;
                break;
            }
            case 975686350: {
                if (!var5_5.equals("$sample")) break;
                var6_6 = 13;
                break;
            }
            case 1134434964: {
                if (!var5_5.equals("$merge")) break;
                var6_6 = 14;
                break;
            }
            case 782135058: {
                if (!var5_5.equals("$replaceRoot")) break;
                var6_6 = 15;
                break;
            }
            case 782278390: {
                if (!var5_5.equals("$replaceWith")) break;
                var6_6 = 16;
                break;
            }
            case 1127836691: {
                if (!var5_5.equals("$facet")) break;
                var6_6 = 17;
                break;
            }
            case 1872936810: {
                if (!var5_5.equals("$planCacheStats")) break;
                var6_6 = 18;
                break;
            }
            case 950468485: {
                if (!var5_5.equals("$redact")) break;
                var6_6 = 19;
                break;
            }
            case 913007761: {
                if (!var5_5.equals("$unionWith")) break;
                var6_6 = 20;
                break;
            }
            case -2121910890: {
                if (!var5_5.equals("$currentOp")) break;
                var6_6 = 21;
                break;
            }
            case 347878790: {
                if (!var5_5.equals("$listLocalSessions")) break;
                var6_6 = 22;
                break;
            }
            case -705166812: {
                if (!var5_5.equals("$findAndModyfy")) break;
                var6_6 = 23;
                break;
            }
            case 1046515181: {
                if (!var5_5.equals("$update")) break;
                var6_6 = 24;
                break;
            }
            case 507158286: {
                if (!var5_5.equals("$bucket")) break;
                var6_6 = 25;
                break;
            }
            case 850901469: {
                if (!var5_5.equals("$bucketAuto")) break;
                var6_6 = 26;
                break;
            }
            case 1909156054: {
                if (!var5_5.equals("$sortByCount")) break;
                var6_6 = 27;
                break;
            }
            case 1806558660: {
                if (!var5_5.equals("$graphLookup")) break;
                var6_6 = 28;
                break;
            }
            case 470319633: {
                if (!var5_5.equals("$indexStats")) break;
                var6_6 = 29;
                break;
            }
            case -1763259787: {
                if (!var5_5.equals("$geoNear")) break;
                var6_6 = 30;
                break;
            }
            case -912162449: {
                if (!var5_5.equals("$collStats")) break;
                var6_6 = 31;
                break;
            }
            case 516313471: {
                if (!var5_5.equals("$listSessions")) break;
                var6_6 = 32;
            }
        }
        block40 : switch (var6_6) {
            case 0: {
                for (Map<String, Object> objm : data) {
                    newO = new HashMap<String, Object>(objm);
                    if (step.get(stage) instanceof List) {
                        flds = (List)step.get(stage);
                        for (String f : flds) {
                            newO.remove(this.morphium.getARHelper().getMongoFieldName(this.type, f));
                        }
                    } else {
                        newO.remove(step.get(stage));
                    }
                    ret.add(newO);
                }
                break;
            }
            case 1: {
                for (Map<String, Object> o : data) {
                    obj = new HashMap<String, Object>(o);
                    ret.add(obj);
                    op = (Map)step.get(stage);
                    for (String k : op.keySet()) {
                        value = op.get(k);
                        if (value instanceof String && ((String)value).startsWith("$")) {
                            obj.put(k, obj.get(((String)value).substring(1)));
                            continue;
                        }
                        if (value instanceof Expr.ValueExpr) {
                            evaluate = ((Expr)value).evaluate(obj);
                            if (!Integer.valueOf(0).equals(evaluate)) continue;
                            obj.remove(k);
                            continue;
                        }
                        if (value instanceof Expr) {
                            evaluate = ((Expr)value).evaluate(obj);
                            obj.put(k, evaluate);
                            continue;
                        }
                        if (value instanceof Integer) {
                            if ((Integer)value != 0) continue;
                            obj.remove(k);
                            continue;
                        }
                        if (!(value instanceof Map)) continue;
                        for (String fld : ((Map)value).keySet()) {
                            if (obj.get(fld) instanceof Expr) {
                                obj.put(fld, ((Expr)obj.get(fld)).evaluate(obj));
                                continue;
                            }
                            this.log.error("InMemoryAggregation only works with Expr");
                        }
                    }
                }
                break;
            }
            case 2: 
            case 3: {
                for (Map<String, Object> o : data) {
                    obj = new HashMap<String, Object>(o);
                    ret.add(obj);
                    op = (Map)step.get(stage);
                    for (String k : op.keySet()) {
                        value = op.get(k);
                        if (value instanceof String && ((String)value).startsWith("$")) {
                            obj.put(k, obj.get(((String)value).substring(1)));
                            continue;
                        }
                        if (value instanceof Expr) {
                            obj.put(k, ((Expr)value).evaluate(obj));
                            continue;
                        }
                        if (!(value instanceof Map)) continue;
                        expr = Expr.parse(value);
                        obj.put(k, expr.evaluate(obj));
                    }
                }
                break;
            }
            case 4: {
                ret.add(UtilsMap.of((String)step.get(stage), data.size()));
                break;
            }
            case 5: {
                group = (Map)step.get(stage);
                res = new HashMap<Iterator<Map.Entry<K, V>>, HashMap<K, V>>();
                for (Map<String, Object> obj : data) {
                    o = new HashMap<String, Object>(obj);
                    id /* !! */  = group.get("_id");
                    if (id /* !! */  instanceof Map) {
                        if (((Map)id /* !! */ ).keySet().toArray()[0].toString().startsWith("$")) {
                            expr = Expr.parse(id /* !! */ );
                            result = expr.evaluate(obj);
                            res.putIfAbsent(result, new HashMap<K, V>());
                            ((Map)res.get(result)).putIfAbsent("_id", result);
                            id /* !! */  = result;
                        } else {
                            this.log.info("ID is combined...");
                            newIdMap = new HashMap<K, V>();
                            for (Map.Entry<K, V> e : ((Map)id /* !! */ ).entrySet()) {
                                k /* !! */  = e.getKey();
                                try {
                                    kEx = Expr.parse(e.getKey());
                                    k /* !! */  = kEx.evaluate(o);
                                    while (k /* !! */  instanceof Expr) {
                                        k /* !! */  = ((Expr)k /* !! */ ).evaluate(o);
                                    }
                                }
                                catch (Exception kEx) {
                                    // empty catch block
                                }
                                v = e.getValue();
                                try {
                                    vEy = Expr.parse(e.getValue());
                                    v = vEy.evaluate(o);
                                    while (v instanceof Expr) {
                                        v = ((Expr)v).evaluate(o);
                                    }
                                }
                                catch (Exception vEy) {
                                    // empty catch block
                                }
                                newIdMap.put(k /* !! */ , v);
                            }
                            id /* !! */  = newIdMap;
                            res.putIfAbsent(id /* !! */ , new HashMap<K, V>());
                            ((Map)res.get(id /* !! */ )).putIfAbsent("_id", newIdMap);
                        }
                    } else {
                        if (id /* !! */  != null && id /* !! */ .toString().startsWith("$")) {
                            id /* !! */  = o.get(id /* !! */ .toString().substring(1));
                        }
                        res.putIfAbsent(id /* !! */ , new HashMap<K, V>());
                        ((Map)res.get(id /* !! */ )).putIfAbsent("_id", id /* !! */ );
                    }
                    block125: for (String fld : group.keySet()) {
                        if (fld.equals("_id")) continue;
                        opValue = group.get(fld);
                        if (opValue instanceof Map) {
                            op = (String)((Map)opValue).keySet().stream().findFirst().get();
                            v = op;
                            vEy = -1;
                            switch (v.hashCode()) {
                                case -1890005014: {
                                    if (!v.equals("$addToSet")) break;
                                    vEy = 0;
                                    break;
                                }
                                case 36699454: {
                                    if (!v.equals("$push")) break;
                                    vEy = 1;
                                    break;
                                }
                                case 1169454: {
                                    if (!v.equals("$avg")) break;
                                    vEy = 2;
                                    break;
                                }
                                case 1128089868: {
                                    if (!v.equals("$first")) break;
                                    vEy = 3;
                                    break;
                                }
                                case 36561082: {
                                    if (!v.equals("$last")) break;
                                    vEy = 4;
                                    break;
                                }
                                case 1180352: {
                                    if (!v.equals("$max")) break;
                                    vEy = 5;
                                    break;
                                }
                                case 1180590: {
                                    if (!v.equals("$min")) break;
                                    vEy = 6;
                                    break;
                                }
                                case 1186727: {
                                    if (!v.equals("$sum")) break;
                                    vEy = 7;
                                    break;
                                }
                                case -72682528: {
                                    if (!v.equals("$mergeObjects")) break;
                                    vEy = 8;
                                    break;
                                }
                                case 473442786: {
                                    if (!v.equals("$accumulator")) break;
                                    vEy = 9;
                                    break;
                                }
                                case 718859867: {
                                    if (!v.equals("$stdDevPop")) break;
                                    vEy = 10;
                                    break;
                                }
                                case 809895335: {
                                    if (!v.equals("$stdDevSamp")) break;
                                    vEy = 11;
                                }
                            }
                            switch (vEy) {
                                case 0: 
                                case 1: {
                                    toPush = ((Map)opValue).get(op);
                                    setValue = null;
                                    if (toPush instanceof Map) {
                                        setValue = new HashMap<K, V>();
                                        for (Map.Entry<K, V> e : ((Map)toPush).entrySet()) {
                                            if (e.getValue() instanceof Expr) {
                                                ((Map)setValue).put(e.getKey(), ((Expr)e.getValue()).evaluate(o));
                                                continue;
                                            }
                                            if (e.getValue() instanceof String) {
                                                v = e.getValue().toString();
                                                if (v.startsWith("$")) {
                                                    setValue = o.get(v.substring(1));
                                                    continue;
                                                }
                                                setValue = v;
                                                continue;
                                            }
                                            setValue = e.getValue();
                                        }
                                    } else {
                                        v = (String)toPush;
                                        setValue = v.startsWith("$") != false ? o.get(v.substring(1)) : toPush;
                                    }
                                    ((Map)res.get(id /* !! */ )).putIfAbsent(fld, new ArrayList<E>());
                                    if (op.equals("$push")) {
                                        ((List)((Map)res.get(id /* !! */ )).get(fld)).add(setValue);
                                        break;
                                    }
                                    l = (List)((Map)res.get(id /* !! */ )).get(fld);
                                    if (l.contains(setValue)) continue block125;
                                    l.add(setValue);
                                    break;
                                }
                                case 2: {
                                    ((Map)res.get(id /* !! */ )).putIfAbsent("$_calc_" + fld, UtilsMap.of("sum", 0, "count", 0));
                                    if (((Map)opValue).get(op).toString().startsWith("$")) {
                                        count = (Number)((Map)((Map)res.get(id /* !! */ )).get("$_calc_" + fld)).get("count");
                                        count = count.intValue() + 1;
                                        ((Map)((Map)res.get(id /* !! */ )).get("$_calc_" + fld)).put("count", count);
                                        current = (Number)((Map)((Map)res.get(id /* !! */ )).get("$_calc_" + fld)).get("sum");
                                        v = (Number)o.get(((Map)opValue).get(op).toString().substring(1));
                                        sum = current.doubleValue() + v.doubleValue();
                                        ((Map)((Map)res.get(id /* !! */ )).get("$_calc_" + fld)).put("sum", sum);
                                        ((Map)res.get(id /* !! */ )).put(fld, sum / count.doubleValue());
                                        break;
                                    }
                                    this.log.error("Average with no $-reference?");
                                    break;
                                }
                                case 3: {
                                    ((Map)res.get(id /* !! */ )).putIfAbsent(fld, o.get(((Map)opValue).get(op).toString().substring(1)));
                                    break;
                                }
                                case 4: {
                                    ((Map)res.get(id /* !! */ )).put(fld, o.get(((Map)opValue).get(op).toString().substring(1)));
                                    break;
                                }
                                case 5: {
                                    if (!((Map)opValue).get(op).toString().startsWith("$")) continue block125;
                                    oVal = o.get(((Map)opValue).get(op).toString().substring(1));
                                    ((Map)res.get(id /* !! */ )).putIfAbsent(fld, oVal);
                                    if (((Comparable)((Map)res.get(id /* !! */ )).get(fld)).compareTo(oVal) <= 0) continue block125;
                                    ((Map)res.get(id /* !! */ )).put(fld, oVal);
                                    break;
                                }
                                case 6: {
                                    if (!((Map)opValue).get(op).toString().startsWith("$")) continue block125;
                                    oVal = o.get(((Map)opValue).get(op).toString().substring(1));
                                    ((Map)res.get(id /* !! */ )).putIfAbsent(fld, oVal);
                                    if (((Comparable)((Map)res.get(id /* !! */ )).get(fld)).compareTo(oVal) >= 0) continue block125;
                                    ((Map)res.get(id /* !! */ )).put(fld, oVal);
                                    break;
                                }
                                case 7: {
                                    ((Map)res.get(id /* !! */ )).putIfAbsent(fld, 0);
                                    current = (Number)((Map)res.get(id /* !! */ )).get(fld);
                                    if (((Map)opValue).get(op).toString().startsWith("$")) {
                                        v = (Number)o.get(((Map)opValue).get(op).toString().substring(1));
                                        ((Map)res.get(id /* !! */ )).put(fld, current.doubleValue() + v.doubleValue());
                                        break;
                                    }
                                    if (((Map)opValue).get(op) instanceof Number) {
                                        v = (Number)((Map)opValue).get(op);
                                        ((Map)res.get(id /* !! */ )).put(fld, current.doubleValue() + v.doubleValue());
                                        break;
                                    }
                                    if (!(((Map)opValue).get(op) instanceof Expr)) continue block125;
                                    v = (Number)o.get(((Expr)((Map)opValue).get(op)).evaluate(o));
                                    ((Map)res.get(id /* !! */ )).put(fld, current.doubleValue() + v.doubleValue());
                                    break;
                                }
                                case 8: {
                                    mergeValue = ((Map)opValue).get(op);
                                    mergedDoc = new HashMap<String, Object>();
                                    if (mergeValue instanceof String) {
                                        fieldName = mergeValue.toString();
                                        if (fieldName.startsWith("$")) {
                                            fieldName = fieldName.substring(1);
                                        }
                                        if ((fieldValue = o.get(fieldName)) instanceof Map) {
                                            mergedDoc.putAll((Map)fieldValue);
                                        } else if (fieldValue instanceof List) {
                                            for (E item : (List)fieldValue) {
                                                if (!(item instanceof Map)) continue;
                                                mergedDoc.putAll((Map)item);
                                            }
                                        }
                                    } else if (mergeValue instanceof Map) {
                                        for (Map.Entry entry : ((Map)mergeValue).entrySet()) {
                                            val = entry.getValue();
                                            if (val instanceof Expr) {
                                                mergedDoc.put((String)entry.getKey(), ((Expr)val).evaluate(o));
                                                continue;
                                            }
                                            if (val instanceof String && val.toString().startsWith("$")) {
                                                mergedDoc.put((String)entry.getKey(), o.get(val.toString().substring(1)));
                                                continue;
                                            }
                                            mergedDoc.put((String)entry.getKey(), val);
                                        }
                                    } else if (mergeValue instanceof List) {
                                        for (E item : (List)mergeValue) {
                                            if (item instanceof String && item.toString().startsWith("$")) {
                                                fieldValue = o.get(item.toString().substring(1));
                                                if (!(fieldValue instanceof Map)) continue;
                                                mergedDoc.putAll((Map)fieldValue);
                                                continue;
                                            }
                                            if (!(item instanceof Map)) continue;
                                            mergedDoc.putAll((Map)item);
                                        }
                                    }
                                    if (!((Map)res.get(id /* !! */ )).containsKey(fld)) {
                                        ((Map)res.get(id /* !! */ )).put(fld, new HashMap<K, V>());
                                    }
                                    if (((Map)res.get(id /* !! */ )).get(fld) instanceof Map) {
                                        ((Map)((Map)res.get(id /* !! */ )).get(fld)).putAll(mergedDoc);
                                        break;
                                    }
                                    ((Map)res.get(id /* !! */ )).put(fld, mergedDoc);
                                    break;
                                }
                                case 9: 
                                case 10: 
                                case 11: {
                                    throw new RuntimeException(op + " not implemented yet,sorry");
                                }
                                default: {
                                    if (opValue instanceof Map) {
                                        opMap = (Map)opValue;
                                        try {
                                            expr = Expr.parse(opMap);
                                            ((Map)res.get(id /* !! */ )).put(fld, expr.evaluate(o));
                                        }
                                        catch (Exception expr) {
                                            // empty catch block
                                        }
                                    }
                                    this.log.error("unknown accumulator " + op);
                                }
                            }
                            continue;
                        }
                        if (!(opValue instanceof String) || !opValue.toString().startsWith("$")) continue;
                        opValue = o.get(opValue.toString().substring(1));
                        ((Map)res.get(id /* !! */ )).put(fld, opValue);
                    }
                }
                ret.addAll(res.values());
                break;
            }
            case 6: 
            case 7: {
                op = step.get(stage);
                if (op instanceof Expr) {
                    op = ((Expr)op).evaluate(new HashMap<String, Object>());
                }
                idx = ((Number)op).intValue();
                if (stage.equals("$limit")) {
                    if (idx < data.size()) {
                        ret.addAll(data.subList(0, idx));
                        break;
                    }
                    ret.addAll(data);
                    break;
                }
                ret.addAll(data.subList(idx, data.size() - idx));
                break;
            }
            case 8: {
                colMap = this.collation == null ? null : this.collation.toQueryObject();
                for (Map<String, Object> doc : data) {
                    if (!QueryHelper.matchesQuery((Map)step.get(stage), doc, colMap)) continue;
                    ret.add(doc);
                }
                break;
            }
            case 9: {
                op = step.get(stage);
                for (Map<String, Object> o : data) {
                    if (op instanceof Map) {
                        op = ((Map)op).get("path");
                    }
                    if (op instanceof Expr) {
                        lst = (List)((Expr)op).evaluate(o);
                        n = ((Expr)op).toQueryObject().toString();
                    } else if (op instanceof String) {
                        if (op.toString().startsWith("$")) {
                            op = op.toString().substring(1);
                        }
                        n = op.toString();
                        lst = (List)o.get(op.toString());
                    } else {
                        this.log.error("Wrong reference: " + String.valueOf(op));
                        break block40;
                    }
                    if (lst == null) break block40;
                    for (E value : lst) {
                        result = new HashMap<String, Object>(o);
                        if (n.startsWith("$")) {
                            n = n.substring(1);
                        }
                        if (result.containsKey(n)) {
                            result.put(n, value);
                        } else {
                            result.put(new AnnotationAndReflectionHelper(true).convertCamelCase(n), value);
                        }
                        ret.add(result);
                    }
                }
                break;
            }
            case 10: {
                this.log.warn("The $search aggregation pipeline stage is only available for collections hosted on MongoDB Atlas cluster tiers running MongoDB version 4.2 or later. To learn more, see Atlas Search.");
                break;
            }
            case 11: {
                keysToSortBy = (Map)step.get(stage);
                sortedList = new ArrayList<Map<String, Object>>(data);
                sortedList.sort((Comparator)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)I, lambda$execStep$0(java.util.Map java.util.Map java.util.Map ), (Ljava/util/Map;Ljava/util/Map;)I)((Map)keysToSortBy));
                ret = sortedList;
                break;
            }
            case 12: {
                ret = new ArrayList<E>();
                lookup = (Map)step.get(stage);
                collection = (String)lookup.get("from");
                localField = (String)lookup.get("localField");
                foreignField = (String)lookup.get("foreignField");
                pipeline = (List)lookup.get("pipeline");
                let = (Map)lookup.get("let");
                as = (String)lookup.get("as");
                if (pipeline != null || let != null) {
                    for (Map<String, Object> doc : data) {
                        letContext = new HashMap<String, Object>();
                        if (let != null) {
                            for (Map.Entry<K, V> letEntry : let.entrySet()) {
                                varName = (String)letEntry.getKey();
                                varExpr = letEntry.getValue();
                                if (varExpr instanceof Expr) {
                                    varValue = ((Expr)varExpr).evaluate(doc);
                                } else if (varExpr instanceof Map) {
                                    expr = Expr.parse((Map)varExpr);
                                    varValue = expr.evaluate(doc);
                                } else {
                                    varValue = varExpr instanceof String ? ((strValue = (String)varExpr).startsWith("$$") ? letContext.get(strValue) : (strValue.startsWith("$") ? this.extractValueByPath(doc, strValue.substring(1)) : strValue)) : varExpr;
                                }
                                letContext.put("$$" + varName, varValue);
                            }
                        }
                        if ((foreignCollection = (database = (inMemDriver = (InMemoryDriver)this.morphium.getDriver()).getDatabase(this.morphium.getConfig().getDatabase())).get(collection)) != null) {
                            foreignData /* !! */  = new ArrayList<Map<String, Object>>(foreignCollection);
                            pipelineResults /* !! */  = new ArrayList<E>();
                            if (pipeline != null && !pipeline.isEmpty()) {
                                strValue = pipeline.iterator();
                                while (strValue.hasNext()) {
                                    pipelineItem = strValue.next();
                                    if (pipelineItem instanceof Expr) {
                                        pipelineStage = (Map)((Expr)pipelineItem).toQueryObject();
                                    } else {
                                        if (!(pipelineItem instanceof Map)) continue;
                                        pipelineStage = (Map)pipelineItem;
                                    }
                                    processedStage = this.substituteLetVariables(pipelineStage, letContext);
                                    foreignData /* !! */  = this.execStep(processedStage, foreignData /* !! */ );
                                }
                                pipelineResults /* !! */  = foreignData /* !! */ ;
                            } else {
                                pipelineResults /* !! */  = foreignData /* !! */ ;
                            }
                            resultDoc = new LinkedHashMap<String, Object>(doc);
                            resultDoc.put(as, pipelineResults /* !! */ );
                            ret.add(resultDoc);
                            continue;
                        }
                        resultDoc = new LinkedHashMap<String, Object>(doc);
                        resultDoc.put(as, new ArrayList<E>());
                        ret.add(resultDoc);
                    }
                } else {
                    for (Map<String, Object> doc : data) {
                        localValue = doc.get(localField);
                        inMemDriver = (InMemoryDriver)this.morphium.getDriver();
                        try {
                            database = inMemDriver.getDatabase(this.morphium.getConfig().getDatabase());
                            foreignCollection = database.get(collection);
                            if (foreignCollection == null) {
                                foreignCollection = new ArrayList<Map<String, Object>>();
                            }
                            matches = new ArrayList<HashMap<String, Object>>();
                            for (Map<String, Object> foreignDoc : foreignCollection) {
                                foreignValue = foreignDoc.get(foreignField);
                                if ((localValue != null || foreignValue != null) && (localValue == null || !localValue.equals(foreignValue))) continue;
                                matches.add(new HashMap<String, Object>(foreignDoc));
                            }
                            resultDoc = new HashMap<String, Object>(doc);
                            resultDoc.put(as, matches);
                            ret.add(resultDoc);
                        }
                        catch (Exception e) {
                            throw new RuntimeException("$lookup failed: " + e.getMessage(), e);
                        }
                    }
                }
                break;
            }
            case 13: {
                size = ((Number)((Map)step.get(stage)).get("size")).intValue();
                o = new ArrayList<Map<String, Object>>(data);
                Collections.shuffle(o);
                ret = o.subList(0, size);
                break;
            }
            case 14: {
                setting = (Map)step.get(stage);
                db = this.morphium.getConfig().getDatabase();
                coll = "";
                if (setting.get("into") instanceof Map) {
                    db = (String)((Map)setting.get("into")).get("db");
                    coll = (String)((Map)setting.get("into")).get("coll");
                } else {
                    coll = (String)setting.get("into");
                }
                if (!setting.containsKey("on")) break;
                on = (List)setting.get("on");
                notMatched = Aggregator.MergeActionWhenNotMatched.insert;
                matched = Aggregator.MergeActionWhenMatched.merge;
                mergePipeline = null;
                if (setting.containsKey("whenMatched")) {
                    if (setting.get("whenMatched") instanceof Map) {
                        mergePipeline = (List)setting.get("whenMatched");
                    } else {
                        matched = Aggregator.MergeActionWhenMatched.valueOf((String)setting.get("whenMatched"));
                    }
                }
                if (setting.containsKey("whenNotMatched")) {
                    notMatched = Aggregator.MergeActionWhenNotMatched.valueOf((String)setting.get("whenNotMatched"));
                }
                block138: for (Map<String, Object> doc : data) {
                    try {
                        q = new HashMap<String, Object>();
                        for (String onfld : on) {
                            q.put(onfld, doc.get(onfld));
                        }
                        toMergeTo = null;
                        if (toMergeTo == null || toMergeTo.size() == 0) {
                            switch (2.$SwitchMap$de$caluga$morphium$aggregation$Aggregator$MergeActionWhenNotMatched[notMatched.ordinal()]) {
                                case 1: {
                                    throw new MorphiumDriverException("Aggregation merge step failed - no doc matched!");
                                }
                                case 2: {
                                    continue block138;
                                }
                                case 3: {
                                    continue block138;
                                }
                                default: {
                                    throw new IllegalArgumentException("unknown whenNotMatched action " + String.valueOf((Object)notMatched));
                                }
                            }
                        }
                        if (toMergeTo.size() > 1) {
                            throw new MorphiumDriverException("Aggregation merge step failed - on fields query returned more than one value. On-Fields are not unique");
                        }
                        mergeObject = (Map)toMergeTo.get(0);
                        switch (2.$SwitchMap$de$caluga$morphium$aggregation$Aggregator$MergeActionWhenMatched[matched.ordinal()]) {
                            case 1: {
                                if (mergePipeline != null) {
                                    block140: for (Map mergePipelineStep : mergePipeline) {
                                        var38_191 = s = (String)mergePipelineStep.keySet().stream().findFirst().get();
                                        var39_198 = -1;
                                        switch (var38_191.hashCode()) {
                                            case 1186238: {
                                                if (!var38_191.equals("$set")) break;
                                                var39_198 = 0;
                                                break;
                                            }
                                            case 1133580054: {
                                                if (!var38_191.equals("$addFields")) break;
                                                var39_198 = 1;
                                                break;
                                            }
                                            case 1142092165: {
                                                if (!var38_191.equals("$unset")) break;
                                                var39_198 = 2;
                                                break;
                                            }
                                            case -1992648075: {
                                                if (!var38_191.equals("$project")) break;
                                                var39_198 = 3;
                                                break;
                                            }
                                            case 782135058: {
                                                if (!var38_191.equals("$replaceRoot")) break;
                                                var39_198 = 4;
                                                break;
                                            }
                                            case 782278390: {
                                                if (!var38_191.equals("$replaceWith")) break;
                                                var39_198 = 5;
                                            }
                                        }
                                        switch (var39_198) {
                                            case 0: 
                                            case 1: {
                                                continue block140;
                                            }
                                            case 2: {
                                                newO = new HashMap<String, Object>(doc);
                                                if (mergePipelineStep.get(s) instanceof List) {
                                                    flds = (List)mergePipelineStep.get(s);
                                                    for (String f : flds) {
                                                        newO.remove(f);
                                                    }
                                                } else {
                                                    newO.remove(mergePipelineStep.get(s));
                                                }
                                                ret.add(newO);
                                                continue block140;
                                            }
                                            case 3: {
                                                continue block140;
                                            }
                                            case 4: 
                                            case 5: {
                                                newRoot = mergePipelineStep.get(s) instanceof Map != false ? ((Map)mergePipelineStep.get(s)).get("newRoot") : mergePipelineStep.get(s);
                                                if (newRoot instanceof String) {
                                                    if (newRoot.toString().startsWith("$")) {
                                                        ret.add((Map)Expr.field(newRoot.toString()).evaluate(doc));
                                                        continue block140;
                                                    }
                                                    throw new IllegalArgumentException("cannot replace root with single value");
                                                }
                                                expr = Expr.parse(newRoot);
                                                ret.add((Map)expr.evaluate(doc));
                                                continue block140;
                                            }
                                        }
                                        throw new MorphiumDriverException("Aggregation error: unknown aggregation step in merge pipeline " + s);
                                    }
                                    continue block138;
                                }
                                if (mergeObject.containsKey("_id")) {
                                    throw new MorphiumDriverException("Aggregation merge failure: referenced object keeps _id!");
                                }
                                newDoc = new HashMap<String, Object>(doc);
                                newDoc.putAll(mergeObject);
                                break;
                            }
                            default: {
                                throw new IllegalArgumentException("unknown whenMatched action " + String.valueOf((Object)matched));
                            }
                        }
                    }
                    catch (MorphiumDriverException e) {
                        throw new RuntimeException(e);
                    }
                }
                break;
            }
            case 15: 
            case 16: {
                newRoot = step.get(stage) instanceof Map != false ? ((Map)step.get(stage)).get("newRoot") : step.get(stage);
                if (!(newRoot instanceof String)) ** GOTO lbl782
                if (newRoot.toString().startsWith("$")) {
                    for (Map<String, Object> doc : data) {
                        ret.add((Map)Expr.field(newRoot.toString()).evaluate(doc));
                    }
                } else {
                    throw new IllegalArgumentException("cannot replace root with single value");
lbl782:
                    // 1 sources

                    expr = Expr.parse(newRoot);
                    for (Map<String, Object> doc : data) {
                        ret.add((Map)expr.evaluate(doc));
                    }
                }
                break;
            }
            case 17: {
                op = step.get(stage);
                if (!(op instanceof Map)) break;
                facetMap = (Map)op;
                facetResult = new HashMap<String, ArrayList<E>>();
                for (Map.Entry<K, V> facetEntry : facetMap.entrySet()) {
                    facetName = (String)facetEntry.getKey();
                    facetPipeline = facetEntry.getValue();
                    facetResults /* !! */  = new ArrayList<E>();
                    if (facetPipeline instanceof List) {
                        tempData /* !! */  = new ArrayList<Map<String, Object>>(data);
                        facetSteps = (List)facetPipeline;
                        for (Map facetStep : facetSteps) {
                            tempData /* !! */  = this.execStep(facetStep, tempData /* !! */ );
                        }
                        facetResults /* !! */  = tempData /* !! */ ;
                    }
                    facetResult.put(facetName, facetResults /* !! */ );
                }
                ret = List.of(facetResult);
                break;
            }
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                op = step.get(stage);
                if (!(op instanceof Map)) break;
                bucketParams = (Map)op;
                groupByObj = bucketParams.get("groupBy");
                boundaries = (List)bucketParams.get("boundaries");
                defaultBucket = bucketParams.get("default");
                outputSpec = (Map)bucketParams.get("output");
                evaluatedBoundaries = new ArrayList<Object>();
                for (E boundary : boundaries) {
                    if (boundary instanceof Expr) {
                        evaluatedBoundaries.add(((Expr)boundary).evaluate(new HashMap<String, Object>()));
                        continue;
                    }
                    evaluatedBoundaries.add(boundary);
                }
                evaluatedDefaultBucket /* !! */  = defaultBucket;
                if (defaultBucket instanceof Expr) {
                    evaluatedDefaultBucket /* !! */  = ((Expr)defaultBucket).evaluate(new HashMap<String, Object>());
                }
                buckets = new LinkedHashMap<Object, ArrayList<E>>();
                for (i = 0; i < evaluatedBoundaries.size() - 1; ++i) {
                    buckets.put(evaluatedBoundaries.get(i), new ArrayList<E>());
                }
                if (evaluatedDefaultBucket /* !! */  != null) {
                    buckets.put(evaluatedDefaultBucket /* !! */ , new ArrayList<E>());
                }
                for (Map<String, Object> doc : data) {
                    if (groupByObj instanceof Expr) {
                        groupValue = ((Expr)groupByObj).evaluate(doc);
                    } else if (groupByObj instanceof String) {
                        fieldName = groupByObj.toString();
                        if (fieldName.startsWith("$")) {
                            fieldName = fieldName.substring(1);
                        }
                        groupValue = doc.get(fieldName);
                    } else {
                        groupValue = groupByObj;
                    }
                    assigned = false;
                    for (i = 0; i < evaluatedBoundaries.size() - 1; ++i) {
                        lowerBound = evaluatedBoundaries.get(i);
                        upperBound = evaluatedBoundaries.get(i + 1);
                        if (this.compareValues(groupValue, lowerBound) < 0 || this.compareValues(groupValue, upperBound) >= 0) continue;
                        ((List)buckets.get(lowerBound)).add(doc);
                        assigned = true;
                        break;
                    }
                    if (assigned || evaluatedDefaultBucket /* !! */  == null) continue;
                    ((List)buckets.get(evaluatedDefaultBucket /* !! */ )).add(doc);
                }
                ret = new ArrayList<E>();
                for (Map.Entry bucketEntry : buckets.entrySet()) {
                    if (((List)bucketEntry.getValue()).isEmpty()) continue;
                    bucketResult = new HashMap<String, Object>();
                    bucketResult.put("_id", bucketEntry.getKey());
                    if (outputSpec != null) {
                        for (Map.Entry<K, V> outputEntry : outputSpec.entrySet()) {
                            outputField = (String)outputEntry.getKey();
                            outputExpr = outputEntry.getValue();
                            result = this.computeGroupValue(outputExpr, (List)bucketEntry.getValue());
                            bucketResult.put(outputField, result);
                        }
                    } else {
                        bucketResult.put("count", ((List)bucketEntry.getValue()).size());
                    }
                    ret.add(bucketResult);
                }
                break;
            }
            case 26: {
                op = step.get(stage);
                if (!(op instanceof Map)) break;
                bucketAutoParams = (Map)op;
                groupByObj = bucketAutoParams.get("groupBy");
                numBuckets = (Integer)bucketAutoParams.get("buckets");
                outputSpec = (Map)bucketAutoParams.get("output");
                if (numBuckets == null) {
                    numBuckets = 5;
                }
                entries = new ArrayList<BucketValue>();
                for (Map<String, Object> doc : data) {
                    if (groupByObj instanceof Expr) {
                        value = ((Expr)groupByObj).evaluate(doc);
                    } else if (groupByObj instanceof String) {
                        fieldName = groupByObj.toString();
                        if (fieldName.startsWith("$")) {
                            fieldName = fieldName.substring(1);
                        }
                        value = doc.get(fieldName);
                    } else {
                        value = groupByObj;
                    }
                    if (value == null) continue;
                    entries.add(new BucketValue(value, doc));
                }
                entries.sort((Comparator)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)I, lambda$execStep$1(de.caluga.morphium.driver.inmem.InMemAggregator$BucketValue de.caluga.morphium.driver.inmem.InMemAggregator$BucketValue ), (Lde/caluga/morphium/driver/inmem/InMemAggregator$BucketValue;Lde/caluga/morphium/driver/inmem/InMemAggregator$BucketValue;)I)((InMemAggregator)this));
                ret = new ArrayList<E>();
                if (entries.isEmpty()) break;
                totalDocs = entries.size();
                docsPerBucket = totalDocs / numBuckets;
                remainder = totalDocs % numBuckets;
                currentIndex = 0;
                lastMaxValue = null;
                for (bucketNum = 0; bucketNum < numBuckets && currentIndex < totalDocs; ++bucketNum) {
                    currentBucketSize = docsPerBucket + (bucketNum < remainder ? 1 : 0);
                    endIndex = Math.min(currentIndex + currentBucketSize, totalDocs);
                    if (bucketNum == numBuckets - 1) {
                        endIndex = totalDocs;
                    }
                    bucketDocs = new ArrayList<Map<String, Object>>();
                    minValue = lastMaxValue != null ? lastMaxValue : ((BucketValue)entries.get((int)currentIndex)).value;
                    maxValue = ((BucketValue)entries.get((int)(endIndex - 1))).value;
                    for (j = currentIndex; j < endIndex; ++j) {
                        bucketDocs.add(((BucketValue)entries.get((int)j)).doc);
                    }
                    if (!bucketDocs.isEmpty()) {
                        bucketResult = new HashMap<String, Object>();
                        idRange = new HashMap<String, Object>();
                        idRange.put("min", minValue);
                        idRange.put("max", maxValue);
                        bucketResult.put("_id", idRange);
                        if (outputSpec != null) {
                            for (Map.Entry<K, V> outputEntry : outputSpec.entrySet()) {
                                outputField = (String)outputEntry.getKey();
                                outputExpr = outputEntry.getValue();
                                result = this.computeGroupValue(outputExpr, bucketDocs);
                                bucketResult.put(outputField, result);
                            }
                        } else {
                            bucketResult.put("count", bucketDocs.size());
                        }
                        ret.add(bucketResult);
                        lastMaxValue = maxValue;
                    }
                    currentIndex = endIndex;
                }
                break;
            }
            case 27: {
                op = step.get(stage);
                counts = new HashMap<Object, Integer>();
                for (Map<String, Object> doc : data) {
                    if (op instanceof Expr) {
                        value = ((Expr)op).evaluate(doc);
                    } else if (op instanceof String) {
                        fieldName = op.toString();
                        if (fieldName.startsWith("$")) {
                            fieldName = fieldName.substring(1);
                        }
                        value = doc.get(fieldName);
                    } else {
                        value = op;
                    }
                    counts.put(value, counts.getOrDefault(value, 0) + 1);
                }
                sortByCountResult = new ArrayList<E>();
                counts.entrySet().stream().sorted((Comparator)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)I, lambda$execStep$2(java.util.Map$Entry java.util.Map$Entry ), (Ljava/util/Map$Entry;Ljava/util/Map$Entry;)I)()).forEach((Consumer<Map.Entry>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, lambda$execStep$3(java.util.List java.util.Map$Entry ), (Ljava/util/Map$Entry;)V)(sortByCountResult));
                ret = sortByCountResult;
                break;
            }
            case 28: {
                op = step.get(stage);
                if (!(op instanceof Map)) break;
                graphParams = (Map)op;
                fromCollection = (String)graphParams.get("from");
                startWithObj = graphParams.get("startWith");
                connectFromField = (String)graphParams.get("connectFromField");
                connectToField = (String)graphParams.get("connectToField");
                asField = (String)graphParams.get("as");
                maxDepth = (Integer)graphParams.get("maxDepth");
                inMemDriver = (InMemoryDriver)this.morphium.getDriver();
                database = inMemDriver.getDatabase(this.morphium.getConfig().getDatabase());
                foreignCollection = database.get(fromCollection);
                if (foreignCollection != null) {
                    for (Map<String, Object> doc : data) {
                        graphResults = new ArrayList<HashMap<String, Object>>();
                        if (startWithObj instanceof Expr) {
                            startValue = ((Expr)startWithObj).evaluate(doc);
                        } else if (startWithObj instanceof String) {
                            fieldName = startWithObj.toString();
                            if (fieldName.startsWith("$")) {
                                fieldName = fieldName.substring(1);
                            }
                            startValue = doc.get(fieldName);
                        } else {
                            startValue = startWithObj;
                        }
                        visited = new HashSet<E>();
                        toVisit = new LinkedList<Object>();
                        toVisit.add(this.normalizeGraphValue(startValue));
                        for (currentDepth = 0; !(toVisit.isEmpty() || maxDepth != null && currentDepth >= maxDepth); ++currentDepth) {
                            nextLevel = new LinkedList<Object>();
                            while (!toVisit.isEmpty()) {
                                searchValue = toVisit.poll();
                                if (visited.contains(searchValue)) continue;
                                visited.add(searchValue);
                                for (Map<String, Object> foreignDoc : foreignCollection) {
                                    connectFromValue = foreignDoc.get(connectFromField);
                                    if (!this.graphValuesEqual(searchValue, connectFromValue)) continue;
                                    graphResults.add(new HashMap<String, Object>(foreignDoc));
                                    connectToValue = foreignDoc.get(connectToField);
                                    if (connectToValue == null || visited.contains(normalized = this.normalizeGraphValue(connectToValue))) continue;
                                    nextLevel.add(normalized);
                                }
                            }
                            toVisit = nextLevel;
                        }
                        doc.put(asField, graphResults);
                    }
                }
                ret = new ArrayList<Map<String, Object>>(data);
                break;
            }
            case 29: 
            case 30: {
                op = step.get(stage);
                if (!(op instanceof Map)) break;
                geoNearParams = (Map)op;
                nearPoint = geoNearParams.get("near");
                keyField = (String)geoNearParams.get("key");
                distanceField = (String)geoNearParams.get("distanceField");
                query = (Map)geoNearParams.get("query");
                geoResults = new ArrayList<LinkedHashMap<String, Object>>();
                for (Map<String, Object> doc : data) {
                    if (query != null && !QueryHelper.matchesQuery(query, doc, null) || (distance = this.calculateDistance(doc, nearPoint, keyField)) == null) continue;
                    resultDoc = new LinkedHashMap<String, Object>(doc);
                    this.setNestedValue(resultDoc, distanceField, distance);
                    geoResults.add(resultDoc);
                }
                geoResults.sort((Comparator)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)I, lambda$execStep$4(java.lang.String java.util.Map java.util.Map ), (Ljava/util/Map;Ljava/util/Map;)I)((InMemAggregator)this, (String)distanceField));
                ret = geoResults;
                break;
            }
            default: {
                this.log.error("unhandled Aggregation stage " + stage);
            }
        }
        return ret;
    }

    @Override
    public List<Map<String, Object>> aggregateMap() {
        return this.doAggregation();
    }

    private List<Map<String, Object>> doAggregation() {
        Query<T> q = this.getMorphium().createQueryFor(this.getSearchType());
        if (this.getCollectionName() != null) {
            q.setCollectionName(this.getCollectionName());
        }
        List<Map<String, Object>> result = q.asMapList();
        for (Map<String, Object> step : this.getPipeline()) {
            result = this.execStep(step, result);
        }
        return result;
    }

    private Object normalizeGraphValue(Object value) {
        if (value instanceof Number) {
            Number num = (Number)value;
            return num.doubleValue();
        }
        return value;
    }

    private boolean graphValuesEqual(Object a, Object b) {
        if (a == null || b == null) {
            return Objects.equals(a, b);
        }
        if (a instanceof Number && b instanceof Number) {
            return Double.compare(((Number)a).doubleValue(), ((Number)b).doubleValue()) == 0;
        }
        return Objects.equals(a, b);
    }

    @Override
    public Map<String, Object> explain() throws MorphiumDriverException {
        return this.explain(null);
    }

    @Override
    public Map<String, Object> explain(ExplainCommand.ExplainVerbosity verbosity) throws MorphiumDriverException {
        return Doc.of("err", "not supported with inMemDriver", "ok", (Object)0.0);
    }

    private int compareValues(Object value1, Object value2) {
        if (value1 == null && value2 == null) {
            return 0;
        }
        if (value1 == null) {
            return -1;
        }
        if (value2 == null) {
            return 1;
        }
        if (value1 instanceof Number && value2 instanceof Number) {
            double d1 = ((Number)value1).doubleValue();
            double d2 = ((Number)value2).doubleValue();
            return Double.compare(d1, d2);
        }
        if (value1 instanceof String && value2 instanceof String) {
            return ((String)value1).compareTo((String)value2);
        }
        return value1.toString().compareTo(value2.toString());
    }

    private Object extractGroupKey(Object groupIdSpec, Map<String, Object> doc) {
        if (groupIdSpec == null) {
            return null;
        }
        if (groupIdSpec instanceof String) {
            String fieldName = groupIdSpec.toString();
            if (fieldName.startsWith("$")) {
                fieldName = fieldName.substring(1);
            }
            return doc.get(fieldName);
        }
        if (groupIdSpec instanceof Expr) {
            return ((Expr)groupIdSpec).evaluate(doc);
        }
        if (groupIdSpec instanceof Map) {
            HashMap<String, Object> result = new HashMap<String, Object>();
            Map groupMap = (Map)groupIdSpec;
            for (Map.Entry entry : groupMap.entrySet()) {
                Object value = this.extractGroupKey(entry.getValue(), doc);
                result.put((String)entry.getKey(), value);
            }
            return result;
        }
        return groupIdSpec;
    }

    private Object computeGroupValue(Object valueSpec, List<Map<String, Object>> groupDocs) {
        if (valueSpec instanceof Expr) {
            Expr expr = (Expr)valueSpec;
            Object queryObj = expr.toQueryObject();
            if (queryObj instanceof Map) {
                return this.computeGroupValue(queryObj, groupDocs);
            }
            Object exprValue = expr.evaluate(new HashMap<String, Object>());
            if (exprValue instanceof Number && ((Number)exprValue).intValue() == 1) {
                return groupDocs.size();
            }
            double sum = 0.0;
            int count = 0;
            for (Map<String, Object> doc : groupDocs) {
                Object result = expr.evaluate(doc);
                if (!(result instanceof Number)) continue;
                sum += ((Number)result).doubleValue();
                ++count;
            }
            return count > 0 ? sum / (double)count : 0.0;
        }
        if (valueSpec instanceof Map) {
            Map specMap = (Map)valueSpec;
            String operation = (String)specMap.keySet().iterator().next();
            Object operand = specMap.get(operation);
            switch (operation) {
                case "$sum": {
                    double sum = 0.0;
                    for (Map<String, Object> doc : groupDocs) {
                        Object value = this.extractValue(operand, doc);
                        if (value instanceof Number) {
                            sum += ((Number)value).doubleValue();
                            continue;
                        }
                        if (value != null && this.isNumeric(value.toString())) {
                            sum += Double.parseDouble(value.toString());
                            continue;
                        }
                        if (value != null && !value.equals(1)) continue;
                        sum += 1.0;
                    }
                    return sum;
                }
                case "$avg": {
                    double total = 0.0;
                    int count = 0;
                    for (Map<String, Object> doc : groupDocs) {
                        Object value = this.extractValue(operand, doc);
                        if (!(value instanceof Number)) continue;
                        total += ((Number)value).doubleValue();
                        ++count;
                    }
                    return count > 0 ? total / (double)count : 0.0;
                }
                case "$min": {
                    Double min = null;
                    for (Map<String, Object> doc : groupDocs) {
                        Object value = this.extractValue(operand, doc);
                        if (!(value instanceof Number)) continue;
                        double d = ((Number)value).doubleValue();
                        if (min != null && !(d < min)) continue;
                        min = d;
                    }
                    return min;
                }
                case "$max": {
                    Double max = null;
                    for (Map<String, Object> doc : groupDocs) {
                        Object value = this.extractValue(operand, doc);
                        if (!(value instanceof Number)) continue;
                        double d = ((Number)value).doubleValue();
                        if (max != null && !(d > max)) continue;
                        max = d;
                    }
                    return max;
                }
                case "$first": {
                    if (!groupDocs.isEmpty()) {
                        return this.extractValue(operand, groupDocs.get(0));
                    }
                    return null;
                }
                case "$last": {
                    if (!groupDocs.isEmpty()) {
                        return this.extractValue(operand, groupDocs.get(groupDocs.size() - 1));
                    }
                    return null;
                }
                case "$push": {
                    ArrayList<Object> pushList = new ArrayList<Object>();
                    for (Map<String, Object> doc : groupDocs) {
                        pushList.add(this.extractValue(operand, doc));
                    }
                    return pushList;
                }
                case "$addToSet": {
                    HashSet<Object> uniqueSet = new HashSet<Object>();
                    for (Map<String, Object> doc : groupDocs) {
                        uniqueSet.add(this.extractValue(operand, doc));
                    }
                    return new ArrayList(uniqueSet);
                }
            }
            return null;
        }
        return valueSpec;
    }

    private Object extractValue(Object spec, Map<String, Object> doc) {
        if (spec instanceof String) {
            String fieldName = spec.toString();
            if (fieldName.startsWith("$")) {
                fieldName = fieldName.substring(1);
            }
            return doc.get(fieldName);
        }
        if (spec instanceof Expr) {
            return ((Expr)spec).evaluate(doc);
        }
        if (spec instanceof Map) {
            Map specMap = (Map)spec;
            LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
            for (Map.Entry entry : specMap.entrySet()) {
                String fieldName = (String)entry.getKey();
                Object fieldValue = entry.getValue();
                if (fieldValue instanceof Map) {
                    try {
                        Map exprMap = (Map)fieldValue;
                        Expr fieldExpr = Expr.parse(exprMap);
                        Object evaluatedValue = fieldExpr.evaluate(doc);
                        result.put(fieldName, evaluatedValue);
                    }
                    catch (Exception e) {
                        result.put(fieldName, fieldValue);
                    }
                    continue;
                }
                if (fieldValue instanceof String && ((String)fieldValue).startsWith("$")) {
                    String fieldRef = ((String)fieldValue).substring(1);
                    Object fieldVal = doc.get(fieldRef);
                    result.put(fieldName, fieldVal);
                    continue;
                }
                result.put(fieldName, fieldValue);
            }
            return result;
        }
        return spec;
    }

    private boolean isNumeric(String str) {
        try {
            Double.parseDouble(str);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    private Double calculateDistance(Map<String, Object> doc, Object nearPoint, String keyField) {
        Object locationValue = doc.get(keyField);
        if (locationValue == null || nearPoint == null) {
            return null;
        }
        try {
            double[] targetCoords = this.extractCoordinates(nearPoint);
            double[] docCoords = this.extractCoordinates(locationValue);
            if (targetCoords == null || docCoords == null) {
                return null;
            }
            double lon1 = Math.toRadians(targetCoords[0]);
            double lat1 = Math.toRadians(targetCoords[1]);
            double lon2 = Math.toRadians(docCoords[0]);
            double lat2 = Math.toRadians(docCoords[1]);
            double dlon = lon2 - lon1;
            double dlat = lat2 - lat1;
            double a = Math.pow(Math.sin(dlat / 2.0), 2.0) + Math.cos(lat1) * Math.cos(lat2) * Math.pow(Math.sin(dlon / 2.0), 2.0);
            double c = 2.0 * Math.asin(Math.sqrt(a));
            double r = 6371.0;
            return c * r;
        }
        catch (Exception e) {
            this.log.warn("Error calculating distance: {}", (Object)e.getMessage());
            return null;
        }
    }

    private double[] extractCoordinates(Object point) {
        List coords;
        if (point instanceof Map) {
            List coords2;
            Map pointMap = (Map)point;
            if ("Point".equals(pointMap.get("type")) && pointMap.containsKey("coordinates") && (coords2 = (List)pointMap.get("coordinates")) != null && coords2.size() >= 2) {
                return new double[]{((Number)coords2.get(0)).doubleValue(), ((Number)coords2.get(1)).doubleValue()};
            }
        } else if (point instanceof List && (coords = (List)point).size() >= 2) {
            return new double[]{((Number)coords.get(0)).doubleValue(), ((Number)coords.get(1)).doubleValue()};
        }
        return null;
    }

    private void setNestedValue(Map<String, Object> map, String path, Object value) {
        String[] parts = path.split("\\.");
        Map current = map;
        for (int i = 0; i < parts.length - 1; ++i) {
            String part = parts[i];
            if (!current.containsKey(part)) {
                current.put(part, new LinkedHashMap());
            }
            current = (Map)current.get(part);
        }
        current.put((String)parts[parts.length - 1], (Object)value);
    }

    private Double getNestedValue(Map<String, Object> map, String path) {
        String[] parts = path.split("\\.");
        Object current = map;
        for (String part : parts) {
            if (!(current instanceof Map)) {
                return null;
            }
            current = current.get(part);
        }
        return current instanceof Number ? Double.valueOf(((Number)current).doubleValue()) : null;
    }

    private Object extractValueByPath(Map<String, Object> map, String path) {
        String[] parts = path.split("\\.");
        Object current = map;
        for (String part : parts) {
            if (!(current instanceof Map)) {
                return null;
            }
            current = current.get(part);
        }
        return current;
    }

    private Map<String, Object> substituteLetVariables(Map<String, Object> stage, Map<String, Object> letContext) {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        for (Map.Entry<String, Object> entry : stage.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            if (value instanceof String) {
                String strValue = (String)value;
                for (Map.Entry<String, Object> letEntry : letContext.entrySet()) {
                    if (!strValue.equals(letEntry.getKey())) continue;
                    value = letEntry.getValue();
                    break;
                }
                result.put(key, value);
                continue;
            }
            if (value instanceof Map) {
                result.put(key, this.substituteLetVariables((Map)value, letContext));
                continue;
            }
            if (value instanceof List) {
                ArrayList<Object> newList = new ArrayList<Object>();
                for (Map.Entry<String, Object> item : (List)value) {
                    if (item instanceof Map) {
                        newList.add(this.substituteLetVariables((Map)((Object)item), letContext));
                        continue;
                    }
                    if (item instanceof String) {
                        String strItem = (String)((Object)item);
                        Object substituted = strItem;
                        for (Map.Entry<String, Object> letEntry : letContext.entrySet()) {
                            if (!strItem.equals(letEntry.getKey())) continue;
                            substituted = letEntry.getValue();
                            break;
                        }
                        newList.add(substituted);
                        continue;
                    }
                    newList.add(item);
                }
                result.put(key, newList);
                continue;
            }
            result.put(key, value);
        }
        return result;
    }

    private /* synthetic */ int lambda$execStep$4(String distanceField, Map a, Map b) {
        Double distA = this.getNestedValue(a, distanceField);
        Double distB = this.getNestedValue(b, distanceField);
        return Double.compare(distA != null ? distA : Double.MAX_VALUE, distB != null ? distB : Double.MAX_VALUE);
    }

    private static /* synthetic */ void lambda$execStep$3(List sortByCountResult, Map.Entry entry) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("_id", entry.getKey());
        result.put("count", entry.getValue());
        sortByCountResult.add(result);
    }

    private static /* synthetic */ int lambda$execStep$2(Map.Entry a, Map.Entry b) {
        return ((Integer)b.getValue()).compareTo((Integer)a.getValue());
    }

    private /* synthetic */ int lambda$execStep$1(BucketValue a, BucketValue b) {
        return this.compareValues(a.value, b.value);
    }

    private static /* synthetic */ int lambda$execStep$0(Map keysToSortBy, Map o1, Map o2) {
        for (String k : keysToSortBy.keySet()) {
            int i = ((Comparable)o1.get(k)).compareTo(o2.get(k));
            if (i == 0) continue;
            if (keysToSortBy.get(k).equals(-1)) {
                i = -i;
            }
            return i;
        }
        return 0;
    }

    private static final class BucketValue {
        final Object value;
        final Map<String, Object> doc;

        BucketValue(Object value, Map<String, Object> doc) {
            this.value = value;
            this.doc = doc;
        }
    }
}

