/*
 * Decompiled with CFR 0.152.
 */
package de.caluga.morphium.driver.commands;

import de.caluga.morphium.driver.MorphiumDriver;
import de.caluga.morphium.driver.MorphiumDriverException;
import de.caluga.morphium.driver.commands.MongoCommand;
import de.caluga.morphium.driver.wire.MongoConnection;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class WriteMongoCommand<T extends MongoCommand>
extends MongoCommand<T> {
    private Map<String, Object> writeConcern;
    private Boolean bypassDocumentValidation;

    public WriteMongoCommand(MongoConnection d) {
        super(d);
    }

    public Map<String, Object> getWriteConcern() {
        return this.writeConcern;
    }

    public T setWriteConcern(Map<String, Object> writeConcern) {
        this.writeConcern = writeConcern;
        return (T)this;
    }

    public Boolean getBypassDocumentValidation() {
        return this.bypassDocumentValidation;
    }

    public WriteMongoCommand<T> setBypassDocumentValidation(Boolean bypassDocumentValidation) {
        this.bypassDocumentValidation = bypassDocumentValidation;
        return this;
    }

    public Map<String, Object> execute() throws MorphiumDriverException {
        if (!this.getConnection().isConnected()) {
            throw new MorphiumDriverException("Not connected");
        }
        MongoConnection con = this.getConnection();
        this.setMetaData("server", con.getConnectedTo());
        long start = System.currentTimeMillis();
        int msg = con.sendCommand(this);
        try {
            Map<String, Object> crs = con.readSingleAnswer(msg);
            long dur = System.currentTimeMillis() - start;
            this.setMetaData("duration", dur);
            return crs;
        }
        catch (MorphiumDriverException e) {
            if (e.getMessage().equals("not primary")) {
                Logger log = LoggerFactory.getLogger(WriteMongoCommand.class);
                MorphiumDriver drv = this.getConnection().getDriver();
                drv.releaseConnection(this.getConnection());
                log.warn("node no primary anymore - waiting for failover");
                try {
                    Thread.sleep(drv.getHeartbeatFrequency() * 2);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                log.warn("Retrying... (recursive)");
                this.setConnection(drv.getPrimaryConnection(null));
                return this.execute();
            }
            throw e;
        }
    }
}

