/*
 * Decompiled with CFR 0.152.
 */
package de.caluga.morphium.driver.bson;

import de.caluga.morphium.driver.Doc;
import de.caluga.morphium.driver.MorphiumId;
import de.caluga.morphium.driver.bson.MongoJSScript;
import de.caluga.morphium.driver.bson.MongoMaxKey;
import de.caluga.morphium.driver.bson.MongoMinKey;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import java.util.UUID;
import java.util.regex.Pattern;

public class BsonDecoder {
    public static Map<String, Object> decodeDocument(byte[] in) throws UnsupportedEncodingException {
        Doc ret = Doc.of();
        BsonDecoder.decodeDocumentIn(ret, in, 0);
        return ret;
    }

    public static int decodeDocumentIn(Map<String, Object> ret, byte[] in, int startIndex) throws UnsupportedEncodingException {
        byte type;
        int sz = BsonDecoder.readInt(in, startIndex);
        if (sz > in.length) {
            throw new RuntimeException("error - size differs! read " + sz + " but buffer is " + in.length);
        }
        int idx = startIndex + 4;
        while (startIndex - 4 - idx < sz && (type = in[idx++]) != 0) {
            Object value;
            int l = 0;
            while (in[idx + l] != 0) {
                ++l;
            }
            String name = new String(in, idx, l, "UTF-8");
            idx += l + 1;
            switch (type) {
                case 1: {
                    long lng = BsonDecoder.readLong(in, idx);
                    value = Double.longBitsToDouble(lng);
                    idx += 8;
                    break;
                }
                case 2: {
                    int strlen = BsonDecoder.readInt(in, idx);
                    value = new String(in, idx + 4, strlen - 1, StandardCharsets.UTF_8);
                    idx += strlen + 4;
                    break;
                }
                case 3: {
                    Doc doc = Doc.of();
                    int len = BsonDecoder.decodeDocumentIn(doc, in, idx);
                    value = doc;
                    idx += len;
                    break;
                }
                case 4: {
                    Doc doc = Doc.of();
                    int len = BsonDecoder.decodeDocumentIn(doc, in, idx);
                    ArrayList lst = new ArrayList();
                    for (int i = 0; i < doc.size(); ++i) {
                        lst.add(doc.get("" + i));
                    }
                    value = lst;
                    idx += len;
                    break;
                }
                case 5: {
                    int boblen = BsonDecoder.readInt(in, idx);
                    byte subtype = in[idx + 4];
                    if (subtype == 3) {
                        u = new UUID(BsonDecoder.readLong(in, idx + 5), BsonDecoder.readLong(in, idx + 13));
                        value = u;
                    } else if (subtype == 4) {
                        u = new UUID(BsonDecoder.readLongBigEndian(in, idx + 5), BsonDecoder.readLongBigEndian(in, idx + 13));
                        value = u;
                    } else {
                        byte[] bobdata = new byte[boblen];
                        System.arraycopy(in, idx + 5, bobdata, 0, boblen);
                        value = bobdata;
                    }
                    idx += boblen + 5;
                    break;
                }
                case 6: 
                case 12: 
                case 14: {
                    throw new RuntimeException("deprecated type detected!");
                }
                case 7: {
                    value = new MorphiumId(in, idx);
                    idx += 12;
                    break;
                }
                case 8: {
                    value = in[idx] == 1;
                    ++idx;
                    break;
                }
                case 9: {
                    long lng = BsonDecoder.readLong(in, idx);
                    idx += 8;
                    value = new Date(lng);
                    break;
                }
                case 10: {
                    value = null;
                    break;
                }
                case 11: {
                    l = 0;
                    while (in[idx + l] != 0) {
                        ++l;
                    }
                    String pattern = new String(in, idx, l, "UTF-8");
                    idx += l + 1;
                    l = 0;
                    while (in[idx + l] != 0) {
                        ++l;
                    }
                    String opts = new String(in, idx, l, "UTF-8");
                    idx += l + 1;
                    int flags = 0;
                    if (opts.contains("i")) {
                        flags |= 2;
                    }
                    if (opts.contains("m")) {
                        flags |= 8;
                    }
                    if (opts.contains("l")) {
                        flags |= 0x10;
                    }
                    if (opts.contains("s")) {
                        flags |= 0x20;
                    }
                    if (opts.contains("u")) {
                        flags |= 0x40;
                    }
                    value = Pattern.compile(pattern, flags);
                    break;
                }
                case 13: {
                    int strlen = BsonDecoder.readInt(in, idx);
                    String code = new String(in, idx + 4, strlen - 1, "UTF-8");
                    value = new MongoJSScript(code);
                    idx += strlen + 4;
                    break;
                }
                case 15: {
                    int strlen = BsonDecoder.readInt(in, idx + 4);
                    String code = new String(in, idx + 8, strlen - 1, "UTF-8");
                    Doc scope = Doc.of();
                    int doclen = BsonDecoder.decodeDocumentIn(scope, in, idx + 8 + strlen);
                    value = new MongoJSScript(code, scope);
                    idx += doclen + 8 + strlen;
                    break;
                }
                case 16: {
                    value = BsonDecoder.readInt(in, idx);
                    idx += 4;
                    break;
                }
                case 17: 
                case 18: {
                    value = BsonDecoder.readLong(in, idx);
                    idx += 8;
                    break;
                }
                case -1: {
                    value = new MongoMinKey();
                    break;
                }
                case 127: {
                    value = new MongoMaxKey();
                }
                default: {
                    throw new RuntimeException("unknown data type: " + in[idx]);
                }
            }
            ret.put(name, value);
        }
        return sz;
    }

    public static int readInt(byte[] bytes, int idx) {
        return bytes[idx] & 0xFF | (bytes[idx + 1] & 0xFF) << 8 | (bytes[idx + 2] & 0xFF) << 16 | (bytes[idx + 3] & 0xFF) << 24;
    }

    public static long readLongBigEndian(byte[] bytes, int idx) {
        return (long)(bytes[idx + 7] & 0xFF) | (long)(bytes[idx + 6] & 0xFF) << 8 | (long)(bytes[idx + 5] & 0xFF) << 16 | (long)(bytes[idx + 4] & 0xFF) << 24 | (long)(bytes[idx + 3] & 0xFF) << 32 | (long)(bytes[idx + 2] & 0xFF) << 40 | (long)(bytes[idx + 1] & 0xFF) << 48 | (long)(bytes[idx + 0] & 0xFF) << 56;
    }

    public static long readLong(byte[] bytes, int idx) {
        return (long)(bytes[idx] & 0xFF) | (long)(bytes[idx + 1] & 0xFF) << 8 | (long)(bytes[idx + 2] & 0xFF) << 16 | (long)(bytes[idx + 3] & 0xFF) << 24 | (long)(bytes[idx + 4] & 0xFF) << 32 | (long)(bytes[idx + 5] & 0xFF) << 40 | (long)(bytes[idx + 6] & 0xFF) << 48 | (long)(bytes[idx + 7] & 0xFF) << 56;
    }
}

