/*
 * Decompiled with CFR 0.152.
 */
package de.caluga.morphium.config;

import de.caluga.morphium.annotations.Embedded;
import de.caluga.morphium.annotations.Transient;
import de.caluga.morphium.config.Settings;
import de.caluga.morphium.writer.AsyncWriterImpl;
import de.caluga.morphium.writer.BufferedMorphiumWriterImpl;
import de.caluga.morphium.writer.MorphiumWriter;
import de.caluga.morphium.writer.MorphiumWriterImpl;

@Embedded
public class WriterSettings
extends Settings {
    @Transient
    private MorphiumWriter writer;
    @Transient
    private MorphiumWriter bufferedWriter;
    @Transient
    private MorphiumWriter asyncWriter;
    private int maximumRetriesBufferedWriter = 10;
    private int maximumRetriesWriter = 10;
    private int maximumRetriesAsyncWriter = 10;
    private int retryWaitTimeBufferedWriter = 200;
    private int retryWaitTimeWriter = 200;
    private int retryWaitTimeAsyncWriter = 200;
    private int writeBufferTime = 1000;
    private int writeBufferTimeGranularity = 100;
    private int threadConnectionMultiplier = 5;

    public MorphiumWriter getWriter() {
        if (this.writer == null) {
            this.writer = new MorphiumWriterImpl();
        }
        return this.writer;
    }

    public WriterSettings setWriter(MorphiumWriter writer) {
        this.writer = writer;
        return this;
    }

    public MorphiumWriter getBufferedWriter() {
        if (this.bufferedWriter == null) {
            this.bufferedWriter = new BufferedMorphiumWriterImpl();
        }
        return this.bufferedWriter;
    }

    public WriterSettings setBufferedWriter(MorphiumWriter bufferedWriter) {
        this.bufferedWriter = bufferedWriter;
        return this;
    }

    public MorphiumWriter getAsyncWriter() {
        if (this.asyncWriter == null) {
            this.asyncWriter = new AsyncWriterImpl();
        }
        return this.asyncWriter;
    }

    public WriterSettings setAsyncWriter(MorphiumWriter asyncWriter) {
        this.asyncWriter = asyncWriter;
        return this;
    }

    public int getMaximumRetriesBufferedWriter() {
        return this.maximumRetriesBufferedWriter;
    }

    public WriterSettings setMaximumRetriesBufferedWriter(int maximumRetriesBufferedWriter) {
        this.maximumRetriesBufferedWriter = maximumRetriesBufferedWriter;
        return this;
    }

    public int getMaximumRetriesWriter() {
        return this.maximumRetriesWriter;
    }

    public WriterSettings setMaximumRetriesWriter(int maximumRetriesWriter) {
        this.maximumRetriesWriter = maximumRetriesWriter;
        return this;
    }

    public int getMaximumRetriesAsyncWriter() {
        return this.maximumRetriesAsyncWriter;
    }

    public WriterSettings setMaximumRetriesAsyncWriter(int maximumRetriesAsyncWriter) {
        this.maximumRetriesAsyncWriter = maximumRetriesAsyncWriter;
        return this;
    }

    public int getRetryWaitTimeBufferedWriter() {
        return this.retryWaitTimeBufferedWriter;
    }

    public WriterSettings setRetryWaitTimeBufferedWriter(int retryWaitTimeBufferedWriter) {
        this.retryWaitTimeBufferedWriter = retryWaitTimeBufferedWriter;
        return this;
    }

    public int getRetryWaitTimeWriter() {
        return this.retryWaitTimeWriter;
    }

    public WriterSettings setRetryWaitTimeWriter(int retryWaitTimeWriter) {
        this.retryWaitTimeWriter = retryWaitTimeWriter;
        return this;
    }

    public int getRetryWaitTimeAsyncWriter() {
        return this.retryWaitTimeAsyncWriter;
    }

    public WriterSettings setRetryWaitTimeAsyncWriter(int retryWaitTimeAsyncWriter) {
        this.retryWaitTimeAsyncWriter = retryWaitTimeAsyncWriter;
        return this;
    }

    public int getWriteBufferTime() {
        return this.writeBufferTime;
    }

    public WriterSettings setWriteBufferTime(int writeBufferTime) {
        this.writeBufferTime = writeBufferTime;
        return this;
    }

    public int getWriteBufferTimeGranularity() {
        return this.writeBufferTimeGranularity;
    }

    public WriterSettings setWriteBufferTimeGranularity(int writeBufferTimeGranularity) {
        this.writeBufferTimeGranularity = writeBufferTimeGranularity;
        return this;
    }

    public int getThreadConnectionMultiplier() {
        return this.threadConnectionMultiplier;
    }

    public WriterSettings setThreadConnectionMultiplier(int threadConnectionMultiplier) {
        this.threadConnectionMultiplier = threadConnectionMultiplier;
        return this;
    }
}

