/*
 * Decompiled with CFR 0.152.
 */
package de.caluga.morphium.config;

import de.caluga.morphium.AnnotationAndReflectionHelper;
import de.caluga.morphium.annotations.Embedded;
import de.caluga.morphium.annotations.Transient;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.function.Consumer;

@Embedded
public abstract class Settings {
    public Properties asProperties() {
        return this.asProperties(null);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (this.getClass() != other.getClass()) {
            return false;
        }
        AnnotationAndReflectionHelper an = new AnnotationAndReflectionHelper(true);
        List<Field> flds = an.getAllFields(this.getClass());
        for (Field f : flds) {
            if (f.isAnnotationPresent(Transient.class)) continue;
            f.setAccessible(true);
            try {
                Object thisValue = f.get(this);
                Object otherValue = f.get(other);
                if (thisValue == otherValue) {
                    return true;
                }
                if (thisValue == null || otherValue == null) {
                    return false;
                }
                if (thisValue.equals(otherValue)) continue;
                return false;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return true;
    }

    public int hashCode() {
        AnnotationAndReflectionHelper an = new AnnotationAndReflectionHelper(true);
        List<Field> flds = an.getAllFields(this.getClass());
        int result = 1;
        for (Field f : flds) {
            if (f.isAnnotationPresent(Transient.class)) continue;
            f.setAccessible(true);
            try {
                Object v = f.get(this);
                result = 31 * result + Objects.hashCode(v);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return result;
    }

    public Properties asProperties(String prefix) {
        Properties p = new Properties();
        try {
            prefix = prefix == null || ((String)prefix).isEmpty() ? "" : (String)prefix + ".";
            AnnotationAndReflectionHelper an = new AnnotationAndReflectionHelper(true);
            List<Field> flds = an.getAllFields(this.getClass());
            Settings defaults = (Settings)this.getClass().getConstructor(new Class[0]).newInstance(new Object[0]);
            for (Field f : flds) {
                if (f.isAnnotationPresent(Transient.class)) continue;
                f.setAccessible(true);
                if ((f.get(this) == null || f.get(this).equals(f.get(defaults))) && !f.getName().equals("database")) continue;
                p.put((String)prefix + f.getName(), f.get(this).toString());
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return p;
    }

    public <T extends Settings> T copy() {
        try {
            Settings ret = (Settings)this.getClass().getConstructor(new Class[0]).newInstance(new Object[0]);
            AnnotationAndReflectionHelper an = new AnnotationAndReflectionHelper(true);
            List<Field> flds = an.getAllFields(this.getClass());
            for (Field f : flds) {
                if (f.isAnnotationPresent(Transient.class)) continue;
                f.setAccessible(true);
                Object v = f.get(this);
                if (v == null) {
                    f.set(ret, null);
                    continue;
                }
                if (v instanceof List) {
                    f.set(ret, new ArrayList((List)v));
                    continue;
                }
                if (v instanceof Map) {
                    f.set(ret, new LinkedHashMap((Map)v));
                    continue;
                }
                if (v.getClass().isArray() && v instanceof Object[]) {
                    f.set(ret, ((Object[])v).clone());
                    continue;
                }
                f.set(ret, v);
            }
            return (T)ret;
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to copy settings for " + this.getClass().getName(), e);
        }
    }

    public <T extends Settings> T copyWith(Consumer<T> mutator) {
        T c = this.copy();
        if (mutator != null) {
            mutator.accept(c);
        }
        return c;
    }
}

