/*
 * Decompiled with CFR 0.152.
 */
package de.caluga.morphium.config;

import de.caluga.morphium.annotations.Embedded;
import de.caluga.morphium.config.Settings;
import java.util.ArrayList;
import java.util.List;

@Embedded
public class ClusterSettings
extends Settings {
    private String atlasUrl;
    private int heartbeatFrequency;
    private int replicaSetMonitoringTimeout = 5000;
    private boolean replicaset = true;
    private List<String> hostSeed = new ArrayList<String>();
    private String requiredReplicaSetName = null;

    public ClusterSettings setHostSeed(List<String> str, List<Integer> ports) {
        this.hostSeed.clear();
        for (int i = 0; i < str.size(); ++i) {
            String host = str.get(i).replaceAll(" ", "") + ":" + String.valueOf(ports.get(i));
            this.hostSeed.add(host);
        }
        return this;
    }

    public List<String> getHostSeed() {
        if (this.hostSeed == null) {
            this.hostSeed = new ArrayList<String>();
        }
        return this.hostSeed;
    }

    public ClusterSettings setHostSeed(String ... hostPorts) {
        this.hostSeed.clear();
        for (String h : hostPorts) {
            this.addHostToSeed(h);
        }
        return this;
    }

    public ClusterSettings addHostToSeed(String host) {
        if ((host = host.replaceAll(" ", "")).contains(":")) {
            String[] h = host.split(":");
            this.addHostToSeed(h[0], Integer.parseInt(h[1]));
        } else {
            this.addHostToSeed(host, 27017);
        }
        return this;
    }

    public boolean hostSeedIsSet() {
        return this.hostSeed != null && !this.hostSeed.isEmpty();
    }

    public int getReplicaSetMonitoringTimeout() {
        return this.replicaSetMonitoringTimeout;
    }

    public ClusterSettings setReplicaSetMonitoringTimeout(int replicaSetMonitoringTimeout) {
        this.replicaSetMonitoringTimeout = replicaSetMonitoringTimeout;
        return this;
    }

    public ClusterSettings setHostSeed(List<String> hostSeed) {
        this.hostSeed = hostSeed;
        return this;
    }

    public String getRequiredReplicaSetName() {
        return this.requiredReplicaSetName;
    }

    public ClusterSettings setRequiredReplicaSetName(String requiredReplicaSetName) {
        this.requiredReplicaSetName = requiredReplicaSetName;
        return this;
    }

    public ClusterSettings setHostSeed(String hostPorts) {
        String[] h;
        this.hostSeed.clear();
        for (String host : h = hostPorts.split(",")) {
            this.addHostToSeed(host);
        }
        return this;
    }

    public ClusterSettings setHostSeed(String hosts, String ports) {
        this.hostSeed.clear();
        hosts = hosts.replaceAll(" ", "");
        ports = ports.replaceAll(" ", "");
        String[] h = hosts.split(",");
        String[] p = ports.split(",");
        for (int i = 0; i < h.length; ++i) {
            if (p.length < i) {
                this.addHostToSeed(h[i], 27017);
                continue;
            }
            this.addHostToSeed(h[i], Integer.parseInt(p[i]));
        }
        return this;
    }

    public ClusterSettings addHostToSeed(String host, int port) {
        host = ((String)host).replaceAll(" ", "") + ":" + port;
        if (this.hostSeed == null) {
            this.hostSeed = new ArrayList<String>();
        }
        this.hostSeed.add((String)host);
        return this;
    }

    public String getAtlasUrl() {
        return this.atlasUrl;
    }

    public ClusterSettings setAtlasUrl(String atlasUrl) {
        this.atlasUrl = atlasUrl;
        return this;
    }

    public int getHeartbeatFrequency() {
        return this.heartbeatFrequency;
    }

    public ClusterSettings setHeartbeatFrequency(int heartbeatFrequency) {
        this.heartbeatFrequency = heartbeatFrequency;
        return this;
    }

    public boolean isReplicaset() {
        return this.replicaset;
    }

    public ClusterSettings setReplicaset(boolean replicaset) {
        this.replicaset = replicaset;
        return this;
    }
}

