/*
 * Decompiled with CFR 0.152.
 */
package de.caluga.morphium;

import de.caluga.morphium.Morphium;
import de.caluga.morphium.Sequence;
import de.caluga.morphium.query.Query;
import java.util.Date;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.LockSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SequenceGenerator {
    private static final Logger log = LoggerFactory.getLogger(SequenceGenerator.class);
    private int inc;
    private long startValue;
    private Morphium morphium;
    private String id;
    private String name;

    public SequenceGenerator(Morphium m, String n) {
        this(m, n, 1, 1L);
    }

    public SequenceGenerator(Morphium mrph, String name, int inc, long startValue) {
        block3: {
            this.inc = inc;
            if (inc == 0) {
                throw new IllegalArgumentException("Cannot use increment value 0!");
            }
            this.name = name;
            this.startValue = startValue;
            this.morphium = mrph;
            this.id = UUID.randomUUID().toString();
            String db = this.morphium.getConfig().connectionSettings().getDatabase();
            log.info("SequenceGenerator init: db={}, name={}, startValue={}, inc={}, thread={}", new Object[]{db, name, startValue, inc, Thread.currentThread().getName()});
            try {
                Sequence s = new Sequence();
                s.setCurrentValue(startValue - (long)inc);
                s.setName(name);
                this.morphium.insert(s);
                log.info("Sequence '{}' inserted successfully in db '{}' with initial value={}, thread={}", new Object[]{name, db, startValue - (long)inc, Thread.currentThread().getName()});
            }
            catch (Exception e) {
                log.info("Sequence '{}' already exists in db '{}' (this is normal in concurrent scenarios), thread={}: {}", new Object[]{name, db, Thread.currentThread().getName(), e.getMessage()});
                if (!log.isDebugEnabled()) break block3;
                log.debug("Full exception:", (Throwable)e);
            }
        }
        this.morphium.ensureIndicesFor(Sequence.class);
        this.morphium.ensureIndicesFor(Sequence.SeqLock.class);
    }

    public long getCurrentValue() {
        Sequence s = this.morphium.createQueryFor(Sequence.class).f("_id").eq(this.name).get();
        if (s == null) {
            log.warn("getCurrentValue() - Sequence '{}' is NULL, calling getNextValue(), thread={}", (Object)this.name, (Object)Thread.currentThread().getName());
            return this.getNextValue();
        }
        if (s.getCurrentValue() == null) {
            log.warn("getCurrentValue() - Sequence '{}' exists but currentValue is NULL, calling getNextValue(), thread={}", (Object)this.name, (Object)Thread.currentThread().getName());
            return this.getNextValue();
        }
        return s.getCurrentValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getNextValue() {
        long start = System.currentTimeMillis();
        Sequence.SeqLock lock = new Sequence.SeqLock();
        lock.setName(this.name);
        lock.setLockedAt(new Date());
        lock.setLockedBy(this.id);
        while (true) {
            if (System.currentTimeMillis() - start > 100000L) {
                throw new RuntimeException(String.format("Getting lock on seqence %s failed!", this.name));
            }
            try {
                this.morphium.insert(lock);
            }
            catch (Exception e) {
                LockSupport.parkNanos(TimeUnit.MILLISECONDS.toNanos((long)(100.0 * Math.random() + 10.0)));
                continue;
            }
            break;
        }
        try {
            Query<Sequence> seq = this.morphium.createQueryFor(Sequence.class).f("_id").eq(this.name);
            Sequence val = seq.get();
            int count = 0;
            while (val == null) {
                if (count++ > this.morphium.getConfig().connectionSettings().getRetriesOnNetworkError()) {
                    throw new RuntimeException("Could not read from Sequence");
                }
                try {
                    Thread.sleep(this.morphium.getConfig().connectionSettings().getSleepBetweenNetworkErrorRetries());
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                val = seq.get();
            }
            this.morphium.inc((Object)val, "current_value", this.inc);
            count = 0;
            while ((val = seq.get()) == null) {
                if (count++ > this.morphium.getConfig().connectionSettings().getRetriesOnNetworkError()) {
                    throw new RuntimeException("Sequence disappeared after increment!");
                }
                try {
                    Thread.sleep(this.morphium.getConfig().connectionSettings().getSleepBetweenNetworkErrorRetries());
                }
                catch (InterruptedException interruptedException) {}
            }
            long l = val.getCurrentValue();
            return l;
        }
        finally {
            this.morphium.delete(lock);
        }
    }

    public int getInc() {
        return this.inc;
    }

    public void setInc(int inc) {
        this.inc = inc;
    }

    public long getStartValue() {
        return this.startValue;
    }

    public void setStartValue(long startValue) {
        this.startValue = startValue;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Morphium getMorphium() {
        return this.morphium;
    }

    public void setMorphium(Morphium morphium) {
        this.morphium = morphium;
    }
}

