/*
 * Decompiled with CFR 0.152.
 */
package de.caluga.morphium;

import com.fasterxml.jackson.databind.ObjectMapper;
import de.caluga.morphium.AnnotationAndReflectionHelper;
import de.caluga.morphium.MorphiumConfigResolver;
import de.caluga.morphium.ObjectMapperImpl;
import de.caluga.morphium.Utils;
import de.caluga.morphium.annotations.AdditionalData;
import de.caluga.morphium.annotations.Embedded;
import de.caluga.morphium.annotations.Transient;
import de.caluga.morphium.cache.MorphiumCache;
import de.caluga.morphium.config.AuthSettings;
import de.caluga.morphium.config.CacheSettings;
import de.caluga.morphium.config.ClusterSettings;
import de.caluga.morphium.config.CollectionCheckSettings;
import de.caluga.morphium.config.ConnectionSettings;
import de.caluga.morphium.config.DriverSettings;
import de.caluga.morphium.config.EncryptionSettings;
import de.caluga.morphium.config.MessagingSettings;
import de.caluga.morphium.config.ObjectMappingSettings;
import de.caluga.morphium.config.Settings;
import de.caluga.morphium.config.ThreadPoolSettings;
import de.caluga.morphium.config.WriterSettings;
import de.caluga.morphium.driver.ReadPreference;
import de.caluga.morphium.driver.ReadPreferenceType;
import de.caluga.morphium.encryption.EncryptionKeyProvider;
import de.caluga.morphium.encryption.ValueEncryptionProvider;
import de.caluga.morphium.writer.MorphiumWriter;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import org.json.simple.parser.ParseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Embedded
public class MorphiumConfig {
    @AdditionalData(readOnly=false)
    private Map<String, Object> restoreData;
    @Transient
    private static Logger log = LoggerFactory.getLogger(MorphiumConfig.class);
    @Transient
    private MessagingSettings messagingSettings = new MessagingSettings();
    @Transient
    private CollectionCheckSettings collectionCheckSettings = new CollectionCheckSettings();
    @Transient
    private ConnectionSettings connectionSettings = new ConnectionSettings();
    @Transient
    private DriverSettings driverSettings = new DriverSettings();
    @Transient
    private EncryptionSettings encryptionSettings = new EncryptionSettings();
    @Transient
    private ObjectMappingSettings objectMappingSettings = new ObjectMappingSettings();
    @Transient
    private ThreadPoolSettings threadPoolSettings = new ThreadPoolSettings();
    @Transient
    private WriterSettings writerSettings = new WriterSettings();
    @Transient
    private CacheSettings cacheSettings = new CacheSettings();
    @Transient
    private AuthSettings authSettings = new AuthSettings();
    @Transient
    private ClusterSettings clusterSettings = new ClusterSettings();
    @Transient
    private List<Settings> settings = List.of(this.clusterSettings, this.authSettings, this.writerSettings, this.threadPoolSettings, this.objectMappingSettings, this.driverSettings, this.connectionSettings, this.collectionCheckSettings, this.messagingSettings);

    private void rebuildSettingsList() {
        this.settings = List.of(this.clusterSettings, this.authSettings, this.writerSettings, this.threadPoolSettings, this.objectMappingSettings, this.driverSettings, this.connectionSettings, this.collectionCheckSettings, this.messagingSettings);
    }

    public MessagingSettings messagingSettings() {
        return this.messagingSettings;
    }

    public CollectionCheckSettings collectionCheckSettings() {
        return this.collectionCheckSettings;
    }

    public EncryptionSettings encryptionSettings() {
        return this.encryptionSettings;
    }

    public ObjectMappingSettings objectMappingSettings() {
        return this.objectMappingSettings;
    }

    public ThreadPoolSettings threadPoolSettings() {
        return this.threadPoolSettings;
    }

    public WriterSettings writerSettings() {
        return this.writerSettings;
    }

    public CacheSettings cacheSettings() {
        return this.cacheSettings;
    }

    public ConnectionSettings connectionSettings() {
        return this.connectionSettings;
    }

    public DriverSettings driverSettings() {
        return this.driverSettings;
    }

    public AuthSettings authSettings() {
        return this.authSettings;
    }

    public ClusterSettings clusterSettings() {
        return this.clusterSettings;
    }

    @Deprecated
    public boolean isMessagingStatusInfoListenerEnabled() {
        return this.messagingSettings.isMessagingStatusInfoListenerEnabled();
    }

    @Deprecated
    public MorphiumConfig setMessagingStatusInfoListenerEnabled(boolean messagingStatusInfoListenerEnabled) {
        this.messagingSettings.setMessagingStatusInfoListenerEnabled(messagingStatusInfoListenerEnabled);
        return this;
    }

    @Deprecated
    public String getMessagingStatusInfoListenerName() {
        return this.messagingSettings.getMessagingStatusInfoListenerName();
    }

    @Deprecated
    public MorphiumConfig setMessagingStatusInfoListenerName(String name) {
        this.messagingSettings.setMessagingStatusInfoListenerName(name);
        return this;
    }

    public MorphiumConfig(Properties prop) {
        this(null, prop);
    }

    public MorphiumConfig(String prefix, Properties prop) {
        this(prefix, prop::get);
    }

    /*
     * WARNING - void declaration
     */
    public MorphiumConfig(String prefix, MorphiumConfigResolver resolver) {
        String lst;
        AnnotationAndReflectionHelper an = new AnnotationAndReflectionHelper(true);
        prefix = prefix != null && !((String)prefix).isEmpty() ? (String)prefix + "." : "";
        for (Settings settings : this.settings) {
            List<Field> flds = an.getAllFields(settings.getClass());
            for (Field f : flds) {
                String fName = (String)prefix + f.getName();
                Object setting = resolver.resolveSetting(fName);
                if (setting == null && (setting = resolver.resolveSetting(fName = (String)prefix + an.convertCamelCase(f.getName()))) == null && (setting = resolver.resolveSetting(fName = (String)prefix + an.createCamelCase(f.getName(), false))) == null) continue;
                f.setAccessible(true);
                try {
                    if (f.getType().isEnum()) {
                        Object value = Enum.valueOf(f.getType(), (String)setting);
                        f.set(settings, value);
                        continue;
                    }
                    if (f.getType().equals(Integer.TYPE) || f.getType().equals(Integer.class)) {
                        f.set(settings, Integer.parseInt((String)setting));
                        continue;
                    }
                    if (f.getType().equals(Long.TYPE) || f.getType().equals(Long.class)) {
                        f.set(settings, Long.parseLong((String)setting));
                        continue;
                    }
                    if (f.getType().equals(String.class)) {
                        f.set(settings, setting);
                        continue;
                    }
                    if (f.getType().equals(Boolean.TYPE) || f.getType().equals(Boolean.class)) {
                        f.set(settings, setting.equals("true"));
                        continue;
                    }
                    if (List.class.isAssignableFrom(f.getType())) {
                        String lst2 = (String)setting;
                        ArrayList l = new ArrayList();
                        lst2 = lst2.replaceAll("[\\[\\]]", "");
                        Collections.addAll(l, lst2.split(","));
                        ArrayList<String> ret = new ArrayList<String>();
                        for (String n : l) {
                            ret.add(n.trim());
                        }
                        f.set(settings, ret);
                        continue;
                    }
                    f.set(settings, setting);
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        if (!this.clusterSettings.hostSeedIsSet() && (lst = (String)resolver.resolveSetting((String)prefix + "hosts")) != null) {
            lst = lst.replaceAll("[\\[\\]]", "");
            for (String s : lst.split(",")) {
                this.clusterSettings.addHostToSeed(s);
            }
        }
        if (resolver.resolveSetting((String)prefix + "driver_class") != null || resolver.resolveSetting((String)prefix + "driverClass") != null) {
            String n = "driver_name";
            if (resolver.resolveSetting("driverName") != null) {
                n = "driverName";
            }
            if (resolver.resolveSetting(n) != null) {
                log.error("not using driver_class - drivername is set {}", resolver.resolveSetting(n));
                this.driverSettings.setDriverName((String)resolver.resolveSetting(n));
            } else {
                Object object = resolver.resolveSetting((String)prefix + "driver_class");
                if (object == null) {
                    Object object2 = resolver.resolveSetting((String)prefix + "driverClass");
                }
                try {
                    void var5_10;
                    Class<?> driverClass = Class.forName((String)var5_10);
                    Method m = driverClass.getMethod("getName", null);
                    m.setAccessible(true);
                    this.driverSettings.setDriverName((String)m.invoke(null, new Object[0]));
                }
                catch (Exception e) {
                    log.error("Cannot set driver class - using default driver instead!");
                    this.driverSettings.setDriverName("PooledDriver");
                }
            }
        }
        this.rebuildSettingsList();
    }

    public MorphiumConfig() {
        this("test", 10, 60000, 10000);
    }

    public MorphiumConfig(String db, int maxConnections, int globalCacheValidTime, int housekeepingTimeout) {
        this.connectionSettings.setDatabase(db);
        this.connectionSettings.setMaxConnections(maxConnections);
        this.cacheSettings.setGlobalCacheValidTime(globalCacheValidTime);
        this.cacheSettings.setHousekeepingTimeout(housekeepingTimeout);
        this.rebuildSettingsList();
    }

    public static List<String> getPropertyNames(String prefix) {
        List<String> flds = new AnnotationAndReflectionHelper(true).getFields(MorphiumConfig.class, new Class[0]);
        ArrayList<String> ret = new ArrayList<String>();
        for (String f : flds) {
            ret.add(prefix + "." + f);
        }
        return ret;
    }

    public static MorphiumConfig createFromJson(String json) throws NoSuchFieldException, ClassNotFoundException, IllegalAccessException, InstantiationException, ParseException, NoSuchMethodException, InvocationTargetException {
        HashMap obj;
        ObjectMapper jacksonOM = new ObjectMapper();
        try {
            obj = (HashMap)jacksonOM.readValue(json.getBytes(), Map.class);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        Properties p = new Properties();
        for (Map.Entry e : obj.entrySet()) {
            if (e.getValue() != null) {
                p.put(e.getKey(), e.getValue().toString());
            }
            log.info("Adding {} = {}", e.getKey(), e.getValue());
        }
        MorphiumConfig cfg = MorphiumConfig.fromProperties(p);
        return cfg;
    }

    @Deprecated
    public int getMessagingWindowSize() {
        return this.messagingSettings.getMessagingWindowSize();
    }

    @Deprecated
    public void setMessagingWindowSize(int messagingWindowSize) {
        this.messagingSettings.setMessagingWindowSize(messagingWindowSize);
    }

    public static MorphiumConfig fromProperties(String prefix, Properties p) {
        return new MorphiumConfig(prefix, p);
    }

    public static MorphiumConfig fromProperties(Properties p) {
        return new MorphiumConfig(p);
    }

    @Deprecated
    public boolean isReplicaset() {
        return this.clusterSettings.isReplicaset();
    }

    @Deprecated
    public CompressionType getCompressionType() {
        return this.driverSettings.getCompressionType();
    }

    @Deprecated
    public MorphiumConfig setCompressionType(CompressionType t) {
        this.driverSettings.setCompressionType(t);
        return this;
    }

    @Deprecated
    public MorphiumConfig setReplicasetMonitoring(boolean replicaset) {
        this.clusterSettings.setReplicaset(replicaset);
        return this;
    }

    @Deprecated
    public Class<? extends ValueEncryptionProvider> getValueEncryptionProviderClass() {
        return this.encryptionSettings.getValueEncryptionProviderClass();
    }

    @Deprecated
    public MorphiumConfig setValueEncryptionProviderClass(Class<? extends ValueEncryptionProvider> valueEncryptionProviderClass) {
        this.encryptionSettings.setValueEncryptionProviderClass(valueEncryptionProviderClass);
        return this;
    }

    @Deprecated
    public Class<? extends EncryptionKeyProvider> getEncryptionKeyProviderClass() {
        return this.encryptionSettings.getEncryptionKeyProviderClass();
    }

    @Deprecated
    public MorphiumConfig setEncryptionKeyProviderClass(Class<? extends EncryptionKeyProvider> encryptionKeyProviderClass) {
        this.encryptionSettings.setEncryptionKeyProviderClass(encryptionKeyProviderClass);
        return this;
    }

    @Deprecated
    public String getCredentialsEncryptionKey() {
        return this.encryptionSettings.getCredentialsEncryptionKey();
    }

    @Deprecated
    public MorphiumConfig setCredentialsEncryptionKey(String credentialsEncryptionKey) {
        this.encryptionSettings.setCredentialsEncryptionKey(credentialsEncryptionKey);
        return this;
    }

    @Deprecated
    public String getCredentialsDecryptionKey() {
        return this.encryptionSettings.getCredentialsDecryptionKey();
    }

    @Deprecated
    public MorphiumConfig setCredentialsDecryptionKey(String credentialsDecryptionKey) {
        this.encryptionSettings.setCredentialsDecryptionKey(credentialsDecryptionKey);
        return this;
    }

    @Deprecated
    public String getDriverName() {
        return this.driverSettings.getDriverName();
    }

    @Deprecated
    public MorphiumConfig setDriverName(String driverName) {
        this.driverSettings.setDriverName(driverName);
        return this;
    }

    public boolean isAutoIndexAndCappedCreationOnWrite() {
        return this.collectionCheckSettings.getIndexCheck().equals((Object)CollectionCheckSettings.IndexCheck.CREATE_ON_WRITE_NEW_COL);
    }

    public MorphiumConfig setAutoIndexAndCappedCreationOnWrite(boolean autoIndexAndCappedCreationOnWrite) {
        if (autoIndexAndCappedCreationOnWrite) {
            this.collectionCheckSettings.setIndexCheck(CollectionCheckSettings.IndexCheck.CREATE_ON_WRITE_NEW_COL);
        } else {
            this.collectionCheckSettings.setIndexCheck(CollectionCheckSettings.IndexCheck.NO_CHECK);
        }
        return this;
    }

    @Deprecated
    public boolean isWarnOnNoEntitySerialization() {
        return this.objectMappingSettings.isWarnOnNoEntitySerialization();
    }

    @Deprecated
    public MorphiumConfig setWarnOnNoEntitySerialization(boolean warnOnNoEntitySerialization) {
        this.objectMappingSettings.setWarnOnNoEntitySerialization(warnOnNoEntitySerialization);
        return this;
    }

    @Deprecated
    public boolean isCheckForNew() {
        return this.objectMappingSettings.isCheckForNew();
    }

    @Deprecated
    public MorphiumConfig setCheckForNew(boolean checkForNew) {
        this.objectMappingSettings.setCheckForNew(checkForNew);
        return this;
    }

    @Deprecated
    public int getRetriesOnNetworkError() {
        return this.connectionSettings.getRetriesOnNetworkError();
    }

    @Deprecated
    public MorphiumConfig setRetriesOnNetworkError(int retriesOnNetworkError) {
        this.connectionSettings.setRetriesOnNetworkError(retriesOnNetworkError);
        return this;
    }

    @Deprecated
    public int getSleepBetweenNetworkErrorRetries() {
        return this.connectionSettings.getSleepBetweenNetworkErrorRetries();
    }

    @Deprecated
    public MorphiumConfig setSleepBetweenNetworkErrorRetries(int sleepBetweenNetworkErrorRetries) {
        this.connectionSettings.setSleepBetweenNetworkErrorRetries(sleepBetweenNetworkErrorRetries);
        return this;
    }

    @Deprecated
    public int getWriteBufferTimeGranularity() {
        return this.writerSettings.getWriteBufferTimeGranularity();
    }

    @Deprecated
    public MorphiumConfig setWriteBufferTimeGranularity(int writeBufferTimeGranularity) {
        this.writerSettings.setWriteBufferTimeGranularity(writeBufferTimeGranularity);
        return this;
    }

    @Deprecated
    public MorphiumCache getCache() {
        return this.cacheSettings.getCache();
    }

    @Deprecated
    public MorphiumConfig setCache(MorphiumCache cache) {
        this.cacheSettings.setCache(cache);
        return this;
    }

    @Deprecated
    public int getWriteBufferTime() {
        return this.writerSettings.getWriteBufferTime();
    }

    @Deprecated
    public MorphiumConfig setWriteBufferTime(int writeBufferTime) {
        this.writerSettings.setWriteBufferTime(writeBufferTime);
        return this;
    }

    @Deprecated
    public MorphiumWriter getBufferedWriter() {
        return this.writerSettings.getBufferedWriter();
    }

    @Deprecated
    public MorphiumConfig setBufferedWriter(MorphiumWriter bufferedWriter) {
        this.writerSettings.setBufferedWriter(bufferedWriter);
        return this;
    }

    @Deprecated
    public MorphiumWriter getWriter() {
        return this.writerSettings.getWriter();
    }

    @Deprecated
    public MorphiumConfig setWriter(MorphiumWriter writer) {
        this.writerSettings.setWriter(writer);
        return this;
    }

    @Deprecated
    public int getConnectionTimeout() {
        return this.connectionSettings.getConnectionTimeout();
    }

    @Deprecated
    public MorphiumConfig setConnectionTimeout(int connectionTimeout) {
        this.connectionSettings.setConnectionTimeout(connectionTimeout);
        return this;
    }

    @Deprecated
    public int getMaxWaitTime() {
        return this.connectionSettings.getMaxWaitTime();
    }

    @Deprecated
    public MorphiumConfig setMaxWaitTime(int maxWaitTime) {
        this.connectionSettings.setMaxWaitTime(maxWaitTime);
        return this;
    }

    @Deprecated
    public int getServerSelectionTimeout() {
        return this.driverSettings.getServerSelectionTimeout();
    }

    @Deprecated
    public MorphiumConfig setServerSelectionTimeout(int serverSelectionTimeout) {
        this.driverSettings.setServerSelectionTimeout(serverSelectionTimeout);
        return this;
    }

    @Deprecated
    public Boolean getCredentialsEncrypted() {
        return this.encryptionSettings.getCredentialsEncrypted();
    }

    @Deprecated
    public MorphiumConfig setCredentialsEncrypted(Boolean credentialsEncrypted) {
        this.encryptionSettings.setCredentialsEncrypted(credentialsEncrypted);
        return this;
    }

    @Deprecated
    public String getMongoAuthDb() {
        return this.authSettings.getMongoAuthDb();
    }

    @Deprecated
    public MorphiumConfig setMongoAuthDb(String mongoAuthDb) {
        this.authSettings.setMongoAuthDb(mongoAuthDb);
        return this;
    }

    @Deprecated
    public String getMongoLogin() {
        return this.authSettings.getMongoLogin();
    }

    @Deprecated
    public MorphiumConfig setMongoLogin(String mongoLogin) {
        this.authSettings.setMongoLogin(mongoLogin);
        return this;
    }

    @Deprecated
    public String getMongoPassword() {
        return this.authSettings.getMongoPassword();
    }

    @Deprecated
    public MorphiumConfig setMongoPassword(String mongoPassword) {
        this.authSettings.setMongoPassword(mongoPassword);
        return this;
    }

    @Deprecated
    public ReadPreference getDefaultReadPreference() {
        return this.driverSettings.getDefaultReadPreference();
    }

    @Deprecated
    public MorphiumConfig setDefaultReadPreference(ReadPreference defaultReadPreference) {
        this.driverSettings.setDefaultReadPreference(defaultReadPreference);
        return this;
    }

    @Deprecated
    public String getDefaultReadPreferenceType() {
        return this.driverSettings.getDefaultReadPreferenceType();
    }

    @Deprecated
    public MorphiumConfig setDefaultReadPreferenceType(String stringDefaultReadPreference) {
        ReadPreferenceType readPreferenceType;
        this.driverSettings.setDefaultReadPreferenceType(stringDefaultReadPreference);
        try {
            readPreferenceType = ReadPreferenceType.valueOf(stringDefaultReadPreference.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            readPreferenceType = null;
        }
        if (readPreferenceType == null) {
            throw new RuntimeException("Could not set defaultReadPreferenceByString " + stringDefaultReadPreference);
        }
        ReadPreference defaultReadPreference = new ReadPreference();
        defaultReadPreference.setType(readPreferenceType);
        this.driverSettings.setDefaultReadPreference(defaultReadPreference);
        return this;
    }

    @Deprecated
    public int getWriteCacheTimeout() {
        return this.cacheSettings.getWriteCacheTimeout();
    }

    @Deprecated
    public MorphiumConfig setWriteCacheTimeout(int writeCacheTimeout) {
        this.cacheSettings.setWriteCacheTimeout(writeCacheTimeout);
        return this;
    }

    @Deprecated
    public MorphiumConfig setHostSeed(List<String> str) {
        this.clusterSettings.setHostSeed(str);
        return this;
    }

    @Deprecated
    public MorphiumConfig setHostSeed(List<String> str, List<Integer> ports) {
        this.clusterSettings.setHostSeed(str, ports);
        return this;
    }

    @Deprecated
    public List<String> getHostSeed() {
        return this.clusterSettings.getHostSeed();
    }

    @Deprecated
    public MorphiumConfig setHostSeed(String ... hostPorts) {
        this.clusterSettings.setHostSeed(hostPorts);
        return this;
    }

    @Deprecated
    public MorphiumConfig setHostSeed(String hostPorts) {
        this.clusterSettings.setHostSeed(hostPorts);
        return this;
    }

    @Deprecated
    public MorphiumConfig setHostSeed(String hosts, String ports) {
        this.clusterSettings.setHostSeed(hosts, ports);
        return this;
    }

    @Deprecated
    public MorphiumConfig addHostToSeed(String host, int port) {
        this.clusterSettings.addHostToSeed(host, port);
        return this;
    }

    @Deprecated
    public MorphiumConfig addHostToSeed(String host) {
        this.clusterSettings.addHostToSeed(host);
        return this;
    }

    @Deprecated
    public int getMaxConnections() {
        return this.connectionSettings.getMaxConnections();
    }

    @Deprecated
    public MorphiumConfig setMaxConnections(int maxConnections) {
        this.connectionSettings.setMaxConnections(maxConnections);
        return this;
    }

    @Deprecated
    public String getDatabase() {
        return this.connectionSettings.getDatabase();
    }

    @Deprecated
    public MorphiumConfig setDatabase(String database) {
        this.connectionSettings.setDatabase(database);
        return this;
    }

    @Deprecated
    public int getHousekeepingTimeout() {
        return this.cacheSettings.getHousekeepingTimeout();
    }

    @Deprecated
    public MorphiumConfig setHousekeepingTimeout(int housekeepingTimeout) {
        this.cacheSettings.setHousekeepingTimeout(housekeepingTimeout);
        return this;
    }

    @Deprecated
    public int getGlobalCacheValidTime() {
        return this.cacheSettings.getGlobalCacheValidTime();
    }

    @Deprecated
    public MorphiumConfig setGlobalCacheValidTime(int globalCacheValidTime) {
        this.cacheSettings.setGlobalCacheValidTime(globalCacheValidTime);
        return this;
    }

    public String toString() {
        try {
            ObjectMapperImpl om = new ObjectMapperImpl();
            om.getARHelper().enableConvertCamelCase();
            LinkedHashMap<String, Object> data = new LinkedHashMap<String, Object>();
            for (Settings s : this.settings) {
                data.putAll(om.serialize(s));
            }
            return Utils.toJsonString(data);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Deprecated
    public MorphiumConfig setThreadConnectionMultiplier(int mp) {
        this.writerSettings.setThreadConnectionMultiplier(mp);
        return this;
    }

    @Deprecated
    public int getThreadConnectionMultiplier() {
        return this.writerSettings.getThreadConnectionMultiplier();
    }

    @Deprecated
    public MorphiumWriter getAsyncWriter() {
        return this.writerSettings.getAsyncWriter();
    }

    @Deprecated
    public MorphiumConfig setAsyncWriter(MorphiumWriter asyncWriter) {
        this.writerSettings.setAsyncWriter(asyncWriter);
        return this;
    }

    @Deprecated
    public int getMaximumRetriesBufferedWriter() {
        return this.writerSettings.getMaximumRetriesAsyncWriter();
    }

    @Deprecated
    public MorphiumConfig setMaximumRetriesBufferedWriter(int maximumRetriesBufferedWriter) {
        this.writerSettings.setMaximumRetriesBufferedWriter(maximumRetriesBufferedWriter);
        return this;
    }

    @Deprecated
    public int getMaximumRetriesWriter() {
        return this.writerSettings.getMaximumRetriesWriter();
    }

    @Deprecated
    public MorphiumConfig setMaximumRetriesWriter(int maximumRetriesWriter) {
        this.writerSettings.setMaximumRetriesWriter(maximumRetriesWriter);
        return this;
    }

    @Deprecated
    public int getMaximumRetriesAsyncWriter() {
        return this.writerSettings.getMaximumRetriesAsyncWriter();
    }

    @Deprecated
    public MorphiumConfig setMaximumRetriesAsyncWriter(int maximumRetriesAsyncWriter) {
        this.writerSettings.setMaximumRetriesAsyncWriter(maximumRetriesAsyncWriter);
        return this;
    }

    @Deprecated
    public int getRetryWaitTimeBufferedWriter() {
        return this.writerSettings.getRetryWaitTimeBufferedWriter();
    }

    @Deprecated
    public MorphiumConfig setRetryWaitTimeBufferedWriter(int retryWaitTimeBufferedWriter) {
        this.writerSettings.setRetryWaitTimeBufferedWriter(retryWaitTimeBufferedWriter);
        return this;
    }

    @Deprecated
    public int getRetryWaitTimeWriter() {
        return this.writerSettings.getRetryWaitTimeWriter();
    }

    @Deprecated
    public MorphiumConfig setRetryWaitTimeWriter(int retryWaitTimeWriter) {
        this.writerSettings.setRetryWaitTimeWriter(retryWaitTimeWriter);
        return this;
    }

    @Deprecated
    public int getRetryWaitTimeAsyncWriter() {
        return this.writerSettings.getRetryWaitTimeAsyncWriter();
    }

    @Deprecated
    public MorphiumConfig setRetryWaitTimeAsyncWriter(int retryWaitTimeAsyncWriter) {
        this.writerSettings.setRetryWaitTimeAsyncWriter(retryWaitTimeAsyncWriter);
        return this;
    }

    public Properties asProperties() {
        return this.asProperties(null);
    }

    public MorphiumConfig createCopy() {
        MorphiumConfig c = new MorphiumConfig();
        c.messagingSettings = (MessagingSettings)this.messagingSettings.copy();
        c.collectionCheckSettings = (CollectionCheckSettings)this.collectionCheckSettings.copy();
        c.connectionSettings = (ConnectionSettings)this.connectionSettings.copy();
        c.driverSettings = (DriverSettings)this.driverSettings.copy();
        c.encryptionSettings = (EncryptionSettings)this.encryptionSettings.copy();
        c.objectMappingSettings = (ObjectMappingSettings)this.objectMappingSettings.copy();
        c.threadPoolSettings = (ThreadPoolSettings)this.threadPoolSettings.copy();
        c.writerSettings = (WriterSettings)this.writerSettings.copy();
        c.cacheSettings = (CacheSettings)this.cacheSettings.copy();
        c.authSettings = (AuthSettings)this.authSettings.copy();
        c.clusterSettings = (ClusterSettings)this.clusterSettings.copy();
        if (this.restoreData != null) {
            c.restoreData = new LinkedHashMap<String, Object>(this.restoreData);
        }
        c.rebuildSettingsList();
        return c;
    }

    @Deprecated
    public Properties asProperties(String prefix, boolean effectiveConfig) {
        return this.asProperties(prefix);
    }

    public Properties asProperties(String prefix, Settings setting) {
        Properties p = new Properties();
        p.putAll((Map<?, ?>)setting.asProperties(prefix));
        return p;
    }

    protected <T extends Settings> T getSettingByType(Class cls) {
        for (Settings s : this.settings) {
            if (!s.getClass().equals(cls)) continue;
            return (T)s;
        }
        return null;
    }

    public <T extends Settings> T createCopyOf(T setting) {
        return setting.copy();
    }

    public Properties asProperties(String prefix) {
        Properties p = new Properties();
        for (Settings setting : this.settings) {
            p.putAll((Map<?, ?>)setting.asProperties(prefix));
        }
        return p;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (this.getClass() != other.getClass()) {
            return false;
        }
        MorphiumConfig that = (MorphiumConfig)other;
        for (Settings s : this.settings) {
            if (Objects.equals(s, that.getSettingByType(s.getClass()))) continue;
            return false;
        }
        return Objects.equals(this.restoreData, that.restoreData);
    }

    public int hashCode() {
        int rd = 0;
        if (this.restoreData != null) {
            rd = this.restoreData.hashCode();
        }
        return Objects.hash(this.settings.toArray()) + rd;
    }

    @Deprecated
    public boolean isReadCacheEnabled() {
        return this.cacheSettings.isReadCacheEnabled();
    }

    @Deprecated
    public MorphiumConfig setReadCacheEnabled(boolean readCacheEnabled) {
        this.cacheSettings.setReadCacheEnabled(readCacheEnabled);
        return this;
    }

    @Deprecated
    public MorphiumConfig disableReadCache() {
        this.cacheSettings.setReadCacheEnabled(false);
        return this;
    }

    @Deprecated
    public MorphiumConfig enableReadCache() {
        this.cacheSettings.setReadCacheEnabled(true);
        return this;
    }

    @Deprecated
    public boolean isAsyncWritesEnabled() {
        return this.cacheSettings.isAsyncWritesEnabled();
    }

    @Deprecated
    public MorphiumConfig setAsyncWritesEnabled(boolean asyncWritesEnabled) {
        this.cacheSettings.setAsyncWritesEnabled(asyncWritesEnabled);
        return this;
    }

    @Deprecated
    public MorphiumConfig disableAsyncWrites() {
        this.cacheSettings.setAsyncWritesEnabled(false);
        return this;
    }

    @Deprecated
    public MorphiumConfig enableAsyncWrites() {
        this.cacheSettings.setAsyncWritesEnabled(true);
        return this;
    }

    @Deprecated
    public boolean isBufferedWritesEnabled() {
        return this.cacheSettings.isBufferedWritesEnabled();
    }

    @Deprecated
    public MorphiumConfig setBufferedWritesEnabled(boolean bufferedWritesEnabled) {
        this.cacheSettings.setBufferedWritesEnabled(bufferedWritesEnabled);
        return this;
    }

    @Deprecated
    public MorphiumConfig disableBufferedWrites() {
        this.cacheSettings.setBufferedWritesEnabled(false);
        return this;
    }

    @Deprecated
    public MorphiumConfig enableBufferedWrites() {
        this.cacheSettings.setBufferedWritesEnabled(true);
        return this;
    }

    @Deprecated
    public boolean isAutoValuesEnabled() {
        return this.objectMappingSettings.isAutoValues();
    }

    @Deprecated
    public MorphiumConfig setAutoValuesEnabled(boolean enabled) {
        this.objectMappingSettings.setAutoValues(enabled);
        return this;
    }

    @Deprecated
    public MorphiumConfig enableAutoValues() {
        this.objectMappingSettings.setAutoValues(true);
        return this;
    }

    @Deprecated
    public MorphiumConfig disableAutoValues() {
        this.objectMappingSettings.setAutoValues(false);
        return this;
    }

    @Deprecated
    public boolean isCamelCaseConversionEnabled() {
        return this.objectMappingSettings.isCamelCaseConversionEnabled();
    }

    @Deprecated
    public MorphiumConfig setCamelCaseConversionEnabled(boolean camelCaseConversionEnabled) {
        this.objectMappingSettings.setCamelCaseConversionEnabled(camelCaseConversionEnabled);
        return this;
    }

    @Deprecated
    public int getThreadPoolMessagingCoreSize() {
        return this.messagingSettings.getThreadPoolMessagingCoreSize();
    }

    @Deprecated
    public MorphiumConfig setThreadPoolMessagingCoreSize(int threadPoolMessagingCoreSize) {
        this.messagingSettings.setThreadPoolMessagingCoreSize(threadPoolMessagingCoreSize);
        return this;
    }

    @Deprecated
    public int getThreadPoolMessagingMaxSize() {
        return this.messagingSettings.getThreadPoolMessagingMaxSize();
    }

    @Deprecated
    public MorphiumConfig setThreadPoolMessagingMaxSize(int threadPoolMessagingMaxSize) {
        this.messagingSettings.setThreadPoolMessagingMaxSize(threadPoolMessagingMaxSize);
        return this;
    }

    @Deprecated
    public long getThreadPoolMessagingKeepAliveTime() {
        return this.messagingSettings.getThreadPoolMessagingKeepAliveTime();
    }

    @Deprecated
    public MorphiumConfig setThreadPoolMessagingKeepAliveTime(long threadPoolMessagingKeepAliveTime) {
        this.messagingSettings.setThreadPoolMessagingKeepAliveTime(threadPoolMessagingKeepAliveTime);
        return this;
    }

    @Deprecated
    public int getThreadPoolAsyncOpCoreSize() {
        return this.threadPoolSettings.getThreadPoolAsyncOpCoreSize();
    }

    @Deprecated
    public MorphiumConfig setThreadPoolAsyncOpCoreSize(int threadPoolAsyncOpCoreSize) {
        this.threadPoolSettings.setThreadPoolAsyncOpCoreSize(threadPoolAsyncOpCoreSize);
        return this;
    }

    @Deprecated
    public int getThreadPoolAsyncOpMaxSize() {
        return this.threadPoolSettings.getThreadPoolAsyncOpMaxSize();
    }

    @Deprecated
    public MorphiumConfig setThreadPoolAsyncOpMaxSize(int threadPoolAsyncOpMaxSize) {
        this.threadPoolSettings.setThreadPoolAsyncOpMaxSize(threadPoolAsyncOpMaxSize);
        return this;
    }

    @Deprecated
    public long getThreadPoolAsyncOpKeepAliveTime() {
        return this.threadPoolSettings.getThreadPoolAsyncOpKeepAliveTime();
    }

    @Deprecated
    public MorphiumConfig setThreadPoolAsyncOpKeepAliveTime(long threadPoolAsyncOpKeepAliveTime) {
        this.threadPoolSettings.setThreadPoolAsyncOpKeepAliveTime(threadPoolAsyncOpKeepAliveTime);
        return this;
    }

    @Deprecated
    public boolean isObjectSerializationEnabled() {
        return this.objectMappingSettings.isObjectSerializationEnabled();
    }

    @Deprecated
    public MorphiumConfig setObjectSerializationEnabled(boolean objectSerializationEnabled) {
        this.objectMappingSettings.setObjectSerializationEnabled(objectSerializationEnabled);
        return this;
    }

    @Deprecated
    public int getHeartbeatFrequency() {
        return this.driverSettings.getHeartbeatFrequency();
    }

    @Deprecated
    public MorphiumConfig setHeartbeatFrequency(int heartbeatFrequency) {
        this.driverSettings.setHeartbeatFrequency(heartbeatFrequency);
        return this;
    }

    @Deprecated
    public MorphiumConfig setMinConnections(int minConnections) {
        this.connectionSettings.setMinConnections(minConnections);
        return this;
    }

    @Deprecated
    public int getLocalThreshold() {
        return this.driverSettings.getLocalThreshold();
    }

    @Deprecated
    public MorphiumConfig setLocalThreshold(int localThreshold) {
        this.driverSettings.setLocalThreshold(localThreshold);
        return this;
    }

    @Deprecated
    public int getMaxConnectionIdleTime() {
        return this.driverSettings.getMaxConnectionIdleTime();
    }

    @Deprecated
    public MorphiumConfig setMaxConnectionIdleTime(int maxConnectionIdleTime) {
        this.driverSettings.setMaxConnectionIdleTime(maxConnectionIdleTime);
        return this;
    }

    @Deprecated
    public int getMaxConnectionLifeTime() {
        return this.driverSettings.getMaxConnectionLifeTime();
    }

    @Deprecated
    public MorphiumConfig setMaxConnectionLifeTime(int maxConnectionLifeTime) {
        this.driverSettings.setMaxConnectionLifeTime(maxConnectionLifeTime);
        return this;
    }

    @Deprecated
    public String getRequiredReplicaSetName() {
        return this.clusterSettings.getRequiredReplicaSetName();
    }

    @Deprecated
    public MorphiumConfig setRequiredReplicaSetName(String requiredReplicaSetName) {
        this.clusterSettings.setRequiredReplicaSetName(requiredReplicaSetName);
        return this;
    }

    public int getCursorBatchSize() {
        return this.driverSettings.getCursorBatchSize();
    }

    public MorphiumConfig setCursorBatchSize(int cursorBatchSize) {
        this.driverSettings.setCursorBatchSize(cursorBatchSize);
        return this;
    }

    @Deprecated
    public int getReadTimeout() {
        return this.driverSettings.getReadTimeout();
    }

    @Deprecated
    public MorphiumConfig setReadTimeout(int readTimeout) {
        this.driverSettings.setReadTimeout(readTimeout);
        return this;
    }

    @Deprecated
    public boolean isRetryReads() {
        return this.driverSettings.isRetryReads();
    }

    @Deprecated
    public void setRetryReads(boolean retryReads) {
        this.driverSettings.setRetryReads(retryReads);
    }

    @Deprecated
    public boolean isRetryWrites() {
        return this.driverSettings.isRetryWrites();
    }

    @Deprecated
    public void setRetryWrites(boolean retryWrites) {
        this.driverSettings.setRetryWrites(retryWrites);
    }

    @Deprecated
    public String getUuidRepresentation() {
        return this.driverSettings.getUuidRepresentation();
    }

    public void setUuidRepresentation(String uuidRepresentation) {
        this.driverSettings.setUuidRepresentation(uuidRepresentation);
    }

    @Deprecated
    public CollectionCheckSettings.IndexCheck getIndexCheck() {
        return this.collectionCheckSettings.getIndexCheck();
    }

    @Deprecated
    public void setIndexCheck(CollectionCheckSettings.IndexCheck indexCheck) {
        this.collectionCheckSettings.setIndexCheck(indexCheck);
    }

    @Deprecated
    public CollectionCheckSettings.CappedCheck getCappedCheck() {
        return this.collectionCheckSettings.getCappedCheck();
    }

    @Deprecated
    public MorphiumConfig setCappedCheck(CollectionCheckSettings.CappedCheck cappedCheck) {
        this.collectionCheckSettings.setCappedCheck(cappedCheck);
        return this;
    }

    @Deprecated
    public int getIdleSleepTime() {
        return this.driverSettings.getIdleSleepTime();
    }

    @Deprecated
    public void setIdleSleepTime(int idleSleepTime) {
        this.driverSettings.setIdleSleepTime(idleSleepTime);
    }

    public Map<String, Object> getRestoreData() {
        return this.restoreData;
    }

    public void setRestoreData(Map<String, Object> restoreData) {
        this.restoreData = restoreData;
    }

    @Deprecated
    public int getMinConnections() {
        return this.connectionSettings.getMinConnections();
    }

    public static enum CompressionType {
        NONE(0),
        ZLIB(2),
        SNAPPY(1);

        private int code;

        private CompressionType(int c) {
            this.code = c;
        }

        public int getCode() {
            return this.code;
        }
    }
}

