/*
 * Decompiled with CFR 0.152.
 */
package de.caluga.morphium;

import de.caluga.morphium.AnnotationAndReflectionHelper;
import de.caluga.morphium.Collation;
import de.caluga.morphium.Morphium;
import de.caluga.morphium.MorphiumConfig;
import de.caluga.morphium.MorphiumStorageListener;
import de.caluga.morphium.UtilsMap;
import de.caluga.morphium.aggregation.Expr;
import de.caluga.morphium.async.AsyncOperationCallback;
import de.caluga.morphium.driver.MorphiumDriver;
import de.caluga.morphium.driver.MorphiumDriverException;
import de.caluga.morphium.driver.commands.ExplainCommand;
import de.caluga.morphium.driver.commands.ListDatabasesCommand;
import de.caluga.morphium.driver.wire.MongoConnection;
import de.caluga.morphium.objectmapping.MorphiumObjectMapper;
import de.caluga.morphium.query.Query;
import de.caluga.morphium.writer.MorphiumWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class MorphiumBase {
    private Logger log = LoggerFactory.getLogger(Morphium.class);

    public <T> void unsetInEntity(T toSet, Enum<?> field) {
        this.unsetInEntity(toSet, field.name(), (AsyncOperationCallback)null);
    }

    public <T> void unsetInEntity(T toSet, String field) {
        this.unsetInEntity(toSet, field, (AsyncOperationCallback)null);
    }

    public <T> void unsetInEntity(T toSet, Enum<?> field, AsyncOperationCallback<T> callback) {
        this.unsetInEntity(toSet, field.name(), callback);
    }

    public <T> void unsetInEntity(T toSet, String collection, Enum<?> field) {
        this.unsetInEntity(toSet, collection, field.name(), null);
    }

    public <T> void unsetInEntity(T toSet, String collection, Enum<?> field, AsyncOperationCallback<T> callback) {
        this.unsetInEntity(toSet, collection, field.name(), callback);
    }

    public <T> void unsetInEntity(T toSet, String field, AsyncOperationCallback<T> callback) {
        this.unsetInEntity(toSet, this.getMapper().getCollectionName(toSet.getClass()), field, callback);
    }

    public <T> Map<String, Object> dec(Query<T> query, Map<String, Number> toUpdate, boolean upsert, boolean multiple, AsyncOperationCallback<T> callback) {
        if (query == null) {
            throw new RuntimeException("Cannot update null!");
        }
        return this.getWriterForClass(query.getType()).inc(query, toUpdate, upsert, multiple, callback);
    }

    public Map<String, Object> inc(Query<?> query, String name, long amount, boolean upsert, boolean multiple) {
        return this.inc((Query)query, name, amount, upsert, multiple, (AsyncOperationCallback)null);
    }

    public Map<String, Object> inc(Query<?> query, String name, int amount, boolean upsert, boolean multiple) {
        return this.inc((Query)query, name, amount, upsert, multiple, (AsyncOperationCallback)null);
    }

    public Map<String, Object> inc(Query<?> query, String name, double amount, boolean upsert, boolean multiple) {
        return this.inc((Query)query, name, amount, upsert, multiple, (AsyncOperationCallback)null);
    }

    public Map<String, Object> inc(Query<?> query, String name, Number amount, boolean upsert, boolean multiple) {
        return this.inc(query, name, amount, upsert, multiple, null);
    }

    public <T> Map<String, Object> inc(Query<T> query, Enum<?> field, long amount, boolean upsert, boolean multiple, AsyncOperationCallback<T> callback) {
        return this.inc(query, field.name(), amount, upsert, multiple, callback);
    }

    public <T> Map<String, Object> inc(Query<T> query, String name, long amount, boolean upsert, boolean multiple, AsyncOperationCallback<T> callback) {
        if (query == null) {
            throw new RuntimeException("Cannot update null!");
        }
        return this.getWriterForClass(query.getType()).inc(query, name, amount, upsert, multiple, callback);
    }

    public <T> Map<String, Object> inc(Query<T> query, Enum<?> field, int amount, boolean upsert, boolean multiple, AsyncOperationCallback<T> callback) {
        return this.inc(query, field.name(), amount, upsert, multiple, callback);
    }

    public <T> Map<String, Object> inc(Query<T> query, String name, int amount, boolean upsert, boolean multiple, AsyncOperationCallback<T> callback) {
        if (query == null) {
            throw new RuntimeException("Cannot update null!");
        }
        return this.getWriterForClass(query.getType()).inc(query, name, amount, upsert, multiple, callback);
    }

    public <T> Map<String, Object> inc(Query<T> query, Enum<?> field, double amount, boolean upsert, boolean multiple, AsyncOperationCallback<T> callback) {
        return this.inc(query, field.name(), amount, upsert, multiple, callback);
    }

    public <T> Map<String, Object> inc(Query<T> query, String name, double amount, boolean upsert, boolean multiple, AsyncOperationCallback<T> callback) {
        if (query == null) {
            throw new RuntimeException("Cannot update null!");
        }
        return this.getWriterForClass(query.getType()).inc(query, name, amount, upsert, multiple, callback);
    }

    public <T> Map<String, Object> inc(Query<T> query, Enum<?> field, Number amount, boolean upsert, boolean multiple, AsyncOperationCallback<T> callback) {
        return this.inc(query, field.name(), amount, upsert, multiple, callback);
    }

    public <T> Map<String, Object> inc(Query<T> query, String name, Number amount, boolean upsert, boolean multiple, AsyncOperationCallback<T> callback) {
        if (query == null) {
            throw new RuntimeException("Cannot update null!");
        }
        return this.getWriterForClass(query.getType()).inc(query, name, amount, upsert, multiple, callback);
    }

    public <T> Map<String, Object> dec(Query<T> query, Enum<?> field, long amount, boolean upsert, boolean multiple, AsyncOperationCallback<T> callback) {
        return this.dec(query, field.name(), amount, upsert, multiple, callback);
    }

    public <T> Map<String, Object> dec(Query<T> query, String name, long amount, boolean upsert, boolean multiple, AsyncOperationCallback<T> callback) {
        if (query == null) {
            throw new RuntimeException("Cannot update null!");
        }
        return this.getWriterForClass(query.getType()).inc(query, name, -amount, upsert, multiple, callback);
    }

    public <T> Map<String, Object> dec(Query<T> query, Enum<?> field, int amount, boolean upsert, boolean multiple, AsyncOperationCallback<T> callback) {
        return this.dec(query, field.name(), amount, upsert, multiple, callback);
    }

    public <T> Map<String, Object> dec(Query<T> query, String name, int amount, boolean upsert, boolean multiple, AsyncOperationCallback<T> callback) {
        if (query == null) {
            throw new RuntimeException("Cannot update null!");
        }
        return this.getWriterForClass(query.getType()).inc(query, name, -amount, upsert, multiple, callback);
    }

    public <T> Map<String, Object> dec(Query<T> query, Enum<?> field, double amount, boolean upsert, boolean multiple, AsyncOperationCallback<T> callback) {
        return this.dec(query, field.name(), amount, upsert, multiple, callback);
    }

    public <T> Map<String, Object> dec(Query<T> query, String name, double amount, boolean upsert, boolean multiple, AsyncOperationCallback<T> callback) {
        if (query == null) {
            throw new RuntimeException("Cannot update null!");
        }
        return this.getWriterForClass(query.getType()).inc(query, name, -amount, upsert, multiple, callback);
    }

    public <T> Map<String, Object> dec(Query<T> query, Enum<?> field, Number amount, boolean upsert, boolean multiple, AsyncOperationCallback<T> callback) {
        return this.dec(query, field.name(), amount, upsert, multiple, callback);
    }

    public <T> Map<String, Object> dec(Query<T> query, String name, Number amount, boolean upsert, boolean multiple, AsyncOperationCallback<T> callback) {
        if (query == null) {
            throw new RuntimeException("Cannot update null!");
        }
        return this.getWriterForClass(query.getType()).inc(query, name, -amount.doubleValue(), upsert, multiple, callback);
    }

    public void updateUsingFields(Object ent, String ... fields) {
        this.updateUsingFields((Object)ent, (AsyncOperationCallback)null, fields);
    }

    public void updateUsingFields(Object ent, Enum ... fieldNames) {
        this.updateUsingFields((Object)ent, (AsyncOperationCallback)null, fieldNames);
    }

    public <T> void updateUsingFields(T ent, AsyncOperationCallback<T> callback, Enum ... fields) {
        this.updateUsingFields(ent, this.getMapper().getCollectionName(ent.getClass()), callback, fields);
    }

    public <T> void updateUsingFields(T ent, AsyncOperationCallback<T> callback, String ... fields) {
        this.updateUsingFields(ent, this.getMapper().getCollectionName(ent.getClass()), callback, fields);
    }

    public <T> void updateUsingFields(T ent, String collection, AsyncOperationCallback<T> callback, Enum ... fields) {
        ArrayList<String> g = new ArrayList<String>();
        for (Enum e : fields) {
            g.add(e.name());
        }
        this.updateUsingFields(ent, collection, callback, g.toArray(new String[0]));
    }

    public <T> void updateUsingFields(T ent, String collection, AsyncOperationCallback<T> callback, String ... fields) {
        if (ent == null) {
            return;
        }
        if (fields.length == 0) {
            return;
        }
        for (int idx = 0; idx < fields.length; ++idx) {
            fields[idx] = this.getARHelper().getMongoFieldName(ent.getClass(), fields[idx]);
        }
        this.getWriterForClass(ent.getClass()).updateUsingFields(ent, collection, null, fields);
    }

    public <T> void dec(Map<Enum, Number> fieldsToInc, Query<T> matching, boolean upsert, boolean multiple, AsyncOperationCallback<T> callback) {
        HashMap<String, Number> toUpdate = new HashMap<String, Number>();
        for (Map.Entry<Enum, Number> e : fieldsToInc.entrySet()) {
            toUpdate.put(e.getKey().name(), e.getValue());
        }
        this.dec(matching, toUpdate, upsert, multiple, callback);
    }

    public void dec(Object toDec, Enum<?> field, double amount) {
        this.dec(toDec, field.name(), amount);
    }

    public void dec(Object toDec, String field, double amount) {
        this.inc(toDec, field, -amount);
    }

    public void dec(Object toDec, Enum<?> field, int amount) {
        this.dec(toDec, field.name(), amount);
    }

    public void dec(Object toDec, String field, int amount) {
        this.inc(toDec, field, -amount);
    }

    public void dec(Object toDec, Enum<?> field, long amount) {
        this.dec(toDec, field.name(), amount);
    }

    public void dec(Object toDec, String field, long amount) {
        this.inc(toDec, field, -amount);
    }

    public void dec(Object toDec, Enum<?> field, Number amount) {
        this.dec(toDec, field.name(), amount);
    }

    public void dec(Object toDec, String field, Number amount) {
        this.inc(toDec, field, -amount.doubleValue());
    }

    public void inc(Object toSet, Enum<?> field, long i) {
        this.inc((Object)toSet, field.name(), i, (AsyncOperationCallback)null);
    }

    public void inc(Object toSet, String field, long i) {
        this.inc((Object)toSet, field, i, (AsyncOperationCallback)null);
    }

    public void inc(Object toSet, Enum<?> field, int i) {
        this.inc((Object)toSet, field.name(), i, (AsyncOperationCallback)null);
    }

    public void inc(Object toSet, String field, int i) {
        this.inc((Object)toSet, field, i, (AsyncOperationCallback)null);
    }

    public void inc(Object toSet, Enum<?> field, double i) {
        this.inc((Object)toSet, field.name(), i, (AsyncOperationCallback)null);
    }

    public void inc(Object toSet, String field, double i) {
        this.inc((Object)toSet, field, i, (AsyncOperationCallback)null);
    }

    public void inc(Object toSet, Enum<?> field, Number i) {
        this.inc(toSet, field.name(), i, null);
    }

    public void inc(Object toSet, String field, Number i) {
        this.inc(toSet, field, i, null);
    }

    public <T> void inc(T toSet, Enum<?> field, double i, AsyncOperationCallback<T> callback) {
        this.inc(toSet, field.name(), i, callback);
    }

    public <T> void inc(T toSet, String field, double i, AsyncOperationCallback<T> callback) {
        this.inc(toSet, this.getMapper().getCollectionName(toSet.getClass()), field, i, callback);
    }

    public <T> void inc(T toSet, Enum<?> field, int i, AsyncOperationCallback<T> callback) {
        this.inc(toSet, field.name(), i, callback);
    }

    public <T> void inc(T toSet, String field, int i, AsyncOperationCallback<T> callback) {
        this.inc(toSet, this.getMapper().getCollectionName(toSet.getClass()), field, i, callback);
    }

    public <T> void inc(T toSet, Enum<?> field, long i, AsyncOperationCallback<T> callback) {
        this.inc(toSet, field.name(), i, callback);
    }

    public <T> void inc(T toSet, String field, long i, AsyncOperationCallback<T> callback) {
        this.inc(toSet, this.getMapper().getCollectionName(toSet.getClass()), field, i, callback);
    }

    public <T> void inc(T toSet, Enum<?> field, Number i, AsyncOperationCallback<T> callback) {
        this.inc(toSet, field.name(), i, callback);
    }

    public <T> void inc(T toSet, String field, Number i, AsyncOperationCallback<T> callback) {
        this.inc(toSet, this.getMapper().getCollectionName(toSet.getClass()), field, i, callback);
    }

    public <T> void inc(T toSet, Enum<?> collection, Enum<?> field, double i, AsyncOperationCallback<T> callback) {
        this.inc(toSet, field.name(), i, callback);
    }

    public <T> void inc(T toSet, String collection, Enum<?> field, double i, AsyncOperationCallback<T> callback) {
        this.inc(toSet, collection, field.name(), i, callback);
    }

    public <T> void inc(T toSet, String collection, String field, double i, AsyncOperationCallback<T> callback) {
        if (toSet == null) {
            throw new RuntimeException("Cannot update null!");
        }
        if (this.getId(toSet) == null) {
            this.log.debug("just storing object as it is new...");
            this.store(toSet);
            return;
        }
        this.getWriterForClass(toSet.getClass()).inc(toSet, collection, field, i, callback);
    }

    public <T> void inc(T toSet, String collection, Enum<?> field, int i, AsyncOperationCallback<T> callback) {
        this.inc(toSet, collection, field.name(), i, callback);
    }

    public <T> void inc(T toSet, String collection, String field, int i, AsyncOperationCallback<T> callback) {
        if (toSet == null) {
            throw new RuntimeException("Cannot update null!");
        }
        if (this.getId(toSet) == null) {
            this.log.debug("just storing object as it is new...");
            this.store(toSet);
            return;
        }
        this.getWriterForClass(toSet.getClass()).inc(toSet, collection, field, i, callback);
    }

    public <T> void inc(T toSet, String collection, Enum<?> field, long i, AsyncOperationCallback<T> callback) {
        this.inc(toSet, collection, field.name(), i, callback);
    }

    public <T> void inc(T toSet, String collection, String field, long i, AsyncOperationCallback<T> callback) {
        if (toSet == null) {
            throw new RuntimeException("Cannot update null!");
        }
        if (this.getId(toSet) == null) {
            this.log.debug("just storing object as it is new...");
            this.store(toSet);
            return;
        }
        this.getWriterForClass(toSet.getClass()).inc(toSet, collection, field, i, callback);
    }

    public <T> void inc(T toSet, String collection, Enum<?> field, Number i, AsyncOperationCallback<T> callback) {
        this.inc(toSet, collection, field.name(), i, callback);
    }

    public <T> void inc(T toSet, String collection, String field, Number i, AsyncOperationCallback<T> callback) {
        if (toSet == null) {
            throw new RuntimeException("Cannot update null!");
        }
        if (this.getId(toSet) == null) {
            this.log.debug("just storing object as it is new...");
            this.store(toSet);
            return;
        }
        this.getWriterForClass(toSet.getClass()).inc(toSet, collection, field, i, callback);
    }

    public <T> void remove(List<T> lst, String forceCollectionName) {
        this.remove((T)lst, forceCollectionName, (AsyncOperationCallback<T>)null);
    }

    public <T> Map<String, Object> delete(Query<T> o) {
        return this.remove(o);
    }

    public <T> Map<String, Object> explainRemove(Query<T> q) {
        return this.getConfig().writerSettings().getWriter().explainRemove(null, q);
    }

    public <T> Map<String, Object> remove(Query<T> o) {
        return this.getWriterForClass(o.getType()).remove(o, null);
    }

    public <T> Map<String, Object> delete(Query<T> o, AsyncOperationCallback<T> callback) {
        return this.remove(o, callback);
    }

    public <T> Map<String, Object> remove(Query<T> o, AsyncOperationCallback<T> callback) {
        return this.getWriterForClass(o.getType()).remove(o, callback);
    }

    public <T> Map<String, Object> pushPull(boolean push, Query<T> query, String field, Object value, boolean upsert, boolean multiple, AsyncOperationCallback<T> callback) {
        return this.getWriterForClass(query.getType()).pushPull(push ? MorphiumStorageListener.UpdateTypes.PUSH : MorphiumStorageListener.UpdateTypes.PULL, query, field, value, upsert, multiple, callback);
    }

    public <T> Map<String, Object> pushPullAll(boolean push, Query<T> query, String field, List<?> value, boolean upsert, boolean multiple, AsyncOperationCallback<T> callback) {
        return this.getWriterForClass(query.getType()).pushPullAll(push ? MorphiumStorageListener.UpdateTypes.PUSH : MorphiumStorageListener.UpdateTypes.PULL, query, field, value, upsert, multiple, callback);
    }

    public <T> Map<String, Object> pullAll(Query<T> query, String field, List<?> value, boolean upsert, boolean multiple, AsyncOperationCallback<T> callback) {
        return this.getWriterForClass(query.getType()).pushPullAll(MorphiumStorageListener.UpdateTypes.PULL, query, field, value, upsert, multiple, callback);
    }

    public void remove(Object o) {
        this.remove(o, this.getMapper().getCollectionName(o.getClass()));
    }

    public void delete(Object o) {
        this.remove(o, this.getMapper().getCollectionName(o.getClass()));
    }

    public void remove(Object o, String collection) {
        this.getWriterForClass(o.getClass()).remove(o, collection, null);
    }

    public void delete(Object o, String collection) {
        this.remove(o, collection);
    }

    public <T> void delete(T lo, AsyncOperationCallback<T> callback) {
        this.remove(lo, callback);
    }

    public <T> void remove(List<T> lst, String forceCollectionName, AsyncOperationCallback<T> callback) {
        ArrayList<T> directDel = new ArrayList<T>();
        ArrayList<T> bufferedDel = new ArrayList<T>();
        for (Object o : lst) {
            if (this.getARHelper().isBufferedWrite(o.getClass()) && !"InMemDriver".equals(this.getDriver().getName())) {
                bufferedDel.add(o);
                continue;
            }
            directDel.add(o);
        }
        for (Object o : bufferedDel) {
            this.getConfig().writerSettings().getBufferedWriter().remove(o, forceCollectionName, callback);
        }
        for (Object o : directDel) {
            this.getConfig().writerSettings().getWriter().remove(o, forceCollectionName, callback);
        }
    }

    public <T> void delete(List<T> lst, AsyncOperationCallback<T> callback) {
        this.remove((T)lst, callback);
    }

    public <T> void remove(List<T> lst, AsyncOperationCallback<T> callback) {
        ArrayList<T> directDel = new ArrayList<T>();
        ArrayList<T> bufferedDel = new ArrayList<T>();
        for (T o : lst) {
            if (this.getARHelper().isBufferedWrite(o.getClass()) && !"InMemDriver".equals(this.getDriver().getName())) {
                bufferedDel.add(o);
                continue;
            }
            directDel.add(o);
        }
        this.getConfig().writerSettings().getBufferedWriter().remove(bufferedDel, callback);
        this.getConfig().writerSettings().getWriter().remove(directDel, callback);
    }

    public <T> void remove(T lo, AsyncOperationCallback<T> callback) {
        if (lo instanceof Query) {
            this.remove((Query)lo, callback);
            return;
        }
        this.getWriterForClass(lo.getClass()).remove(lo, this.getMapper().getCollectionName(lo.getClass()), callback);
    }

    public <T> void delete(T lo, String collection, AsyncOperationCallback<T> callback) {
        this.remove(lo, collection, callback);
    }

    public <T> void remove(T lo, String collection, AsyncOperationCallback<T> callback) {
        this.getWriterForClass(lo.getClass()).remove(lo, collection, callback);
    }

    public boolean exists(String db) throws MorphiumDriverException {
        MongoConnection primaryConnection = this.getDriver().getPrimaryConnection(null);
        ListDatabasesCommand cmd = new ListDatabasesCommand(primaryConnection);
        List<Map<String, Object>> dbs = cmd.getList();
        cmd.releaseConnection();
        for (Map<String, Object> l : dbs) {
            if (!l.get("name").equals(db)) continue;
            return true;
        }
        return false;
    }

    public boolean exists(String db, String col) throws MorphiumDriverException {
        return this.getDriver().listCollections(db, col).size() != 0;
    }

    public boolean exists(Class<?> cls) throws MorphiumDriverException {
        return this.exists(this.getDatabase(), this.getMapper().getCollectionName(cls));
    }

    public <T> void storeList(List<T> lst) {
        this.saveList(lst);
    }

    public <T> void saveList(List<T> lst) {
        this.saveList(lst, (AsyncOperationCallback)null);
    }

    public <T> void storeList(Set<T> set) {
        this.saveList(set);
    }

    public <T> void saveList(Set<T> set) {
        this.saveList(new ArrayList<T>(set), (AsyncOperationCallback)null);
    }

    public <T> void storeList(List<T> lst, AsyncOperationCallback<T> callback) {
        this.saveList(lst, callback);
    }

    public <T> void storeList(List<T> lst, String collection) {
        this.saveList(lst, collection, null);
    }

    public <T> void saveList(List<T> lst, String collection) {
        this.saveList(lst, collection, null);
    }

    public <T> void storeList(List<T> lst, String collection, AsyncOperationCallback<T> callback) {
        this.saveList(lst, collection, callback);
    }

    public <T> void store(T o) {
        this.save(o);
    }

    public <T> void save(T o) {
        if (o instanceof List) {
            this.saveList((List)o);
        } else if (o instanceof Collection) {
            this.saveList(new ArrayList((Collection)o));
        } else {
            this.save(o, this.getMapper().getCollectionName(o.getClass()), null);
        }
    }

    public <T> void store(T o, AsyncOperationCallback<T> callback) {
        this.save(o, callback);
    }

    public <T> void save(T o, AsyncOperationCallback<T> callback) {
        if (o instanceof List) {
            this.saveList((List)o, callback);
        } else if (o instanceof Collection) {
            this.saveList(new ArrayList((Collection)o), callback);
        } else {
            this.save(o, this.getMapper().getCollectionName(o.getClass()), callback);
        }
    }

    public <T> void store(T o, String collection) {
        this.save(o, collection, null);
    }

    public <T> void store(T o, String collection, AsyncOperationCallback<T> callback) {
        this.save(o, collection, callback);
    }

    public <T> void save(T o, String collection, AsyncOperationCallback<T> callback) {
        if (o instanceof List) {
            this.saveList((List)o, collection, callback);
        } else if (o instanceof Collection) {
            this.saveList(new ArrayList((Collection)o), collection, callback);
        }
        if (this.getARHelper().getId(o) != null) {
            this.getWriterForClass(o.getClass()).store(o, collection, callback);
        } else {
            this.getWriterForClass(o.getClass()).insert(o, collection, callback);
        }
    }

    public <T> void setInEntity(T toSet, Enum<?> field, Object value, AsyncOperationCallback<T> callback) {
        this.setInEntity(toSet, field.name(), value, callback);
    }

    public <T> void setInEntity(T toSet, Enum<?> field, Object value) {
        this.setInEntity(toSet, field.name(), value, null);
    }

    public <T> void setInEntity(T toSet, String collection, Enum<?> field, Object value) {
        this.setInEntity(toSet, collection, field.name(), value, false, null);
    }

    public <T> void setInEntity(T toSet, Enum<?> field, Object value, boolean upserts, AsyncOperationCallback<T> callback) {
        this.setInEntity(toSet, field.name(), value, upserts, callback);
    }

    public <T> void setInEntity(T toSet, Map<Enum, Object> values) {
        this.setInEntity(toSet, this.getMapper().getCollectionName(toSet.getClass()), false, values, null);
    }

    public <T> void setInEntity(T toSet, String collection, boolean upserts, Map<Enum, Object> values) {
        this.set(toSet, collection, upserts, values, null);
    }

    public <T> Map<String, Object> explainRemove(ExplainCommand.ExplainVerbosity verbosity, T o) {
        return this.getConfig().writerSettings().getWriter().explainRemove(verbosity, o, this.getMapper().getCollectionName(o.getClass()));
    }

    public <T> void setInEntity(T toSet, String field, Object value) {
        this.setInEntity(toSet, field, value, null);
    }

    public <T> void setInEntity(T toSet, String field, Object value, boolean upserts, AsyncOperationCallback<T> callback) {
        this.setInEntity(toSet, this.getMapper().getCollectionName(toSet.getClass()), field, value, upserts, callback);
    }

    public <T> void setInEntity(T toSet, String collection, Map<String, Object> values) {
        this.setInEntity(toSet, collection, values, false, null);
    }

    public <T> void setInEntity(T toSet, String collection, Map<String, Object> values, boolean upserts) {
        this.setInEntity(toSet, collection, values, upserts, null);
    }

    public <T> void setInEntity(T toSet, String collection, Enum field, Object value, boolean upserts, AsyncOperationCallback<T> callback) {
        this.setInEntity(toSet, collection, UtilsMap.of(field.name(), value), upserts, callback);
    }

    public <T> void setInEntity(T toSet, String collection, String field, Object value, boolean upserts, AsyncOperationCallback<T> callback) {
        this.setInEntity(toSet, collection, UtilsMap.of(field, value), upserts, callback);
    }

    public <T> void setInEntity(T toSet, String field, Object value, AsyncOperationCallback<T> callback) {
        this.setInEntity(toSet, field, value, false, callback);
    }

    public Map<String, Object> dec(Query<?> query, Enum<?> field, double amount, boolean upsert, boolean multiple) {
        return this.dec(query, field.name(), -amount, upsert, multiple);
    }

    public Map<String, Object> dec(Query<?> query, Enum<?> field, long amount, boolean upsert, boolean multiple) {
        return this.dec(query, field.name(), -amount, upsert, multiple);
    }

    public Map<String, Object> dec(Query<?> query, Enum<?> field, Number amount, boolean upsert, boolean multiple) {
        return this.dec(query, field.name(), amount.doubleValue(), upsert, multiple);
    }

    public Map<String, Object> dec(Query<?> query, Enum<?> field, int amount, boolean upsert, boolean multiple) {
        return this.dec(query, field.name(), amount, upsert, multiple);
    }

    public Map<String, Object> dec(Query<?> query, String field, double amount, boolean upsert, boolean multiple) {
        return this.inc(query, field, -amount, upsert, multiple);
    }

    public Map<String, Object> dec(Query<?> query, String field, long amount, boolean upsert, boolean multiple) {
        return this.inc(query, field, -amount, upsert, multiple);
    }

    public Map<String, Object> dec(Query<?> query, String field, int amount, boolean upsert, boolean multiple) {
        return this.inc(query, field, -amount, upsert, multiple);
    }

    public Map<String, Object> dec(Query<?> query, String field, Number amount, boolean upsert, boolean multiple) {
        return this.inc(query, field, -amount.doubleValue(), upsert, multiple);
    }

    public Map<String, Object> dec(Query<?> query, String field, double amount) {
        return this.inc(query, field, -amount, false, false);
    }

    public Map<String, Object> dec(Query<?> query, String field, long amount) {
        return this.inc(query, field, -amount, false, false);
    }

    public Map<String, Object> dec(Query<?> query, String field, int amount) {
        return this.inc((Query)query, field, -amount, false, false, (AsyncOperationCallback)null);
    }

    public Map<String, Object> dec(Query<?> query, String field, Number amount) {
        return this.inc(query, field, -amount.doubleValue(), false, false);
    }

    public Map<String, Object> dec(Query<?> query, Enum<?> field, double amount) {
        return this.inc(query, field, -amount, false, false);
    }

    public Map<String, Object> dec(Query<?> query, Enum<?> field, long amount) {
        return this.inc(query, field, -amount, false, false);
    }

    public Map<String, Object> dec(Query<?> query, Enum<?> field, int amount) {
        return this.inc(query, field, -amount, false, false);
    }

    public Map<String, Object> dec(Query<?> query, Enum<?> field, Number amount) {
        return this.inc(query, field, -amount.doubleValue(), false, false);
    }

    public Map<String, Object> inc(Query<?> query, String field, long amount) {
        return this.inc(query, field, amount, false, false);
    }

    public Map<String, Object> inc(Query<?> query, String field, int amount) {
        return this.inc(query, field, amount, false, false);
    }

    public Map<String, Object> inc(Query<?> query, String field, Number amount) {
        return this.inc(query, field, amount, false, false);
    }

    public Map<String, Object> inc(Query<?> query, String field, double amount) {
        return this.inc(query, field, amount, false, false);
    }

    public Map<String, Object> inc(Query<?> query, Enum<?> field, double amount) {
        return this.inc(query, field, amount, false, false);
    }

    public Map<String, Object> inc(Query<?> query, Enum<?> field, long amount) {
        return this.inc(query, field, amount, false, false);
    }

    public Map<String, Object> inc(Query<?> query, Enum<?> field, int amount) {
        return this.inc(query, field, amount, false, false);
    }

    public Map<String, Object> inc(Query<?> query, Enum<?> field, Number amount) {
        return this.inc(query, field, amount, false, false);
    }

    public Map<String, Object> inc(Query<?> query, Enum<?> field, double amount, boolean upsert, boolean multiple) {
        return this.inc(query, field.name(), amount, upsert, multiple);
    }

    public Map<String, Object> inc(Query<?> query, Enum<?> field, long amount, boolean upsert, boolean multiple) {
        return this.inc(query, field.name(), amount, upsert, multiple);
    }

    public Map<String, Object> inc(Query<?> query, Enum<?> field, int amount, boolean upsert, boolean multiple) {
        return this.inc(query, field.name(), amount, upsert, multiple);
    }

    public Map<String, Object> inc(Query<?> query, Enum<?> field, Number amount, boolean upsert, boolean multiple) {
        return this.inc(query, field.name(), amount, upsert, multiple);
    }

    public <T> T findById(Class<? extends T> type, Object id) {
        return this.findById(type, id, null);
    }

    public List<Object> distinct(String key, String collectionName) {
        return this.distinct(key, collectionName, null);
    }

    public List<Object> distinct(Enum<?> key, Class c) {
        return this.distinct(key.name(), c);
    }

    public List<Object> distinct(Enum<?> key, Query q) {
        return this.distinct(key.name(), q);
    }

    public List<Object> distinct(String key, Class cls) {
        return this.distinct(key, cls, null);
    }

    public <T> Map<String, Object> addToSet(Query<T> query, String field, Object value) {
        return this.addToSet(query, field, value, false, false);
    }

    public <T> Map<String, Object> addToSet(Query<T> query, String field, Object value, boolean multiple) {
        return this.addToSet(query, field, value, false, multiple);
    }

    public <T> Map<String, Object> addToSet(Query<T> query, String field, Object value, boolean upsert, boolean multiple) {
        if (query == null || field == null) {
            throw new RuntimeException("Cannot update null!");
        }
        MorphiumWriter wr = this.getWriterForClass(query.getType());
        return wr.pushPull(MorphiumStorageListener.UpdateTypes.ADD_TO_SET, query, field, value, upsert, multiple, null);
    }

    public void push(Object entity, String collection, Enum<?> field, Object value, boolean upsert) {
        this.push(entity, collection, field.name(), value, upsert);
    }

    public void push(Object entity, Enum<?> field, Object value, boolean upsert) {
        this.push(entity, field.name(), value, upsert);
    }

    public Map<String, Object> pullAll(Query<?> query, Enum<?> field, List<Object> value, boolean upsert, boolean multiple) {
        return this.pull(query, field.name(), value, upsert, multiple, null);
    }

    public <T> Map<String, Object> push(Query<T> query, String field, Object value, boolean upsert, boolean multiple) {
        return this.push(query, field, value, upsert, multiple, null);
    }

    public <T> void save(List<T> lst, AsyncOperationCallback<T> callback) {
        this.saveList(lst, callback);
    }

    public <T> void store(List<T> lst, AsyncOperationCallback<T> callback) {
        this.saveList(lst, callback);
    }

    public <T> Map<String, Object> pull(Query<T> query, String field, Object value, boolean upsert, boolean multiple, AsyncOperationCallback<T> callback) {
        if (query == null || field == null) {
            throw new RuntimeException("Cannot update null!");
        }
        MorphiumWriter wr = this.getWriterForClass(query.getType());
        return wr.pushPull(MorphiumStorageListener.UpdateTypes.PULL, query, field, value, upsert, multiple, callback);
    }

    public Map<String, Object> push(Query<?> query, Enum<?> field, Object value) {
        return this.push(query, field, value, false, true);
    }

    public Map<String, Object> pull(Query<?> query, Enum<?> field, Object value) {
        return this.pull(query, field.name(), value, false, true, null);
    }

    public Map<String, Object> push(Query<?> query, String field, Object value) {
        return this.push(query, field, value, false, true);
    }

    public Map<String, Object> pull(Query<?> query, String field, Object value) {
        return this.pull(query, field, value, false, true, null);
    }

    public Map<String, Object> push(Query<?> query, Enum<?> field, Object value, boolean upsert, boolean multiple) {
        return this.push(query, field.name(), value, upsert, multiple);
    }

    public Map<String, Object> pull(Query<?> query, Enum<?> field, Object value, boolean upsert, boolean multiple) {
        return this.pull(query, field.name(), value, upsert, multiple, null);
    }

    public Map<String, Object> pushAll(Query<?> query, Enum<?> field, List<Object> value, boolean upsert, boolean multiple) {
        return this.pushAll(query, field.name(), value, upsert, multiple);
    }

    public void push(Object entity, String field, Object value, boolean upsert) {
        this.push(entity, this.getMapper().getCollectionName(entity.getClass()), field, value, upsert);
    }

    @Deprecated
    public <T> Map<String, Object> set(Query<T> query, Enum<?> field, Object val, AsyncOperationCallback<T> callback) {
        HashMap<String, Object> toSet = new HashMap<String, Object>();
        toSet.put(field.name(), val);
        return this.getWriterForClass(query.getType()).set(query, toSet, false, false, callback);
    }

    @Deprecated
    public <T> Map<String, Object> set(Query<T> query, String field, Object val) {
        return this.set(query, field, val, (AsyncOperationCallback)null);
    }

    @Deprecated
    public <T> Map<String, Object> set(Query<T> query, String field, Object val, AsyncOperationCallback<T> callback) {
        HashMap<String, Object> toSet = new HashMap<String, Object>();
        toSet.put(field, val);
        return this.getWriterForClass(query.getType()).set(query, toSet, false, false, callback);
    }

    public Map<String, Object> setEnum(Query<?> query, Map<Enum, Object> values, boolean upsert, boolean multiple) {
        HashMap<String, Object> toSet = new HashMap<String, Object>();
        for (Map.Entry<Enum, Object> est : values.entrySet()) {
            toSet.put(est.getKey().name(), values.get(est.getValue()));
        }
        return this.set(query, toSet, upsert, multiple);
    }

    public <T> Map<String, Object> pushAll(Query<T> query, String field, List<?> value, boolean upsert, boolean multiple, AsyncOperationCallback<T> callback) {
        if (query == null || field == null) {
            throw new RuntimeException("Cannot update null!");
        }
        MorphiumWriter wr = this.getWriterForClass(query.getType());
        return wr.pushPullAll(MorphiumStorageListener.UpdateTypes.PUSH, query, field, value, upsert, multiple, callback);
    }

    public <T> Map<String, Object> addAllToSet(Query<T> query, String field, List<?> value, boolean multiple) {
        return this.addAllToSet(query, field, value, false, multiple, null);
    }

    public <T> Map<String, Object> addAllToSet(Query<T> query, String field, List<?> value, boolean upsert, boolean multiple) {
        return this.addAllToSet(query, field, value, upsert, multiple, null);
    }

    public <T> Map<String, Object> addAllToSet(Query<T> query, String field, List<?> value, boolean upsert, boolean multiple, AsyncOperationCallback callback) {
        if (query == null || field == null) {
            throw new RuntimeException("Cannot update null!");
        }
        MorphiumWriter wr = this.getWriterForClass(query.getType());
        return wr.pushPullAll(MorphiumStorageListener.UpdateTypes.ADD_TO_SET, query, field, value, upsert, multiple, callback);
    }

    public <T> Map<String, Object> pull(Query<T> query, String field, Expr value, boolean upsert, boolean multiple, AsyncOperationCallback<T> callback) {
        if (query == null || field == null) {
            throw new RuntimeException("Cannot update null!");
        }
        MorphiumWriter wr = this.getWriterForClass(query.getType());
        return wr.pushPull(MorphiumStorageListener.UpdateTypes.PULL, query, field, value, upsert, multiple, callback);
    }

    public Map<String, Object> pushAll(Query<?> query, String field, List<?> value, boolean upsert, boolean multiple) {
        return this.pushAll(query, field, value, upsert, multiple, null);
    }

    @Deprecated
    public <T> Map<String, Object> set(Query<T> query, Enum<?> field, Object val, boolean upsert, boolean multiple) {
        return this.set(query, field.name(), val, upsert, multiple, null);
    }

    @Deprecated
    public <T> Map<String, Object> set(Query<T> query, Enum<?> field, Object val, boolean upsert, boolean multiple, AsyncOperationCallback<T> callback) {
        return this.set(query, field.name(), val, upsert, multiple, callback);
    }

    public Map<String, Object> pullAll(Query<?> query, String field, List<Object> value, boolean upsert, boolean multiple) {
        return this.pull(query, field, value, upsert, multiple, null);
    }

    @Deprecated
    public <T> Map<String, Object> set(Query<T> query, String field, Object val, boolean upsert, boolean multiple) {
        return this.set(query, field, val, upsert, multiple, null);
    }

    @Deprecated
    public <T> Map<String, Object> set(Query<T> query, String field, Object val, boolean upsert, boolean multiple, AsyncOperationCallback<T> callback) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(field, val);
        return query.set(map, upsert, multiple, callback);
    }

    @Deprecated
    public Map<String, Object> set(Query<?> query, Map<String, Object> map, boolean upsert, boolean multiple) {
        return query.set(map, upsert, multiple, null);
    }

    public <T> Map<String, Object> currentDate(Query<?> query, String field, boolean upsert, boolean multiple) {
        return this.set(query, UtilsMap.of("$currentDate", UtilsMap.of(field, 1)), upsert, multiple);
    }

    public <T> Map<String, Object> currentDate(Query<?> query, Enum field, boolean upsert, boolean multiple) {
        return this.set(query, UtilsMap.of("$currentDate", UtilsMap.of(field.name(), 1)), upsert, multiple);
    }

    public <T> Map<String, Object> pull(T entity, String field, Expr value, boolean upsert, boolean multiple) {
        return this.pull(entity, field, value, upsert, multiple, null);
    }

    public abstract <T> Map<String, Object> pull(T var1, String var2, Expr var3, boolean var4, boolean var5, AsyncOperationCallback<T> var6);

    public abstract void push(Object var1, String var2, String var3, Object var4, boolean var5);

    public abstract <T> Map<String, Object> push(Query<T> var1, String var2, Object var3, boolean var4, boolean var5, AsyncOperationCallback<T> var6);

    public <T> void insertList(List arrayList, AsyncOperationCallback<T> callback) {
        this.insertList(arrayList, null, callback);
    }

    public <T> void insertList(List arrayList) {
        this.insertList(arrayList, null, null);
    }

    public <T> void insert(T o) {
        if (o instanceof List) {
            this.insertList((List)o, null);
        } else if (o instanceof Collection) {
            this.insertList(new ArrayList((Collection)o), null);
        } else {
            this.insert(o, null);
        }
    }

    public <T> void insert(T o, AsyncOperationCallback<T> callback) {
        if (o instanceof List) {
            this.insertList((List)o, callback);
        } else if (o instanceof Collection) {
            this.insertList(new ArrayList((Collection)o), callback);
        } else {
            this.insert(o, this.getMapper().getCollectionName(o.getClass()), callback);
        }
    }

    public <T> void insert(T o, String collection, AsyncOperationCallback<T> callback) {
        if (o instanceof List) {
            this.insertList((List)o, collection, callback);
        } else if (o instanceof Collection) {
            this.insertList(new ArrayList((Collection)o), collection, callback);
        } else {
            this.getWriterForClass(o.getClass()).insert(o, collection, callback);
        }
    }

    public Map<String, Integer> storeMaps(Class type, List<Map<String, Object>> lst) throws MorphiumDriverException {
        return this.saveMaps(type, lst);
    }

    public <T> void storeNoCache(T lst) {
        this.storeNoCache(lst, this.getMapper().getCollectionName(lst.getClass()), null);
    }

    public <T> void storeNoCache(T o, AsyncOperationCallback<T> callback) {
        this.storeNoCache(o, this.getMapper().getCollectionName(o.getClass()), callback);
    }

    public <T> void storeNoCache(T o, String collection) {
        this.storeNoCache(o, collection, null);
    }

    public <T> void storeNoCache(T o, String collection, AsyncOperationCallback<T> callback) {
        if (this.getARHelper().getId(o) == null) {
            this.getConfig().getWriter().insert(o, collection, callback);
        } else {
            this.getConfig().getWriter().store(o, collection, callback);
        }
    }

    public <T> void storeBuffered(T lst) {
        this.storeBuffered(lst, null);
    }

    public <T> void storeBuffered(T lst, AsyncOperationCallback<T> callback) {
        this.storeBuffered(lst, this.getMapper().getCollectionName(lst.getClass()), callback);
    }

    public <T> void storeBuffered(T lst, String collection, AsyncOperationCallback<T> callback) {
        this.getConfig().getBufferedWriter().store(lst, collection, callback);
    }

    public <T> void ensureIndicesFor(Class<T> type) {
        this.ensureIndicesFor(type, this.getMapper().getCollectionName(type), null);
    }

    public <T> void ensureIndicesFor(Class<T> type, String onCollection) {
        this.ensureIndicesFor(type, onCollection, null);
    }

    public <T> void ensureIndicesFor(Class<T> type, AsyncOperationCallback<T> callback) {
        this.ensureIndicesFor(type, this.getMapper().getCollectionName(type), callback);
    }

    public <T> void ensureIndicesFor(Class<T> type, String onCollection, AsyncOperationCallback<T> callback) {
        this.ensureIndicesFor(type, onCollection, callback, this.getWriterForClass(type));
    }

    @Deprecated
    public <T> Map<String, Object> unsetQ(Query<T> q, String ... field) {
        return this.getWriterForClass(q.getType()).unset(q, null, false, field);
    }

    @Deprecated
    public <T> Map<String, Object> unsetQ(Query<T> q, boolean multiple, String ... field) {
        return this.getWriterForClass(q.getType()).unset(q, null, multiple, field);
    }

    @Deprecated
    public <T> Map<String, Object> unsetQ(Query<T> q, Enum ... field) {
        return this.getWriterForClass(q.getType()).unset(q, null, false, field);
    }

    @Deprecated
    public <T> Map<String, Object> unsetQ(Query<T> q, boolean multiple, Enum ... field) {
        return this.getWriterForClass(q.getType()).unset(q, null, multiple, field);
    }

    public <T> Map<String, Object> unsetQ(Query<T> q, AsyncOperationCallback<T> cb, String ... field) {
        return this.getWriterForClass(q.getType()).unset(q, cb, false, field);
    }

    public <T> Map<String, Object> unsetQ(Query<T> q, AsyncOperationCallback<T> cb, boolean multiple, String ... field) {
        return this.getWriterForClass(q.getType()).unset(q, cb, false, field);
    }

    public <T> Map<String, Object> unsetQ(Query<T> q, AsyncOperationCallback<T> cb, Enum ... field) {
        return this.getWriterForClass(q.getType()).unset(q, cb, false, field);
    }

    public <T> Map<String, Object> unsetQ(Query<T> q, boolean multiple, AsyncOperationCallback<T> cb, Enum ... field) {
        return this.getWriterForClass(q.getType()).unset(q, cb, multiple, field);
    }

    public abstract <T> void ensureIndicesFor(Class<T> var1, String var2, AsyncOperationCallback<T> var3, MorphiumWriter var4);

    public abstract Map<String, Integer> saveMaps(Class var1, List<Map<String, Object>> var2) throws MorphiumDriverException;

    public abstract <T> void insertList(List var1, String var2, AsyncOperationCallback<T> var3);

    public abstract <T> T findById(Class<? extends T> var1, Object var2, String var3);

    public abstract <T> void findById(Class<? extends T> var1, Object var2, String var3, AsyncOperationCallback var4);

    public abstract List<Object> distinct(String var1, Query var2);

    public abstract List<Object> distinct(String var1, String var2, Collation var3);

    public abstract List<Object> distinct(String var1, Class var2, Collation var3);

    public abstract <T> Map<String, Object> inc(Map<Enum, Number> var1, Query<T> var2, boolean var3, boolean var4, AsyncOperationCallback<T> var5);

    public abstract <T> void setInEntity(T var1, String var2, Map<String, Object> var3, boolean var4, AsyncOperationCallback<T> var5);

    public abstract <T> void set(T var1, String var2, Map<String, Object> var3, boolean var4, AsyncOperationCallback<T> var5);

    public abstract <T> void set(T var1, String var2, boolean var3, Map<Enum, Object> var4, AsyncOperationCallback<T> var5);

    public abstract <T> void setInEntity(T var1, String var2, boolean var3, Map<Enum, Object> var4, AsyncOperationCallback<T> var5);

    public abstract <T> void unsetInEntity(T var1, String var2, String var3, AsyncOperationCallback<T> var4);

    public abstract boolean isWriteBufferEnabledForThread();

    public abstract MorphiumDriver getDriver();

    public abstract String getDatabase();

    public abstract Object getId(Object var1);

    public abstract MorphiumWriter getWriterForClass(Class<?> var1);

    public abstract MorphiumObjectMapper getMapper();

    public abstract AnnotationAndReflectionHelper getARHelper();

    public abstract MorphiumConfig getConfig();

    public abstract <T> void saveList(List<T> var1, String var2, AsyncOperationCallback<T> var3);

    public abstract <T> void saveList(List<T> var1, AsyncOperationCallback<T> var2);
}

