/*
 * Decompiled with CFR 0.152.
 */
package de.caluga.morphium.writer;

import com.fasterxml.jackson.databind.ObjectMapper;
import de.caluga.morphium.Collation;
import de.caluga.morphium.IndexDescription;
import de.caluga.morphium.Morphium;
import de.caluga.morphium.MorphiumConfig;
import de.caluga.morphium.MorphiumStorageListener;
import de.caluga.morphium.ShutdownListener;
import de.caluga.morphium.StatisticKeys;
import de.caluga.morphium.Utils;
import de.caluga.morphium.UtilsMap;
import de.caluga.morphium.annotations.AdditionalData;
import de.caluga.morphium.annotations.Capped;
import de.caluga.morphium.annotations.CreationTime;
import de.caluga.morphium.annotations.Embedded;
import de.caluga.morphium.annotations.Entity;
import de.caluga.morphium.annotations.LastChange;
import de.caluga.morphium.annotations.Reference;
import de.caluga.morphium.async.AsyncOperationCallback;
import de.caluga.morphium.async.AsyncOperationType;
import de.caluga.morphium.driver.Doc;
import de.caluga.morphium.driver.MorphiumDriverException;
import de.caluga.morphium.driver.MorphiumId;
import de.caluga.morphium.driver.WriteConcern;
import de.caluga.morphium.driver.bulk.BulkRequestContext;
import de.caluga.morphium.driver.commands.CountMongoCommand;
import de.caluga.morphium.driver.commands.CreateCommand;
import de.caluga.morphium.driver.commands.CreateIndexesCommand;
import de.caluga.morphium.driver.commands.DeleteMongoCommand;
import de.caluga.morphium.driver.commands.DropMongoCommand;
import de.caluga.morphium.driver.commands.ExplainCommand;
import de.caluga.morphium.driver.commands.InsertMongoCommand;
import de.caluga.morphium.driver.commands.ListCollectionsCommand;
import de.caluga.morphium.driver.commands.MongoCommand;
import de.caluga.morphium.driver.commands.StoreMongoCommand;
import de.caluga.morphium.driver.commands.UpdateMongoCommand;
import de.caluga.morphium.driver.commands.WriteMongoCommand;
import de.caluga.morphium.driver.wire.MongoConnection;
import de.caluga.morphium.query.Query;
import de.caluga.morphium.writer.MorphiumWriter;
import de.caluga.morphium.writer.WriterTask;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.bson.types.ObjectId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MorphiumWriterImpl
implements MorphiumWriter,
ShutdownListener {
    private static final Logger logger = LoggerFactory.getLogger(MorphiumWriterImpl.class);
    private Morphium morphium;
    private int maximumRetries = 10;
    private int pause = 250;
    private ThreadPoolExecutor executor = null;

    @Override
    public void setMaximumQueingTries(int n) {
        this.maximumRetries = n;
    }

    @Override
    public void setPauseBetweenTries(int p) {
        this.pause = p;
    }

    @Override
    public void setMorphium(Morphium m) {
        this.morphium = m;
        if (m != null) {
            int max;
            LinkedBlockingQueue<Runnable> queue = new LinkedBlockingQueue<Runnable>(){

                @Override
                public boolean offer(Runnable e) {
                    int maximumPoolSize;
                    int poolSize = MorphiumWriterImpl.this.executor.getPoolSize();
                    if (poolSize >= (maximumPoolSize = MorphiumWriterImpl.this.executor.getMaximumPoolSize()) || poolSize > MorphiumWriterImpl.this.executor.getActiveCount()) {
                        return super.offer(e);
                    }
                    return false;
                }
            };
            int core = m.getConfig().getMaxConnections() / 2;
            if (core <= 1) {
                core = 1;
            }
            if ((max = m.getConfig().getMaxConnections() * m.getConfig().getThreadConnectionMultiplier()) <= core) {
                max = 2 * core;
            }
            this.executor = new ThreadPoolExecutor(core, max, 60L, TimeUnit.SECONDS, (BlockingQueue<Runnable>)queue);
            this.executor.setRejectedExecutionHandler((r, executor) -> {
                try {
                    executor.getQueue().put(r);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            });
            this.executor.setThreadFactory(new ThreadFactory(){
                private final AtomicInteger num = new AtomicInteger(1);

                @Override
                public Thread newThread(Runnable r) {
                    Thread ret = new Thread(r, "writer " + String.valueOf(this.num));
                    this.num.set(this.num.get() + 1);
                    ret.setDaemon(true);
                    return ret;
                }
            });
            m.addShutdownListener(this);
        }
    }

    @Override
    public void close() {
        if (this.executor != null) {
            this.executor.shutdownNow();
        }
    }

    @Override
    public <T> void insert(List<T> lst, AsyncOperationCallback<T> callback) {
        this.insert((T)lst, null, callback);
    }

    private void setIdIfNull(Object record) throws IllegalAccessException {
        Field idf = this.morphium.getARHelper().getIdField(record);
        if (idf.get(record) != null) {
            return;
        }
        if (idf.get(record) == null && idf.getType().equals(MorphiumId.class)) {
            idf.set(record, new MorphiumId());
        } else if (idf.get(record) == null && idf.getType().equals(ObjectId.class)) {
            idf.set(record, new ObjectId());
        } else if (idf.get(record) == null && idf.getType().equals(String.class)) {
            idf.set(record, new MorphiumId().toString());
        } else if (idf.getType().isAssignableFrom(MorphiumId.class)) {
            idf.set(record, new MorphiumId());
        } else {
            throw new IllegalArgumentException("Cannot set ID of non-ID-Type");
        }
    }

    @Override
    public <T> void insert(final List<T> lst, final String cn, AsyncOperationCallback<T> callback) {
        if (!lst.isEmpty()) {
            WriterTask r = new WriterTask(){
                private AsyncOperationCallback<T> callback;

                public void setCallback(AsyncOperationCallback cb) {
                    this.callback = cb;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    long allStart = System.currentTimeMillis();
                    try {
                        String collectionName = cn;
                        if (lst == null || lst.isEmpty()) {
                            return;
                        }
                        if (collectionName == null) {
                            collectionName = MorphiumWriterImpl.this.morphium.getMapper().getCollectionName(lst.get(0).getClass());
                        }
                        List<Map<String, Object>> dbLst = new ArrayList<Map<String, Object>>();
                        WriteConcern wc = MorphiumWriterImpl.this.morphium.getWriteConcernForClass(lst.get(0).getClass());
                        HashMap<Object, Boolean> isNew = new HashMap<Object, Boolean>();
                        for (Object o : lst) {
                            boolean isn = true;
                            if (MorphiumWriterImpl.this.morphium.isAutoValuesEnabledForThread()) {
                                try {
                                    isn = MorphiumWriterImpl.this.morphium.setAutoValues(o);
                                }
                                catch (IllegalAccessException e) {
                                    throw new RuntimeException("could not set auto variable!", e);
                                }
                            }
                            isNew.put(o, isn);
                            try {
                                MorphiumWriterImpl.this.setIdIfNull(o);
                            }
                            catch (IllegalAccessException e) {
                                throw new RuntimeException(e);
                            }
                        }
                        MorphiumWriterImpl.this.checkIndexAndCaps(lst.get(0).getClass(), collectionName, this.callback);
                        long start = System.currentTimeMillis();
                        MorphiumWriterImpl.this.morphium.firePreStore(isNew);
                        for (Object o : lst) {
                            dbLst.add(MorphiumWriterImpl.this.morphium.getMapper().serialize(o));
                        }
                        MongoCommand settings = null;
                        try {
                            while (dbLst.size() != 0) {
                                MongoConnection con = MorphiumWriterImpl.this.morphium.getDriver().getPrimaryConnection(wc);
                                settings = ((InsertMongoCommand)((InsertMongoCommand)new InsertMongoCommand(con).setDb(MorphiumWriterImpl.this.morphium.getDatabase())).setColl(collectionName)).setOrdered(false);
                                if (dbLst.size() > MorphiumWriterImpl.this.morphium.getConfig().getCursorBatchSize()) {
                                    ((InsertMongoCommand)settings).setDocuments(dbLst.subList(0, MorphiumWriterImpl.this.morphium.getConfig().getCursorBatchSize()));
                                    dbLst = dbLst.subList(MorphiumWriterImpl.this.morphium.getConfig().getCursorBatchSize(), dbLst.size());
                                } else {
                                    ((InsertMongoCommand)settings).setDocuments(dbLst);
                                    dbLst = new ArrayList();
                                }
                                if (wc != null) {
                                    ((WriteMongoCommand)settings).setWriteConcern(wc.asMap());
                                }
                                Map<String, Object> writeResult = ((InsertMongoCommand)settings).execute();
                                settings.releaseConnection();
                                settings = null;
                                if (!writeResult.containsKey("writeErrors")) continue;
                                int failedWrites = ((List)writeResult.get("writeErrors")).size();
                                int success = (Integer)writeResult.get("n");
                                throw new RuntimeException("Failed to write: " + failedWrites + " - succeeded: " + success);
                            }
                        }
                        finally {
                            if (settings != null) {
                                settings.releaseConnection();
                            }
                        }
                        ArrayList cleared = new ArrayList();
                        for (Object o : lst) {
                            if (cleared.contains(o.getClass())) continue;
                            cleared.add(o.getClass());
                            MorphiumWriterImpl.this.morphium.getCache().clearCacheIfNecessary(o.getClass());
                        }
                        MorphiumWriterImpl.this.morphium.firePostStore(isNew);
                        if (this.callback != null) {
                            this.callback.onOperationSucceeded(AsyncOperationType.WRITE, null, System.currentTimeMillis() - allStart, null, null, lst);
                        }
                    }
                    catch (Exception e) {
                        if (this.callback != null) {
                            this.callback.onOperationError(AsyncOperationType.WRITE, null, System.currentTimeMillis() - allStart, e.getMessage(), e, null, new Object[0]);
                        }
                        if (e instanceof RuntimeException) {
                            throw (RuntimeException)e;
                        }
                        throw new RuntimeException(e);
                    }
                }
            };
            this.submitAndBlockIfNecessary(callback, r);
        }
    }

    @Override
    public <T> void insert(T obj, String collection, AsyncOperationCallback<T> callback) {
        if (obj instanceof List) {
            this.insert((T)((List)obj), collection, callback);
            return;
        }
        this.insert((T)Arrays.asList(obj), collection, callback);
    }

    private <T> void checkIndexAndCaps(Class type, String coll, AsyncOperationCallback<T> callback) throws MorphiumDriverException {
        if (coll == null) {
            coll = this.morphium.getMapper().getCollectionName(type);
        }
        if (this.morphium == null || this.morphium.getConfig() == null) {
            return;
        }
        if (!this.morphium.getDriver().isTransactionInProgress() && !this.morphium.getDriver().exists(this.getDbName(), coll)) {
            if (this.morphium.getConfig().getCappedCheck().equals((Object)MorphiumConfig.CappedCheck.CREATE_ON_WRITE_NEW_COL)) {
                this.createCappedCollection(type, coll);
            }
            if (this.morphium.getConfig().getIndexCheck().equals((Object)MorphiumConfig.IndexCheck.CREATE_ON_WRITE_NEW_COL)) {
                this.morphium.ensureIndicesFor(type, coll, callback);
            }
        }
    }

    @Override
    public <T> void store(T obj, String collection, AsyncOperationCallback<T> callback) {
        if (obj instanceof List) {
            this.store((List)obj, collection, callback);
            return;
        }
        this.store(Arrays.asList(obj), collection, callback);
    }

    private void checkViolations(Exception e) {
        if (e instanceof RuntimeException && e.getClass().getName().equals("javax.validation.ConstraintViolationException")) {
            try {
                Method m = e.getClass().getMethod("getConstraintViolations", new Class[0]);
                Set violations = (Set)m.invoke((Object)e, new Object[0]);
                for (Object v : violations) {
                    m = v.getClass().getMethod("getMessage", new Class[0]);
                    String msg = (String)m.invoke(v, new Object[0]);
                    m = v.getClass().getMethod("getRootBean", new Class[0]);
                    Object bean = m.invoke(v, new Object[0]);
                    String s = Utils.toJsonString(bean);
                    String type = bean.getClass().getName();
                    m = v.getClass().getMethod("getInvalidValue", new Class[0]);
                    Object invalidValue = m.invoke(v, new Object[0]);
                    m = v.getClass().getMethod("getPropertyPath", new Class[0]);
                    Iterable pth = (Iterable)m.invoke(v, new Object[0]);
                    StringBuilder stringBuilder = new StringBuilder();
                    for (Object p : pth) {
                        m = p.getClass().getMethod("getName", new Class[0]);
                        String name = (String)m.invoke(p, new Object[0]);
                        stringBuilder.append(".");
                        stringBuilder.append(name);
                    }
                    logger.error("Validation of " + type + " failed: " + msg + " - Invalid Value: " + String.valueOf(invalidValue) + " for path: " + String.valueOf(stringBuilder) + "\n Tried to store: " + s);
                }
            }
            catch (Exception e1) {
                logger.error("Could not get more information about validation error ", (Throwable)e1);
            }
        }
    }

    @Override
    public <T> void store(final List<T> lst, final String cln, AsyncOperationCallback<T> callback) {
        if (!lst.isEmpty()) {
            WriterTask r = new WriterTask(){
                private AsyncOperationCallback<T> callback;

                public void setCallback(AsyncOperationCallback cb) {
                    this.callback = cb;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    long allStart = System.currentTimeMillis();
                    try {
                        long start;
                        String coll;
                        Class c;
                        HashMap toUpdate = new HashMap();
                        HashMap newElementsToInsert = new HashMap();
                        for (int i = 0; i < lst.size(); ++i) {
                            boolean isn;
                            Object o = lst.get(i);
                            Class<?> type = MorphiumWriterImpl.this.morphium.getARHelper().getRealClass(o.getClass());
                            if (!MorphiumWriterImpl.this.morphium.getARHelper().isAnnotationPresentInHierarchy(type, Entity.class)) {
                                logger.error("Not an entity! Storing not possible! Even not in list!");
                                continue;
                            }
                            MorphiumWriterImpl.this.morphium.inc(StatisticKeys.WRITES);
                            o = MorphiumWriterImpl.this.morphium.getARHelper().getRealObject(o);
                            if (o == null) {
                                logger.warn("Illegal Reference? - cannot store Lazy-Loaded / Partial Update Proxy without delegate!");
                                return;
                            }
                            boolean bl = isn = MorphiumWriterImpl.this.morphium.getId(o) == null;
                            if (MorphiumWriterImpl.this.morphium.isAutoValuesEnabledForThread()) {
                                isn = MorphiumWriterImpl.this.morphium.setAutoValues(o);
                            }
                            if (isn) {
                                MorphiumWriterImpl.this.setIdIfNull(o);
                                MorphiumWriterImpl.this.morphium.firePreStore(o, isn);
                                newElementsToInsert.putIfAbsent(o.getClass(), new ArrayList());
                                ((List)newElementsToInsert.get(o.getClass())).add(MorphiumWriterImpl.this.morphium.getMapper().serialize(o));
                                continue;
                            }
                            MorphiumWriterImpl.this.morphium.firePreStore(o, isn);
                            toUpdate.putIfAbsent(o.getClass(), new ArrayList());
                            ((List)toUpdate.get(o.getClass())).add(MorphiumWriterImpl.this.morphium.getMapper().serialize(o));
                        }
                        for (Map.Entry es : toUpdate.entrySet()) {
                            c = (Class)es.getKey();
                            WriteConcern wc = MorphiumWriterImpl.this.morphium.getWriteConcernForClass(c);
                            coll = cln != null ? cln : MorphiumWriterImpl.this.morphium.getMapper().getCollectionName(c);
                            MorphiumWriterImpl.this.checkIndexAndCaps(c, coll, this.callback);
                            start = System.currentTimeMillis();
                            List<Map<String, Object>> lst2 = new ArrayList<Map<String, Object>>();
                            lst2.addAll((Collection)es.getValue());
                            MongoConnection con = MorphiumWriterImpl.this.morphium.getDriver().getPrimaryConnection(wc);
                            MongoCommand settings = null;
                            try {
                                while (!lst2.isEmpty()) {
                                    settings = (StoreMongoCommand)((StoreMongoCommand)new StoreMongoCommand(con).setDb(MorphiumWriterImpl.this.morphium.getConfig().getDatabase())).setColl(coll);
                                    if (lst2.size() > MorphiumWriterImpl.this.morphium.getConfig().getCursorBatchSize()) {
                                        ((StoreMongoCommand)settings).setDocuments(lst2.subList(0, MorphiumWriterImpl.this.morphium.getConfig().getCursorBatchSize()));
                                        lst2 = lst2.subList(MorphiumWriterImpl.this.morphium.getConfig().getCursorBatchSize(), lst2.size());
                                    } else {
                                        ((StoreMongoCommand)settings).setDocuments(lst2);
                                        lst2 = new ArrayList();
                                    }
                                    if (wc != null) {
                                        ((WriteMongoCommand)settings).setWriteConcern(wc.asMap());
                                    }
                                    Map<String, Object> map = ((StoreMongoCommand)settings).execute();
                                }
                                MorphiumWriterImpl.this.morphium.getCache().clearCacheIfNecessary(c);
                                long dur = System.currentTimeMillis() - start;
                                ((List)es.getValue()).forEach(record -> MorphiumWriterImpl.this.morphium.firePostStore(record, true));
                            }
                            finally {
                                if (settings == null) continue;
                                settings.releaseConnection();
                            }
                        }
                        for (Map.Entry es : newElementsToInsert.entrySet()) {
                            c = (Class)es.getKey();
                            WriteConcern wc = MorphiumWriterImpl.this.morphium.getWriteConcernForClass(c);
                            coll = cln != null ? cln : MorphiumWriterImpl.this.morphium.getMapper().getCollectionName(c);
                            MorphiumWriterImpl.this.checkIndexAndCaps(c, coll, null);
                            start = System.currentTimeMillis();
                            MongoCommand insert = null;
                            try {
                                MongoConnection con = MorphiumWriterImpl.this.morphium.getDriver().getPrimaryConnection(wc);
                                insert = new InsertMongoCommand(con);
                                insert.setDb(MorphiumWriterImpl.this.morphium.getDatabase());
                                insert.setColl(coll);
                                ((InsertMongoCommand)insert).setDocuments((List)es.getValue());
                                ((InsertMongoCommand)insert).setOrdered(false);
                                if (wc != null) {
                                    ((WriteMongoCommand)insert).setWriteConcern(wc.asMap());
                                }
                                Map<String, Object> result = ((InsertMongoCommand)insert).execute();
                                insert.releaseConnection();
                                if (result.containsKey("writeErrors")) {
                                    int failedWrites = ((List)result.get("writeErrors")).size();
                                    int success = (Integer)result.get("n");
                                    throw new RuntimeException("Failed to write: " + failedWrites + " - succeeded: " + success);
                                }
                            }
                            finally {
                                if (insert != null) {
                                    insert.releaseConnection();
                                }
                            }
                            MorphiumWriterImpl.this.morphium.getCache().clearCacheIfNecessary(c);
                            long l = System.currentTimeMillis() - start;
                        }
                        if (this.callback != null) {
                            this.callback.onOperationSucceeded(AsyncOperationType.WRITE, null, System.currentTimeMillis() - allStart, null, null, lst);
                        }
                        lst.forEach(record -> MorphiumWriterImpl.this.morphium.firePostStore(record, true));
                    }
                    catch (Exception e) {
                        if (e instanceof RuntimeException) {
                            throw (RuntimeException)e;
                        }
                        if (this.callback == null) {
                            if (e instanceof RuntimeException) {
                                throw (RuntimeException)e;
                            }
                            throw new RuntimeException(e);
                        }
                        this.callback.onOperationError(AsyncOperationType.WRITE, null, System.currentTimeMillis() - allStart, e.getMessage(), e, null, lst);
                    }
                }
            };
            this.submitAndBlockIfNecessary(callback, r);
        }
    }

    @Override
    public void flush() {
    }

    @Override
    public void flush(Class type) {
    }

    @Override
    public <T> void store(List<T> lst, AsyncOperationCallback<T> callback) {
        this.store(lst, (String)null, callback);
    }

    private void createCappedCollection(Class c) {
        this.createCappedCollection(c, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createCappedCollection(Class c, String collectionName) {
        block18: {
            if (logger.isDebugEnabled()) {
                logger.debug("Collection does not exist - ensuring indices / capped status / Schema validation");
            }
            MongoCommand cmd = null;
            try {
                de.caluga.morphium.annotations.Collation collation;
                MongoConnection con = null;
                con = this.morphium.getDriver().getPrimaryConnection(this.morphium.getWriteConcernForClass(c));
                ListCollectionsCommand lcmd = ((ListCollectionsCommand)new ListCollectionsCommand(con).setDb(this.getDbName())).setFilter(Doc.of("name", collectionName));
                List<Map<String, Object>> result = lcmd.execute();
                lcmd.releaseConnection();
                if (result.size() > 0) {
                    logger.info("collection already exists");
                    return;
                }
                Entity e = this.morphium.getARHelper().getAnnotationFromHierarchy(c, Entity.class);
                con = this.morphium.getDriver().getPrimaryConnection(this.morphium.getWriteConcernForClass(c));
                cmd = new CreateCommand(con);
                cmd.setDb(this.morphium.getDatabase());
                cmd.setColl(this.morphium.getMapper().getCollectionName(c));
                Capped capped = this.morphium.getARHelper().getAnnotationFromHierarchy(c, Capped.class);
                if (capped != null) {
                    ((CreateCommand)cmd).setCapped(true);
                    ((CreateCommand)cmd).setSize(capped.maxSize());
                    ((CreateCommand)cmd).setMax(capped.maxEntries());
                }
                if (!e.schemaDef().equals("")) {
                    ObjectMapper jacksonOM = new ObjectMapper();
                    try {
                        Map def = (Map)jacksonOM.readValue(e.schemaDef().getBytes(), Map.class);
                        ((CreateCommand)cmd).setValidator(def);
                        ((CreateCommand)cmd).setValidationLevel(e.validationLevel().name());
                        ((CreateCommand)cmd).setValidationAction(e.validationAction().name());
                    }
                    catch (Exception parseException) {
                        parseException.printStackTrace();
                        throw new RuntimeException("Error parsing", parseException);
                    }
                }
                if (!e.comment().equals("")) {
                    cmd.setComment(e.comment());
                }
                if ((collation = this.morphium.getARHelper().getAnnotationFromHierarchy(c, de.caluga.morphium.annotations.Collation.class)) != null) {
                    Collation collation1 = new Collation();
                    collation1.locale(collation.locale());
                    if (!collation.alternate().equals("")) {
                        collation1.alternate(collation.alternate());
                    }
                    if (!collation.caseFirst().equals("")) {
                        collation1.caseFirst(collation.caseFirst());
                    }
                    collation1.backwards(collation.backwards());
                    collation1.caseLevel(collation.caseLevel());
                    collation1.numericOrdering(collation.numericOrdering());
                    collation1.strength(collation.strength());
                    ((CreateCommand)cmd).setCollation(collation1.toQueryObject());
                }
                ((CreateCommand)cmd).execute();
            }
            catch (MorphiumDriverException ex) {
                if (ex.getMessage().contains("already exists")) {
                    LoggerFactory.getLogger(MorphiumWriterImpl.class).error("Collection already exists...cannot create");
                    break block18;
                }
                throw new RuntimeException(ex);
            }
            finally {
                if (cmd != null) {
                    cmd.releaseConnection();
                }
            }
        }
    }

    private String getDbName() {
        return this.morphium.getConfig().getDatabase();
    }

    private void executeWriteBatch(List<Object> es, Class c, WriteConcern wc, BulkRequestContext bulkCtx, long start) {
        try {
            bulkCtx.execute();
        }
        catch (MorphiumDriverException e) {
            throw new RuntimeException(e);
        }
        long dur = System.currentTimeMillis() - start;
        this.morphium.getCache().clearCacheIfNecessary(c);
        this.morphium.firePostStore(es, false);
    }

    @Override
    public <T> void set(T toSet, String col, Map<String, Object> values, boolean upsert, AsyncOperationCallback<T> callback) {
        Query<?> q = this.morphium.createQueryFor(toSet.getClass()).f("_id").eq(this.morphium.getId(toSet));
        q.setCollectionName(col);
        this.set(q, values, upsert, false, callback);
        for (Map.Entry<String, Object> entry : values.entrySet()) {
            if (entry.getKey().contains(".")) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                this.morphium.reread(toSet);
                continue;
            }
            Field fld = this.morphium.getARHelper().getField(toSet.getClass(), entry.getKey());
            try {
                fld.set(toSet, entry.getValue());
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException("could not set value to field: " + entry.getKey());
            }
        }
    }

    public <T> Map<String, Object> submitAndBlockIfNecessary(AsyncOperationCallback<T> callback, WriterTask<T> r) {
        if (callback == null) {
            int retries = 0;
            while (true) {
                try {
                    r.run();
                }
                catch (Exception e) {
                    if (this.morphium != null && this.morphium.getConfig() != null && ++retries < this.morphium.getConfig().getRetriesOnNetworkError()) {
                        Utils.pause(this.morphium.getConfig().getSleepBetweenNetworkErrorRetries());
                        continue;
                    }
                    throw new RuntimeException(e);
                }
                break;
            }
            return r.getReturnObject();
        }
        r.setCallback(callback);
        Runnable retryRunnable = () -> {
            int retries = 0;
            while (true) {
                try {
                    r.run();
                }
                catch (Exception e) {
                    if (++retries < this.morphium.getConfig().getRetriesOnNetworkError()) {
                        Utils.pause(this.morphium.getConfig().getRetriesOnNetworkError());
                        continue;
                    }
                    callback.onOperationError(AsyncOperationType.WRITE, null, 0L, e.getMessage(), e, null, new Object[0]);
                    continue;
                }
                break;
            }
        };
        int tries = 0;
        boolean retry = true;
        while (retry) {
            try {
                ++tries;
                this.executor.execute(retryRunnable);
                retry = false;
            }
            catch (OutOfMemoryError ignored) {
                logger.error(tries + " - Got OutOfMemory Erro, retrying...", (Throwable)ignored);
            }
            catch (RejectedExecutionException e) {
                if (tries > this.maximumRetries) {
                    throw new RuntimeException("Could not write - not even after " + this.maximumRetries + " retries and pause of " + this.pause + "ms", e);
                }
                if (logger.isDebugEnabled()) {
                    logger.warn("thread pool exceeded - waiting " + this.pause + " ms for the " + tries + ". time");
                }
                try {
                    Thread.sleep(this.pause);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        try {
            Thread.sleep(5L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        return null;
    }

    @Override
    public <T> void updateUsingFields(final T ent, final String collection, AsyncOperationCallback<T> callback, final String ... fields) {
        if (ent == null) {
            return;
        }
        WriterTask r = new WriterTask(){
            private AsyncOperationCallback<T> callback;

            public void setCallback(AsyncOperationCallback cb) {
                this.callback = cb;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object id = MorphiumWriterImpl.this.morphium.getARHelper().getId(ent);
                if (id == null) {
                    logger.warn("trying to partially update new object - storing it in full!");
                    MorphiumWriterImpl.this.store(ent, collection, this.callback);
                    return;
                }
                MorphiumWriterImpl.this.morphium.firePreStore(ent, false);
                MorphiumWriterImpl.this.morphium.inc(StatisticKeys.WRITES);
                Entity entityDefinition = MorphiumWriterImpl.this.morphium.getARHelper().getAnnotationFromHierarchy(ent.getClass(), Entity.class);
                HashMap<String, Object> find = new HashMap<String, Object>();
                find.put("_id", id);
                HashMap<String, Object> update = new HashMap<String, Object>();
                for (String f : fields) {
                    try {
                        Object value = MorphiumWriterImpl.this.morphium.getARHelper().getValue(ent, f);
                        if (value != null) {
                            Entity en = MorphiumWriterImpl.this.morphium.getARHelper().getAnnotationFromHierarchy(value.getClass(), Entity.class);
                            if (MorphiumWriterImpl.this.morphium.getARHelper().isAnnotationPresentInHierarchy(value.getClass(), Entity.class)) {
                                value = MorphiumWriterImpl.this.morphium.getARHelper().getField(ent.getClass(), f).getAnnotation(Reference.class) != null ? MorphiumWriterImpl.this.morphium.getARHelper().getId(ent) : MorphiumWriterImpl.this.morphium.getMapper().serialize(value);
                            }
                        }
                        update.put(f, value);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
                Class<?> type = MorphiumWriterImpl.this.morphium.getARHelper().getRealClass(ent.getClass());
                LastChange t = MorphiumWriterImpl.this.morphium.getARHelper().getAnnotationFromHierarchy(type, LastChange.class);
                if (t != null) {
                    List<String> lst = MorphiumWriterImpl.this.morphium.getARHelper().getFields(ent.getClass(), LastChange.class);
                    long now = System.currentTimeMillis();
                    for (String ctf : lst) {
                        Field f = MorphiumWriterImpl.this.morphium.getARHelper().getField(type, ctf);
                        if (f != null) {
                            try {
                                f.set(ent, now);
                            }
                            catch (IllegalAccessException e) {
                                logger.error("Could not set modification time", (Throwable)e);
                            }
                        }
                        update.put(ctf, now);
                    }
                }
                update = UtilsMap.of("$set", update);
                WriteConcern wc = MorphiumWriterImpl.this.morphium.getWriteConcernForClass(type);
                long start = System.currentTimeMillis();
                try {
                    String collectionName = collection;
                    if (collectionName == null) {
                        collectionName = MorphiumWriterImpl.this.morphium.getMapper().getCollectionName(ent.getClass());
                    }
                    MorphiumWriterImpl.this.checkIndexAndCaps(ent.getClass(), collectionName, this.callback);
                    MongoCommand up = null;
                    try {
                        MongoConnection con = MorphiumWriterImpl.this.morphium.getDriver().getPrimaryConnection(wc);
                        up = ((UpdateMongoCommand)((UpdateMongoCommand)new UpdateMongoCommand(con).setDb(MorphiumWriterImpl.this.getDbName())).setColl(collectionName)).setUpdates(Arrays.asList(Doc.of("q", Doc.of(find), "u", Doc.of(update), "multi", (Object)false, "upsert", (Object)false)));
                        if (wc != null) {
                            ((WriteMongoCommand)up).setWriteConcern(wc.asMap());
                        }
                        Map<String, Object> ret = ((WriteMongoCommand)up).execute();
                        up.releaseConnection();
                        if (ret.containsKey("ok") && ret.get("ok").equals(0.0)) {
                            throw new MorphiumDriverException("Error: " + String.valueOf(ret.get("code")) + " - " + String.valueOf(ret.get("errmsg")));
                        }
                        if (!Integer.valueOf(1).equals(ret.get("nModified"))) {
                            throw new MorphiumDriverException("Error - not updated");
                        }
                    }
                    finally {
                        if (up != null) {
                            up.releaseConnection();
                        }
                    }
                    long dur = System.currentTimeMillis() - start;
                    MorphiumWriterImpl.this.morphium.getCache().clearCacheIfNecessary(MorphiumWriterImpl.this.morphium.getARHelper().getRealClass(ent.getClass()));
                    MorphiumWriterImpl.this.morphium.firePostStore(ent, false);
                    if (this.callback != null) {
                        this.callback.onOperationSucceeded(AsyncOperationType.UPDATE, null, System.currentTimeMillis() - start, null, ent, new Object[]{fields});
                    }
                }
                catch (Exception e) {
                    if (this.callback == null) {
                        if (e instanceof RuntimeException) {
                            throw (RuntimeException)e;
                        }
                        throw new RuntimeException(e);
                    }
                    this.callback.onOperationError(AsyncOperationType.UPDATE, null, System.currentTimeMillis() - start, e.getMessage(), e, ent, new Object[]{fields});
                }
            }
        };
        this.submitAndBlockIfNecessary(callback, r);
    }

    @Override
    public <T> void remove(final List<T> lst, AsyncOperationCallback<T> callback) {
        WriterTask r = new WriterTask(){
            private AsyncOperationCallback<T> callback;

            public void setCallback(AsyncOperationCallback cb) {
                this.callback = cb;
            }

            @Override
            public void run() {
                HashMap sortedMap = new HashMap();
                for (Object o : lst) {
                    if (sortedMap.get(o.getClass()) == null) {
                        ArrayList queries = new ArrayList();
                        sortedMap.put(o.getClass(), queries);
                    }
                    Query<?> q = MorphiumWriterImpl.this.morphium.createQueryFor(o.getClass());
                    q.f(MorphiumWriterImpl.this.morphium.getARHelper().getIdFieldName(o)).eq(MorphiumWriterImpl.this.morphium.getARHelper().getId(o));
                    ((List)sortedMap.get(o.getClass())).add(q);
                }
                MorphiumWriterImpl.this.morphium.firePreRemove(lst);
                long start = System.currentTimeMillis();
                try {
                    for (Class cls : sortedMap.keySet()) {
                        Query orQuery = MorphiumWriterImpl.this.morphium.createQueryFor(cls);
                        orQuery = orQuery.or((List)sortedMap.get(cls));
                        MorphiumWriterImpl.this.remove(orQuery, null);
                    }
                    MorphiumWriterImpl.this.morphium.inc(StatisticKeys.WRITES);
                    MorphiumWriterImpl.this.morphium.firePostRemove(lst);
                    if (this.callback != null) {
                        this.callback.onOperationSucceeded(AsyncOperationType.REMOVE, null, System.currentTimeMillis() - start, null, null, lst);
                    }
                }
                catch (Exception e) {
                    if (this.callback == null) {
                        throw new RuntimeException(e);
                    }
                    this.callback.onOperationError(AsyncOperationType.REMOVE, null, System.currentTimeMillis() - start, e.getMessage(), e, null, lst);
                }
            }
        };
        this.submitAndBlockIfNecessary(callback, r);
    }

    @Override
    public <T> Map<String, Object> explainRemove(ExplainCommand.ExplainVerbosity verbosity, Query<T> q) {
        MongoCommand settings = null;
        try {
            MongoConnection con = null;
            WriteConcern wc = this.morphium.getWriteConcernForClass(q.getType());
            con = this.morphium.getDriver().getPrimaryConnection(wc);
            String collectionName = q.getCollectionName();
            int limit = q.getLimit();
            settings = ((DeleteMongoCommand)((DeleteMongoCommand)new DeleteMongoCommand(con).setColl(collectionName)).setDb(this.getDbName())).setDeletes(Arrays.asList(Doc.of("q", q.toQueryObject(), "limit", (Object)limit, "collation", q.getCollation() == null ? null : q.getCollation().toQueryObject())));
            Map<String, Object> map = ((DeleteMongoCommand)settings).explain(verbosity);
            return map;
        }
        catch (MorphiumDriverException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (settings != null) {
                settings.releaseConnection();
            }
        }
    }

    @Override
    public <T> Map<String, Object> remove(Query<T> q, AsyncOperationCallback<T> callback) {
        return this.remove(q, true, callback);
    }

    @Override
    public <T> Map<String, Object> remove(final Query<T> q, final boolean multiple, AsyncOperationCallback<T> callback) {
        WriterTask r = new WriterTask(){
            private AsyncOperationCallback<T> callback;
            private Map<String, Object> ret = new HashMap<String, Object>();

            public Map getReturnObject() {
                return this.ret;
            }

            public void setCallback(AsyncOperationCallback cb) {
                this.callback = cb;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                MorphiumWriterImpl.this.morphium.firePreRemoveEvent(q);
                WriteConcern wc = MorphiumWriterImpl.this.morphium.getWriteConcernForClass(q.getType());
                long start = System.currentTimeMillis();
                MongoConnection con = null;
                MongoCommand settings = null;
                try {
                    int limit;
                    con = MorphiumWriterImpl.this.morphium.getDriver().getPrimaryConnection(wc);
                    String collectionName = q.getCollectionName();
                    int n = limit = multiple ? 0 : 1;
                    if (q.getLimit() > 0 && multiple) {
                        limit = q.getLimit();
                    }
                    settings = ((DeleteMongoCommand)((DeleteMongoCommand)new DeleteMongoCommand(con).setColl(collectionName)).setDb(MorphiumWriterImpl.this.getDbName())).setDeletes(Arrays.asList(Doc.of("q", q.toQueryObject(), "limit", (Object)limit, "collation", q.getCollation() == null ? null : q.getCollation().toQueryObject())));
                    if (wc != null) {
                        ((WriteMongoCommand)settings).setWriteConcern(wc.asMap());
                    }
                    this.ret = ((WriteMongoCommand)settings).execute();
                    settings.releaseConnection();
                    long dur = System.currentTimeMillis() - start;
                    MorphiumWriterImpl.this.morphium.inc(StatisticKeys.WRITES);
                    MorphiumWriterImpl.this.morphium.getCache().clearCacheIfNecessary(q.getType());
                    MorphiumWriterImpl.this.morphium.firePostRemoveEvent(q);
                    if (this.callback != null) {
                        this.callback.onOperationSucceeded(AsyncOperationType.REMOVE, q, System.currentTimeMillis() - start, null, null, new Object[0]);
                    }
                }
                catch (Exception e) {
                    if (this.callback == null) {
                        if (e instanceof RuntimeException) {
                            throw (RuntimeException)e;
                        }
                        throw new RuntimeException(e);
                    }
                    this.callback.onOperationError(AsyncOperationType.REMOVE, q, System.currentTimeMillis() - start, e.getMessage(), e, null, new Object[0]);
                }
                finally {
                    if (settings != null) {
                        settings.releaseConnection();
                    }
                }
            }
        };
        return this.submitAndBlockIfNecessary(callback, r);
    }

    @Override
    public <T> Map<String, Object> explainRemove(ExplainCommand.ExplainVerbosity verbosity, T o, String collection) {
        Object id = this.morphium.getARHelper().getId(o);
        this.morphium.firePreRemove(o);
        HashMap<String, Object> db = new HashMap<String, Object>();
        db.put("_id", id);
        WriteConcern wc = this.morphium.getWriteConcernForClass(o.getClass());
        MongoConnection con = null;
        MongoCommand settings = null;
        try {
            if (collection == null) {
                this.morphium.getMapper().getCollectionName(o.getClass());
            }
            con = this.morphium.getDriver().getPrimaryConnection(wc);
            settings = ((DeleteMongoCommand)((DeleteMongoCommand)new DeleteMongoCommand(con).setDb(this.getDbName())).setColl(collection)).setDeletes(Arrays.asList(Doc.of("q", db, "limit", (Object)1)));
            if (wc != null) {
                ((WriteMongoCommand)settings).setWriteConcern(wc.asMap());
            }
            Map<String, Object> map = ((DeleteMongoCommand)settings).explain(verbosity);
            return map;
        }
        catch (MorphiumDriverException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (settings != null) {
                settings.releaseConnection();
            }
        }
    }

    @Override
    public <T> void remove(final T o, final String collection, AsyncOperationCallback<T> callback) {
        WriterTask r = new WriterTask(){
            private AsyncOperationCallback<T> callback;

            public void setCallback(AsyncOperationCallback cb) {
                this.callback = cb;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object id = MorphiumWriterImpl.this.morphium.getARHelper().getId(o);
                MorphiumWriterImpl.this.morphium.firePreRemove(o);
                HashMap<String, Object> db = new HashMap<String, Object>();
                db.put("_id", id);
                WriteConcern wc = MorphiumWriterImpl.this.morphium.getWriteConcernForClass(o.getClass());
                long start = System.currentTimeMillis();
                MongoCommand settings = null;
                try {
                    MongoConnection con = null;
                    con = MorphiumWriterImpl.this.morphium.getDriver().getPrimaryConnection(wc);
                    settings = ((DeleteMongoCommand)new DeleteMongoCommand(con).setDb(MorphiumWriterImpl.this.getDbName())).setDeletes(Arrays.asList(Doc.of("q", db, "limit", (Object)1)));
                    if (collection == null) {
                        settings.setColl(MorphiumWriterImpl.this.morphium.getMapper().getCollectionName(o.getClass()));
                    } else {
                        settings.setColl(collection);
                    }
                    if (wc != null) {
                        ((WriteMongoCommand)settings).setWriteConcern(wc.asMap());
                    }
                    ((WriteMongoCommand)settings).execute();
                    settings.releaseConnection();
                    MorphiumWriterImpl.this.morphium.clearCachefor(o.getClass());
                    MorphiumWriterImpl.this.morphium.inc(StatisticKeys.WRITES);
                    MorphiumWriterImpl.this.morphium.firePostRemoveEvent(o);
                    if (this.callback != null) {
                        this.callback.onOperationSucceeded(AsyncOperationType.REMOVE, null, System.currentTimeMillis() - start, null, o, new Object[0]);
                    }
                }
                catch (Exception e) {
                    if (this.callback == null) {
                        if (e instanceof RuntimeException) {
                            throw (RuntimeException)e;
                        }
                        throw new RuntimeException(e);
                    }
                    this.callback.onOperationError(AsyncOperationType.REMOVE, null, System.currentTimeMillis() - start, e.getMessage(), e, o, new Object[0]);
                }
                finally {
                    if (settings != null) {
                        settings.releaseConnection();
                    }
                }
            }
        };
        this.submitAndBlockIfNecessary(callback, r);
    }

    @Override
    public <T> void inc(final T toInc, final String collection, final String field, final Number amount, AsyncOperationCallback<T> callback) {
        WriterTask r = new WriterTask(){
            private AsyncOperationCallback<T> callback;

            public void setCallback(AsyncOperationCallback cb) {
                this.callback = cb;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Class<?> cls = toInc.getClass();
                MorphiumWriterImpl.this.morphium.firePreUpdateEvent(MorphiumWriterImpl.this.morphium.getARHelper().getRealClass(cls), MorphiumStorageListener.UpdateTypes.INC);
                String coll = collection;
                if (coll == null) {
                    coll = MorphiumWriterImpl.this.morphium.getMapper().getCollectionName(cls);
                }
                HashMap<String, Object> query = new HashMap<String, Object>();
                query.put("_id", MorphiumWriterImpl.this.morphium.getId(toInc));
                Field f = MorphiumWriterImpl.this.morphium.getARHelper().getField(cls, field);
                if (f == null) {
                    throw new RuntimeException("Cannot inc unknown field: " + field);
                }
                String fieldName = MorphiumWriterImpl.this.morphium.getARHelper().getMongoFieldName(cls, field);
                UtilsMap<String, Object> update = UtilsMap.of("$inc", UtilsMap.of(fieldName, amount));
                WriteConcern wc = MorphiumWriterImpl.this.morphium.getWriteConcernForClass(toInc.getClass());
                long start = System.currentTimeMillis();
                MongoCommand settings = null;
                try {
                    MongoConnection con = null;
                    MorphiumWriterImpl.this.checkIndexAndCaps(cls, coll, this.callback);
                    con = MorphiumWriterImpl.this.morphium.getDriver().getPrimaryConnection(wc);
                    MorphiumWriterImpl.this.handleLastChange(cls, update);
                    settings = ((UpdateMongoCommand)((UpdateMongoCommand)new UpdateMongoCommand(con).setColl(coll)).setDb(MorphiumWriterImpl.this.getDbName())).addUpdate(Doc.of(query), Doc.of(update), null, false, false, null, null, null);
                    if (wc != null) {
                        ((WriteMongoCommand)settings).setWriteConcern(wc.asMap());
                    }
                    Map<String, Object> ret = ((WriteMongoCommand)settings).execute();
                    settings.releaseConnection();
                    if (ret.containsKey("ok") && ret.get("ok").equals(0.0)) {
                        throw new MorphiumDriverException("Error: " + String.valueOf(ret.get("code")) + " - " + String.valueOf(ret.get("errmsg")));
                    }
                    if (!Integer.valueOf(1).equals(ret.get("nModified"))) {
                        throw new MorphiumDriverException("Update failed");
                    }
                    MorphiumWriterImpl.this.morphium.getCache().clearCacheIfNecessary(cls);
                    if (f.getType().equals(Integer.class) || f.getType().equals(Integer.TYPE)) {
                        try {
                            f.set(toInc, (Integer)f.get(toInc) + amount.intValue());
                        }
                        catch (IllegalAccessException e) {
                            throw new RuntimeException(e);
                        }
                    } else if (f.getType().equals(Double.class) || f.getType().equals(Double.TYPE)) {
                        try {
                            f.set(toInc, (Double)f.get(toInc) + amount.doubleValue());
                        }
                        catch (IllegalAccessException e) {
                            throw new RuntimeException(e);
                        }
                    } else if (f.getType().equals(Float.class) || f.getType().equals(Float.TYPE)) {
                        try {
                            f.set(toInc, Float.valueOf(((Float)f.get(toInc)).floatValue() + amount.floatValue()));
                        }
                        catch (IllegalAccessException e) {
                            throw new RuntimeException(e);
                        }
                    } else if (f.getType().equals(Long.class) || f.getType().equals(Long.TYPE)) {
                        try {
                            f.set(toInc, (Long)f.get(toInc) + amount.longValue());
                        }
                        catch (IllegalAccessException e) {
                            throw new RuntimeException(e);
                        }
                    } else {
                        logger.error("Could not set increased value - unsupported type " + cls.getName());
                    }
                    MorphiumWriterImpl.this.morphium.firePostUpdateEvent(MorphiumWriterImpl.this.morphium.getARHelper().getRealClass(cls), MorphiumStorageListener.UpdateTypes.INC);
                    if (this.callback != null) {
                        this.callback.onOperationSucceeded(AsyncOperationType.INC, null, System.currentTimeMillis() - start, null, toInc, field, amount);
                    }
                }
                catch (Exception e) {
                    if (this.callback == null) {
                        if (e instanceof RuntimeException) {
                            throw (RuntimeException)e;
                        }
                        throw new RuntimeException(e);
                    }
                    this.callback.onOperationError(AsyncOperationType.INC, null, System.currentTimeMillis() - start, e.getMessage(), e, toInc, field, amount);
                }
                finally {
                    if (settings != null) {
                        settings.releaseConnection();
                    }
                }
            }
        };
        this.submitAndBlockIfNecessary(callback, r);
    }

    private void sumUp(Map<String, Object> toAdd, Map<String, Object> target) {
        for (Map.Entry<String, Object> e : toAdd.entrySet()) {
            try {
                if (e.getValue() instanceof Integer) {
                    target.putIfAbsent(e.getKey(), 0);
                    target.put(e.getKey(), (Integer)e.getValue() + (Integer)target.get(e.getKey()));
                    continue;
                }
                if (e.getValue() instanceof Long) {
                    target.putIfAbsent(e.getKey(), 0L);
                    target.put(e.getKey(), (Long)e.getValue() + (Long)target.get(e.getKey()));
                    continue;
                }
                if (e.getValue() instanceof Double) {
                    target.putIfAbsent(e.getKey(), 0.0);
                    target.put(e.getKey(), (Double)e.getValue() + (Double)target.get(e.getKey()));
                    continue;
                }
                if (e.getValue() instanceof String) {
                    target.putIfAbsent(e.getKey(), "");
                    target.put(e.getKey(), (String)target.get(e.getKey()) + (String)e.getValue());
                    continue;
                }
                target.put(e.getKey(), e.getValue());
            }
            catch (ClassCastException ex) {
                LoggerFactory.getLogger(MorphiumWriterImpl.class).error("Could not set value for " + e.getKey());
            }
        }
    }

    @Override
    public <T> Map<String, Object> inc(final Query<T> query, final Map<String, Number> fieldsToInc, final boolean upsert, final boolean multiple, AsyncOperationCallback<T> callback) {
        WriterTask r = new WriterTask(){
            private AsyncOperationCallback<T> callback;
            private Map<String, Object> ret = new HashMap<String, Object>();

            public void setCallback(AsyncOperationCallback cb) {
                this.callback = cb;
            }

            public Map getReturnObject() {
                return this.ret;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                if (query.getLimit() > 1 && multiple) {
                    LoggerFactory.getLogger(MorphiumWriterImpl.class).error("Limit for inc not supported - ignoring");
                }
                Class cls = query.getType();
                MorphiumWriterImpl.this.morphium.firePreUpdateEvent(MorphiumWriterImpl.this.morphium.getARHelper().getRealClass(cls), MorphiumStorageListener.UpdateTypes.INC);
                String coll = query.getCollectionName();
                HashMap<String, Object> update = new HashMap<String, Object>();
                update.put("$inc", new HashMap(fieldsToInc));
                MorphiumWriterImpl.this.handleLastChange(cls, update);
                Map<String, Object> qobj = query.toQueryObject();
                if (upsert) {
                    qobj = MorphiumWriterImpl.this.morphium.simplifyQueryObject(qobj);
                }
                long start = System.currentTimeMillis();
                MongoConnection con = null;
                MongoCommand settings = null;
                try {
                    if (upsert) {
                        MorphiumWriterImpl.this.checkIndexAndCaps(cls, coll, this.callback);
                    }
                    if (query.getSort() != null) {
                        logger.warn("Sorting is not supported on updates!");
                    }
                    WriteConcern wc = MorphiumWriterImpl.this.morphium.getWriteConcernForClass(cls);
                    con = MorphiumWriterImpl.this.morphium.getDriver().getPrimaryConnection(wc);
                    settings = (UpdateMongoCommand)((UpdateMongoCommand)new UpdateMongoCommand(con).setDb(MorphiumWriterImpl.this.getDbName())).setColl(coll);
                    ((UpdateMongoCommand)settings).addUpdate(Doc.of(qobj), Doc.of(update), null, upsert, multiple, query.getCollation(), null, null);
                    this.ret = ((WriteMongoCommand)settings).execute();
                    settings.releaseConnection();
                    long dur = System.currentTimeMillis() - start;
                    MorphiumWriterImpl.this.morphium.getCache().clearCacheIfNecessary(cls);
                    MorphiumWriterImpl.this.morphium.firePostUpdateEvent(MorphiumWriterImpl.this.morphium.getARHelper().getRealClass(cls), MorphiumStorageListener.UpdateTypes.INC);
                    if (this.callback != null) {
                        this.callback.onOperationSucceeded(AsyncOperationType.INC, query, System.currentTimeMillis() - start, null, null, fieldsToInc, this.ret);
                    }
                }
                catch (Exception e) {
                    if (this.callback == null) {
                        if (e instanceof RuntimeException) {
                            throw (RuntimeException)e;
                        }
                        throw new RuntimeException(e);
                    }
                    this.callback.onOperationError(AsyncOperationType.INC, query, System.currentTimeMillis() - start, e.getMessage(), e, null, fieldsToInc);
                }
                finally {
                    if (settings != null) {
                        settings.releaseConnection();
                    }
                }
            }
        };
        return this.submitAndBlockIfNecessary(callback, r);
    }

    private <T> void handleLastChange(Class<? extends T> cls, Map<String, Object> update) {
        List<String> latChangeFlds;
        if (!this.morphium.isAutoValuesEnabledForThread()) {
            return;
        }
        LastChange lc = this.morphium.getARHelper().getAnnotationFromHierarchy(cls, LastChange.class);
        if (lc != null && (latChangeFlds = this.morphium.getARHelper().getFields(cls, LastChange.class)) != null && !latChangeFlds.isEmpty()) {
            for (String fL : latChangeFlds) {
                Field fld = this.morphium.getARHelper().getField(cls, fL);
                Class<?> type = fld.getType();
                update.putIfAbsent("$set", new HashMap());
                if (type.equals(Long.class) || type.equals(Long.TYPE)) {
                    ((Map)update.get("$set")).put(this.morphium.getARHelper().getMongoFieldName(cls, fld.getName()), System.currentTimeMillis());
                    continue;
                }
                if (type.equals(Date.class)) {
                    ((Map)update.get("$set")).put(this.morphium.getARHelper().getMongoFieldName(cls, fld.getName()), new Date());
                    continue;
                }
                if (type.equals(String.class)) {
                    ((Map)update.get("$set")).put(this.morphium.getARHelper().getMongoFieldName(cls, fld.getName()), new Date().toString());
                    continue;
                }
                ((Map)update.get("$set")).put(this.morphium.getARHelper().getMongoFieldName(cls, fld.getName()), System.currentTimeMillis());
            }
        }
    }

    @Override
    public <T> Map<String, Object> inc(final Query<T> query, final String field, final Number amount, final boolean upsert, final boolean multiple, AsyncOperationCallback<T> callback) {
        WriterTask r = new WriterTask(){
            private AsyncOperationCallback<T> callback;
            private Map<String, Object> ret = new HashMap<String, Object>();

            public Map getReturnObject() {
                return this.ret;
            }

            public void setCallback(AsyncOperationCallback cb) {
                this.callback = cb;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Class cls = query.getType();
                MorphiumWriterImpl.this.morphium.firePreUpdateEvent(MorphiumWriterImpl.this.morphium.getARHelper().getRealClass(cls), MorphiumStorageListener.UpdateTypes.INC);
                String coll = query.getCollectionName();
                String fieldName = MorphiumWriterImpl.this.morphium.getARHelper().getMongoFieldName(cls, field);
                UtilsMap<String, Object> update = UtilsMap.of("$inc", UtilsMap.of(fieldName, amount));
                Map<String, Object> qobj = query.toQueryObject();
                if (upsert) {
                    qobj = MorphiumWriterImpl.this.morphium.simplifyQueryObject(qobj);
                }
                long start = System.currentTimeMillis();
                MongoConnection con = null;
                MongoCommand settings = null;
                try {
                    if (upsert) {
                        MorphiumWriterImpl.this.checkIndexAndCaps(cls, coll, this.callback);
                    }
                    if (query.getSort() != null) {
                        logger.warn("Sorting not supported in update query!");
                    }
                    MorphiumWriterImpl.this.handleLastChange(cls, update);
                    WriteConcern wc = MorphiumWriterImpl.this.morphium.getWriteConcernForClass(cls);
                    settings = null;
                    con = MorphiumWriterImpl.this.morphium.getDriver().getPrimaryConnection(wc);
                    settings = (UpdateMongoCommand)((UpdateMongoCommand)new UpdateMongoCommand(con).setDb(MorphiumWriterImpl.this.getDbName())).setColl(coll);
                    if (query.getLimit() > 0 && multiple) {
                        for (int i = 0; i < query.getLimit(); ++i) {
                            ((UpdateMongoCommand)settings).addUpdate(Doc.of(qobj), Doc.of(update), null, upsert, false, query.getCollation(), null, null);
                            if (((UpdateMongoCommand)settings).getUpdates().size() < MorphiumWriterImpl.this.morphium.getConfig().getCursorBatchSize()) continue;
                            Map<String, Object> result = ((WriteMongoCommand)settings).execute();
                            MorphiumWriterImpl.this.sumUp(result, this.ret);
                            ((UpdateMongoCommand)settings).getUpdates().clear();
                        }
                    } else {
                        ((UpdateMongoCommand)settings).addUpdate(Doc.of(qobj), Doc.of(update), null, upsert, multiple, query.getCollation(), null, null);
                    }
                    if (settings != null && ((UpdateMongoCommand)settings).getUpdates().size() != 0) {
                        Map<String, Object> result = ((WriteMongoCommand)settings).execute();
                        MorphiumWriterImpl.this.sumUp(result, this.ret);
                    }
                    settings.releaseConnection();
                    if (this.ret.containsKey("ok") && this.ret.get("ok").equals(0.0)) {
                        throw new MorphiumDriverException("Error: " + String.valueOf(this.ret.get("code")) + " - " + String.valueOf(this.ret.get("errmsg")));
                    }
                    MorphiumWriterImpl.this.morphium.getCache().clearCacheIfNecessary(cls);
                    MorphiumWriterImpl.this.morphium.firePostUpdateEvent(MorphiumWriterImpl.this.morphium.getARHelper().getRealClass(cls), MorphiumStorageListener.UpdateTypes.INC);
                    if (this.callback != null) {
                        this.callback.onOperationSucceeded(AsyncOperationType.INC, query, System.currentTimeMillis() - start, null, null, field, amount, this.ret);
                    }
                }
                catch (Exception e) {
                    if (this.callback == null) {
                        if (e instanceof RuntimeException) {
                            throw (RuntimeException)e;
                        }
                        throw new RuntimeException(e);
                    }
                    this.callback.onOperationError(AsyncOperationType.INC, query, System.currentTimeMillis() - start, e.getMessage(), e, null, field, amount);
                }
                finally {
                    if (settings != null) {
                        settings.releaseConnection();
                    }
                }
            }
        };
        return this.submitAndBlockIfNecessary(callback, r);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleCreationTimeOnUpsert(Class cls, String coll, Map<String, Object> query, Map<String, Object> update, boolean upsert) {
        if (upsert && this.morphium.getARHelper().isAnnotationPresentInHierarchy(cls, CreationTime.class) && this.morphium.isAutoValuesEnabledForThread()) {
            Map<String, Object> qobj = this.morphium.simplifyQueryObject(query);
            if (coll == null) {
                coll = this.morphium.getMapper().getCollectionName(cls);
            }
            long cnt = 1L;
            MongoConnection con = null;
            MongoCommand settings = null;
            try {
                con = this.morphium.getDriver().getReadConnection(null);
                settings = (CountMongoCommand)((CountMongoCommand)new CountMongoCommand(con).setQuery(Doc.of(qobj)).setDb(this.getDbName())).setColl(coll);
                cnt = ((CountMongoCommand)settings).getCount();
            }
            catch (MorphiumDriverException e) {
                logger.error("Error counting", (Throwable)e);
            }
            finally {
                if (settings != null) {
                    settings.releaseConnection();
                }
            }
            if (cnt == 0L) {
                List<String> flds = this.morphium.getARHelper().getFields(cls, CreationTime.class);
                for (String creationTimeField : flds) {
                    Class<?> type = this.morphium.getARHelper().getField(cls, creationTimeField).getType();
                    if (type.equals(Date.class)) {
                        qobj.put(creationTimeField, new Date());
                        continue;
                    }
                    if (type.equals(Long.class) || type.equals(Long.TYPE)) {
                        qobj.put(creationTimeField, System.currentTimeMillis());
                        continue;
                    }
                    if (type.equals(String.class)) {
                        qobj.put(creationTimeField, new Date().toString());
                        continue;
                    }
                    logger.error("Could not set CreationTime.... wrong type " + type.getName());
                }
            }
            update.putIfAbsent("$set", new HashMap());
            for (Map.Entry<String, Object> e : update.entrySet()) {
                for (Map.Entry f : ((Map)e.getValue()).entrySet()) {
                    qobj.remove(f.getKey());
                }
            }
            ((Map)update.get("$set")).putAll(qobj);
        }
    }

    @Override
    public <T> Map<String, Object> set(final Query<T> query, final Map<String, Object> values, final boolean upsert, final boolean multiple, AsyncOperationCallback<T> callback) {
        return this.submitAndBlockIfNecessary(callback, new WriterTask(){
            private AsyncOperationCallback<T> callback;
            private Map<String, Object> ret = new HashMap<String, Object>();

            public Map getReturnObject() {
                return this.ret;
            }

            public void setCallback(AsyncOperationCallback cb) {
                this.callback = cb;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Class cls = query.getType();
                String coll = query.getCollectionName();
                MorphiumWriterImpl.this.morphium.firePreUpdateEvent(MorphiumWriterImpl.this.morphium.getARHelper().getRealClass(cls), MorphiumStorageListener.UpdateTypes.SET);
                HashMap<String, Object> toSet = new HashMap<String, Object>();
                for (Map.Entry ef : values.entrySet()) {
                    String fieldName = MorphiumWriterImpl.this.morphium.getARHelper().getMongoFieldName(cls, (String)ef.getKey());
                    toSet.put(fieldName, MorphiumWriterImpl.this.marshallIfNecessary(ef.getValue()));
                }
                UtilsMap<String, Object> update = UtilsMap.of("$set", toSet);
                Map<String, Object> qobj = query.toQueryObject();
                MorphiumWriterImpl.this.handleLastChange(cls, update);
                MorphiumWriterImpl.this.handleCreationTimeOnUpsert(cls, coll, query.toQueryObject(), update, upsert);
                WriteConcern wc = MorphiumWriterImpl.this.morphium.getWriteConcernForClass(cls);
                long start = System.currentTimeMillis();
                MongoConnection con = null;
                MongoCommand settings = null;
                try {
                    if (upsert) {
                        MorphiumWriterImpl.this.checkIndexAndCaps(cls, coll, this.callback);
                    }
                    con = MorphiumWriterImpl.this.morphium.getDriver().getPrimaryConnection(wc);
                    settings = (UpdateMongoCommand)((UpdateMongoCommand)((UpdateMongoCommand)new UpdateMongoCommand(con).setDb(MorphiumWriterImpl.this.getDbName())).setColl(coll)).setWriteConcern(wc != null ? wc.asMap() : null);
                    if (multiple && query.getLimit() > 0) {
                        for (int i = 0; i < query.getLimit(); ++i) {
                            ((UpdateMongoCommand)settings).addUpdate(Doc.of(qobj), Doc.of(update), null, false, false, query.getCollation(), null, null);
                            if (((UpdateMongoCommand)settings).getUpdates().size() < MorphiumWriterImpl.this.morphium.getConfig().getCursorBatchSize()) continue;
                            Map<String, Object> daa = ((WriteMongoCommand)settings).execute();
                            MorphiumWriterImpl.this.sumUp(daa, this.ret);
                        }
                    } else {
                        ((UpdateMongoCommand)settings).addUpdate(Doc.of(qobj), Doc.of(update), null, upsert, multiple, query.getCollation(), null, null);
                    }
                    if (((UpdateMongoCommand)settings).getUpdates().size() != 0) {
                        Map<String, Object> daa = ((WriteMongoCommand)settings).execute();
                        MorphiumWriterImpl.this.sumUp(daa, this.ret);
                    }
                    settings.releaseConnection();
                    MorphiumWriterImpl.this.morphium.inc(StatisticKeys.WRITES);
                    MorphiumWriterImpl.this.morphium.getCache().clearCacheIfNecessary(cls);
                    MorphiumWriterImpl.this.morphium.firePostUpdateEvent(MorphiumWriterImpl.this.morphium.getARHelper().getRealClass(cls), MorphiumStorageListener.UpdateTypes.SET);
                    if (this.callback != null) {
                        this.callback.onOperationSucceeded(AsyncOperationType.SET, query, System.currentTimeMillis() - start, null, null, values, upsert, multiple, this.ret);
                    }
                }
                catch (Exception e) {
                    if (this.callback == null) {
                        if (e instanceof RuntimeException) {
                            throw (RuntimeException)e;
                        }
                        throw new RuntimeException(e);
                    }
                    this.callback.onOperationError(AsyncOperationType.SET, query, System.currentTimeMillis() - start, e.getMessage(), e, null, values, upsert, multiple);
                }
                finally {
                    if (settings != null) {
                        settings.releaseConnection();
                    }
                }
            }
        });
    }

    @Override
    public <T> Map<String, Object> unset(Query<T> query, AsyncOperationCallback<T> callback, boolean multiple, Enum ... fields) {
        ArrayList<String> flds = new ArrayList<String>();
        for (Enum e : fields) {
            flds.add(this.morphium.getARHelper().getMongoFieldName(query.getType(), e.name()));
        }
        return this.unset(query, callback, multiple, flds.toArray(new String[fields.length]));
    }

    @Override
    public <T> Map<String, Object> unset(final Query<T> query, AsyncOperationCallback<T> callback, final boolean multiple, final String ... fields) {
        WriterTask r = new WriterTask(){
            private AsyncOperationCallback<T> callback;
            private Map<String, Object> ret = new HashMap<String, Object>();

            public Map getReturnObject() {
                return this.ret;
            }

            public void setCallback(AsyncOperationCallback cb) {
                this.callback = cb;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Class cls = query.getType();
                String coll = query.getCollectionName();
                MorphiumWriterImpl.this.morphium.firePreUpdateEvent(MorphiumWriterImpl.this.morphium.getARHelper().getRealClass(cls), MorphiumStorageListener.UpdateTypes.SET);
                Map<String, Object> qobj = query.toQueryObject();
                HashMap<String, String> toSet = new HashMap<String, String>();
                for (String f : fields) {
                    toSet.put(MorphiumWriterImpl.this.morphium.getARHelper().getMongoFieldName(cls, f), "");
                }
                UtilsMap<String, Object> update = UtilsMap.of("$unset", toSet);
                MorphiumWriterImpl.this.handleLastChange(cls, update);
                WriteConcern wc = MorphiumWriterImpl.this.morphium.getWriteConcernForClass(cls);
                long start = System.currentTimeMillis();
                MongoConnection con = null;
                if (query.getSort() != null) {
                    logger.warn("Sort not supported when updating");
                }
                MongoCommand settings = null;
                try {
                    con = MorphiumWriterImpl.this.morphium.getDriver().getPrimaryConnection(wc);
                    settings = (UpdateMongoCommand)((UpdateMongoCommand)new UpdateMongoCommand(con).setDb(MorphiumWriterImpl.this.getDbName())).setColl(coll);
                    if (wc != null) {
                        ((WriteMongoCommand)settings).setWriteConcern(wc.asMap());
                    }
                    if (multiple && query.getLimit() > 0) {
                        for (int i = 0; i < query.getLimit(); ++i) {
                            ((UpdateMongoCommand)settings).addUpdate(Doc.of(qobj), Doc.of(update), null, false, false, query.getCollation(), null, null);
                            if (((UpdateMongoCommand)settings).getUpdates().size() < MorphiumWriterImpl.this.morphium.getConfig().getCursorBatchSize()) continue;
                            Map<String, Object> r = ((WriteMongoCommand)settings).execute();
                            MorphiumWriterImpl.this.sumUp(r, this.ret);
                            ((UpdateMongoCommand)settings).getUpdates().clear();
                        }
                    } else {
                        ((UpdateMongoCommand)settings).addUpdate(Doc.of(qobj), Doc.of(update), null, false, multiple, query.getCollation(), null, null);
                    }
                    if (((UpdateMongoCommand)settings).getUpdates().size() != 0) {
                        Map<String, Object> r = ((WriteMongoCommand)settings).execute();
                        MorphiumWriterImpl.this.sumUp(r, this.ret);
                    }
                    settings.releaseConnection();
                    MorphiumWriterImpl.this.morphium.getCache().clearCacheIfNecessary(cls);
                    MorphiumWriterImpl.this.morphium.firePostUpdateEvent(MorphiumWriterImpl.this.morphium.getARHelper().getRealClass(cls), MorphiumStorageListener.UpdateTypes.SET);
                    if (this.callback != null) {
                        this.callback.onOperationSucceeded(AsyncOperationType.SET, query, System.currentTimeMillis() - start, null, null, fields, false, multiple);
                    }
                }
                catch (Exception e) {
                    if (this.callback == null) {
                        if (e instanceof RuntimeException) {
                            throw (RuntimeException)e;
                        }
                        throw new RuntimeException(e);
                    }
                    this.callback.onOperationError(AsyncOperationType.SET, query, System.currentTimeMillis() - start, e.getMessage(), e, null, fields, false, multiple);
                }
                finally {
                    if (settings != null) {
                        settings.releaseConnection();
                    }
                }
            }
        };
        return this.submitAndBlockIfNecessary(callback, r);
    }

    @Override
    public <T> void unset(final T toSet, final String collection, final String field, AsyncOperationCallback<T> callback) {
        if (toSet == null) {
            throw new RuntimeException("Cannot update null!");
        }
        if (this.morphium.getARHelper().getId(toSet) == null) {
            logger.info("just storing object as it is new...");
            this.store(toSet, collection, callback);
        }
        WT r = new WT(){

            @Override
            public void run() {
                Class<?> cls = toSet.getClass();
                MorphiumWriterImpl.this.morphium.firePreUpdateEvent(MorphiumWriterImpl.this.morphium.getARHelper().getRealClass(cls), MorphiumStorageListener.UpdateTypes.UNSET);
                String coll = collection;
                if (coll == null) {
                    coll = MorphiumWriterImpl.this.morphium.getMapper().getCollectionName(cls);
                }
                HashMap<String, Object> query = new HashMap<String, Object>();
                query.put("_id", MorphiumWriterImpl.this.morphium.getId(toSet));
                Field f = MorphiumWriterImpl.this.morphium.getARHelper().getField(cls, field);
                if (f == null && !MorphiumWriterImpl.this.morphium.getARHelper().isAnnotationPresentInHierarchy(cls, AdditionalData.class)) {
                    throw new RuntimeException("Unknown field: " + field);
                }
                String fieldName = MorphiumWriterImpl.this.morphium.getARHelper().getMongoFieldName(cls, field);
                UtilsMap<String, Object> update = UtilsMap.of("$unset", UtilsMap.of(fieldName, 1));
                WriteConcern wc = MorphiumWriterImpl.this.morphium.getWriteConcernForClass(toSet.getClass());
                this.doUpdate(cls, toSet, coll, field, query, f, update, wc);
            }
        };
        this.submitAndBlockIfNecessary(callback, r);
    }

    @Override
    public <T> void pop(final T obj, final String collection, final String field, final boolean first, AsyncOperationCallback<T> callback) {
        if (obj == null) {
            throw new RuntimeException("Cannot update null!");
        }
        if (this.morphium.getARHelper().getId(obj) == null) {
            logger.info("just storing object as it is new...");
            this.store(obj, collection, callback);
        }
        WT r = new WT(){

            @Override
            public void run() {
                Class<?> cls = obj.getClass();
                MorphiumWriterImpl.this.morphium.firePreUpdateEvent(MorphiumWriterImpl.this.morphium.getARHelper().getRealClass(cls), MorphiumStorageListener.UpdateTypes.UNSET);
                String coll = collection;
                if (coll == null) {
                    coll = MorphiumWriterImpl.this.morphium.getMapper().getCollectionName(cls);
                }
                HashMap<String, Object> query = new HashMap<String, Object>();
                query.put("_id", MorphiumWriterImpl.this.morphium.getId(obj));
                Field f = MorphiumWriterImpl.this.morphium.getARHelper().getField(cls, field);
                if (f == null) {
                    throw new RuntimeException("Unknown field: " + field);
                }
                String fieldName = MorphiumWriterImpl.this.morphium.getARHelper().getMongoFieldName(cls, field);
                UtilsMap<String, Object> update = UtilsMap.of("$pop", UtilsMap.of(fieldName, first ? -1 : 1));
                WriteConcern wc = MorphiumWriterImpl.this.morphium.getWriteConcernForClass(obj.getClass());
                this.doUpdate(cls, obj, coll, field, query, f, update, wc);
            }
        };
        this.submitAndBlockIfNecessary(callback, r);
    }

    @Override
    public <T> Map<String, Object> unset(Query<T> query, String field, boolean multiple, AsyncOperationCallback<T> callback) {
        return this.unset(query, callback, multiple, field);
    }

    @Override
    public <T> Map<String, Object> pushPull(final MorphiumStorageListener.UpdateTypes type, final Query<T> query, final String field, final Object value, final boolean upsert, final boolean multiple, AsyncOperationCallback<T> callback) {
        WriterTask r = new WriterTask(){
            private AsyncOperationCallback<T> callback;
            private Map<String, Object> ret = new HashMap<String, Object>();

            public Map getReturnObject() {
                return this.ret;
            }

            public void setCallback(AsyncOperationCallback cb) {
                this.callback = cb;
            }

            @Override
            public void run() {
                Class cls = query.getType();
                MorphiumWriterImpl.this.morphium.firePreUpdateEvent(MorphiumWriterImpl.this.morphium.getARHelper().getRealClass(cls), type);
                String coll = query.getCollectionName();
                Map<String, Object> qobj = query.toQueryObject();
                if (upsert) {
                    qobj = MorphiumWriterImpl.this.morphium.simplifyQueryObject(qobj);
                }
                Object v = MorphiumWriterImpl.this.marshallIfNecessary(value);
                String fieldName = MorphiumWriterImpl.this.morphium.getARHelper().getMongoFieldName(cls, field);
                Doc set = Doc.of(fieldName, v instanceof Enum ? ((Enum)v).name() : v);
                Doc update = null;
                switch (type) {
                    case PUSH: {
                        update = Doc.of("$push", set);
                        break;
                    }
                    case PULL: {
                        update = Doc.of("$pull", set);
                        break;
                    }
                    case ADD_TO_SET: {
                        update = Doc.of("$addToSet", set);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Unsupported type " + type.name());
                    }
                }
                long start = System.currentTimeMillis();
                try {
                    boolean push;
                    boolean bl = push = type.equals((Object)MorphiumStorageListener.UpdateTypes.PUSH) || type.equals((Object)MorphiumStorageListener.UpdateTypes.ADD_TO_SET);
                    if (query.getLimit() != 0) {
                        LoggerFactory.getLogger(MorphiumWriterImpl.class).warn("Limit on push/pull queries not useful!");
                    }
                    this.ret = MorphiumWriterImpl.this.pushIt(push, upsert, multiple, cls, coll, qobj, update, query.getCollation());
                    if (this.ret.containsKey("ok") && this.ret.get("ok").equals(0.0)) {
                        throw new RuntimeException("Error: " + String.valueOf(this.ret.get("code")) + " - " + String.valueOf(this.ret.get("errmsg")));
                    }
                    MorphiumWriterImpl.this.morphium.firePostUpdateEvent(query.getType(), MorphiumStorageListener.UpdateTypes.PUSH);
                    if (this.callback != null) {
                        this.callback.onOperationSucceeded(AsyncOperationType.PUSH, query, System.currentTimeMillis() - start, null, null, field, value, upsert, multiple);
                    }
                }
                catch (RuntimeException e) {
                    if (this.callback == null) {
                        if (e instanceof RuntimeException) {
                            throw e;
                        }
                        throw new RuntimeException(e);
                    }
                    this.callback.onOperationError(AsyncOperationType.PUSH, query, System.currentTimeMillis() - start, e.getMessage(), e, null, field, value, upsert, multiple);
                }
            }
        };
        return this.submitAndBlockIfNecessary(callback, r);
    }

    public Object marshallIfNecessary(Object value) {
        if (value != null) {
            if (value instanceof Enum) {
                return ((Enum)value).name();
            }
            if (this.morphium.getARHelper().isAnnotationPresentInHierarchy(value.getClass(), Entity.class) || this.morphium.getARHelper().isAnnotationPresentInHierarchy(value.getClass(), Embedded.class)) {
                Map<String, Object> marshall = this.morphium.getMapper().serialize(value);
                marshall.put("class_name", this.morphium.getARHelper().getTypeIdForClass(value.getClass()));
                value = marshall;
            } else if (List.class.isAssignableFrom(value.getClass())) {
                ArrayList<Map<String, Object>> lst = new ArrayList<Map<String, Object>>();
                for (Object o : (List)value) {
                    if (this.morphium.getARHelper().isAnnotationPresentInHierarchy(o.getClass(), Embedded.class) || this.morphium.getARHelper().isAnnotationPresentInHierarchy(o.getClass(), Entity.class)) {
                        Map<String, Object> marshall = this.morphium.getMapper().serialize(o);
                        marshall.put("class_name", this.morphium.getARHelper().getTypeIdForClass(o.getClass()));
                        lst.add(marshall);
                        continue;
                    }
                    lst.add((Map<String, Object>)o);
                }
                value = lst;
            } else if (Map.class.isAssignableFrom(value.getClass())) {
                value = new LinkedHashMap<String, Object>((Map<String, Object>)value);
                Iterator<Map.Entry<String, Object>> iterator = value.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry<String, Object> e;
                    Map.Entry<String, Object> en = e = iterator.next();
                    if (!String.class.isAssignableFrom(e.getKey().getClass())) {
                        throw new IllegalArgumentException("Can't push maps with Key not of type String!");
                    }
                    if (en.getValue() != null) {
                        if (!this.morphium.getARHelper().isAnnotationPresentInHierarchy(en.getValue().getClass(), Entity.class) && !this.morphium.getARHelper().isAnnotationPresentInHierarchy(en.getValue().getClass(), Embedded.class)) continue;
                        Map<String, Object> marshall = this.morphium.getMapper().serialize(en.getValue());
                        marshall.put("class_name", this.morphium.getARHelper().getTypeIdForClass(en.getValue().getClass()));
                        ((Map)value).put(en.getKey(), marshall);
                        continue;
                    }
                    ((Map)value).put(en.getKey(), null);
                }
            }
        }
        return value;
    }

    private Map<String, Object> pushIt(boolean push, boolean upsert, boolean multiple, Class<?> cls, String coll, Map<String, Object> qobj, Map<String, Object> update, Collation collation) {
        this.morphium.firePreUpdateEvent(this.morphium.getARHelper().getRealClass(cls), push ? MorphiumStorageListener.UpdateTypes.PUSH : MorphiumStorageListener.UpdateTypes.PULL);
        Entity en = this.morphium.getARHelper().getAnnotationFromHierarchy(cls, Entity.class);
        if (coll == null) {
            coll = this.morphium.getMapper().getCollectionName(cls);
        }
        this.handleLastChange(cls, update);
        this.handleCreationTimeOnUpsert(cls, coll, qobj, update, upsert);
        WriteConcern wc = this.morphium.getWriteConcernForClass(cls);
        long start = System.currentTimeMillis();
        MongoConnection con = null;
        HashMap<String, Object> result = new HashMap<String, Object>();
        MongoCommand settings = null;
        try {
            this.checkIndexAndCaps(cls, coll, null);
            con = this.morphium.getDriver().getPrimaryConnection(wc);
            settings = (UpdateMongoCommand)((UpdateMongoCommand)((UpdateMongoCommand)new UpdateMongoCommand(con).setColl(coll)).setDb(this.getDbName())).setWriteConcern(wc != null ? wc.asMap() : null);
            ((UpdateMongoCommand)settings).addUpdate(Doc.of(qobj), Doc.of(update), null, upsert, multiple, collation, null, null);
            Map<String, Object> r = ((WriteMongoCommand)settings).execute();
            settings.releaseConnection();
            this.sumUp(r, result);
            if (result.containsKey("ok") && result.get("ok").equals(0.0)) {
                throw new MorphiumDriverException("Error: " + String.valueOf(result.get("code")) + " - " + String.valueOf(result.get("errmsg")));
            }
            this.morphium.inc(StatisticKeys.WRITES);
        }
        catch (MorphiumDriverException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (settings != null) {
                settings.releaseConnection();
            }
        }
        long dur = System.currentTimeMillis() - start;
        this.morphium.getCache().clearCacheIfNecessary(cls);
        this.morphium.firePostUpdateEvent(this.morphium.getARHelper().getRealClass(cls), push ? MorphiumStorageListener.UpdateTypes.PUSH : MorphiumStorageListener.UpdateTypes.PULL);
        return result;
    }

    @Override
    public <T> Map<String, Object> pushPullAll(final MorphiumStorageListener.UpdateTypes type, final Query<T> query, final String f, final List<?> v, final boolean upsert, final boolean multiple, AsyncOperationCallback<T> callback) {
        WriterTask r = new WriterTask(){
            private AsyncOperationCallback<T> callback;
            private Map<String, Object> ret = new HashMap<String, Object>();

            public Map getReturnObject() {
                return this.ret;
            }

            public void setCallback(AsyncOperationCallback cb) {
                this.callback = cb;
            }

            @Override
            public void run() {
                List value = v;
                String field = f;
                Class cls = query.getType();
                String coll = query.getCollectionName();
                MorphiumWriterImpl.this.morphium.firePreUpdateEvent(MorphiumWriterImpl.this.morphium.getARHelper().getRealClass(cls), type);
                long start = System.currentTimeMillis();
                value = value.stream().map(o -> MorphiumWriterImpl.this.marshallIfNecessary(o)).collect(Collectors.toList());
                try {
                    UtilsMap<String, Object> update;
                    Map<String, Object> qobj = query.toQueryObject();
                    if (upsert) {
                        qobj = MorphiumWriterImpl.this.morphium.simplifyQueryObject(qobj);
                    }
                    if (query.getSort() != null) {
                        logger.warn("Sort is not supported for updates!!!");
                    }
                    field = MorphiumWriterImpl.this.morphium.getARHelper().getMongoFieldName(cls, field);
                    switch (type) {
                        case PULL: {
                            update = UtilsMap.of("$pullAll", UtilsMap.of(field, value));
                            break;
                        }
                        case ADD_TO_SET: {
                            UtilsMap set = UtilsMap.of(field, UtilsMap.of("$each", value));
                            update = UtilsMap.of("$addToSet", set);
                            break;
                        }
                        case PUSH: {
                            UtilsMap set = UtilsMap.of(field, UtilsMap.of("$each", value));
                            update = UtilsMap.of("$push", set);
                            break;
                        }
                        default: {
                            throw new IllegalArgumentException("Unsupported update type " + type.name());
                        }
                    }
                    MorphiumWriterImpl.this.handleLastChange(cls, update);
                    MorphiumWriterImpl.this.handleCreationTimeOnUpsert(cls, coll, query.toQueryObject(), update, upsert);
                    WriteConcern wc = MorphiumWriterImpl.this.morphium.getWriteConcernForClass(cls);
                    MongoConnection con = null;
                    MongoCommand settings = null;
                    try {
                        if (upsert) {
                            MorphiumWriterImpl.this.checkIndexAndCaps(cls, coll, this.callback);
                        }
                        con = MorphiumWriterImpl.this.morphium.getDriver().getPrimaryConnection(wc);
                        settings = (UpdateMongoCommand)((UpdateMongoCommand)new UpdateMongoCommand(con).setColl(coll)).setDb(MorphiumWriterImpl.this.getDbName());
                        if (wc != null) {
                            ((WriteMongoCommand)settings).setWriteConcern(wc.asMap());
                        }
                        if (multiple && query.getLimit() > 0) {
                            for (int i = 0; i < query.getLimit(); ++i) {
                                ((UpdateMongoCommand)settings).addUpdate(Doc.of(qobj), Doc.of(update), null, false, false, query.getCollation(), null, null);
                                if (((UpdateMongoCommand)settings).getUpdates().size() < MorphiumWriterImpl.this.morphium.getConfig().getCursorBatchSize()) continue;
                                Map<String, Object> r = ((WriteMongoCommand)settings).execute();
                                MorphiumWriterImpl.this.sumUp(r, this.ret);
                                ((UpdateMongoCommand)settings).getUpdates().clear();
                            }
                        } else {
                            ((UpdateMongoCommand)settings).addUpdate(Doc.of(qobj), Doc.of(update), null, upsert, multiple, query.getCollation(), null, null);
                        }
                        if (settings != null && ((UpdateMongoCommand)settings).getUpdates() != null && ((UpdateMongoCommand)settings).getUpdates().size() != 0) {
                            Map<String, Object> r = ((WriteMongoCommand)settings).execute();
                            MorphiumWriterImpl.this.sumUp(r, this.ret);
                        }
                        settings.releaseConnection();
                        if (this.ret.containsKey("ok") && this.ret.get("ok").equals(0.0)) {
                            throw new MorphiumDriverException("Error: " + String.valueOf(this.ret.get("code")) + " - " + String.valueOf(this.ret.get("errmsg")));
                        }
                        MorphiumWriterImpl.this.morphium.inc(StatisticKeys.WRITES);
                    }
                    catch (MorphiumDriverException e) {
                        throw new RuntimeException(e);
                    }
                    finally {
                        if (settings != null) {
                            settings.releaseConnection();
                        }
                    }
                    long dur = System.currentTimeMillis() - start;
                    MorphiumWriterImpl.this.morphium.getCache().clearCacheIfNecessary(cls);
                    MorphiumWriterImpl.this.morphium.firePostUpdateEvent(query.getType(), MorphiumStorageListener.UpdateTypes.PUSH);
                    if (this.callback != null) {
                        this.callback.onOperationSucceeded(type.equals((Object)MorphiumStorageListener.UpdateTypes.PULL) ? AsyncOperationType.PULL : AsyncOperationType.PUSH, query, System.currentTimeMillis() - start, null, null, field, value, upsert, multiple);
                    }
                }
                catch (RuntimeException e) {
                    if (this.callback == null) {
                        if (e instanceof RuntimeException) {
                            throw e;
                        }
                        throw new RuntimeException(e);
                    }
                    this.callback.onOperationError(type.equals((Object)MorphiumStorageListener.UpdateTypes.PULL) ? AsyncOperationType.PULL : AsyncOperationType.PUSH, query, System.currentTimeMillis() - start, e.getMessage(), e, null, field, value, upsert, multiple);
                }
            }
        };
        return this.submitAndBlockIfNecessary(callback, r);
    }

    @Override
    public <T> void dropCollection(final Class<T> cls, final String collection, AsyncOperationCallback<T> callback) {
        if (!this.morphium.getARHelper().isAnnotationPresentInHierarchy(cls, Entity.class)) {
            throw new RuntimeException("No entity class: " + cls.getName());
        }
        WriterTask r = new WriterTask(){

            public void setCallback(AsyncOperationCallback cb) {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                long start;
                block8: {
                    MorphiumWriterImpl.this.morphium.firePreDrop(cls);
                    start = System.currentTimeMillis();
                    String co = collection;
                    if (co == null) {
                        co = MorphiumWriterImpl.this.morphium.getMapper().getCollectionName(cls);
                    }
                    MongoConnection con = null;
                    MongoCommand settings = null;
                    try {
                        con = MorphiumWriterImpl.this.morphium.getDriver().getPrimaryConnection(null);
                        settings = (DropMongoCommand)((DropMongoCommand)new DropMongoCommand(con).setColl(co)).setDb(MorphiumWriterImpl.this.getDbName());
                        ((WriteMongoCommand)settings).execute();
                    }
                    catch (MorphiumDriverException e) {
                        if (e.getMessage().endsWith("error: 26 - ns not found")) {
                            LoggerFactory.getLogger(MorphiumWriterImpl.class).warn("NS not found: " + MorphiumWriterImpl.this.morphium.getMapper().getCollectionName(cls));
                            break block8;
                        }
                        throw new RuntimeException(e);
                    }
                    finally {
                        if (settings != null) {
                            settings.releaseConnection();
                        }
                    }
                }
                long dur = System.currentTimeMillis() - start;
                MorphiumWriterImpl.this.morphium.firePostDropEvent(cls);
            }
        };
        this.submitAndBlockIfNecessary(callback, r);
    }

    @Override
    public <T> void createIndex(final Class<T> cls, final String collection, final IndexDescription idesc, AsyncOperationCallback<T> callback) {
        WriterTask r = new WriterTask(){

            public void setCallback(AsyncOperationCallback cb) {
            }

            @Override
            public void run() {
                long start;
                block8: {
                    List<String> fields = MorphiumWriterImpl.this.morphium.getARHelper().getFields(cls, new Class[0]);
                    LinkedHashMap<String, Object> idx = new LinkedHashMap<String, Object>();
                    for (Map.Entry<String, Object> es : idesc.getKey().entrySet()) {
                        String k = es.getKey();
                        if (!(k.contains(".") || fields.contains(k) || fields.contains(MorphiumWriterImpl.this.morphium.getARHelper().convertCamelCase(k)))) {
                            throw new IllegalArgumentException("Field unknown for type " + cls.getSimpleName() + ": " + k);
                        }
                        String fn = MorphiumWriterImpl.this.morphium.getARHelper().getMongoFieldName(cls, k);
                        idx.put(fn, es.getValue());
                    }
                    start = System.currentTimeMillis();
                    LinkedHashMap<String, Object> keys = new LinkedHashMap<String, Object>(idx);
                    String coll = collection;
                    if (coll == null) {
                        coll = MorphiumWriterImpl.this.morphium.getMapper().getCollectionName(cls);
                    }
                    MongoConnection con = null;
                    CreateIndexesCommand cmd = null;
                    try {
                        con = MorphiumWriterImpl.this.morphium.getDriver().getPrimaryConnection(null);
                        cmd = new CreateIndexesCommand(con);
                        ((CreateIndexesCommand)cmd.setDb(MorphiumWriterImpl.this.getDbName())).setColl(coll);
                        idesc.setKey(keys);
                        cmd.addIndex(idesc);
                        Map<String, Object> res = cmd.execute();
                        cmd.releaseConnection();
                        cmd = null;
                        if (!res.containsKey("ok") || !res.get("ok").equals(0.0)) break block8;
                        if (((String)res.get("errmsg")).contains("already exists")) {
                            logger.warn("could not create index - already exists");
                            break block8;
                        }
                        throw new MorphiumDriverException((String)res.get("errmsg"));
                    }
                    catch (MorphiumDriverException e) {
                        e.printStackTrace();
                        throw new RuntimeException(e);
                    }
                }
                long dur = System.currentTimeMillis() - start;
            }
        };
        this.submitAndBlockIfNecessary(callback, r);
    }

    @Override
    public int writeBufferCount() {
        return this.executor.getActiveCount();
    }

    @Override
    public void onShutdown(Morphium m) {
        if (this.executor != null) {
            try {
                this.executor.shutdownNow();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public abstract class WT<T>
    implements WriterTask<T> {
        private AsyncOperationCallback<T> callback;

        @Override
        public void setCallback(AsyncOperationCallback cb) {
            this.callback = cb;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void doUpdate(Class cls, T toSet, String coll, String field, Map<String, Object> query, Field f, Map<String, Object> update, WriteConcern wc) {
            long start = System.currentTimeMillis();
            if (coll == null) {
                coll = MorphiumWriterImpl.this.morphium.getMapper().getCollectionName(cls);
            }
            MongoConnection con = null;
            MongoCommand settings = null;
            try {
                MorphiumWriterImpl.this.checkIndexAndCaps(cls, coll, this.callback);
                con = MorphiumWriterImpl.this.morphium.getDriver().getPrimaryConnection(null);
                settings = ((UpdateMongoCommand)((UpdateMongoCommand)new UpdateMongoCommand(con).setColl(coll)).setDb(MorphiumWriterImpl.this.getDbName())).addUpdate(Doc.of(query), Doc.of(update), null, false, false, null, null, null);
                if (wc != null) {
                    ((WriteMongoCommand)settings).setWriteConcern(wc.asMap());
                }
                ((WriteMongoCommand)settings).execute();
                settings.releaseConnection();
                MorphiumWriterImpl.this.morphium.inc(StatisticKeys.WRITES);
                MorphiumWriterImpl.this.handleLastChange(cls, update);
                long dur = System.currentTimeMillis() - start;
                MorphiumWriterImpl.this.morphium.getCache().clearCacheIfNecessary(cls);
                try {
                    if (f != null) {
                        f.set(toSet, null);
                    }
                }
                catch (IllegalAccessException illegalAccessException) {
                    // empty catch block
                }
                MorphiumWriterImpl.this.morphium.firePostUpdateEvent(MorphiumWriterImpl.this.morphium.getARHelper().getRealClass(cls), MorphiumStorageListener.UpdateTypes.UNSET);
                if (this.callback != null) {
                    this.callback.onOperationSucceeded(AsyncOperationType.UNSET, null, System.currentTimeMillis() - start, null, toSet, field);
                }
            }
            catch (Exception e) {
                if (this.callback == null) {
                    if (e instanceof RuntimeException) {
                        throw (RuntimeException)e;
                    }
                    throw new RuntimeException(e);
                }
                this.callback.onOperationError(AsyncOperationType.UNSET, null, System.currentTimeMillis() - start, e.getMessage(), e, toSet, field);
            }
            finally {
                if (settings != null) {
                    settings.releaseConnection();
                }
            }
        }
    }
}

