/*
 * Decompiled with CFR 0.152.
 */
package de.caluga.morphium.messaging;

import de.caluga.morphium.driver.MorphiumDriverException;
import de.caluga.morphium.messaging.MessageListener;
import de.caluga.morphium.messaging.Messaging;
import de.caluga.morphium.messaging.Msg;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StatusInfoListener
implements MessageListener<Msg> {
    private Logger log = LoggerFactory.getLogger(StatusInfoListener.class);
    public static final String messagingThreadpoolstatsKey = "messaging_threadpoolstats";
    public static final String messageListenersbyNameKey = "message_listeners_by_name";
    public static final String globalListenersKey = "global_listeners";
    public static final String morphiumCachestatsKey = "morphium.cachestats";
    public static final String morphiumConfigKey = "morphium.config";
    public static final String morphiumDriverStatsKey = "morphium.driver.stats";
    public static final String morphiumDriverConnections = "morphium.driver.connections";
    public static final String morphiumDriverReplstatKey = "morphium.driver.replicaset_status";

    @Override
    public Msg onMessage(Messaging msg, Msg m) {
        if (m.isAnswer()) {
            return null;
        }
        this.log.info("Preparing status info... " + String.valueOf(m.getMsgId()));
        long tripDur = System.currentTimeMillis() - m.getTimestamp();
        Msg answer = m.createAnswerMsg();
        answer.setMapValue(new HashMap<String, Object>());
        StatusInfoLevel level = StatusInfoLevel.MESSAGING_ONLY;
        if (m.getValue() != null) {
            for (StatusInfoLevel l : StatusInfoLevel.values()) {
                if (!l.name().equals(m.getValue())) continue;
                level = StatusInfoLevel.valueOf(m.getValue());
                break;
            }
        }
        if (level.equals((Object)StatusInfoLevel.ALL) || level.equals((Object)StatusInfoLevel.MESSAGING_ONLY)) {
            if (msg.isMultithreadded()) {
                answer.getMapValue().put(messagingThreadpoolstatsKey, msg.getThreadPoolStats());
            }
            answer.getMapValue().put(messageListenersbyNameKey, msg.getListenerNames());
            answer.getMapValue().put(globalListenersKey, msg.getGlobalListeners());
            answer.getMapValue().put("messaging.changestream", msg.isUseChangeStream());
            answer.getMapValue().put("messaging.multithreadded", msg.isMultithreadded());
            answer.getMapValue().put("messaging.window_size", msg.getWindowSize());
            answer.getMapValue().put("messaging.pause", msg.getPause());
            answer.getMapValue().put("messaging.time_till_recieved", tripDur);
        }
        if (level.equals((Object)StatusInfoLevel.ALL) || level.equals((Object)StatusInfoLevel.MORPHIUM_ONLY)) {
            answer.getMapValue().put(morphiumCachestatsKey, msg.getMorphium().getStatistics());
            answer.getMapValue().put(morphiumConfigKey, msg.getMorphium().getConfig().asProperties());
            answer.getMapValue().put(morphiumDriverStatsKey, msg.getMorphium().getDriver().getDriverStats());
            answer.getMapValue().put(morphiumDriverConnections, msg.getMorphium().getDriver().getNumConnectionsByHost());
            try {
                answer.getMapValue().put(morphiumDriverReplstatKey, msg.getMorphium().getDriver().getReplsetStatus());
            }
            catch (MorphiumDriverException e) {
                answer.getMapValue().put(morphiumDriverReplstatKey, "could not get replicaset status: " + e.getMessage());
            }
        }
        this.log.info(" status info done... " + String.valueOf(m.getMsgId()));
        return answer;
    }

    @Override
    public boolean markAsProcessedBeforeExec() {
        return true;
    }

    public static enum StatusInfoLevel {
        ALL,
        MESSAGING_ONLY,
        MORPHIUM_ONLY,
        PING;

    }

    public static abstract class InternalCommand {
        private String name;

        public InternalCommand(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public abstract void exec(Messaging var1, Msg var2, Object var3);
    }
}

