/*
 * Decompiled with CFR 0.152.
 */
package de.caluga.morphium.driver.inmem;

import de.caluga.morphium.Collation;
import de.caluga.morphium.IndexDescription;
import de.caluga.morphium.Morphium;
import de.caluga.morphium.ObjectMapperImpl;
import de.caluga.morphium.Utils;
import de.caluga.morphium.UtilsMap;
import de.caluga.morphium.aggregation.Aggregator;
import de.caluga.morphium.aggregation.Expr;
import de.caluga.morphium.driver.Doc;
import de.caluga.morphium.driver.DriverTailableIterationCallback;
import de.caluga.morphium.driver.FunctionNotSupportedException;
import de.caluga.morphium.driver.MorphiumCursor;
import de.caluga.morphium.driver.MorphiumDriver;
import de.caluga.morphium.driver.MorphiumDriverException;
import de.caluga.morphium.driver.MorphiumId;
import de.caluga.morphium.driver.MorphiumTransactionContext;
import de.caluga.morphium.driver.ReadPreference;
import de.caluga.morphium.driver.SingleBatchCursor;
import de.caluga.morphium.driver.WriteConcern;
import de.caluga.morphium.driver.bulk.BulkRequest;
import de.caluga.morphium.driver.bulk.BulkRequestContext;
import de.caluga.morphium.driver.bulk.DeleteBulkRequest;
import de.caluga.morphium.driver.bulk.InsertBulkRequest;
import de.caluga.morphium.driver.bulk.UpdateBulkRequest;
import de.caluga.morphium.driver.commands.AbortTransactionCommand;
import de.caluga.morphium.driver.commands.AggregateMongoCommand;
import de.caluga.morphium.driver.commands.ClearCollectionCommand;
import de.caluga.morphium.driver.commands.CollStatsCommand;
import de.caluga.morphium.driver.commands.CommitTransactionCommand;
import de.caluga.morphium.driver.commands.CountMongoCommand;
import de.caluga.morphium.driver.commands.CreateCommand;
import de.caluga.morphium.driver.commands.CreateIndexesCommand;
import de.caluga.morphium.driver.commands.CurrentOpCommand;
import de.caluga.morphium.driver.commands.DbStatsCommand;
import de.caluga.morphium.driver.commands.DeleteMongoCommand;
import de.caluga.morphium.driver.commands.DistinctMongoCommand;
import de.caluga.morphium.driver.commands.DropDatabaseMongoCommand;
import de.caluga.morphium.driver.commands.DropMongoCommand;
import de.caluga.morphium.driver.commands.ExplainCommand;
import de.caluga.morphium.driver.commands.FindAndModifyMongoCommand;
import de.caluga.morphium.driver.commands.FindCommand;
import de.caluga.morphium.driver.commands.GenericCommand;
import de.caluga.morphium.driver.commands.GetMoreMongoCommand;
import de.caluga.morphium.driver.commands.HelloCommand;
import de.caluga.morphium.driver.commands.InsertMongoCommand;
import de.caluga.morphium.driver.commands.KillCursorsCommand;
import de.caluga.morphium.driver.commands.ListCollectionsCommand;
import de.caluga.morphium.driver.commands.ListDatabasesCommand;
import de.caluga.morphium.driver.commands.ListIndexesCommand;
import de.caluga.morphium.driver.commands.MapReduceCommand;
import de.caluga.morphium.driver.commands.MongoCommand;
import de.caluga.morphium.driver.commands.RenameCollectionCommand;
import de.caluga.morphium.driver.commands.ReplicastStatusCommand;
import de.caluga.morphium.driver.commands.ShutdownCommand;
import de.caluga.morphium.driver.commands.StepDownCommand;
import de.caluga.morphium.driver.commands.StoreMongoCommand;
import de.caluga.morphium.driver.commands.UpdateMongoCommand;
import de.caluga.morphium.driver.commands.WatchCommand;
import de.caluga.morphium.driver.commands.auth.CreateRoleAdminCommand;
import de.caluga.morphium.driver.commands.auth.CreateUserAdminCommand;
import de.caluga.morphium.driver.commands.auth.SaslAuthCommand;
import de.caluga.morphium.driver.inmem.InMemAggregator;
import de.caluga.morphium.driver.inmem.InMemDumpContainer;
import de.caluga.morphium.driver.inmem.InMemTransactionContext;
import de.caluga.morphium.driver.inmem.QueryHelper;
import de.caluga.morphium.driver.wire.AtomicDecimal;
import de.caluga.morphium.driver.wire.HelloResult;
import de.caluga.morphium.driver.wire.MongoConnection;
import de.caluga.morphium.driver.wireprotocol.OpMsg;
import de.caluga.morphium.objectmapping.MorphiumObjectMapper;
import de.caluga.morphium.objectmapping.MorphiumTypeMapper;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.lang.invoke.LambdaMetafactory;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Predicate;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.net.ssl.SSLContext;
import org.bson.types.ObjectId;
import org.json.simple.parser.ParseException;
import org.openjdk.jol.vm.VM;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InMemoryDriver
implements MorphiumDriver,
MongoConnection {
    private final Logger log = LoggerFactory.getLogger(InMemoryDriver.class);
    public static final String driverName = "InMemDriver";
    private final Map<String, Map<String, List<Map<String, Object>>>> database = new ConcurrentHashMap<String, Map<String, List<Map<String, Object>>>>();
    private int idleSleepTime = 20;
    private final Map<String, Map<String, List<Map<String, Object>>>> indicesByDbCollection = new ConcurrentHashMap<String, Map<String, List<Map<String, Object>>>>();
    private final Map<String, Map<String, Map<String, Map<Integer, List<Map<String, Object>>>>>> indexDataByDBCollection = new ConcurrentHashMap<String, Map<String, Map<String, Map<Integer, List<Map<String, Object>>>>>>();
    private final ThreadLocal<InMemTransactionContext> currentTransaction = new ThreadLocal();
    private final AtomicLong txn = new AtomicLong();
    private final Map<String, List<DriverTailableIterationCallback>> watchersByDb = new ConcurrentHashMap<String, List<DriverTailableIterationCallback>>();
    private final Map<String, Map<String, Map<String, Integer>>> cappedCollections = new ConcurrentHashMap<String, Map<String, Map<String, Integer>>>();
    private final List<Object> monitors = new CopyOnWriteArrayList<Object>();
    private List<Runnable> eventQueue = new CopyOnWriteArrayList<Runnable>();
    private final List<Map<String, Object>> commandResults = new Vector<Map<String, Object>>();
    private final Map<String, Class<? extends MongoCommand>> commandsCache = new HashMap<String, Class<? extends MongoCommand>>();
    private final AtomicInteger commandNumber = new AtomicInteger(0);
    private final Map<MorphiumDriver.DriverStatsKey, AtomicDecimal> stats = new ConcurrentHashMap<MorphiumDriver.DriverStatsKey, AtomicDecimal>();
    private final Map<Long, FindCommand> cursors = new ConcurrentHashMap<Long, FindCommand>();
    private ScheduledThreadPoolExecutor exec = new ScheduledThreadPoolExecutor(2);
    private boolean running = true;
    private int expireCheck = 45000;
    private ScheduledFuture<?> expire;
    private String replicaSetName;

    public Map<String, List<Map<String, Object>>> getDatabase(String dbn) {
        return this.database.get(dbn);
    }

    @Override
    public <T, R> Aggregator<T, R> createAggregator(Morphium morphium, Class<? extends T> type, Class<? extends R> resultType) {
        return new InMemAggregator<T, R>(morphium, type, resultType);
    }

    public void setDatabase(String dbn, Map<String, List<Map<String, Object>>> db) {
        if (db != null) {
            this.database.put(dbn, db);
        }
    }

    public void restore(InputStream in) throws IOException, ParseException {
        GZIPInputStream gzin = new GZIPInputStream(in);
        BufferedInputStream bin = new BufferedInputStream(gzin);
        BufferedReader br = new BufferedReader(new InputStreamReader(bin));
        String l = null;
        StringBuilder b = new StringBuilder();
        while ((l = br.readLine()) != null) {
            b.append(l);
        }
        br.close();
        ObjectMapperImpl mapper = new ObjectMapperImpl();
        MorphiumTypeMapper<ObjectId> typeMapper = this.getObjectIdTypeMapper();
        mapper.registerCustomMapperFor(ObjectId.class, typeMapper);
        this.log.info("Read in json: " + String.valueOf(b));
        InMemDumpContainer cnt = mapper.deserialize(InMemDumpContainer.class, b.toString());
        this.log.info("Restoring DB " + cnt.getDb() + " dump from " + String.valueOf(new Date(cnt.getCreated())));
        this.setDatabase(cnt.getDb(), cnt.getData());
    }

    public void restoreFromFile(File f) throws IOException, ParseException {
        this.restore(new FileInputStream(f));
    }

    public void dumpToFile(Morphium m, String db, File f) throws IOException {
        this.dump(m, db, new FileOutputStream(f));
    }

    public void dump(Morphium m, String db, OutputStream out) throws IOException {
        MorphiumObjectMapper mapper = m.getMapper();
        MorphiumTypeMapper<ObjectId> typeMapper = this.getObjectIdTypeMapper();
        mapper.registerCustomMapperFor(ObjectId.class, typeMapper);
        GZIPOutputStream gzip = new GZIPOutputStream(out);
        InMemDumpContainer d = new InMemDumpContainer();
        d.setCreated(System.currentTimeMillis());
        d.setData(this.getDatabase(db));
        d.setDb(db);
        Map<String, Object> ser = mapper.serialize(d);
        OutputStreamWriter wr = new OutputStreamWriter(gzip);
        Utils.writeJson(ser, wr);
        wr.flush();
        gzip.finish();
        gzip.flush();
        out.flush();
        gzip.close();
    }

    private MorphiumTypeMapper<ObjectId> getObjectIdTypeMapper() {
        return new MorphiumTypeMapper<ObjectId>(){

            @Override
            public Object marshall(ObjectId o) {
                ConcurrentHashMap<String, String> m = new ConcurrentHashMap<String, String>();
                m.put("value", o.toHexString());
                m.put("class_name", o.getClass().getName());
                return m;
            }

            @Override
            public ObjectId unmarshall(Object d) {
                return new ObjectId(((Map)d).get("value").toString());
            }
        };
    }

    @Override
    public List<String> listDatabases() {
        return new ArrayList<String>(this.database.keySet());
    }

    @Override
    public List<String> listCollections(String db, String pattern) {
        HashSet<String> collections = new HashSet<String>();
        if (db.equals("1")) {
            for (String k : this.database.keySet()) {
                collections.addAll(this.database.get(k).keySet());
            }
        } else if (this.database.containsKey(db)) {
            collections.addAll(this.database.get(db).keySet());
        } else {
            return new ArrayList<String>();
        }
        ArrayList<String> ret = new ArrayList<String>();
        if (pattern == null) {
            ret.addAll(collections);
        } else {
            for (String col : collections) {
                if (!col.matches(pattern)) continue;
                ret.add(col);
            }
        }
        return ret;
    }

    @Override
    public String getReplicaSetName() {
        return this.replicaSetName;
    }

    @Override
    public void setReplicaSetName(String replicaSetName) {
        this.replicaSetName = replicaSetName;
    }

    public void resetData() {
        this.database.clear();
        this.indexDataByDBCollection.clear();
        this.indicesByDbCollection.clear();
        this.cappedCollections.clear();
        for (Object o : this.monitors) {
            o.notifyAll();
        }
        this.monitors.clear();
        this.watchersByDb.clear();
        this.eventQueue.clear();
        this.cursors.clear();
        this.commandResults.clear();
        this.currentTransaction.remove();
    }

    public void setCredentials(String db, String login, char[] pwd) {
    }

    @Override
    public void watch(WatchCommand settings) throws MorphiumDriverException {
        this.watch(settings.getDb(), settings.getColl(), settings.getMaxTimeMS(), settings.getFullDocument().equals((Object)WatchCommand.FullDocumentEnum.updateLookup), settings.getPipeline(), settings.getCb());
    }

    @Override
    public List<Map<String, Object>> readAnswerFor(int queryId) throws MorphiumDriverException {
        this.log.info("Reading answer for id " + queryId);
        this.stats.get((Object)MorphiumDriver.DriverStatsKey.REPLY_PROCESSED).incrementAndGet();
        Map<String, Object> data = this.commandResults.remove(0);
        if (data.containsKey("results")) {
            return (List)data.get("results");
        }
        if (data.containsKey("cursor")) {
            Map cursor = (Map)data.get("cursor");
            if (cursor.containsKey("firstBatch")) {
                return (List)cursor.get("firstBatch");
            }
            if (cursor.containsKey("nextBatch")) {
                return (List)cursor.get("nextBatch");
            }
        }
        return null;
    }

    @Override
    public MorphiumCursor getAnswerFor(int queryId, int batchsize) throws MorphiumDriverException {
        this.stats.get((Object)MorphiumDriver.DriverStatsKey.REPLY_PROCESSED).incrementAndGet();
        Map<String, Object> data = this.commandResults.remove(0);
        List batch = new ArrayList();
        if (data.containsKey("results")) {
            batch = (List)data.get("results");
        } else if (data.containsKey("cursor")) {
            Map cursor = (Map)data.get("cursor");
            if (cursor.containsKey("firstBatch")) {
                batch = (List)cursor.get("firstBatch");
            } else if (cursor.containsKey("nextBatch")) {
                batch = (List)cursor.get("nextBatch");
            }
        }
        return new SingleBatchCursor(batch);
    }

    @Override
    public List<Map<String, Object>> readAnswerFor(MorphiumCursor crs) throws MorphiumDriverException {
        return crs.getBatch();
    }

    @Override
    public int sendCommand(MongoCommand cmd) throws MorphiumDriverException {
        this.stats.get((Object)MorphiumDriver.DriverStatsKey.MSG_SENT).incrementAndGet();
        if (cmd.asMap().get("$db") == null) {
            throw new IllegalArgumentException("DB cannot be null");
        }
        try {
            try {
                Method method = this.getClass().getDeclaredMethod("runCommand", cmd.getClass());
                Object o = method.invoke((Object)this, cmd);
                this.stats.get((Object)MorphiumDriver.DriverStatsKey.REPLY_RECEIVED);
                if (o instanceof Integer) {
                    return (Integer)o;
                }
            }
            catch (NoSuchMethodException ex) {
                this.log.error("No method for command " + cmd.getClass().getSimpleName() + " - " + cmd.getCommandName());
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return 0;
    }

    public int runCommand(CreateUserAdminCommand cmd) {
        return 0;
    }

    public int runCommand(CreateRoleAdminCommand cmd) {
        return 0;
    }

    public int runCommand(SaslAuthCommand cmd) {
        return 0;
    }

    public int runCommand(ExplainCommand cmd) {
        int ret = this.commandNumber.incrementAndGet();
        this.commandResults.add(this.prepareResult(Doc.of("ok", (Object)0, "errmsg", "no explain possible yet - in Memory!")));
        return ret;
    }

    public int runCommand(GenericCommand cmd) {
        this.log.info("Trying to handle generic Command");
        Map<String, Object> cmdMap = cmd.asMap();
        String commandName = (String)cmdMap.keySet().stream().findFirst().get();
        Class<? extends MongoCommand> commandClass = this.commandsCache.get(commandName);
        if (commandClass == null) {
            throw new IllegalArgumentException("Unknown command " + commandName);
        }
        try {
            Constructor<? extends MongoCommand> declaredConstructor = commandClass.getDeclaredConstructor(MongoConnection.class);
            declaredConstructor.setAccessible(true);
            MongoCommand mongoCommand = declaredConstructor.newInstance(this);
            mongoCommand.fromMap(cmdMap);
            try {
                Method method = this.getClass().getDeclaredMethod("runCommand", commandClass);
                Object o = method.invoke((Object)this, mongoCommand);
                if (o instanceof Integer) {
                    return (Integer)o;
                }
                this.log.error("THIS CANNOT HAPPEN!");
                return 0;
            }
            catch (NoSuchMethodException ex) {
                this.log.error("No method for command " + commandClass.getSimpleName() + " - " + mongoCommand.getCommandName());
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        int ret = this.commandNumber.incrementAndGet();
        this.commandResults.add(this.prepareResult(Doc.of("ok", (Object)0, "errmsg", "could not execute command inMemory")));
        return ret;
    }

    private int runCommand(StepDownCommand cmd) {
        int ret = this.commandNumber.incrementAndGet();
        this.commandResults.add(this.prepareResult(Doc.of("ok", (Object)0, "errmsg", "no replicaset - in Memory!")));
        return ret;
    }

    private int runCommand(AbortTransactionCommand cmd) {
        this.abortTransaction();
        int ret = this.commandNumber.incrementAndGet();
        this.commandResults.add(this.prepareResult(Doc.of("ok", (Object)1.0, "msg", "aborted")));
        return ret;
    }

    private int runCommand(CommitTransactionCommand cmd) {
        this.commitTransaction();
        int ret = this.commandNumber.incrementAndGet();
        this.commandResults.add(this.prepareResult(Doc.of("ok", (Object)1.0, "msg", "committed")));
        return ret;
    }

    private int runCommand(UpdateMongoCommand cmd) throws MorphiumDriverException {
        int ret = this.commandNumber.incrementAndGet();
        HashMap<String, Object> stats = new HashMap<String, Object>();
        for (Map<String, Object> update : cmd.getUpdates()) {
            boolean multi = false;
            if (update.containsKey("multi")) {
                multi = Boolean.TRUE.equals(update.get("multi"));
            }
            boolean upsert = false;
            if (update.containsKey("upsert")) {
                upsert = Boolean.TRUE.equals(update.get("upsert"));
            }
            Map<String, Object> res = this.update(cmd.getDb(), cmd.getColl(), (Map)update.get("q"), null, (Map)update.get("u"), multi, upsert, null, cmd.getWriteConcern());
            for (Map.Entry<String, Object> e : res.entrySet()) {
                if (!stats.containsKey(e.getKey())) {
                    stats.put(e.getKey(), (Integer)e.getValue());
                    continue;
                }
                stats.put(e.getKey(), (Integer)e.getValue() + (Integer)stats.get(e.getKey()));
            }
        }
        stats.put("n", stats.get("inserted"));
        this.commandResults.add(this.prepareResult(stats));
        return ret;
    }

    private int runCommand(WatchCommand cmd) throws MorphiumDriverException {
        int ret = this.commandNumber.incrementAndGet();
        this.watch(cmd);
        return ret;
    }

    private int runCommand(StoreMongoCommand cmd) throws MorphiumDriverException {
        int ret = this.commandNumber.incrementAndGet();
        Map<String, Integer> stats = this.store(cmd.getDb(), cmd.getColl(), cmd.getDocs(), null);
        this.commandResults.add(this.prepareResult(Doc.of("ok", (Object)1.0, "stats", stats)));
        return ret;
    }

    private int runCommand(ShutdownCommand cmd) {
        int ret = this.commandNumber.incrementAndGet();
        this.commandResults.add(this.prepareResult(Doc.of("ok", (Object)0.0, "errmsg", "shutdown in memory not supported")));
        return ret;
    }

    private int runCommand(ReplicastStatusCommand cmd) {
        int ret = this.commandNumber.incrementAndGet();
        this.commandResults.add(this.prepareResult(Doc.of("ok", (Object)0.0, "errmsg", "no replicaset")));
        return ret;
    }

    private int runCommand(RenameCollectionCommand cmd) {
        String target = cmd.getTo();
        String origin = cmd.getColl();
        List<Map<String, Object>> col = this.database.get(cmd.getDb()).remove(origin);
        this.database.get(cmd.getDb()).put(target, col);
        int ret = this.commandNumber.incrementAndGet();
        this.commandResults.add(this.prepareResult(Doc.of("ok", (Object)1.0, "msg", "renamed " + origin + " to " + target)));
        return ret;
    }

    private int runCommand(MapReduceCommand cmd) {
        int ret = this.commandNumber.incrementAndGet();
        this.commandResults.add(this.prepareResult(Doc.of("ok", (Object)0.0, "errmsg", "MapReduce not possible inMem (yet)")));
        return ret;
    }

    private int runCommand(ListIndexesCommand cmd) {
        int ret = this.commandNumber.incrementAndGet();
        Map<String, List<Map<String, Object>>> indexesForDB = this.indicesByDbCollection.get(cmd.getDb());
        if (indexesForDB == null) {
            this.commandResults.add(this.prepareResult(Doc.of("cursor", Doc.of("firstBatch", List.of()), "ok", (Object)1.0, "ns", cmd.getDb() + "." + cmd.getColl(), "id", (Object)0)));
            return ret;
        }
        List<Map<String, Object>> idx = indexesForDB.get(cmd.getColl());
        ArrayList indices = new ArrayList();
        if (idx != null) {
            for (Map<String, Object> i : idx) {
                HashMap<String, Object> index = new HashMap<String, Object>();
                index.put("v", 2.0);
                for (Map.Entry<String, Object> e : i.entrySet()) {
                    if (e.getKey().startsWith("$")) continue;
                    index.putIfAbsent("key", Doc.of());
                    ((Doc)index.get("key")).add(e.getKey(), e.getValue());
                }
                Map opt = (Map)i.get("$options");
                if (opt != null && opt.get("name") != null) {
                    index.put("name", opt.get("name"));
                } else {
                    index.put("name", "unknown");
                }
                if (opt != null && opt.get("unique") != null) {
                    index.put("unique", opt.get("unique"));
                }
                if (opt != null && opt.get("sparse") != null) {
                    index.put("sparse", opt.get("sparse"));
                }
                if (opt != null && opt.get("expireAfterSeconds") != null) {
                    index.put("expireAfterSeconds", opt.get("expireAfterSeconds"));
                }
                if (opt != null && opt.get("bachground") != null) {
                    index.put("background", opt.get("background"));
                }
                if (opt != null && opt.get("background") != null) {
                    index.put("background", opt.get("background"));
                }
                if (opt != null && opt.get("hidden") != null) {
                    index.put("hidden", opt.get("hidden"));
                }
                indices.add(index);
            }
        }
        this.commandResults.add(this.prepareResult(Doc.of("cursor", Doc.of("firstBatch", indices), "ok", (Object)1.0, "ns", cmd.getDb() + "." + cmd.getColl(), "id", (Object)0)));
        return ret;
    }

    private int runCommand(ListDatabasesCommand cmd) {
        int ret = this.commandNumber.incrementAndGet();
        HashMap<String, Object> data = new HashMap<String, Object>();
        ArrayList<Doc> dbList = new ArrayList<Doc>();
        data.put("databases", dbList);
        int sum = 0;
        for (String k : this.database.keySet()) {
            sum += this.database.get(k).size();
            Doc db = Doc.of("name", k, "sizeOnDisk", (Object)0, "entries", (Object)this.database.get(k).size(), "empty", (Object)this.database.get(k).isEmpty());
            dbList.add(db);
        }
        data.put("ok", 1.0);
        data.put("totalSize", 0);
        data.put("totalSizeMb", 0);
        data.put("totalEntries", sum);
        this.log.info("Storing listDb Result for id: " + ret);
        this.commandResults.add(this.prepareResult(data));
        return ret;
    }

    private int runCommand(ListCollectionsCommand cmd) {
        int ret = this.commandNumber.incrementAndGet();
        Map<String, Object> m = this.prepareResult();
        ArrayList<Map<String, Object>> cursorData = new ArrayList<Map<String, Object>>();
        if (!this.database.containsKey(cmd.getDb())) {
            m.put("ok", 0.0);
            m.put("errmsg", "no such database");
            this.commandResults.add(m);
            return ret;
        }
        for (String coll : this.database.get(cmd.getDb()).keySet()) {
            cursorData.add(Doc.of("name", coll, "type", "collection", "options", new Doc(), "info", Doc.of("readonly", (Object)false, "UUID", UUID.randomUUID())).add("idIndex", Doc.of("v", (Object)2.0, "key", Doc.of("_id", (Object)1), "name", "_id_1", "ns", cmd.getDb() + "." + coll)));
        }
        this.addCursor(cmd.getDb(), "$cmd.listCollections", m, cursorData);
        this.commandResults.add(m);
        return ret;
    }

    private int runCommand(KillCursorsCommand cmd) {
        this.log.info("Killing cursors");
        int ret = this.commandNumber.incrementAndGet();
        for (Long id : cmd.getCursors()) {
            this.cursors.remove(id);
        }
        this.commandResults.add(this.prepareResult());
        return ret;
    }

    private int runCommand(InsertMongoCommand cmd) throws MorphiumDriverException {
        int ret = this.commandNumber.incrementAndGet();
        List<Map<String, Object>> writeErrors = this.insert(cmd.getDb(), cmd.getColl(), cmd.getDocuments(), cmd.getWriteConcern());
        Map<String, Object> m = this.prepareResult();
        m.put("n", cmd.getDocuments().size() - writeErrors.size());
        if (writeErrors.size() != 0) {
            m.put("writeErrors", writeErrors);
        }
        this.commandResults.add(m);
        return ret;
    }

    private int runCommand(FindCommand cmd) throws MorphiumDriverException {
        int ret = this.commandNumber.incrementAndGet();
        final List<Map<String, Object>> result = this.runFind(cmd);
        long cursorId = 0L;
        if (cmd.isTailable() != null && cmd.isTailable().booleanValue()) {
            cursorId = ret;
            this.cursors.put(cursorId, cmd);
            if (result == null || result.isEmpty()) {
                this.watch(cmd.getDb(), cmd.getColl(), cmd.getMaxTimeMS(), true, Arrays.asList(Doc.of("$match", cmd.getFilter())), new DriverTailableIterationCallback(){

                    @Override
                    public void incomingData(Map<String, Object> data, long dur) {
                        result.add(data);
                    }

                    @Override
                    public boolean isContinued() {
                        return false;
                    }
                });
            }
        }
        Map<String, Object> m = this.prepareResult();
        this.addCursor(cmd.getDb(), cmd.getColl(), m, result);
        if (cursorId != 0L) {
            ((Map)m.get("cursor")).put("id", cursorId);
        }
        this.commandResults.add(m);
        return ret;
    }

    private List<Map<String, Object>> runFind(FindCommand cmd) throws MorphiumDriverException {
        Doc filter;
        int limit = 0;
        if (cmd.getLimit() != null) {
            limit = cmd.getLimit();
        }
        int skip = 0;
        if (cmd.getSkip() != null) {
            skip = cmd.getSkip();
        }
        if ((filter = cmd.getFilter()) == null) {
            filter = Doc.of();
        }
        List<Map<String, Object>> result = this.find(cmd.getDb(), cmd.getColl(), filter, cmd.getSort(), cmd.getProjection(), cmd.getCollation(), skip, limit, false);
        return result;
    }

    private int runCommand(GetMoreMongoCommand cmd) throws MorphiumDriverException {
        int ret = this.commandNumber.incrementAndGet();
        Map<String, Object> m = this.prepareResult();
        m.put("ok", 0);
        if (this.cursors.containsKey(cmd.getCursorId())) {
            FindCommand fnd = this.cursors.get(cmd.getCursorId());
            final ArrayList result = new ArrayList();
            if (result == null || result.isEmpty()) {
                this.watch(fnd.getDb(), fnd.getColl(), fnd.getMaxTimeMS(), true, Arrays.asList(Doc.of("$match", fnd.getFilter())), new DriverTailableIterationCallback(){

                    @Override
                    public void incomingData(Map<String, Object> data, long dur) {
                        result.add((Map)data.get("fullDocument"));
                    }

                    @Override
                    public boolean isContinued() {
                        return false;
                    }
                });
            }
            m.put("cursor", Doc.of("nextBatch", result, "ns", cmd.getDb() + "." + cmd.getColl(), "id", (Object)cmd.getCursorId()));
        }
        this.commandResults.add(m);
        return ret;
    }

    private int runCommand(FindAndModifyMongoCommand cmd) throws MorphiumDriverException {
        int ret = this.commandNumber.incrementAndGet();
        if (cmd.isRemove()) {
            List<Map<String, Object>> list = this.find(cmd.getDb(), cmd.getColl(), cmd.getQuery(), cmd.getSort(), null, 0, 1);
            Map<String, Object> res = this.delete(cmd.getDb(), cmd.getColl(), Doc.of("_id", list.get(0).get("_id")), null, false, null, null);
            this.commandResults.add(this.prepareResult(Doc.of("value", list.get(0))));
        } else {
            Map<String, Object> res = this.findAndOneAndUpdate(cmd.getDb(), cmd.getColl(), cmd.getQuery(), cmd.getUpdate(), cmd.getSort(), cmd.getCollation());
            this.commandResults.add(this.prepareResult(Doc.of("value", res)));
        }
        return ret;
    }

    private int runCommand(DropMongoCommand cmd) {
        int ret = this.commandNumber.incrementAndGet();
        this.drop(cmd.getDb(), cmd.getColl(), null);
        this.commandResults.add(this.prepareResult(Doc.of("ok", (Object)1.0, "msg", "dropped collection " + cmd.getColl())));
        try {
            Thread.sleep(200L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return ret;
    }

    private int runCommand(DropDatabaseMongoCommand cmd) {
        int ret = this.commandNumber.incrementAndGet();
        this.drop(cmd.getDb(), null);
        this.commandResults.add(this.prepareResult(Doc.of("ok", (Object)1.0, "msg", "dropped database " + cmd.getDb())));
        return ret;
    }

    private int runCommand(DistinctMongoCommand cmd) throws MorphiumDriverException {
        int ret = this.commandNumber.incrementAndGet();
        List<Object> distinctResult = this.distinct(cmd.getDb(), cmd.getColl(), cmd.getKey(), cmd.getQuery(), cmd.getCollation());
        Map<String, Object> m = this.prepareResult();
        m.put("values", distinctResult);
        this.commandResults.add(m);
        return ret;
    }

    private int runCommand(DeleteMongoCommand cmd) throws MorphiumDriverException {
        int ret = this.commandNumber.incrementAndGet();
        for (Doc del : cmd.getDeletes()) {
            this.delete(cmd.getDb(), cmd.getColl(), (Map)del.get("q"), null, true, null, null);
        }
        this.commandResults.add(this.prepareResult());
        return ret;
    }

    private int runCommand(DbStatsCommand cmd) {
        int ret = this.commandNumber.incrementAndGet();
        Map<String, Object> m = this.prepareResult();
        m.put("databases", this.database.size());
        this.commandResults.add(m);
        return ret;
    }

    private int runCommand(CurrentOpCommand cmd) {
        int ret = this.commandNumber.incrementAndGet();
        Map<String, Object> m = this.prepareResult();
        m.put("ok", 0.0);
        m.put("errmsg", "no running ops in memory");
        this.commandResults.add(m);
        return ret;
    }

    private int runCommand(CreateIndexesCommand cmd) throws MorphiumDriverException {
        int ret = this.commandNumber.incrementAndGet();
        for (Map<String, Object> idx : cmd.getIndexes()) {
            IndexDescription descr = IndexDescription.fromMap(idx);
            this.createIndex(cmd.getDb(), cmd.getColl(), (Map)idx.get("key"), idx);
        }
        this.commandResults.add(this.prepareResult());
        return ret;
    }

    private int runCommand(CreateCommand cmd) {
        int ret = this.commandNumber.incrementAndGet();
        if (cmd.getCapped() != null && cmd.getCapped().booleanValue()) {
            this.cappedCollections.putIfAbsent(cmd.getDb(), new HashMap());
            this.cappedCollections.get(cmd.getDb()).putIfAbsent(cmd.getColl(), new HashMap());
            this.cappedCollections.get(cmd.getDb()).get(cmd.getColl()).put("size", cmd.getSize());
            this.cappedCollections.get(cmd.getDb()).get(cmd.getColl()).put("max", cmd.getMax());
        }
        if (cmd.getTimeseries() != null) {
            this.log.warn("Timeseries collections not supported in memory");
        }
        if (cmd.getPipeline() != null) {
            this.log.warn("pipeline not supported in memory");
        }
        this.database.putIfAbsent(cmd.getDb(), new ConcurrentHashMap());
        if (this.database.get(cmd.getDb()).containsKey(cmd.getColl())) {
            this.log.warn("Collection already exists...");
        } else {
            this.database.get(cmd.getDb()).put(cmd.getColl(), new ArrayList());
        }
        Map<String, Object> m = this.prepareResult();
        this.addCursor(cmd.getDb(), cmd.getColl(), m, Arrays.asList(Doc.of()));
        this.commandResults.add(m);
        return ret;
    }

    private int runCommand(CountMongoCommand cmd) throws MorphiumDriverException {
        int ret = this.commandNumber.incrementAndGet();
        Map<String, Object> m = this.prepareResult();
        int cnt = this.find(cmd.getDb(), cmd.getColl(), cmd.getQuery(), null, null, 0, 0).size();
        m.put("n", cnt);
        m.put("count", cnt);
        this.commandResults.add(m);
        return ret;
    }

    private int runCommand(CollStatsCommand cmd) {
        int ret = this.commandNumber.incrementAndGet();
        Map<String, Object> m = this.prepareResult();
        m.put("ns", cmd.getDb() + "." + cmd.getColl());
        long size = VM.current().sizeOf(this.database.get(cmd.getDb()).get(cmd.getColl()));
        m.put("size", size);
        m.put("storageSize", 0);
        List<Map<String, Object>> indexes = this.getIndexes(cmd.getDb(), cmd.getColl());
        m.put("nindexes", indexes.size());
        Doc indexDetails = Doc.of();
        Doc indexSizes = Doc.of();
        long totalSize = size;
        for (Map<String, Object> idx : indexes) {
            String idxName = (String)((Map)idx.get("$options")).get("name");
            indexDetails.put(idxName, idx);
            long sz = VM.current().sizeOf(this.indexDataByDBCollection.get(cmd.getDb()).get(cmd.getColl())) + VM.current().sizeOf(idx);
            indexSizes.put(idxName, sz);
            totalSize += sz;
        }
        m.put("totalSize", totalSize);
        m.put("indexDetails", indexDetails);
        m.put("indexSizes", indexSizes);
        this.commandResults.add(m);
        return ret;
    }

    private int runCommand(ClearCollectionCommand cmd) {
        this.database.get(cmd.getDb()).get(cmd.getColl()).clear();
        int ret = this.commandNumber.incrementAndGet();
        this.commandResults.add(this.prepareResult(Doc.of("ok", (Object)1.0)));
        return ret;
    }

    private int runCommand(AggregateMongoCommand cmd) {
        throw new IllegalArgumentException("pleas use morphium for aggregation in Memory!");
    }

    private int runCommand(MongoCommand cmd) {
        throw new IllegalArgumentException("Unhandled command " + cmd.getCommandName() + " class: " + cmd.getClass().getSimpleName());
    }

    private int runCommand(HelloCommand cmd) {
        this.log.info("Hello Command incoming");
        int ret = this.commandNumber.incrementAndGet();
        Map<String, Object> m = this.addCursor(cmd.getDb(), cmd.getColl(), this.prepareResult(), Arrays.asList(Doc.of("helloOk", (Object)true, "isWritablePrimary", (Object)true, "maxBsonObjectSize", (Object)0x8000000, "msg", "InMemDriver - ok")));
        this.commandResults.add(m);
        return ret;
    }

    private Map<String, Object> addCursor(String db, String coll, Map<String, Object> result, List<Map<String, Object>> data) {
        result.put("cursor", Doc.of("firstBatch", data, "ns", db + "." + coll, "id", (Object)0));
        return result;
    }

    private Map<String, Object> prepareResult() {
        return this.prepareResult(Doc.of());
    }

    private Map<String, Object> prepareResult(Map<String, Object> result) {
        if (!result.containsKey("ok")) {
            result.put("ok", 1.0);
        }
        result.put("$clusterTime", Doc.of("clusterTime", (Object)System.currentTimeMillis(), "signature", Doc.of("hash", new byte[20], "keyId", (Object)0)));
        result.put("operationTime", System.currentTimeMillis());
        return result;
    }

    @Override
    public MongoConnection getReadConnection(ReadPreference rp) {
        this.stats.get((Object)MorphiumDriver.DriverStatsKey.CONNECTIONS_BORROWED).incrementAndGet();
        return this;
    }

    @Override
    public MongoConnection getPrimaryConnection(WriteConcern wc) {
        this.stats.get((Object)MorphiumDriver.DriverStatsKey.CONNECTIONS_BORROWED).incrementAndGet();
        return this;
    }

    @Override
    public void releaseConnection(MongoConnection con) {
    }

    @Override
    public void closeConnection(MongoConnection con) {
    }

    @Override
    public String getName() {
        return driverName;
    }

    @Override
    public int getMaxBsonObjectSize() {
        return Integer.MAX_VALUE;
    }

    @Override
    public void setMaxBsonObjectSize(int maxBsonObjectSize) {
    }

    @Override
    public int getMaxMessageSize() {
        return Integer.MAX_VALUE;
    }

    @Override
    public void setMaxMessageSize(int maxMessageSize) {
    }

    @Override
    public int getMaxWriteBatchSize() {
        return Integer.MAX_VALUE;
    }

    @Override
    public void setMaxWriteBatchSize(int maxWriteBatchSize) {
    }

    @Override
    public boolean isReplicaSet() {
        return false;
    }

    @Override
    public void setReplicaSet(boolean replicaSet) {
    }

    @Override
    public boolean getDefaultJ() {
        return false;
    }

    @Override
    public int getDefaultWriteTimeout() {
        return 0;
    }

    @Override
    public void setDefaultWriteTimeout(int wt) {
    }

    @Override
    public void setHostSeed(String ... host) {
    }

    @Override
    public void setConnectionUrl(String connectionUrl) {
    }

    /*
     * Exception decompiling
     */
    @Override
    public void connect() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void scheduleExpire() {
        this.expire = this.exec.scheduleWithFixedDelay(() -> {
            try {
                for (String db : this.database.keySet()) {
                    for (String coll : this.database.get(db).keySet()) {
                        List<Map<String, Object>> idx = this.getIndexes(db, coll);
                        for (Map<String, Object> i : idx) {
                            Map options = (Map)i.get("$options");
                            if (options == null || !options.containsKey("expireAfterSeconds")) continue;
                            HashMap<String, Object> k = new HashMap<String, Object>(i);
                            k.remove("$options");
                            String[] keys = k.keySet().toArray(new String[0]);
                            if (keys.length > 1) {
                                this.log.error("Too many keys for expire-index!!!");
                                continue;
                            }
                            try {
                                List<Map<String, Object>> candidates = this.find(db, coll, Doc.of(keys[0], Doc.of("$lte", new Date(System.currentTimeMillis() - (long)((Integer)options.get("expireAfterSeconds") * 1000)))), null, null, null, 0, 0, true);
                                for (Map<String, Object> o : candidates) {
                                    if (!o.containsKey(keys[0])) continue;
                                    this.getCollection(db, coll).remove(o);
                                }
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }, 100L, this.expireCheck, TimeUnit.MILLISECONDS);
    }

    public int getExpireCheck() {
        return this.expireCheck;
    }

    public InMemoryDriver setExpireCheck(int expireCheck) {
        this.expireCheck = expireCheck;
        if (this.expire != null) {
            this.expire.cancel(true);
        }
        this.scheduleExpire();
        return this;
    }

    @Override
    public void connect(String replicasetName) {
        this.connect();
    }

    @Override
    public boolean isConnected() {
        return true;
    }

    @Override
    public String getConnectedTo() {
        return "inMem:0000";
    }

    @Override
    public String getConnectedToHost() {
        return "inMem";
    }

    @Override
    public int getConnectedToPort() {
        return 6666;
    }

    @Override
    public int getRetriesOnNetworkError() {
        return 1;
    }

    @Override
    public MorphiumDriver setRetriesOnNetworkError(int r) {
        return this;
    }

    @Override
    public int getSleepBetweenErrorRetries() {
        return 100;
    }

    @Override
    public MorphiumDriver setSleepBetweenErrorRetries(int s) {
        return this;
    }

    @Override
    public int getMaxConnections() {
        return 1;
    }

    @Override
    public MorphiumDriver setMaxConnections(int maxConnections) {
        return this;
    }

    @Override
    public int getMinConnections() {
        return 1;
    }

    @Override
    public MorphiumDriver setMinConnections(int minConnections) {
        return this;
    }

    @Override
    public boolean isRetryReads() {
        return false;
    }

    @Override
    public MorphiumDriver setRetryReads(boolean retryReads) {
        return this;
    }

    @Override
    public boolean isRetryWrites() {
        return false;
    }

    @Override
    public MorphiumDriver setRetryWrites(boolean retryWrites) {
        return this;
    }

    @Override
    public int getReadTimeout() {
        return 0;
    }

    @Override
    public void setReadTimeout(int readTimeout) {
    }

    @Override
    public int getMinConnectionsPerHost() {
        return 0;
    }

    @Override
    public void setMinConnectionsPerHost(int minConnectionsPerHost) {
    }

    @Override
    public int getMaxConnectionsPerHost() {
        return 0;
    }

    @Override
    public void setMaxConnectionsPerHost(int maxConnectionsPerHost) {
    }

    @Override
    public void setCredentials(String db, String login, String pwd) {
    }

    private <T> T deepClone(T object) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            oos.writeObject(object);
            ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
            ObjectInputStream ois = new ObjectInputStream(bais);
            return (T)ois.readObject();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public MorphiumTransactionContext startTransaction(boolean autoCommit) {
        if (this.currentTransaction.get() != null) {
            throw new IllegalArgumentException("transaction in progress");
        }
        InMemTransactionContext ctx = new InMemTransactionContext();
        ctx.setDatabase(this.deepClone(this.database));
        this.currentTransaction.set(ctx);
        return this.currentTransaction.get();
    }

    @Override
    public boolean isTransactionInProgress() {
        return this.currentTransaction.get() != null;
    }

    @Override
    public MorphiumTransactionContext getTransactionContext() {
        return this.currentTransaction.get();
    }

    @Override
    public HelloResult connect(MorphiumDriver drv, String host, int port) throws IOException, MorphiumDriverException {
        return new HelloResult().setHosts(Arrays.asList("inMem")).setHelloOk(true).setLocalTime(new Date()).setMaxBsonObjectSize(Integer.MAX_VALUE).setMe("inMem").setWritablePrimary(true);
    }

    @Override
    public MorphiumDriver getDriver() {
        return this;
    }

    @Override
    public int getSourcePort() {
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        this.exec.shutdownNow();
        Iterator<Object> iterator = this.monitors.iterator();
        while (iterator.hasNext()) {
            Object m;
            Object object = m = iterator.next();
            synchronized (object) {
                m.notifyAll();
            }
        }
        this.database.clear();
    }

    @Override
    public boolean isReplicaset() {
        return false;
    }

    @Override
    public Map<String, Object> getReplsetStatus() {
        return this.prepareResult(Doc.of("ok", (Object)0.0, "errmsg", "no replicaset"));
    }

    @Override
    public Map<String, Object> getDBStats(String db) {
        ConcurrentHashMap<String, Object> ret = new ConcurrentHashMap<String, Object>();
        ret.put("collections", this.getDB(db).size());
        return ret;
    }

    @Override
    public Map<String, Object> getCollStats(String db, String coll) throws MorphiumDriverException {
        ConcurrentHashMap<String, Object> ret = new ConcurrentHashMap<String, Object>();
        ret.put("entries", this.getDB(db).get(coll).size());
        return ret;
    }

    public MorphiumCursor initIteration(String db, String collection, Map<String, Object> query, Map<String, Object> sort, Map<String, Object> projection, int skip, int limit, int batchSize, ReadPreference readPreference, Collation coll, Map<String, Object> findMetaData) throws MorphiumDriverException {
        MorphiumCursor crs = new MorphiumCursor(){

            @Override
            public Iterator<Map<String, Object>> iterator() {
                return this;
            }

            @Override
            public boolean hasNext() {
                return false;
            }

            @Override
            public Map<String, Object> next() {
                return null;
            }

            @Override
            public void close() {
            }

            @Override
            public int available() {
                return 0;
            }

            @Override
            public List<Map<String, Object>> getAll() throws MorphiumDriverException {
                return null;
            }

            @Override
            public void ahead(int skip) throws MorphiumDriverException {
            }

            @Override
            public void back(int jump) throws MorphiumDriverException {
            }

            @Override
            public int getCursor() {
                return 0;
            }

            @Override
            public MongoConnection getConnection() {
                return null;
            }
        };
        crs.setBatchSize(batchSize);
        crs.setCursorId(System.currentTimeMillis());
        InMemoryCursor inCrs = new InMemoryCursor();
        inCrs.skip = skip;
        inCrs.limit = limit;
        inCrs.batchSize = batchSize;
        if (batchSize == 0) {
            inCrs.batchSize = 1000;
        }
        inCrs.setCollection(collection);
        inCrs.setDb(db);
        inCrs.setProjection(projection);
        inCrs.setQuery(query);
        inCrs.setFindMetaData(findMetaData);
        inCrs.setReadPreference(readPreference);
        inCrs.setSort(sort);
        return crs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void watch(String db, String collection, int timeout, boolean fullDocumentOnUpdate, final List<Map<String, Object>> pipeline, final DriverTailableIterationCallback cb) throws MorphiumDriverException {
        final Object monitor = new Object();
        this.monitors.add(monitor);
        DriverTailableIterationCallback cback = new DriverTailableIterationCallback(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void incomingData(Map<String, Object> data, long dur) {
                if (pipeline != null && !pipeline.isEmpty()) {
                    InMemAggregator<Map, Map> agg = new InMemAggregator<Map, Map>(null, Map.class, Map.class);
                    for (Map step : pipeline) {
                        List<Map<String, Object>> lst = agg.execStep(step, Arrays.asList(data));
                        if (lst == null || lst.isEmpty()) {
                            return;
                        }
                        data = lst.get(0);
                    }
                }
                cb.incomingData(data, dur);
                if (!cb.isContinued()) {
                    Object object = monitor;
                    synchronized (object) {
                        monitor.notifyAll();
                    }
                }
            }

            @Override
            public boolean isContinued() {
                return cb.isContinued();
            }
        };
        if (collection != null) {
            db = (String)db + "." + collection;
        }
        this.watchersByDb.putIfAbsent((String)db, new CopyOnWriteArrayList());
        this.watchersByDb.get(db).add(cback);
        try {
            Object object = monitor;
            synchronized (object) {
                monitor.wait();
                this.monitors.remove(monitor);
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.watchersByDb.get(db).remove(cb);
        this.log.debug("Exiting");
    }

    public MorphiumCursor nextIteration(MorphiumCursor crs) throws MorphiumDriverException {
        MorphiumCursor next = new MorphiumCursor(){

            @Override
            public Iterator<Map<String, Object>> iterator() {
                return this;
            }

            @Override
            public boolean hasNext() {
                return false;
            }

            @Override
            public Map<String, Object> next() {
                return null;
            }

            @Override
            public void close() {
            }

            @Override
            public int available() {
                return 0;
            }

            @Override
            public List<Map<String, Object>> getAll() throws MorphiumDriverException {
                return null;
            }

            @Override
            public void ahead(int skip) throws MorphiumDriverException {
            }

            @Override
            public void back(int jump) throws MorphiumDriverException {
            }

            @Override
            public int getCursor() {
                return 0;
            }

            @Override
            public MongoConnection getConnection() {
                return null;
            }
        };
        next.setCursorId(crs.getCursorId());
        return next;
    }

    public List<Map<String, Object>> find(String db, String collection, Map<String, Object> query, Map<String, Object> sort, Map<String, Object> projection, int skip, int limit) throws MorphiumDriverException {
        return this.find(db, collection, query, sort, projection, null, skip, limit, false);
    }

    private List<Map<String, Object>> find(String db, String collection, Map<String, Object> query, Map<String, Object> sort, Map<String, Object> projection, Map<String, Object> collation, int skip, int limit, boolean internal) throws MorphiumDriverException {
        List<Map<String, Object>> dataFromIndex;
        List m;
        List<Object> partialHitData = new ArrayList();
        if (query == null) {
            query = Doc.of();
        }
        if (query.containsKey("$and")) {
            m = (List)query.get("$and");
            if (m != null && !m.isEmpty()) {
                for (Map subquery : m) {
                    dataFromIndex = this.getDataFromIndex(db, collection, subquery);
                    if (dataFromIndex == null) continue;
                    partialHitData = dataFromIndex;
                    break;
                }
            }
        } else if (query.containsKey("$or")) {
            m = (List)query.get("$or");
            if (m != null) {
                for (Map subquery : m) {
                    dataFromIndex = this.getDataFromIndex(db, collection, subquery);
                    if (dataFromIndex == null) continue;
                    partialHitData.addAll(dataFromIndex);
                }
            }
        } else {
            partialHitData = this.getDataFromIndex(db, collection, query);
        }
        List<Object> data = partialHitData == null || partialHitData.isEmpty() ? new ArrayList<Map<String, Object>>(this.getCollection(db, collection)) : partialHitData;
        ArrayList ret = new ArrayList();
        int count = 0;
        if (sort != null) {
            Collator coll = QueryHelper.getCollator(collation);
            data.sort((o1, o2) -> {
                for (String f : sort.keySet()) {
                    int r;
                    if (o1.get(f) == null && o2.get(f) == null) continue;
                    if (o1.get(f) == null && o2.get(f) != null) {
                        return -1;
                    }
                    if (o1.get(f) != null && o2.get(f) == null) {
                        return 1;
                    }
                    if (sort.get(f) instanceof Integer) {
                        if (coll != null) {
                            r = coll.compare(o1.get(f).toString(), o2.get(f).toString()) * (Integer)sort.get(f);
                            if (r == 0) continue;
                            return r;
                        }
                        r = ((Comparable)o1.get(f)).compareTo(o2.get(f)) * (Integer)sort.get(f);
                        if (r == 0) continue;
                        return r;
                    }
                    r = coll.compare(o1.toString(), o2.toString());
                    if (r == 0) continue;
                    return r;
                }
                return 0;
            });
        }
        for (int i = 0; i < data.size(); ++i) {
            HashMap<String, MorphiumId> o = (HashMap<String, MorphiumId>)data.get(i);
            if (++count < skip) continue;
            if (!internal) {
                while (true) {
                    try {
                        o = new HashMap<String, MorphiumId>(o);
                        if (!(o.get("_id") instanceof ObjectId)) break;
                        o.put("_id", new MorphiumId((ObjectId)o.get("_id")));
                    }
                    catch (ConcurrentModificationException concurrentModificationException) {
                        continue;
                    }
                    break;
                }
            }
            if (QueryHelper.matchesQuery(query, (Map<String, Object>)o, collation)) {
                if (o == null) {
                    o = new HashMap();
                }
                ret.add(o);
            }
            if (limit > 0 && ret.size() >= limit) break;
        }
        return new ArrayList<Map<String, Object>>(ret);
    }

    private List<Map<String, Object>> getDataFromIndex(String db, String collection, Map<String, Object> query) {
        List<Map<String, Object>> ret = null;
        int bucketId = 0;
        StringBuilder fieldList = new StringBuilder();
        for (Map<String, Object> idx : this.getIndexes(db, collection)) {
            if (idx.size() > query.size()) continue;
            boolean found = true;
            bucketId = 0;
            fieldList.setLength(0);
            for (String k : query.keySet()) {
                if (!idx.containsKey(k)) {
                    found = false;
                    break;
                }
                Object value = query.get(k);
                bucketId = this.iterateBucketId(bucketId, value);
                fieldList.append(k);
            }
            if (!found) continue;
            String fields = fieldList.toString();
            Map<Integer, List<Map<String, Object>>> indexDataForCollection = this.getIndexDataForCollection(db, collection, fields);
            ret = indexDataForCollection.get(bucketId);
            if (ret != null && ret.size() != 0) break;
            ret = new ArrayList<Map<String, Object>>();
            for (Map.Entry<Integer, List<Map<String, Object>>> k : indexDataForCollection.entrySet()) {
                for (Map<String, Object> o : k.getValue()) {
                    if (!QueryHelper.matchesQuery(query, o, null)) continue;
                    ret.add(o);
                }
            }
            if (ret.size() != 0) break;
            ret = null;
            break;
        }
        return ret;
    }

    public long count(String db, String collection, Map<String, Object> query, Collation collation, ReadPreference rp) throws MorphiumDriverException {
        List<Map<String, Object>> d = this.getCollection(db, collection);
        CopyOnWriteArrayList<Map<String, Object>> data = new CopyOnWriteArrayList<Map<String, Object>>(d);
        if (query.isEmpty()) {
            return data.size();
        }
        long cnt = 0L;
        for (Map map : data) {
            if (!QueryHelper.matchesQuery(query, map, collation == null ? null : collation.toQueryObject())) continue;
            ++cnt;
        }
        return cnt;
    }

    public long estimatedDocumentCount(String db, String collection, ReadPreference rp) throws MorphiumDriverException {
        return this.getCollection(db, collection).size();
    }

    public List<Map<String, Object>> findByFieldValue(String db, String coll, String field, Object value) throws MorphiumDriverException {
        ArrayList<Map<String, Object>> ret = new ArrayList<Map<String, Object>>();
        CopyOnWriteArrayList<Map<String, Object>> data = new CopyOnWriteArrayList<Map<String, Object>>(this.getCollection(db, coll));
        for (Map map : data) {
            if (map.get(field) == null && value != null || (map.get(field) != null || value != null) && !map.get(field).equals(value)) continue;
            ConcurrentHashMap<String, MorphiumId> add = new ConcurrentHashMap<String, MorphiumId>(map);
            if (add.get("_id") instanceof ObjectId) {
                add.put("_id", new MorphiumId((ObjectId)add.get("_id")));
            }
            ret.add(add);
        }
        return ret;
    }

    public Map<Integer, List<Map<String, Object>>> getIndexDataForCollection(String db, String collection, String fields) {
        this.indexDataByDBCollection.putIfAbsent(db, new ConcurrentHashMap());
        this.indexDataByDBCollection.get(db).putIfAbsent(collection, new ConcurrentHashMap());
        this.indexDataByDBCollection.get(db).get(collection).putIfAbsent(fields, new HashMap());
        return this.indexDataByDBCollection.get(db).get(collection).get(fields);
    }

    public synchronized List<Map<String, Object>> insert(String db, String collection, List<Map<String, Object>> objs, Map<String, Object> wc) throws MorphiumDriverException {
        int errors = 0;
        objs = new ArrayList<Map<String, Object>>(objs);
        ArrayList<Map<String, Object>> writeErrors = new ArrayList<Map<String, Object>>();
        List<Map<String, Object>> indexes = this.getIndexes(db, collection);
        if (indexes != null && !indexes.isEmpty()) {
            for (Map<String, Object> idx : indexes) {
                Map options;
                if (!idx.containsKey("$options") || !(options = (Map)idx.get("$options")).containsKey("unique") || !options.get("unique").equals("true") && !options.get("unique").equals(true)) continue;
                HashMap<String, Object> indexKey = new HashMap<String, Object>(idx);
                for (Map<String, Object> o : objs) {
                    Doc q = Doc.of();
                    for (Object k : indexKey.keySet()) {
                        if (((String)k).startsWith("$")) continue;
                        q.put(k, o.get(k));
                    }
                    if (q.size() != 1) {
                        Object k;
                        ArrayList<Doc> and = new ArrayList<Doc>();
                        k = q.entrySet().iterator();
                        while (k.hasNext()) {
                            Map.Entry e = (Map.Entry)k.next();
                            and.add(Doc.of((String)e.getKey(), e.getValue()));
                        }
                        q = Doc.of("$and", and);
                    }
                    if (this.find(db, collection, q, null, null, 0, 0).size() <= 0) continue;
                    this.log.error("Cannot store - unique index!");
                    writeErrors.add(o);
                }
                errors += writeErrors.size();
                objs.removeAll(writeErrors);
            }
        }
        for (Map<String, Object> o : objs) {
            if (o.get("_id") != null) {
                Map<Integer, List<Map<String, Object>>> id = this.getIndexDataForCollection(db, collection, "_id");
                int bucketId = this.iterateBucketId(0, o.get("_id"));
                if (id != null && id.containsKey(bucketId)) {
                    for (Map<String, Object> objectMap : id.get(bucketId)) {
                        if (!objectMap.get("_id").equals(o.get("_id"))) continue;
                        throw new MorphiumDriverException("Duplicate _id! " + String.valueOf(o.get("_id")), null);
                    }
                }
            }
            o.putIfAbsent("_id", new ObjectId());
        }
        List<Map<String, Object>> collectionData = this.getCollection(db, collection);
        if (this.cappedCollections.containsKey(db) && this.cappedCollections.get(db).containsKey(collection)) {
            while (!collectionData.isEmpty() && this.cappedCollections.get(db).get(collection).containsKey("max") && this.cappedCollections.get(db).get(collection).get("max") < collectionData.size() + objs.size()) {
                collectionData.remove(0);
            }
            while (collectionData.size() > 0 && (long)this.cappedCollections.get(db).get(collection).get("size").intValue() < VM.current().sizeOf(collectionData) + VM.current().sizeOf(objs)) {
                collectionData.remove(0);
            }
            while (objs.size() > 0 && this.cappedCollections.get(db).get(collection).containsKey("max") && collectionData.size() + objs.size() > this.cappedCollections.get(db).get(collection).get("max")) {
                objs.remove(0);
            }
            while (objs.size() > 0 && this.cappedCollections.get(db).get(collection).containsKey("size") && VM.current().sizeOf(collectionData) + VM.current().sizeOf((Object)objs.size()) > (long)this.cappedCollections.get(db).get(collection).get("size").intValue()) {
                objs.remove(0);
            }
        }
        collectionData.addAll(objs);
        for (int i = 0; i < objs.size(); ++i) {
            Map<String, Object> o = objs.get(i);
            List<Map<String, Object>> idx = indexes;
            Map<String, Map<Integer, List<Map<String, Object>>>> indexData = this.indexDataByDBCollection.get(db).get(collection);
            for (Map<String, Object> ix : idx) {
                int bucketId = 0;
                StringBuilder fieldNames = new StringBuilder();
                for (String k : ix.keySet()) {
                    bucketId = this.iterateBucketId(bucketId, o.get(k));
                    fieldNames.append(k);
                }
                String fn = fieldNames.toString();
                indexData.putIfAbsent(fn, new HashMap());
                indexData.get(fn).putIfAbsent(bucketId, new ArrayList());
                indexData.get(fn).get(bucketId).add(o);
            }
            int buckedId = this.iterateBucketId(0, o.get("_id"));
            indexData.putIfAbsent("_id", new HashMap());
            indexData.get("_id").putIfAbsent(buckedId, new ArrayList());
            indexData.get("_id").get(buckedId).add(o);
            this.notifyWatchers(db, collection, "insert", o);
        }
        return writeErrors;
    }

    private Integer iterateBucketId(int bucketId, Object o) {
        if (o == null) {
            return bucketId + 1;
        }
        return bucketId + o.hashCode();
    }

    public synchronized Map<String, Integer> store(String db, String collection, List<Map<String, Object>> objs, Map<String, Object> wc) throws MorphiumDriverException {
        ConcurrentHashMap<String, Integer> ret = new ConcurrentHashMap<String, Integer>();
        int upd = 0;
        int total = objs.size();
        for (Map<String, Object> o : objs) {
            if (o.get("_id") == null) {
                o.put("_id", new MorphiumId());
                this.getCollection(db, collection).add(o);
                continue;
            }
            List<Map<String, Object>> srch = this.findByFieldValue(db, collection, "_id", o.get("_id"));
            if (!srch.isEmpty()) {
                this.getCollection(db, collection).remove(srch.get(0));
                ++upd;
                this.notifyWatchers(db, collection, "replace", o);
            } else {
                this.notifyWatchers(db, collection, "insert", o);
            }
            this.getCollection(db, collection).add(o);
            List<Map<String, Object>> idx = this.getIndexes(db, collection);
            int bucketId = 0;
            StringBuilder fields = new StringBuilder();
            for (Map<String, Object> i : idx) {
                for (String k : i.keySet()) {
                    bucketId = this.iterateBucketId(bucketId, o.get(k));
                    fields.append(k);
                }
                this.indexDataByDBCollection.putIfAbsent(db, new ConcurrentHashMap());
                this.indexDataByDBCollection.get(db).putIfAbsent(collection, new ConcurrentHashMap());
                this.indexDataByDBCollection.get(db).get(collection).putIfAbsent(fields.toString(), new HashMap());
                this.indexDataByDBCollection.get(db).get(collection).get(fields.toString()).putIfAbsent(bucketId, new ArrayList());
                this.indexDataByDBCollection.get(db).get(collection).get(fields.toString()).get(bucketId).add(o);
            }
        }
        ret.put("matched", upd);
        ret.put("updated", upd);
        return ret;
    }

    private Map<String, List<Map<String, Object>>> getDB(String db) {
        if (this.currentTransaction.get() == null) {
            this.database.putIfAbsent(db, new ConcurrentHashMap());
            return this.database.get(db);
        }
        this.currentTransaction.get().getDatabase().putIfAbsent(db, new ConcurrentHashMap());
        return (Map)this.currentTransaction.get().getDatabase().get(db);
    }

    @Override
    public void closeIteration(MorphiumCursor crs) {
    }

    @Override
    public Map<String, Object> killCursors(String db, String coll, long ... ids) throws MorphiumDriverException {
        for (long i : ids) {
            this.cursors.remove(i);
        }
        return this.prepareResult();
    }

    @Override
    public OpMsg readNextMessage(int timeout) throws MorphiumDriverException {
        OpMsg msg = new OpMsg();
        msg.setMessageId(0);
        HashMap<String, Object> o = new HashMap<String, Object>(this.commandResults.remove(0));
        msg.setFirstDoc(o);
        return msg;
    }

    @Override
    public Map<String, Object> readSingleAnswer(int id) throws MorphiumDriverException {
        return this.commandResults.remove(0);
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    public synchronized Map<String, Object> update(String db, String collection, Map<String, Object> query, Map<String, Object> sort, Map<String, Object> op, boolean multiple, boolean upsert, Map<String, Object> collation, Map<String, Object> wc) throws MorphiumDriverException {
        lst = this.find(db, collection, query, sort, null, collation, 0, multiple != false ? 0 : 1, true);
        insert = false;
        count = 0;
        if (lst == null) {
            lst = new ArrayList<Map<String, Object>>();
        }
        if (upsert && lst.isEmpty()) {
            lst.add(new ConcurrentHashMap<K, V>());
            for (String k : query.keySet()) {
                if (k.startsWith("$")) continue;
                if (query.get(k) != null) {
                    lst.get(0).put(k, query.get(k));
                    continue;
                }
                lst.get(0).remove(k);
            }
            insert = true;
        }
        modified = new HashSet<Object>();
        for (Map obj : lst) {
            block32: for (String operand : op.keySet()) {
                cmd = (Map)op.get(operand);
                var19_19 = operand;
                var20_20 = -1;
                switch (var19_19.hashCode()) {
                    case 1186238: {
                        if (!var19_19.equals("$set")) break;
                        var20_20 = 0;
                        break;
                    }
                    case 1142092165: {
                        if (!var19_19.equals("$unset")) break;
                        var20_20 = 1;
                        break;
                    }
                    case 1176890: {
                        if (!var19_19.equals("$inc")) break;
                        var20_20 = 2;
                        break;
                    }
                    case 952761891: {
                        if (!var19_19.equals("$currentDate")) break;
                        var20_20 = 3;
                        break;
                    }
                    case 1180960: {
                        if (!var19_19.equals("$mul")) break;
                        var20_20 = 4;
                        break;
                    }
                    case 950766690: {
                        if (!var19_19.equals("$rename")) break;
                        var20_20 = 5;
                        break;
                    }
                    case 1180590: {
                        if (!var19_19.equals("$min")) break;
                        var20_20 = 6;
                        break;
                    }
                    case 1180352: {
                        if (!var19_19.equals("$max")) break;
                        var20_20 = 7;
                        break;
                    }
                    case 36699241: {
                        if (!var19_19.equals("$pull")) break;
                        var20_20 = 8;
                        break;
                    }
                    case -1909505928: {
                        if (!var19_19.equals("$pullAll")) break;
                        var20_20 = 9;
                        break;
                    }
                    case -1890005014: {
                        if (!var19_19.equals("$addToSet")) break;
                        var20_20 = 10;
                        break;
                    }
                    case 36699454: {
                        if (!var19_19.equals("$push")) break;
                        var20_20 = 11;
                        break;
                    }
                    case -1903160445: {
                        if (!var19_19.equals("$pushAll")) break;
                        var20_20 = 12;
                    }
                }
                block16 : switch (var20_20) {
                    case 0: {
                        for (Map.Entry<K, V> entry : cmd.entrySet()) {
                            if (entry.getValue() == null) ** GOTO lbl114
                            v /* !! */  = entry.getValue();
                            if (v /* !! */  instanceof Map) {
                                try {
                                    v /* !! */  = Expr.parse(v /* !! */ ).evaluate(obj);
                                }
                                catch (Exception var24_25) {
                                    // empty catch block
                                }
                            }
                            if (!((String)entry.getKey()).contains(".")) ** GOTO lbl111
                            path = ((String)entry.getKey()).split("\\.");
                            current = obj;
                            lastEl /* !! */  = null;
                            var27_33 = path;
                            var28_35 = var27_33.length;
                            for (var29_36 = 0; var29_36 < var28_35; ++var29_36) {
                                p = var27_33[var29_36];
                                if (current.get(p) == null) ** GOTO lbl103
                                if (current.get(p) instanceof Map) {
                                    ((Map)current.get(p)).put(p, Doc.of());
                                } else {
                                    this.log.error("could not set value! " + p);
                                    break;
lbl103:
                                    // 1 sources

                                    current.put(p, Doc.of());
                                }
                                lastEl /* !! */  = current;
                                current = (Map)current.get(p);
                            }
                            lastEl /* !! */ .put(path[path.length - 1], v /* !! */ );
                            continue;
lbl111:
                            // 1 sources

                            obj.put((String)((String)entry.getKey()), v /* !! */ );
                            continue;
lbl114:
                            // 1 sources

                            if (((String)entry.getKey()).contains(".")) {
                                path = ((String)entry.getKey()).split("\\.");
                                current = obj;
                                lastEl = null;
                                for (String p : path) {
                                    lastEl = current;
                                    if (current.get(p) == null) break;
                                    current = (Map)current.get(p);
                                }
                                if (lastEl == null) continue;
                                lastEl.remove(path[path.length - 1]);
                                continue;
                            }
                            obj.remove(entry.getKey());
                        }
                        continue block32;
                    }
                    case 1: {
                        for (Map.Entry<K, V> entry : cmd.entrySet()) {
                            obj.remove(entry.getKey());
                        }
                        continue block32;
                    }
                    case 2: {
                        for (Map.Entry<K, V> entry : cmd.entrySet()) {
                            value = obj.get(entry.getKey());
                            if (value == null) {
                                value = new Integer(0);
                            }
                            if (value instanceof Integer) {
                                if (entry.getValue() instanceof Integer) {
                                    value = (Integer)value + (Integer)entry.getValue();
                                } else if (entry.getValue() instanceof Float) {
                                    value = Float.valueOf((float)((Integer)value).intValue() + ((Float)entry.getValue()).floatValue());
                                } else if (entry.getValue() instanceof Double) {
                                    value = (double)((Integer)value).intValue() + (Double)entry.getValue();
                                } else if (entry.getValue() instanceof Long) {
                                    value = (long)((Integer)value).intValue() + (Long)entry.getValue();
                                }
                            } else if (value instanceof Double) {
                                if (entry.getValue() instanceof Integer) {
                                    value = (Double)value + (double)((Integer)entry.getValue()).intValue();
                                } else if (entry.getValue() instanceof Float) {
                                    value = (Double)value + (double)((Float)entry.getValue()).floatValue();
                                } else if (entry.getValue() instanceof Double) {
                                    value = (Double)value + (Double)entry.getValue();
                                } else if (entry.getValue() instanceof Long) {
                                    value = (Double)value + (double)((Long)entry.getValue()).longValue();
                                }
                            } else if (value instanceof Float) {
                                if (entry.getValue() instanceof Integer) {
                                    value = Float.valueOf(((Float)value).floatValue() + (float)((Integer)entry.getValue()).intValue());
                                } else if (entry.getValue() instanceof Float) {
                                    value = Float.valueOf(((Float)value).floatValue() + ((Float)entry.getValue()).floatValue());
                                } else if (entry.getValue() instanceof Double) {
                                    value = (double)((Float)value).floatValue() + (Double)entry.getValue();
                                } else if (entry.getValue() instanceof Long) {
                                    value = Float.valueOf(((Float)value).floatValue() + (float)((Long)entry.getValue()).longValue());
                                }
                            } else if (value instanceof Long) {
                                if (entry.getValue() instanceof Integer) {
                                    value = (Long)value + (long)((Integer)entry.getValue()).intValue();
                                } else if (entry.getValue() instanceof Float) {
                                    value = Float.valueOf((float)((Long)value).longValue() + ((Float)entry.getValue()).floatValue());
                                } else if (entry.getValue() instanceof Double) {
                                    value = (double)((Long)value).longValue() + (Double)entry.getValue();
                                } else if (entry.getValue() instanceof Long) {
                                    value = (Long)value + (Long)entry.getValue();
                                }
                            }
                            if (!obj.get(entry.getKey()).equals(value)) {
                                modified.add(obj.get("_id"));
                            }
                            if (value != null) {
                                obj.put((String)((String)entry.getKey()), (Object)value);
                                continue;
                            }
                            obj.remove(entry.getKey());
                        }
                        continue block32;
                    }
                    case 3: {
                        obj.put((String)((String)cmd.keySet().toArray()[0]), (Object)new Date());
                        break;
                    }
                    case 4: {
                        for (Map.Entry<K, V> entry : cmd.entrySet()) {
                            value = obj.get(entry.getKey());
                            if (value instanceof Integer) {
                                value = (Integer)value * (Integer)entry.getValue();
                            } else if (value instanceof Double) {
                                value = (Double)value * (Double)entry.getValue();
                            } else if (value instanceof Float) {
                                value = Float.valueOf(((Float)value).floatValue() * ((Float)entry.getValue()).floatValue());
                            } else if (value instanceof Long) {
                                value = (Long)value * (Long)entry.getValue();
                            }
                            if (!obj.get(entry.getKey()).equals(value)) {
                                modified.add(obj.get("_id"));
                            }
                            if (value != null) {
                                obj.put((String)((String)entry.getKey()), (Object)value);
                                continue;
                            }
                            obj.remove(entry.getKey());
                        }
                        continue block32;
                    }
                    case 5: {
                        for (Map.Entry<K, V> entry : cmd.entrySet()) {
                            if (obj.get(entry.getKey()) != null) {
                                obj.put((String)((String)entry.getValue()), (Object)obj.get(entry.getKey()));
                            } else {
                                obj.remove(entry.getValue());
                            }
                            obj.remove(entry.getKey());
                            modified.add(obj.get("_id"));
                        }
                        continue block32;
                    }
                    case 6: {
                        for (Map.Entry<K, V> entry : cmd.entrySet()) {
                            value = (Comparable)obj.get(entry.getKey());
                            if (value.compareTo(entry.getValue()) <= 0 || entry.getValue() == null) continue;
                            modified.add(obj.get("_id"));
                            obj.put((String)((String)entry.getKey()), entry.getValue());
                        }
                        continue block32;
                    }
                    case 7: {
                        for (Map.Entry<K, V> entry : cmd.entrySet()) {
                            value = (Comparable)obj.get(entry.getKey());
                            if (value.compareTo(entry.getValue()) >= 0 || entry.getValue() == null) continue;
                            obj.put((String)((String)entry.getKey()), entry.getValue());
                            modified.add(obj.get("_id"));
                        }
                        continue block32;
                    }
                    case 8: {
                        for (Map.Entry<K, V> entry : cmd.entrySet()) {
                            values = new ArrayList<E>((List)obj.get(entry.getKey()));
                            subquery = Doc.of((String)entry.getKey(), entry.getValue());
                            filteredValues = new ArrayList<E>();
                            for (E value : values) {
                                if (QueryHelper.matchesQuery(subquery, Doc.of((String)entry.getKey(), value), null)) continue;
                                filteredValues.add(value);
                            }
                            v0 = valueIsChanged = filteredValues.containsAll(values) == false || values.containsAll(filteredValues) == false;
                            if (valueIsChanged) {
                                modified.add(obj.get("_id"));
                            }
                            obj.put((String)((String)entry.getKey()), filteredValues);
                        }
                        continue block32;
                    }
                    case 9: {
                        for (Map.Entry<K, V> entry : cmd.entrySet()) {
                            v /* !! */  = new ArrayList<E>((List)obj.get(entry.getKey()));
                            objectsToBeDeleted = (List)entry.getValue();
                            valueIsChanged = objectsToBeDeleted.stream().anyMatch((Predicate<Object>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$update$3(java.util.List java.lang.Object ), (Ljava/lang/Object;)Z)(v /* !! */ ));
                            if (valueIsChanged) {
                                modified.add(obj.get("_id"));
                            }
                            v /* !! */ .removeAll(objectsToBeDeleted);
                            obj.put((String)((String)entry.getKey()), v /* !! */ );
                        }
                        continue block32;
                    }
                    case 10: 
                    case 11: 
                    case 12: {
                        for (Map.Entry<K, V> entry : cmd.entrySet()) {
                            v /* !! */  = (List)obj.get(entry.getKey());
                            if (v /* !! */  == null) {
                                v /* !! */  = new ArrayList<E>();
                                obj.put((String)((String)entry.getKey()), v /* !! */ );
                                modified.add(obj.get("_id"));
                            }
                            if (entry.getValue() instanceof Map) {
                                if (((Map)entry.getValue()).get("$each") != null) {
                                    if (operand.equals("$addToSet")) {
                                        for (E elem : (List)((Map)entry.getValue()).get("$each")) {
                                            if (v /* !! */ .contains(elem)) continue;
                                            v /* !! */ .add(elem);
                                        }
                                        continue;
                                    }
                                    v /* !! */ .addAll((List)((Map)entry.getValue()).get("$each"));
                                    continue;
                                }
                                if (operand.equals("$addToSet") && v /* !! */ .contains(entry.getValue())) break block16;
                                if (operand.equals("$pushAll") && entry.getValue() instanceof List) {
                                    v /* !! */ .addAll((List)entry.getValue());
                                    continue;
                                }
                                v /* !! */ .add(entry.getValue());
                                continue;
                            }
                            if (operand.equals("$addToSet") && v /* !! */ .contains(entry.getValue())) break block16;
                            if (operand.equals("$pushAll") && entry.getValue() instanceof List) {
                                v /* !! */ .addAll((List)entry.getValue());
                                continue;
                            }
                            v /* !! */ .add(entry.getValue());
                        }
                        continue block32;
                    }
                    default: {
                        throw new RuntimeException("unknown operand " + operand);
                    }
                }
            }
            ++count;
            if (insert) continue;
            this.notifyWatchers(db, collection, "update", obj);
        }
        if (insert) {
            this.store(db, collection, lst, wc);
        }
        this.indexDataByDBCollection.get(db).remove(collection);
        this.updateIndexData(db, collection, null);
        return Doc.of("matched", (Object)lst.size(), "inserted", (Object)(insert != false ? 1 : 0), "nModified", (Object)count, "modified", (Object)count);
    }

    private void notifyWatchers(String db, String collection, String op, Map doc) {
        Runnable r = () -> {
            List<DriverTailableIterationCallback> w = null;
            if (this.watchersByDb.containsKey(db)) {
                w = Collections.synchronizedList(new CopyOnWriteArrayList(this.watchersByDb.get(db)));
            } else if (collection != null && this.watchersByDb.containsKey(db + "." + collection)) {
                w = Collections.synchronizedList(new CopyOnWriteArrayList(this.watchersByDb.get(db + "." + collection)));
            }
            if (w == null || w.isEmpty()) {
                return;
            }
            long tx = this.txn.incrementAndGet();
            Collections.shuffle(w);
            for (DriverTailableIterationCallback cb : w) {
                ConcurrentHashMap<String, Object> data = new ConcurrentHashMap<String, Object>();
                if (doc != null) {
                    data.put("fullDocument", doc);
                }
                if (op != null) {
                    data.put("operationType", op);
                }
                Map<String, String> m = Collections.synchronizedMap(new HashMap<String, String>(UtilsMap.of("db", db)));
                m.put("coll", collection);
                data.put("ns", m);
                data.put("txnNumber", tx);
                data.put("clusterTime", System.currentTimeMillis());
                if (doc != null && doc.get("_id") != null) {
                    if (doc.get("_id") instanceof ObjectId) {
                        data.put("documentKey", new MorphiumId((ObjectId)doc.get("_id")));
                    } else {
                        data.put("documentKey", doc.get("_id"));
                    }
                }
                try {
                    cb.incomingData(data, System.currentTimeMillis());
                }
                catch (Exception e) {
                    this.log.error("Error calling watcher", (Throwable)e);
                }
            }
        };
        this.eventQueue.add(r);
    }

    public synchronized Map<String, Object> delete(String db, String collection, Map<String, Object> query, Map<String, Object> sort, boolean multiple, Map<String, Object> collation, WriteConcern wc) throws MorphiumDriverException {
        ArrayList<Map<String, Object>> toDel = new ArrayList<Map<String, Object>>(this.find(db, collection, query, null, UtilsMap.of("_id", 1), 0, multiple ? 0 : 1));
        for (Map map : toDel) {
            for (Map<String, Object> dat : new ArrayList<Map<String, Object>>(this.getCollection(db, collection))) {
                ArrayList lst;
                Map<Integer, List<Map<String, Object>>> id;
                if (dat.get("_id") instanceof ObjectId || dat.get("_id") instanceof MorphiumId) {
                    if (!dat.get("_id").toString().equals(map.get("_id").toString())) continue;
                    this.getCollection(db, collection).remove(dat);
                    for (String keys : this.indexDataByDBCollection.get(db).get(collection).keySet()) {
                        id = this.getIndexDataForCollection(db, collection, keys);
                        for (int bucketId : id.keySet()) {
                            lst = new ArrayList(id.get(bucketId));
                            for (Map objectMap : lst) {
                                if (!objectMap.get("_id").toString().equals(map.get("_id").toString())) continue;
                                id.get(bucketId).remove(objectMap);
                            }
                        }
                    }
                    continue;
                }
                if (!dat.get("_id").equals(map.get("_id"))) continue;
                this.getCollection(db, collection).remove(dat);
                for (String keys : this.indexDataByDBCollection.get(db).get(collection).keySet()) {
                    id = this.getIndexDataForCollection(db, collection, keys);
                    for (int bucketId : id.keySet()) {
                        lst = new ArrayList(id.get(bucketId));
                        for (Map objectMap : lst) {
                            if (!objectMap.get("_id").equals(map.get("_id"))) continue;
                            id.get(bucketId).remove(objectMap);
                        }
                    }
                }
            }
            this.notifyWatchers(db, collection, "delete", map);
        }
        return new ConcurrentHashMap<String, Object>();
    }

    private List<Map<String, Object>> getCollection(String db, String collection) throws MorphiumDriverException {
        if (!this.getDB(db).containsKey(collection)) {
            this.getDB(db).put(collection, new CopyOnWriteArrayList());
            try {
                this.createIndex(db, collection, Doc.of("_id", (Object)1), Doc.of("name", "_id_1"));
            }
            catch (MorphiumDriverException morphiumDriverException) {
                // empty catch block
            }
        }
        return this.getDB(db).get(collection);
    }

    public synchronized void drop(String db, String collection, WriteConcern wc) {
        this.getDB(db).remove(collection);
        if (this.indexDataByDBCollection.containsKey(db)) {
            this.indexDataByDBCollection.get(db).remove(collection);
        }
        if (this.indicesByDbCollection.containsKey(db)) {
            this.indicesByDbCollection.get(db).remove(collection);
        }
        this.notifyWatchers(db, collection, "drop", null);
    }

    public synchronized void drop(String db, WriteConcern wc) {
        this.database.remove(db);
        if (this.indexDataByDBCollection.containsKey(db)) {
            this.indexDataByDBCollection.remove(db);
        }
        if (this.indicesByDbCollection.containsKey(db)) {
            this.indicesByDbCollection.remove(db);
        }
        this.notifyWatchers(db, null, "drop", null);
    }

    @Override
    public boolean exists(String db) {
        return this.database.containsKey(db);
    }

    @Override
    public int getMaxConnectionLifetime() {
        return 0;
    }

    @Override
    public void setMaxConnectionLifetime(int timeout) {
    }

    @Override
    public int getMaxConnectionIdleTime() {
        return 0;
    }

    @Override
    public void setMaxConnectionIdleTime(int time) {
    }

    @Override
    public int getConnectionTimeout() {
        return 0;
    }

    @Override
    public void setConnectionTimeout(int timeout) {
    }

    @Override
    public int getDefaultW() {
        return 0;
    }

    @Override
    public void setDefaultW(int w) {
    }

    @Override
    public int getHeartbeatFrequency() {
        return 0;
    }

    @Override
    public void setHeartbeatFrequency(int heartbeatFrequency) {
    }

    @Override
    public ReadPreference getDefaultReadPreference() {
        return null;
    }

    @Override
    public void setDefaultReadPreference(ReadPreference rp) {
    }

    @Override
    public int getDefaultBatchSize() {
        return 0;
    }

    @Override
    public void setDefaultBatchSize(int defaultBatchSize) {
    }

    @Override
    public boolean isUseSSL() {
        return false;
    }

    @Override
    public void setUseSSL(boolean useSSL) {
    }

    @Override
    public boolean isDefaultJ() {
        return false;
    }

    @Override
    public void setDefaultJ(boolean j) {
    }

    public List<Object> distinct(String db, String collection, String field, Map<String, Object> filter, Map<String, Object> collation) throws MorphiumDriverException {
        List<Map<String, Object>> list = this.find(db, collection, filter, null, null, 0, 0);
        HashSet<Object> distinctValues = new HashSet<Object>();
        if (list != null && !list.isEmpty()) {
            for (Map<String, Object> doc : list) {
                if (doc == null || doc.isEmpty() || doc.get(field) == null) continue;
                distinctValues.add(doc.get(field));
            }
        }
        return Collections.synchronizedList(new ArrayList(distinctValues));
    }

    @Override
    public boolean exists(String db, String collection) {
        return this.getDB(db) != null && this.getDB(db).containsKey(collection);
    }

    private Map<String, List<Map<String, Object>>> getIndexesForDB(String db) {
        this.indicesByDbCollection.putIfAbsent(db, new ConcurrentHashMap());
        return this.indicesByDbCollection.get(db);
    }

    public List<Map<String, Object>> getIndexes(String db, String collection) {
        if (!this.getIndexesForDB(db).containsKey(collection)) {
            ArrayList<Doc> value = new ArrayList<Doc>();
            this.getIndexesForDB(db).put(collection, value);
            value.add(Doc.of("_id", (Object)1, "$options", Doc.of("name", "_id_1")));
        }
        return this.getIndexesForDB(db).get(collection);
    }

    public List<String> getCollectionNames(String db) {
        return null;
    }

    public Map<String, Object> findAndOneAndDelete(String db, String col, Map<String, Object> query, Map<String, Object> sort, Map<String, Object> collation) throws MorphiumDriverException {
        List<Map<String, Object>> r = this.find(db, col, query, sort, null, 0, 1);
        if (r.size() == 0) {
            return null;
        }
        this.delete(db, col, Doc.of("_id", r.get(0).get("_id")), null, false, collation, null);
        return r.get(0);
    }

    public synchronized Map<String, Object> findAndOneAndUpdate(String db, String col, Map<String, Object> query, Map<String, Object> update, Map<String, Object> sort, Map<String, Object> collation) throws MorphiumDriverException {
        List<Map<String, Object>> ret = this.find(db, col, query, sort, null, 0, 1);
        this.update(db, col, query, null, update, false, false, collation, null);
        return ret.get(0);
    }

    public synchronized Map<String, Object> findAndOneAndReplace(String db, String col, Map<String, Object> query, Map<String, Object> replacement, Map<String, Object> sort, Map<String, Object> collation) throws MorphiumDriverException {
        List<Map<String, Object>> ret = this.find(db, col, query, sort, null, 0, 1);
        if (ret.get(0).get("_id") != null) {
            replacement.put("_id", ret.get(0).get("_id"));
        } else {
            replacement.remove("_id");
        }
        this.store(db, col, Collections.singletonList(replacement), null);
        return replacement;
    }

    public void tailableIteration(String db, String collection, Map<String, Object> query, Map<String, Object> sort, Map<String, Object> projection, int skip, int limit, int batchSize, ReadPreference readPreference, int timeout, DriverTailableIterationCallback cb) throws MorphiumDriverException {
        throw new FunctionNotSupportedException("not possible in Mem yet");
    }

    @Override
    public int getMaxWaitTime() {
        return 0;
    }

    @Override
    public void setMaxWaitTime(int maxWaitTime) {
    }

    @Override
    public String[] getCredentials(String db) {
        return new String[0];
    }

    @Override
    public List<String> getHostSeed() {
        return new ArrayList<String>();
    }

    @Override
    public void setHostSeed(List<String> hosts) {
    }

    public int getServerSelectionTimeout() {
        return 0;
    }

    public void setServerSelectionTimeout(int serverSelectionTimeout) {
    }

    @Override
    public boolean isCapped(String db, String coll) {
        return this.cappedCollections.containsKey(db) && this.cappedCollections.get(db).containsKey(coll);
    }

    @Override
    public Map<String, Integer> getNumConnectionsByHost() {
        return Map.of("inMem", 1);
    }

    @Override
    public BulkRequestContext createBulkContext(Morphium m, final String db, final String collection, boolean ordered, WriteConcern wc) {
        return new BulkRequestContext(m){
            private final List<BulkRequest> requests;
            {
                super(m);
                this.requests = new ArrayList<BulkRequest>();
            }

            @Override
            public Map<String, Object> execute() {
                try {
                    for (BulkRequest r : this.requests) {
                        if (r instanceof InsertBulkRequest) {
                            InMemoryDriver.this.insert(db, collection, ((InsertBulkRequest)r).getToInsert(), null);
                            continue;
                        }
                        if (r instanceof UpdateBulkRequest) {
                            UpdateBulkRequest up = (UpdateBulkRequest)r;
                            InMemoryDriver.this.update(db, collection, up.getQuery(), null, up.getCmd(), up.isMultiple(), up.isUpsert(), null, null);
                            continue;
                        }
                        if (r instanceof DeleteBulkRequest) {
                            InMemoryDriver.this.delete(db, collection, ((DeleteBulkRequest)r).getQuery(), null, ((DeleteBulkRequest)r).isMultiple(), null, null);
                            continue;
                        }
                        throw new RuntimeException("Unknown operation " + r.getClass().getName());
                    }
                }
                catch (MorphiumDriverException e) {
                    InMemoryDriver.this.log.error("Got exception: ", (Throwable)e);
                }
                return new Doc();
            }

            @Override
            public UpdateBulkRequest addUpdateBulkRequest() {
                UpdateBulkRequest up = new UpdateBulkRequest();
                this.requests.add(up);
                return up;
            }

            @Override
            public InsertBulkRequest addInsertBulkRequest(List<Map<String, Object>> toInsert) {
                InsertBulkRequest in = new InsertBulkRequest(toInsert);
                this.requests.add(in);
                return in;
            }

            @Override
            public DeleteBulkRequest addDeleteBulkRequest() {
                DeleteBulkRequest del = new DeleteBulkRequest();
                this.requests.add(del);
                return del;
            }
        };
    }

    @Override
    public Map<MorphiumDriver.DriverStatsKey, Double> getDriverStats() {
        HashMap<MorphiumDriver.DriverStatsKey, Double> ret = new HashMap<MorphiumDriver.DriverStatsKey, Double>();
        for (Map.Entry<MorphiumDriver.DriverStatsKey, AtomicDecimal> e : this.stats.entrySet()) {
            ret.put(e.getKey(), e.getValue().doubleValue());
        }
        ret.put(MorphiumDriver.DriverStatsKey.REPLY_IN_MEM, Double.valueOf(this.commandResults.size()));
        return ret;
    }

    public void createIndex(String db, String collection, Map<String, Object> indexDef, Map<String, Object> options) throws MorphiumDriverException {
        HashMap<String, Object> index = new HashMap<String, Object>(indexDef);
        index.put("$options", options);
        if (!options.containsKey("name")) {
            StringBuilder name = new StringBuilder();
            for (String k : index.keySet()) {
                if (k.startsWith("$")) continue;
                name.append(k + "_" + index.get(k).toString());
                name.append("_");
            }
            name.setLength(name.length() - 1);
            ((Map)index.get("$options")).put("name", name.toString());
        }
        List<Map<String, Object>> indexes = this.getIndexes(db, collection);
        boolean found = true;
        for (Map<String, Object> i : indexes) {
            found = true;
            if (i.size() - 1 != indexDef.size()) {
                found = false;
                continue;
            }
            for (Map.Entry<String, Object> e : indexDef.entrySet()) {
                if (e.getKey().startsWith("$") || i.containsKey(e.getKey()) && i.get(e.getKey()).equals(e.getValue())) continue;
                found = false;
                break;
            }
            if (!found) continue;
            break;
        }
        if (!found) {
            indexes.add(index);
        } else if (index.size() != 2 || !index.containsKey("_id") || index.containsKey("$options")) {
            // empty if block
        }
        this.updateIndexData(db, collection, options);
    }

    private void updateIndexData(String db, String collection, Map<String, Object> options) throws MorphiumDriverException {
        StringBuilder b = new StringBuilder();
        this.indexDataByDBCollection.putIfAbsent(db, new ConcurrentHashMap());
        this.indexDataByDBCollection.get(db).putIfAbsent(collection, new ConcurrentHashMap());
        this.indexDataByDBCollection.get(db).get(collection).clear();
        for (Map<String, Object> doc : this.getCollection(db, collection)) {
            for (Map<String, Object> idx : this.getIndexes(db, collection)) {
                b.setLength(0);
                int bucketId = 0;
                for (String k : idx.keySet()) {
                    if (k.equals("$options")) continue;
                    bucketId = this.iterateBucketId(bucketId, doc.get(k));
                    b.append(k);
                }
                Map<Integer, List<Map<String, Object>>> index = this.getIndexDataForCollection(db, collection, b.toString());
                index.putIfAbsent(bucketId, new CopyOnWriteArrayList());
                index.get(bucketId).add(doc);
            }
        }
    }

    public List<Map<String, Object>> mapReduce(String db, String collection, String mapping, String reducing) throws MorphiumDriverException {
        throw new FunctionNotSupportedException("no map reduce in memory");
    }

    public List<Map<String, Object>> mapReduce(String db, String collection, String mapping, String reducing, Map<String, Object> query) throws MorphiumDriverException {
        throw new FunctionNotSupportedException("no map reduce in memory");
    }

    public List<Map<String, Object>> mapReduce(String db, String collection, String mapping, String reducing, Map<String, Object> query, Map<String, Object> sorting, Collation collation) throws MorphiumDriverException {
        throw new FunctionNotSupportedException("no map reduce in memory");
    }

    @Override
    public void commitTransaction() {
        if (this.currentTransaction.get() == null) {
            throw new IllegalArgumentException("No transaction in progress");
        }
        InMemTransactionContext ctx = this.currentTransaction.get();
        this.database.putAll(ctx.getDatabase());
        this.currentTransaction.set(null);
    }

    @Override
    public void abortTransaction() {
        this.currentTransaction.set(null);
    }

    @Override
    public void setTransactionContext(MorphiumTransactionContext ctx) {
        this.currentTransaction.set((InMemTransactionContext)ctx);
    }

    public void writeDump(File f) {
    }

    public SSLContext getSslContext() {
        return null;
    }

    public void setSslContext(SSLContext sslContext) {
    }

    public boolean isSslInvalidHostNameAllowed() {
        return false;
    }

    public void setSslInvalidHostNameAllowed(boolean sslInvalidHostNameAllowed) {
    }

    @Override
    public int getIdleSleepTime() {
        return 0;
    }

    @Override
    public void setIdleSleepTime(int sl) {
    }

    private static /* synthetic */ boolean lambda$update$3(List v, Object object) {
        return v.contains(object);
    }

    private /* synthetic */ void lambda$connect$0() {
        try {
            List<Runnable> current = this.eventQueue;
            this.eventQueue = new CopyOnWriteArrayList<Runnable>();
            Collections.shuffle(current);
            for (Runnable r1 : current) {
                try {
                    r1.run();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static class InMemoryCursor {
        private int skip;
        private int limit;
        private int batchSize;
        private int dataRead = 0;
        private String db;
        private String collection;
        private Map<String, Object> query;
        private Map<String, Object> sort;
        private Map<String, Object> projection;
        private ReadPreference readPreference;
        private Map<String, Object> findMetaData;
        private Collation collation;

        private InMemoryCursor() {
        }

        public String getDb() {
            return this.db;
        }

        public void setDb(String db) {
            this.db = db;
        }

        public String getCollection() {
            return this.collection;
        }

        public void setCollection(String collection) {
            this.collection = collection;
        }

        public Map<String, Object> getQuery() {
            return this.query;
        }

        public void setQuery(Map<String, Object> query) {
            this.query = query;
        }

        public Map<String, Object> getSort() {
            return this.sort;
        }

        public void setSort(Map<String, Object> sort) {
            this.sort = sort;
        }

        public Map<String, Object> getProjection() {
            return this.projection;
        }

        public void setProjection(Map<String, Object> projection) {
            this.projection = projection;
        }

        public ReadPreference getReadPreference() {
            return this.readPreference;
        }

        public void setReadPreference(ReadPreference readPreference) {
            this.readPreference = readPreference;
        }

        public Map<String, Object> getFindMetaData() {
            return this.findMetaData;
        }

        public void setFindMetaData(Map<String, Object> findMetaData) {
            this.findMetaData = findMetaData;
        }

        public int getDataRead() {
            return this.dataRead;
        }

        public void setDataRead(int dataRead) {
            this.dataRead = dataRead;
        }

        public int getBatchSize() {
            return this.batchSize;
        }

        public void setBatchSize(int batchSize) {
            this.batchSize = batchSize;
        }

        public int getSkip() {
            return this.skip;
        }

        public void setSkip(int skip) {
            this.skip = skip;
        }

        public int getLimit() {
            return this.limit;
        }

        public void setLimit(int limit) {
            this.limit = limit;
        }

        public Collation getCollation() {
            return this.collation;
        }

        public void setCollation(Collation collation) {
            this.collation = collation;
        }
    }
}

