/*
 * Decompiled with CFR 0.152.
 */
package de.caluga.morphium.cache;

import de.caluga.morphium.Morphium;
import de.caluga.morphium.annotations.caching.Cache;
import de.caluga.morphium.cache.AbstractCacheSynchronizer;
import de.caluga.morphium.cache.CacheSyncVetoException;
import de.caluga.morphium.cache.WatchingCacheSyncListener;
import de.caluga.morphium.changestream.ChangeStreamEvent;
import de.caluga.morphium.changestream.ChangeStreamListener;
import de.caluga.morphium.changestream.ChangeStreamMonitor;
import java.util.Set;

public class WatchingCacheSynchronizer
extends AbstractCacheSynchronizer<WatchingCacheSyncListener>
implements ChangeStreamListener {
    private boolean running = true;
    private final ChangeStreamMonitor monitor;

    public WatchingCacheSynchronizer(Morphium m) {
        super(m);
        this.monitor = new ChangeStreamMonitor(m);
        this.monitor.addListener(this);
        this.monitor.start();
    }

    public void start() {
    }

    public void terminate() {
        this.running = false;
        this.monitor.terminate();
    }

    public boolean isActive() {
        return this.monitor.isRunning();
    }

    @Override
    public boolean incomingData(ChangeStreamEvent evt) {
        if (evt.getOperationType().equals("invalidate")) {
            return this.running;
        }
        Set<Class<?>> types = this.morphium.getCache().getCachedTypes();
        for (Class<?> t : types) {
            String s = this.morphium.getMapper().getCollectionName(t);
            if (!s.equals(evt.getCollectionName())) continue;
            Cache cache = this.morphium.getARHelper().getAnnotationFromHierarchy(t, Cache.class);
            if (cache != null) {
                Object id = evt.getDocumentKey();
                try {
                    this.firePreClearEvent(t);
                }
                catch (CacheSyncVetoException e) {
                    log.warn("Cache clear aborted due to Veto from Listener!");
                    break;
                }
                switch (cache.syncCache()) {
                    case CLEAR_TYPE_CACHE: {
                        this.morphium.getCache().clearCachefor(t);
                        break;
                    }
                    case REMOVE_ENTRY_FROM_TYPE_CACHE: {
                        this.morphium.getCache().removeEntryFromCache(t, id);
                        break;
                    }
                    case UPDATE_ENTRY: {
                        Object ent = this.morphium.getCache().getFromIDCache(t, id);
                        this.morphium.reread(ent);
                        break;
                    }
                }
            }
            this.firePostClearEvent(t);
            break;
        }
        return this.running;
    }
}

