/*
 * Decompiled with CFR 0.152.
 */
package de.caluga.morphium.messaging;

import de.caluga.morphium.driver.Doc;
import de.caluga.morphium.driver.MorphiumDriverException;
import de.caluga.morphium.driver.commands.MongoCommand;
import de.caluga.morphium.driver.commands.UpdateMongoCommand;
import de.caluga.morphium.driver.commands.WriteMongoCommand;
import de.caluga.morphium.messaging.Messaging;
import de.caluga.morphium.messaging.Msg;
import de.caluga.morphium.messaging.MsgLock;
import java.util.Map;
import org.slf4j.LoggerFactory;

public class MessageRejectedException
extends RuntimeException {
    private boolean continueProcessing;
    private boolean sendAnswer;
    private RejectionHandler handler = null;

    public MessageRejectedException(String reason) {
        this(reason, false, false);
    }

    public MessageRejectedException(String reason, boolean continueProcessing) {
        this(reason, continueProcessing, false);
    }

    public MessageRejectedException(String reason, boolean continueProcessing, boolean sendAnswer) {
        super(reason);
        this.continueProcessing = continueProcessing;
        this.sendAnswer = sendAnswer;
        this.handler = (msg, m) -> {
            if (this.isSendAnswer()) {
                Msg answer = new Msg(msg.getName(), "message rejected by listener", this.getMessage());
                m.sendAnswer(msg, answer);
            }
            if (this.isContinueProcessing()) {
                MongoCommand cmd = null;
                try {
                    if (!m.isExclusive()) {
                        cmd = new UpdateMongoCommand(msg.getMorphium().getDriver().getPrimaryConnection(msg.getMorphium().getWriteConcernForClass(Msg.class)));
                        ((UpdateMongoCommand)cmd.setColl(msg.getCollectionName())).setDb(msg.getMorphium().getDatabase());
                        ((UpdateMongoCommand)cmd).addUpdate(Doc.of("_id", m.getMsgId()), Doc.of("$addToSet", Doc.of("processed_by", msg.getSenderId())), null, false, false, null, null, null);
                        ((WriteMongoCommand)cmd).execute();
                    } else {
                        Map<String, Object> map = msg.getMorphium().createQueryFor(MsgLock.class, msg.getLockCollectionName()).f("_id").eq(m.getMsgId()).delete();
                    }
                }
                catch (MorphiumDriverException e) {
                    LoggerFactory.getLogger(msg.getClass()).error("Error unlocking message", (Throwable)e);
                }
                finally {
                    if (cmd != null) {
                        cmd.releaseConnection();
                    }
                }
                LoggerFactory.getLogger(msg.getClass()).debug(msg.getSenderId() + ": Message will be re-processed by others");
            }
        };
    }

    public MessageRejectedException setCustomRejectionHandler(RejectionHandler hdl) {
        this.handler = hdl;
        return this;
    }

    public RejectionHandler getRejectionHandler() {
        return this.handler;
    }

    public boolean isContinueProcessing() {
        return this.continueProcessing;
    }

    public MessageRejectedException setContinueProcessing(boolean continueProcessing) {
        this.continueProcessing = continueProcessing;
        return this;
    }

    public boolean isSendAnswer() {
        return this.sendAnswer;
    }

    public MessageRejectedException setSendAnswer(boolean sendAnswer) {
        this.sendAnswer = sendAnswer;
        return this;
    }

    public static interface RejectionHandler {
        public void handleRejection(Messaging var1, Msg var2) throws Exception;
    }
}

