/*
 * Decompiled with CFR 0.152.
 */
package de.caluga.morphium.driver.wire;

import de.caluga.morphium.Morphium;
import de.caluga.morphium.aggregation.Aggregator;
import de.caluga.morphium.aggregation.AggregatorImpl;
import de.caluga.morphium.driver.Doc;
import de.caluga.morphium.driver.MorphiumCursor;
import de.caluga.morphium.driver.MorphiumDriver;
import de.caluga.morphium.driver.MorphiumDriverException;
import de.caluga.morphium.driver.MorphiumTransactionContext;
import de.caluga.morphium.driver.ReadPreference;
import de.caluga.morphium.driver.ReadPreferenceType;
import de.caluga.morphium.driver.WriteConcern;
import de.caluga.morphium.driver.bulk.BulkRequest;
import de.caluga.morphium.driver.bulk.BulkRequestContext;
import de.caluga.morphium.driver.bulk.DeleteBulkRequest;
import de.caluga.morphium.driver.bulk.InsertBulkRequest;
import de.caluga.morphium.driver.bulk.UpdateBulkRequest;
import de.caluga.morphium.driver.commands.AbortTransactionCommand;
import de.caluga.morphium.driver.commands.CollStatsCommand;
import de.caluga.morphium.driver.commands.CommitTransactionCommand;
import de.caluga.morphium.driver.commands.CurrentOpCommand;
import de.caluga.morphium.driver.commands.DbStatsCommand;
import de.caluga.morphium.driver.commands.DeleteMongoCommand;
import de.caluga.morphium.driver.commands.HelloCommand;
import de.caluga.morphium.driver.commands.InsertMongoCommand;
import de.caluga.morphium.driver.commands.KillCursorsCommand;
import de.caluga.morphium.driver.commands.ListCollectionsCommand;
import de.caluga.morphium.driver.commands.MongoCommand;
import de.caluga.morphium.driver.commands.ReplicastStatusCommand;
import de.caluga.morphium.driver.commands.UpdateMongoCommand;
import de.caluga.morphium.driver.commands.WatchCommand;
import de.caluga.morphium.driver.wire.AtomicDecimal;
import de.caluga.morphium.driver.wire.DriverBase;
import de.caluga.morphium.driver.wire.HelloResult;
import de.caluga.morphium.driver.wire.MongoConnection;
import de.caluga.morphium.driver.wire.NetworkCallHelper;
import de.caluga.morphium.driver.wire.SingleMongoConnection;
import de.caluga.morphium.driver.wireprotocol.OpMsg;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PooledDriver
extends DriverBase {
    public static final String driverName = "PooledDriver";
    private Map<String, List<Connection>> connectionPool;
    private Map<Integer, Connection> borrowedConnections;
    private Map<MorphiumDriver.DriverStatsKey, AtomicDecimal> stats;
    private long fastestTime = 10000L;
    private int idleSleepTime = 5;
    private String fastestHost = "";
    private final Logger log = LoggerFactory.getLogger(PooledDriver.class);
    private String primaryNode;
    private ScheduledThreadPoolExecutor executor = new ScheduledThreadPoolExecutor(5, new ThreadFactory(){
        private AtomicLong l = new AtomicLong(0L);

        @Override
        public Thread newThread(Runnable r) {
            Thread ret = new Thread(r);
            ret.setName("MCon_" + this.l.incrementAndGet());
            ret.setDaemon(true);
            return ret;
        }
    });
    private int lastSecondaryNode;
    private ScheduledFuture<?> heartbeat;

    public PooledDriver() {
        this.connectionPool = new HashMap<String, List<Connection>>();
        this.borrowedConnections = Collections.synchronizedMap(new HashMap());
        this.stats = new ConcurrentHashMap<MorphiumDriver.DriverStatsKey, AtomicDecimal>();
        for (MorphiumDriver.DriverStatsKey e : MorphiumDriver.DriverStatsKey.values()) {
            this.stats.put(e, new AtomicDecimal(0));
        }
    }

    @Override
    public void connect(String replSet) throws MorphiumDriverException {
        int retries = 0;
        boolean connected = false;
        for (String host : new ArrayList<String>(this.getHostSeed())) {
            for (int i = 0; i < this.getMinConnectionsPerHost(); ++i) {
                while (true) {
                    try {
                        this.connectToHost(host);
                        connected = true;
                    }
                    catch (MorphiumDriverException e) {
                        if (++retries < this.getRetriesOnNetworkError()) {
                            this.log.error("Connection failed, retrying...");
                            try {
                                Thread.sleep(this.getSleepBetweenErrorRetries());
                            }
                            catch (InterruptedException interruptedException) {}
                            continue;
                        }
                        this.log.error("Could not connect to " + host);
                        this.getHostSeed().remove(host);
                    }
                    break;
                }
            }
        }
        if (!connected) {
            throw new MorphiumDriverException("Connection failed");
        }
        this.setReplicaSet(this.getHostSeed().size() > 1);
        this.startHeartbeat();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void connectToHost(String host) throws MorphiumDriverException {
        String h = this.getHost(host);
        int port = this.getPortFromHost(host);
        SingleMongoConnection con = new SingleMongoConnection();
        Connection theCon = new Connection(con);
        if (this.getAuthDb() != null) {
            con.setCredentials(this.getAuthDb(), this.getUser(), this.getPassword());
        }
        long start = System.currentTimeMillis();
        HelloResult hello = con.connect(this, h, port);
        this.stats.get((Object)MorphiumDriver.DriverStatsKey.CONNECTIONS_OPENED).incrementAndGet();
        long dur = System.currentTimeMillis() - start;
        if (this.fastestTime > dur) {
            this.fastestTime = dur;
            this.fastestHost = host;
        }
        Map<String, List<Connection>> map = this.connectionPool;
        synchronized (map) {
            this.connectionPool.putIfAbsent(host, new CopyOnWriteArrayList());
            this.connectionPool.get(host).add(theCon);
        }
        if (hello.getWritablePrimary().booleanValue()) {
            this.primaryNode = host;
        }
        this.handleHello(hello);
        this.setMaxBsonObjectSize(hello.getMaxBsonObjectSize());
        this.setMaxMessageSize(hello.getMaxMessageSizeBytes());
        this.setMaxWriteBatchSize(hello.getMaxWriteBatchSize());
    }

    private String getHost(String hostPort) {
        if (hostPort == null) {
            return "";
        }
        String[] h = hostPort.split(":");
        return h[0];
    }

    private int getPortFromHost(String host) {
        String[] h = host.split(":");
        if (h.length == 1) {
            return 27017;
        }
        return Integer.parseInt(h[1]);
    }

    @Override
    public void connect() throws MorphiumDriverException {
        this.connect(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleHello(HelloResult hello) {
        if (hello.getWritablePrimary().booleanValue() && hello.getMe() != null && !hello.getMe().equals(this.primaryNode)) {
            if (this.log.isDebugEnabled()) {
                this.log.debug(String.format("Primary failover? %s -> %s", this.primaryNode, hello.getMe()));
            }
            this.primaryNode = hello.getMe();
        }
        if (hello.getHosts() != null) {
            for (String hst : hello.getHosts()) {
                Map<String, List<Connection>> map = this.connectionPool;
                synchronized (map) {
                    if (!this.connectionPool.containsKey(hst)) {
                        this.log.debug("new host needs to be added: " + hst);
                        this.connectionPool.put(hst, new ArrayList());
                    }
                }
                if (this.getHostSeed().contains(hst)) continue;
                this.getHostSeed().add(hst);
            }
            for (String hst : new ArrayList<String>(this.getHostSeed())) {
                if (hello.getHosts().contains(hst)) continue;
                this.getHostSeed().remove(hst);
            }
            Map<String, List<Connection>> map = this.connectionPool;
            synchronized (map) {
                for (String k : new ArrayList<String>(this.connectionPool.keySet())) {
                    if (hello.getHosts().contains(k)) continue;
                    this.log.warn("Host " + k + " is not part of the replicaset anymore!");
                    this.getHostSeed().remove(k);
                    List<Connection> lst = this.connectionPool.remove(k);
                    if (this.fastestHost.equals(k)) {
                        this.fastestHost = null;
                        this.fastestTime = 10000L;
                    }
                    for (Connection con : lst) {
                        try {
                            con.getCon().close();
                            this.stats.get((Object)MorphiumDriver.DriverStatsKey.CONNECTIONS_CLOSED).incrementAndGet();
                        }
                        catch (Exception exception) {}
                    }
                }
            }
        }
    }

    protected synchronized void startHeartbeat() {
        if (this.heartbeat == null) {
            this.heartbeat = this.executor.scheduleWithFixedDelay(this::lambda$startHeartbeat$0, 0L, this.getHeartbeatFrequency(), TimeUnit.MILLISECONDS);
        } else {
            this.log.debug("Heartbeat already scheduled...");
        }
    }

    @Override
    public void watch(WatchCommand settings) throws MorphiumDriverException {
        MongoConnection con = null;
        try {
            con = this.getPrimaryConnection(null);
            con.watch(settings);
        }
        finally {
            if (con != null) {
                this.releaseConnection(con);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getTotalConnectionsToHost(String h) {
        int borrowed = 0;
        ArrayList<Connection> values = new ArrayList<Connection>(this.borrowedConnections.values());
        for (Connection c : values) {
            if (!c.getCon().getConnectedTo().equals(h)) continue;
            ++borrowed;
        }
        Map<String, List<Connection>> map = this.connectionPool;
        synchronized (map) {
            if (this.connectionPool.get(h) == null) {
                return borrowed;
            }
            return borrowed + this.connectionPool.get(h).size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized MongoConnection borrowConnection(String host) throws MorphiumDriverException {
        Map<String, List<Connection>> map;
        Connection c = null;
        while (true) {
            if (this.connectionPool.get(host) == null || this.connectionPool.get(host).size() == 0) {
                long start = System.currentTimeMillis();
                while (this.getTotalConnectionsToHost(host) > this.getMaxConnectionsPerHost()) {
                    if (System.currentTimeMillis() - start > (long)this.getMaxWaitTime()) {
                        this.log.error("maxwaitTime exceeded while waiting for a connection - connectionpool exceeded! " + this.getMaxWaitTime() + "ms");
                        throw new MorphiumDriverException("Could not get connection in time: " + this.getMaxWaitTime() + "ms");
                    }
                    Map<String, List<Connection>> map2 = this.connectionPool;
                    synchronized (map2) {
                        if (this.connectionPool.get(host).size() != 0) {
                            c = this.connectionPool.get(host).remove(0);
                        }
                    }
                    if (c != null) {
                        map2 = this.connectionPool;
                        synchronized (map2) {
                            this.borrowedConnections.put(c.getCon().getSourcePort(), c);
                        }
                        this.stats.get((Object)MorphiumDriver.DriverStatsKey.CONNECTIONS_BORROWED).incrementAndGet();
                        return c.getCon();
                    }
                    try {
                        Thread.sleep(this.idleSleepTime);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                String h = this.getHost(host);
                int port = this.getPortFromHost(host);
                SingleMongoConnection con = new SingleMongoConnection();
                if (this.getAuthDb() != null) {
                    con.setCredentials(this.getAuthDb(), this.getUser(), this.getPassword());
                }
                c = new Connection(con);
                HelloResult hello = con.connect(this, h, port);
                if (hello == null) {
                    throw new MorphiumDriverException("Could not create connection");
                }
                Map<String, List<Connection>> map3 = this.connectionPool;
                synchronized (map3) {
                    this.borrowedConnections.put(con.getSourcePort(), c);
                }
                this.stats.get((Object)MorphiumDriver.DriverStatsKey.CONNECTIONS_OPENED).incrementAndGet();
                return con;
            }
            map = this.connectionPool;
            synchronized (map) {
                if (this.connectionPool.get(host).size() != 0) {
                    try {
                        c = this.connectionPool.get(host).remove(0);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    while (c == null && this.connectionPool.get(host).size() != 0) {
                        c = this.connectionPool.get(host).remove(0);
                    }
                    break;
                }
            }
        }
        if (c == null) {
            this.log.error("Could not get connection!?!?");
            return null;
        }
        map = this.connectionPool;
        synchronized (map) {
            if (this.borrowedConnections.containsKey(c.getCon().getSourcePort())) {
                this.log.error("Re-borrowing same connection?!?!?! recursing...!");
                return this.borrowConnection(host);
            }
            this.borrowedConnections.put(c.getCon().getSourcePort(), c);
        }
        this.stats.get((Object)MorphiumDriver.DriverStatsKey.CONNECTIONS_BORROWED).incrementAndGet();
        return c.getCon();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MongoConnection getReadConnection(ReadPreference rp) {
        try {
            if (this.getHostSeed().size() == 1 || !this.isReplicaSet()) {
                return this.borrowConnection(this.primaryNode);
            }
            if (rp == null) {
                rp = this.getDefaultReadPreference();
            }
            ReadPreferenceType type = rp.getType();
            if (this.isTransactionInProgress()) {
                type = ReadPreferenceType.PRIMARY;
            }
            switch (type) {
                case PRIMARY: {
                    return this.borrowConnection(this.primaryNode);
                }
                case NEAREST: {
                    if (this.fastestHost != null) {
                        try {
                            return this.borrowConnection(this.fastestHost);
                        }
                        catch (MorphiumDriverException e) {
                            this.log.warn("Could not get connection to fastest host, trying primary", (Throwable)e);
                        }
                    }
                }
                case PRIMARY_PREFERRED: {
                    Map<String, List<Connection>> e = this.connectionPool;
                    synchronized (e) {
                        if (this.connectionPool.get(this.primaryNode).size() != 0) {
                            try {
                                return this.borrowConnection(this.primaryNode);
                            }
                            catch (MorphiumDriverException e2) {
                                this.log.warn("Could not get connection to " + this.primaryNode + " trying secondary");
                            }
                        }
                    }
                }
                case SECONDARY_PREFERRED: 
                case SECONDARY: {
                    int retry = 0;
                    while (true) {
                        if (this.lastSecondaryNode >= this.getHostSeed().size()) {
                            this.lastSecondaryNode = 0;
                            ++retry;
                        }
                        if (this.getHostSeed().get(this.lastSecondaryNode).equals(this.primaryNode)) {
                            ++this.lastSecondaryNode;
                            if (this.lastSecondaryNode > this.getHostSeed().size()) {
                                this.lastSecondaryNode = 0;
                                ++retry;
                            }
                        }
                        String host = this.getHostSeed().get(this.lastSecondaryNode++);
                        try {
                            return this.borrowConnection(host);
                        }
                        catch (MorphiumDriverException e) {
                            if (retry > this.getRetriesOnNetworkError()) {
                                this.log.error("Could not get Connection - abort");
                                throw e;
                            }
                            this.log.warn(String.format("could not get connection to secondary node '%s'- trying other replicaset node", host));
                            this.getHostSeed().remove(this.lastSecondaryNode - 1);
                            try {
                                Thread.sleep(this.getSleepBetweenErrorRetries());
                            }
                            catch (InterruptedException interruptedException) {}
                            continue;
                        }
                        break;
                    }
                }
            }
            throw new IllegalArgumentException("Unhandeled Readpreferencetype " + String.valueOf((Object)rp.getType()));
        }
        catch (MorphiumDriverException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public synchronized MongoConnection getPrimaryConnection(WriteConcern wc) throws MorphiumDriverException {
        if (this.primaryNode == null) {
            throw new MorphiumDriverException("No primary node found - connection not established yet?");
        }
        return this.borrowConnection(this.primaryNode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void closeConnection(MongoConnection con) {
        this.releaseConnection(con);
        Map<String, List<Connection>> map = this.connectionPool;
        synchronized (map) {
            for (String k : this.connectionPool.keySet()) {
                for (Connection c : new ArrayList(this.connectionPool.get(k))) {
                    if (c.getCon() != con) continue;
                    this.connectionPool.get(k).remove(c);
                    return;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<Integer, Connection> getBorrowedConnections() {
        Map<String, List<Connection>> map = this.connectionPool;
        synchronized (map) {
            return new HashMap<Integer, Connection>(this.borrowedConnections);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void releaseConnection(MongoConnection con) {
        if (con == null) {
            return;
        }
        if (this.heartbeat == null) {
            return;
        }
        if (!(con instanceof SingleMongoConnection)) {
            throw new IllegalArgumentException("Got connection of wrong type back!");
        }
        if (con.getSourcePort() != 0) {
            Connection c = this.borrowedConnections.remove(con.getSourcePort());
            if (c == null) {
                if (con.isConnected()) {
                    c = new Connection((SingleMongoConnection)con);
                } else {
                    return;
                }
            }
            if (con.getConnectedTo() != null) {
                Map<String, List<Connection>> map = this.connectionPool;
                synchronized (map) {
                    this.connectionPool.putIfAbsent(con.getConnectedTo(), new CopyOnWriteArrayList());
                    this.connectionPool.get(con.getConnectedTo()).add(0, c);
                }
            }
        }
        this.stats.get((Object)MorphiumDriver.DriverStatsKey.CONNECTIONS_RELEASED).incrementAndGet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isConnected() {
        Map<String, List<Connection>> map = this.connectionPool;
        synchronized (map) {
            for (String c : this.connectionPool.keySet()) {
                if (this.getTotalConnectionsToHost(c) == 0) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public int getIdleSleepTime() {
        return this.idleSleepTime;
    }

    @Override
    public void setIdleSleepTime(int sl) {
        this.idleSleepTime = sl;
    }

    @Override
    public <T, R> Aggregator<T, R> createAggregator(Morphium morphium, Class<? extends T> type, Class<? extends R> resultType) {
        return new AggregatorImpl<T, R>(morphium, type, resultType);
    }

    @Override
    public String getName() {
        return driverName;
    }

    @Override
    public void setConnectionUrl(String connectionUrl) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        if (this.heartbeat != null) {
            this.heartbeat.cancel(true);
        }
        this.heartbeat = null;
        Map<String, List<Connection>> map = this.connectionPool;
        synchronized (map) {
            for (Map.Entry<String, List<Connection>> e : new ArrayList<Map.Entry<String, List<Connection>>>(this.connectionPool.entrySet())) {
                for (Connection c : new ArrayList(e.getValue())) {
                    try {
                        c.getCon().close();
                        this.stats.get((Object)MorphiumDriver.DriverStatsKey.CONNECTIONS_CLOSED).incrementAndGet();
                    }
                    catch (Exception exception) {}
                }
                this.connectionPool.get(e.getKey()).clear();
            }
        }
    }

    protected void killCursors(String db, String coll, long ... ids) throws MorphiumDriverException {
        ArrayList<Long> cursorIds = new ArrayList<Long>();
        for (long l : ids) {
            if (l == 0L) continue;
            cursorIds.add(l);
        }
        if (cursorIds.isEmpty()) {
            return;
        }
        KillCursorsCommand k = (KillCursorsCommand)((KillCursorsCommand)new KillCursorsCommand(null).setCursors(cursorIds).setDb(db)).setColl(coll);
        Map<String, Object> ret = k.execute();
        this.log.debug("killed cursor");
    }

    @Override
    public void commitTransaction() throws MorphiumDriverException {
        if (this.getTransactionContext() == null) {
            throw new IllegalArgumentException("No transaction in progress, cannot commit");
        }
        MorphiumTransactionContext ctx = this.getTransactionContext();
        MongoConnection con = this.getPrimaryConnection(null);
        CommitTransactionCommand cmd = new CommitTransactionCommand(con).setTxnNumber(ctx.getTxnNumber()).setAutocommit(false).setLsid(ctx.getLsid());
        cmd.execute();
        this.clearTransactionContext();
        this.releaseConnection(con);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void abortTransaction() throws MorphiumDriverException {
        if (this.getTransactionContext() == null) {
            throw new IllegalArgumentException("No transaction in progress, cannot abort");
        }
        MongoConnection con = this.getPrimaryConnection(null);
        try {
            MorphiumTransactionContext ctx = this.getTransactionContext();
            AbortTransactionCommand cmd = new AbortTransactionCommand(con).setTxnNumber(ctx.getTxnNumber()).setAutocommit(false).setLsid(ctx.getLsid());
            cmd.execute();
        }
        finally {
            this.releaseConnection(con);
            this.clearTransactionContext();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, Object> getReplsetStatus() throws MorphiumDriverException {
        MongoConnection con = null;
        try {
            con = this.getPrimaryConnection(null);
            ReplicastStatusCommand cmd = new ReplicastStatusCommand(con);
            Map<String, Object> result = cmd.execute();
            List mem = (List)result.get("members");
            if (mem == null) {
                Map<String, Object> map = null;
                return map;
            }
            mem.stream().filter(d -> d.get("optime") instanceof Map).forEach(d -> d.put("optime", ((Map)d.get("optime")).get("ts")));
            Map<String, Object> map = result;
            return map;
        }
        finally {
            this.releaseConnection(con);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, Object> getDBStats(String db) throws MorphiumDriverException {
        MongoConnection con = null;
        try {
            con = this.getPrimaryConnection(null);
            Map<String, Object> map = ((DbStatsCommand)new DbStatsCommand(con).setDb(db)).execute();
            return map;
        }
        finally {
            this.releaseConnection(con);
        }
    }

    @Override
    public Map<String, Object> getCollStats(String db, String coll) throws MorphiumDriverException {
        CollStatsCommand cmd = (CollStatsCommand)((CollStatsCommand)new CollStatsCommand(this.getPrimaryConnection(null)).setColl(coll)).setDb(db);
        return cmd.execute();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Map<String, Object>> currentOp(int threshold) throws MorphiumDriverException {
        MongoCommand cmd = null;
        try {
            cmd = ((CurrentOpCommand)new CurrentOpCommand(this.getPrimaryConnection(null)).setColl("admin")).setSecsRunning(threshold);
            List<Map<String, Object>> list = ((CurrentOpCommand)cmd).execute();
            return list;
        }
        finally {
            if (cmd != null) {
                cmd.releaseConnection();
            }
        }
    }

    public void closeIteration(MorphiumCursor crs) throws MorphiumDriverException {
        if (crs == null) {
            return;
        }
        this.killCursors(crs.getDb(), crs.getCollection(), crs.getCursorId());
    }

    public Map<String, Object> getDbStats(String db, boolean withStorage) throws MorphiumDriverException {
        return (Map)new NetworkCallHelper().doCall(() -> {
            OpMsg msg = new OpMsg();
            msg.setMessageId(this.getNextId());
            Doc v = Doc.of("dbStats", (Object)1, "scale", (Object)1024);
            v.put("$db", db);
            if (withStorage) {
                v.put("freeStorage", 1);
            }
            msg.setFirstDoc(v);
            OpMsg reply = null;
            return reply.getFirstDoc();
        }, this.getRetriesOnNetworkError(), this.getSleepBetweenErrorRetries());
    }

    @Override
    public boolean exists(String db) throws MorphiumDriverException {
        try {
            this.getDBStats(db);
            return true;
        }
        catch (MorphiumDriverException morphiumDriverException) {
            return false;
        }
    }

    public Map<String, Object> getDbStats(String db) throws MorphiumDriverException {
        return this.getDbStats(db, false);
    }

    private List<Map<String, Object>> getCollectionInfo(String db, String collection) throws MorphiumDriverException {
        return (List)new NetworkCallHelper().doCall(() -> {
            MongoConnection con = this.getReadConnection(null);
            ListCollectionsCommand cmd = new ListCollectionsCommand(con);
            cmd.setDb(db);
            cmd.setFilter(Doc.of("name", collection));
            List<Map<String, Object>> ret = cmd.execute();
            return ret;
        }, this.getRetriesOnNetworkError(), this.getSleepBetweenErrorRetries());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized Map<String, Integer> getNumConnectionsByHost() {
        HashMap<String, Integer> ret = new HashMap<String, Integer>();
        Map<String, List<Connection>> map = this.connectionPool;
        synchronized (map) {
            for (Map.Entry<String, List<Connection>> e : this.connectionPool.entrySet()) {
                ret.put(e.getKey(), e.getValue().size());
            }
        }
        for (Connection e : this.borrowedConnections.values()) {
            ret.put(e.getCon().getConnectedTo(), (Integer)ret.get(e.getCon().getConnectedTo()) + 1);
        }
        return ret;
    }

    @Override
    public boolean isCapped(String db, String coll) throws MorphiumDriverException {
        List<Map<String, Object>> lst = this.getCollectionInfo(db, coll);
        try {
            if (!lst.isEmpty() && lst.get(0).get("name").equals(coll)) {
                Object capped = ((Map)lst.get(0).get("options")).get("capped");
                return capped != null && capped.equals(true);
            }
        }
        catch (Exception e) {
            this.log.error("Error", (Throwable)e);
        }
        return false;
    }

    @Override
    public BulkRequestContext createBulkContext(Morphium m, final String db, final String collection, boolean ordered, WriteConcern wc) {
        return new BulkRequestContext(m){
            private final List<BulkRequest> requests;
            {
                super(m);
                this.requests = new ArrayList<BulkRequest>();
            }

            public Doc execute() {
                try {
                    for (BulkRequest r : this.requests) {
                        if (r instanceof InsertBulkRequest) {
                            InsertMongoCommand settings = new InsertMongoCommand(PooledDriver.this.getPrimaryConnection(null));
                            ((InsertMongoCommand)((InsertMongoCommand)settings.setDb(db)).setColl(collection)).setComment("Bulk insert").setDocuments(((InsertBulkRequest)r).getToInsert());
                            settings.execute();
                            settings.releaseConnection();
                            continue;
                        }
                        if (r instanceof UpdateBulkRequest) {
                            UpdateBulkRequest up = (UpdateBulkRequest)r;
                            UpdateMongoCommand upCmd = new UpdateMongoCommand(PooledDriver.this.getPrimaryConnection(null));
                            ((UpdateMongoCommand)((UpdateMongoCommand)upCmd.setColl(collection)).setDb(db)).setUpdates(Arrays.asList(Doc.of("q", up.getQuery(), "u", up.getCmd(), "upsert", (Object)up.isUpsert(), "multi", (Object)up.isMultiple())));
                            upCmd.execute();
                            upCmd.releaseConnection();
                            continue;
                        }
                        if (r instanceof DeleteBulkRequest) {
                            DeleteBulkRequest dbr = (DeleteBulkRequest)r;
                            DeleteMongoCommand del = new DeleteMongoCommand(PooledDriver.this.getPrimaryConnection(null));
                            ((DeleteMongoCommand)((DeleteMongoCommand)del.setColl(collection)).setDb(db)).setDeletes(Arrays.asList(Doc.of("q", dbr.getQuery(), "limit", (Object)(dbr.isMultiple() ? 0 : 1))));
                            del.execute();
                            del.releaseConnection();
                            continue;
                        }
                        throw new RuntimeException("Unknown operation " + r.getClass().getName());
                    }
                }
                catch (MorphiumDriverException e) {
                    PooledDriver.this.log.error("Got exception: ", (Throwable)e);
                }
                return new Doc();
            }

            @Override
            public UpdateBulkRequest addUpdateBulkRequest() {
                UpdateBulkRequest up = new UpdateBulkRequest();
                this.requests.add(up);
                return up;
            }

            @Override
            public InsertBulkRequest addInsertBulkRequest(List<Map<String, Object>> toInsert) {
                InsertBulkRequest in = new InsertBulkRequest(toInsert);
                this.requests.add(in);
                return in;
            }

            @Override
            public DeleteBulkRequest addDeleteBulkRequest() {
                DeleteBulkRequest del = new DeleteBulkRequest();
                this.requests.add(del);
                return del;
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<MorphiumDriver.DriverStatsKey, Double> getDriverStats() {
        HashMap<MorphiumDriver.DriverStatsKey, Double> m = new HashMap<MorphiumDriver.DriverStatsKey, Double>();
        for (Map.Entry<MorphiumDriver.DriverStatsKey, AtomicDecimal> e : this.stats.entrySet()) {
            m.put(e.getKey(), e.getValue().get());
        }
        Map<String, List<Connection>> map = this.connectionPool;
        synchronized (map) {
            for (List<Connection> l : this.connectionPool.values()) {
                m.put(MorphiumDriver.DriverStatsKey.CONNECTIONS_IN_POOL, (Double)m.get((Object)MorphiumDriver.DriverStatsKey.CONNECTIONS_IN_POOL) + (double)l.size());
                for (Connection con : l) {
                    for (Map.Entry<MorphiumDriver.DriverStatsKey, Double> entry : con.getCon().getStats().entrySet()) {
                        m.put(entry.getKey(), (Double)m.get((Object)entry.getKey()) + entry.getValue());
                    }
                }
            }
        }
        m.put(MorphiumDriver.DriverStatsKey.CONNECTIONS_IN_USE, Double.valueOf(this.borrowedConnections.size()));
        return m;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private /* synthetic */ void lambda$startHeartbeat$0() {
        block27: {
            try lbl-1000:
            // 3 sources

            {
                for (String hst : new ArrayList<String>(this.getHostSeed())) {
                    c = null;
                    var4_5 = this.connectionPool;
                    synchronized (var4_5) {
                        if (this.connectionPool.get(hst) != null && !this.connectionPool.get(hst).isEmpty()) {
                            c = this.connectionPool.get(hst).remove(0);
                        }
                        ** if (c == null) goto lbl24
                    }
lbl-1000:
                    // 1 sources

                    {
                        if (System.currentTimeMillis() - c.getCreated() > (long)this.getMaxConnectionLifetime()) {
                            this.log.debug("Lifetime exceeded...host: " + hst);
                            c.getCon().close();
                            this.stats.get((Object)MorphiumDriver.DriverStatsKey.CONNECTIONS_CLOSED).incrementAndGet();
                        } else if (System.currentTimeMillis() - c.getLastUsed() > (long)this.getMaxConnectionIdleTime()) {
                            this.log.debug("Unused connection to " + hst + " closed");
                            c.getCon().close();
                            this.stats.get((Object)MorphiumDriver.DriverStatsKey.CONNECTIONS_CLOSED).incrementAndGet();
                        } else {
                            var4_5 = this.connectionPool;
                            synchronized (var4_5) {
                                this.connectionPool.get(hst).add(0, c);
                            }
                        }
                    }
lbl24:
                    // 4 sources

                    h = new HelloCommand(this.borrowConnection(hst)).setHelloOk(true).setIncludeClient(false);
                    try {
                        start = System.currentTimeMillis();
                        hello = h.execute();
                        h.releaseConnection();
                        dur = System.currentTimeMillis() - start;
                        if (dur < this.fastestTime) {
                            this.fastestTime = dur;
                            this.fastestHost = hst;
                        }
                        if (hello == null || !hello.getWritablePrimary().booleanValue()) break block27;
                        this.handleHello(hello);
                        break block27;
                    }
                    catch (Throwable ex) {
                        if (ex.getMessage().contains("closed")) break block27;
                        this.log.error("Error talking to " + hst, ex);
                        try {
                            c.getCon().close();
                            this.stats.get((Object)MorphiumDriver.DriverStatsKey.CONNECTIONS_CLOSED).incrementAndGet();
                        }
                        catch (Exception var6_10) {
                            // empty catch block
                        }
                        break block27;
                    }
                    finally {
                        h.releaseConnection();
                    }
                }
                return;
            }
            catch (Exception e) {
                this.log.error("Error during heartbeat", (Throwable)e);
                return;
            }
        }
        while (this.getTotalConnectionsToHost(hst) < this.getMinConnectionsPerHost()) {
            try {
                this.connectToHost(hst);
            }
            catch (MorphiumDriverException ex) {
                this.log.error("Could not fill connection pool for " + hst, (Throwable)ex);
                this.getHostSeed().remove(hst);
                var6_9 = this.connectionPool;
                synchronized (var6_9) {
                    if (this.connectionPool.get(hst).size() == 0) {
                        this.connectionPool.remove(hst);
                    }
                    ** GOTO lbl-1000
                }
            }
        }
        ** GOTO lbl-1000
    }

    private class Connection {
        private SingleMongoConnection con;
        private long created;
        private long lastUsed;

        public Connection(SingleMongoConnection con) {
            this.con = con;
            this.created = System.currentTimeMillis();
            this.lastUsed = System.currentTimeMillis();
        }

        public void touch() {
            this.lastUsed = System.currentTimeMillis();
        }

        public SingleMongoConnection getCon() {
            return this.con;
        }

        public Connection setCon(SingleMongoConnection con) {
            this.con = con;
            return this;
        }

        public long getCreated() {
            return this.created;
        }

        public Connection setCreated(long created) {
            this.created = created;
            return this;
        }

        public long getLastUsed() {
            return this.lastUsed;
        }

        public Connection setLastUsed(long lastUsed) {
            this.lastUsed = lastUsed;
            return this;
        }
    }
}

