/*
 * Decompiled with CFR 0.152.
 */
package de.caluga.morphium.driver.inmem;

import de.caluga.morphium.Collation;
import de.caluga.morphium.MongoType;
import de.caluga.morphium.aggregation.Expr;
import de.caluga.morphium.driver.Doc;
import de.caluga.morphium.driver.MorphiumId;
import java.math.BigDecimal;
import java.text.Collator;
import java.text.ParseException;
import java.text.RuleBasedCollator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.regex.Pattern;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import org.bson.types.ObjectId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryHelper {
    private static final Logger log = LoggerFactory.getLogger(QueryHelper.class);

    public static boolean matchesQuery(Map<String, Object> query, Map<String, Object> toCheck, Map<String, Object> collation) {
        if (query.isEmpty()) {
            return true;
        }
        boolean ret = false;
        Iterator<String> iterator = query.keySet().iterator();
        block79: while (iterator.hasNext()) {
            String keyQuery;
            switch (keyQuery = iterator.next()) {
                case "$and": {
                    List lst = (List)query.get(keyQuery);
                    for (Map q : lst) {
                        if (QueryHelper.matchesQuery(q, toCheck, collation)) continue;
                        return false;
                    }
                    return true;
                }
                case "$or": {
                    List lst = (List)query.get(keyQuery);
                    for (Map q : lst) {
                        if (!QueryHelper.matchesQuery(q, toCheck, collation)) continue;
                        return true;
                    }
                    return false;
                }
                case "$not": {
                    return !QueryHelper.matchesQuery((Map)query.get(keyQuery), toCheck, collation);
                }
                case "$nor": {
                    List lst = (List)query.get(keyQuery);
                    for (Map q : lst) {
                        if (!QueryHelper.matchesQuery(q, toCheck, collation)) continue;
                        return false;
                    }
                    return true;
                }
                case "$expr": {
                    Expr expr = Expr.parse(query.get(keyQuery));
                    Object result = expr.evaluate(toCheck);
                    if (result instanceof Expr) {
                        result = ((Expr)result).evaluate(toCheck);
                    }
                    return Boolean.TRUE.equals(result);
                }
                case "$where": {
                    ret = QueryHelper.runWhere(query, toCheck);
                    continue block79;
                }
            }
            if (query.get(keyQuery) instanceof Map) {
                Map commandMap = (Map)query.get(keyQuery);
                Iterator it = commandMap.keySet().iterator();
                String commandKey = (String)it.next();
                while (commandKey.equals("$options") && it.hasNext()) {
                    commandKey = (String)it.next();
                }
                if (keyQuery.equals("$expr")) {
                    Expr e = Expr.parse(commandMap);
                    return Boolean.TRUE.equals(e.evaluate(toCheck));
                }
                Collator coll = null;
                if (collation != null && !collation.isEmpty()) {
                    coll = QueryHelper.getCollator(collation);
                }
                Object checkValue = toCheck;
                if (keyQuery.contains(".")) {
                    Object pth = keyQuery.split("\\.");
                    checkValue = toCheck;
                    for (Iterator<Map> p : pth) {
                        if (checkValue != null) {
                            if (checkValue instanceof Map) {
                                checkValue = checkValue.get(p);
                                continue;
                            }
                            if (!(checkValue instanceof List)) continue;
                            try {
                                int idx = Integer.valueOf(p);
                                checkValue = ((List)checkValue).get(Integer.valueOf(p));
                                continue;
                            }
                            catch (Exception e) {
                                ArrayList lst = new ArrayList();
                                for (Object o : (List)checkValue) {
                                    if (!(o instanceof Map)) continue;
                                    lst.add(((Map)o).get(p));
                                }
                                checkValue = lst;
                            }
                        }
                        break;
                    }
                } else {
                    checkValue = toCheck.get(keyQuery);
                }
                switch (commandKey) {
                    case "$where": {
                        return QueryHelper.runWhere(query, toCheck);
                    }
                    case "$eq": {
                        if (checkValue == null && commandMap.get(commandKey) == null) {
                            return true;
                        }
                        if (checkValue != null && commandMap.get(commandKey) == null) {
                            return false;
                        }
                        if (checkValue == null && commandMap.get(commandKey) != null) {
                            return false;
                        }
                        if (coll != null && checkValue instanceof String) {
                            return coll.equals((String)checkValue, (String)commandMap.get(commandKey));
                        }
                        if (checkValue instanceof List) {
                            return ((List)checkValue).contains(commandMap.get(commandKey));
                        }
                        return checkValue.equals(commandMap.get(commandKey));
                    }
                    case "$lte": 
                    case "$lt": {
                        List<Map> lst = null;
                        int offset = 0;
                        if (commandKey.equals("$lt")) {
                            offset = -1;
                        }
                        if ((lst = checkValue instanceof List ? (List<Map>)checkValue : (checkValue != null ? List.of(checkValue) : null)) == null || checkValue == null) {
                            return true;
                        }
                        for (Map cv : lst) {
                            if (coll != null && cv instanceof String) {
                                if (coll.compare(cv, commandMap.get(commandKey)) > offset) continue;
                                return true;
                            }
                            if (cv == null) {
                                return commandMap.get(commandKey) != null;
                            }
                            if (cv instanceof Number && commandMap.get(commandKey) instanceof Number) {
                                if (Double.valueOf(((Number)((Object)cv)).doubleValue()).compareTo(((Number)commandMap.get(commandKey)).doubleValue()) > offset) continue;
                                return true;
                            }
                            try {
                                if (((Comparable)((Object)cv)).compareTo(commandMap.get(commandKey)) > offset) continue;
                                return true;
                            }
                            catch (Exception e) {
                            }
                        }
                        return false;
                    }
                    case "$gte": 
                    case "$gt": {
                        List<Map> lst = null;
                        int offset = 0;
                        if (commandKey.equals("$gt")) {
                            offset = 1;
                        }
                        lst = checkValue instanceof List ? (List<Map>)checkValue : List.of(checkValue);
                        for (Map cv : lst) {
                            if (coll != null && cv instanceof String) {
                                if (coll.compare(cv, commandMap.get(commandKey)) < offset) continue;
                                return true;
                            }
                            if (cv == null) {
                                return commandMap.get(commandKey) != null;
                            }
                            if (cv instanceof Number && commandMap.get(commandKey) instanceof Number) {
                                if (Double.valueOf(((Number)((Object)cv)).doubleValue()).compareTo(((Number)commandMap.get(commandKey)).doubleValue()) < offset) continue;
                                return true;
                            }
                            try {
                                if (((Comparable)((Object)cv)).compareTo(commandMap.get(commandKey)) < offset) continue;
                                return true;
                            }
                            catch (Exception e) {
                            }
                        }
                        return false;
                    }
                    case "$mod": {
                        Number n = (Number)checkValue;
                        List arr = (List)commandMap.get(commandKey);
                        int div = (Integer)arr.get(0);
                        int rem = (Integer)arr.get(1);
                        return n.intValue() % div == rem;
                    }
                    case "$ne": {
                        boolean contains = false;
                        if (checkValue instanceof List) {
                            List chk = Collections.synchronizedList(new CopyOnWriteArrayList((List)checkValue));
                            for (Object o : chk) {
                                if (coll != null && o instanceof String && coll.equals((String)o, (String)commandMap.get(commandKey))) {
                                    contains = true;
                                    break;
                                }
                                if (o == null || commandMap.get(commandKey) == null || !o.equals(commandMap.get(commandKey))) continue;
                                contains = true;
                                break;
                            }
                            return !contains;
                        }
                        if (checkValue == null && commandMap.get(commandKey) != null) {
                            return true;
                        }
                        if (checkValue == null && commandMap.get(commandKey) == null) {
                            return false;
                        }
                        if (coll != null && checkValue instanceof String) {
                            return coll.compare(checkValue, commandMap.get(commandKey)) != 0;
                        }
                        if (checkValue instanceof List) {
                            return !((List)checkValue).contains(commandMap.get(commandKey));
                        }
                        return !checkValue.equals(commandMap.get(commandKey));
                    }
                    case "$exists": {
                        boolean exists;
                        boolean bl = exists = checkValue != null;
                        if (exists && checkValue instanceof List) {
                            boolean bl2 = exists = !((List)checkValue).isEmpty();
                        }
                        if (commandMap.get(commandKey).equals(Boolean.TRUE) || commandMap.get(commandKey).equals("true") || commandMap.get(commandKey).equals(1)) {
                            return exists;
                        }
                        return !exists;
                    }
                    case "$nin": {
                        boolean found = false;
                        block89: for (Object v : (List)commandMap.get(commandKey)) {
                            if (v instanceof MorphiumId) {
                                v = new ObjectId(v.toString());
                            }
                            if (checkValue == null) {
                                if (v != null) continue;
                                found = true;
                                continue;
                            }
                            if (coll != null && checkValue instanceof String && coll.equals((String)toCheck.get(keyQuery), (String)v)) {
                                found = true;
                                break;
                            }
                            if (checkValue instanceof MorphiumId && v instanceof ObjectId && checkValue.toString().equals(v.toString())) {
                                found = true;
                                break;
                            }
                            if (checkValue.equals(v)) {
                                found = true;
                                break;
                            }
                            if (!(checkValue instanceof List)) continue;
                            for (Object v2 : (List)checkValue) {
                                if (coll != null && coll.equals((String)v2, (String)v)) {
                                    found = true;
                                    continue block89;
                                }
                                if (!v2.equals(v)) continue;
                                found = true;
                                continue block89;
                            }
                        }
                        return !found;
                    }
                    case "$in": {
                        for (Object v : (List)commandMap.get(commandKey)) {
                            if (v instanceof MorphiumId) {
                                v = new ObjectId(v.toString());
                            }
                            if (checkValue == null && v == null) {
                                return true;
                            }
                            if (coll != null && checkValue instanceof String && coll.equals((String)toCheck.get(keyQuery), (String)v)) {
                                return true;
                            }
                            if (checkValue != null && toCheck.get(keyQuery).equals(v)) {
                                return true;
                            }
                            if (checkValue == null || !(toCheck.get(keyQuery) instanceof List)) continue;
                            for (Object v2 : (List)checkValue) {
                                if (!v2.equals(v)) continue;
                                return true;
                            }
                        }
                        return false;
                    }
                    case "$comment": {
                        continue block79;
                    }
                    case "$expr": {
                        Expr e = (Expr)commandMap.get(commandKey);
                        Object ev = e.evaluate(toCheck);
                        return ev != null && (ev.equals(Boolean.TRUE) || ev.equals(1) || ev.equals("true"));
                    }
                    case "$not": {
                        return !QueryHelper.matchesQuery((Map)commandMap.get(commandKey), toCheck, collation);
                    }
                    case "$regex": 
                    case "$regularExpression": 
                    case "$text": {
                        Object r;
                        Map valtoCheck = null;
                        if (keyQuery.contains(".")) {
                            String[] b = keyQuery.split("\\.");
                            Map val = toCheck;
                            for (int i = 0; i < b.length; ++i) {
                                String el = b[i];
                                Object candidate = val.get(el);
                                if (candidate == null) {
                                    return false;
                                }
                                if (!(candidate instanceof Map) && i < b.length - 1) {
                                    return false;
                                }
                                if (i < b.length - 1) {
                                    val = (Map)candidate;
                                }
                                if (i != b.length - 1) continue;
                                valtoCheck = candidate;
                            }
                        } else {
                            valtoCheck = checkValue;
                        }
                        int opts = 0;
                        if (commandMap.containsKey("$options")) {
                            String opt = commandMap.get("$options").toString().toLowerCase();
                            if (opt.contains("i")) {
                                opts |= 2;
                            }
                            if (opt.contains("m")) {
                                opts |= 8;
                            }
                            if (opt.contains("s")) {
                                opts |= 0x20;
                            }
                            if (opt.contains("x")) {
                                log.warn("There is no proper equivalent for the 'x' option in mongodb!");
                            }
                            opts |= 0x20;
                            opts |= 8;
                        }
                        if (valtoCheck == null) {
                            return false;
                        }
                        if (commandKey.equals("$text")) {
                            String srch = commandMap.get("$text").toString().toLowerCase();
                            String[] tokens = null;
                            if (srch.contains("\"")) {
                                ArrayList<String> tks = new ArrayList<String>();
                                String[] p = Pattern.compile("\"([^\"]*)\"");
                                String t = p.matcher(srch).group(1);
                                srch = srch.replaceAll("\"" + t + "\"", "");
                                tks.add(t);
                                tks.addAll(Arrays.asList(srch.split(" ")));
                            } else {
                                srch = srch.replaceAll("[^a-zA-Z0-9 ]", " ");
                                tokens = srch.split(" ");
                            }
                            String v = valtoCheck.toString().toLowerCase();
                            boolean found = true;
                            for (String s : tokens) {
                                if (s.isEmpty() || s.isBlank() || v.contains(s)) continue;
                                found = false;
                                break;
                            }
                            return found;
                        }
                        Object regex = null;
                        if (commandMap.get("$regex") != null) {
                            if (commandMap.get("$regex") instanceof Map) {
                                Object r2 = commandMap.get("$regex");
                                if (r2 instanceof Map) {
                                    regex = (String)((Map)r2).get("pattern");
                                }
                            } else {
                                regex = (String)commandMap.get("$regex");
                            }
                        }
                        if (regex == null && (r = commandMap.get("$regularExpression")) instanceof Map) {
                            regex = (String)((Map)r).get("pattern");
                        }
                        if (regex == null) {
                            return false;
                        }
                        if (!((String)regex).startsWith("^")) {
                            regex = ".*" + (String)regex;
                        }
                        if (!((String)regex).contains("$")) {
                            regex = (String)regex + ".*$";
                        }
                        Pattern p = Pattern.compile((String)regex, opts);
                        return p.matcher(valtoCheck.toString()).matches();
                    }
                    case "$type": {
                        MongoType type = null;
                        if (commandMap.get(commandKey) instanceof Integer) {
                            type = MongoType.findByValue((Integer)commandMap.get(commandKey));
                        } else if (commandMap.get(commandKey) instanceof String) {
                            type = MongoType.findByTxt((String)commandMap.get(commandKey));
                        } else {
                            log.error("Type specification needs to be either int or string - not " + commandMap.get(commandKey).getClass().getName());
                            return false;
                        }
                        List elements = new ArrayList();
                        if (checkValue instanceof List) {
                            elements = (List)checkValue;
                        } else {
                            elements.add(checkValue);
                        }
                        boolean fnd = false;
                        for (Object o : elements) {
                            if (o == null) {
                                fnd = type.equals((Object)MongoType.NULL);
                            } else if (o instanceof byte[]) {
                                fnd = type.equals((Object)MongoType.BINARY_DATA);
                            } else if (o instanceof List || o.getClass().isArray()) {
                                fnd = type.equals((Object)MongoType.ARRAY);
                            } else if (o instanceof Pattern) {
                                fnd = type.equals((Object)MongoType.REGEX);
                            } else if (o instanceof Map) {
                                fnd = type.equals((Object)MongoType.OBJECT);
                            } else if (o instanceof Double) {
                                fnd = type.equals((Object)MongoType.DOUBLE);
                            } else if (o instanceof Date) {
                                fnd = type.equals((Object)MongoType.DATE);
                            } else if (o instanceof MorphiumId || o instanceof ObjectId) {
                                fnd = type.equals((Object)MongoType.OBJECT_ID);
                            } else if (o instanceof BigDecimal) {
                                fnd = type.equals((Object)MongoType.DECIMAL);
                            } else if (o instanceof String) {
                                fnd = type.equals((Object)MongoType.STRING);
                            } else if (o instanceof Boolean) {
                                fnd = type.equals((Object)MongoType.BOOLEAN);
                            } else if (o instanceof Float) {
                                fnd = type.equals((Object)MongoType.DOUBLE);
                            } else if (o instanceof Long) {
                                fnd = type.equals((Object)MongoType.LONG);
                            } else if (o instanceof Integer) {
                                fnd = type.equals((Object)MongoType.INTEGER);
                            }
                            if (!fnd) continue;
                            break;
                        }
                        return fnd;
                    }
                    case "$jsonSchema": 
                    case "$geoIntersects": {
                        break;
                    }
                    case "$nearSphere": 
                    case "$near": {
                        if (!(checkValue instanceof List)) {
                            log.warn("No proper coordinates found");
                            return false;
                        }
                        if (commandMap.get(commandKey) instanceof Map) {
                            Map qmap = (Map)commandMap.get(commandKey);
                            Map geo = (Map)qmap.get("$geometry");
                            if (geo.containsKey("type")) {
                                if (!geo.get("type").equals("Point")) {
                                    log.warn("$near needs a point as parameter");
                                    return false;
                                }
                                List coord = (List)geo.get("coordinates");
                                if (coord == null || coord.size() != 2) {
                                    log.warn("Coordinates for point wrong!");
                                    return false;
                                }
                                double lat1 = (Double)coord.get(1);
                                double lon1 = (Double)coord.get(0);
                                double lat2 = (Double)((List)checkValue).get(1);
                                double lon2 = (Double)((List)checkValue).get(0);
                                lon1 = Math.toRadians(lon1);
                                lon2 = Math.toRadians(lon2);
                                lat1 = Math.toRadians(lat1);
                                lat2 = Math.toRadians(lat2);
                                double dlon = lon2 - lon1;
                                double dlat = lat2 - lat1;
                                double a = Math.pow(Math.sin(dlat / 2.0), 2.0) + Math.cos(lat1) * Math.cos(lat2) * Math.pow(Math.sin(dlon / 2.0), 2.0);
                                double c = 2.0 * Math.asin(Math.sqrt(a));
                                double r = 6371.0;
                                double distance = c * r;
                                if (qmap.containsKey("$minDistance") && distance < (Double)qmap.get("$minDistance")) {
                                    return false;
                                }
                                if (qmap.containsKey("$maxDistance") && distance > (Double)qmap.get("$maxDistance")) {
                                    return false;
                                }
                                if (!qmap.containsKey("$maxDistance") && !qmap.containsKey("$minDistance")) {
                                    log.warn("No distance given?");
                                    return true;
                                }
                                return true;
                            }
                            return false;
                        }
                        log.error("Could not parse near query");
                        return false;
                    }
                    case "$geoWithin": {
                        Double tmp;
                        if (!(checkValue instanceof List)) {
                            log.warn("No proper coordinates found");
                            return false;
                        }
                        if (!(commandMap.get(commandKey) instanceof Map)) {
                            log.warn("No proper geoWithin query for " + keyQuery);
                            return false;
                        }
                        Map geoQuery = (Map)commandMap.get(commandKey);
                        List coordToCheckWithin = (List)checkValue;
                        if (!geoQuery.containsKey("$box")) continue block79;
                        List coords = (List)geoQuery.get("$box");
                        if (coords.size() > 2) {
                            log.error("Box coordinates should be 2 Points!");
                        } else if (coords.size() < 2) {
                            log.error("No proper box coordinates");
                            return false;
                        }
                        Double upperLeftX = (Double)((List)coords.get(0)).get(0);
                        Double upperLeftY = (Double)((List)coords.get(0)).get(1);
                        Double lowerRightX = (Double)((List)coords.get(1)).get(0);
                        Double lowerRightY = (Double)((List)coords.get(1)).get(1);
                        if (lowerRightX < upperLeftX) {
                            tmp = upperLeftX;
                            upperLeftX = lowerRightX;
                            lowerRightX = tmp;
                        }
                        if (lowerRightY < upperLeftY) {
                            tmp = upperLeftY;
                            upperLeftY = lowerRightY;
                            lowerRightY = tmp;
                        }
                        if (coordToCheckWithin.size() == 2 && coordToCheckWithin.get(0) instanceof Double) {
                            Double x = (Double)coordToCheckWithin.get(0);
                            Double y = (Double)coordToCheckWithin.get(1);
                            if (x > lowerRightX || x < upperLeftX) {
                                return false;
                            }
                            return !(y > lowerRightY) && !(y < upperLeftY);
                        }
                        for (Object o : coordToCheckWithin) {
                            for (List coord : (List)o) {
                                Double x = (Double)coord.get(0);
                                Double y = (Double)coord.get(1);
                                if (x > lowerRightX || x < upperLeftX) {
                                    return false;
                                }
                                if (!(y > lowerRightY) && !(y < upperLeftY)) continue;
                                return false;
                            }
                        }
                        return true;
                    }
                    case "$all": {
                        if (checkValue == null) {
                            return false;
                        }
                        if (!(checkValue instanceof List)) {
                            log.warn("Trying $all on non-list value");
                            return false;
                        }
                        if (!(commandMap.get(commandKey) instanceof List)) {
                            log.warn("Syntax: $all: [ v1,v2,v3... ]");
                            return false;
                        }
                        List toCheckValList = (List)checkValue;
                        List queryValues = (List)commandMap.get(commandKey);
                        for (Object o : queryValues) {
                            if (toCheckValList.contains(o)) continue;
                            return false;
                        }
                        return true;
                    }
                    case "$size": {
                        if (checkValue == null) {
                            return commandMap.get(commandKey).equals(0);
                        }
                        if (!(checkValue instanceof List)) {
                            log.warn("Trying $size on non-list value");
                            return false;
                        }
                        return commandMap.get(commandKey).equals(((List)checkValue).size());
                    }
                    case "$elemMatch": {
                        if (checkValue == null) {
                            return false;
                        }
                        if (!(checkValue instanceof List)) {
                            log.warn("Trying $elemMatch on non-list value");
                            return false;
                        }
                        if (!(commandMap.get(commandKey) instanceof Map)) {
                            log.warn("Syntax: $elemMatch { field: QUERYMAP}");
                            return false;
                        }
                        List valList = (List)checkValue;
                        Map queryMap = (Map)commandMap.get(commandKey);
                        for (Object o : valList) {
                            if (!(o instanceof Map)) {
                                o = Doc.of("value", o);
                            }
                            if (!QueryHelper.matchesQuery(queryMap, (Map)o, null) && !QueryHelper.matchesQuery(Doc.of("value", queryMap), (Map)o, null)) continue;
                            return true;
                        }
                        return false;
                    }
                    case "$bitsAnySet": 
                    case "$bitsAllClear": 
                    case "$bitsAllSet": 
                    case "$bitsAnyClear": {
                        if (checkValue == null) {
                            return false;
                        }
                        long value = 0L;
                        if (commandMap.get(commandKey) instanceof Integer) {
                            value = ((Integer)commandMap.get(commandKey)).longValue();
                        } else if (commandMap.get(commandKey) instanceof Long) {
                            value = (Long)commandMap.get(commandKey);
                        } else if (commandMap.get(commandKey) instanceof List) {
                            for (Object o : (List)commandMap.get(commandKey)) {
                                if (!(o instanceof Integer)) continue;
                                value |= 1L << (Integer)o;
                            }
                        } else if (commandMap.get(commandKey) instanceof byte[]) {
                            byte[] b = (byte[])commandMap.get(commandKey);
                            int bits = 0;
                            for (int idx = b.length - 1; idx > 0; ++idx) {
                                value |= (long)(b[idx] << bits);
                                bits += 8;
                            }
                        }
                        long chkVal = 0L;
                        if (checkValue instanceof Integer) {
                            chkVal = ((Integer)checkValue).longValue();
                        } else if (checkValue instanceof Long) {
                            chkVal = (Long)checkValue;
                        } else if (checkValue instanceof Byte) {
                            chkVal = ((Byte)checkValue).byteValue();
                        }
                        if (commandKey.equals("$bitsAnySet")) {
                            return (value & chkVal) != 0L;
                        }
                        if (commandKey.equals("$bitsAllSet")) {
                            return (value & chkVal) == value;
                        }
                        if (commandKey.equals("$bitsAnyClear")) {
                            return (value & chkVal) < value;
                        }
                        return (value & chkVal) == 0L;
                    }
                    case "$options": {
                        break;
                    }
                    default: {
                        if (toCheck.containsKey(commandKey)) {
                            return toCheck.get(commandKey).equals(commandMap.get(commandKey));
                        }
                        if (keyQuery.equals("value")) {
                            return false;
                        }
                        return commandMap.equals(toCheck);
                    }
                }
                continue;
            }
            if (keyQuery.contains(".")) {
                String[] path = keyQuery.split("\\.");
                Map current = toCheck;
                Object value = null;
                for (int i = 0; i < path.length; ++i) {
                    String k = path[i];
                    if (current instanceof Map && current.get(k) == null) {
                        return query.get(keyQuery) == null;
                    }
                    if (current instanceof Map && current.get(k) instanceof List) {
                        List cnd = (List)current.get(k);
                        Integer idx = Integer.valueOf(path[i + 1]);
                        if (idx >= cnd.size()) {
                            current = null;
                            if (query.get(keyQuery) != null) continue;
                            return true;
                        }
                        value = cnd.get(idx);
                        current = cnd.get(idx);
                        ++i;
                        continue;
                    }
                    if (Map.class.isAssignableFrom(current.get(k).getClass())) {
                        current = (Map)current.get(k);
                        continue;
                    }
                    value = current.get(k);
                }
                return value.equals(query.get(keyQuery));
            }
            if (toCheck.get(keyQuery) == null && query.get(keyQuery) == null) {
                return true;
            }
            if (toCheck.get(keyQuery) == null && query.get(keyQuery) != null) {
                return false;
            }
            assert (query.size() == 1);
            if (toCheck.get(keyQuery) instanceof MorphiumId || toCheck.get(keyQuery) instanceof ObjectId) {
                return toCheck.get(keyQuery).toString().equals(query.get(keyQuery).toString());
            }
            if (toCheck.get(keyQuery) instanceof List) {
                return ((List)toCheck.get(keyQuery)).contains(query.get(keyQuery));
            }
            return toCheck.get(keyQuery).equals(query.get(keyQuery));
        }
        return ret;
    }

    private static boolean runWhere(Map<String, Object> query, Map<String, Object> toCheck) {
        System.setProperty("polyglot.engine.WarnInterpreterOnly", "false");
        ScriptEngineManager mgr = new ScriptEngineManager();
        ScriptEngine engine = mgr.getEngineByExtension("js");
        if (engine != null) {
            engine.getContext().setAttribute("obj", toCheck, 100);
            for (String k : toCheck.keySet()) {
                engine.getContext().setAttribute(k, toCheck.get(k), 100);
            }
            try {
                Object result = engine.eval((String)query.get("$where"));
                return result.equals(Boolean.TRUE);
            }
            catch (ScriptException e) {
                throw new RuntimeException("Scripting error", e);
            }
        }
        log.error("Could not create javscript engine!");
        return false;
    }

    public static Collator getCollator(Map<String, Object> collation) {
        Locale locale = Locale.ROOT;
        if (collation == null) {
            return null;
        }
        if (collation.containsKey("locale") && !"simple".equals(collation.get("locale"))) {
            locale = Locale.forLanguageTag((String)collation.get("locale"));
        }
        Collator coll = Collator.getInstance(locale);
        if (collation.containsKey("caseFirst") && Collation.CaseFirst.UPPER.getMongoText().equals(collation.get("caseFirst"))) {
            try {
                coll = new RuleBasedCollator(((RuleBasedCollator)coll).getRules() + ",A<a,B<b,C<c,D<d,E<e,F<f,G<g,H<h,I<i,J<j,K<k,L<l,M<m,N<n,O<o,P<p,Q<q,R<r,S<s,T<t,U<u,V<v,W<w,X<x,Y<y,Z<z,\u00d6<\u00f6,\u00dc<\u00fc,\u00c4<\u00e4");
            }
            catch (ParseException e) {
                throw new RuntimeException(e);
            }
        }
        if (collation.containsKey("strength")) {
            coll.setStrength((Integer)collation.get("strength"));
        }
        return coll;
    }
}

