/*
 * Decompiled with CFR 0.152.
 */
package de.caluga.morphium.driver.commands;

import de.caluga.morphium.driver.MorphiumDriverException;
import de.caluga.morphium.driver.commands.MongoCommand;
import de.caluga.morphium.driver.commands.SingleResultCommand;
import de.caluga.morphium.driver.wire.MongoConnection;
import de.caluga.morphium.driver.wire.NetworkCallHelper;
import java.util.Map;
import org.slf4j.LoggerFactory;

public class DropDatabaseMongoCommand
extends MongoCommand<DropDatabaseMongoCommand>
implements SingleResultCommand {
    private Map<String, Object> writeConcern;

    public DropDatabaseMongoCommand(MongoConnection d) {
        super(d);
    }

    @Override
    public DropDatabaseMongoCommand setColl(String coll) {
        LoggerFactory.getLogger(DropDatabaseMongoCommand.class).warn("Cannot set collection on DB command");
        return this;
    }

    @Override
    public String getCommandName() {
        return "dropDatabase";
    }

    @Override
    public Map<String, Object> asMap() {
        Map<String, Object> m = super.asMap();
        m.put(this.getCommandName(), 1);
        return m;
    }

    @Override
    public Map<String, Object> execute() throws MorphiumDriverException {
        MongoConnection connection = this.getConnection();
        if (connection == null) {
            throw new IllegalArgumentException("you need to set the connection!");
        }
        return (Map)new NetworkCallHelper().doCall(() -> {
            this.setMetaData("server", connection.getConnectedTo());
            long start = System.currentTimeMillis();
            int msg = connection.sendCommand(this);
            Map<String, Object> crs = connection.readSingleAnswer(msg);
            long dur = System.currentTimeMillis() - start;
            this.setMetaData("duration", dur);
            return crs;
        }, connection.getDriver().getRetriesOnNetworkError(), connection.getDriver().getSleepBetweenErrorRetries());
    }
}

