/*
 * Decompiled with CFR 0.152.
 */
package de.caluga.morphium.driver.bson;

import de.caluga.morphium.Collation;
import de.caluga.morphium.driver.Doc;
import de.caluga.morphium.driver.MorphiumId;
import de.caluga.morphium.driver.bson.MongoBob;
import de.caluga.morphium.driver.bson.MongoJSScript;
import de.caluga.morphium.driver.bson.MongoMinKey;
import de.caluga.morphium.driver.bson.MongoTimestamp;
import de.caluga.morphium.driver.bson.UUIDRepresentation;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import java.util.UUID;
import java.util.regex.Pattern;
import org.bson.types.ObjectId;

public class BsonEncoder {
    private final ByteArrayOutputStream out;
    private UUIDRepresentation uuidRepresentation = UUIDRepresentation.STANDARD;

    public BsonEncoder() {
        this.out = new ByteArrayOutputStream();
    }

    public static byte[] encodeDocument(Map<String, Object> m) {
        return BsonEncoder.encodeDocument(m, UUIDRepresentation.STANDARD);
    }

    public static byte[] encodeDocument(Map<String, Object> m, UUIDRepresentation representation) {
        ByteArrayOutputStream o = new ByteArrayOutputStream();
        for (Map.Entry<String, Object> e : m.entrySet()) {
            BsonEncoder enc = new BsonEncoder();
            enc.setUuidRepresentation(representation);
            enc.encodeObject(e.getKey(), e.getValue());
            try {
                o.write(enc.getBytes());
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
        }
        ByteArrayOutputStream o2 = new ByteArrayOutputStream();
        for (int i = 3; i >= 0; --i) {
            o2.write((byte)(o.size() + 4 + 1 >> (7 - i) * 8 & 0xFF));
        }
        try {
            o2.write(o.toByteArray());
            o2.write(0);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return o2.toByteArray();
    }

    public UUIDRepresentation getUuidRepresentation() {
        return this.uuidRepresentation;
    }

    public BsonEncoder setUuidRepresentation(UUIDRepresentation uuidRepresentation) {
        this.uuidRepresentation = uuidRepresentation;
        return this;
    }

    private BsonEncoder string(String s) {
        try {
            byte[] b = s.getBytes("UTF-8");
            this.writeInt(b.length + 1);
            this.writeBytes(b);
            this.out.write(0);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return this;
    }

    private BsonEncoder cString(String s) {
        try {
            byte[] b = s.getBytes("UTF-8");
            this.writeBytes(b);
            this.out.write(0);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return this;
    }

    public byte[] getBytes() {
        return this.out.toByteArray();
    }

    public BsonEncoder encodeObject(String n, Object v) {
        block69: {
            block73: {
                block72: {
                    block71: {
                        block70: {
                            block68: {
                                if (v != null) break block68;
                                this.writeByte(10).cString(n);
                                break block69;
                            }
                            if (!(v instanceof Float) && !v.getClass().equals(Float.TYPE)) break block70;
                            this.writeByte(1).cString(n);
                            long lng = Double.doubleToLongBits(((Float)v).doubleValue());
                            this.writeLong(lng);
                            break block69;
                        }
                        if (!(v instanceof Double)) break block71;
                        this.writeByte(1).cString(n);
                        long lng = Double.doubleToLongBits((Double)v);
                        this.writeLong(lng);
                        break block69;
                    }
                    if (!(v instanceof String)) break block72;
                    this.writeByte(2);
                    this.cString(n);
                    this.string((String)v);
                    break block69;
                }
                if (!(v instanceof UUID)) break block73;
                this.writeByte(5);
                this.cString(n);
                this.writeInt(16);
                this.writeByte(this.uuidRepresentation.subtype);
                switch (this.uuidRepresentation) {
                    case UNSPECIFIED: {
                        throw new IllegalArgumentException("Cannot encode using UNSPECIFIED representation");
                    }
                    case STANDARD: 
                    case PYTHON_LEGACY: {
                        this.writeLongBigEndian(((UUID)v).getMostSignificantBits());
                        this.writeLongBigEndian(((UUID)v).getLeastSignificantBits());
                        break block69;
                    }
                    case JAVA_LEGACY: {
                        this.writeLong(((UUID)v).getMostSignificantBits());
                        this.writeLong(((UUID)v).getLeastSignificantBits());
                        break block69;
                    }
                    case C_SHARP_LEGACY: {
                        for (int i : new int[]{3, 2, 1, 0, 5, 4, 7, 6}) {
                            this.writeByte((byte)(((UUID)v).getMostSignificantBits() >> (7 - i) * 8 & 0xFFL));
                        }
                        this.writeLongBigEndian(((UUID)v).getLeastSignificantBits());
                        break block69;
                    }
                    default: {
                        throw new IllegalArgumentException("Unknown UUID representation " + this.uuidRepresentation.name());
                    }
                }
            }
            if (v.getClass().isArray() && v.getClass().getComponentType().equals(Byte.TYPE)) {
                this.writeByte(5);
                this.cString(n);
                byte[] data = (byte[])v;
                if (data == null) {
                    data = new byte[]{};
                }
                this.writeInt(data.length);
                this.writeByte(0);
                this.writeBytes(data);
            } else if (Collection.class.isAssignableFrom(v.getClass())) {
                this.writeByte(4);
                this.cString(n);
                Doc doc = Doc.of();
                int cnt = 0;
                for (Object o : (Collection)v) {
                    doc.put("" + cnt++, o);
                }
                this.writeBytes(BsonEncoder.encodeDocument(doc));
            } else if (v.getClass().isArray()) {
                this.writeByte(4);
                this.cString(n);
                Doc doc = Doc.of();
                int arrayLength = Array.getLength(v);
                ArrayList lst = new ArrayList(arrayLength);
                for (int i = 0; i < arrayLength; ++i) {
                    doc.put("" + i, Array.get(v, i));
                }
                this.writeBytes(BsonEncoder.encodeDocument(doc));
            } else if (v instanceof Map || Map.class.isAssignableFrom(v.getClass())) {
                this.writeByte(3);
                this.cString(n);
                byte[] b = BsonEncoder.encodeDocument((Map)v);
                this.writeBytes(b);
            } else if (v instanceof MongoBob) {
                this.writeByte(5);
                this.cString(n);
                MongoBob b = (MongoBob)v;
                byte[] data = b.getData();
                if (data == null) {
                    data = new byte[]{};
                }
                this.writeInt(data.length);
                this.writeByte(0);
                this.writeBytes(data);
            } else if (ObjectId.class.isAssignableFrom(v.getClass())) {
                this.writeByte(7);
                this.cString(n);
                this.writeBytes(((ObjectId)v).toByteArray());
            } else if (MorphiumId.class.isAssignableFrom(v.getClass())) {
                this.writeByte(7);
                this.cString(n);
                this.writeBytes(((MorphiumId)v).getBytes());
            } else if (v instanceof Boolean || v.getClass().equals(Boolean.TYPE)) {
                boolean b = (Boolean)v;
                this.writeByte(8);
                this.cString(n);
                if (b) {
                    this.writeByte(1);
                } else {
                    this.writeByte(0);
                }
            } else if (Date.class.isAssignableFrom(v.getClass())) {
                this.writeByte(9);
                this.cString(n);
                this.writeLong(((Date)v).getTime());
            } else if (Calendar.class.isAssignableFrom(v.getClass())) {
                this.writeByte(9);
                this.cString(n);
                this.writeLong(((Calendar)v).getTimeInMillis());
            } else if (Pattern.class.isAssignableFrom(v.getClass())) {
                Pattern p = (Pattern)v;
                Object flags = "";
                int f = p.flags();
                if ((f & 8) != 0) {
                    flags = (String)flags + "m";
                } else if ((f & 2) != 0) {
                    flags = (String)flags + "i";
                } else if ((f & 0x20) != 0) {
                    flags = (String)flags + "s";
                }
                this.writeByte(11);
                this.cString(n);
                this.cString(p.pattern());
                this.cString((String)flags);
            } else if (v.getClass().isAssignableFrom(MongoJSScript.class)) {
                MongoJSScript s = (MongoJSScript)v;
                if (s.getContext() != null) {
                    this.writeByte(15);
                    this.cString(n);
                    int l = s.getJs().length() + 4;
                    byte[] b = BsonEncoder.encodeDocument(s.getContext());
                    this.writeByte(l += b.length);
                    this.string(s.getJs());
                    this.writeBytes(b);
                } else {
                    this.writeByte(13);
                    this.cString(n);
                    this.string(s.getJs());
                }
            } else if (v.getClass().isAssignableFrom(Byte.class)) {
                this.writeByte(16);
                this.cString(n);
                int val = ((Byte)v).intValue();
                this.writeInt(val);
            } else if (v.getClass().isAssignableFrom(Character.class)) {
                this.writeByte(16);
                this.cString(n);
                char val = ((Character)v).charValue();
                this.writeInt(val);
            } else if (v.getClass().isAssignableFrom(Short.class)) {
                this.writeByte(16);
                this.cString(n);
                int val = ((Short)v).intValue();
                this.writeInt(val);
            } else if (v.getClass().isAssignableFrom(Integer.class)) {
                this.writeByte(16);
                this.cString(n);
                int val = (Integer)v;
                this.writeInt(val);
            } else if (v.getClass().isAssignableFrom(Long.class)) {
                this.writeByte(18);
                this.cString(n);
                long val = (Long)v;
                this.writeLong(val);
            } else if (v.getClass().isAssignableFrom(MongoTimestamp.class)) {
                this.writeByte(17);
                this.cString(n);
                long val = ((MongoTimestamp)v).getValue();
                this.writeLong(val);
            } else if (v.getClass().isAssignableFrom(MongoMinKey.class)) {
                this.writeByte(255);
                this.cString(n);
            } else if (v instanceof Collation.CaseFirst) {
                this.writeByte(2);
                this.cString(n);
                this.string(((Collation.CaseFirst)((Object)v)).getMongoText());
            } else if (v instanceof Collation.MaxVariable) {
                this.writeByte(2);
                this.cString(n);
                this.string(((Collation.MaxVariable)((Object)v)).getMongoText());
            } else if (v instanceof Collation.Strength) {
                this.writeByte(16);
                this.cString(n);
                int val = ((Collation.Strength)((Object)v)).getMongoValue();
                this.writeInt(val);
            } else if (v instanceof Collation.Alternate) {
                this.writeByte(2);
                this.cString(n);
                this.string(((Collation.Alternate)((Object)v)).getMongoText());
            } else if (v.getClass().isEnum()) {
                this.writeByte(2);
                this.cString(n);
                this.string(v.toString());
            } else {
                throw new RuntimeException("Unhandled Data type: " + v.getClass().getName());
            }
        }
        return this;
    }

    private void writeBytes(byte[] data) {
        try {
            this.out.write(data);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void writeInt(int val) {
        for (int i = 3; i >= 0; --i) {
            this.writeByte((byte)(val >> (7 - i) * 8 & 0xFF));
        }
    }

    private void writeLong(long lng) {
        for (int i = 7; i >= 0; --i) {
            this.writeByte((byte)(lng >> (7 - i) * 8 & 0xFFL));
        }
    }

    private void writeLongBigEndian(long lng) {
        for (int i = 0; i <= 7; ++i) {
            this.writeByte((byte)(lng >> (7 - i) * 8 & 0xFFL));
        }
    }

    private BsonEncoder writeByte(int v) {
        this.out.write((byte)v);
        return this;
    }
}

